/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.base.Base;
import com.isomorphic.log.Logger;
import com.isomorphic.util.HttpUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.util.EntityUtils;

public class SimpleHttpResponse
extends Base {
    private static Logger log = new Logger(HttpUtil.class.getName());
    protected HttpClient httpClient;
    protected HttpResponse httpResponse;

    public SimpleHttpResponse(HttpClient httpClient, HttpResponse httpResponse) {
        this.httpClient = httpClient;
        this.httpResponse = httpResponse;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public int getStatusCode() {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    public boolean isSuccess() {
        int statusCode = this.getStatusCode();
        return statusCode >= 200 && statusCode < 300;
    }

    public boolean isRedirect() {
        int statusCode = this.getStatusCode();
        return statusCode >= 300 && statusCode < 400;
    }

    public Header[] getHeaders(String name) {
        return this.httpResponse.getHeaders(name);
    }

    public HeaderIterator headerIterator(String name) {
        return this.httpResponse.headerIterator(name);
    }

    public Header[] getAllHeaders() {
        return this.httpResponse.getAllHeaders();
    }

    public HeaderIterator headerIterator() {
        return this.httpResponse.headerIterator();
    }

    public InputStream getBody() throws IOException {
        return this.httpResponse.getEntity() != null ? this.httpResponse.getEntity().getContent() : null;
    }

    public String getBodyAsString() throws IOException, ParseException {
        return this.httpResponse.getEntity() != null ? EntityUtils.toString((HttpEntity)this.httpResponse.getEntity()) : null;
    }

    public String getBodyAsString(Charset charset) throws IOException, ParseException {
        return this.httpResponse.getEntity() != null ? EntityUtils.toString((HttpEntity)this.httpResponse.getEntity(), (Charset)charset) : null;
    }

    public long getContentLength() {
        return this.httpResponse.getEntity() != null ? this.httpResponse.getEntity().getContentLength() : -1L;
    }

    public String getContentType() {
        HttpEntity httpEntity = this.httpResponse.getEntity();
        if (httpEntity == null) {
            return null;
        }
        Header contentTypeHeader = httpEntity.getContentType();
        if (contentTypeHeader == null) {
            return null;
        }
        return contentTypeHeader.getValue();
    }
}

