/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.profiler;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.tools.profiler.PerformanceProfiler;

public class Profile
implements Serializable,
Cloneable {
    protected Class queryClass;
    protected Class domainClass;
    protected long numberOfInstancesEffected = 0L;
    protected Hashtable operationTimings = new Hashtable();
    protected long localTime = 0L;
    protected long profileTime = 0L;
    protected long totalTime = 0L;
    protected long shortestTime = -1L;
    protected long longestTime = 0L;

    public void addTiming(String name, long time) {
        this.getOperationTimings().put(name, time);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Class getDomainClass() {
        return this.domainClass;
    }

    public long getLocalTime() {
        return this.localTime;
    }

    public long getLongestTime() {
        return this.longestTime;
    }

    public long getNumberOfInstancesEffected() {
        return this.numberOfInstancesEffected;
    }

    public long getObjectsPerSecond() {
        if (this.getTotalTime() == 0L) {
            return 0L;
        }
        return this.getNumberOfInstancesEffected() * 1000L / this.getTotalTime();
    }

    public Hashtable getOperationTimings() {
        return this.operationTimings;
    }

    public long getProfileTime() {
        return this.profileTime;
    }

    public Class getQueryClass() {
        return this.queryClass;
    }

    public long getShortestTime() {
        return this.shortestTime;
    }

    public long getTimePerObject() {
        if (this.getNumberOfInstancesEffected() == 0L) {
            return 0L;
        }
        return this.getTotalTime() / this.getNumberOfInstancesEffected();
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public void setDomainClass(Class domainClass) {
        this.domainClass = domainClass;
    }

    public void setLocalTime(long localTime) {
        this.localTime = localTime;
    }

    public void setLongestTime(long longestTime) {
        this.longestTime = longestTime;
    }

    public void setNumberOfInstancesEffected(long numberOfInstancesEffected) {
        this.numberOfInstancesEffected = numberOfInstancesEffected;
    }

    public void setOperationTimings(Hashtable operationTimings) {
        this.operationTimings = operationTimings;
    }

    public void setProfileTime(long profileTime) {
        this.profileTime = profileTime;
    }

    public void setQueryClass(Class queryClass) {
        this.queryClass = queryClass;
    }

    public void setShortestTime(long shortestTime) {
        this.shortestTime = shortestTime;
    }

    public void setTotalTime(long totalTime) {
        this.totalTime = totalTime;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        this.write(writer, new PerformanceProfiler());
        return writer.toString();
    }

    public void write(Writer writer, PerformanceProfiler profiler) {
        String cr = Helper.cr();
        try {
            writer.write(String.valueOf(ToStringLocalization.buildMessage("profile", null)) + "(");
            if (this.getQueryClass() != null) {
                writer.write(String.valueOf(Helper.getShortClassName(this.getQueryClass())) + "," + cr);
            } else {
                writer.write(cr);
            }
            if (this.getDomainClass() != null) {
                profiler.writeNestingTabs(writer);
                writer.write("\t" + ToStringLocalization.buildMessage("class", null) + "=" + this.getDomainClass().getName() + "," + cr);
            }
            if (this.getNumberOfInstancesEffected() != 0L) {
                profiler.writeNestingTabs(writer);
                writer.write("\t" + ToStringLocalization.buildMessage("number_of_objects", null) + "=" + this.getNumberOfInstancesEffected() + "," + cr);
            }
            profiler.writeNestingTabs(writer);
            writer.write("\t" + ToStringLocalization.buildMessage("total_time", null) + "=" + this.getTotalTime() + "," + cr);
            profiler.writeNestingTabs(writer);
            writer.write("\t" + ToStringLocalization.buildMessage("local_time", null) + "=" + this.getLocalTime() + "," + cr);
            if (this.getProfileTime() != 0L) {
                profiler.writeNestingTabs(writer);
                writer.write("\t" + ToStringLocalization.buildMessage("profiling_time", null) + "=" + this.getProfileTime() + "," + cr);
            }
            Enumeration operationNames = this.getOperationTimings().keys();
            while (operationNames.hasMoreElements()) {
                String operationName = (String)operationNames.nextElement();
                long operationTime = (Long)this.getOperationTimings().get(operationName);
                if (operationTime == 0L) continue;
                profiler.writeNestingTabs(writer);
                writer.write("\t" + operationName + "=" + operationTime + "," + cr);
            }
            if (this.getTimePerObject() != 0L) {
                profiler.writeNestingTabs(writer);
                writer.write("\t" + ToStringLocalization.buildMessage("time_object", null) + "=" + this.getTimePerObject() + "," + cr);
            }
            if (this.getObjectsPerSecond() != 0L) {
                profiler.writeNestingTabs(writer);
                writer.write("\t" + ToStringLocalization.buildMessage("objects_second", null) + "=" + this.getObjectsPerSecond() + "," + cr);
            }
            if (this.getShortestTime() != -1L) {
                profiler.writeNestingTabs(writer);
                writer.write("\t" + ToStringLocalization.buildMessage("shortestTime", null) + "=" + this.getShortestTime() + "," + cr);
            }
            if (this.getLongestTime() != 0L) {
                profiler.writeNestingTabs(writer);
                writer.write("\t" + ToStringLocalization.buildMessage("longestTime", null) + "=" + this.getLongestTime() + "," + cr);
            }
            profiler.writeNestingTabs(writer);
            writer.write(")");
        }
        catch (IOException iOException) {}
    }
}

