/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.direct;

import com.lowagie.text.rtf.direct.RtfParser;
import java.io.IOException;
import java.io.Reader;

public class RtfTokeniser {
    private static final int TOKENISER_STATE_READY = 0;
    private static final int TOKENISER_STATE_SLASH = 1;
    private static final int TOKENISER_STATE_IN_CTRL_WORD = 2;
    private static final int TOKENISER_STATE_IN_TEXT = 4;
    private int state = 0;
    private int groupLevel = 0;
    private RtfParser rtfParser = null;

    public RtfTokeniser(RtfParser rtfParser, int n) {
        this.rtfParser = rtfParser;
        this.groupLevel = n;
    }

    public void tokenise(Reader reader) throws IOException {
        char[] cArray = new char[1];
        StringBuffer stringBuffer = new StringBuffer();
        this.state = 0;
        this.groupLevel = 0;
        while (reader.read(cArray) != -1) {
            if (this.state == 0) {
                if (cArray[0] == '{') {
                    this.rtfParser.handleOpenGroup(this.groupLevel);
                    ++this.groupLevel;
                    continue;
                }
                if (cArray[0] == '}') {
                    this.rtfParser.handleCloseGroup(this.groupLevel);
                    --this.groupLevel;
                    continue;
                }
                if (cArray[0] == '\\') {
                    this.state = 1;
                    stringBuffer = new StringBuffer();
                    continue;
                }
                this.state = 4;
                stringBuffer.append(cArray[0]);
                continue;
            }
            if ((this.state & 1) == 1) {
                if (cArray[0] == '{') {
                    this.state = 4;
                    stringBuffer.append("\\{");
                    continue;
                }
                if (cArray[0] == '}') {
                    this.state = 4;
                    stringBuffer.append("\\}");
                    continue;
                }
                if (cArray[0] == '\\') {
                    this.state = 4;
                    stringBuffer.append("\\\\");
                    continue;
                }
                if ((this.state & 4) == 4) {
                    this.rtfParser.handleText(stringBuffer.toString(), this.groupLevel);
                    stringBuffer = new StringBuffer();
                }
                if (cArray[0] == '|') {
                    this.state = 0;
                    this.rtfParser.handleCtrlCharacter("\\|", this.groupLevel);
                    continue;
                }
                if (cArray[0] == '~') {
                    this.state = 0;
                    this.rtfParser.handleCtrlCharacter("\\~", this.groupLevel);
                    continue;
                }
                if (cArray[0] == '-') {
                    this.state = 0;
                    this.rtfParser.handleCtrlCharacter("\\-", this.groupLevel);
                    continue;
                }
                if (cArray[0] == '_') {
                    this.state = 0;
                    this.rtfParser.handleCtrlCharacter("\\_", this.groupLevel);
                    continue;
                }
                if (cArray[0] == ':') {
                    this.state = 0;
                    this.rtfParser.handleCtrlCharacter("\\:", this.groupLevel);
                    continue;
                }
                if (cArray[0] == '*') {
                    this.state = 0;
                    this.rtfParser.handleCtrlCharacter("\\*", this.groupLevel);
                    continue;
                }
                this.state = 2;
                stringBuffer = new StringBuffer("\\");
                stringBuffer.append(cArray[0]);
                continue;
            }
            if (this.state == 2) {
                if (cArray[0] == '\n' || cArray[0] == '\r') {
                    cArray[0] = 32;
                }
                if (cArray[0] == '{') {
                    this.rtfParser.handleCtrlWord(stringBuffer.toString(), this.groupLevel);
                    this.rtfParser.handleOpenGroup(this.groupLevel);
                    ++this.groupLevel;
                    this.state = 0;
                    stringBuffer = new StringBuffer();
                    continue;
                }
                if (cArray[0] == '}') {
                    this.rtfParser.handleCtrlWord(stringBuffer.toString(), this.groupLevel);
                    this.rtfParser.handleCloseGroup(this.groupLevel);
                    --this.groupLevel;
                    this.state = 0;
                    stringBuffer = new StringBuffer();
                    continue;
                }
                if (cArray[0] == '\\') {
                    this.rtfParser.handleCtrlWord(stringBuffer.toString(), this.groupLevel);
                    this.state = 1;
                    stringBuffer = new StringBuffer();
                    continue;
                }
                if (cArray[0] == ' ') {
                    this.rtfParser.handleCtrlWord(stringBuffer.toString(), this.groupLevel);
                    this.rtfParser.handleText(" ", this.groupLevel);
                    this.state = 0;
                    stringBuffer = new StringBuffer();
                    continue;
                }
                if (cArray[0] == ';') {
                    this.rtfParser.handleCtrlWord(stringBuffer.toString(), this.groupLevel);
                    this.rtfParser.handleText(";", this.groupLevel);
                    this.state = 0;
                    stringBuffer = new StringBuffer();
                    continue;
                }
                stringBuffer.append(cArray[0]);
                continue;
            }
            if (this.state != 4) continue;
            if (cArray[0] == '{') {
                this.rtfParser.handleText(stringBuffer.toString(), this.groupLevel);
                this.rtfParser.handleOpenGroup(this.groupLevel);
                ++this.groupLevel;
                this.state = 0;
                stringBuffer = new StringBuffer();
                continue;
            }
            if (cArray[0] == '}') {
                this.rtfParser.handleText(stringBuffer.toString(), this.groupLevel);
                this.rtfParser.handleCloseGroup(this.groupLevel);
                --this.groupLevel;
                this.state = 0;
                stringBuffer = new StringBuffer();
                continue;
            }
            if (cArray[0] == '\\') {
                this.state = 5;
                continue;
            }
            stringBuffer.append(cArray[0]);
        }
        if ((this.state & 4) == 4 && !stringBuffer.toString().equals("")) {
            this.rtfParser.handleText(stringBuffer.toString(), this.groupLevel);
        }
    }
}

