/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.hibernate;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.hibernate.HBProviderInterface;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.xml.XML;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.MappingNotFoundException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.xml.sax.InputSource;

public class HB4Provider
implements HBProviderInterface {
    private static final String CLASS_NAME = HB4Provider.class.getName();
    private static final Logger log = new Logger(CLASS_NAME);
    public static final String CONFIG = "config";
    protected Configuration configuration;
    protected SessionFactory factory;

    public HB4Provider() {
        this(Config.getGlobal().getSubtree("hibernate").asProperties());
    }

    public HB4Provider(Properties config) {
        this(config.getProperty(CONFIG));
    }

    public HB4Provider(String configFileName) {
        if (configFileName == null) {
            throw new HibernateException("Configuration file is not specified.");
        }
        configFileName = ISCFile.canonicalizePath((String)configFileName);
        log.debug((Object)("Instantiating Hibernate config and session factory from file " + configFileName));
        try {
            ISCFile configFile = ISCFile.newInstance((String)configFileName);
            this.configuration = new Configuration().configure(XML.parseXML((InputSource)new InputSource(configFile.getInputStream())));
            this.buildFactory();
        }
        catch (Exception ex) {
            throw new HibernateException("Failed to initialize HB4 Provider", (Throwable)ex);
        }
    }

    @Override
    public synchronized SessionFactory get() {
        log.info((Object)"Getting factory");
        return this.factory;
    }

    @Override
    public synchronized Session getSession() throws HibernateException {
        log.info((Object)"Getting session");
        return this.factory.openSession();
    }

    @Override
    public void returnSession(Session session) {
        log.info((Object)"Returning session");
        if (session != null) {
            try {
                if (session.isOpen()) {
                    session.close();
                }
            }
            catch (HibernateException ex) {
                log.warn((Object)"Failed to close session.", (Throwable)ex);
            }
        }
    }

    @Override
    public Transaction getTransaction(Session session) throws HibernateException {
        log.info((Object)"Getting transaction");
        if (session != null) {
            Transaction tx = session.getTransaction();
            if (!tx.isActive()) {
                tx.begin();
            }
            return tx;
        }
        throw new HibernateException("Session manager not provided.");
    }

    @Override
    public void commitTransaction(Transaction tx) throws HibernateException {
        log.info((Object)"Committing transaction");
        if (tx != null && tx.isActive()) {
            tx.commit();
        }
    }

    @Override
    public void rollbackTransaction(Transaction tx) {
        log.info((Object)"Rilling back transaction");
        if (tx != null && tx.isActive()) {
            try {
                tx.rollback();
            }
            catch (Exception ex) {
                log.warn((Object)"Unexpected exception while rolling back transaction", (Throwable)ex);
            }
        }
    }

    @Override
    public synchronized Dialect getDialect() {
        log.info((Object)"Getting dialect");
        try {
            Method method = Reflection.findMethod((Object)this.factory, (String)"getDialect");
            return (Dialect)method.invoke((Object)this.factory, (Object[])null);
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to acquire Hibernate dialect. Using default.", (Throwable)ex);
            return Dialect.getDialect();
        }
    }

    @Override
    public synchronized Iterator<PersistentClass> getMappings() {
        log.info((Object)"Getting mappings");
        return this.configuration.getClassMappings();
    }

    @Override
    public synchronized PersistentClass getMapping(String entityName) {
        log.info((Object)("Getting mapping: " + entityName));
        return this.configuration.getClassMapping(entityName);
    }

    @Override
    public synchronized Collection getCollectionMapping(String role) {
        log.info((Object)("Getting collection mapping: " + role));
        return this.configuration.getCollectionMapping(role);
    }

    @Override
    public synchronized void addMapping(String mapping) {
        log.info((Object)("Adding mapping: " + mapping));
        try {
            this.configuration.addDocument(XML.parseXML((InputSource)new InputSource(new StringReader(mapping))));
        }
        catch (MappingException ex) {
            log.warn((Object)"Failed to add XML mapping to Hibernate configuration.", (Throwable)ex);
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to parse provided XML mapping string.", (Throwable)ex);
        }
        this.buildFactory();
    }

    @Override
    public synchronized void addMapping(Class mapping) {
        log.info((Object)("Adding mapping: " + mapping.getName()));
        try {
            try {
                this.configuration.addClass(mapping);
            }
            catch (MappingNotFoundException mnfe) {
                this.configuration.addAnnotatedClass(mapping);
            }
        }
        catch (MappingException ex) {
            log.warn((Object)("Failed to add \"" + mapping.getName() + "\" mapping to Hibernate configuration."), (Throwable)ex);
        }
        this.buildFactory();
    }

    @Override
    public synchronized SchemaUpdate getSchemaUpdate() {
        log.info((Object)"Getting schema update");
        return new SchemaUpdate(this.configuration);
    }

    @Override
    public synchronized SchemaExport getSchemaExport() {
        log.info((Object)"Getting schema export");
        return new SchemaExport(this.configuration);
    }

    private void buildFactory() {
        Dialect dialect;
        this.factory = this.configuration.buildSessionFactory();
        if (this.configuration.getProperties().get("hibernate.dialect") == null && (dialect = this.getDialect()) != null) {
            log.info((Object)("Hibernate dialect autodection did not propagate  to hibernate env properties - pushing it manually (dialect: " + dialect.toString() + ")"));
            this.configuration.getProperties().put("hibernate.dialect", dialect.toString());
        }
    }
}

