/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.test.tools;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.log.Logger;
import com.isomorphic.tools.BatchUpload;
import com.isomorphic.util.DataTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchUploadDMI {
    private static Logger log = new Logger(BatchUploadDMI.class);
    private List<Map> expectedErrorList = new ArrayList<Map>(){
        {
            HashMap pkError1 = new HashMap(){
                {
                    this.put("rowNum", 0);
                    this.put("errors", new HashMap(){
                        {
                            this.put("id", DataTools.makeListIfSingle((Object)"PK must be unique"));
                        }
                    });
                }
            };
            HashMap pkError2 = new HashMap(){
                {
                    this.put("rowNum", 1);
                    this.put("errors", new HashMap(){
                        {
                            this.put("id", DataTools.makeListIfSingle((Object)"PK must be unique"));
                        }
                    });
                }
            };
            HashMap cityError1 = new HashMap(){
                {
                    this.put("rowNum", 4);
                    this.put("errors", new HashMap(){
                        {
                            this.put("name", DataTools.makeListIfSingle((Object)"City in country must be unique"));
                        }
                    });
                }
            };
            HashMap cityError2 = new HashMap(){
                {
                    this.put("rowNum", 5);
                    this.put("errors", new HashMap(){
                        {
                            this.put("name", DataTools.makeListIfSingle((Object)"City in country must be unique"));
                        }
                    });
                }
            };
            this.add(pkError1);
            this.add(pkError2);
            this.add(cityError1);
            this.add(cityError2);
        }
    };

    public DSResponse uploadCSV(DSRequest dsRequest) {
        DSResponse dsResponse = new DSResponse();
        String error = null;
        try {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("dsName", "batchUploadCity");
            values.put("fileName", "/isomorphic/QA/BatchUploader/cities.csv");
            dsRequest.setValues(values);
            DSResponse uploadResponse = BatchUpload.internalBatchUpload(dsRequest, true);
            Map data = uploadResponse.getDataMap();
            if (data == null) {
                error = "BatchUpload did not return any data";
            } else {
                Object errorListObj = data.get("errors");
                if (errorListObj == null || !(errorListObj instanceof List)) {
                    error = "BatchUpload did not return any validation errors";
                } else {
                    List errorList = (List)errorListObj;
                    if (errorList.size() > 4) {
                        error = "BatchUpload returned too many validation errors";
                    } else {
                        for (Map expectedError : this.expectedErrorList) {
                            if (errorList.contains(expectedError)) continue;
                            error = "BatchUpload return some erros, but expected error for field '" + ((Map)expectedError.get("errors")).keySet().iterator().next() + "' at row " + expectedError.get("rowNum") + " is missing";
                            break;
                        }
                    }
                }
            }
            if (error != null) {
                dsResponse.setStatus(-1);
                dsResponse.setData((Object)error);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            dsResponse.setStatus(-1);
            dsResponse.setData((Object)e.getMessage());
        }
        return dsResponse;
    }
}

