package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * How should {@link com.smartgwt.client.util.AutoTest#waitForElement AutoTest.waitForElement()} determine  that the
 * application is ready to retrieve the element?  <P>  Note: In most cases <code>"system"</code> is the appropriate
 * setting. This will wait for standard  Smart GWT-initiated asychronous actions to complete, including timer-instantiated 
 * actions such as {@link com.smartgwt.client.widgets.Canvas#markForRedraw delayed redraws} or actions   configured through
 * the  Timer class, and oustanding   {@link com.smartgwt.client.rpc.RPCManager RPC Requests}. If the locator cannot be
 * resolved to a clickable  element after system quiescence, this usually implies that it will not ever resolve,  and
 * there's no need to wait for the timeout to complete and slow down your test suite.  <P>  The only time you'd want to use
 * <code>"element"</code>  would be if your application relies on some asynchronous event that isn't tracked by  the Smart
 * GWT system. Examples might include waiting for asynchronous actions instantiated  by a third-party tool on the page, or
 * waiting for a server notification to come in through  the {@link
 * com.smartgwt.client.types.ElementWaitStyle#getRealtimeMessaging RealtimeMessaging} system.
 */
public enum ElementWaitStyle implements ValueEnum {
    /**
     * use {@link com.smartgwt.client.util.AutoTest#waitForSystemDone AutoTest.waitForSystemDone()} to wait for actions to
     * complete, then return the result of {@link com.smartgwt.client.util.AutoTest#getElement AutoTest.getElement()}, even if
     * this method doesn't resolve to an element.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "system".
     */
    SYSTEM("system"),
    /**
     * wait until {@link com.smartgwt.client.util.AutoTest#getElement AutoTest.getElement()} resolves to an element, and the
     * element is {@link com.smartgwt.client.util.AutoTest#isElementClickable clickable}.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "element".
     */
    ELEMENT("element");
    private String value;

    ElementWaitStyle(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
