package com.smartgwt.sample.showcase.client.dataintegration.java.serversummaries;

import java.util.Date;

import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.data.fields.DataSourceDateField;
import com.smartgwt.client.data.fields.DataSourceFloatField;
import com.smartgwt.client.data.fields.DataSourceIntegerField;
import com.smartgwt.client.data.fields.DataSourceTextField;
import com.smartgwt.client.types.ListGridFieldType;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.grid.HeaderSpan;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.client.widgets.grid.ListGridRecord;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;

public class ClientOnlyEmulationSample extends ShowcasePanel {

    private static final String DESCRIPTION =
        "Client-only DataSources allow you to emulate the responses your server will "+
        "ultimately return, so that you can build your UI with a simulated server while "+
        "work proceeds in parallel on the complete server design." + 
        "<p>" + 
        "Client-only DataSources provide support for simulated joins (<code>includeFrom</code> attribute) "+
        "as well as aggregation (<code>summaryFunction</code>) and joins with aggregation (<code>includeSummaryFunction</code>), "+
        "with behavior that matches the SQL, JPA &amp; Hibernate connectors provided with Power Edition and above." + 
        "<p>" + 
        "This sample is same as <code>\"Aggregation &amp; Join\"</code>, except it is using client-only DataSource.";
    
    public static class Factory implements PanelFactory {
        private String id;

        public ShowcasePanel create() {
        	ClientOnlyEmulationSample panel = new ClientOnlyEmulationSample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    protected boolean isTopIntro() {
        return true;
    }

    public Canvas getViewPanel() {
    	DataSource clientOnlyOrderItemDS = ClientOnlyOrderItemDS.getInstance(); 
    	DataSource clientOnlyOrderDS = ClientOnlyOrderDS.getInstance(); 
    	final ListGrid orderList = new ListGrid();
    	orderList.setDataSource(clientOnlyOrderDS);
    	orderList.setWidth(720);
    	orderList.setHeight(300);
    	orderList.setShowFilterEditor(true);
    	orderList.setAlternateRecordStyles(true);
    	orderList.setAutoFetchData(true);
    	orderList.setCanEdit(false);
    	orderList.setCanRemoveRecords(false);
    	orderList.setWrapHeaderTitles(true);
    	orderList.setWrapCells(true);
    	orderList.setCellHeight(40);
    	orderList.setHeaderHeight(65);
    	
    	ListGridField trackingNumber = new ListGridField("trackingNumber");
    	trackingNumber.setType(ListGridFieldType.INTEGER);
    	trackingNumber.setWidth(90);
    	trackingNumber.setTitle("Number");
    	ListGridField orderDate = new ListGridField("orderDate");
    	orderDate.setType(ListGridFieldType.DATE);
    	orderDate.setWidth(100);
    	orderDate.setTitle("Date");    	
    	ListGridField customerName = new ListGridField("customerName");
    	customerName.setWidth(180);
    	customerName.setTitle("Customer");
    	ListGridField itemCount = new ListGridField("itemCount");
    	itemCount.setType(ListGridFieldType.INTEGER);
    	itemCount.setTitle("Count");
    	itemCount.setWidth(80);
    	ListGridField items = new ListGridField("items");
    	items.setWidth("*");
    	items.setTitle("Description");
    	
    	orderList.setFields(trackingNumber,orderDate,customerName,itemCount,items);    	
    	
    	orderList.setHeaderSpans(new HeaderSpan[] {
    			new HeaderSpan("Items", new String[] {"itemCount", "items"})
        });
    	
        return orderList;
    }

    private static class ClientOnlyOrderDS extends DataSource {  
    	  
        private static ClientOnlyOrderDS instance = null;  
          
        public static ClientOnlyOrderDS getInstance() {  
            if (instance == null) {  
                instance = new ClientOnlyOrderDS("clientOnlyOrderDS");  
            }  
            return instance;  
        }  
  
        public ClientOnlyOrderDS(String id) {  
            setID(id);  
              
            DataSourceTextField orderIDField = new DataSourceTextField("orderID", "Code");
            orderIDField.setHidden(true);
            orderIDField.setPrimaryKey(true);
            orderIDField.setForeignKey("clientOnlyOrderItemDS.orderID");
            DataSourceTextField customerNameField = new DataSourceTextField("customerName", "Customer Name");  
            DataSourceDateField orderDateField = new DataSourceDateField("orderDate", "Order Date");
            DataSourceIntegerField trackingNumberField = new DataSourceIntegerField("trackingNumber", "Tracking Number");
            DataSourceIntegerField itemCountField = new DataSourceIntegerField("itemCount", "Count");
            itemCountField.setAttribute("includeFrom", "clientOnlyOrderItemDS.pk");
            itemCountField.setAttribute("includeSummaryFunction", "count");
            DataSourceTextField itemsField = new DataSourceTextField("items");
            itemsField.setJoinString(", ");
            itemsField.setAttribute("includeFrom", "clientOnlyOrderItemDS.itemDescription");
            itemsField.setAttribute("includeSummaryFunction", "concat");
            
            setFields(orderIDField, customerNameField, orderDateField, trackingNumberField, itemCountField, itemsField);  
              
            setTestData(ClientOnlyOrderSampleData.getNewRecords());  
            setClientOnly(true);  
        }  
    }  
    
    private static class ClientOnlyOrderItemDS extends DataSource {  
  	  
        private static ClientOnlyOrderItemDS instance = null;  
          
        public static ClientOnlyOrderItemDS getInstance() {  
            if (instance == null) {  
                instance = new ClientOnlyOrderItemDS("clientOnlyOrderItemDS");  
            }  
            return instance;  
        }  
  
        public ClientOnlyOrderItemDS(String id) {  
            setID(id);  
              
            DataSourceIntegerField pkField = new DataSourceIntegerField("pk");
            pkField.setHidden(true);
            pkField.setPrimaryKey(true);
            DataSourceIntegerField orderIDField = new DataSourceIntegerField("orderID");
            orderIDField.setHidden(true);
            DataSourceTextField itemDescriptionField = new DataSourceTextField("itemDescription","Item");
            DataSourceIntegerField quantityField = new DataSourceIntegerField("quantity", "Quantity");
            DataSourceFloatField unitPriceField = new DataSourceFloatField("Unit Price");
            
            setFields(pkField, orderIDField, itemDescriptionField, quantityField, unitPriceField);  
              
            setTestData(ClientOnlyOrderItemSampleData.getNewRecords());  
            setClientOnly(true);  
        }  
    }  
    
    public static class ClientOnlyOrderSampleData {  
    	  
        private static ListGridRecord[] records;    
            
        public static ListGridRecord[] getRecords() {  
            if (records == null) {  
                records = getNewRecords();    
            }    
            return records;    
        }    
        
        public static ListGridRecord createRecord(int orderID, Date orderDate, int trackingNumber, String customerName) {  
            ListGridRecord record = new ListGridRecord();  
            record.setAttribute("orderID", orderID);  
            record.setAttribute("orderDate", orderDate);  
            record.setAttribute("trackingNumber", trackingNumber);  
            record.setAttribute("customerName", customerName);
            return record;  
        }  
      
        public static ListGridRecord[] getNewRecords() {  
            return new ListGridRecord[]{  
                    createRecord(1, new Date(2009,2,9), 9912315, "Isomorphic Software"),    
                    createRecord(2, new Date(2009,2,17), 4110884, "Acme Widgets"),
                    createRecord(3, new Date(2009,2,7), 3113234, "Smith, Jones and Partners"),
                    createRecord(4, new Date(2009,2,1), 5112901, "ABC Mining"),
                    createRecord(5, new Date(2009,2,3), 8121042, "Isomorphic Software"),
                    createRecord(6, new Date(2009,2,23), 2231092, "Acme Widgets"),
                    createRecord(7, new Date(2009,2,18), 7112080, "ABC Mining"),
                    createRecord(8, new Date(2009,2,14), 4033512, "Isomorphic Software"),
                    createRecord(9, new Date(2009,2,10), 9631143, "ABC Mining"),
                    createRecord(10, new Date(2009,2,22), 1022231, "Isomorphic Software"),
                    createRecord(11, new Date(2009,2,9), 9912315, "Isomorphic Software"),
                    createRecord(12, new Date(2009,2,17), 4110884, "Acme Widgets"),
                    createRecord(13, new Date(2009,2,7), 3113234, "Smith, Jones and Partners"),
                    createRecord(14, new Date(2009,2,1), 5112901, "ABC Mining"),
                    createRecord(15, new Date(2009,2,3), 8121042, "Isomorphic Software"),
                    createRecord(16, new Date(2009,2,23), 2231092, "Acme Widgets"),
                    createRecord(17, new Date(2009,2,18), 7112080, "ABC Mining"),
                    createRecord(18, new Date(2009,2,14), 4033512, "Isomorphic Software"),
                    createRecord(19, new Date(2009,2,10), 9631143, "ABC Mining"),
                    createRecord(20, new Date(2009,2,22), 1022231, "Isomorphic Software")
            };  
        }  
    }
    
    public static class ClientOnlyOrderItemSampleData {  
  	  
        private static ListGridRecord[] records;    
            
        public static ListGridRecord[] getRecords() {  
            if (records == null) {  
                records = getNewRecords();    
            }    
            return records;    
        }    
        
        public static ListGridRecord createRecord(float unitPrice, int quantity, int orderID, int pk, String itemDescription) {  
            ListGridRecord record = new ListGridRecord();  
            record.setAttribute("unitPrice", unitPrice);  
            record.setAttribute("quantity", quantity);  
            record.setAttribute("orderID", orderID);  
            record.setAttribute("pk", pk);
            record.setAttribute("itemDescription", itemDescription);
            return record;  
        }  
      
        public static ListGridRecord[] getNewRecords() {  
            return new ListGridRecord[]{  
                    createRecord(3.95f, 4, 1, 1, "Green widget"),    
                    createRecord(3.95f, 2, 2, 2, "Green widget"),
                    createRecord(12.95f, 3, 2, 3, "Orange component"),
                    createRecord(24.95f, 5, 3, 4, "Magenta widget"),
                    createRecord(12.24f, 2, 3, 5, "Orange component"),
                    createRecord(24.95f, 5, 3, 6, "Blue gadget"),
                    createRecord(8.22f, 2, 3, 7, "Yellow item"),
                    createRecord(3.48f, 5, 3, 8, "Green widget"),
                    createRecord(8.22f, 24, 4, 9, "Yellow item"),
                    createRecord(3.95f, 6, 6, 11, "Green widget"),
                    createRecord(12.95f, 1, 6, 12, "Orange component"),
                    createRecord(8.12f, 12, 7, 13, "Yellow item"),
                    createRecord(20.95f, 2, 8, 14, "Blue gadget"),
                    createRecord(3.95f, 16, 9, 15, "Green widget"),
                    createRecord(14.99f, 1, 9, 16, "Orange component"),
                    createRecord(8.12f, 6, 9, 17, "Yellow item"),
                    createRecord(21.95f, 3, 10, 18, "Blue gadget"),
                    createRecord(3.95f, 4, 11, 19, "Green widget"),
                    createRecord(3.95f, 2, 12, 20, "Green widget"),                    
                    createRecord(12.95f, 3, 12, 21, "Orange component"),
                    createRecord(24.95f, 5, 13, 22, "Magenta widget"),
                    createRecord(12.24f, 2, 13, 23, "Orange component"),
                    createRecord(24.95f, 5, 13, 24, "Blue gadget"),
                    createRecord(8.22f, 2, 13, 25, "Yellow item"),
                    createRecord(3.48f, 5, 13, 26, "Green widget"),
                    createRecord(8.22f, 24, 14, 27, "Yellow item"),
                    createRecord(24.95f, 1, 15, 28, "Blue gadget"),                    
                    createRecord(3.95f, 6, 16, 29, "Green widget"),
                    createRecord(12.95f, 1, 16, 30, "Orange component"),
                    createRecord(8.12f, 12, 17, 31, "Yellow item"),
                    createRecord(20.95f, 2, 18, 32, "Blue gadget"),
                    createRecord(3.95f, 16, 19, 33, "Green widget"),
                    createRecord(14.99f, 1, 19, 34, "Orange component"),
                    createRecord(8.12f, 6, 19, 35, "Yellow item"),
                    createRecord(21.95f, 3, 20, 36, "Blue gadget")
            };  
        }  
    }
    
    public String getIntro() {
        return DESCRIPTION;
    }

}
