/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.css;

import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.util.log.PrintWriterTreeLogger;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.gss.ClassNamesCollector;
import com.google.gwt.resources.rg.GssResourceGenerator;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTree;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssParser;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssParserException;
import com.google.gwt.thirdparty.common.css.compiler.passes.CollectConstantDefinitions;
import com.google.gwt.thirdparty.common.css.compiler.passes.CreateDefinitionNodes;
import com.google.gwt.thirdparty.common.css.compiler.passes.CreateForLoopNodes;
import com.google.gwt.thirdparty.common.css.compiler.passes.UnrollLoops;
import com.google.gwt.thirdparty.guava.common.base.CaseFormat;
import com.google.gwt.thirdparty.guava.common.base.Function;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.user.rebind.StringSourceWriter;
import com.google.gwt.util.tools.ArgHandler;
import com.google.gwt.util.tools.ArgHandlerFile;
import com.google.gwt.util.tools.ArgHandlerFlag;
import com.google.gwt.util.tools.ArgHandlerString;
import com.google.gwt.util.tools.ToolBase;
import java.io.File;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;

public class InterfaceGenerator
extends ToolBase {
    private static final Comparator<String> NAME_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    };
    private static final TreeLogger.Type LOG_LEVEL = TreeLogger.WARN;
    private String interfaceName;
    private File inputFile;
    private TreeLogger logger;
    private boolean standaloneFile;

    public static void main(String[] args) {
        new InterfaceGenerator().execImpl(args);
    }

    private InterfaceGenerator() {
        this.registerHandler((ArgHandler)new ArgHandlerAddPackageHeader());
        this.registerHandler((ArgHandler)new ArgHandlerString(){

            public String getPurpose() {
                return "The name of the generated CssResource subtype";
            }

            public String getTag() {
                return "-typeName";
            }

            public String[] getTagArgs() {
                return new String[]{"some.package.MyCssResource"};
            }

            public boolean isRequired() {
                return true;
            }

            public boolean setString(String str) {
                if (str.length() == 0) {
                    return false;
                }
                if (!Character.isJavaIdentifierStart(str.charAt(0))) {
                    return false;
                }
                int j = str.length();
                for (int i = 1; i < j; ++i) {
                    char c = str.charAt(i);
                    if (Character.isJavaIdentifierPart(c) || c == '.') continue;
                    return false;
                }
                InterfaceGenerator.this.interfaceName = str;
                if (InterfaceGenerator.this.logger.isLoggable(TreeLogger.DEBUG)) {
                    InterfaceGenerator.this.logger.log(TreeLogger.DEBUG, "interfaceName = " + InterfaceGenerator.this.interfaceName);
                }
                return true;
            }
        });
        this.registerHandler((ArgHandler)new ArgHandlerFile(){

            public String getPurpose() {
                return "The input CSS file to process";
            }

            public String getTag() {
                return "-css";
            }

            public boolean isRequired() {
                return true;
            }

            public void setFile(File file) {
                InterfaceGenerator.this.inputFile = file;
                if (InterfaceGenerator.this.logger.isLoggable(TreeLogger.DEBUG)) {
                    InterfaceGenerator.this.logger.log(TreeLogger.DEBUG, "inputFile = " + file.getAbsolutePath());
                }
            }
        });
    }

    protected String getDescription() {
        return "Create a CssResource interface based on a CSS file";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execImpl(String[] args) {
        PrintWriter logWriter = new PrintWriter(System.err);
        this.logger = new PrintWriterTreeLogger(logWriter);
        ((PrintWriterTreeLogger)this.logger).setMaxDetail(LOG_LEVEL);
        if (!this.processArgs(args)) {
            System.exit(-1);
        }
        boolean error = false;
        try {
            System.out.println(this.process());
        }
        catch (MalformedURLException e) {
            this.logger.log(TreeLogger.ERROR, "Unable to load CSS", (Throwable)e);
            error = true;
        }
        catch (UnableToCompleteException e) {
            this.logger.log(TreeLogger.ERROR, "Unable to process CSS", (Throwable)e);
            error = true;
        }
        finally {
            logWriter.flush();
        }
        System.exit(error ? -1 : 0);
    }

    private String methodName(String className) {
        StringBuilder sb = new StringBuilder();
        char c = className.charAt(0);
        boolean nextUpCase = false;
        if (Character.isJavaIdentifierStart(c)) {
            sb.append(Character.toLowerCase(c));
        }
        int j = className.length();
        for (int i = 1; i < j; ++i) {
            c = className.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                nextUpCase = true;
                continue;
            }
            if (nextUpCase) {
                nextUpCase = false;
                c = Character.toUpperCase(c);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String process() throws MalformedURLException, UnableToCompleteException {
        CssTree cssTree = this.createAst(this.inputFile.toURI().toURL(), this.logger);
        TreeSet<String> names = new TreeSet<String>(NAME_COMPARATOR);
        names.addAll(new ClassNamesCollector().getClassNames(cssTree));
        CollectConstantDefinitions collectConstantDefinitionsPass = new CollectConstantDefinitions(cssTree);
        collectConstantDefinitionsPass.runPass();
        Collection<String> renamedDefs = this.renameDefs(collectConstantDefinitionsPass.getConstantDefinitions().getConstantsNames());
        names.addAll(renamedDefs);
        HashSet<String> methodNames = new HashSet<String>();
        StringSourceWriter sw = new StringSourceWriter();
        int lastDot = this.interfaceName.lastIndexOf(46);
        if (this.standaloneFile) {
            sw.println("// DO NOT EDIT");
            sw.println("// Automatically generated by " + InterfaceGenerator.class.getName());
            sw.println("package " + this.interfaceName.substring(0, lastDot) + ";");
            sw.println("import " + CssResource.class.getCanonicalName() + ";");
            sw.println("import " + CssResource.ClassName.class.getCanonicalName() + ";");
        }
        sw.println("interface " + this.interfaceName.substring(lastDot + 1) + " extends CssResource {");
        sw.indent();
        for (String className : names) {
            String methodName = this.methodName(className);
            while (!methodNames.add(methodName)) {
                methodName = methodName + "_";
            }
            sw.println();
            if (!methodName.equals(className)) {
                sw.println("@ClassName(\"" + Generator.escape((String)className) + "\")");
            }
            sw.println("String " + methodName + "();");
        }
        sw.outdent();
        sw.println("}");
        return sw.toString();
    }

    private Collection<String> renameDefs(Iterable<String> constantsNames) {
        return Lists.newArrayList(Iterables.transform(constantsNames, new Function<String, String>(){

            @Override
            public String apply(String constantName) {
                String lowerCase = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, constantName);
                if (!constantName.equals(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, lowerCase))) {
                    return constantName;
                }
                return lowerCase;
            }
        }));
    }

    private CssTree createAst(URL sourceFileUrl, TreeLogger logger) throws UnableToCompleteException {
        CssTree cssTree;
        GssResourceGenerator.LoggerErrorManager errorManager = new GssResourceGenerator.LoggerErrorManager(logger);
        try {
            cssTree = new GssParser(GssResourceGenerator.readUrlContent(sourceFileUrl, logger)).parse();
        }
        catch (GssParserException e) {
            logger.log(TreeLogger.ERROR, "Unable to parse CSS", (Throwable)e);
            throw new UnableToCompleteException();
        }
        new CreateDefinitionNodes(cssTree.getMutatingVisitController(), (ErrorManager)errorManager).runPass();
        new CreateForLoopNodes(cssTree.getMutatingVisitController(), (ErrorManager)errorManager).runPass();
        new UnrollLoops(cssTree.getMutatingVisitController(), (ErrorManager)errorManager).runPass();
        return cssTree;
    }

    private class ArgHandlerAddPackageHeader
    extends ArgHandlerFlag {
        public ArgHandlerAddPackageHeader() {
            this.addTagValue("-standalone", true);
        }

        public String getPurposeSnippet() {
            return "Add package and import statements to generated interface so that they are still functional when they stand alone.";
        }

        public String getLabel() {
            return "addPackageHeader";
        }

        public boolean setFlag(boolean value) {
            InterfaceGenerator.this.standaloneFile = value;
            InterfaceGenerator.this.logger.log(TreeLogger.DEBUG, value ? "Not creating" : "Creating a standalone file");
            return true;
        }

        public boolean getDefaultValue() {
            return InterfaceGenerator.this.standaloneFile;
        }
    }
}

