/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import org.openqa.jetty.util.IO;
import org.openqa.jetty.util.Loader;
import org.openqa.jetty.util.Password;

public class KeyPairTool {
    private File keyStoreFile = new File(System.getProperty("user.home"), ".keystore");
    private String keyStoreType = KeyStore.getDefaultType();
    private Password keyStorePassword = null;
    private Password keyPassword = null;
    private String alias = "mykey";
    private File privateKeyFile = null;
    private File certFile = null;
    private String providerClassName = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    private static final String usageString = "Tool to insert a private key/certificate pair into a keystore.\nParameters:\n -key        FILENAME, location of private key [MANDATORY]\n -cert       FILENAME, location of certificate [MANDATORY]\n -storepass  PASSWORD, keystore password       [OPTIONAL - security RISK!]\n -keypass    PASSWORD, password for new entry  [=STOREPASS]\n -keystore   FILENAME, location of keystore,   [~/.keystore]\n -storetype  STRING,   name/type of keystore,  [" + KeyStore.getDefaultType() + "]\n" + " -alias      NAME,     alias used to store key [mykey]\n" + " -provider   NAME,     name of provider class [org.bouncycastle.jce.provider.BouncyCastleProvider]\n\n" + "The keystore and key passwords will be prompted for or can be\n" + "set with the following JVM system properties:\n" + "  jetty.ssl.password\n" + "  jetty.ssl.keypassword";

    public static void main(String[] args) {
        KeyPairTool tool = new KeyPairTool();
        tool.doit(args);
    }

    private void doit(String[] args) {
        try {
            this.loadParameters(args);
            this.importKeyPair();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            e.printStackTrace();
            System.exit(23);
        }
    }

    private void importKeyPair() throws IOException, GeneralSecurityException, Exception {
        PrivateKey privateKey = this.loadPrivateKey(this.privateKeyFile);
        Certificate[] certChain = this.loadCertChain(this.certFile);
        if (this.keyPassword == null) {
            this.keyPassword = this.keyStorePassword;
        }
        KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
        FileInputStream keyStoreStream = null;
        try {
            keyStoreStream = new FileInputStream(this.keyStoreFile);
            System.out.println("Will load " + this.keyStoreType + " keystore: " + this.keyStoreFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Creating keystore: " + this.keyStoreFile);
        }
        keyStore.load(keyStoreStream, this.keyStorePassword.toString().toCharArray());
        if (keyStoreStream != null) {
            ((InputStream)keyStoreStream).close();
            System.out.println("Keystore loaded OK...");
        }
        keyStore.setKeyEntry(this.alias, privateKey, this.keyPassword.toString().toCharArray(), certChain);
        FileOutputStream keyStoreOut = new FileOutputStream(this.keyStoreFile);
        keyStore.store(keyStoreOut, this.keyStorePassword.toString().toCharArray());
        keyStoreOut.close();
        System.out.println("Keys have been written to keystore");
    }

    private Certificate[] loadCertChain(File certFile) throws Exception {
        Certificate[] certificateArray;
        DataInputStream dis = null;
        try {
            FileInputStream fis = new FileInputStream(certFile);
            dis = new DataInputStream(fis);
            byte[] bytes = new byte[dis.available()];
            dis.readFully(bytes);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ArrayList<Certificate> chain = new ArrayList<Certificate>();
            while (bais.available() > 0) {
                Certificate cert = certificateFactory.generateCertificate(bais);
                chain.add(cert);
            }
            Certificate[] certChain = chain.toArray(new Certificate[chain.size()]);
            System.out.println("Loaded the cert chain. Depth = " + certChain.length);
            certificateArray = certChain;
        }
        catch (Throwable throwable) {
            IO.close(dis);
            throw throwable;
        }
        IO.close(dis);
        return certificateArray;
    }

    private PrivateKey loadPrivateKey(File privateKeyFile) throws Exception {
        byte[] keyBytes;
        System.out.println("Loading private key from " + privateKeyFile + ", using " + this.providerClassName + " as the private key loading provider");
        FileInputStream privateKeyInputStream = null;
        try {
            privateKeyInputStream = new FileInputStream(privateKeyFile);
            keyBytes = new byte[(int)privateKeyFile.length()];
            privateKeyInputStream.read(keyBytes);
        }
        catch (Throwable throwable) {
            IO.close(privateKeyInputStream);
            throw throwable;
        }
        IO.close(privateKeyInputStream);
        Class providerClass = Loader.loadClass(this.getClass(), this.providerClassName);
        Provider provider = (Provider)providerClass.newInstance();
        Security.insertProviderAt(provider, 1);
        try {
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
            System.out.println("Loaded " + privateKey.getAlgorithm() + " " + privateKey.getFormat() + " private key.");
            PrivateKey privateKey2 = privateKey;
            return privateKey2;
        }
        finally {
            Security.removeProvider(provider.getName());
        }
    }

    private static void usage() {
        System.out.println(usageString);
        System.exit(23);
    }

    private void loadParameters(String[] args) {
        int i = 0;
        while (i < args.length && args[i].startsWith("-")) {
            String parameterName = args[i];
            if (parameterName.equalsIgnoreCase("-key")) {
                this.privateKeyFile = new File(args[++i]);
            } else if (parameterName.equalsIgnoreCase("-cert")) {
                this.certFile = new File(args[++i]);
            } else if (parameterName.equalsIgnoreCase("-keystore")) {
                this.keyStoreFile = new File(args[++i]);
            } else if (parameterName.equalsIgnoreCase("-storetype")) {
                this.keyStoreType = args[++i];
            } else if (parameterName.equalsIgnoreCase("-alias")) {
                this.alias = args[++i];
            } else if (parameterName.equalsIgnoreCase("-provider")) {
                this.providerClassName = args[++i];
            } else {
                System.err.println("Illegal parameter: " + parameterName);
                KeyPairTool.usage();
            }
            ++i;
        }
        if (this.privateKeyFile == null || this.certFile == null) {
            KeyPairTool.usage();
        }
        this.keyStorePassword = Password.getPassword("jetty.ssl.password", null, null);
        this.keyPassword = Password.getPassword("jetty.ssl.keypassword", null, this.keyStorePassword.toString());
    }
}

