/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.store;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSFileSpec;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.store.ExpiringCache;
import com.isomorphic.store.ExpiringValue;
import com.isomorphic.store.ProcessedFileCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.keyvalue.MultiKey;

public class DataStructCache
extends Base {
    private static Logger log = new Logger(DataStructCache.class.getName());
    private static JSTranslater jsTrans = JSTranslater.instance();
    public static StructCache cache = new StructCache();
    public static ThreadLocal<int[]> disableDsPaths = new ThreadLocal<int[]>(){

        @Override
        protected int[] initialValue() {
            return new int[]{0};
        }
    };
    private static ExpiringCache<MultiKey, String> instanceFileCache = new ExpiringCache(Config.getGlobal().getLong((Object)"file.stalenessCheckInterval", 500L), 1024L);
    public static int instanceFileCacheHits = 0;
    public static int instanceFileCacheMisses = 0;
    public static int getInstanceFileCalls = 0;
    public static int getInstanceFileTime = 0;
    static Boolean logLoadLocations = null;

    public static Map getDataMap(String filename) throws Exception {
        return cache.getDataMap(filename);
    }

    public static List getSingleList(String filename) throws Exception {
        Map myMap = DataStructCache.getDataMap(filename);
        return DataStructCache.singleList(myMap, filename);
    }

    public static List singleList(Map myMap, String name) throws Exception {
        if (myMap.size() > 1) {
            log.warn("getSingleList: Found multiple js variables in file " + name + ", returning the first one");
        } else if (myMap.size() == 0) {
            throw new IOException("No js variable definitions found in file " + name);
        }
        return (List)myMap.get(myMap.keySet().iterator().next());
    }

    public static Object getJSVariableFromFile(String filename, String variableName) throws Exception {
        return DataStructCache.getDataMap(filename).get(variableName);
    }

    public static Map getSingleDataMap(String filename) throws Exception {
        Map myMap = DataStructCache.getDataMap(filename);
        if (myMap.size() > 1) {
            log.warn("getSingleDataMap: Found multiple js variables in file " + filename + ", returning the first one");
        } else if (myMap.size() == 0) {
            throw new IOException("No js variable definitions found in file " + filename);
        }
        return (Map)myMap.get(myMap.keySet().iterator().next());
    }

    public static void addCachedObjectWithNoConfigFile(String typeName, Object config) {
        cache.setDataMapForTypeName(typeName, config);
    }

    public static void removeCachedObjectWithNoConfigFile(String typeName) {
        cache.removeDataMapForTypeName(typeName);
    }

    public static Object getCachedObjectWithNoConfigFile(String typeName) {
        return cache.getDataMapForTypeName(typeName);
    }

    public static Object getInstance(String ID, String typeName, String suffix) throws Exception {
        String filename = DataStructCache.getInstanceFile(ID, typeName, suffix);
        if (filename == null) {
            return null;
        }
        return DataStructCache.loadInstance(filename, ID, suffix);
    }

    public static Object loadInstance(String filename, String ID, String suffix) throws Exception {
        return DataStructCache.loadInstance(filename, ID, suffix, null);
    }

    public static Object loadInstance(String filename, String ID, String suffix, Map flags) throws Exception {
        if (filename.endsWith(".js")) {
            return DataStructCache.getJSVariableFromFile(filename, ID + suffix);
        }
        return XML.loadCacheableDSRecords(ISCFile.newInstance(filename), flags);
    }

    public static void disableDsPaths() {
        int[] count = disableDsPaths.get();
        count[0] = count[0] + 1;
    }

    public static void enableDsPaths() {
        int[] count = disableDsPaths.get();
        count[0] = count[0] - 1;
    }

    public static String getInstanceFile(String ID, String typeName, String suffix) throws Exception {
        return DataStructCache.getInstanceFile(ID, typeName, suffix, null);
    }

    public static String getInstanceFile(String ID, String typeName, String suffix, DataTypeMap flags) throws Exception {
        String result;
        String forComponentXMLKey;
        String frameworkSchemaOnlyKey;
        MultiKey cacheKey;
        ExpiringValue<String> value;
        long start = System.currentTimeMillis();
        if (flags == null) {
            flags = DataSource.getLoadFlags();
        }
        if ((value = instanceFileCache.get(cacheKey = new MultiKey((Object)ID, (Object)typeName, (Object)(suffix = suffix.toLowerCase()), (Object)(frameworkSchemaOnlyKey = "frameworkSchemaOnly" + flags.getBoolean((Object)"frameworkSchemaOnly", Boolean.FALSE).toString()), (Object)(forComponentXMLKey = "forComponentXML" + flags.getBoolean((Object)"forComponentXML", Boolean.FALSE).toString())))) == null) {
            result = DataStructCache._getInstanceFile(ID, typeName, suffix, flags);
            if (result != null && flags.getBoolean((Object)"_resultIsCacheable", true)) {
                instanceFileCache.put(cacheKey, result);
                ++instanceFileCacheMisses;
            }
            flags.remove("_resultIsCacheable");
        } else {
            result = value.get();
            ++instanceFileCacheHits;
        }
        long end = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("getInstanceFile (" + (result != null ? "success" : "failure") + "): '" + ID + "' instance of " + typeName + ": " + (end - start) + "ms");
        }
        ++getInstanceFileCalls;
        getInstanceFileTime = (int)((long)getInstanceFileTime + (end - start));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String _getInstanceFile(String ID, String typeName, String suffix, DataTypeMap flags) throws Exception {
        boolean useDsPaths;
        String filePath;
        String filename = ID + "." + suffix;
        String instanceDir = null;
        if (config.getBoolean((Object)(typeName + ".enableExplicitLocations"), true)) {
            instanceDir = config.getPath(typeName + "." + ID + ".location");
        }
        String frameworkFilePath = null;
        if (instanceDir != null) {
            List simpleModeList;
            boolean allowExplicitLocation = true;
            if (config.getBoolean((Object)(typeName + ".restrictExplicitLocationsToSimpleModeList"), false) && (simpleModeList = config.getList(typeName + ".simpleModeList", null)) != null && !simpleModeList.contains(ID)) {
                allowExplicitLocation = false;
                log.debug("Explicit location for " + typeName + " " + ID + " suppressed by " + typeName + ".restrictExplicitLocationsToSimpleModeList: true");
            }
            if (allowExplicitLocation) {
                filePath = DataStructCache.XMLOrJSFile(instanceDir + '/' + filename);
                if (filePath != null) {
                    return filePath;
                }
                if (instanceDir != null) {
                    log.warning("File " + filename + " not found at explicitly specified location " + instanceDir + ", checking project-wide area");
                }
            }
        }
        boolean projectDataSourcesCanShadowFramework = config.getBoolean((Object)"datasources.projectDataSourcesCanShadowFramework", true);
        boolean frameworkSchemaOnly = flags.getBoolean((Object)"frameworkSchemaOnly", false);
        if (!projectDataSourcesCanShadowFramework || frameworkSchemaOnly) {
            frameworkFilePath = DataStructCache._getFrameworkInstanceFile(typeName, filename);
            if (frameworkFilePath != null) {
                return frameworkFilePath;
            }
            if (frameworkSchemaOnly) {
                return null;
            }
        }
        List projectPaths = config.getCommaSeparatedList("project." + typeName);
        boolean bl = useDsPaths = disableDsPaths.get()[0] == 0;
        if (projectPaths != null) {
            Iterator i = projectPaths.iterator();
            while (i.hasNext()) {
                instanceDir = ISCFile.canonicalizePath((String)i.next());
                boolean isDSPath = instanceDir.startsWith("ds://");
                if (!isDSPath) {
                    filePath = DataStructCache.XMLOrJSFile(instanceDir + '/' + filename);
                    if (filePath == null) continue;
                    if (!projectDataSourcesCanShadowFramework && frameworkFilePath != null) {
                        log.warn("Disallowing " + filePath + " from shadowing framework instance at :" + frameworkFilePath);
                        return frameworkFilePath;
                    }
                    return filePath;
                }
                if (!useDsPaths) continue;
                boolean allowFileSourceLookup = flags.getBoolean((Object)"allowFileSourceLookup", true);
                if (allowFileSourceLookup && flags.getBoolean((Object)"forComponentXML", false)) {
                    String sourceDSName = new DSFileSpec(instanceDir).getDataSourceName();
                    DataSource sourceDS = null;
                    try {
                        sourceDS = DataSourceManager.get(sourceDSName, null, DataTools.buildMap("allowFileSourceLookup", false));
                        allowFileSourceLookup = sourceDS != null && sourceDS.getConfig().getBoolean((Object)"hasComponentSchema", false);
                    }
                    catch (Throwable throwable) {
                        DataSourceManager.free(sourceDS);
                        throw throwable;
                    }
                    DataSourceManager.free(sourceDS);
                }
                if (!allowFileSourceLookup) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("allowed fileSource lookup for: " + ID + " with flags: " + flags.toString()), new Exception());
                }
                if ((filePath = DataStructCache.XMLOrJSFile(instanceDir + '/' + filename)) == null) continue;
                if (!projectDataSourcesCanShadowFramework && frameworkFilePath != null) {
                    log.warn("Disallowing " + filePath + " from shadowing framework instance at :" + frameworkFilePath);
                    return frameworkFilePath;
                }
                if (DataSource.isSandboxEligible(DataSource.parentDataSourceId(filePath))) {
                    log.debug((Object)"Not cacheable: ", filePath);
                    flags.put("_resultIsCacheable", Boolean.FALSE);
                }
                return filePath;
            }
        }
        filePath = projectDataSourcesCanShadowFramework ? DataStructCache._getFrameworkInstanceFile(typeName, filename) : null;
        return filePath;
    }

    protected static String _getFrameworkInstanceFile(String typeName, String filename) throws Exception {
        List frameworkPaths = config.getCommaSeparatedList("framework." + typeName);
        if (frameworkPaths != null) {
            Iterator i = frameworkPaths.iterator();
            while (i.hasNext()) {
                String instanceDir = ISCFile.canonicalizePath((String)i.next());
                String filePath = DataStructCache.XMLOrJSFile(instanceDir + '/' + filename);
                if (filePath == null) continue;
                return filePath;
            }
        }
        return null;
    }

    public static String getInstanceDir(String ID, String typeName, String fileSuffix) throws Exception {
        String instanceFilename = DataStructCache.getInstanceFile(ID, typeName, fileSuffix);
        if (instanceFilename == null) {
            return null;
        }
        if (instanceFilename.startsWith("ds://")) {
            String path = instanceFilename.substring("ds://".length());
            String parent = new File(path).getParent();
            return "ds://" + parent;
        }
        return new File(instanceFilename).getParent();
    }

    public static String XMLOrJSFile(String baseName) throws IOException {
        boolean allowJS = config.getBoolean((Object)"allowJSDataSource", false);
        if (baseName == null) {
            return null;
        }
        String xmlName = baseName + ".xml";
        String jsName = baseName + ".js";
        ISCFile iscFile = ISCFile.newInstance(xmlName);
        if (iscFile.exists()) {
            String path = iscFile.getCanonicalPath();
            if (logLoadLocations == null) {
                logLoadLocations = Config.getGlobal().getBoolean((Object)"datasource.logLoadLocations", false);
            }
            if (logLoadLocations.booleanValue()) {
                System.out.println("file exists at: " + xmlName + "\r\nwill load from: " + path);
            }
            return path;
        }
        if (allowJS && (iscFile = ISCFile.newInstance(jsName)).exists()) {
            return iscFile.getCanonicalPath();
        }
        return null;
    }

    public static class StructCache
    extends ProcessedFileCache {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object loadObjectFromFile(ISCFile file) throws Exception {
            long start = System.currentTimeMillis();
            InputStream inStream = null;
            Map result = null;
            try {
                inStream = file.getInputStream();
                result = (Map)jsTrans.fromJSMap(inStream);
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            long end = System.currentTimeMillis();
            Logger.timing.debug("Parsed JS file '" + file.getCanonicalPath() + "': " + (end - start) + "ms");
            return result;
        }

        public Map getDataMap(String filename) throws Exception {
            return (Map)this.getObjectFromFile(DataTools.makePathAbsolute(filename));
        }

        public Object getDataMapForTypeName(String typeName) {
            return this.cache.get(typeName);
        }

        public synchronized void setDataMapForTypeName(String typeName, Object dataMap) {
            this.cache.put(typeName, dataMap);
        }

        public synchronized void removeDataMapForTypeName(String typeName) {
            this.cache.remove(typeName);
        }
    }
}

