/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.servlet.URIRegexFilter;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NoCacheFilter
extends URIRegexFilter {
    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    @Override
    public void match(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        try {
            RequestContext context = RequestContext.instance(this.servletContext, (ServletRequest)request, (ServletResponse)response);
            context.setNoCacheHeaders();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Applied no-cache headers to: " + context.request.getRequestURI());
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error setting noCache headers for URI: " + ServletTools.getCurrentRequestURI(request)), e);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

