/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import org.w3c.tidy.AttVal;
import org.w3c.tidy.Attribute;
import org.w3c.tidy.AttributeTable;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Node;
import org.w3c.tidy.TagCheck;

public final class TagCheckImpl {
    public static final TagCheck HTML = new CheckHTML();
    public static final TagCheck SCRIPT = new CheckSCRIPT();
    public static final TagCheck TABLE = new CheckTABLE();
    public static final TagCheck CAPTION = new CheckCaption();
    public static final TagCheck IMG = new CheckIMG();
    public static final TagCheck AREA = new CheckAREA();
    public static final TagCheck ANCHOR = new CheckAnchor();
    public static final TagCheck MAP = new CheckMap();
    public static final TagCheck STYLE = new CheckSTYLE();
    public static final TagCheck TABLECELL = new CheckTableCell();
    public static final TagCheck LINK = new CheckLINK();
    public static final TagCheck HR = new CheckHR();
    public static final TagCheck FORM = new CheckForm();
    public static final TagCheck META = new CheckMeta();

    private TagCheckImpl() {
    }

    public static class CheckLINK
    implements TagCheck {
        public void check(Lexer lexer, Node node) {
            AttVal attVal;
            AttVal attVal2 = node.getAttrByName("rel");
            node.checkAttributes(lexer);
            if (attVal2 != null && attVal2.value != null && attVal2.value.equals("stylesheet") && (attVal = node.getAttrByName("type")) == null) {
                AttVal attVal3 = new AttVal(null, null, 34, "type", "");
                lexer.report.attrError(lexer, node, attVal3, (short)49);
                node.addAttribute("type", "text/css");
            }
        }
    }

    public static class CheckTableCell
    implements TagCheck {
        public void check(Lexer lexer, Node node) {
            node.checkAttributes(lexer);
            if (node.getAttrByName("width") != null || node.getAttrByName("height") != null) {
                lexer.constrainVersion(-5);
            }
        }
    }

    public static class CheckMeta
    implements TagCheck {
        public void check(Lexer lexer, Node node) {
            AttVal attVal = node.getAttrByName("content");
            node.checkAttributes(lexer);
            if (attVal == null) {
                AttVal attVal2 = new AttVal(null, null, 34, "content", "");
                lexer.report.attrError(lexer, node, attVal2, (short)49);
            }
        }
    }

    public static class CheckForm
    implements TagCheck {
        public void check(Lexer lexer, Node node) {
            AttVal attVal = node.getAttrByName("action");
            node.checkAttributes(lexer);
            if (attVal == null) {
                AttVal attVal2 = new AttVal(null, null, 34, "action", "");
                lexer.report.attrError(lexer, node, attVal2, (short)49);
            }
        }
    }

    public static class CheckSTYLE
    implements TagCheck {
        public void check(Lexer lexer, Node node) {
            AttVal attVal = node.getAttrByName("type");
            node.checkAttributes(lexer);
            if (attVal == null) {
                AttVal attVal2 = new AttVal(null, null, 34, "type", "");
                lexer.report.attrError(lexer, node, attVal2, (short)49);
                node.addAttribute("type", "text/css");
            }
        }
    }

    public static class CheckMap
    implements TagCheck {
        public void check(Lexer lexer, Node node) {
            node.checkAttributes(lexer);
            lexer.fixId(node);
        }
    }

    public static class CheckAnchor
    implements TagCheck {
        public void check(Lexer lexer, Node node) {
            node.checkAttributes(lexer);
            lexer.fixId(node);
        }
    }

    public static class CheckAREA
    implements TagCheck {
        public void check(Lexer lexer, Node node) {
            AttVal attVal;
            boolean bl = false;
            boolean bl2 = false;
            AttVal attVal2 = node.attributes;
            while (attVal2 != null) {
                Attribute attribute = attVal2.checkAttribute(lexer, node);
                if (attribute == AttributeTable.attrAlt) {
                    bl = true;
                } else if (attribute == AttributeTable.attrHref) {
                    bl2 = true;
                }
                attVal2 = attVal2.next;
            }
            if (!bl) {
                lexer.badAccess = (short)(lexer.badAccess | 2);
                attVal = new AttVal(null, null, 34, "alt", "");
                lexer.report.attrError(lexer, node, attVal, (short)49);
            }
            if (!bl2) {
                attVal = new AttVal(null, null, 34, "href", "");
                lexer.report.attrError(lexer, node, attVal, (short)49);
            }
        }
    }

    public static class CheckIMG
    implements TagCheck {
        public void check(Lexer lexer, Node node) {
            AttVal attVal;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            AttVal attVal2 = node.attributes;
            while (attVal2 != null) {
                Attribute attribute = attVal2.checkAttribute(lexer, node);
                if (attribute == AttributeTable.attrAlt) {
                    bl = true;
                } else if (attribute == AttributeTable.attrSrc) {
                    bl2 = true;
                } else if (attribute == AttributeTable.attrUsemap) {
                    bl3 = true;
                } else if (attribute == AttributeTable.attrIsmap) {
                    bl4 = true;
                } else if (attribute == AttributeTable.attrDatafld) {
                    bl5 = true;
                } else if (attribute == AttributeTable.attrWidth || attribute == AttributeTable.attrHeight) {
                    lexer.constrainVersion(-2);
                }
                attVal2 = attVal2.next;
            }
            if (!bl) {
                lexer.badAccess = (short)(lexer.badAccess | 1);
                attVal = new AttVal(null, null, 34, "alt", "");
                lexer.report.attrError(lexer, node, attVal, (short)49);
                if (lexer.configuration.altText != null) {
                    node.addAttribute("alt", lexer.configuration.altText);
                }
            }
            if (!bl2 && !bl5) {
                attVal = new AttVal(null, null, 34, "src", "");
                lexer.report.attrError(lexer, node, attVal, (short)49);
            }
            if (bl4 && !bl3) {
                attVal = new AttVal(null, null, 34, "ismap", "");
                lexer.report.attrError(lexer, node, attVal, (short)56);
            }
        }
    }

    public static class CheckHR
    implements TagCheck {
        public void check(Lexer lexer, Node node) {
            AttVal attVal = node.getAttrByName("src");
            node.checkAttributes(lexer);
            if (attVal != null) {
                lexer.report.attrError(lexer, node, attVal, (short)54);
            }
        }
    }

    public static class CheckCaption
    implements TagCheck {
        public void check(Lexer lexer, Node node) {
            String string = null;
            node.checkAttributes(lexer);
            AttVal attVal = node.attributes;
            while (attVal != null) {
                if ("align".equalsIgnoreCase(attVal.attribute)) {
                    string = attVal.value;
                    break;
                }
                attVal = attVal.next;
            }
            if (string != null) {
                if ("left".equalsIgnoreCase(string) || "right".equalsIgnoreCase(string)) {
                    lexer.constrainVersion(8);
                } else if ("top".equalsIgnoreCase(string) || "bottom".equalsIgnoreCase(string)) {
                    lexer.constrainVersion(-4);
                } else {
                    lexer.report.attrError(lexer, node, attVal, (short)51);
                }
            }
        }
    }

    public static class CheckTABLE
    implements TagCheck {
        public void check(Lexer lexer, Node node) {
            boolean bl = false;
            AttVal attVal = node.attributes;
            while (attVal != null) {
                Attribute attribute = attVal.checkAttribute(lexer, node);
                if (attribute == AttributeTable.attrSummary) {
                    bl = true;
                }
                attVal = attVal.next;
            }
            if (!bl && lexer.doctype != 1 && lexer.doctype != 2) {
                lexer.badAccess = (short)(lexer.badAccess | 4);
            }
            if (lexer.configuration.xmlOut && (attVal = node.getAttrByName("border")) != null && attVal.value == null) {
                attVal.value = "1";
            }
            if ((attVal = node.getAttrByName("height")) != null) {
                lexer.report.attrError(lexer, node, attVal, (short)53);
                lexer.versions = (short)(lexer.versions & 0x1C0);
            }
        }
    }

    public static class CheckSCRIPT
    implements TagCheck {
        public void check(Lexer lexer, Node node) {
            node.checkAttributes(lexer);
            AttVal attVal = node.getAttrByName("language");
            AttVal attVal2 = node.getAttrByName("type");
            if (attVal2 == null) {
                AttVal attVal3 = new AttVal(null, null, 34, "type", "");
                lexer.report.attrError(lexer, node, attVal3, (short)49);
                if (attVal != null) {
                    String string = attVal.value;
                    if ("javascript".equalsIgnoreCase(string) || "jscript".equalsIgnoreCase(string)) {
                        node.addAttribute("type", "text/javascript");
                    } else if ("vbscript".equalsIgnoreCase(string)) {
                        node.addAttribute("type", "text/vbscript");
                    }
                } else {
                    node.addAttribute("type", "text/javascript");
                }
            }
        }
    }

    public static class CheckHTML
    implements TagCheck {
        private static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";

        public void check(Lexer lexer, Node node) {
            AttVal attVal = node.getAttrByName("xmlns");
            if (attVal != null && XHTML_NAMESPACE.equals(attVal.value)) {
                lexer.isvoyager = true;
                if (!lexer.configuration.htmlOut) {
                    lexer.configuration.xHTML = true;
                }
                lexer.configuration.xmlOut = true;
                lexer.configuration.upperCaseTags = false;
                lexer.configuration.upperCaseAttrs = false;
            }
            AttVal attVal2 = node.attributes;
            while (attVal2 != null) {
                attVal2.checkAttribute(lexer, node);
                attVal2 = attVal2.next;
            }
        }
    }
}

