/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import org.w3c.tidy.AttVal;
import org.w3c.tidy.Clean;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Node;
import org.w3c.tidy.Parser;
import org.w3c.tidy.TagTable;
import org.w3c.tidy.TidyUtils;

public final class ParserImpl {
    public static final Parser HTML = new ParseHTML();
    public static final Parser HEAD = new ParseHead();
    public static final Parser TITLE = new ParseTitle();
    public static final Parser SCRIPT = new ParseScript();
    public static final Parser BODY = new ParseBody();
    public static final Parser FRAMESET = new ParseFrameSet();
    public static final Parser INLINE = new ParseInline();
    public static final Parser LIST = new ParseList();
    public static final Parser DEFLIST = new ParseDefList();
    public static final Parser PRE = new ParsePre();
    public static final Parser BLOCK = new ParseBlock();
    public static final Parser TABLETAG = new ParseTableTag();
    public static final Parser COLGROUP = new ParseColGroup();
    public static final Parser ROWGROUP = new ParseRowGroup();
    public static final Parser ROW = new ParseRow();
    public static final Parser NOFRAMES = new ParseNoFrames();
    public static final Parser SELECT = new ParseSelect();
    public static final Parser TEXT = new ParseText();
    public static final Parser EMPTY = new ParseEmpty();
    public static final Parser OPTGROUP = new ParseOptGroup();

    private ParserImpl() {
    }

    protected static void parseTag(Lexer lexer, Node node, short s) {
        if ((node.tag.model & 1) != 0) {
            lexer.waswhite = false;
        } else if ((node.tag.model & 0x10) == 0) {
            lexer.insertspace = false;
        }
        if (node.tag.getParser() == null) {
            return;
        }
        if (node.type == 7) {
            Node.trimEmptyElement(lexer, node);
            return;
        }
        node.tag.getParser().parse(lexer, node, s);
    }

    protected static void moveToHead(Lexer lexer, Node node, Node node2) {
        node2.removeNode();
        TagTable tagTable = lexer.configuration.tt;
        if (node2.type == 5 || node2.type == 7) {
            lexer.report.warning(lexer, node, node2, (short)11);
            while (node.tag != tagTable.tagHtml) {
                node = node.parent;
            }
            Node node3 = node.content;
            while (node3 != null) {
                if (node3.tag == tagTable.tagHead) {
                    node3.insertNodeAtEnd(node2);
                    break;
                }
                node3 = node3.next;
            }
            if (node2.tag.getParser() != null) {
                ParserImpl.parseTag(lexer, node2, (short)0);
            }
        } else {
            lexer.report.warning(lexer, node, node2, (short)8);
        }
    }

    static void moveNodeToBody(Lexer lexer, Node node) {
        node.removeNode();
        Node node2 = lexer.root.findBody(lexer.configuration.tt);
        node2.insertNodeAtEnd(node);
    }

    public static Node parseDocument(Lexer lexer) {
        Node node;
        Node node2;
        Node node3 = null;
        TagTable tagTable = lexer.configuration.tt;
        Node node4 = lexer.newNode();
        node4.type = 0;
        lexer.root = node4;
        while ((node2 = lexer.getToken((short)0)) != null) {
            if (Node.insertMisc(node4, node2)) continue;
            if (node2.type == 1) {
                if (node3 == null) {
                    node4.insertNodeAtEnd(node2);
                    node3 = node2;
                    continue;
                }
                lexer.report.warning(lexer, node4, node2, (short)8);
                continue;
            }
            if (node2.type == 6) {
                lexer.report.warning(lexer, node4, node2, (short)8);
                continue;
            }
            if (node2.type != 5 || node2.tag != tagTable.tagHtml) {
                lexer.ungetToken();
                node = lexer.inferredTag("html");
            } else {
                node = node2;
            }
            if (node4.findDocType() == null && !lexer.configuration.bodyOnly) {
                lexer.report.warning(lexer, null, null, (short)44);
            }
            node4.insertNodeAtEnd(node);
            HTML.parse(lexer, node, (short)0);
            break;
        }
        if (lexer.root.findHTML(lexer.configuration.tt) == null) {
            node = lexer.inferredTag("html");
            lexer.root.insertNodeAtEnd(node);
            HTML.parse(lexer, node, (short)0);
        }
        if (lexer.root.findTITLE(lexer.configuration.tt) == null) {
            Node node5 = lexer.root.findHEAD(lexer.configuration.tt);
            lexer.report.warning(lexer, node5, null, (short)17);
            node5.insertNodeAtEnd(lexer.inferredTag("title"));
        }
        return node4;
    }

    public static boolean XMLPreserveWhiteSpace(Node node, TagTable tagTable) {
        AttVal attVal = node.attributes;
        while (attVal != null) {
            if (attVal.attribute.equals("xml:space")) {
                return attVal.value.equals("preserve");
            }
            attVal = attVal.next;
        }
        if (node.element == null) {
            return false;
        }
        if ("pre".equalsIgnoreCase(node.element) || "script".equalsIgnoreCase(node.element) || "style".equalsIgnoreCase(node.element)) {
            return true;
        }
        if (tagTable != null && tagTable.findParser(node) == PRE) {
            return true;
        }
        return "xsl:text".equalsIgnoreCase(node.element);
    }

    public static void parseXMLElement(Lexer lexer, Node node, short s) {
        Node node2;
        if (ParserImpl.XMLPreserveWhiteSpace(node, lexer.configuration.tt)) {
            s = (short)2;
        }
        while ((node2 = lexer.getToken(s)) != null) {
            if (node2.type == 6 && node2.element.equals(node.element)) {
                node.closed = true;
                break;
            }
            if (node2.type == 6) {
                lexer.report.error(lexer, node, node2, (short)13);
                continue;
            }
            if (node2.type == 5) {
                ParserImpl.parseXMLElement(lexer, node2, s);
            }
            node.insertNodeAtEnd(node2);
        }
        if ((node2 = node.content) != null && node2.type == 4 && s != 2 && node2.textarray[node2.start] == 32) {
            ++node2.start;
            if (node2.start >= node2.end) {
                Node.discardElement(node2);
            }
        }
        if ((node2 = node.last) != null && node2.type == 4 && s != 2 && node2.textarray[node2.end - 1] == 32) {
            --node2.end;
            if (node2.start >= node2.end) {
                Node.discardElement(node2);
            }
        }
    }

    public static Node parseXMLDocument(Lexer lexer) {
        Node node;
        Node node2 = lexer.newNode();
        node2.type = 0;
        Node node3 = null;
        lexer.configuration.xmlTags = true;
        while ((node = lexer.getToken((short)0)) != null) {
            if (node.type == 6) {
                lexer.report.warning(lexer, null, node, (short)13);
                continue;
            }
            if (Node.insertMisc(node2, node)) continue;
            if (node.type == 1) {
                if (node3 == null) {
                    node2.insertNodeAtEnd(node);
                    node3 = node;
                    continue;
                }
                lexer.report.warning(lexer, node2, node, (short)8);
                continue;
            }
            if (node.type == 7) {
                node2.insertNodeAtEnd(node);
                continue;
            }
            if (node.type != 5) continue;
            node2.insertNodeAtEnd(node);
            ParserImpl.parseXMLElement(lexer, node, (short)0);
        }
        if (node3 != null && !lexer.checkDocTypeKeyWords(node3)) {
            lexer.report.warning(lexer, node3, null, (short)37);
        }
        if (lexer.configuration.xmlPi) {
            lexer.fixXmlDecl(node2);
        }
        return node2;
    }

    static void badForm(Lexer lexer) {
        lexer.badForm = 1;
        lexer.errors = (short)(lexer.errors + 1);
    }

    public static class ParseOptGroup
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer.configuration.tt;
            lexer.insert = -1;
            while ((node2 = lexer.getToken((short)0)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    Node.trimSpaces(lexer, node);
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.type == 5 && (node2.tag == tagTable.tagOption || node2.tag == tagTable.tagOptgroup)) {
                    if (node2.tag == tagTable.tagOptgroup) {
                        lexer.report.warning(lexer, node, node2, (short)19);
                    }
                    node.insertNodeAtEnd(node2);
                    ParserImpl.parseTag(lexer, node2, (short)1);
                    continue;
                }
                lexer.report.warning(lexer, node, node2, (short)8);
            }
        }
    }

    public static class ParseText
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer.configuration.tt;
            lexer.insert = -1;
            s = node.tag == tagTable.tagTextarea ? (short)2 : (short)1;
            while ((node2 = lexer.getToken(s)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    Node.trimSpaces(lexer, node);
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.type == 4) {
                    if (node.content == null && (s & 2) == 0) {
                        Node.trimSpaces(lexer, node);
                    }
                    if (node2.start >= node2.end) continue;
                    node.insertNodeAtEnd(node2);
                    continue;
                }
                if (node2.tag != null && (node2.tag.model & 0x10) != 0 && (node2.tag.model & 0x400) == 0) {
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                if ((node.tag.model & 0x8000) == 0) {
                    lexer.report.warning(lexer, node, node2, (short)7);
                }
                lexer.ungetToken();
                Node.trimSpaces(lexer, node);
                return;
            }
            if ((node.tag.model & 0x8000) == 0) {
                lexer.report.warning(lexer, node, node2, (short)6);
            }
        }
    }

    public static class ParseSelect
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer.configuration.tt;
            lexer.insert = -1;
            while ((node2 = lexer.getToken((short)0)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    Node.trimSpaces(lexer, node);
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.type == 5 && (node2.tag == tagTable.tagOption || node2.tag == tagTable.tagOptgroup || node2.tag == tagTable.tagScript)) {
                    node.insertNodeAtEnd(node2);
                    ParserImpl.parseTag(lexer, node2, (short)0);
                    continue;
                }
                lexer.report.warning(lexer, node, node2, (short)8);
            }
            lexer.report.warning(lexer, node, node2, (short)6);
        }
    }

    public static class ParseNoFrames
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer.configuration.tt;
            lexer.badAccess = (short)(lexer.badAccess | 0x20);
            s = 0;
            while ((node2 = lexer.getToken(s)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    Node.trimSpaces(lexer, node);
                    return;
                }
                if (node2.tag == tagTable.tagFrame || node2.tag == tagTable.tagFrameset) {
                    Node.trimSpaces(lexer, node);
                    if (node2.type == 6) {
                        lexer.report.warning(lexer, node, node2, (short)8);
                    } else {
                        lexer.report.warning(lexer, node, node2, (short)7);
                        lexer.ungetToken();
                    }
                    return;
                }
                if (node2.tag == tagTable.tagHtml) {
                    if (node2.type != 5 && node2.type != 7) continue;
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == tagTable.tagBody && node2.type == 5) {
                    boolean bl = lexer.seenEndBody;
                    node.insertNodeAtEnd(node2);
                    ParserImpl.parseTag(lexer, node2, (short)0);
                    if (!bl) continue;
                    Node.coerceNode(lexer, node2, tagTable.tagDiv);
                    ParserImpl.moveNodeToBody(lexer, node2);
                    continue;
                }
                if (node2.type == 4 || node2.tag != null && node2.type != 6) {
                    if (lexer.seenEndBody) {
                        Node node3 = lexer.root.findBody(tagTable);
                        if (node2.type == 4) {
                            lexer.ungetToken();
                            node2 = lexer.inferredTag("p");
                            lexer.report.warning(lexer, node, node2, (short)27);
                        }
                        node3.insertNodeAtEnd(node2);
                    } else {
                        lexer.ungetToken();
                        node2 = lexer.inferredTag("body");
                        if (lexer.configuration.xmlOut) {
                            lexer.report.warning(lexer, node, node2, (short)15);
                        }
                        node.insertNodeAtEnd(node2);
                    }
                    ParserImpl.parseTag(lexer, node2, (short)0);
                    continue;
                }
                lexer.report.warning(lexer, node, node2, (short)8);
            }
            lexer.report.warning(lexer, node, node2, (short)6);
        }
    }

    public static class ParseRow
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer.configuration.tt;
            if ((node.tag.model & 1) != 0) {
                return;
            }
            while ((node2 = lexer.getToken((short)0)) != null) {
                if (node2.tag == node.tag) {
                    if (node2.type == 6) {
                        node.closed = true;
                        Node.fixEmptyRow(lexer, node);
                        return;
                    }
                    lexer.ungetToken();
                    Node.fixEmptyRow(lexer, node);
                    return;
                }
                if (node2.type == 6) {
                    if ((node2.tag != null && (node2.tag.model & 0x82) != 0 || node2.tag == tagTable.tagTable) && node.isDescendantOf(node2.tag)) {
                        lexer.ungetToken();
                        return;
                    }
                    if (node2.tag == tagTable.tagForm || node2.tag != null && (node2.tag.model & 0x18) != 0) {
                        if (node2.tag == tagTable.tagForm) {
                            ParserImpl.badForm(lexer);
                        }
                        lexer.report.warning(lexer, node, node2, (short)8);
                        continue;
                    }
                    if (node2.tag == tagTable.tagTd || node2.tag == tagTable.tagTh) {
                        lexer.report.warning(lexer, node, node2, (short)8);
                        continue;
                    }
                    Node node3 = node.parent;
                    while (node3 != null) {
                        if (node2.tag == node3.tag) {
                            lexer.ungetToken();
                            Node.trimEmptyElement(lexer, node);
                            return;
                        }
                        node3 = node3.parent;
                    }
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == null && node2.type != 4) {
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                if (node2.tag == tagTable.tagTable) {
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                if (node2.tag != null && (node2.tag.model & 0x100) != 0) {
                    lexer.ungetToken();
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (node2.type == 6) {
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                if (node2.type != 6) {
                    if (node2.tag == tagTable.tagForm) {
                        lexer.ungetToken();
                        node2 = lexer.inferredTag("td");
                        lexer.report.warning(lexer, node, node2, (short)12);
                    } else {
                        if (node2.type == 4 || (node2.tag.model & 0x18) != 0) {
                            Node.moveBeforeTable(node, node2, tagTable);
                            lexer.report.warning(lexer, node, node2, (short)11);
                            lexer.exiled = true;
                            if (node2.type != 4) {
                                ParserImpl.parseTag(lexer, node2, (short)0);
                            }
                            lexer.exiled = false;
                            continue;
                        }
                        if ((node2.tag.model & 4) != 0) {
                            lexer.report.warning(lexer, node, node2, (short)11);
                            ParserImpl.moveToHead(lexer, node, node2);
                            continue;
                        }
                    }
                }
                if (node2.tag != tagTable.tagTd && node2.tag != tagTable.tagTh) {
                    lexer.report.warning(lexer, node, node2, (short)11);
                    continue;
                }
                node.insertNodeAtEnd(node2);
                boolean bl = lexer.excludeBlocks;
                lexer.excludeBlocks = false;
                ParserImpl.parseTag(lexer, node2, (short)0);
                lexer.excludeBlocks = bl;
                while (lexer.istack.size() > lexer.istackbase) {
                    lexer.popInline(null);
                }
            }
            Node.trimEmptyElement(lexer, node);
        }
    }

    public static class ParseRowGroup
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer.configuration.tt;
            if ((node.tag.model & 1) != 0) {
                return;
            }
            while ((node2 = lexer.getToken((short)0)) != null) {
                if (node2.tag == node.tag) {
                    if (node2.type == 6) {
                        node.closed = true;
                        Node.trimEmptyElement(lexer, node);
                        return;
                    }
                    lexer.ungetToken();
                    return;
                }
                if (node2.tag == tagTable.tagTable && node2.type == 6) {
                    lexer.ungetToken();
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == null && node2.type != 4) {
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                if (node2.type != 6) {
                    if (node2.tag == tagTable.tagTd || node2.tag == tagTable.tagTh) {
                        lexer.ungetToken();
                        node2 = lexer.inferredTag("tr");
                        lexer.report.warning(lexer, node, node2, (short)12);
                    } else {
                        if (node2.type == 4 || (node2.tag.model & 0x18) != 0) {
                            Node.moveBeforeTable(node, node2, tagTable);
                            lexer.report.warning(lexer, node, node2, (short)11);
                            lexer.exiled = true;
                            if (node2.type != 4) {
                                ParserImpl.parseTag(lexer, node2, (short)0);
                            }
                            lexer.exiled = false;
                            continue;
                        }
                        if ((node2.tag.model & 4) != 0) {
                            lexer.report.warning(lexer, node, node2, (short)11);
                            ParserImpl.moveToHead(lexer, node, node2);
                            continue;
                        }
                    }
                }
                if (node2.type == 6) {
                    if (node2.tag == tagTable.tagForm || node2.tag != null && (node2.tag.model & 0x18) != 0) {
                        if (node2.tag == tagTable.tagForm) {
                            ParserImpl.badForm(lexer);
                        }
                        lexer.report.warning(lexer, node, node2, (short)8);
                        continue;
                    }
                    if (node2.tag == tagTable.tagTr || node2.tag == tagTable.tagTd || node2.tag == tagTable.tagTh) {
                        lexer.report.warning(lexer, node, node2, (short)8);
                        continue;
                    }
                    Node node3 = node.parent;
                    while (node3 != null) {
                        if (node2.tag == node3.tag) {
                            lexer.ungetToken();
                            Node.trimEmptyElement(lexer, node);
                            return;
                        }
                        node3 = node3.parent;
                    }
                }
                if ((node2.tag.model & 0x100) != 0) {
                    if (node2.type != 6) {
                        lexer.ungetToken();
                    }
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (node2.type == 6) {
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                if (node2.tag != tagTable.tagTr) {
                    node2 = lexer.inferredTag("tr");
                    lexer.report.warning(lexer, node, node2, (short)12);
                    lexer.ungetToken();
                }
                node.insertNodeAtEnd(node2);
                ParserImpl.parseTag(lexer, node2, (short)0);
            }
            Node.trimEmptyElement(lexer, node);
        }
    }

    public static class ParseColGroup
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer.configuration.tt;
            if ((node.tag.model & 1) != 0) {
                return;
            }
            while ((node2 = lexer.getToken((short)0)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    return;
                }
                if (node2.type == 6) {
                    if (node2.tag == tagTable.tagForm) {
                        ParserImpl.badForm(lexer);
                        lexer.report.warning(lexer, node, node2, (short)8);
                        continue;
                    }
                    Node node3 = node.parent;
                    while (node3 != null) {
                        if (node2.tag == node3.tag) {
                            lexer.ungetToken();
                            return;
                        }
                        node3 = node3.parent;
                    }
                }
                if (node2.type == 4) {
                    lexer.ungetToken();
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == null) {
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                if (node2.tag != tagTable.tagCol) {
                    lexer.ungetToken();
                    return;
                }
                if (node2.type == 6) {
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                node.insertNodeAtEnd(node2);
                ParserImpl.parseTag(lexer, node2, (short)0);
            }
        }
    }

    public static class ParseTableTag
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer.configuration.tt;
            lexer.deferDup();
            int n = lexer.istackbase;
            lexer.istackbase = lexer.istack.size();
            while ((node2 = lexer.getToken((short)0)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    lexer.istackbase = n;
                    node.closed = true;
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == null && node2.type != 4) {
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                if (node2.type != 6) {
                    if (node2.tag == tagTable.tagTd || node2.tag == tagTable.tagTh || node2.tag == tagTable.tagTable) {
                        lexer.ungetToken();
                        node2 = lexer.inferredTag("tr");
                        lexer.report.warning(lexer, node, node2, (short)12);
                    } else {
                        if (node2.type == 4 || (node2.tag.model & 0x18) != 0) {
                            Node.insertNodeBeforeElement(node, node2);
                            lexer.report.warning(lexer, node, node2, (short)11);
                            lexer.exiled = true;
                            if (node2.type != 4) {
                                ParserImpl.parseTag(lexer, node2, (short)0);
                            }
                            lexer.exiled = false;
                            continue;
                        }
                        if ((node2.tag.model & 4) != 0) {
                            ParserImpl.moveToHead(lexer, node, node2);
                            continue;
                        }
                    }
                }
                if (node2.type == 6) {
                    if (node2.tag == tagTable.tagForm || node2.tag != null && (node2.tag.model & 0x18) != 0) {
                        ParserImpl.badForm(lexer);
                        lexer.report.warning(lexer, node, node2, (short)8);
                        continue;
                    }
                    if (node2.tag != null && (node2.tag.model & 0x280) != 0 || node2.tag != null && (node2.tag.model & 0x18) != 0) {
                        lexer.report.warning(lexer, node, node2, (short)8);
                        continue;
                    }
                    Node node3 = node.parent;
                    while (node3 != null) {
                        if (node2.tag == node3.tag) {
                            lexer.report.warning(lexer, node, node2, (short)7);
                            lexer.ungetToken();
                            lexer.istackbase = n;
                            Node.trimEmptyElement(lexer, node);
                            return;
                        }
                        node3 = node3.parent;
                    }
                }
                if ((node2.tag.model & 0x80) == 0) {
                    lexer.ungetToken();
                    lexer.report.warning(lexer, node, node2, (short)11);
                    lexer.istackbase = n;
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (node2.type == 5 || node2.type == 7) {
                    node.insertNodeAtEnd(node2);
                    ParserImpl.parseTag(lexer, node2, (short)0);
                    continue;
                }
                lexer.report.warning(lexer, node, node2, (short)8);
            }
            lexer.report.warning(lexer, node, node2, (short)6);
            Node.trimEmptyElement(lexer, node);
            lexer.istackbase = n;
        }
    }

    public static class ParseBlock
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            int n = 0;
            TagTable tagTable = lexer.configuration.tt;
            boolean bl = true;
            if ((node.tag.model & 1) != 0) {
                return;
            }
            if (node.tag == tagTable.tagForm && node.isDescendantOf(tagTable.tagForm)) {
                lexer.report.warning(lexer, node, null, (short)25);
            }
            if ((node.tag.model & 0x800) != 0) {
                n = lexer.istackbase;
                lexer.istackbase = lexer.istack.size();
            }
            if ((node.tag.model & 0x20000) == 0) {
                lexer.inlineDup(null);
            }
            s = 0;
            while ((node2 = lexer.getToken(s)) != null) {
                if (node2.type == 6 && node2.tag != null && (node2.tag == node.tag || node.was == node2.tag)) {
                    if ((node.tag.model & 0x800) != 0) {
                        while (lexer.istack.size() > lexer.istackbase) {
                            lexer.popInline(null);
                        }
                        lexer.istackbase = n;
                    }
                    node.closed = true;
                    Node.trimSpaces(lexer, node);
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (node2.tag == tagTable.tagHtml || node2.tag == tagTable.tagHead || node2.tag == tagTable.tagBody) {
                    if (node2.type != 5 && node2.type != 7) continue;
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                if (node2.type == 6) {
                    if (node2.tag == null) {
                        lexer.report.warning(lexer, node, node2, (short)8);
                        continue;
                    }
                    if (node2.tag == tagTable.tagBr) {
                        node2.type = (short)5;
                    } else if (node2.tag == tagTable.tagP) {
                        Node.coerceNode(lexer, node2, tagTable.tagBr);
                        node.insertNodeAtEnd(node2);
                        node2 = lexer.inferredTag("br");
                    } else {
                        Node node3 = node.parent;
                        while (node3 != null) {
                            if (node2.tag == node3.tag) {
                                if ((node.tag.model & 0x8000) == 0) {
                                    lexer.report.warning(lexer, node, node2, (short)7);
                                }
                                lexer.ungetToken();
                                if ((node.tag.model & 0x800) != 0) {
                                    while (lexer.istack.size() > lexer.istackbase) {
                                        lexer.popInline(null);
                                    }
                                    lexer.istackbase = n;
                                }
                                Node.trimSpaces(lexer, node);
                                Node.trimEmptyElement(lexer, node);
                                return;
                            }
                            node3 = node3.parent;
                        }
                        if (lexer.exiled && node2.tag.model != 0 && (node2.tag.model & 0x80) != 0) {
                            lexer.ungetToken();
                            Node.trimSpaces(lexer, node);
                            Node.trimEmptyElement(lexer, node);
                            return;
                        }
                    }
                }
                if (node2.type == 4) {
                    boolean bl2 = false;
                    if (node2.type == 4 && node2.end <= node2.start + 1 && lexer.lexbuf[node2.start] == 32) {
                        bl2 = true;
                    }
                    if (lexer.configuration.encloseBlockText && !bl2) {
                        lexer.ungetToken();
                        node2 = lexer.inferredTag("p");
                        node.insertNodeAtEnd(node2);
                        ParserImpl.parseTag(lexer, node2, (short)1);
                        continue;
                    }
                    if (bl) {
                        bl = false;
                        if ((node.tag.model & 0x20000) == 0 && lexer.inlineDup(node2) > 0) continue;
                    }
                    node.insertNodeAtEnd(node2);
                    s = 1;
                    if (node.tag != tagTable.tagBody && node.tag != tagTable.tagMap && node.tag != tagTable.tagBlockquote && node.tag != tagTable.tagForm && node.tag != tagTable.tagNoscript) continue;
                    lexer.constrainVersion(-5);
                    continue;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == tagTable.tagParam) {
                    if ((node.tag.model & 0x1000) != 0 && (node2.type == 5 || node2.type == 7)) {
                        node.insertNodeAtEnd(node2);
                        continue;
                    }
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                if (node2.tag == tagTable.tagArea) {
                    if (node.tag == tagTable.tagMap && (node2.type == 5 || node2.type == 7)) {
                        node.insertNodeAtEnd(node2);
                        continue;
                    }
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                if (node2.tag == null) {
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                if ((node2.tag.model & 0x10) == 0) {
                    if (node2.type != 5 && node2.type != 7) {
                        if (node2.tag == tagTable.tagForm) {
                            ParserImpl.badForm(lexer);
                        }
                        lexer.report.warning(lexer, node, node2, (short)8);
                        continue;
                    }
                    if (node.tag == tagTable.tagLi && (node2.tag == tagTable.tagFrame || node2.tag == tagTable.tagFrameset || node2.tag == tagTable.tagOptgroup || node2.tag == tagTable.tagOption)) {
                        lexer.report.warning(lexer, node, node2, (short)8);
                        continue;
                    }
                    if (node.tag == tagTable.tagTd || node.tag == tagTable.tagTh) {
                        if ((node2.tag.model & 4) != 0) {
                            ParserImpl.moveToHead(lexer, node, node2);
                            continue;
                        }
                        if ((node2.tag.model & 0x20) != 0) {
                            lexer.ungetToken();
                            node2 = lexer.inferredTag("ul");
                            node2.addClass("noindent");
                            lexer.excludeBlocks = true;
                        } else if ((node2.tag.model & 0x40) != 0) {
                            lexer.ungetToken();
                            node2 = lexer.inferredTag("dl");
                            lexer.excludeBlocks = true;
                        }
                        if ((node2.tag.model & 8) == 0) {
                            lexer.ungetToken();
                            Node.trimSpaces(lexer, node);
                            Node.trimEmptyElement(lexer, node);
                            return;
                        }
                    } else if ((node2.tag.model & 8) != 0) {
                        if (lexer.excludeBlocks) {
                            if ((node.tag.model & 0x8000) == 0) {
                                lexer.report.warning(lexer, node, node2, (short)7);
                            }
                            lexer.ungetToken();
                            if ((node.tag.model & 0x800) != 0) {
                                lexer.istackbase = n;
                            }
                            Node.trimSpaces(lexer, node);
                            Node.trimEmptyElement(lexer, node);
                            return;
                        }
                    } else {
                        if ((node2.tag.model & 4) != 0) {
                            ParserImpl.moveToHead(lexer, node, node2);
                            continue;
                        }
                        if (node.tag == tagTable.tagForm && node.parent.tag == tagTable.tagTd && node.parent.implicit) {
                            if (node2.tag == tagTable.tagTd) {
                                lexer.report.warning(lexer, node, node2, (short)8);
                                continue;
                            }
                            if (node2.tag == tagTable.tagTh) {
                                lexer.report.warning(lexer, node, node2, (short)8);
                                node2 = node.parent;
                                node2.element = "th";
                                node2.tag = tagTable.tagTh;
                                continue;
                            }
                        }
                        if ((node.tag.model & 0x8000) == 0 && !node.implicit) {
                            lexer.report.warning(lexer, node, node2, (short)7);
                        }
                        lexer.ungetToken();
                        if ((node2.tag.model & 0x20) != 0) {
                            if (node.parent != null && node.parent.tag != null && node.parent.tag.getParser() == LIST) {
                                Node.trimSpaces(lexer, node);
                                Node.trimEmptyElement(lexer, node);
                                return;
                            }
                            node2 = lexer.inferredTag("ul");
                            node2.addClass("noindent");
                        } else if ((node2.tag.model & 0x40) != 0) {
                            if (node.parent.tag == tagTable.tagDl) {
                                Node.trimSpaces(lexer, node);
                                Node.trimEmptyElement(lexer, node);
                                return;
                            }
                            node2 = lexer.inferredTag("dl");
                        } else if ((node2.tag.model & 0x80) != 0 || (node2.tag.model & 0x200) != 0) {
                            node2 = lexer.inferredTag("table");
                        } else {
                            if ((node.tag.model & 0x800) != 0) {
                                while (lexer.istack.size() > lexer.istackbase) {
                                    lexer.popInline(null);
                                }
                                lexer.istackbase = n;
                                Node.trimSpaces(lexer, node);
                                Node.trimEmptyElement(lexer, node);
                                return;
                            }
                            Node.trimSpaces(lexer, node);
                            Node.trimEmptyElement(lexer, node);
                            return;
                        }
                    }
                }
                if (node2.type == 5 || node2.type == 7) {
                    if (TidyUtils.toBoolean(node2.tag.model & 0x10)) {
                        if (bl && !node2.implicit) {
                            bl = false;
                            if (!TidyUtils.toBoolean(node.tag.model & 0x20000) && lexer.inlineDup(node2) > 0) continue;
                        }
                        s = 1;
                    } else {
                        bl = true;
                        s = 0;
                    }
                    if (node2.tag == tagTable.tagBr) {
                        Node.trimSpaces(lexer, node);
                    }
                    node.insertNodeAtEnd(node2);
                    if (node2.implicit) {
                        lexer.report.warning(lexer, node, node2, (short)15);
                    }
                    ParserImpl.parseTag(lexer, node2, (short)0);
                    continue;
                }
                if (node2.type == 6) {
                    lexer.popInline(node2);
                }
                lexer.report.warning(lexer, node, node2, (short)8);
            }
            if ((node.tag.model & 0x8000) == 0) {
                lexer.report.warning(lexer, node, node2, (short)6);
            }
            if ((node.tag.model & 0x800) != 0) {
                while (lexer.istack.size() > lexer.istackbase) {
                    lexer.popInline(null);
                }
                lexer.istackbase = n;
            }
            Node.trimSpaces(lexer, node);
            Node.trimEmptyElement(lexer, node);
        }
    }

    public static class ParsePre
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer.configuration.tt;
            if ((node.tag.model & 1) != 0) {
                return;
            }
            if ((node.tag.model & 0x80000) != 0) {
                Node.coerceNode(lexer, node, tagTable.tagPre);
            }
            lexer.inlineDup(null);
            while ((node2 = lexer.getToken((short)2)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    Node.trimSpaces(lexer, node);
                    node.closed = true;
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (node2.tag == tagTable.tagHtml) {
                    if (node2.type != 5 && node2.type != 7) continue;
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                if (node2.type == 4) {
                    if (node.content == null) {
                        if (node2.textarray[node2.start] == 10) {
                            ++node2.start;
                        }
                        if (node2.start >= node2.end) continue;
                    }
                    node.insertNodeAtEnd(node2);
                    continue;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (!lexer.preContent(node2)) {
                    lexer.report.warning(lexer, node, node2, (short)39);
                    Node node3 = Node.escapeTag(lexer, node2);
                    node.insertNodeAtEnd(node3);
                    continue;
                }
                if (node2.tag == tagTable.tagP) {
                    if (node2.type == 5) {
                        lexer.report.warning(lexer, node, node2, (short)14);
                        Node.trimSpaces(lexer, node);
                        Node.coerceNode(lexer, node2, tagTable.tagBr);
                        node.insertNodeAtEnd(node2);
                        continue;
                    }
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                if (node2.type == 5 || node2.type == 7) {
                    if (node2.tag == tagTable.tagBr) {
                        Node.trimSpaces(lexer, node);
                    }
                    node.insertNodeAtEnd(node2);
                    ParserImpl.parseTag(lexer, node2, (short)2);
                    continue;
                }
                lexer.report.warning(lexer, node, node2, (short)8);
            }
            lexer.report.warning(lexer, node, node2, (short)6);
            Node.trimEmptyElement(lexer, node);
        }
    }

    public static class ParseDefList
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer.configuration.tt;
            if ((node.tag.model & 1) != 0) {
                return;
            }
            lexer.insert = -1;
            while ((node2 = lexer.getToken((short)0)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.type == 4) {
                    lexer.ungetToken();
                    node2 = lexer.inferredTag("dt");
                    lexer.report.warning(lexer, node, node2, (short)12);
                }
                if (node2.tag == null) {
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                if (node2.type == 6) {
                    if (node2.tag == tagTable.tagForm) {
                        ParserImpl.badForm(lexer);
                        lexer.report.warning(lexer, node, node2, (short)8);
                        continue;
                    }
                    Node node3 = node.parent;
                    while (node3 != null) {
                        if (node2.tag == node3.tag) {
                            lexer.report.warning(lexer, node, node2, (short)7);
                            lexer.ungetToken();
                            Node.trimEmptyElement(lexer, node);
                            return;
                        }
                        node3 = node3.parent;
                    }
                }
                if (node2.tag == tagTable.tagCenter) {
                    if (node.content != null) {
                        node.insertNodeAfterElement(node2);
                    } else {
                        Node.insertNodeBeforeElement(node, node2);
                        Node.discardElement(node);
                    }
                    ParserImpl.parseTag(lexer, node2, s);
                    node = lexer.inferredTag("dl");
                    node2.insertNodeAfterElement(node);
                    continue;
                }
                if (node2.tag != tagTable.tagDt && node2.tag != tagTable.tagDd) {
                    lexer.ungetToken();
                    if ((node2.tag.model & 0x18) == 0) {
                        lexer.report.warning(lexer, node, node2, (short)11);
                        Node.trimEmptyElement(lexer, node);
                        return;
                    }
                    if ((node2.tag.model & 0x10) == 0 && lexer.excludeBlocks) {
                        Node.trimEmptyElement(lexer, node);
                        return;
                    }
                    node2 = lexer.inferredTag("dd");
                    lexer.report.warning(lexer, node, node2, (short)12);
                }
                if (node2.type == 6) {
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                node.insertNodeAtEnd(node2);
                ParserImpl.parseTag(lexer, node2, (short)0);
            }
            lexer.report.warning(lexer, node, node2, (short)6);
            Node.trimEmptyElement(lexer, node);
        }
    }

    public static class ParseEmpty
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            if (lexer.isvoyager && (node2 = lexer.getToken(s)) != null && (node2.type != 6 || node2.tag != node.tag)) {
                lexer.report.warning(lexer, node, node2, (short)41);
                lexer.ungetToken();
            }
        }
    }

    public static class ParseList
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer.configuration.tt;
            if ((node.tag.model & 1) != 0) {
                return;
            }
            lexer.insert = -1;
            while ((node2 = lexer.getToken((short)0)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    if ((node.tag.model & 0x80000) != 0) {
                        Node.coerceNode(lexer, node, tagTable.tagUl);
                    }
                    node.closed = true;
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.type != 4 && node2.tag == null) {
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                if (node2.type == 6) {
                    if (node2.tag == tagTable.tagForm) {
                        ParserImpl.badForm(lexer);
                        lexer.report.warning(lexer, node, node2, (short)8);
                        continue;
                    }
                    if (node2.tag != null && (node2.tag.model & 0x10) != 0) {
                        lexer.report.warning(lexer, node, node2, (short)8);
                        lexer.popInline(node2);
                        continue;
                    }
                    Node node3 = node.parent;
                    while (node3 != null) {
                        if (node2.tag == node3.tag) {
                            lexer.report.warning(lexer, node, node2, (short)7);
                            lexer.ungetToken();
                            if ((node.tag.model & 0x80000) != 0) {
                                Node.coerceNode(lexer, node, tagTable.tagUl);
                            }
                            Node.trimEmptyElement(lexer, node);
                            return;
                        }
                        node3 = node3.parent;
                    }
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                if (node2.tag != tagTable.tagLi) {
                    lexer.ungetToken();
                    if (node2.tag != null && (node2.tag.model & 8) != 0 && lexer.excludeBlocks) {
                        lexer.report.warning(lexer, node, node2, (short)7);
                        Node.trimEmptyElement(lexer, node);
                        return;
                    }
                    node2 = lexer.inferredTag("li");
                    node2.addAttribute("style", "list-style: none");
                    lexer.report.warning(lexer, node, node2, (short)12);
                }
                node.insertNodeAtEnd(node2);
                ParserImpl.parseTag(lexer, node2, (short)0);
            }
            if ((node.tag.model & 0x80000) != 0) {
                Node.coerceNode(lexer, node, tagTable.tagUl);
            }
            lexer.report.warning(lexer, node, node2, (short)6);
            Node.trimEmptyElement(lexer, node);
        }
    }

    public static class ParseInline
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer.configuration.tt;
            if (TidyUtils.toBoolean(node.tag.model & 1)) {
                return;
            }
            if (TidyUtils.toBoolean(node.tag.model & 8) || node.tag == tagTable.tagDt) {
                lexer.inlineDup(null);
            } else if (TidyUtils.toBoolean(node.tag.model & 0x10) && node.tag != tagTable.tagA && node.tag != tagTable.tagSpan) {
                lexer.pushInline(node);
            }
            if (node.tag == tagTable.tagNobr) {
                lexer.badLayout = (short)(lexer.badLayout | 4);
            } else if (node.tag == tagTable.tagFont) {
                lexer.badLayout = (short)(lexer.badLayout | 8);
            }
            if (s != 2) {
                s = 1;
            }
            while ((node2 = lexer.getToken(s)) != null) {
                Node node3;
                if (node2.tag == node.tag && node2.type == 6) {
                    if (TidyUtils.toBoolean(node.tag.model & 0x10)) {
                        lexer.popInline(node2);
                    }
                    if (!TidyUtils.toBoolean(s & 2)) {
                        Node.trimSpaces(lexer, node);
                    }
                    if (node.tag == tagTable.tagFont && node.content != null && node.content == node.last) {
                        node3 = node.content;
                        if (node3.tag == tagTable.tagA) {
                            node3.parent = node.parent;
                            node3.next = node.next;
                            node3.prev = node.prev;
                            if (node3.prev != null) {
                                node3.prev.next = node3;
                            } else {
                                node3.parent.content = node3;
                            }
                            if (node3.next != null) {
                                node3.next.prev = node3;
                            } else {
                                node3.parent.last = node3;
                            }
                            node.next = null;
                            node.prev = null;
                            node.parent = node3;
                            node.content = node3.content;
                            node.last = node3.last;
                            node3.content = node;
                            node3.last = node;
                            node3 = node.content;
                            while (node3 != null) {
                                node3.parent = node;
                                node3 = node3.next;
                            }
                        }
                    }
                    node.closed = true;
                    Node.trimSpaces(lexer, node);
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (node2.type == 5 && node2.tag == node.tag && lexer.isPushed(node2) && !node2.implicit && !node.implicit && node2.tag != null && (node2.tag.model & 0x10) != 0 && node2.tag != tagTable.tagA && node2.tag != tagTable.tagFont && node2.tag != tagTable.tagBig && node2.tag != tagTable.tagSmall && node2.tag != tagTable.tagQ) {
                    if (node.content != null && node2.attributes == null) {
                        lexer.report.warning(lexer, node, node2, (short)24);
                        node2.type = (short)6;
                        lexer.ungetToken();
                        continue;
                    }
                    lexer.report.warning(lexer, node, node2, (short)9);
                } else if (lexer.isPushed(node2) && node2.type == 5 && node2.tag == tagTable.tagQ) {
                    lexer.report.warning(lexer, node, node2, (short)40);
                }
                if (node2.type == 4) {
                    if (node.content == null && !TidyUtils.toBoolean(s & 2)) {
                        Node.trimSpaces(lexer, node);
                    }
                    if (node2.start >= node2.end) continue;
                    node.insertNodeAtEnd(node2);
                    continue;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == tagTable.tagHtml) {
                    if (node2.type == 5 || node2.type == 7) {
                        lexer.report.warning(lexer, node, node2, (short)8);
                        continue;
                    }
                    lexer.ungetToken();
                    if ((s & 2) == 0) {
                        Node.trimSpaces(lexer, node);
                    }
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (node2.tag == tagTable.tagP && node2.type == 5 && ((s & 2) != 0 || node.tag == tagTable.tagDt || node.isDescendantOf(tagTable.tagDt))) {
                    node2.tag = tagTable.tagBr;
                    node2.element = "br";
                    Node.trimSpaces(lexer, node);
                    node.insertNodeAtEnd(node2);
                    continue;
                }
                if (node2.tag == null || node2.tag == tagTable.tagParam) {
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                if (node2.tag == tagTable.tagBr && node2.type == 6) {
                    node2.type = (short)5;
                }
                if (node2.type == 6) {
                    if (node2.tag == tagTable.tagBr) {
                        node2.type = (short)5;
                    } else if (node2.tag == tagTable.tagP) {
                        if (!node.isDescendantOf(tagTable.tagP)) {
                            Node.coerceNode(lexer, node2, tagTable.tagBr);
                            Node.trimSpaces(lexer, node);
                            node.insertNodeAtEnd(node2);
                            node2 = lexer.inferredTag("br");
                            continue;
                        }
                    } else {
                        if ((node2.tag.model & 0x10) != 0 && node2.tag != tagTable.tagA && (node2.tag.model & 0x800) == 0 && (node.tag.model & 0x10) != 0) {
                            lexer.popInline(node);
                            if (node.tag != tagTable.tagA) {
                                if (node2.tag == tagTable.tagA && node2.tag != node.tag) {
                                    lexer.report.warning(lexer, node, node2, (short)7);
                                    lexer.ungetToken();
                                } else {
                                    lexer.report.warning(lexer, node, node2, (short)10);
                                }
                                if ((s & 2) == 0) {
                                    Node.trimSpaces(lexer, node);
                                }
                                Node.trimEmptyElement(lexer, node);
                                return;
                            }
                            lexer.report.warning(lexer, node, node2, (short)8);
                            continue;
                        }
                        if (lexer.exiled && node2.tag.model != 0 && (node2.tag.model & 0x80) != 0) {
                            lexer.ungetToken();
                            Node.trimSpaces(lexer, node);
                            Node.trimEmptyElement(lexer, node);
                            return;
                        }
                    }
                }
                if ((node2.tag.model & 0x4000) != 0 && (node.tag.model & 0x4000) != 0) {
                    if (node2.tag == node.tag) {
                        lexer.report.warning(lexer, node, node2, (short)10);
                    } else {
                        lexer.report.warning(lexer, node, node2, (short)7);
                        lexer.ungetToken();
                    }
                    if ((s & 2) == 0) {
                        Node.trimSpaces(lexer, node);
                    }
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (node2.tag == tagTable.tagA && !node2.implicit && (node.tag == tagTable.tagA || node.isDescendantOf(tagTable.tagA))) {
                    if (node2.type != 6 && node2.attributes == null) {
                        node2.type = (short)6;
                        lexer.report.warning(lexer, node, node2, (short)24);
                        lexer.ungetToken();
                        continue;
                    }
                    lexer.ungetToken();
                    lexer.report.warning(lexer, node, node2, (short)7);
                    if ((s & 2) == 0) {
                        Node.trimSpaces(lexer, node);
                    }
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if ((node.tag.model & 0x4000) != 0) {
                    if (node2.tag == tagTable.tagCenter || node2.tag == tagTable.tagDiv) {
                        if (node2.type != 5 && node2.type != 7) {
                            lexer.report.warning(lexer, node, node2, (short)8);
                            continue;
                        }
                        lexer.report.warning(lexer, node, node2, (short)11);
                        if (node.content == null) {
                            Node.insertNodeAsParent(node, node2);
                            continue;
                        }
                        node.insertNodeAfterElement(node2);
                        if ((s & 2) == 0) {
                            Node.trimSpaces(lexer, node);
                        }
                        node = lexer.cloneNode(node);
                        node.start = lexer.lexsize;
                        node.end = lexer.lexsize;
                        node2.insertNodeAtEnd(node);
                        continue;
                    }
                    if (node2.tag == tagTable.tagHr) {
                        if (node2.type != 5 && node2.type != 7) {
                            lexer.report.warning(lexer, node, node2, (short)8);
                            continue;
                        }
                        lexer.report.warning(lexer, node, node2, (short)11);
                        if (node.content == null) {
                            Node.insertNodeBeforeElement(node, node2);
                            continue;
                        }
                        node.insertNodeAfterElement(node2);
                        if ((s & 2) == 0) {
                            Node.trimSpaces(lexer, node);
                        }
                        node = lexer.cloneNode(node);
                        node.start = lexer.lexsize;
                        node.end = lexer.lexsize;
                        node2.insertNodeAfterElement(node);
                        continue;
                    }
                }
                if (node.tag == tagTable.tagDt && node2.tag == tagTable.tagHr) {
                    if (node2.type != 5 && node2.type != 7) {
                        lexer.report.warning(lexer, node, node2, (short)8);
                        continue;
                    }
                    lexer.report.warning(lexer, node, node2, (short)11);
                    node3 = lexer.inferredTag("dd");
                    if (node.content == null) {
                        Node.insertNodeBeforeElement(node, node3);
                        node3.insertNodeAtEnd(node2);
                        continue;
                    }
                    node.insertNodeAfterElement(node3);
                    node3.insertNodeAtEnd(node2);
                    if ((s & 2) == 0) {
                        Node.trimSpaces(lexer, node);
                    }
                    node = lexer.cloneNode(node);
                    node.start = lexer.lexsize;
                    node.end = lexer.lexsize;
                    node3.insertNodeAfterElement(node);
                    continue;
                }
                if (node2.type == 6) {
                    Node node4 = node.parent;
                    while (node4 != null) {
                        if (node2.tag == node4.tag) {
                            if ((node.tag.model & 0x8000) == 0 && !node.implicit) {
                                lexer.report.warning(lexer, node, node2, (short)7);
                            }
                            if (node.tag == tagTable.tagA) {
                                lexer.popInline(node);
                            }
                            lexer.ungetToken();
                            if ((s & 2) == 0) {
                                Node.trimSpaces(lexer, node);
                            }
                            Node.trimEmptyElement(lexer, node);
                            return;
                        }
                        node4 = node4.parent;
                    }
                }
                if ((node2.tag.model & 0x10) == 0) {
                    if (node2.type != 5) {
                        lexer.report.warning(lexer, node, node2, (short)8);
                        continue;
                    }
                    if ((node.tag.model & 0x8000) == 0) {
                        lexer.report.warning(lexer, node, node2, (short)7);
                    }
                    if ((node2.tag.model & 4) != 0 && (node2.tag.model & 8) == 0) {
                        ParserImpl.moveToHead(lexer, node, node2);
                        continue;
                    }
                    if (node.tag == tagTable.tagA) {
                        if (node2.tag != null && (node2.tag.model & 0x4000) == 0) {
                            lexer.popInline(node);
                        } else if (node.content == null) {
                            Node.discardElement(node);
                            lexer.ungetToken();
                            return;
                        }
                    }
                    lexer.ungetToken();
                    if ((s & 2) == 0) {
                        Node.trimSpaces(lexer, node);
                    }
                    Node.trimEmptyElement(lexer, node);
                    return;
                }
                if (node2.type == 5 || node2.type == 7) {
                    if (node2.implicit) {
                        lexer.report.warning(lexer, node, node2, (short)15);
                    }
                    if (node2.tag == tagTable.tagBr) {
                        Node.trimSpaces(lexer, node);
                    }
                    node.insertNodeAtEnd(node2);
                    ParserImpl.parseTag(lexer, node2, s);
                    continue;
                }
                lexer.report.warning(lexer, node, node2, (short)8);
            }
            if ((node.tag.model & 0x8000) == 0) {
                lexer.report.warning(lexer, node, node2, (short)6);
            }
            Node.trimEmptyElement(lexer, node);
        }
    }

    public static class ParseFrameSet
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            TagTable tagTable = lexer.configuration.tt;
            lexer.badAccess = (short)(lexer.badAccess | 0x10);
            while ((node2 = lexer.getToken((short)0)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    Node.trimSpaces(lexer, node);
                    return;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == null) {
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                if ((node2.type == 5 || node2.type == 7) && node2.tag != null && (node2.tag.model & 4) != 0) {
                    ParserImpl.moveToHead(lexer, node, node2);
                    continue;
                }
                if (node2.tag == tagTable.tagBody) {
                    lexer.ungetToken();
                    node2 = lexer.inferredTag("noframes");
                    lexer.report.warning(lexer, node, node2, (short)15);
                }
                if (node2.type == 5 && (node2.tag.model & 0x2000) != 0) {
                    node.insertNodeAtEnd(node2);
                    lexer.excludeBlocks = false;
                    ParserImpl.parseTag(lexer, node2, (short)1);
                    continue;
                }
                if (node2.type == 7 && (node2.tag.model & 0x2000) != 0) {
                    node.insertNodeAtEnd(node2);
                    continue;
                }
                lexer.report.warning(lexer, node, node2, (short)8);
            }
            lexer.report.warning(lexer, node, node2, (short)6);
        }
    }

    public static class ParseBody
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            s = 0;
            boolean bl = true;
            TagTable tagTable = lexer.configuration.tt;
            Clean.bumpObject(lexer, node.parent);
            while ((node2 = lexer.getToken(s)) != null) {
                if (node2.tag == tagTable.tagHtml) {
                    if (node2.type == 5 || node2.type == 7 || lexer.seenEndHtml) {
                        lexer.report.warning(lexer, node, node2, (short)8);
                        continue;
                    }
                    lexer.seenEndHtml = true;
                    continue;
                }
                if (lexer.seenEndBody && (node2.type == 5 || node2.type == 6 || node2.type == 7)) {
                    lexer.report.warning(lexer, node, node2, (short)27);
                }
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    Node.trimSpaces(lexer, node);
                    lexer.seenEndBody = true;
                    s = 0;
                    if (node.parent.tag != tagTable.tagNoframes) continue;
                    break;
                }
                if (node2.tag == tagTable.tagNoframes) {
                    if (node2.type == 5) {
                        node.insertNodeAtEnd(node2);
                        BLOCK.parse(lexer, node2, s);
                        continue;
                    }
                    if (node2.type == 6 && node.parent.tag == tagTable.tagNoframes) {
                        Node.trimSpaces(lexer, node);
                        lexer.ungetToken();
                        break;
                    }
                }
                if ((node2.tag == tagTable.tagFrame || node2.tag == tagTable.tagFrameset) && node.parent.tag == tagTable.tagNoframes) {
                    Node.trimSpaces(lexer, node);
                    lexer.ungetToken();
                    break;
                }
                boolean bl2 = false;
                if (node2.type == 4 && node2.end <= node2.start + 1 && node2.textarray[node2.start] == 32) {
                    bl2 = true;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.type == 4) {
                    if (bl2 && s == 0) continue;
                    if (lexer.configuration.encloseBodyText && !bl2) {
                        lexer.ungetToken();
                        Node node3 = lexer.inferredTag("p");
                        node.insertNodeAtEnd(node3);
                        ParserImpl.parseTag(lexer, node3, s);
                        s = 1;
                        continue;
                    }
                    lexer.constrainVersion(-6);
                    if (bl) {
                        bl = false;
                        if (lexer.inlineDup(node2) > 0) continue;
                    }
                    node.insertNodeAtEnd(node2);
                    s = 1;
                    continue;
                }
                if (node2.type == 1) {
                    Node.insertDocType(lexer, node, node2);
                    continue;
                }
                if (node2.tag == null || node2.tag == tagTable.tagParam) {
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                lexer.excludeBlocks = false;
                if ((node2.tag.model & 8) == 0 && (node2.tag.model & 0x10) == 0 || node2.tag == tagTable.tagInput) {
                    if ((node2.tag.model & 4) == 0) {
                        lexer.report.warning(lexer, node, node2, (short)11);
                    }
                    if ((node2.tag.model & 2) != 0) {
                        if (node2.tag != tagTable.tagBody || !node.implicit || node.attributes != null) continue;
                        node.attributes = node2.attributes;
                        node2.attributes = null;
                        continue;
                    }
                    if ((node2.tag.model & 4) != 0) {
                        ParserImpl.moveToHead(lexer, node, node2);
                        continue;
                    }
                    if ((node2.tag.model & 0x20) != 0) {
                        lexer.ungetToken();
                        node2 = lexer.inferredTag("ul");
                        node2.addClass("noindent");
                        lexer.excludeBlocks = true;
                    } else if ((node2.tag.model & 0x40) != 0) {
                        lexer.ungetToken();
                        node2 = lexer.inferredTag("dl");
                        lexer.excludeBlocks = true;
                    } else if ((node2.tag.model & 0x380) != 0) {
                        if (node2.type != 6) {
                            lexer.ungetToken();
                            node2 = lexer.inferredTag("table");
                        }
                        lexer.excludeBlocks = true;
                    } else if (node2.tag == tagTable.tagInput) {
                        lexer.ungetToken();
                        node2 = lexer.inferredTag("form");
                        lexer.excludeBlocks = true;
                    } else {
                        if ((node2.tag.model & 0x600) != 0) continue;
                        lexer.ungetToken();
                        return;
                    }
                }
                if (node2.type == 6) {
                    if (node2.tag == tagTable.tagBr) {
                        node2.type = (short)5;
                    } else if (node2.tag == tagTable.tagP) {
                        Node.coerceNode(lexer, node2, tagTable.tagBr);
                        node.insertNodeAtEnd(node2);
                        node2 = lexer.inferredTag("br");
                    } else if ((node2.tag.model & 0x10) != 0) {
                        lexer.popInline(node2);
                    }
                }
                if (node2.type == 5 || node2.type == 7) {
                    if ((node2.tag.model & 0x10) != 0 && (node2.tag.model & 0x20000) == 0) {
                        if (node2.tag == tagTable.tagImg) {
                            lexer.constrainVersion(-5);
                        } else {
                            lexer.constrainVersion(-6);
                        }
                        if (bl && !node2.implicit) {
                            bl = false;
                            if (lexer.inlineDup(node2) > 0) continue;
                        }
                        s = 1;
                    } else {
                        bl = true;
                        s = 0;
                    }
                    if (node2.implicit) {
                        lexer.report.warning(lexer, node, node2, (short)15);
                    }
                    node.insertNodeAtEnd(node2);
                    ParserImpl.parseTag(lexer, node2, s);
                    continue;
                }
                lexer.report.warning(lexer, node, node2, (short)8);
            }
        }
    }

    public static class ParseScript
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2 = lexer.getCDATA(node);
            if (node2 == null) {
                lexer.report.error(lexer, node, null, (short)6);
                return;
            }
            node.insertNodeAtEnd(node2);
            node2 = lexer.getToken((short)0);
            if (node2 == null || node2.type != 6 || node2.tag == null || !node2.tag.name.equalsIgnoreCase(node.tag.name)) {
                lexer.report.error(lexer, node, node2, (short)6);
                if (node2 != null) {
                    lexer.ungetToken();
                }
            }
        }
    }

    public static class ParseTitle
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            while ((node2 = lexer.getToken((short)1)) != null) {
                if (node2.tag == node.tag && node2.type == 5) {
                    lexer.report.warning(lexer, node, node2, (short)24);
                    node2.type = (short)6;
                    continue;
                }
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    Node.trimSpaces(lexer, node);
                    return;
                }
                if (node2.type == 4) {
                    if (node.content == null) {
                        Node.trimInitialSpace(lexer, node, node2);
                    }
                    if (node2.start >= node2.end) continue;
                    node.insertNodeAtEnd(node2);
                    continue;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.tag == null) {
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                lexer.report.warning(lexer, node, node2, (short)7);
                lexer.ungetToken();
                Node.trimSpaces(lexer, node);
                return;
            }
            lexer.report.warning(lexer, node, node2, (short)6);
        }
    }

    public static class ParseHead
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            int n = 0;
            int n2 = 0;
            TagTable tagTable = lexer.configuration.tt;
            while ((node2 = lexer.getToken((short)0)) != null) {
                if (node2.tag == node.tag && node2.type == 6) {
                    node.closed = true;
                    break;
                }
                if (node2.type == 4) {
                    lexer.report.warning(lexer, node, node2, (short)11);
                    lexer.ungetToken();
                    break;
                }
                if (Node.insertMisc(node, node2)) continue;
                if (node2.type == 1) {
                    Node.insertDocType(lexer, node, node2);
                    continue;
                }
                if (node2.tag == null) {
                    lexer.report.warning(lexer, node, node2, (short)8);
                    continue;
                }
                if (!TidyUtils.toBoolean(node2.tag.model & 4)) {
                    if (lexer.isvoyager) {
                        lexer.report.warning(lexer, node, node2, (short)11);
                    }
                    lexer.ungetToken();
                    break;
                }
                if (node2.type == 5 || node2.type == 7) {
                    if (node2.tag == tagTable.tagTitle) {
                        if (++n > 1) {
                            lexer.report.warning(lexer, node, node2, (short)38);
                        }
                    } else if (node2.tag == tagTable.tagBase) {
                        if (++n2 > 1) {
                            lexer.report.warning(lexer, node, node2, (short)38);
                        }
                    } else if (node2.tag == tagTable.tagNoscript) {
                        lexer.report.warning(lexer, node, node2, (short)11);
                    }
                    node.insertNodeAtEnd(node2);
                    ParserImpl.parseTag(lexer, node2, (short)0);
                    continue;
                }
                lexer.report.warning(lexer, node, node2, (short)8);
            }
        }
    }

    public static class ParseHTML
    implements Parser {
        public void parse(Lexer lexer, Node node, short s) {
            Node node2;
            block28: {
                TagTable tagTable;
                Node node3;
                Node node4;
                block27: {
                    node4 = null;
                    node3 = null;
                    lexer.configuration.xmlTags = false;
                    lexer.seenEndBody = false;
                    tagTable = lexer.configuration.tt;
                    while (true) {
                        if ((node2 = lexer.getToken((short)0)) == null) {
                            node2 = lexer.inferredTag("head");
                            break block27;
                        }
                        if (node2.tag == tagTable.tagHead) break block27;
                        if (node2.tag == node.tag && node2.type == 6) {
                            lexer.report.warning(lexer, node, node2, (short)8);
                            continue;
                        }
                        if (!Node.insertMisc(node, node2)) break;
                    }
                    lexer.ungetToken();
                    node2 = lexer.inferredTag("head");
                }
                Node node5 = node2;
                node.insertNodeAtEnd(node5);
                HEAD.parse(lexer, node5, s);
                block1: while (true) {
                    if ((node2 = lexer.getToken((short)0)) == null) {
                        if (node4 == null) {
                            node2 = lexer.inferredTag("body");
                            node.insertNodeAtEnd(node2);
                            BODY.parse(lexer, node2, s);
                        }
                        return;
                    }
                    if (node2.tag == node.tag) {
                        if (node2.type != 5 && node4 == null) {
                            lexer.report.warning(lexer, node, node2, (short)8);
                            continue;
                        }
                        if (node2.type != 6) continue;
                        lexer.seenEndHtml = true;
                        continue;
                    }
                    if (Node.insertMisc(node, node2)) continue;
                    if (node2.tag == tagTable.tagBody) {
                        if (node2.type != 5) {
                            lexer.report.warning(lexer, node, node2, (short)8);
                            continue;
                        }
                        if (node4 != null) {
                            lexer.ungetToken();
                            if (node3 == null) {
                                node3 = lexer.inferredTag("noframes");
                                node4.insertNodeAtEnd(node3);
                                lexer.report.warning(lexer, node, node3, (short)15);
                            }
                            ParserImpl.parseTag(lexer, node3, s);
                            continue;
                        }
                        lexer.constrainVersion(-17);
                        break block28;
                    }
                    if (node2.tag == tagTable.tagFrameset) {
                        if (node2.type != 5) {
                            lexer.report.warning(lexer, node, node2, (short)8);
                            continue;
                        }
                        if (node4 != null) {
                            lexer.report.error(lexer, node, node2, (short)18);
                        } else {
                            node4 = node2;
                        }
                        node.insertNodeAtEnd(node2);
                        ParserImpl.parseTag(lexer, node2, s);
                        node2 = node4.content;
                        while (true) {
                            if (node2 == null) continue block1;
                            if (node2.tag == tagTable.tagNoframes) {
                                node3 = node2;
                            }
                            node2 = node2.next;
                        }
                    }
                    if (node2.tag == tagTable.tagNoframes) {
                        if (node2.type != 5) {
                            lexer.report.warning(lexer, node, node2, (short)8);
                            continue;
                        }
                        if (node4 == null) {
                            lexer.report.warning(lexer, node, node2, (short)8);
                            node2 = lexer.inferredTag("body");
                            break block28;
                        }
                        if (node3 == null) {
                            node3 = node2;
                            node4.insertNodeAtEnd(node3);
                        }
                        ParserImpl.parseTag(lexer, node3, s);
                        continue;
                    }
                    if (node2.type == 5 || node2.type == 7) {
                        if (node2.tag != null && (node2.tag.model & 4) != 0) {
                            ParserImpl.moveToHead(lexer, node, node2);
                            continue;
                        }
                        if (node4 != null && node2.tag == tagTable.tagFrame) {
                            lexer.report.warning(lexer, node, node2, (short)8);
                            continue;
                        }
                    }
                    lexer.ungetToken();
                    if (node4 == null) break;
                    if (node3 == null) {
                        node3 = lexer.inferredTag("noframes");
                        node4.insertNodeAtEnd(node3);
                    } else {
                        lexer.report.warning(lexer, node, node2, (short)26);
                    }
                    lexer.constrainVersion(16);
                    ParserImpl.parseTag(lexer, node3, s);
                }
                node2 = lexer.inferredTag("body");
                lexer.constrainVersion(-17);
            }
            node.insertNodeAtEnd(node2);
            ParserImpl.parseTag(lexer, node2, s);
            lexer.seenEndHtml = true;
        }
    }
}

