/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.xml;

import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.datasource.DSFileSpec;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.io.ISCFile;
import com.isomorphic.io.SequenceReader;
import com.isomorphic.js.IToJSON;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import com.isomorphic.xml.XMLParsingException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class Screen
implements IToJSON {
    private static Config config = Config.getGlobal();
    private static Logger log = new Logger(Screen.class.getName());
    private static String storageDS = config.getString("project.vbScreensDS");
    private static String fileType = "ui";
    private static String fileFormat = "xml";
    DataTypeMap data;
    String xml;
    DataTypeMap metadata;

    public Screen(String xml, Map metadata) throws Exception {
        this(Screen.dataFromXML(xml, false), metadata);
        this.xml = xml;
    }

    public Screen(String xml, Map metadata, boolean mockMode) throws Exception {
        this(Screen.dataFromXML(xml, false), metadata, mockMode);
        this.xml = xml;
    }

    public Screen(Map data, Map metadata) {
        this(data, metadata, false);
    }

    public Screen(Map data, Map metadata, boolean mockMode) {
        this.data = new DataTypeMap(data);
        if (mockMode) {
            this.applyMockMode();
        }
        this.metadata = metadata == null ? new DataTypeMap() : new DataTypeMap(metadata);
        this.addWorkflowReferencedDataSources();
    }

    private void applyMockMode() {
        List<Map> components = this.getComponents();
        ArrayList<Map> newComponents = new ArrayList<Map>();
        for (Map component : components) {
            String constructor = (String)component.get("__autoConstruct");
            if (constructor != null) {
                HashMap<String, Boolean> componentCopy = new HashMap<String, Boolean>(component);
                componentCopy.put("mockMode", true);
                newComponents.add(componentCopy);
                continue;
            }
            newComponents.add(component);
        }
        this.setComponents(newComponents);
    }

    private void addWorkflowReferencedDataSources() {
        ArrayList<String> referencedComponents = new ArrayList<String>();
        ArrayList<String> impliedDataSources = new ArrayList<String>();
        List<Map> components = this.getComponents();
        if (components == null) {
            return;
        }
        for (Map map : components) {
            ArrayList<Map> subComponents = null;
            if (map instanceof List) {
                subComponents = (ArrayList<Map>)((Object)map);
            } else {
                subComponents = new ArrayList<Map>();
                subComponents.add(map);
            }
            for (Object e : subComponents) {
                Map component = (Map)e;
                String ID = (String)component.get("ID");
                if (ID != null) {
                    referencedComponents.add(ID);
                }
                List<String> dataSources = this.getWorkflowDataSources(component);
                impliedDataSources.addAll(dataSources);
            }
        }
        if (impliedDataSources.size() > 0) {
            String string;
            Map component;
            ArrayList<String> dsList = new ArrayList<String>();
            for (String ds : impliedDataSources) {
                if (referencedComponents.contains(ds)) continue;
                dsList.add(ds);
            }
            if (dsList.size() > 0 && (component = this.createLoadDSComponent(string = StringUtils.join(dsList, (String)","))) != null) {
                components.add(component);
            }
        }
    }

    private Map createLoadDSComponent(String dataSource) {
        Map component = null;
        String xml = "<DataSource loadParents=\"true\"><loadID>" + dataSource + "</loadID></DataSource>";
        try {
            component = (Map)XML.toDSRecords(new StringReader(xml));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return component;
    }

    private List<String> getWorkflowDataSources(Map component) {
        ArrayList<Map> processes = new ArrayList<Map>();
        this.getProcesses(component, processes);
        ArrayList<String> dataSources = new ArrayList<String>();
        for (Map process : processes) {
            this.getProcessDataSources(process, dataSources);
        }
        return dataSources;
    }

    private void getProcesses(Map component, List<Map> processes) {
        if (component.containsKey("_constructor") && "Process".equals(component.get("_constructor"))) {
            processes.add(component);
            return;
        }
        for (Object key : component.keySet()) {
            Object value = component.get(key);
            if (value instanceof Map) {
                this.getProcesses((Map)value, processes);
                continue;
            }
            if (!(value instanceof ArrayList)) continue;
            ArrayList a = (ArrayList)value;
            for (Object ao : a) {
                if (!(ao instanceof Map)) continue;
                this.getProcesses((Map)ao, processes);
            }
        }
    }

    private void getProcessDataSources(Map component, List<String> dataSources) {
        for (Object key : component.keySet()) {
            Object value = component.get(key);
            if (value instanceof Map) {
                this.getProcessDataSources((Map)value, dataSources);
                continue;
            }
            if (value instanceof ArrayList) {
                ArrayList a = (ArrayList)value;
                for (Object ao : a) {
                    if (!(ao instanceof Map)) continue;
                    this.getProcessDataSources((Map)ao, dataSources);
                }
                continue;
            }
            if (!"dataSource".equals(key)) continue;
            dataSources.add((String)value);
        }
    }

    private static Map dataFromXML(String xml, boolean mockMode) throws Exception {
        log.warn("data: " + xml);
        try {
            return (Map)XML.toDSRecords(new StringReader(xml));
        }
        catch (XMLParsingException e) {
            log.warn("dataFromXML(): invalid XML - trying again with top-level element added");
            return (Map)XML.toDSRecords(new SequenceReader("<Object><components xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"xsd:List\">", xml, "</components></Object>"));
        }
    }

    public static Screen load(String name) throws Exception {
        log.warn("Looking for screen: " + name);
        return Screen.load(name, false);
    }

    public static Screen load(String name, boolean mockMode) throws Exception {
        return Screen.load((Object)DataTools.buildMap("fileName", name), mockMode);
    }

    public static Screen load(String name, String ownerId) throws Exception {
        log.warn("Looking for screen: " + name + ", with owner: " + ownerId);
        return Screen.load(name, ownerId, false);
    }

    public static Screen load(String name, String ownerId, boolean mockMode) throws Exception {
        return Screen.load((Object)DataTools.buildMap("fileName", name, "ownerId", ownerId), mockMode);
    }

    public static Screen load(Object criteria, boolean mockMode) throws Exception {
        List<Screen> resultsMatchingCriteria = Screen.list(criteria, mockMode);
        if (resultsMatchingCriteria.size() == 0) {
            return null;
        }
        if (resultsMatchingCriteria.size() > 1) {
            log.warn("Multiple Screens (" + resultsMatchingCriteria.size() + ") matched criteria for load() - using the latest one.  Criteria: " + DataTools.prettyPrint(criteria));
        }
        return resultsMatchingCriteria.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Screen> list(Object criteria, boolean mockMode) throws Exception {
        if (criteria == null) {
            criteria = new HashMap();
        }
        if (criteria instanceof Map) {
            Map m = criteria;
            if (m.get("fileType") == null) {
                m.put("fileType", fileType);
            }
            if (m.get("fileFormat") == null) {
                m.put("fileFormat", fileFormat);
            }
        } else {
            AdvancedCriteria c = (AdvancedCriteria)((Object)criteria);
            if (c.getFieldValue("fileType") == null) {
                c.addCriteria("fileType", DefaultOperators.Equals, fileType);
            }
            if (c.getFieldValue("fileFormat") == null) {
                c.addCriteria("fileFormat", DefaultOperators.Equals, fileFormat);
            }
        }
        ArrayList<Screen> results = new ArrayList<Screen>();
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            List<Map<String, Object>> files = ds.listFiles(criteria, (Map)((Object)DataTools.buildMap("sortBy", "-fileLastModified")));
            for (Map<String, Object> metadata : files) {
                String xml = ds.getFileAsString(new DSFileSpec(metadata));
                results.add(new Screen(xml, metadata, mockMode));
            }
        }
        finally {
            DataSourceManager.free(ds);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Screen persist() throws Exception {
        StringWriter sw = new StringWriter();
        List<Map> components = this.getComponents();
        for (Map component : components) {
            String tagName = (String)component.get("__autoConstruct");
            if (tagName == null) {
                tagName = "Object";
            }
            DataSource transformDS = null;
            try {
                transformDS = DataSourceManager.get(tagName);
            }
            finally {
                DataSourceManager.free(transformDS);
            }
            XML.recordToXML(tagName, component, sw, false, false, transformDS, null);
        }
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            Map<String, Object> metadataAsSaved = ds.saveFile(new DSFileSpec((Map)((Object)this.metadata)), sw.toString());
            Screen screen = Screen.load(metadataAsSaved, false);
            return screen;
        }
        finally {
            DataSourceManager.free(ds);
        }
    }

    public void _persistXML() throws Exception {
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            ds.saveFile(new DSFileSpec((Map)((Object)this.metadata)), this.xml);
        }
        finally {
            DataSourceManager.free(ds);
        }
    }

    public void remove() throws Exception {
        if (this.getName() == null) {
            throw new Exception("Cannot remove a Screen that has not yet been persisted");
        }
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            ds.removeFile(new DSFileSpec((Map)((Object)this.metadata)));
        }
        finally {
            DataSourceManager.free(ds);
        }
    }

    @Override
    public void toJSON(Writer out, JSTranslater jsTrans) throws UnconvertableException, IOException {
        jsTrans.toJS((Object)this.data, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Screen rename(String newName) throws Exception {
        if (this.getName() == null) {
            throw new Exception("Cannot rename a Screen that has not yet been persisted");
        }
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            List<Map<String, Object>> renamedFiles = ds.renameFile(new DSFileSpec((Map)((Object)this.metadata)), new DSFileSpec((Map)((Object)DataTools.buildMap("fileName", newName))));
            Map<String, Object> metadataAsSaved = renamedFiles.get(0);
            Screen screen = Screen.load(metadataAsSaved, false);
            return screen;
        }
        finally {
            DataSourceManager.free(ds);
        }
    }

    public String getName() {
        return this.metadata.getString("fileName");
    }

    public DataTypeMap getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map metadata) {
        this.metadata = new DataTypeMap(metadata);
    }

    public String getOwner() {
        return this.metadata.getString("ownerId");
    }

    public void setOwner(String owner) {
        this.metadata.put("ownerId", owner);
    }

    public List<Map> getComponents() {
        return this.data.getList("components");
    }

    public void setComponents(Collection components) {
        this.data.put("components", new ArrayList(components));
    }

    private static Screen _load(String name, String ownerId) throws Exception {
        Screen screen = null;
        String screenFile = DataStructCache.getInstanceFile(name, "ui", "ui");
        if (screenFile != null) {
            String xml = ISCFile.newInstance(screenFile).getAsString();
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("fileName", name);
            metadata.put("fileFormat", "xml");
            metadata.put("fileType", "ui");
            screen = new Screen(xml, metadata);
        }
        if (screen == null) {
            screen = ownerId == null ? Screen.load(name) : Screen.load(name, ownerId);
        }
        return screen;
    }

    public static String getLoadScript(String screenName) throws Exception {
        return Screen.getLoadScript(screenName, null);
    }

    public static String getLoadScript(String screenName, String ownerId) throws Exception {
        boolean allowNonOwnerFetch = config.getBoolean((Object)"security.allowNonOwnerFetch", false);
        Screen screen = Screen._load(screenName, allowNonOwnerFetch ? null : ownerId);
        if (screen == null) {
            throw new Exception("Unable to find screen: " + screenName);
        }
        JSTranslater jsTrans = JSTranslater.instance();
        jsTrans.setObfuscation(false);
        StringWriter out = new StringWriter();
        jsTrans.toJS(screen, out);
        return ((Object)out).toString();
    }
}

