/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.store;

import com.isomorphic.base.Config;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class ProcessedFileCache {
    private static Logger log = new Logger(ProcessedFileCache.class.getName());
    private long stalenessCheckInterval = Config.getGlobal().getLong((Object)"file.stalenessCheckInterval", 0L);
    Map cache = Collections.synchronizedMap(new HashMap());

    public void setStalenessCheckInterval(long millis) {
        this.stalenessCheckInterval = millis;
    }

    public long getStalenessCheckInterval() {
        return this.stalenessCheckInterval;
    }

    public void clearCacheEntry(Object key) {
        this.cache.remove(key);
    }

    public void clear() {
        this.cache.clear();
    }

    public Object getObjectFromFile(ISCFile file) throws Exception {
        return this.getObjectFromFile(file, null);
    }

    public Object getObjectFromFile(ISCFile file, Map flags) throws Exception {
        boolean bypassCache = false;
        if (flags != null && flags.containsKey("bypassCache")) {
            bypassCache = DataTools.asBoolean(flags.get("bypassCache"));
        }
        if (!bypassCache) {
            String name = file.getCanonicalPath();
            CacheEntry entry = (CacheEntry)this.cache.get(name);
            long timeStamp = -1L;
            if (entry != null) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - entry.lastStalenessCheck <= this.stalenessCheckInterval) {
                    return entry.cachedObject;
                }
                timeStamp = file.lastModified();
                if (timeStamp == 0L) {
                    log.warning("Can't perform staleness checking for " + name);
                }
                if (entry.timeStamp == timeStamp) {
                    entry.lastStalenessCheck = currentTime;
                    return entry.cachedObject;
                }
                if (log.isDebugEnabled()) {
                    log.debug("STALE object for file '" + name + "', reloading (file timestamp " + timeStamp + ", cache timestamp " + entry.timeStamp + ")");
                }
                if (flags != null) {
                    flags.put("objectWasStale", Boolean.TRUE);
                }
            }
            if (timeStamp == -1L) {
                timeStamp = file.lastModified();
            }
            Object loadedObject = this.loadObjectFromFile(file);
            if (timeStamp > 0L) {
                this.cacheObject(name, loadedObject, timeStamp);
            }
            return loadedObject;
        }
        return this.loadObjectFromFile(file);
    }

    public Object getObjectFromFile(String fileName) throws Exception {
        return this.getObjectFromFile(ISCFile.newInstance(fileName));
    }

    public abstract Object loadObjectFromFile(ISCFile var1) throws Exception;

    public void cacheObject(String name, Object object, long timeStamp) {
        CacheEntry entry = new CacheEntry();
        entry.timeStamp = timeStamp;
        entry.cachedObject = object;
        entry.lastStalenessCheck = System.currentTimeMillis();
        this.cache.put(name, entry);
    }

    static class CacheEntry {
        public Object cachedObject;
        public long timeStamp;
        public long lastStalenessCheck;

        CacheEntry() {
        }
    }
}

