/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.hibernate;

import com.isomorphic.datasource.DataSource;
import com.isomorphic.hibernate.HibernateDSGenerator;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.taglib.VirtualTag;
import com.isomorphic.util.DataTools;
import java.io.Writer;
import javax.servlet.jsp.JspException;

public class LoadDSFromDBTag
extends VirtualTag {
    public String ID = null;
    public String serverType = null;
    public String tableName = null;
    public String dbName = null;
    public String schema = null;

    public int doStartTag() throws JspException {
        this.init();
        try {
            if (this.ID == null && this.tableName == null) {
                throw new JspException("Neither DataSource ID nor tableName set in tag - unable to proceed.");
            }
            if (this.tableName == null) {
                this.tableName = this.ID;
            }
            if (this.ID == null) {
                this.ID = this.tableName;
            }
            if (virtualize) {
                return this.virtualizeTag("ds", this.ID);
            }
            DataSource ds = null;
            DataStructCache.removeCachedObjectWithNoConfigFile((String)this.ID);
            ds = "hibernate".equals(this.serverType) ? HibernateDSGenerator.fromTable(this.tableName, this.schema, this.ID) : SQLDataSource.fromTable(null, (String)this.tableName, (String)this.schema, (String)this.ID, (String)this.serverType, (String)this.dbName);
            if (ds == null) {
                throw new JspException("Unable to build DataSource for tableName: " + this.tableName);
            }
            JSTranslater.get().toJS((Object)ds, (Writer)this.pageContext.getOut());
        }
        catch (Throwable e) {
            this.log.error((Object)"Exception while attempting to process a loadDSFromDB tag.", e);
            throw new JspException(DataTools.getStackTrace((Throwable)e));
        }
        return 0;
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    public String getID() {
        return this.ID;
    }

    public void setName(String name) {
        this.ID = name;
    }

    public String getName() {
        return this.ID;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public String getServerType() {
        return this.serverType;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getSchema() {
        return this.schema;
    }
}

