#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )

$symbol_pound Built-In SQL DataSource

This example builds on **archetype-smartgwt-quickstart**, which illustrates setting up a datasource of type "sql", and goes a step further to show how a single databound component can be used (and re-used) with many datasources.  It was generated by a Maven archetype available in the SDK.

_Note that, given a choice, most users will want to start new projects with either the **archetype-smartgwt-quickstart** or **archetype-smartgwt-quickstart-relogin** archetype.  Refer to the Quick Start Guide distributed with your build for further discussion on best practices._

To start with a new application like this one:

1. Install Maven, if necessary 

     <https://maven.apache.org/install.html>

2. Install SmartGWT, if necessary.
              
        mvn com.isomorphic:isc-maven-plugin:1.4.5:install $symbol_escape
          -Dproduct=SMARTGWT -Dlicense=EVAL -DbuildNumber=12.1p

3. Generate a project (using LATEST as below, or the version installed for you in step 2)

        mvn archetype:generate $symbol_escape
          -DartifactId=my-application -Dmodule=MyApplication $symbol_escape
          -DgroupId=com.example -Dpackage=com.example.myapplication $symbol_escape
          -DarchetypeGroupId=com.isomorphic.archetype $symbol_escape
          -DarchetypeArtifactId=archetype-smartgwt-example-builtinds $symbol_escape
          -DarchetypeVersion=LATEST -DinteractiveMode=false

Instructions are provided below for using the generated project with Eclipse and command line development environments.

If you instead want to add Smart GWT EE to an existing project, see these instructions:  

<http://www.smartclient.com/smartgwtee/javadoc/com/smartgwt/client/docs/SgwtEESetup.html>

For instructions for launching tools such as the Developer Console, Visual Builder or DataSource Wizards, see the Smart GWT FAQ:

<http://forums.smartclient.com/showthread.php?t=8159>


$symbol_pound$symbol_pound Prerequisites

Variations on the following are possible, but archetypes & sample projects were created with the following environment/s in mind:

- [Java 8](https://java.com/en/download/manual.jsp)

- [Google Web Toolkit](https://developers.google.com/web-toolkit/download) version 2.8.2 or later

- [Apache Maven](http://maven.apache.org/download.cgi) version 3.5.0 or later

- [Apache Ant](https://ant.apache.org/bindownload.cgi) version 1.9.10 or later.

  - *Ensure that the GWT_HOME environment variable is set to the location of your Google Web Toolkit SDK directory*

  - *Ensure that the ANT_HOME environment variable is set to the location of your Apache Ant directory, and the 'ant' command is in your PATH.*

- [Eclipse Java EE IDE for Web Developers](http://www.eclipse.org/downloads/packages/eclipse-ide-java-ee-developers/oxygen2), version 4.7.2 (Oxygen) or later and [GWT Eclipse Plugin](http://gwt-plugins.github.io/documentation/gwt-eclipse-plugin/Download.html) version 3.0.0 or later.

$symbol_pound$symbol_pound$symbol_pound Initialization

1.  Ant users will begin by restructuring the project and removing Maven-specific resources.

        cd my-application
        ant unmaven


$symbol_pound$symbol_pound Usage: Apache Maven

$symbol_pound$symbol_pound$symbol_pound Command line tools

1. Navigate to your project directory
        
        cd my-application

2. Start the GWT codeserver.

        mvn gwt:codeserver -am -pl *-client

3.  At another command line from the same directory, start the servlet container

        mvn jetty:run -Pdev -pl *-server

4. Wait for each process to indicate that it's ready, and then load the app in your browser at <http://localhost:8080/index.jsp>

$symbol_pound$symbol_pound$symbol_pound Eclipse

1. Import the generated project using the "Existing Maven Projects" wizard (File/Import/Maven/Existing Maven Projects)

2. Ensure that the imported project's client module takes the GWT Facet (Project Properties / Project Facets / GWT is checked)

3. Package the parent project, causing the SmartGWT runtime to be unpacked to the server (Provide "package" to the 'goals' prompt at Run / Run As / Maven Build).  A refresh of the server project's 'target' folder may be necessary.

   _Note that this won't be strictly necessary if you've already tested the project using Command Line Tools, but you'll need to repeat this step following any 'mvn clean' execution._

4. Add the SmartGWT runtime to the server project's 'Deployment Assembly' (Project Properties / Deployment Assembly).  
   
   **Source**: /target/my-application-server-1.0-SNAPSHOT/myapplication 
   **Deploy Path**: myapplication

5. If necessary, create or edit a Tomcat server with a JNDI configuration similar to those found at src/etc/tomcat/context.xml.  Servers/[YOUR SERVER]/context.xml or Servers/[YOUR SERVER]/server.xml (added to the context node)

6. Add the application to the server and launch it. 

7. Wait for each process to indicate that it's ready, and then load the app in your browser at the URL reported by Eclipse.  <http://localhost:8080/my-application-server/index.jsp>


$symbol_pound$symbol_pound Usage: Apache Ant

$symbol_pound$symbol_pound$symbol_pound Command line tools

1. Navigate to your project directory
        
        cd my-application
        
2. Launch GWT DevMode.  _Note that this may fail the first time when Apache Ivy has not been installed, but correction should occur automatically, and subsequent attempts should be successful_.

        ant devmode

3. Wait for the process to indicate that it's ready, and then load the app in your browser at <http://127.0.0.1:8888/index.html>

$symbol_pound$symbol_pound$symbol_pound Eclipse

1. Create a new project using the "Java Project" wizard (File/New/Project/Java Project)

2. When prompted for the 'Project name', use the name of the directory holding your project on disk.  

   **Project name: my-application**

   The wizard will automatically configure the JRE and the project layout based on the existing source.

3. If necessary, run the Ant build's 'gwtc' target to retrieve dependencies and force GWT compilation.  If you are using Ant tools for Eclipse, you'll need to make sure Eclipse has proper values for the environment variables outlined in the Prerequisites section above.

        ant gwtc

   Alternatively, you may choose to do this in steps by first running the Ant build's 'ivy-get' target and then compiling via Eclipse (Right-click > GWT > Compile).  The benefit to doing so is that there is no need for the aforementioned environment variables.  

   In either case, you may need to refresh your project's contents.

   _Note that this won't be strictly necessary if you've already tested the project using Command Line Tools, but you'll need to repeat this step following any 'ant clean' execution._

4. Create or edit a Tomcat server with a JNDI configuration similar to those found at src/etc/tomcat/context.xml.  Servers/[YOUR SERVER]/context.xml or Servers/[YOUR SERVER]/server.xml (added to the context node)

5. Add the application to the server and launch it.

6. Wait for each process to indicate that it's ready, and then load the app in your browser at <http://localhost:8080/index.jsp>


$symbol_pound$symbol_pound Related Topics

- Refer to the [Reify for Developers](https://www.smartclient.com/smartclient-latest/isomorphic/system/reference/?id=group..reifyForDevelopers) documentation topic for tips on importing UI assets from the Reify environment.

- Hosted Mode is being being phased out by GWT and replaced with Super Dev Mode.  You can find an overview of SDM at:

  <http://www.gwtproject.org/articles/superdevmode.html>

- For more details about how to set up or use SDM, see our online Smart GWT SDM Troubleshooting help topic at 

  <http://www.smartclient.com/smartgwt/javadoc/com/smartgwt/client/docs/SuperDevModeTroubleshooting.html>

- See our debugging overview at <http://www.smartclient.com/smartgwt/javadoc/com/smartgwt/client/docs/Debugging.html>
