/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.css;

import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.ConfigurationProperty;
import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.SelectionProperty;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssCompilerException;
import com.google.gwt.resources.css.ast.CssIf;
import com.google.gwt.resources.css.ast.CssModVisitor;
import com.google.gwt.resources.css.ast.CssNode;
import java.util.Arrays;

public class IfEvaluator
extends CssModVisitor {
    private final TreeLogger logger;
    private final PropertyOracle oracle;

    public IfEvaluator(TreeLogger logger, PropertyOracle oracle) {
        this.logger = logger.branch(TreeLogger.DEBUG, "Replacing property-based @if blocks");
        this.oracle = oracle;
    }

    @Override
    public void endVisit(CssIf x, Context ctx) {
        if (x.getExpression() == null) {
            try {
                String propertyName = x.getPropertyName();
                String propValue = null;
                try {
                    SelectionProperty selProp = this.oracle.getSelectionProperty(this.logger, propertyName);
                    propValue = selProp.getCurrentValue();
                }
                catch (BadPropertyValueException e) {
                    ConfigurationProperty confProp = this.oracle.getConfigurationProperty(propertyName);
                    propValue = (String)confProp.getValues().get(0);
                }
                if (Arrays.asList(x.getPropertyValues()).contains(propValue) ^ x.isNegated()) {
                    for (CssNode n : x.getNodes()) {
                        ctx.insertBefore(n);
                    }
                } else {
                    for (CssNode n : x.getElseNodes()) {
                        ctx.insertBefore(n);
                    }
                }
                ctx.removeMe();
            }
            catch (BadPropertyValueException e) {
                this.logger.log(TreeLogger.ERROR, "Unable to evaluate @if block", (Throwable)e);
                throw new CssCompilerException("Unable to parse CSS", e);
            }
        }
    }
}

