/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.tools;

import com.isomorphic.base.Config;
import com.isomorphic.base.ConfigLoader;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.naming.JNDI;
import com.isomorphic.naming.JNDISearchResult;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.sql.SQLConnectionManager;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLMetaData;
import com.isomorphic.tools.BuiltinRPC;
import com.isomorphic.tools.SQLImport;
import com.isomorphic.tools.SQLTestException;
import com.isomorphic.util.DataTools;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.commons.collections4.list.SetUniqueList;
import org.hibernate.exception.ConstraintViolationException;

public class AdminConsole
extends com.isomorphic.rpc.BuiltinRPC {
    private static String createTest = "CREATE TABLE isc_admin_test (foo varchar(1))";
    private static String dropTest = "DROP TABLE isc_admin_test";
    public static List<String> restoreDBList = Collections.synchronizedList(SetUniqueList.setUniqueList(new ArrayList()));
    public static List<String> dbSnapshotFileList = Collections.synchronizedList(SetUniqueList.setUniqueList(new ArrayList()));
    public static Map globalConfigOverides = null;

    public static DataTypeMap sanitizeConfig(Map passedConfig) throws Exception {
        if (passedConfig == null) {
            return null;
        }
        DataTypeMap sanitizedConfig = new DataTypeMap();
        ArrayList keys = new ArrayList(passedConfig.keySet());
        for (String key : keys) {
            if (passedConfig.get(key) == null || !key.startsWith("database") && !key.startsWith("interface") && !key.startsWith("driver") && !key.startsWith("autoJoinTransactions") && !key.startsWith("pool")) continue;
            Object value = passedConfig.get(key);
            key = key.replace('_', '.');
            sanitizedConfig.put((Object)key, value);
        }
        return sanitizedConfig;
    }

    public static void saveDBConfig(Map values) throws Exception {
        DataTypeMap form = new DataTypeMap(values);
        String dbName = form.getString((Object)"dbName");
        String interfaceType = (String)(form = AdminConsole.sanitizeConfig((Map)form)).get((Object)"interface.type");
        if (interfaceType != null && interfaceType.equals("jndi")) {
            form.put((Object)"pool.enabled", (Object)"false");
        }
        Config newConfig = new Config();
        newConfig.putSubtree("sql." + dbName, (Map)form);
        Config.persistProperties((Map)newConfig, (String)ConfigLoader.server);
        DataTools.mapMerge((Map)newConfig, (Map)config);
        String urlProperty = "sql." + dbName + ".driver.url";
        if (newConfig.get((Object)urlProperty) == null) {
            Config.persistProperty((String)urlProperty, null, (String)ConfigLoader.server);
            config.remove((Object)urlProperty);
        }
        SQLDriver.purgeSqlConfig();
        SQLConnectionManager.restartPoolManager();
        DataSourceManager.restartPoolManager();
    }

    public static RPCResponse testDB(String dbName, Map passedConfig) throws Exception {
        RPCResponse result = new RPCResponse();
        Config dbConfig = null;
        if (passedConfig != null) {
            dbConfig = new Config((Map)AdminConsole.sanitizeConfig(passedConfig));
        }
        log.info((Object)("testing db '" + dbName + "' with config: " + DataTools.prettyPrint((Object)dbConfig)));
        try {
            AdminConsole.testDBCore(dbName, dbConfig, null);
        }
        catch (SQLTestWarningException e) {
            result.setData((Object)("<font color='red'><b>WARNING:</b></font> Database " + dbName + " is connectable but the connection is limited.  We were unable to create or drop a test table, which means you are likely to experience problems importing DataSources."));
            return result;
        }
        catch (SQLTestException e) {
            result.setData((Object)("Failure: " + e.error + ". Error from Driver: " + e.originalException.toString()));
            result.setStatus(-1);
            return result;
        }
        result.setData((Object)("Database '" + dbName + "' is OK."));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void testDBCore(String dbName, Config dbConfig, Map result) throws SQLTestException {
        Connection conn = null;
        try {
            conn = AdminConsole.getConnectionForConfig(dbName, dbConfig);
            if (result != null) {
                SQLMetaData smd = new SQLMetaData(conn);
                Map pv = smd.getProductNameAndVersion();
                result.put("dbProductName", pv.get("productName"));
                result.put("dbProductVersion", pv.get("productVersion"));
            }
            if (conn == null) {
                throw new Exception("Can't get connection to '" + dbName + "'");
            }
            Statement s = null;
            try {
                s = conn.createStatement();
                s.executeUpdate(createTest);
            }
            catch (SQLException se) {
                try {
                    try {
                        s.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    s = conn.createStatement();
                    s.executeUpdate(dropTest);
                    s.executeUpdate(createTest);
                }
                catch (SQLException se2) {
                    throw new SQLTestWarningException("Limited: User has insufficient privileges to create or drop tables", se2);
                }
            }
            finally {
                block60: {
                    try {
                        s.close();
                    }
                    catch (Exception exception) {}
                    s = conn.createStatement();
                    s.executeUpdate(dropTest);
                    try {
                        s.close();
                    }
                    catch (Exception exception) {}
                    break block60;
                    catch (SQLException sQLException) {
                        try {
                            s.close();
                        }
                        catch (Exception exception) {}
                        catch (Throwable throwable) {
                            try {
                                s.close();
                            }
                            catch (Exception exception) {}
                            throw throwable;
                        }
                    }
                }
            }
        }
        catch (SQLTestWarningException stwe) {
            throw stwe;
        }
        catch (Exception e) {
            log.info((Object)("testDB (" + dbName + ") error: " + e.toString()));
            if (e.toString().indexOf("ClassNotFoundException") != -1) {
                throw new SQLTestException("JDBC Driver not installed", e);
            }
            throw new SQLTestException("Unable to connect", e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Connection getConnectionForConfig(String dbName, Config dbConfig) throws Exception {
        log.debug((Object)("Testing DB connection for database: " + dbName + " with config: " + DataTools.prettyPrint((Object)dbConfig)));
        if (dbConfig != null) {
            SQLDriver.configure((String)dbName, (Config)dbConfig);
        }
        return SQLDriver.instance((String)dbName).rawConnection();
    }

    public static List getDefinedDatabases(boolean testConnection) throws Exception {
        ArrayList dbList = new ArrayList();
        List dbNames = SQLConnectionManager.getDefinedDatabaseNames();
        String defaultDatabase = config.getString((Object)"sql.defaultDatabase");
        for (String dbName : dbNames) {
            Config dbConfig = config.getSubtree("sql." + dbName);
            SQLDriver driver = null;
            try {
                driver = SQLDriver.instance((String)dbName);
            }
            catch (Exception e) {
                dbConfig.put((Object)"dbStatus", (Object)e.getMessage());
            }
            if (driver != null) {
                dbConfig = driver.getSqlConfig();
                if (!testConnection) {
                    dbConfig.put((Object)"dbStatus", (Object)"Not tested");
                } else {
                    try {
                        AdminConsole.testDBCore(dbName, null, (Map)dbConfig);
                        dbConfig.put((Object)"dbStatus", (Object)"OK");
                    }
                    catch (SQLTestWarningException e) {
                        dbConfig.put((Object)"dbStatus", (Object)"OK, Read-Only");
                    }
                    catch (SQLTestException e) {
                        dbConfig.put((Object)"dbStatus", (Object)e.error);
                    }
                }
            }
            dbConfig.put((Object)"dbName", (Object)dbName);
            if (dbName.equals(defaultDatabase)) {
                dbConfig.put((Object)"isDefault", (Object)Boolean.TRUE);
            }
            LinkedHashMap<String, Object> alteredConfig = new LinkedHashMap<String, Object>();
            for (String key : dbConfig.keySet()) {
                Object value = dbConfig.get((Object)key);
                key = key.replace('.', '_');
                alteredConfig.put(key, value);
            }
            dbList.add(alteredConfig);
        }
        Collections.sort(dbList, new Comparator(){

            public int compare(Object o1, Object o2) {
                Map m1 = (Map)o1;
                Map m2 = (Map)o2;
                if ("true".equals(m1.get("driver.autoConfigured")) && !"true".equals(m1.get("driver.autoConfigured"))) {
                    return 1;
                }
                return ((String)m1.get("dbName")).compareTo((String)m2.get("dbName"));
            }
        });
        return dbList;
    }

    public static List discoverJNDIDatabases() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        List contextRoots = config.getList((Object)"sql.jndi.autoDetectRoots", new ArrayList());
        ArrayList l = new ArrayList();
        for (String contextRoot : contextRoots) {
            log.info((Object)("Discovering datasources at JNDI root: " + contextRoot));
            if (contextRoot.equals("__root__")) {
                contextRoot = "";
            }
            List searchResult = null;
            try {
                searchResult = JNDI.searchTreeForClass((String)contextRoot, javax.sql.DataSource.class, (List)DataTools.buildList((Object[])new String[]{"java:comp/Resources"}));
            }
            catch (NamingException ne) {
                log.warn((Object)("Failure during JNDI datasource discovery: " + ne.getMessage()));
            }
            DataTools.addAll(l, (List)searchResult);
        }
        for (JNDISearchResult sr : l) {
            String path = sr.getPath();
            if (result.contains(path)) continue;
            log.info((Object)("Auto-discovered JNDI DataSource: " + path));
            result.add(path);
        }
        return result;
    }

    public static String setDefaultDB(String dbName) throws Exception {
        if (dbName == null || dbName.equals(config.getString((Object)"sql.defaultDatabase"))) {
            return dbName;
        }
        Config.persistProperty((String)"sql.defaultDatabase", (Object)dbName, (String)ConfigLoader.server);
        config.put((Object)"sql.defaultDatabase", (Object)dbName);
        SQLDriver.purgeSqlConfig();
        SQLConnectionManager.restartPoolManager();
        DataSourceManager.restartPoolManager();
        return dbName;
    }

    public static synchronized void setGlobalConfigOverrides(Map globalConfigOverides) throws Exception {
        if (globalConfigOverides != null && !globalConfigOverides.isEmpty()) {
            log.info((Object)("setting globalConfig overrides: " + DataTools.prettyPrint((Object)globalConfigOverides)));
            AdminConsole.globalConfigOverides = globalConfigOverides;
            config.setGlobalOverrides(globalConfigOverides);
        }
    }

    public static synchronized void clearGlobalConfigOverrides() throws Exception {
        if (globalConfigOverides != null) {
            log.info((Object)("clearing globalConfig overrides: " + DataTools.prettyPrint((Object)globalConfigOverides)));
            config.clearGlobalOverrides();
            globalConfigOverides = null;
        }
    }

    public static synchronized void testStart(String testURL, List<String> snapshotDBList, Map globalConfigOverrides) throws Exception {
        log.info((Object)testURL);
        if (config.getBoolean((Object)"autotest.instance.running", false)) {
            log.warn((Object)"detected autotest in progress on testStart - calling testEnd before proceeding");
            AdminConsole.testEnd(config.getString((Object)"autotest.instance.testURL", "N/A"));
        }
        config.put((Object)"autotest.instance.testURL", (Object)testURL);
        config.put((Object)"autotest.instance.running", (Object)"true");
        config.put((Object)"autotest.instance.restoreDBList", restoreDBList);
        config.put((Object)"autotest.instance.dbSnapshotFileList", dbSnapshotFileList);
        String defaultDatabase = config.getString((Object)"sql.defaultDatabase");
        config.put((Object)"autotest.instance.defaultDatabase", (Object)defaultDatabase);
        restoreDBList.clear();
        snapshotDBList = SetUniqueList.setUniqueList(snapshotDBList);
        if (snapshotDBList.size() != 0) {
            for (String dbName : snapshotDBList) {
                List defaultDbAliases = DataTools.buildList((Object[])new String[]{"isomorphic", "default", "defaultDatabase"});
                restoreDBList.add(defaultDbAliases.contains(dbName) ? defaultDatabase : dbName);
            }
            AdminConsole.snapshotDB(restoreDBList);
            log.info((Object)("explicit snapshotDB: " + DataTools.prettyPrint(restoreDBList)));
        }
        if (globalConfigOverrides != null) {
            AdminConsole.setGlobalConfigOverrides(globalConfigOverrides);
        } else {
            AdminConsole.clearGlobalConfigOverrides();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void testEnd(String testURL) throws Exception {
        AdminConsole.clearGlobalConfigOverrides();
        try {
            log.info((Object)testURL);
            if (config.getBoolean((Object)"autotest.restore.db", true) && restoreDBList.size() != 0) {
                log.info((Object)("autotest.restore.db flag is set, restoring database(s): " + DataTools.prettyPrint(restoreDBList)));
                long start = new Date().getTime();
                AdminConsole.restoreDB(restoreDBList);
                long end = new Date().getTime();
                log.info((Object)("restore complete - took: " + (end - start) + "ms"));
            }
        }
        finally {
            restoreDBList.clear();
            try {
                AdminConsole.setDefaultDB(config.getString((Object)"autotest.instance.defaultDatabase"));
            }
            finally {
                config.clearSubtree("autotest.instance");
            }
        }
    }

    public static void snapshotDB(List<String> dbList) throws Exception {
        for (String dbName : dbList) {
            String dbSnapshotFilename = SQLDriver.createSnapshot((String)dbName);
            dbSnapshotFileList.add(dbSnapshotFilename);
        }
    }

    public static void restoreDB(List<String> dbList) throws Exception {
        Exception e = null;
        for (String dbName : dbList) {
            try {
                SQLDriver.restoreFromSnapshot((String)dbName);
            }
            catch (Exception ee) {
                if (e == null) continue;
                e = ee;
            }
        }
        for (String dbSnapshotFilename : dbSnapshotFileList) {
            try {
                new File(dbSnapshotFilename).delete();
            }
            catch (Exception exception) {}
        }
        if (e != null) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RPCResponse importDataSources(List dsList, boolean importTestData, boolean replaceTables) throws Exception {
        RPCResponse result = new RPCResponse();
        if (replaceTables) {
            boolean atLeastOneHB = false;
            for (String dsName : dsList) {
                DataSource ds = DataSourceManager.get((String)dsName, null);
                try {
                    String catalog;
                    String dbName;
                    if (ds == null) continue;
                    if ("hibernate".equals(ds.getType())) {
                        atLeastOneHB = true;
                    }
                    if ((dbName = (String)ds.getConfig().get((Object)"dbName")) == null) {
                        dbName = config.getString((Object)"sql.defaultDatabase");
                    }
                    if ((catalog = config.getString((Object)("sql." + dbName + ".driver.databaseName"))) != null) continue;
                    catalog = config.getString((Object)("sql." + dbName + ".driver.url"));
                    if (catalog == null) {
                        catalog = "isomorphic";
                        continue;
                    }
                    catalog = catalog.substring(catalog.lastIndexOf("/") + 1);
                }
                finally {
                    DataSourceManager.free((DataSource)ds);
                }
            }
            if (atLeastOneHB) {
                SQLImport.recreateHibernateSchema();
                List allDSList = BuiltinRPC.getDefinedDataSourcesAsList();
                for (Map dsDef : allDSList) {
                    if (!"hibernate".equals(dsDef.get("dsType")) || dsList.contains(dsDef.get("dsName"))) continue;
                    dsList.add(dsDef.get("dsName"));
                }
            }
        }
        boolean bl = SQLImport.schemaOnly = !importTestData;
        if (replaceTables) {
            SQLImport.dropTables = true;
            SQLImport.createTables = true;
        } else {
            SQLImport.dropTables = false;
            SQLImport.createTables = false;
        }
        ArrayList<String> successful = new ArrayList<String>();
        ArrayList<String> failedCVE = new ArrayList<String>();
        for (String dsName : dsList) {
            try {
                if (!SQLImport.processDataSource(dsName)) continue;
                successful.add(dsName);
            }
            catch (ConstraintViolationException cve) {
                failedCVE.add(dsName);
            }
            catch (Exception ee) {
                String exceptionStackTrace = DataTools.getStackTrace((Throwable)ee);
                String error = "There was a problem importing datasource '" + dsName + "'.  The error report below may indicate what the problem was.";
                log.error((Object)error, (Throwable)ee);
                result.setStatus(-1);
                result.setData((Object)(error + "\n\n" + exceptionStackTrace));
                return result;
            }
        }
        for (String dsName : failedCVE) {
            try {
                if (!SQLImport.processDataSource(dsName)) continue;
                successful.add(dsName);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        String message = "DataSources imported: " + successful;
        if (successful.size() != dsList.size()) {
            dsList.removeAll(successful);
            message = message + "\nThe following DataSources could not be imported: " + dsList + ".  Check the server log for details.";
        }
        result.setData((Object)message);
        return result;
    }

    public boolean tableExists(String tableName, String schema) throws Exception {
        SQLDriver sqlDriver = SQLDriver.instance();
        return sqlDriver.tableExists(tableName, schema);
    }

    static class SQLTestWarningException
    extends SQLTestException {
        public SQLTestWarningException(String error, Exception e) {
            super(error, e);
        }
    }
}

