/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.view.client;

import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SetSelectionModel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MultiSelectionModel<T>
extends SelectionModel.AbstractSelectionModel<T>
implements SetSelectionModel<T> {
    final Map<Object, T> selectedSet;
    private final Map<Object, SelectionChange<T>> selectionChanges;

    public MultiSelectionModel() {
        this(null);
    }

    public MultiSelectionModel(ProvidesKey<T> keyProvider) {
        this(keyProvider, new HashMap(), new HashMap<Object, SelectionChange<T>>());
    }

    MultiSelectionModel(ProvidesKey<T> keyProvider, Map<Object, T> selectedSet, Map<Object, SelectionChange<T>> selectionChanges) {
        super(keyProvider);
        this.selectedSet = selectedSet;
        this.selectionChanges = selectionChanges;
    }

    @Override
    public void clear() {
        this.selectionChanges.clear();
        for (T value : this.selectedSet.values()) {
            this.selectionChanges.put(this.getKey(value), new SelectionChange<T>(value, false));
        }
        this.scheduleSelectionChangeEvent();
    }

    @Override
    public Set<T> getSelectedSet() {
        this.resolveChanges();
        return new HashSet<T>(this.selectedSet.values());
    }

    @Override
    public boolean isSelected(T item) {
        this.resolveChanges();
        return this.selectedSet.containsKey(this.getKey(item));
    }

    @Override
    public void setSelected(T item, boolean selected) {
        this.selectionChanges.put(this.getKey(item), new SelectionChange<T>(item, selected));
        this.scheduleSelectionChangeEvent();
    }

    @Override
    protected void fireSelectionChangeEvent() {
        if (this.isEventScheduled()) {
            this.setEventCancelled(true);
        }
        this.resolveChanges();
    }

    void resolveChanges() {
        if (this.selectionChanges.isEmpty()) {
            return;
        }
        boolean changed = false;
        for (Map.Entry<Object, SelectionChange<T>> entry : this.selectionChanges.entrySet()) {
            Object key = entry.getKey();
            SelectionChange<T> value = entry.getValue();
            boolean selected = ((SelectionChange)value).isSelected;
            T oldValue = this.selectedSet.get(key);
            if (selected) {
                this.selectedSet.put(key, ((SelectionChange)value).item);
                Object oldKey = this.getKey(oldValue);
                if (changed) continue;
                changed = oldKey == null ? key != null : !oldKey.equals(key);
                continue;
            }
            if (oldValue == null) continue;
            this.selectedSet.remove(key);
            changed = true;
        }
        this.selectionChanges.clear();
        if (changed) {
            SelectionChangeEvent.fire(this);
        }
    }

    static class SelectionChange<T> {
        private final T item;
        private final boolean isSelected;

        SelectionChange(T item, boolean isSelected) {
            this.item = item;
            this.isSelected = isSelected;
        }

        public T getItem() {
            return this.item;
        }

        public boolean isSelected() {
            return this.isSelected;
        }
    }
}

