/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.cell.client;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.i18n.shared.DateTimeFormat;
import com.google.gwt.i18n.shared.TimeZone;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.text.shared.SafeHtmlRenderer;
import com.google.gwt.text.shared.SimpleSafeHtmlRenderer;
import java.util.Date;

public class DateCell
extends AbstractCell<Date> {
    private final DateTimeFormat format;
    private final SafeHtmlRenderer<String> renderer;
    private final TimeZone timeZone;

    public DateCell() {
        this(DateTimeFormat.getFormat(DateTimeFormat.PredefinedFormat.DATE_FULL), SimpleSafeHtmlRenderer.getInstance(), null);
    }

    public DateCell(SafeHtmlRenderer<String> renderer) {
        this(DateTimeFormat.getFormat(DateTimeFormat.PredefinedFormat.DATE_FULL), renderer, null);
    }

    public DateCell(DateTimeFormat format) {
        this(format, SimpleSafeHtmlRenderer.getInstance(), null);
    }

    public DateCell(DateTimeFormat format, SafeHtmlRenderer<String> renderer) {
        this(format, renderer, null);
    }

    public DateCell(DateTimeFormat format, TimeZone timeZone) {
        this(format, SimpleSafeHtmlRenderer.getInstance(), timeZone);
    }

    public DateCell(DateTimeFormat format, SafeHtmlRenderer<String> renderer, TimeZone timeZone) {
        super(new String[0]);
        if (format == null) {
            throw new IllegalArgumentException("format == null");
        }
        if (renderer == null) {
            throw new IllegalArgumentException("renderer == null");
        }
        this.format = format;
        this.renderer = renderer;
        this.timeZone = timeZone;
    }

    @Override
    public void render(Cell.Context context, Date value, SafeHtmlBuilder sb) {
        if (value != null) {
            sb.append(this.renderer.render(this.format.format(value, this.timeZone)));
        }
    }
}

