/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler.internal;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.server.KnownElements;

public class ArgumentConverter
implements Function<Object, Object> {
    private final KnownElements knownElements;

    public ArgumentConverter(KnownElements knownElements) {
        this.knownElements = knownElements;
    }

    public Object apply(Object arg) {
        if (arg instanceof Map) {
            Map paramAsMap = (Map)arg;
            if (paramAsMap.containsKey("ELEMENT")) {
                KnownElements.ProxiedElement element = (KnownElements.ProxiedElement)((Object)this.knownElements.get((String)paramAsMap.get("ELEMENT")));
                return element.getWrappedElement();
            }
            HashMap converted = Maps.newHashMapWithExpectedSize((int)paramAsMap.size());
            for (Map.Entry entry : paramAsMap.entrySet()) {
                converted.put(entry.getKey(), this.apply(entry.getValue()));
            }
            return converted;
        }
        if (arg instanceof RemoteWebElement) {
            return this.knownElements.get(((RemoteWebElement)arg).getId());
        }
        if (arg instanceof List) {
            return Lists.newArrayList((Iterable)Iterables.transform((Iterable)((List)arg), (Function)this));
        }
        return arg;
    }
}

