/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import com.isomorphic.pool.IPoolableObjectFactory;
import com.isomorphic.pool.ISCObjectPool;
import com.isomorphic.pool.ISCPoolableObjectFactory;
import com.isomorphic.sql.SQLDriver;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbcp.PoolableConnection;
import org.apache.commons.pool.ObjectPool;

public class PoolableSQLConnectionFactory
extends ISCPoolableObjectFactory {
    private static Logger log = new Logger(PoolableSQLConnectionFactory.class.getName());
    private static Config config = Config.getGlobal();
    private String dbName;
    private SQLDriver driver;
    private String pingTest;
    private int pingTestTimeout;
    private boolean autoDeriveConfig = false;
    private long nanosPassivating = 0L;

    public IPoolableObjectFactory newInstance(Object key) throws Exception {
        return new PoolableSQLConnectionFactory(key.toString());
    }

    public PoolableSQLConnectionFactory() {
    }

    public PoolableSQLConnectionFactory(String dbName) throws Exception {
        this.dbName = dbName;
        this.driver = SQLDriver.instance(dbName);
        Config sqlConfig = this.driver.getSqlConfig();
        if ("jndi".equals(sqlConfig.getString((Object)"interface.type"))) {
            if (!config.getBoolean((Object)("sql." + dbName + ".pool.enabled"), false)) {
                this.poolDisabled = Boolean.TRUE;
            }
        } else if (sqlConfig.getBoolean((Object)"pool.enabled", false)) {
            this.poolDisabled = Boolean.FALSE;
        }
        this.pingTest = sqlConfig.getString((Object)"pingTest");
        this.pingTestTimeout = sqlConfig.getInt((Object)"validationQueryTimeout", 10);
    }

    public void activateObject(Object obj) throws Exception {
        ++this.numActivateObjectCalls;
        if (obj instanceof ISCPoolableConnection) {
            ((ISCPoolableConnection)((Object)obj)).activate();
        }
    }

    public void destroyObject(Object obj) throws Exception {
        ++this.numDestroyObjectCalls;
        try {
            if (obj instanceof PoolableConnection) {
                ((PoolableConnection)obj).reallyClose();
            } else {
                ((Connection)obj).close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Object makeUnpooledObject() throws Exception {
        return this.driver.rawConnection();
    }

    public Object makeObject() throws Exception {
        ++this.numMakeObjectCalls;
        Connection conn = (Connection)this.makeUnpooledObject();
        if (conn == null) {
            throw new Exception("Error: unable to obtain a database connection");
        }
        if (this.pool == null) {
            log.debug((Object)("makeObject() created an unpooled Connection '" + conn.hashCode() + "'"));
            return conn;
        }
        log.debug((Object)("makeObject() created a pooled Connection '" + conn.hashCode() + "'"));
        return new ISCPoolableConnection(conn, (ISCObjectPool)this.pool){};
    }

    public void passivateObject(Object obj) throws Exception {
        ++this.numPassivateObjectCalls;
        if (obj instanceof ISCPoolableConnection) {
            long before = System.nanoTime();
            ((ISCPoolableConnection)((Object)obj)).passivate();
            this.nanosPassivating += System.nanoTime() - before;
        }
    }

    public void logPassivateStats() {
        log.warn((Object)("Made " + this.numPassivateObjectCalls + " passivate calls in " + this.nanosPassivating + "us"));
    }

    public boolean validateObject(Object obj) {
        ++this.numValidateObjectCalls;
        Connection conn = (Connection)obj;
        Statement s = null;
        try {
            if (conn.isClosed()) {
                log.debug((Object)"Connection was already closed in validateObject - returning false");
                return false;
            }
            if (this.pingTest != null) {
                s = conn.createStatement();
                s.setQueryTimeout(this.pingTestTimeout);
                log.debug((Object)("Executing pingTest '" + this.pingTest + "' on connection " + obj.hashCode()));
                s.executeQuery(this.pingTest);
                s.close();
            }
            return true;
        }
        catch (SQLException e) {
            log.warn((Object)("Exception running pingTest: " + e.getMessage()));
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception ignored) {
                log.debug((Object)("Failed to close statement " + obj.hashCode() + ": " + ignored.getMessage()));
                ignored.printStackTrace();
            }
            return false;
        }
    }

    private static class ISCPoolableConnection
    extends PoolableConnection {
        public ISCPoolableConnection(Connection conn, ISCObjectPool pool) {
            super(conn, (ObjectPool)pool);
        }

        public void passivate() throws SQLException {
            super.passivate();
        }

        public void activate() {
            super.activate();
        }
    }
}

