/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.packaging;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.hibernate.ejb.packaging.NamedInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceMetadata {
    private String name;
    private String nonJtaDatasource;
    private String jtaDatasource;
    private String provider;
    private PersistenceUnitTransactionType transactionType;
    private boolean useQuotedIdentifiers = false;
    private List<String> classes = new ArrayList<String>();
    private List<String> packages = new ArrayList<String>();
    private List<String> mappingFiles = new ArrayList<String>();
    private Set<String> jarFiles = new HashSet<String>();
    private List<NamedInputStream> hbmfiles = new ArrayList<NamedInputStream>();
    private Properties props = new Properties();
    private boolean excludeUnlistedClasses = false;
    private String validationMode;
    private String version;
    private String sharedCacheMode;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getSharedCacheMode() {
        return this.sharedCacheMode;
    }

    public boolean isExcludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(PersistenceUnitTransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public String getNonJtaDatasource() {
        return this.nonJtaDatasource;
    }

    public void setNonJtaDatasource(String nonJtaDatasource) {
        this.nonJtaDatasource = nonJtaDatasource;
    }

    public String getJtaDatasource() {
        return this.jtaDatasource;
    }

    public void setJtaDatasource(String jtaDatasource) {
        this.jtaDatasource = jtaDatasource;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        if (provider != null && provider.endsWith(".class")) {
            this.provider = provider.substring(0, provider.length() - 6);
        }
        this.provider = provider;
    }

    public boolean isUseQuotedIdentifiers() {
        return this.useQuotedIdentifiers;
    }

    public void setUseQuotedIdentifiers(boolean useQuotedIdentifiers) {
        this.useQuotedIdentifiers = useQuotedIdentifiers;
    }

    public List<String> getClasses() {
        return this.classes;
    }

    public void setClasses(List<String> classes) {
        this.classes = classes;
    }

    public List<String> getPackages() {
        return this.packages;
    }

    public void setPackages(List<String> packages) {
        this.packages = packages;
    }

    public List<String> getMappingFiles() {
        return this.mappingFiles;
    }

    public void setMappingFiles(List<String> mappingFiles) {
        this.mappingFiles = mappingFiles;
    }

    public Set<String> getJarFiles() {
        return this.jarFiles;
    }

    public void setJarFiles(Set<String> jarFiles) {
        this.jarFiles = jarFiles;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public List<NamedInputStream> getHbmfiles() {
        return this.hbmfiles;
    }

    public void setHbmfiles(List<NamedInputStream> hbmfiles) {
        this.hbmfiles = hbmfiles;
    }

    public boolean getExcludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    public void setExcludeUnlistedClasses(boolean excludeUnlistedClasses) {
        this.excludeUnlistedClasses = excludeUnlistedClasses;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PersistenceMetadata(version=").append(this.version).append(") [\n").append("\tname: ").append(this.name).append("\n").append("\tjtaDataSource: ").append(this.jtaDatasource).append("\n").append("\tnonJtaDataSource: ").append(this.nonJtaDatasource).append("\n").append("\ttransactionType: ").append(this.transactionType).append("\n").append("\tprovider: ").append(this.provider).append("\n").append("\tuseQuotedIdentifiers: ").append(this.useQuotedIdentifiers).append("\n").append("\tclasses[\n");
        if (this.classes != null) {
            for (String string : this.classes) {
                sb.append("\t\t").append(string);
            }
        }
        sb.append("\t]\n").append("\tpackages[\n");
        if (this.packages != null) {
            for (String string : this.packages) {
                sb.append("\t\t").append(string).append("\n");
            }
        }
        sb.append("\t]\n").append("\tmappingFiles[\n");
        if (this.mappingFiles != null) {
            for (String string : this.mappingFiles) {
                sb.append("\t\t").append(string).append("\n");
            }
        }
        sb.append("\t]\n").append("\tjarFiles[\n");
        if (this.jarFiles != null) {
            for (String string : this.jarFiles) {
                sb.append("\t\t").append(string).append("\n");
            }
        }
        sb.append("\t]\n").append("\thbmfiles: ").append(this.hbmfiles != null ? this.hbmfiles.size() : 0).append("\n");
        if (this.validationMode != null) {
            sb.append("\tvalidation-mode: ").append(this.validationMode).append("\n");
        }
        if (this.sharedCacheMode != null) {
            sb.append("\tshared-cache-mode: ").append(this.sharedCacheMode).append("\n");
        }
        sb.append("\tproperties[\n");
        if (this.props != null) {
            for (Map.Entry entry : this.props.entrySet()) {
                sb.append("\t\t").append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
        }
        sb.append("\t]").append("]");
        return sb.toString();
    }

    public void setValidationMode(String validationMode) {
        this.validationMode = validationMode;
    }

    public String getValidationMode() {
        return this.validationMode;
    }

    public void setSharedCacheMode(String sharedCacheMode) {
        this.sharedCacheMode = sharedCacheMode;
    }
}

