/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.rpc;

import com.isomorphic.base.Base;
import com.isomorphic.log.Logger;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class OOXMLDataExport
extends Base {
    private static Logger log = new Logger(OOXMLDataExport.class.getName());

    static Workbook getXSSFWorkbook(boolean streaming) throws Exception {
        if (streaming) {
            return OOXMLDataExport.getSXSSFWorkbook();
        }
        return new XSSFWorkbook();
    }

    static Workbook getSXSSFWorkbook() throws Exception {
        int rows = config.getInt("excel.streamingWindow", 100);
        return new SXSSFWorkbook(rows);
    }

    static RichTextString getXSSFRichTextString(String value) {
        return new XSSFRichTextString(value);
    }

    static void disposeWorkbook(Workbook workbook) {
        if (workbook instanceof SXSSFWorkbook) {
            ((SXSSFWorkbook)workbook).dispose();
        } else {
            log.warn("disposeWorkbook called for an unexpected workbook type (type of object is " + workbook.getClass().getCanonicalName() + ")");
        }
    }
}

