/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.auth;

import com.isomorphic.auth.IAuthenticator;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.js.IToJSON;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AuthenticatedUser
extends DataTypeMap
implements Principal,
Serializable,
IToJSON {
    private static Logger log = new Logger(AuthenticatedUser.class.getName());
    private static final String userNameField = "isc_username";
    private static final String realUserNameField = "isc_real_username";
    private List<String> clientSafeFields;
    private List<String> roles = new ArrayList<String>();
    private String superUserRole;

    public AuthenticatedUser() {
    }

    public AuthenticatedUser(String username, IAuthenticator authenticator) {
        this(username, new HashMap(), authenticator);
    }

    public AuthenticatedUser(String username, Map userData, IAuthenticator authenticator) {
        super(userData);
        if (authenticator == null) {
            this.clientSafeFields = new ArrayList<String>();
        } else {
            this.clientSafeFields = authenticator.getClientSafeFields();
            this.superUserRole = authenticator.getSuperUserRole();
            try {
                this.roles = authenticator.getUserRoles(userData);
            }
            catch (Exception e) {
                log.error((Object)"Failed to obtain user roles", e);
            }
        }
        this.put(userNameField, username);
        if (!this.clientSafeFields.contains(userNameField)) {
            this.clientSafeFields.add(userNameField);
        }
        this.put(realUserNameField, username);
        if (!this.clientSafeFields.contains(realUserNameField)) {
            this.clientSafeFields.add(realUserNameField);
        }
    }

    public String getUserName() {
        return this.getString(userNameField);
    }

    public String getRealUserName() {
        return this.getString(realUserNameField, this.getUserName());
    }

    public void setRealUserName(String realName) {
        this.put(realUserNameField, realName);
    }

    public boolean isMasquerading() {
        return this.getRealUserName() != null && !this.getUserName().equals(this.getRealUserName());
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof AuthenticatedUser)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return this.getName().equals(((AuthenticatedUser)o).getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " (" + this.getName() + ")";
    }

    @Override
    public void toJSON(Writer out, JSTranslater jsTrans) throws UnconvertableException, IOException {
        jsTrans.toJS((Object)this.clientSafeMap(), out);
    }

    public DataTypeMap clientSafeMap() {
        HashMap clientSafeMap = new HashMap(this);
        DataTools.divideMap(clientSafeMap, this.clientSafeFields);
        return new DataTypeMap(clientSafeMap);
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public boolean inRole(String role) {
        if (role == null) {
            return false;
        }
        return this.roles.contains(role);
    }

    public boolean isSuper() {
        return this.isSuperUser();
    }

    public boolean isSuperUser() {
        return this.inRole(this.superUserRole);
    }

    public boolean canMasquerade() {
        return this.isSuper() || this.isMasquerading();
    }

    @Override
    public String getName() {
        return this.getUserName();
    }
}

