/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.LogSupport;

public class TypeUtil {
    private static Log log = LogFactory.getLog(TypeUtil.class);
    private static final HashMap name2Class = new HashMap();
    private static final HashMap class2Name;
    private static final HashMap class2Value;
    private static Class[] stringArg;
    private static int intCacheSize;
    private static Integer[] integerCache;
    private static String[] integerStrCache;
    private static Integer minusOne;

    static {
        name2Class.put("boolean", Boolean.TYPE);
        name2Class.put("byte", Byte.TYPE);
        name2Class.put("char", Character.TYPE);
        name2Class.put("double", Double.TYPE);
        name2Class.put("float", Float.TYPE);
        name2Class.put("int", Integer.TYPE);
        name2Class.put("long", Long.TYPE);
        name2Class.put("short", Short.TYPE);
        name2Class.put("void", Void.TYPE);
        name2Class.put("java.lang.Boolean.TYPE", Boolean.TYPE);
        name2Class.put("java.lang.Byte.TYPE", Byte.TYPE);
        name2Class.put("java.lang.Character.TYPE", Character.TYPE);
        name2Class.put("java.lang.Double.TYPE", Double.TYPE);
        name2Class.put("java.lang.Float.TYPE", Float.TYPE);
        name2Class.put("java.lang.Integer.TYPE", Integer.TYPE);
        name2Class.put("java.lang.Long.TYPE", Long.TYPE);
        name2Class.put("java.lang.Short.TYPE", Short.TYPE);
        name2Class.put("java.lang.Void.TYPE", Void.TYPE);
        name2Class.put("java.lang.Boolean", Boolean.class);
        name2Class.put("java.lang.Byte", Byte.class);
        name2Class.put("java.lang.Character", Character.class);
        name2Class.put("java.lang.Double", Double.class);
        name2Class.put("java.lang.Float", Float.class);
        name2Class.put("java.lang.Integer", Integer.class);
        name2Class.put("java.lang.Long", Long.class);
        name2Class.put("java.lang.Short", Short.class);
        name2Class.put("Boolean", Boolean.class);
        name2Class.put("Byte", Byte.class);
        name2Class.put("Character", Character.class);
        name2Class.put("Double", Double.class);
        name2Class.put("Float", Float.class);
        name2Class.put("Integer", Integer.class);
        name2Class.put("Long", Long.class);
        name2Class.put("Short", Short.class);
        name2Class.put(null, Void.TYPE);
        name2Class.put("string", String.class);
        name2Class.put("String", String.class);
        name2Class.put("java.lang.String", String.class);
        class2Name = new HashMap();
        class2Name.put(Boolean.TYPE, "boolean");
        class2Name.put(Byte.TYPE, "byte");
        class2Name.put(Character.TYPE, "char");
        class2Name.put(Double.TYPE, "double");
        class2Name.put(Float.TYPE, "float");
        class2Name.put(Integer.TYPE, "int");
        class2Name.put(Long.TYPE, "long");
        class2Name.put(Short.TYPE, "short");
        class2Name.put(Void.TYPE, "void");
        class2Name.put(Boolean.class, "java.lang.Boolean");
        class2Name.put(Byte.class, "java.lang.Byte");
        class2Name.put(Character.class, "java.lang.Character");
        class2Name.put(Double.class, "java.lang.Double");
        class2Name.put(Float.class, "java.lang.Float");
        class2Name.put(Integer.class, "java.lang.Integer");
        class2Name.put(Long.class, "java.lang.Long");
        class2Name.put(Short.class, "java.lang.Short");
        class2Name.put(null, "void");
        name2Class.put(String.class, "java.lang.String");
        class2Value = new HashMap();
        try {
            Class[] s = new Class[]{String.class};
            class2Value.put(Boolean.TYPE, Boolean.class.getMethod("valueOf", s));
            class2Value.put(Byte.TYPE, Byte.class.getMethod("valueOf", s));
            class2Value.put(Double.TYPE, Double.class.getMethod("valueOf", s));
            class2Value.put(Float.TYPE, Float.class.getMethod("valueOf", s));
            class2Value.put(Integer.TYPE, Integer.class.getMethod("valueOf", s));
            class2Value.put(Long.TYPE, Long.class.getMethod("valueOf", s));
            class2Value.put(Short.TYPE, Short.class.getMethod("valueOf", s));
            class2Value.put(Boolean.class, Boolean.class.getMethod("valueOf", s));
            class2Value.put(Byte.class, Byte.class.getMethod("valueOf", s));
            class2Value.put(Double.class, Double.class.getMethod("valueOf", s));
            class2Value.put(Float.class, Float.class.getMethod("valueOf", s));
            class2Value.put(Integer.class, Integer.class.getMethod("valueOf", s));
            class2Value.put(Long.class, Long.class.getMethod("valueOf", s));
            class2Value.put(Short.class, Short.class.getMethod("valueOf", s));
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
        stringArg = new Class[]{String.class};
        intCacheSize = Integer.getInteger("org.openqa.jetty.util.TypeUtil.IntegerCacheSize", 600);
        integerCache = new Integer[intCacheSize];
        integerStrCache = new String[intCacheSize];
        minusOne = new Integer(-1);
    }

    public static Class fromName(String name) {
        return (Class)name2Class.get(name);
    }

    public static String toName(Class type) {
        return (String)class2Name.get(type);
    }

    public static Object valueOf(Class type, String value) {
        try {
            if (type.equals(String.class)) {
                return value;
            }
            Method m = (Method)class2Value.get(type);
            if (m != null) {
                return m.invoke(null, value);
            }
            if (type.equals(Character.TYPE) || type.equals(Character.class)) {
                return new Character(value.charAt(0));
            }
            Constructor c = type.getConstructor(stringArg);
            return c.newInstance(value);
        }
        catch (NoSuchMethodException e) {
            LogSupport.ignore(log, e);
        }
        catch (IllegalAccessException e) {
            LogSupport.ignore(log, e);
        }
        catch (InstantiationException e) {
            LogSupport.ignore(log, e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            LogSupport.ignore(log, e);
        }
        return null;
    }

    public static Object valueOf(String type, String value) {
        return TypeUtil.valueOf(TypeUtil.fromName(type), value);
    }

    public static Integer newInteger(int i) {
        if (i >= 0 && i < intCacheSize) {
            if (integerCache[i] == null) {
                TypeUtil.integerCache[i] = new Integer(i);
            }
            return integerCache[i];
        }
        if (i == -1) {
            return minusOne;
        }
        return new Integer(i);
    }

    public static String toString(int i) {
        if (i >= 0 && i < intCacheSize) {
            if (integerStrCache[i] == null) {
                TypeUtil.integerStrCache[i] = Integer.toString(i);
            }
            return integerStrCache[i];
        }
        if (i == -1) {
            return "-1";
        }
        return Integer.toString(i);
    }

    public static int parseInt(String s, int offset, int length, int base) throws NumberFormatException {
        int value = 0;
        if (length < 0) {
            length = s.length() - offset;
        }
        int i = 0;
        while (i < length) {
            char c = s.charAt(offset + i);
            int digit = c - 48;
            if (!(digit >= 0 && digit < base && digit < 10 || (digit = 10 + c - 65) >= 10 && digit < base)) {
                digit = 10 + c - 97;
            }
            if (digit < 0 || digit >= base) {
                throw new NumberFormatException(s.substring(offset, offset + length));
            }
            value = value * base + digit;
            ++i;
        }
        return value;
    }

    public static byte[] parseBytes(String s, int base) {
        byte[] bytes = new byte[s.length() / 2];
        int i = 0;
        while (i < s.length()) {
            bytes[i / 2] = (byte)TypeUtil.parseInt(s, i, 2, base);
            i += 2;
        }
        return bytes;
    }

    public static String toString(byte[] bytes, int base) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            int bi = 0xFF & bytes[i];
            int c = 48 + bi / base % base;
            if (c > 57) {
                c = 97 + (c - 48 - 10);
            }
            buf.append((char)c);
            c = 48 + bi % base;
            if (c > 57) {
                c = 97 + (c - 48 - 10);
            }
            buf.append((char)c);
            ++i;
        }
        return buf.toString();
    }

    public static byte convertHexDigit(byte b) {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(b - 97 + 10);
        }
        if (b >= 65 && b <= 70) {
            return (byte)(b - 65 + 10);
        }
        return 0;
    }

    public static char toHexChar(int b) {
        return (char)(b < 10 ? 48 + b : 65 + b - 10);
    }

    public static String toHexString(byte[] b) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            int bi = 0xFF & b[i];
            int c = 48 + bi / 16 % 16;
            if (c > 57) {
                c = 65 + (c - 48 - 10);
            }
            buf.append((char)c);
            c = 48 + bi % 16;
            if (c > 57) {
                c = 97 + (c - 48 - 10);
            }
            buf.append((char)c);
            ++i;
        }
        return buf.toString();
    }

    public static String toHexString(byte[] b, int offset, int length) {
        StringBuffer buf = new StringBuffer();
        int i = offset;
        while (i < offset + length) {
            int bi = 0xFF & b[i];
            int c = 48 + bi / 16 % 16;
            if (c > 57) {
                c = 65 + (c - 48 - 10);
            }
            buf.append((char)c);
            c = 48 + bi % 16;
            if (c > 57) {
                c = 97 + (c - 48 - 10);
            }
            buf.append((char)c);
            ++i;
        }
        return buf.toString();
    }

    public static byte[] fromHexString(String s) {
        if (s.length() % 2 != 0) {
            throw new IllegalArgumentException(s);
        }
        byte[] array = new byte[s.length() / 2];
        int i = 0;
        while (i < array.length) {
            int b = Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16);
            array[i] = (byte)(0xFF & b);
            ++i;
        }
        return array;
    }

    public static void dump(Class c) {
        System.err.println("Dump: " + c);
        TypeUtil.dump(c.getClassLoader());
    }

    public static void dump(ClassLoader cl) {
        System.err.println("Dump Loaders:");
        while (cl != null) {
            System.err.println("  loader " + cl);
            cl = cl.getParent();
        }
    }
}

