/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp.services;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.protobuf.AbstractMessage;
import com.opera.core.systems.internal.ImplicitWait;
import com.opera.core.systems.internal.StackHashMap;
import com.opera.core.systems.internal.VersionUtil;
import com.opera.core.systems.scope.AbstractService;
import com.opera.core.systems.scope.ScopeServices;
import com.opera.core.systems.scope.exceptions.ScopeException;
import com.opera.core.systems.scope.exceptions.WindowNotFoundException;
import com.opera.core.systems.scope.internal.OperaIntervals;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.protos.WmProtos;
import com.opera.core.systems.scope.services.WindowManager;
import com.opera.core.systems.scope.stp.services.messages.WindowManagerMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.jxpath.CompiledExpression;
import org.apache.commons.jxpath.JXPathContext;
import org.openqa.selenium.NoSuchWindowException;

public class ScopeWindowManager
extends AbstractService
implements WindowManager {
    public static final String CLOSE_ALL_PAGES_ACTION = "Close all pages";
    public static final CompiledExpression WINDOW_FINDER_EXPRESSION = JXPathContext.compile((String)"/.[windowType='normal']/windowID");
    private final StackHashMap<Integer, WmProtos.WindowInfo> windows = new StackHashMap();
    private final AtomicInteger lastHttpResponseCode = new AtomicInteger();

    public ScopeWindowManager(ScopeServices services) {
        super(services, "window-manager");
        services.setWindowManager(this);
    }

    @Override
    public AtomicInteger getLastHttpResponseCode() {
        return this.lastHttpResponseCode;
    }

    @Override
    public int getOpenWindowCount() {
        return this.windows.size();
    }

    @Override
    public void setActiveWindowId(Integer windowId) {
        this.windows.putIfAbsent(windowId, null);
    }

    @Override
    public int getActiveWindowId() {
        Integer windowID = this.windows.peekKey();
        if (windowID == null) {
            return this.findActiveWindow().getWindowID();
        }
        return windowID;
    }

    @Override
    public void addWindow(WmProtos.WindowInfo info) {
        this.windows.put(info.getWindowID(), info);
    }

    @Override
    public void removeWindow(Integer windowId) {
        this.windows.remove(windowId);
    }

    @Override
    public void init() {
        this.initializeWindows();
        this.findDriverWindow();
    }

    @Override
    public void findDriverWindow() {
        JXPathContext pathContext = JXPathContext.newContext(this.windows.values());
        WmProtos.WindowInfo window = this.windows.peek();
        if (window == null || !window.getWindowType().equals("normal")) {
            Integer windowId = (Integer)WINDOW_FINDER_EXPRESSION.getValue(pathContext);
            if (windowId == null) {
                throw new WindowNotFoundException("No window is available for driving");
            }
            this.setActiveWindowId(windowId);
            this.filterActiveWindow();
        }
    }

    private WmProtos.WindowID findActiveWindow() {
        if (this.services.getCore().getProduct().equalsIgnoreCase("mobile")) {
            ScopeWindowManager.sleep(100L);
        }
        UmsProtos.Response response = this.executeMessage(WindowManagerMessage.GET_ACTIVE_WINDOW, null);
        WmProtos.WindowID.Builder builder = WmProtos.WindowID.newBuilder();
        ScopeWindowManager.buildPayload(response, builder);
        return builder.build();
    }

    @Override
    public void filterActiveWindow() {
        WmProtos.WindowFilter.Builder filterBuilder = WmProtos.WindowFilter.newBuilder();
        filterBuilder.setClearFilter(true);
        filterBuilder.addIncludeIDList(this.getActiveWindowId());
        this.executeMessage(WindowManagerMessage.MODIFY_FILTER, (AbstractMessage.Builder<?>)filterBuilder);
    }

    private void initializeWindows() {
        this.clearFilter();
        UmsProtos.Response response = this.executeMessage(WindowManagerMessage.LIST_WINDOWS, null);
        WmProtos.WindowList.Builder builder = WmProtos.WindowList.newBuilder();
        ScopeWindowManager.buildPayload(response, builder);
        WmProtos.WindowList list = builder.build();
        List<WmProtos.WindowInfo> windowsList = list.getWindowListList();
        this.windows.clear();
        for (WmProtos.WindowInfo window : windowsList) {
            this.windows.put(window.getWindowID(), window);
        }
        this.windows.putIfAbsent(this.findActiveWindow().getWindowID(), null);
    }

    @Override
    public void setActiveWindow(String title) {
        Integer windowId = (Integer)this.xpathPointer(this.windows.values(), "/.[title='" + title + "']/windowID").getValue();
        if (windowId == null) {
            throw new NoSuchWindowException("No such window: " + title);
        }
        this.setActiveWindowId(windowId);
    }

    @Override
    public void createWindow() {
        UmsProtos.Response response = this.executeMessage(WindowManagerMessage.CREATE_WINDOW, null);
        WmProtos.WindowID.Builder builder = WmProtos.WindowID.newBuilder();
        ScopeWindowManager.buildPayload(response, builder);
        this.openUrl(builder.build().getWindowID(), "opera:debug");
    }

    @Override
    public List<Integer> getWindowHandles() {
        return ImmutableList.copyOf(this.windows.asStack());
    }

    @Override
    public void resetWindowsList() {
        this.initializeWindows();
    }

    @Override
    public void clearFilter() {
        WmProtos.WindowFilter.Builder filterBuilder = WmProtos.WindowFilter.newBuilder();
        filterBuilder.setClearFilter(true);
        filterBuilder.addIncludePatternList("*");
        this.executeMessage(WindowManagerMessage.MODIFY_FILTER, (AbstractMessage.Builder<?>)filterBuilder);
    }

    @Override
    public void filterWindow(Integer windowId) {
        WmProtos.WindowFilter.Builder filterBuilder = WmProtos.WindowFilter.newBuilder();
        filterBuilder.setClearFilter(true);
        filterBuilder.addIncludeIDList(windowId);
        this.executeMessage(WindowManagerMessage.MODIFY_FILTER, (AbstractMessage.Builder<?>)filterBuilder);
    }

    @Override
    public void openUrl(int windowId, String url) {
        if (VersionUtil.compare(this.getServiceVersion(), "2.1") < 0) {
            this.services.getExec().action("Go", url);
            return;
        }
        WmProtos.OpenURLArg.Builder openUrlBuilder = WmProtos.OpenURLArg.newBuilder();
        openUrlBuilder.setWindowID(windowId);
        openUrlBuilder.setUrl(url);
        UmsProtos.Response response = this.executeMessage(WindowManagerMessage.OPEN_URL, (AbstractMessage.Builder<?>)openUrlBuilder);
        if (response == null) {
            throw new ScopeException("Internal error while opening " + url);
        }
    }

    @Override
    public void closeWindow(final int windowId) {
        this.assertSupportsClosingWindows();
        WmProtos.CloseWindowArg.Builder closeWindowBuilder = WmProtos.CloseWindowArg.newBuilder();
        closeWindowBuilder.setWindowID(windowId);
        UmsProtos.Response response = this.executeMessage(WindowManagerMessage.CLOSE_WINDOW, (AbstractMessage.Builder<?>)closeWindowBuilder);
        new ImplicitWait(OperaIntervals.WINDOW_CLOSE_TIMEOUT.getValue(), OperaIntervals.INTERNAL_FREQUENCY.getValue()).until(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return !ScopeWindowManager.this.windows.containsKey(windowId);
            }
        });
        if (response == null) {
            throw new ScopeException("Internal error while closing window");
        }
    }

    @Override
    public void closeAllWindows() {
        int toBeClosed = this.windows.size();
        if (this.supportsClosingWindows()) {
            LinkedList list = Lists.newLinkedList(this.windows.asStack());
            while (!list.isEmpty()) {
                this.closeWindow((Integer)list.removeFirst());
            }
        } else if (this.services.getExec().getActionList().contains(CLOSE_ALL_PAGES_ACTION)) {
            this.services.getExec().action(CLOSE_ALL_PAGES_ACTION, new String[0]);
            ScopeWindowManager.sleep(OperaIntervals.WINDOW_CLOSE_USING_ACTION_SLEEP.getMs() * (long)toBeClosed);
        } else {
            throw new UnsupportedOperationException("Product does not support closing windows");
        }
    }

    private boolean supportsClosingWindows() {
        return !this.services.getCore().getProduct().equals("devices") && VersionUtil.compare(this.getServiceVersion(), "2.1") >= 0;
    }

    private void assertSupportsClosingWindows() {
        if (!this.supportsClosingWindows()) {
            throw new UnsupportedOperationException(String.format("Window Manager version %s does not support closing windows", this.getServiceVersion()));
        }
    }
}

