/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.opera.core.systems.OperaUIElement;
import com.opera.core.systems.scope.protos.DesktopWmProtos;
import com.opera.core.systems.scope.services.desktop.DesktopUtils;
import com.opera.core.systems.scope.services.desktop.SystemInput;

public class QuickMenuItem
extends OperaUIElement {
    private final DesktopWmProtos.QuickMenuItemInfo info;
    private final String menu;

    public QuickMenuItem(DesktopWmProtos.QuickMenuItemInfo info, String menu, DesktopUtils desktopUtils, SystemInput systemInputManager) {
        super(systemInputManager, desktopUtils);
        this.info = info;
        this.menu = menu;
    }

    public String getName() {
        if (this.isSeparator()) {
            return "Separator";
        }
        if (this.getActionName().length() > 0) {
            if (this.getActionParameter() != null && this.getActionParameter().length() > 0) {
                return this.getActionName() + ", " + this.getActionParameter();
            }
            return this.getActionName();
        }
        return this.getSubMenu();
    }

    public String getActionName() {
        return this.info.getAction();
    }

    public boolean hasSubMenu() {
        return this.info.getSubmenu() != null && this.info.getSubmenu().length() > 0;
    }

    public String getActionParameter() {
        return this.info.getActionParam();
    }

    public String getSubMenu() {
        return this.info.getSubmenu();
    }

    @Override
    public String getText() {
        return this.getDesktopUtils().removeCR(this.info.getText().replaceAll("&", ""));
    }

    public boolean isEnabled() {
        return this.info.getEnabled();
    }

    public boolean isChecked() {
        return this.info.getChecked();
    }

    public boolean isSeparator() {
        return this.info.getSeparator();
    }

    public boolean isBold() {
        return this.info.getBold();
    }

    public int getRow() {
        return this.info.getRow();
    }

    public String getShortcutLetter() {
        return this.info.getShortcutLetter();
    }

    public String getShortcut() {
        return this.info.getShortcut();
    }

    @Override
    public DesktopWmProtos.DesktopWindowRect getRect() {
        return this.info.getRect();
    }

    public String toString() {
        String str = this.isSeparator() ? "Separator" : (this.getActionName() != null && this.getActionName().length() > 0 ? this.getActionName() : this.getSubMenu());
        return "QuickMenuItem " + str;
    }

    @Override
    public String toFullString() {
        return "QuickMenuItem\n       Item name: " + this.getName() + "\n" + "       text: " + this.getText() + "\n" + "    enabled: " + this.isEnabled() + "\n" + "          x: " + this.getRect().getX() + "\n" + "          y: " + this.getRect().getY() + "\n" + "      width: " + this.getRect().getWidth() + "\n" + "     height: " + this.getRect().getHeight() + " \n";
    }

    public String getMenu() {
        return this.menu;
    }
}

