/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.ClientRect;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

@JsxClasses(value={@JsxClass(isJSObject=false, value={SupportedBrowser.FF}), @JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.IE, SupportedBrowser.EDGE})})
public class ClientRectList
extends SimpleScriptable {
    private final List<ClientRect> clientRects_ = new ArrayList<ClientRect>();

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public ClientRectList() {
    }

    @JsxGetter
    public int getLength() {
        return this.clientRects_.size();
    }

    public final Object get(int index, Scriptable start) {
        if (index >= 0 && index < this.clientRects_.size()) {
            return this.clientRects_.get(index);
        }
        return NOT_FOUND;
    }

    @JsxFunction
    public ClientRect item(int index) {
        if (index >= 0 && index < this.clientRects_.size()) {
            return this.clientRects_.get(index);
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CLIENTRECTLIST_THROWS_IF_ITEM_NOT_FOUND)) {
            throw Context.reportRuntimeError((String)("Invalid index '" + index + "'"));
        }
        return null;
    }

    public void add(ClientRect clientRect) {
        this.clientRects_.add(clientRect);
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (String.class == hint && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CLIENTRECTLIST_DEFAUL_VALUE_FROM_FIRST)) {
            if (this.clientRects_.size() > 0) {
                return this.clientRects_.get(0).getDefaultValue(hint);
            }
            return "";
        }
        return super.getDefaultValue(hint);
    }
}

