/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.embedded;

import javax.sql.DataSource;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseFactory;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;

public class EmbeddedDatabaseFactoryBean
extends EmbeddedDatabaseFactory
implements FactoryBean<DataSource>,
InitializingBean,
DisposableBean {
    private DatabasePopulator databaseCleaner;

    public void setDatabaseCleaner(DatabasePopulator databaseCleaner) {
        this.databaseCleaner = databaseCleaner;
    }

    public void afterPropertiesSet() {
        this.initDatabase();
    }

    public DataSource getObject() {
        return this.getDataSource();
    }

    public Class<? extends DataSource> getObjectType() {
        return DataSource.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        if (this.databaseCleaner != null) {
            DatabasePopulatorUtils.execute(this.databaseCleaner, this.getDataSource());
        }
        this.shutdownDatabase();
    }
}

