/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */
package com.smartgwt.sample.showcase.client.chart;

import com.smartgwt.client.data.Record;

public class MultiSeriesChartData extends Record {

    public MultiSeriesChartData(String time, float value, String region) {
        setAttribute("time", time);
        setAttribute("value", value);
        setAttribute("region", region);
    }

    public static MultiSeriesChartData[] getData() {
        return new MultiSeriesChartData[] {
            new MultiSeriesChartData("1/1/2014", 108.88f, "North"),
            new MultiSeriesChartData("1/1/2014", 891.93f, "South"),
            new MultiSeriesChartData("1/1/2014", 715.13f, "East"),
            new MultiSeriesChartData("1/1/2014", 559.34f, "West"),
            new MultiSeriesChartData("2/1/2014", 626.63f, "North"),
            new MultiSeriesChartData("2/1/2014", 637.73f, "South"),
            new MultiSeriesChartData("2/1/2014", 976.97f, "East"),
            new MultiSeriesChartData("2/1/2014", 216.27f, "West"),
            new MultiSeriesChartData("3/1/2014",  799.18f, "North"),
            new MultiSeriesChartData("3/1/2014",  916.38f, "South"),
            new MultiSeriesChartData("3/1/2014",  853.82f, "East"),
            new MultiSeriesChartData("3/1/2014",  344.79f, "West"),
            new MultiSeriesChartData("4/1/2014",  707.1f, "North"),
            new MultiSeriesChartData("4/1/2014",  796.73f, "South"),
            new MultiSeriesChartData("4/1/2014",  590.05f, "East"),
            new MultiSeriesChartData("4/1/2014",  209.03f, "West"),
            new MultiSeriesChartData("5/1/2014",  321.58f, "North"),
            new MultiSeriesChartData("5/1/2014",  363.25f, "South"),
            new MultiSeriesChartData("5/1/2014",  446.66f, "East"),
            new MultiSeriesChartData("5/1/2014",  338.79f, "West"),
            new MultiSeriesChartData("6/1/2014",  423.43f, "North"),
            new MultiSeriesChartData("6/1/2014",  216.04f, "South"),
            new MultiSeriesChartData("6/1/2014",  511.3f, "East"),
            new MultiSeriesChartData("6/1/2014",  292.49f, "West"),
            new MultiSeriesChartData("7/1/2014",  837.1f, "North"),
            new MultiSeriesChartData("7/1/2014",  970.83f, "South"),
            new MultiSeriesChartData("7/1/2014",  888.2f, "East"),
            new MultiSeriesChartData("7/1/2014",  842.14f, "West"),
            new MultiSeriesChartData("8/1/2014",  975.65f, "North"),
            new MultiSeriesChartData("8/1/2014",  758.96f, "South"),
            new MultiSeriesChartData("8/1/2014",  853.26f, "East"),
            new MultiSeriesChartData("8/1/2014",  103.42f, "West"),
            new MultiSeriesChartData("9/1/2014",  440.78f, "North"),
            new MultiSeriesChartData("9/1/2014",  727.4f, "South"),
            new MultiSeriesChartData("9/1/2014",  822.97f, "East"),
            new MultiSeriesChartData("9/1/2014",  405.61f, "West"),
            new MultiSeriesChartData("10/1/2014",  327.79f, "North"),
            new MultiSeriesChartData("10/1/2014",  538.75f, "South"),
            new MultiSeriesChartData("10/1/2014",  854.46f, "East"),
            new MultiSeriesChartData("10/1/2014",  106.61f, "West"),
            new MultiSeriesChartData("11/1/2014",  451.64f, "North"),
            new MultiSeriesChartData("11/1/2014",  871.23f, "South"),
            new MultiSeriesChartData("11/1/2014",  145.49f, "East"),
            new MultiSeriesChartData("11/1/2014",  829.97f, "West"),
            new MultiSeriesChartData("12/1/2014",  178.88f, "North"),
            new MultiSeriesChartData("12/1/2014",  918.7f, "South"),
            new MultiSeriesChartData("12/1/2014",  534.44f, "East"),
            new MultiSeriesChartData("12/1/2014",  964.85f, "West"),
            new MultiSeriesChartData("1/1/2015",  122.72f, "North"),
            new MultiSeriesChartData("1/1/2015",  890.61f, "South"),
            new MultiSeriesChartData("1/1/2015",  234.3f, "East"),
            new MultiSeriesChartData("1/1/2015",  166.02f, "West"),
            new MultiSeriesChartData("2/1/2015",  252.96f, "North"),
            new MultiSeriesChartData("2/1/2015",  512.08f, "South"),
            new MultiSeriesChartData("2/1/2015",  162.72f, "East"),
            new MultiSeriesChartData("2/1/2015",  853.91f, "West"),
            new MultiSeriesChartData("3/1/2015",  786.04f, "North"),
            new MultiSeriesChartData("3/1/2015",  523.83f, "South"),
            new MultiSeriesChartData("3/1/2015",  781.93f, "East"),
            new MultiSeriesChartData("3/1/2015",  714.54f, "West"),
            new MultiSeriesChartData("4/1/2015",  490.04f, "North"),
            new MultiSeriesChartData("4/1/2015",  182.19f, "South"),
            new MultiSeriesChartData("4/1/2015",  258.83f, "East"),
            new MultiSeriesChartData("4/1/2015",  199.57f, "West"),
            new MultiSeriesChartData("5/1/2015",  232.65f, "North"),
            new MultiSeriesChartData("5/1/2015",  759.15f, "South"),
            new MultiSeriesChartData("5/1/2015",  134.91f, "East"),
            new MultiSeriesChartData("5/1/2015",  269.29f, "West"),
            new MultiSeriesChartData("6/1/2015",  436.18f, "North"),
            new MultiSeriesChartData("6/1/2015",  423.31f, "South"),
            new MultiSeriesChartData("6/1/2015",  592.31f, "East"),
            new MultiSeriesChartData("6/1/2015",  677.62f, "West"),
            new MultiSeriesChartData("7/1/2015",  667.57f, "North"),
            new MultiSeriesChartData("7/1/2015",  834.87f, "South"),
            new MultiSeriesChartData("7/1/2015",  953.77f, "East"),
            new MultiSeriesChartData("7/1/2015",  902.08f, "West"),
            new MultiSeriesChartData("8/1/2015",  485.39f, "North"),
            new MultiSeriesChartData("8/1/2015",  455.7f, "South"),
            new MultiSeriesChartData("8/1/2015",  182.68f, "East"),
            new MultiSeriesChartData("8/1/2015",  213.83f, "West"),
            new MultiSeriesChartData("9/1/2015",  799.83f, "North"),
            new MultiSeriesChartData("9/1/2015",  239.27f, "South"),
            new MultiSeriesChartData("9/1/2015",  383.04f, "East"),
            new MultiSeriesChartData("9/1/2015",  392.67f, "West"),
            new MultiSeriesChartData("10/1/2015",  533.71f, "North"),
            new MultiSeriesChartData("10/1/2015",  352.66f, "South"),
            new MultiSeriesChartData("10/1/2015",  299.48f, "East"),
            new MultiSeriesChartData("10/1/2015",  983.99f, "West"),
            new MultiSeriesChartData("11/1/2015",  752.46f, "North"),
            new MultiSeriesChartData("11/1/2015",  710.61f, "South"),
            new MultiSeriesChartData("11/1/2015",  817.26f, "East"),
            new MultiSeriesChartData("11/1/2015",  798.84f, "West"),
            new MultiSeriesChartData("12/1/2015",  349.16f, "North"),
            new MultiSeriesChartData("12/1/2015",  645.47f, "South"),
            new MultiSeriesChartData("12/1/2015",  462.25f, "East"),
            new MultiSeriesChartData("12/1/2015",  413.88f, "West"),
            new MultiSeriesChartData("1/1/2016",  107.5f, "North"),
            new MultiSeriesChartData("1/1/2016",  237.2f, "South"),
            new MultiSeriesChartData("1/1/2016",  900.95f, "East"),
            new MultiSeriesChartData("1/1/2016",  671.39f, "West"),
            new MultiSeriesChartData("2/1/2016",  201.79f, "North"),
            new MultiSeriesChartData("2/1/2016",  398.4f, "South"),
            new MultiSeriesChartData("2/1/2016",  440.5f, "East"),
            new MultiSeriesChartData("2/1/2016",  179.28f, "West"),
            new MultiSeriesChartData("3/1/2016",  696.97f, "North"),
            new MultiSeriesChartData("3/1/2016",  572.3f, "South"),
            new MultiSeriesChartData("3/1/2016",  528.65f, "East"),
            new MultiSeriesChartData("3/1/2016",  811.09f, "West"),
            new MultiSeriesChartData("4/1/2016",  482.62f, "North"),
            new MultiSeriesChartData("4/1/2016",  657.75f, "South"),
            new MultiSeriesChartData("4/1/2016",  253.78f, "East"),
            new MultiSeriesChartData("4/1/2016",  205.98f, "West"),
            new MultiSeriesChartData("5/1/2016",  602.92f, "North"),
            new MultiSeriesChartData("5/1/2016",  659.21f, "South"),
            new MultiSeriesChartData("5/1/2016",  844.88f, "East"),
            new MultiSeriesChartData("5/1/2016",  268.72f, "West"),
            new MultiSeriesChartData("6/1/2016",  961.68f, "North"),
            new MultiSeriesChartData("6/1/2016",  367.78f, "South"),
            new MultiSeriesChartData("6/1/2016",  171.6f, "East"),
            new MultiSeriesChartData("6/1/2016",  669.74f, "West"),
            new MultiSeriesChartData("7/1/2016",  157.36f, "North"),
            new MultiSeriesChartData("7/1/2016",  781.19f, "South"),
            new MultiSeriesChartData("7/1/2016",  244.19f, "East"),
            new MultiSeriesChartData("7/1/2016",  345.07f, "West"),
            new MultiSeriesChartData("8/1/2016",  803.01f, "North"),
            new MultiSeriesChartData("8/1/2016",  398.78f, "South"),
            new MultiSeriesChartData("8/1/2016",  713.52f, "East"),
            new MultiSeriesChartData("8/1/2016",  996.36f, "West"),
            new MultiSeriesChartData("9/1/2016",  942.33f, "North"),
            new MultiSeriesChartData("9/1/2016",  411.54f, "South"),
            new MultiSeriesChartData("9/1/2016",  371.09f, "East"),
            new MultiSeriesChartData("9/1/2016",  590.91f, "West"),
            new MultiSeriesChartData("10/1/2016",  874.63f, "North"),
            new MultiSeriesChartData("10/1/2016",  857.04f, "South"),
            new MultiSeriesChartData("10/1/2016",  649.05f, "East"),
            new MultiSeriesChartData("10/1/2016",  861.61f, "West"),
            new MultiSeriesChartData("11/1/2016",  789.86f, "North"),
            new MultiSeriesChartData("11/1/2016",  788.52f, "South"),
            new MultiSeriesChartData("11/1/2016",  120.13f, "East"),
            new MultiSeriesChartData("11/1/2016",  807.02f, "West"),
            new MultiSeriesChartData("12/1/2016",  268.58f, "North"),
            new MultiSeriesChartData("12/1/2016",  774.83f, "South"),
            new MultiSeriesChartData("12/1/2016",  997.72f, "East"),
            new MultiSeriesChartData("12/1/2016",  191.29f, "West")
        };
    }

}
