/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.xml;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Document;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DocumentFragment;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLDocument;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import com.gargoylesoftware.htmlunit.xml.XmlUtil;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.EDGE})
public class XSLTProcessor
extends SimpleScriptable {
    private Node style_;
    private Map<String, Object> parameters_ = new HashMap<String, Object>();

    @JsxConstructor
    public XSLTProcessor() {
    }

    @JsxFunction
    public void importStylesheet(Node style) {
        this.style_ = style;
    }

    @JsxFunction
    public XMLDocument transformToDocument(Node source) {
        org.w3c.dom.Node node;
        XMLDocument doc = new XMLDocument();
        doc.setPrototype(this.getPrototype(doc.getClass()));
        doc.setParentScope(this.getParentScope());
        Object transformResult = this.transform(source);
        if (transformResult instanceof org.w3c.dom.Node) {
            org.w3c.dom.Node transformedDoc = (org.w3c.dom.Node)transformResult;
            node = transformedDoc.getFirstChild();
        } else {
            node = null;
        }
        XmlPage page = new XmlPage(node, this.getWindow().getWebWindow());
        doc.setDomNode(page);
        return doc;
    }

    private Object transform(Node source) {
        try {
            DOMSource xmlSource = new DOMSource(source.getDomNodeOrDie());
            DOMSource xsltSource = new DOMSource(this.style_.getDomNodeOrDie());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            org.w3c.dom.Document containerDocument = factory.newDocumentBuilder().newDocument();
            Element containerElement = containerDocument.createElement("container");
            containerDocument.appendChild(containerElement);
            DOMResult result = new DOMResult(containerElement);
            Transformer transformer = TransformerFactory.newInstance().newTransformer(xsltSource);
            for (Map.Entry<String, Object> entry : this.parameters_.entrySet()) {
                transformer.setParameter(entry.getKey(), entry.getValue());
            }
            transformer.transform(xmlSource, result);
            org.w3c.dom.Node transformedNode = result.getNode();
            if (transformedNode.getFirstChild().getNodeType() == 1) {
                return transformedNode;
            }
            xmlSource = new DOMSource(source.getDomNodeOrDie());
            StringWriter writer = new StringWriter();
            StreamResult streamResult = new StreamResult(writer);
            transformer.transform(xmlSource, streamResult);
            return writer.toString();
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)("Exception: " + e));
        }
    }

    @JsxFunction
    public DocumentFragment transformToFragment(Node source, Object output) {
        SgmlPage page = (SgmlPage)((Document)output).getDomNodeOrDie();
        DomDocumentFragment fragment = page.createDocumentFragment();
        DocumentFragment rv = new DocumentFragment();
        rv.setPrototype(this.getPrototype(rv.getClass()));
        rv.setParentScope(this.getParentScope());
        rv.setDomNode(fragment);
        this.transform(source, fragment);
        return rv;
    }

    private void transform(Node source, DomNode parent) {
        Object result = this.transform(source);
        if (result instanceof org.w3c.dom.Node) {
            SgmlPage parentPage = parent.getPage();
            NodeList children = ((org.w3c.dom.Node)result).getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                XmlUtil.appendChild(parentPage, parent, children.item(i), true);
            }
        } else {
            DomText text = new DomText(parent.getPage(), (String)result);
            parent.appendChild(text);
        }
    }

    @JsxFunction
    public void setParameter(String namespaceURI, String localName, Object value) {
        this.parameters_.put(XSLTProcessor.getQualifiedName(namespaceURI, localName), value);
    }

    @JsxFunction
    public Object getParameter(String namespaceURI, String localName) {
        return this.parameters_.get(XSLTProcessor.getQualifiedName(namespaceURI, localName));
    }

    private static String getQualifiedName(String namespaceURI, String localName) {
        String qualifiedName = namespaceURI != null && !namespaceURI.isEmpty() && !"null".equals(namespaceURI) ? '{' + namespaceURI + '}' + localName : localName;
        return qualifiedName;
    }
}

