/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.typedarrays.client;

import com.google.gwt.typedarrays.client.ArrayBufferNative;
import com.google.gwt.typedarrays.client.Float32ArrayNative;
import com.google.gwt.typedarrays.client.Float64ArrayNative;
import com.google.gwt.typedarrays.client.Int16ArrayNative;
import com.google.gwt.typedarrays.client.Int32ArrayNative;
import com.google.gwt.typedarrays.client.Int8ArrayNative;
import com.google.gwt.typedarrays.client.Uint16ArrayNative;
import com.google.gwt.typedarrays.client.Uint32ArrayNative;
import com.google.gwt.typedarrays.client.Uint8ArrayNative;
import com.google.gwt.typedarrays.shared.ArrayBuffer;
import com.google.gwt.typedarrays.shared.DataView;

public class DataViewNativeEmul
implements DataView {
    private static final boolean nativeLittleEndian = DataViewNativeEmul.isNativeLittleEndian();
    protected final ArrayBuffer buffer;
    protected final int bufferByteOffset;
    protected final int byteLength;
    protected final Uint8ArrayNative tempBuffer;
    protected final Uint8ArrayNative uint8Array;

    public static DataView create(ArrayBuffer buffer, int byteOffset, int byteLength) {
        return new DataViewNativeEmul(buffer, byteOffset, byteLength);
    }

    private static native boolean isNativeLittleEndian();

    protected DataViewNativeEmul(ArrayBuffer buffer, int byteOffset, int byteLength) {
        this.buffer = buffer;
        this.bufferByteOffset = byteOffset;
        this.byteLength = byteLength;
        this.tempBuffer = Uint8ArrayNative.create(ArrayBufferNative.create(8), 0, 8);
        this.uint8Array = Uint8ArrayNative.create(buffer, byteOffset, byteLength);
    }

    @Override
    public ArrayBuffer buffer() {
        return this.buffer;
    }

    @Override
    public int byteLength() {
        return this.byteLength;
    }

    @Override
    public int byteOffset() {
        return this.bufferByteOffset;
    }

    @Override
    public float getFloat32(int byteOffset) {
        return this.getFloat32(byteOffset, false);
    }

    @Override
    public float getFloat32(int byteOffset, boolean littleEndian) {
        ArrayBuffer buf = this.buffer;
        int ofs = this.bufferByteOffset + byteOffset;
        int len = 4;
        if (littleEndian != nativeLittleEndian) {
            this.reverseBytes(this.uint8Array, ofs, len, this.tempBuffer, 0);
            buf = this.tempBuffer.buffer();
            ofs = 0;
        }
        return Float32ArrayNative.create(buf, ofs, 1).get(0);
    }

    @Override
    public double getFloat64(int byteOffset) {
        return this.getFloat64(byteOffset, false);
    }

    @Override
    public double getFloat64(int byteOffset, boolean littleEndian) {
        ArrayBuffer buf = this.buffer;
        int ofs = this.bufferByteOffset + byteOffset;
        int len = 8;
        if (littleEndian != nativeLittleEndian) {
            this.reverseBytes(this.uint8Array, ofs, len, this.tempBuffer, 0);
            buf = this.tempBuffer.buffer();
            ofs = 0;
        }
        return Float64ArrayNative.create(buf, ofs, 1).get(0);
    }

    @Override
    public short getInt16(int byteOffset) {
        return this.getInt16(byteOffset, false);
    }

    @Override
    public short getInt16(int byteOffset, boolean littleEndian) {
        ArrayBuffer buf = this.buffer;
        int ofs = this.bufferByteOffset + byteOffset;
        int len = 2;
        if (littleEndian != nativeLittleEndian) {
            this.reverseBytes(this.uint8Array, ofs, len, this.tempBuffer, 0);
            buf = this.tempBuffer.buffer();
            ofs = 0;
        }
        return Int16ArrayNative.create(buf, ofs, 1).get(0);
    }

    @Override
    public int getInt32(int byteOffset) {
        return this.getInt32(byteOffset, false);
    }

    @Override
    public int getInt32(int byteOffset, boolean littleEndian) {
        ArrayBuffer buf = this.buffer;
        int ofs = this.bufferByteOffset + byteOffset;
        int len = 4;
        if (littleEndian != nativeLittleEndian) {
            this.reverseBytes(this.uint8Array, ofs, len, this.tempBuffer, 0);
            buf = this.tempBuffer.buffer();
            ofs = 0;
        }
        return Int32ArrayNative.create(buf, ofs, 1).get(0);
    }

    @Override
    public byte getInt8(int byteOffset) {
        return Int8ArrayNative.create(this.buffer, byteOffset, 1).get(0);
    }

    @Override
    public int getUint16(int byteOffset) {
        return this.getUint16(byteOffset, false);
    }

    @Override
    public int getUint16(int byteOffset, boolean littleEndian) {
        ArrayBuffer buf = this.buffer;
        int ofs = this.bufferByteOffset + byteOffset;
        int len = 2;
        if (littleEndian != nativeLittleEndian) {
            this.reverseBytes(this.uint8Array, ofs, len, this.tempBuffer, 0);
            buf = this.tempBuffer.buffer();
            ofs = 0;
        }
        return Uint16ArrayNative.create(buf, ofs, 1).get(0);
    }

    @Override
    public long getUint32(int byteOffset) {
        return this.getUint32(byteOffset, false);
    }

    @Override
    public long getUint32(int byteOffset, boolean littleEndian) {
        ArrayBuffer buf = this.buffer;
        int ofs = this.bufferByteOffset + byteOffset;
        int len = 4;
        if (littleEndian != nativeLittleEndian) {
            this.reverseBytes(this.uint8Array, ofs, len, this.tempBuffer, 0);
            buf = this.tempBuffer.buffer();
            ofs = 0;
        }
        return Uint32ArrayNative.create(buf, ofs, 1).get(0);
    }

    @Override
    public double getUint32AsDouble(int byteOffset) {
        return this.getUint32(byteOffset, false);
    }

    @Override
    public double getUint32AsDouble(int byteOffset, boolean littleEndian) {
        return this.getUint32(byteOffset, littleEndian);
    }

    @Override
    public short getUint8(int byteOffset) {
        return Uint8ArrayNative.create(this.buffer, byteOffset, 1).get(0);
    }

    @Override
    public void setFloat32(int byteOffset, float value) {
        this.setFloat32(byteOffset, value, false);
    }

    @Override
    public void setFloat32(int byteOffset, float value, boolean littleEndian) {
        int ofs;
        ArrayBuffer buf = this.buffer;
        int finalOfs = ofs = this.bufferByteOffset + byteOffset;
        int len = 4;
        if (littleEndian != nativeLittleEndian) {
            buf = this.tempBuffer.buffer();
            ofs = 0;
        }
        Float32ArrayNative.create(buf, ofs, 1).set(0, value);
        if (littleEndian != nativeLittleEndian) {
            this.reverseBytes(this.tempBuffer, 0, len, this.uint8Array, finalOfs);
        }
    }

    @Override
    public void setFloat64(int byteOffset, double value) {
        this.setFloat64(byteOffset, value, false);
    }

    @Override
    public void setFloat64(int byteOffset, double value, boolean littleEndian) {
        int ofs;
        ArrayBuffer buf = this.buffer;
        int finalOfs = ofs = this.bufferByteOffset + byteOffset;
        int len = 8;
        if (littleEndian != nativeLittleEndian) {
            buf = this.tempBuffer.buffer();
            ofs = 0;
        }
        Float64ArrayNative.create(buf, ofs, 1).set(0, value);
        if (littleEndian != nativeLittleEndian) {
            this.reverseBytes(this.tempBuffer, 0, len, this.uint8Array, finalOfs);
        }
    }

    @Override
    public void setInt16(int byteOffset, int value) {
        this.setInt16(byteOffset, value, false);
    }

    @Override
    public void setInt16(int byteOffset, int value, boolean littleEndian) {
        int ofs;
        ArrayBuffer buf = this.buffer;
        int finalOfs = ofs = this.bufferByteOffset + byteOffset;
        int len = 2;
        if (littleEndian != nativeLittleEndian) {
            buf = this.tempBuffer.buffer();
            ofs = 0;
        }
        Int16ArrayNative.create(buf, ofs, 1).set(0, value);
        if (littleEndian != nativeLittleEndian) {
            this.reverseBytes(this.tempBuffer, 0, len, this.uint8Array, finalOfs);
        }
    }

    @Override
    public void setInt32(int byteOffset, int value) {
        this.setInt32(byteOffset, value, false);
    }

    @Override
    public void setInt32(int byteOffset, int value, boolean littleEndian) {
        int ofs;
        ArrayBuffer buf = this.buffer;
        int finalOfs = ofs = this.bufferByteOffset + byteOffset;
        int len = 4;
        if (littleEndian != nativeLittleEndian) {
            buf = this.tempBuffer.buffer();
            ofs = 0;
        }
        Int32ArrayNative.create(buf, ofs, 1).set(0, value);
        if (littleEndian != nativeLittleEndian) {
            this.reverseBytes(this.tempBuffer, 0, len, this.uint8Array, finalOfs);
        }
    }

    @Override
    public void setInt8(int byteOffset, int value) {
        Int8ArrayNative.create(this.buffer, byteOffset, 1).set(0, value);
    }

    @Override
    public void setUint16(int byteOffset, int value) {
        this.setUint16(byteOffset, value, false);
    }

    @Override
    public void setUint16(int byteOffset, int value, boolean littleEndian) {
        int ofs;
        ArrayBuffer buf = this.buffer;
        int finalOfs = ofs = this.bufferByteOffset + byteOffset;
        int len = 2;
        if (littleEndian != nativeLittleEndian) {
            buf = this.tempBuffer.buffer();
            ofs = 0;
        }
        Uint16ArrayNative.create(buf, ofs, 1).set(0, value);
        if (littleEndian != nativeLittleEndian) {
            this.reverseBytes(this.tempBuffer, 0, len, this.uint8Array, finalOfs);
        }
    }

    @Override
    public void setUint32(int byteOffset, long value) {
        this.setUint32(byteOffset, value, false);
    }

    @Override
    public void setUint32(int byteOffset, long value, boolean littleEndian) {
        int ofs;
        ArrayBuffer buf = this.buffer;
        int finalOfs = ofs = this.bufferByteOffset + byteOffset;
        int len = 4;
        if (littleEndian != nativeLittleEndian) {
            buf = this.tempBuffer.buffer();
            ofs = 0;
        }
        Uint32ArrayNative.create(buf, ofs, 1).set(0, value);
        if (littleEndian != nativeLittleEndian) {
            this.reverseBytes(this.tempBuffer, 0, len, this.uint8Array, finalOfs);
        }
    }

    @Override
    public void setUint32FromDouble(int byteOffset, double value) {
        this.setUint32FromDouble(byteOffset, value, false);
    }

    @Override
    public void setUint32FromDouble(int byteOffset, double value, boolean littleEndian) {
        int ofs;
        ArrayBuffer buf = this.buffer;
        int finalOfs = ofs = this.bufferByteOffset + byteOffset;
        int len = 4;
        if (littleEndian != nativeLittleEndian) {
            buf = this.tempBuffer.buffer();
            ofs = 0;
        }
        Uint32ArrayNative.create(buf, ofs, 1).set(0, value);
        if (littleEndian != nativeLittleEndian) {
            this.reverseBytes(this.tempBuffer, 0, len, this.uint8Array, finalOfs);
        }
    }

    @Override
    public void setUint8(int byteOffset, int value) {
        Uint8ArrayNative.create(this.buffer, byteOffset, 1).set(0, value);
    }

    protected final void reverseBytes(Uint8ArrayNative src, int srcOfs, int len, Uint8ArrayNative dest, int destOfs) {
        for (int i = 0; i < len; ++i) {
            dest.set(i + destOfs, (int)src.get(srcOfs + len - 1 - i));
        }
    }
}

