## Attr: FormSetFieldValueTask.targetField

### Description
Field to assign new value.

**Flags**: IR

---
## ClassMethod: TabIndexManager.getTabIndex

### Description
Returns a tabIndex number for some target ID registered via \[classMethod:TabIndexManager.addTarget\](#classmethod-tabindexmanageraddtarget). Generated tab indices are guaranteed to be in order.

As targets are added to, or moved within the TabIndexManager, their tab index may become invalid. The `tabIndexUpdated` notification will be fired when this occurs, giving developers a way to pick up the new tab index, and assign it to the appropriate DOM element if appropriate.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| ID | [String](#type-string) | false | — | ID of the target for which you want to get a numeric tabIndex. |

### Returns

`[Integer](#type-integer)` — returns the numeric tabIndex value for the specified target

---
## Method: EventStream.end

### Description
Ends event capturing and returns the \[object:EventStreamData\](#object-eventstreamdata). Once ended, capturing cannot be restarted without losing all stored events.

### Returns

`[EventStreamData](#type-eventstreamdata)` — —

### See Also

- [EventStream.autoStart](#attr-eventstreamautostart)
- [EventStream.start](#method-eventstreamstart)

---
## Method: PickList.dataArrived

### Description
If this item is showing a dataBound pickList, this notification method will be fired when new data arrives from the server.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| startRow | [int](#type-int) | false | — | index of first row returned by the server |
| endRow | [int](#type-int) | false | — | index of last row returned by the server |
| data | [ResultSet](#type-resultset) | false | — | pointer to this pickList's data |

---
## Attr: SelectItem.fetchDisplayedFieldsOnly

### Description
If this item has a specified `optionDataSource` and this property is `true`, the list of fields used by this pickList will be passed to the datasource as \[attr:DSRequest.outputs\](#attr-dsrequestoutputs). If the datasource supports this feature the returned fields will be limited to this list. A custom datasource will need to add code to implement field limiting.

This list of used fields consists of the values of \[valueField\](#attr-formitemvaluefield), \[displayField\](#attr-formitemdisplayfield) and \[pickListFields\](#attr-selectitempicklistfields).

NOTE: When enabled, \[getSelectedRecord\](#method-formitemgetselectedrecord) will only include the fetched fields.

**Flags**: IRA

---
## Class: SendEmailTask

### Description
Sends the specified message via email or \[notification\](#class-notify).

Email is sent using the \[group:reifyMessaging\](#group-reifymessaging) `isc_sendEmail` DataSource. Refer to \[Mail overview\](#class-mail) to know how to set up access to an SMTP server.

There is a matching Reify Workflow Editor task editor, \[class:SendEmailTaskEditor\](#class-sendemailtaskeditor), that can be enabled by \[attr:Reify.enableSendEmailTaskEditor\](#attr-reifyenablesendemailtaskeditor).

If \[mock mode\](#attr-processmockmode) is enabled, instead of sending an email a \[notification message\](#attr-sendemailtaskmockmodenotifymessage) is shown instead.

---
## Method: ColorItem.pickerColorSelected

### Description
Store the color value selected by the user from the color picker. You will need to override this method if you wish to capture opacity information from the \[class:ColorPicker\](#class-colorpicker).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| color | [String](#type-string) | false | — | The selected color as a string. |
| opacity | [Integer](#type-integer) | false | — | The selected opacity, from 0 (transparent) to 100 (opaque), or null if \[attr:ColorItem.supportsTransparency\](#attr-coloritemsupportstransparency) is false or the \[color picker\](#class-colorpicker) selected a color while in \[simple mode\](#type-colorpickermode). |

---
## Attr: DataSource.canAggregate

### Description
By default, all DataSources are assumed to be capable of handling \[group:serverSummaries\](#group-serversummaries) on fetch or filter type operations. This property may be set to `false` to indicate that this dataSource does not support serverSummaries.

#### NOTE:
 If you specify this property in a DataSource descriptor (`.ds.xml` file), it is enforced on the server. This means that if you run a request containing serverSummaries against a DataSource that advertises itself as `canAggregate:false`, it will be rejected.

### Groups

- serverSummaries

### See Also

- [serverSummaries](#group-serversummaries)

**Flags**: IRWA

---
## Attr: MultiSortDialog.deleteLevelButton

### Description
Automatically generated \[class:IButton\](#class-ibutton) providing a mechanism for deleting levels from the sort configuration.

This component is an \[type:AutoChild\](#type-autochild) and as such may be customized via `multiSortPanel.deleteLevelButtonProperties` and `multiSortPanel.deleteLevelButtonDefaults`.

**Flags**: RA

---
## Attr: SectionItem.editProxyConstructor

### Description
Default class used to construct the \[class:EditProxy\](#class-editproxy) for this component when the component is \[first placed into edit mode\](#method-canvasseteditmode).

**Flags**: IR

---
## Method: SimpleType.getGroupValue

### Description
Returns a group value appropriate for the passed record, field and value, in the passed component.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| value | [Any](#type-any) | false | — | the record value to return a group value for |
| record | [Record](#type-record) | false | — | the record containing the passed value |
| field | [Object](#type-object) | false | — | the field relating to the value to be processed |
| fieldName | [String](#type-string) | false | — | the name of the field relating to the value to be processed |
| component | [Canvas](#type-canvas) | false | — | the component, usually a \[class:ListGrid\](#class-listgrid), containing the passed record |

### Returns

`[Any](#type-any)` — the group value for the passed parameters

---
## Attr: ListGrid.clipHeaderTitles

### Description
Whether the ListGrid should manage the clipping of titles of header buttons, showing ellipses if the title is clipped, and potentially showing the full title on \[hover\](#attr-listgridshowclippedheadertitlesonhover).

In some cases this may be preferable to the button component's default clipping behavior because if a \[sort arrow\](#attr-listgridshowsortarrow) or sort numeral is displayed for a header, then the button's default clipping behavior may clip the sort arrow/numeral whereas ListGrid-managed title clipping utilizes special HTML which keeps the sort arrow/numeral visible.

This feature is automatically enabled if supported by the browser. The only supported use of this attribute is to _disable_ the feature by setting clipHeaderTitles to false.

Note that this feature is incompatible with \[attr:ListGridField.wrap\](#attr-listgridfieldwrap), and will automatically be disabled for wrapping fields.

### Groups

- gridHeader
- appearance

### See Also

- [ListGrid.headerBaseStyle](#attr-listgridheaderbasestyle)

**Flags**: IRA

---
## Attr: CubeGrid.valueFormat

### Description
\[type:FormatString\](#type-formatstring) for numeric or date formatting. See \[attr:DataSourceField.format\](#attr-datasourcefieldformat).

### Groups

- exportFormatting

**Flags**: IR

---
## Attr: ListGrid.hiliteCanReplaceValue

### Description
If set, end users can create advanced hiliting rules that will use the \[attr:Hilite.replacementValue\](#attr-hilitereplacementvalue) feature to cause values in hilited cells to be replaced with a user-entered value. For example, a user could create a hilite rule that replaces numeric values ranging from 0.5 to 1.0 with the text "LOW".

Specifically, when the "Add Advanced Rule" button is pressed and `hiliteCanReplaceValue` is true, the user will see a text entry field titled "Replace value with" (\[attr:ListGrid.hiliteReplaceValueFieldTitle\](#attr-listgridhilitereplacevaluefieldtitle)) and if they enter a value, that value will appear in the grid cell in lieu of the cell's original value.

### Groups

- hiliting

**Flags**: IR

---
## Group: reifyMessaging

### Description
Reify allows you to send two different kind of messages from your applications: Email and SMS.

#### Email

There is a special DataSource named 'isc\_sendEmail', which you can directly use from your app. The following fields are required to send this kind of message:

*   #### to
    : indicates the email accounts of the destinataries. Use commas (',') in order to use more than one destinatary.
*   #### subject
    : indicates the topic of the email.
*   #### message
    : indicates the message to send.

You need to set up the following entry in the server.properties file in order to use this feature:

*   #### reify.emailFrom
    : the email account used as 'from' in the email message.

Also, you can check the \[Mail overview\](#class-mail) to know how to set up access to an SMTP server and complete the configuration to use this feature.

#### SMS

There is a special DataSource named 'isc\_sendSMS', which you can directly use from your app. The following fields are required to send this kind of message:

*   #### to
    : phone numbers of the destinataries that will receive the message. Use commas (',') in order to use more than one phone number.
*   #### message
    : message to send.

Also, Reify uses a specific Twilio library to achieve this. You need to set up the following entries in the server.properties file in order to use this feature:

*   #### twilio.ACCOUNT\_SID
    : identifier of the account, which acts as a username.
*   #### twilio.AUTH\_TOKEN
    : acts as a password.
*   #### twilio.twilioPhoneNumber
    : Twilio phone number you get when setting up your account in Twilio.

You need to register in the Twilio website and set up your account in order to get the required values.

---
## Method: DataSource.getFieldOperators

### Description
Get the list of \[type:OperatorId\](#type-operatorid)s available for this field.

By default, if \[field.validOperators\](#attr-datasourcefieldvalidoperators) is set, returns that list, otherwise returns the result of \[method:DataSource.getTypeOperators\](#method-datasourcegettypeoperators).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| field | [String](#type-string)|[DataSourceField](#type-datasourcefield) | false | — | Field (or field name) to obtain operators for |

### Returns

`[Array of OperatorId](#type-array-of-operatorid)` — available Operators

### Groups

- advancedFilter

---
## Method: Array.find

### Description
Like \[method:Array.findIndex\](#method-arrayfindindex), but returns the object itself instead of its index.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| propertyName | [String](#type-string)|[Object](#type-object)|[AdvancedCriteria](#type-advancedcriteria) | false | — | property to match, or if an Object is passed, set of properties and values to match |
| value | [Any](#type-any) | true | — | value to compare against (if propertyName is a string) |

### Returns

`[Object](#type-object)` — first matching object or null if not found

### Groups

- access
- find

---
## Method: TabSet.tabIconClick

### Description
Method fired when the user clicks the icon for a tab, as specified via \[attr:Tab.icon\](#attr-tabicon).

Default behavior will fire `icon.click()` if specified, with two parameters `tab` (a pointer to the tab object and `tabSet` a pointer to the tabSet instance.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| tab | [Tab](#type-tab) | false | — | with click handler being fired |

---
## Attr: ListGrid.filterByCell

### Description
If we're showing the \[filterEditor\](#attr-listgridshowfiltereditor), should this list be filtered every time the user changes edit values for particular cells rather than waiting for an Enter keypress or a click on the filterEditor submit button.

Note that by default fields in the filter editor will be set to \[changeOnKeypress:false\](#attr-formitemchangeonkeypress), so the grid will not filter as the user types in text-based items.  
To enable filtering as the user types in text fields, we recommend the \[attr:ListGrid.filterOnKeypress\](#attr-listgridfilteronkeypress) attribute. Also note that `filterOnKeypress:true` implies filtering will occur on change to edit values for cells, even if `filterByCell` is not set to true.

### Groups

- filterEditor

### See Also

- [ListGrid.fetchDelay](#attr-listgridfetchdelay)

**Flags**: IRWA

---
## Attr: DynamicForm.checkFileAccessOnSubmit

### Description
For dynamicForms containing a \[class:FileItem\](#class-fileitem) for uploading files, should the browser verify that the file is accessible before submitting the uploaded file to the server?

In some cases the browser may not be able to access the selected file.  
This can occur when the file has been modified in the file system after selection in the browser, or if the current user doesn't have permission to view the file.

By default, before submitting the file to the server the browser will verify that it can access the file's contents and display the \[attr:DynamicForm.fileAccessFailedWarning\](#attr-dynamicformfileaccessfailedwarning) if file access fails.  
Note that accessing the file's contents is an asynchronous process, so form submission is not performed synchronously.

This means that if application code calls \[method:DynamicForm.saveData\](#method-dynamicformsavedata) on a form containing a fileItem and then synchronously \[clears\](#method-canvasclear) it from the DOM, the upload will never be kicked off.  
Setting `checkFileAccessOnSubmit` to false will suppress the (asynchronous) check, and can be used to bypass this limitation, but this is not recommended except as a short term backwards-compatibility workaround. Instead we'd recommend using the \[saveData callback\](#method-dynamicformsavedata) to clear the form when the upload has completed. This also gives the user an opportunity to correct validation errors and re-submit the form if necessary.

**Flags**: IRWA

---
## Attr: PickTreeItem.valueTree

### Description
A \[class:Tree\](#class-tree) of options from which the user can select.

**Flags**: IR

---
## Method: MultiGroupDialog.getNumLevels

### Description
Return the number of levels of grouping that have been configured.

### Returns

`[number](#type-number)` — The number of levels of grouping that have been configured

---
## Method: PortalLayout.willAcceptPortletDrop

### Description
This method will be invoked to determine whether a dragged \[class:Portlet\](#class-portlet) or other component can be dropped into this `PortalLayout` at the specified position.

The method will be called with the appropriate parameters from \[method:Canvas.willAcceptDrop\](#method-canvaswillacceptdrop) when the user attempts to drop within the PortalLayout or its subcomponents.

The default implementation acts like \[method:Canvas.willAcceptDrop\](#method-canvaswillacceptdrop), checking the \[attr:PortalLayout.dropTypes\](#attr-portallayoutdroptypes) of the appropriate subcomponent, which will be derived from the \[attr:PortalLayout.portletDropTypes\](#attr-portallayoutportletdroptypes) by default.

This method may be overridden to control Portlet drop capabilities based on custom logic.

See \[group:portalLayoutDrop\](#group-portallayoutdrop) for an overview of Portlet drop behaviors within a PortalLayout.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| dragTarget | [Canvas](#type-canvas) | false | — | The \[class:Portlet\](#class-portlet), or other component, being dragged |
| colNum | [int](#type-int) | false | — | indicates the target column number for the portlet to be added to. |
| rowNum | [int](#type-int) | true | — | indicates the row number being dropped on within the target column. If this parameter is not passed, the user is attempting to add a new column by dropping outside any existing column. |
| dropPosition | [int](#type-int) | true | — | Drop position within an existing row. If this parameter is not passed, the user is attempting to add a new row by dropping above or below any existing row. |

### Returns

`[boolean](#type-boolean)` — true if the \[class:Portlet\](#class-portlet) or other component being dragged can be dropped on this PortalLayout, false otherwise

### Groups

- portalLayoutDrop

### See Also

- [Canvas.dragType](#attr-canvasdragtype)
- [PortalLayout.portletDropTypes](#attr-portallayoutportletdroptypes)
- [PortalLayout.portletsChanged](#method-portallayoutportletschanged)

**Flags**: A

---
## Attr: DSRequest.exportToClient

### Description
If set to true (the default), SmartClient Server will export data back to the client, either as a file download or as content in a new browser window, depending on the setting of \[exportDisplay\](#attr-dsrequestexportdisplay).

Setting this property to false disables this. This may be useful when developers wish to \[export the data to a file on the server fileSystem\](#attr-dsrequestexporttofilesystem), but do not need to display it in the browser in response to the export request.

Note that it is perfectly valid to have both this property and \[exportToFilesystem\](#attr-dsrequestexporttofilesystem) set to true; in this case the data is both exported to a file on the server filesystem, and downloaded to the client. If you specify _neither_ property, the export no-ops.

**Flags**: IR

---
## ClassMethod: Canvas.getSnapPosition

### Description
Return the position for `snapper` to be placed in order to "snap to" an edge or corner of `target`, in the same sense as \[attr:Canvas.snapTo\](#attr-canvassnapto).

Default for `snapEdge` is the 
#### opposite
 edge or corner from `snapTo`. For example, `snapTo` of "T" (top) means `snapEdge` will default to "B" (bottom), so the returned coordinates would place `snapper` centered along the top edge of `target`. A `snapTo` of "TL" (top left) means `snapEdge` will default to "BR" (bottom right), so the returned coordinates would place the bottom right of `snapper` at the top left corner of `target`.

`target` can be passed as either a Canvas or 4-element Array giving the top, left, width and height of the target. `snapper` can be passed as either a Canvas or a two-element Array of the width and height of the rectangle to be placed.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| target | [Canvas](#type-canvas)|[Array of Integer](#type-array-of-integer) | false | — | canvas to snap to |
| snapTo | [String](#type-string) | false | — | edge against which to snap |
| snapper | [Canvas](#type-canvas)|[Array of Integer](#type-array-of-integer) | false | — | canvas being snapped |
| snapEdge | [String](#type-string) | true | — | optional edge to snapTo. Default is the 
#### opposite
 edge or corner from `snapTo` |

### Returns

`[Point](#type-point)` — the position for `snapper` to be placed in order to "snap to" an edge or corner of `target`

### Groups

- snapPositioning

---
## Method: Chart.setData

### Description
Change the dataset for this chart on the fly. May or may not be supported by concrete chart implementations.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| newData | [Array of CellRecord](#type-array-of-cellrecord)|[CellRecord](#type-cellrecord) | false | — | new dataset |

---
## Attr: StretchImgButton.showRollOverIcon

### Description
If using an icon for this button, whether to switch the icon image on mouse rollover.

### Groups

- buttonIcon

**Flags**: IR

---
## Method: RecordEditor.performAction

### Description
Fired when the user clicks the \[attr:RecordEditor.actionButton\](#attr-recordeditoractionbutton) for this RecordEditor. May also be triggered from other user interaction with edit values (for example filter-editor change - see \[attr:ListGrid.filterOnKeypress\](#attr-listgridfilteronkeypress)).

This is the method which initiates a filter in a listGrid \[filter editor\](#attr-listgridshowfiltereditor). Note that for custom filtering behavior, developers can use the \[method:ListGrid.filterEditorSubmit\](#method-listgridfiltereditorsubmit) notification method rather than overriding this method directly.

---
## Attr: ListGrid.autoFitExtraRecords

### Description
If \[attr:ListGrid.autoFitData\](#attr-listgridautofitdata) is set to `"vertical"` or `"both"`, setting this property will cause the ListGrid body to size large enough to accommodate the actual data and also leave this many extra rows' worth of blank space below the last record. If a maximum size is specified via \[attr:ListGrid.autoFitMaxHeight\](#attr-listgridautofitmaxheight) or \[attr:ListGrid.autoFitMaxRecords\](#attr-listgridautofitmaxrecords), it will still be respected. Once the data set is large enough to fill or exceed that space, this property no longer has an effect.

### Groups

- autoFitData

**Flags**: IRW

---
## Attr: TabSet.moreTabPane

### Description
Pane contents for the "more" tab based on a VLayout. Typically contains a \[class:NavigationBar\](#class-navigationbar) and \[class:TableView\](#class-tableview).

**Flags**: R

---
## Attr: Validator.caseSensitive

### Description
Applies only to the "isUnique" and "hasRelatedRecord" validators and controls whether the search for existing records is case sensitive or not.

**Flags**: IR

---
## ClassAttr: Canvas.REPEAT

### Description
A declared value of the enum type \[BackgroundRepeat\](#type-backgroundrepeat).

**Flags**: R

---
## Attr: ListGrid.showGroupSummaryInHeader

### Description
If this grid is \[grouped\](#method-listgridgroupby), and \[attr:ListGrid.showGroupSummary\](#attr-listgridshowgroupsummary) is true, setting this property causes field summary values for each group to be displayed directly in the group header node, rather than showing up at the bottom of each expanded group.

Note that this means the group header node will be showing multiple field values rather than the default display of a single cell spanning all columns containing the group title. Developers may specify an explicit \[attr:ListGrid.groupTitleField\](#attr-listgridgrouptitlefield), or rely on the automatically generated \[groupTitleColumn\](#attr-listgridshowgrouptitlecolumn) to have group titles be visible as well as the summary values.

Also note that multi-line group summaries are not supported when showing the group summary in the group header. If multiple \[field summary functions\](#attr-listgridfieldsummaryfunction) are defined for some field only the first will be displayed when this property is set to true.

### Groups

- grouping

### See Also

- [ListGrid.groupBy](#method-listgridgroupby)

**Flags**: IRW

---
## Class: DrawShape

### Description
DrawItem to render a shape defined by executing the series of drawing commands in the \[commands\](#attr-drawshapecommands) array.

---
## Attr: TreeMenuButton.title

### Description
Title for this button. If not specified, the selected value from the tree will be displayed instead.

**Flags**: IRW

---
## Method: Class.getClassName

### Description
Gets the name of this class as a string.

### Returns

`[String](#type-string)` — String name of this instance's Class object.

---
## Attr: OperationBinding.requiredCriterion

### Description
A comma-separated list of field names that must be present in criteria / advancedCriteria provided by the caller. Failure to provide any one of these will yield a \[classAttr:RPCResponse.STATUS\_CRITERIA\_REQUIRED\_ERROR\](#classattr-rpcresponsestatus-criteria-required-error) from the server.

### Groups

- clientDataIntegration

**Flags**: IR

---
## Attr: DataSource.sqlUsePagingHint

### Description
If explicitly set true or left null, causes the server to use a "hint" in the SQL we generate for paged queries. If explicitly set false, forces off the use of hints. This property can be overridden per operationBinding - see \[attr:OperationBinding.sqlUsePagingHint\](#attr-operationbindingsqlusepaginghint).

Note this property is only applicable to \[SQL\](#attr-datasourceservertype) DataSources, only when a \[paging strategy\](#attr-datasourcesqlpaging) of "sqlLimit" is in force, and it only has an effect for those specific database products where we employ a native hint in the generated SQL in an attempt to improve performance.

### Groups

- sqlPaging

### See Also

- [OperationBinding.sqlUsePagingHint](#attr-operationbindingsqlusepaginghint)

**Flags**: IR

---
## Attr: ViewLoader.httpMethod

### Description
Selects the HTTP method that will be used when fetching content. Valid values are "POST" and "GET".

### Groups

- contentLoading

**Flags**: IRW

---
## Attr: FacetChart.facetFields

### Description
Specifies what \[class:DataSource\](#class-datasource) fields to use as the chart \[attr:FacetChart.facets\](#attr-facetchartfacets) for a databound chart. If \[attr:FacetChart.facets\](#attr-facetchartfacets) is also explicitly set, \[attr:FacetChart.facetFields\](#attr-facetchartfacetfields) is definitive but \[class:Facet\](#class-facet) properties will be picked up from \[attr:FacetChart.facets\](#attr-facetchartfacets) also present in the \[attr:FacetChart.facetFields\](#attr-facetchartfacetfields).

If neither this property nor \[attr:FacetChart.facets\](#attr-facetchartfacets) is set, a databound chart will attempt to auto-derive \[attr:FacetChart.facetFields\](#attr-facetchartfacetfields) from the DataSource fields. The first two text or text-derived fields in the DataSource will be assumed to be the \[attr:FacetChart.facetFields\](#attr-facetchartfacetfields).

### See Also

- [FacetChart.valueProperty](#attr-facetchartvalueproperty)

**Flags**: IR

---
## Attr: HeaderSpan.title

### Description
A title for this headerSpan, to display in the headerSpan button for this headerSpan and in other contexts such as the \[menu for picking visible fields\](#attr-listgridcanpickfields). Note: if you want to use HTML tags to affect the display of the header, you should do so via \[attr:HeaderSpan.headerTitle\](#attr-headerspanheadertitle) instead so that other places where the title appears in the UI are not affected. Refer to discussion at \[attr:ListGridField.title\](#attr-listgridfieldtitle).

### Groups

- headerSpan

**Flags**: IR

---
## Method: Canvas.visibilityChanged

### Description
Notification fired when this canvas becomes visible or hidden to the user. Note - this method is fired when the \[method:Canvas.isVisible\](#method-canvasisvisible) state of this component changes. It may be fired in response an explicit call to \[method:Canvas.show\](#method-canvasshow) or \[method:Canvas.hide\](#method-canvashide), or in response to a parent component being shown or hidden when this widgets \[attr:Canvas.visibility\](#attr-canvasvisibility) is set to "inherit".

Note that a call to \[method:Canvas.show\](#method-canvasshow) or \[method:Canvas.hide\](#method-canvashide) will not 
#### always
 fire this notification. If this widget has a hidden parent, show or hide would change this components \[attr:Canvas.visibility\](#attr-canvasvisibility) property, and may update the CSS visibility attribute of the drawn handle in the DOM, but would not actually hide or reveal the component to the user and as such the notification would not fire.

Note also that this notification will only be fired for components which have been \[drawn\](#method-canvasdraw).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| isVisible | [boolean](#type-boolean) | false | — | whether the canvas is visible to the user |

---
## Type: Selected

### Description
—

### Values

| Value | Description |
|-------|-------------|
| StatefulCanvas.FOCUSED | StatefulCanvas should show focused state |
| StatefulCanvas.SELECTED | StatefulCanvas is selected |
| StatefulCanvas.UNSELECTED | StatefulCanvas is not selected |

### Groups

- state

---
## Method: Sound.setCurrentTime

### Description
Move playback to a particular time in a loaded audio file.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| time | [Float](#type-float) | false | — | time to move to. This method will have no effect if the file has not been loaded or no \[attr:Sound.src\](#attr-soundsrc) element is defined. |

---
## Attr: Window.hiliteHeaderStyle

### Description
Highlight style for the Window header. Displayed when a window is \[flashed\](#method-windowflash)

### Groups

- appearance
- header

**Flags**: IRWA

---
## Object: AdvancedCriterionSubquery

### Description
A specialized subclass of \[object:DSRequest\](#object-dsrequest) that you use to declare the properties of a subquery (a \[fieldQuery\](#attr-criterionfieldquery) or \[valueQuery\](#attr-criterionvaluequery)) to be used in \[object:AdvancedCriteria\](#object-advancedcriteria). Subquery definitions are often very compact; only a few properties are permitted for a client-driven subquery (see "Restrictions on client-driven subqueries", below), and many use cases can be satisfied specifying just a \[dataSource\](#attr-advancedcriterionsubquerydatasource) and a \[summary function\](#attr-advancedcriterionsubquerysummaryfunctions).

Criteria subquery definitions fall into two broad categories:

*   #### Aggregation
    , where the subquery uses a \[type:SummaryFunction\](#type-summaryfunction) to aggregate or summarize a related dataset, and then filter on that aggregated or summarized value. For example, orders with more than 10 lines, customers with an average order value more than $1000, UK customers with an outstanding payment more than a week old, etc
*   #### Related value
    , where the subquery selects a value (or, for `inSet`\-type clauses, a set of values) from a related dataSource and then filters on that value. For example, Products that were not ordered last month, Employees who are based in one of the North American offices, Orders that include a particular category of Product, etc

In ideal circumstances - when both main and subquery \[dataSource\](#class-datasource)s are \[SQL DataSources\](#group-sqldatasource), and a number of other restrictions are satisfied - subqueries are implemented by incorporating their functionality into a larger overall SQL query, because this is the most efficient thing to do, and gives the best performance. See \[canEmbedSQL\](#attr-advancedcriterionsubquerycanembedsql) for a description of the rules and nuances around this.

In cases where we cannot implement subqueries by embedding SQL, they are implemented by converting the subquery definitions into separate real `DSRequest`s, executing them, and then combining their results into the wider resultset.

#### Subquery Overview
Subqueries are used to derive a value to be compared as part of the main query, from a set of related data where there is no way to directly join to a single record (usually because the subquery is summarizing or extracting from a larger dataset). Each subquery must return a single value per record in the main query, because it going to be compared to a single value from each main record (this value either comes directly from the main record, or is derived via a `fieldQuery`)

Because the nature of a subquery is that it is deriving a single value from multiple records, subqueries are often involved in some kind of aggregation (returning a record count, or the minimum value, for example). While this is the most common use of subqueries, it is not the only one - see the "Simple valueQuery" example below.

Whether or not a subquery is aggregating multiple records, it typically needs to be constrained by a join to the outer query. For example, if you were looking for all customers that have placed more than $1000-worth of orders, you would use something like the "Simple aggregating subquery" below. As you will see, that example displays no explicit means of joining the subquery to the outer query, and yet one is obviously necessary because we are looking for the sum of "lineValue" customer-by-customer, not the total sum for all customers.

This join from the subquery to the outer query is applied implicitly by SmartClient's SQL engine. It auto-discovers a Relation between the main dataSource and subquery dataSource by following \[foreignKey\](#attr-datasourcefieldforeignkey) definitions from the subquery dataSource, until it finds a path to the main dataSource. This auto-discovery usually does the right thing, but there are two possibilities it does not address:

*   There is no direct or indirect Relation from the subquery dataSource to the main dataSource. This is an unusual case for a subquery - most use use cases call for related dataSources - but valid cases are conceivable. To cope with this scenario, you set \[queryFK\](#attr-advancedcriterionsubqueryqueryfk) to the special value "`  #### *none*  `". Note, if SmartClient fails to find a path from the subquery dataSource to the main dataSource and `queryFK:"*none*"` has not been set, the framework will log a warning and the fetch will fail
*   There is more than one direct or indirect Relation from the subquery dataSource to the main dataSource, and you want to use a different one from the one that was auto-discovered. Again, the solution is to explicitly name the \[queryFK\](#attr-advancedcriterionsubqueryqueryfk) - see the documentation for that property for details of the syntax

Since SmartClient can only make use of a single value as output from a subquery, if your subquery returns multiple records, we will simply use the first. If the query returns multiple fields, you can specify the field to use as the subquery output with \[queryOutput\](#attr-advancedcriterionsubqueryqueryoutput). If the subquery returns more than one field and no `queryOutput` is specified, we will use the first aggregated (\[summaryFunction\](#attr-advancedcriterionsubquerysummaryfunctions)) field, or the first \[grouped\](#attr-advancedcriterionsubquerygroupby) field if there are no aggregated fields, or the \[primaryKey\](#attr-datasourcefieldprimarykey) field if there are also no `groupBy` fields, or just the first numeric field failing all else. Note, however, that although we attempt to derive a sensible value, it never makes sense to return multiple records from a subquery, and it only really makes sense to return multiple fields if you explicitly identify the correct field with `queryOutput`. Ideally, for the sake of clarity, return a single record, and either have that record contain a single field, or specify `queryOutput`

#### Restrictions on client-driven subqueries
For security reasons, subqueries in \[requests\](#object-dsrequest) that came from the client-side are only permitted to specify a handful of properties. These properties are sufficient to allow the full power of the subquery feature to be used, without allowing any of the much broader set of general properties associated with the `DSRequest` superclass. The properties that can be set in a client-driven subquery are just those that are documented as direct properties of the `AdvancedCriterionSubquery` class - specifically \[canEmbedSQL\](#attr-advancedcriterionsubquerycanembedsql), \[criteria\](#attr-advancedcriterionsubquerycriteria), \[dataSource\](#attr-advancedcriterionsubquerydatasource), \[groupBy\](#attr-advancedcriterionsubquerygroupby), \[operationId\](#attr-advancedcriterionsubqueryoperationid), \[queryFK\](#attr-advancedcriterionsubqueryqueryfk), \[queryOutput\](#attr-advancedcriterionsubqueryqueryoutput), and \[summaryFunctions\](#attr-advancedcriterionsubquerysummaryfunctions)

For `DSRequest`s that originally came from the server, it is possible to have a subquery that specifies any `DSRequest` property. Many of these would only have any relevance or effect if the subquery was run separately rather than embedded (as described above and in the \[canEmbedSQL\](#attr-advancedcriterionsubquerycanembedsql) doc). If you need to do this, look in the server Javadoc for `DSRequest.setAllowArbitrarySubqueries(boolean)`

Finally, note that it is possible to switch off the ability to use subqueries altogether, either \[per-DataSource\](#attr-datasourceallowcriteriasubqueries), or globally by setting the `allowCriteriaSubqueries` flag in your `server.properties` file:

 allowCriteriaSubqueries: false
 

#### `exists / notExists` operators
The \[`exists / notExists`\](#type-operatorid) operators provide a concise way to filter records based on the existence (or absence) of related rows.

When both main DataSource and suquery DataSource is backed by `SQLDataSource`, these operators are transformed into `EXISTS (...)` / `NOT EXISTS (...)` correlated subselects in the generated SQL. Non-SQL backends, as well as when \[canEmbedSQL:false\](#attr-advancedcriterionsubquerycanembedsql) is set for SQL backends, will execute subqueries as separate \[DSRequests\](#object-dsrequest) and apply their results manually.

These operators must be used with a \[fieldQuery\](#attr-criterionfieldquery):

 // EXISTS: at least one related row matches the subquery
 { operator: "exists",
   fieldQuery: { dataSource: "OrderLine", criteria: { /\* ... \*/ } }
 }
 

See full examples in the "Examples" section below.

#### Examples
Subqueries are quite hard to describe in narrative text, but the following examples demonstrate their use and should make things clearer

#### Simple aggregating subquery
This example uses a `fieldQuery` to select all Order records for customer 1234, where the order total (sum of all the order line values) is greater than $1000.

 Order.fetchData({
     \_constructor: "AdvancedCriteria", operator: "and", criteria: \[
         {fieldName: "customerNumber", operator: "equals", value: 1234},
         {
              fieldQuery: {
                  dataSource: "OrderLine",
                  summaryFunctions: {lineValue: "sum"}
              }, operator: "greaterThan", value: 1000
         }
     \] 
 });
 

#### Simple valueQuery
This example uses a `valueQuery` to derive the employeeNumber of a manager when we only know the email address of that manager, so we can find out who reports to her. This example shows how to use additional criteria within a subquery. It also demonstrates the relatively rare situation where no join to the outer dataSource is required (hence the declaration of `queryFK: "*none*"`)

 Employee.fetchData({
     \_constructor: "AdvancedCriteria", operator: "and", criteria: \[
         {
             fieldName: "reportsTo", 
             operator: "equals",
                 valueQuery: {
                     dataSource: "Employee",
                     queryFK: "\*none\*",
                     criteria: { operator: "and", criteria: \[
                         {fieldName: "email", operator: "equals", value: "mpatterson@classicmodelcars.com"}
                     \]
                 }
             }
         }
     \]
 });
 

#### More complex aggregation example
This example uses both a `fieldQuery` and a `valueQuery` to select all US-based customers who placed more orders in 2022 than they placed in 2021. Note, this is the number of orders, not the value, and the particular field that we add the "count" function to is not important (count is the same regardless of which field you count). We chose the orderNumber in this case, but that choice is arbitrary

 Customer.fetchData({
     \_constructor: "AdvancedCriteria", operator: "and", criteria: \[
         {fieldName: "country", operator: "equals", value: "USA"},
         {
             fieldQuery: {
                 dataSource: "Order",
                 summaryFunctions : { orderNumber : "count" },
                 criteria: {fieldName: "orderDate", operator: "iBetweenInclusive", 
                                         start:new Date("2021-01-01"), end:new Date("2021-12-31")}
             }, 
             operator: "lessThan",
             valueQuery: {
                 dataSource: "Order",
                 summaryFunctions : { orderNumber : "count" },
                 criteria: {fieldName: "orderDate", operator: "iBetweenInclusive", 
                                         start:new Date("2022-01-01"), end:new Date("2022-12-31")}
             }
         }
     \]
 });
 

#### `exists` / `notExists` operators
Show customers with any Orders in 2024 (exists).

 Customer.fetchData({
   \_constructor: "AdvancedCriteria", operator: "and", criteria: \[
     { operator: "exists",
       fieldQuery: {
         dataSource: "Order",
         criteria: { fieldName: "orderDate", operator: "iBetweenInclusive",
                     start: new Date("2024-01-01"), end: new Date("2024-12-31") }
       }
     }
   \]
 });
 

Products not ordered last month (notExists).

 Product.fetchData({
   \_constructor: "AdvancedCriteria", operator: "and", criteria: \[
     { operator: "notExists",
       fieldQuery: {
         dataSource: "OrderLine",
         criteria: { operator: "and", criteria: \[
           { fieldName: "orderDate", operator: "iBetweenInclusive",
             start: startOfLastMonth, end: endOfLastMonth }
         \]}
       }
     }
   \]
 });

### Groups

- advancedFilter

---
## Attr: EditContext.selectedTintOpacity

### Description
Opacity applied to \[editMask\](#attr-editproxyeditmask) of selected component when \[attr:EditProxy.selectedAppearance\](#attr-editproxyselectedappearance) is "tintMask".

This value is applied as a default to \[attr:EditProxy.selectedTintOpacity\](#attr-editproxyselectedtintopacity).

### See Also

- [EditContext.selectedTintColor](#attr-editcontextselectedtintcolor)

**Flags**: IR

---
## Group: serverDataIntegration

### Description
Server Data Integration means:

*   You \[install\](#group-iscinstall) the \[SmartClient Java Server Framework\](#group-iscserver) into any J2SE/J2EE environment, including any existing web application
*   You \[create DataSources\](#group-datasourcedeclaration) via an XML declaration, possibly on-the-fly from \[existing metadata\](#group-metadataimport).
*   Server communication for components bound to these DataSources is handled automatically with a highly efficient, compressed protocol. You work with clean Java APIs instead of dealing with the details of XML or JSON over HTTP.
*   You can use built-in connectors for SQL, Hibernate and other common data providers without writing any code, or you can easily build your own connectors in Java.
*   Whether using the built-in connectors or custom connectors, declarations in your DataSource control a large set of server features that can make common types of business logic entirely declarative

This approach is in contrast to \[Client-side Data Integration\](#group-clientdataintegration) in which client-side DataSources are configured to send and receive HTTP messages containing XML, JSON or other content.

#### Server-side Request Processing

Client-side \[DataBoundComponents\](#interface-databoundcomponent) will send \[DSRequests\](#object-dsrequest) to the SmartClient Server as background communications transparent to the user. Integrating SmartClient's DataSource layer with your data model is a matter of handling these DSRequests and sending back DSResponses, in order to fulfill the 4 basic operations of the \[DataSource Protocol\](#group-datasourceoperations).

Out of the box, SmartClient is set up to route all DSRequests through a special servlet called `IDACall`.

Note that the SmartClient SDK includes detailed Javadoc reference for this servlet and all shipped SmartClient Java server classes.

Requests that go through `IDACall` have the following lifecycle:

*   The overall HTTP request is received by the IDACall servlet. SmartClient supports queuing of transactions, so each HTTP request might contain multiple DSRequests.
*   IDACall sets up an instance of `RPCManager` to manage the processing of the entire queue of transactions. For every DSRequest in the queue, this RPCManager:

*   Validates the DSRequest
*   Checks the DataSource configuration for customizations implemented via \[server scripting\](#group-serverscript) or \[DMI\](#group-dmioverview) - in other words, your code - and passes the request to this logic.
    
    As described later in this section, your code can perform some custom logic here: either completely fulfilling the request, or alternatively modifying the request and causing the default processing of the request to continue
    
*   Calls the DataSource's `execute` method to obtain a DSResponse.

*   Having processed all requests, the RPCManager now serializes all the DSResponses and sends them back to the browser as a single HTTP response

This basic request handling flow can be customized at a number of points:

*   If you need an overarching authentication service, this is best implemented using [servlet Filters](http://java.sun.com/products/servlet/Filters.html) to intercept unauthenticated requests before they reach the `IDACall` servlet
*   The \[attr:DataSource.serverType\](#attr-datasourceservertype) specification within your `.ds.xml` configuration file is used to specify a standard server-side connector to service your requests.
*   General custom business logic can be added in a number of ways, both declaratively and programmatically:

*   The <criteria> and <values> properties of an \[class:OperationBinding\](#class-operationbinding) allow you to modify the dataSource request dynamically at transaction-processing time, using built-in \[Velocity support\](#group-velocitysupport).  
    Note this feature also allows developers to use \[Transaction Chaining\](#group-transactionchaining) to dynamically set data values according to the results of earlier transactions.
*   For editing, standard \[attr:DataSourceField.validators\](#attr-datasourcefieldvalidators) defined in the `.ds.xml` file will be processed on both the client and the server. In addition to the built-in validator types, entirely custom server validation logic may be implemented using \["serverCustom" type validators\](#type-validatortype).
*   For SQL DataSources, use \[SQL Templating\](#group-customquerying) to change, add to or even completely replace the SQL sent to the database, including calling stored procedures
*   The \[attr:DataSource.serverConstructor\](#attr-datasourceserverconstructor) allows you to specify an explicit custom DataSource subclass to create as your DataSource instance. This must be a subclass of `BasicDataSource`.  
    When requests are recieved by the `IDACall` servlet, they will be passed to standard methods on this DataSource, which can be overridden for custom behavior.  
    Validation is performed via a call to the `validate()` method.  
    The request is processed by the `execute()`, method which can be overridden directly, or developers may override the operation-specific methods `executeFetch()`, `executeAdd()`, `executeUpdate`, or `executeRemove()` called from the standard `execute()` implementation.  
    This approach allows you to either extend one of the built-in persistence mechanisms by subclassing a shipped class such as `SQLDataSource`, or create an entirely custom implementation from scratch.  
    A custom dataSource will still take full advantage of DataSource-agnostic features of the SmartClient Server, like validation, queuing, transaction chaining, support for Velocity templating, and so on.  
    For more information see the \[custom server dataSource overview\](#group-writecustomdatasource)
*   Use \[Direct Method Invocation\](#group-dmioverview) to call directly into your own Java classes. An operation configured to use DMI will invoke the specified method instead of running through the standard DataSource `execute()` method directly - the DMI implementation can then use `dsRequest.execute()` to call the default behavior. This means DMIs allow you to modify the `DSRequest` before it executes, modify the `DSResponse` before it returns, or replace the default behavior with unrelated actions. Note that DMI can be applied \[to all operations\](#attr-datasourceserverobject), or to \[individual operation bindings\](#attr-operationbindingserverobject), and can be used in conjunction with a \[custom dataSource\](#attr-datasourceserverobject).
*   Use \[server scripting\](#group-serverscript) to add small amounts of business logic right in your `.ds.xml` file (either \[per operation\](#attr-operationbindingscript), or as standard handling for \[all operations\](#attr-datasourcescript)). DMI scripts allow you to add business logic just like normal DMIs, but don't require the logic to be in a separate .java file.

  
*   If you need to use a Front Controller servlet for some other reason than authentication - for example, you are using Spring some other similar system which requires that all requests go through some particular servlet - just call `RPCManager.processRequest()` within your Spring Controller or whatever the equivalent is in the framework in use.
    
    However, note carefully that taking this approach is often a sign that the SmartClient architecture has not been correctly understood. SmartClient is architected for _client-server_ data communication, as opposed to early web MVC frameworks which do everything on the server. In particular, it is absolutely incorrect to represent every individual DataSource operation - or even every DataSource - as a separate Spring Controller because this implies different URLs for different operations. All DataSource operations should go through a single URL in order to allow \[transaction queuing\](#class-rpcmanager) - see these ${isc.DocUtils.linkForExampleId('transactionsFolder', 'Queuing examples')}.
    

For more information on the DMI subsystem, see the \[DMI overview\](#group-dmioverview), \[DMI class\](#class-dmi) and the ${isc.DocUtils.linkForExampleId('DMI', 'DMI example')} in the Feature Explorer.

Note that, as you continue to integrate your prototype with your backend, you can use a mixture of DataSources that have been fully integrated with your backend and DataSources that are running in "client-only" mode (see \[group:clientOnlyDataSources\](#group-clientonlydatasources)).

#### Important methods for handling DataSource requests

The basic flow of logic for handling DataSource requests is:

1\. Determine operation type (Fetch, Add, Update, Remove) for a single request. Not necessary if you follow the recommendations for \[writing a custom DataSource\](#group-writecustomdatasource) and provide your implementation via `executeFetch(), executeAdd()`, et al.

dsRequest.getOperationType()

2\. Get inbound values (Add, Update) and/or criteria (Fetch, Update, Remove) for this request.

dsRequest.getFieldValue()  
dsRequest.getValues()  
dsRequest.getCriteria()

3\. Business logic, validation, calls to data and service tiers... anything you can code.

#### execute custom logic

4\. Set status and data for the response.

dsResponse.setStatus()  
dsResponse.setData()

For more information, see the \[RPCManager documentation\](#class-rpcmanager), and the ${isc.DocUtils.linkForExampleId('ormDataSource', 'Custom ORM DataSource example')}.

---
## ClassAttr: Browser.isSupported

### Description
Whether SmartClient supports the current browser.

Note that this flag will only be available on browsers that at least support basic JavaScript.

**Flags**: R

---
## Method: ListGrid.cellErrorIconOver

### Description
Optional stringMethod to fire when the mouse moves over the error icon of a cell with validation errors.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| record | [ListGridRecord](#type-listgridrecord) | false | — | cell record as returned by getCellRecord() |
| rowNum | [number](#type-number) | false | — | row number for the cell |
| colNum | [number](#type-number) | false | — | column number of the cell |

### Returns

`[boolean](#type-boolean)` — false to suppress the default behavior (show a standard error message hover)

### Groups

- events

### See Also

- [ListGrid.showErrorIcons](#attr-listgridshowerroricons)

**Flags**: A

---
## Attr: ListGridField.groupingMode

### Description
For a field that allows multiple \[grouping modes\](#attr-listgridfieldgroupingmodes), the current grouping mode.

This property is set when a user chooses a particular grouping mode, and may be set on ListGrid creation to affect the initial grouping.

### Groups

- grouping

**Flags**: IR

---
## Method: Toolbar.itemDragResized

### Description
Observable, overrideable method - called when one of the Toolbar buttons is drag resized.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| itemNum | [number](#type-number) | false | — | the index of the item that was resized |
| newSize | [number](#type-number) | false | — | the new size of the item |

---
## Attr: DateItem.inputFormat

### Description
If \[attr:DateItem.useTextField\](#attr-dateitemusetextfield) is `true` this property can be used to specify the input format for date strings. If unset, the input format will be determined based on the specified \[attr:DateItem.dateFormatter\](#attr-dateitemdateformatter) if possible (see \[method:DateItem.getInputFormat\](#method-dateitemgetinputformat)), otherwise picked up from the Date class (see \[classMethod:DateUtil.setInputFormat\](#classmethod-dateutilsetinputformat)).

Should be set to a standard \[type:DateInputFormat\](#type-dateinputformat)

Note that the \[type:DateInputFormat\](#type-dateinputformat) property is sufficient to parse date or datetime strings specified in most standard date formats. However should an entirely custom parsing function be required developers can implement a custom \[method:DateItem.parseEditorValue\](#method-dateitemparseeditorvalue) method.

This attribute does not have an effect if a native HTML5 date input is being used. See \[attr:DateItem.browserInputType\](#attr-dateitembrowserinputtype).

### See Also

- [dateItem.displayFormat](#dateitemdisplayformat)

**Flags**: IRW

---
## Method: ListGrid.getDefaultFormattedFieldValue

### Description
Get a field value for some record with default field formatters applied.

This method differs from \[method:ListGrid.getDefaultFormattedValue\](#method-listgridgetdefaultformattedvalue) in a couple of ways. Firstly, this method does not rely on the rowNum and colNum parameters to find the record and field in the grid.  
Secondly, unlike \[method:ListGrid.getDefaultFormattedValue\](#method-listgridgetdefaultformattedvalue) this method _will_ call any explicit cell formatter specified on the field passed in (though it will not call a \[component level formatter\](#method-listgridformatcellvalue) if one exists).

This is useful for cases where a developer wishes to display a formatted value for some record and field combination which does not necessarily map to a cell displayed in the ListGrid.

If `rowNum` and `colNum` parameters are passed through to the field level cell formatter if one exists. If not explicitly provided these are defaulted to -1.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| record | [Record](#type-record) | false | — | the record object |
| field | [ListGridField](#type-listgridfield) | false | — | the field object |
| rowNum | [int](#type-int) | true | — | rowNum (passed to any field level cell formatter) |
| colNum | [int](#type-int) | true | — | colNum (passed to any field level cell formatter) |

### Returns

`[String](#type-string)` — Default formatted value

### See Also

- [ListGridField.formatCellValue](#method-listgridfieldformatcellvalue)

**Flags**: A

---
## Method: Window.setHeaderStyle

### Description
Setter for \[headerStyle\](#attr-windowheaderstyle).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| newHeaderStyle | [CSSStyleName](#type-cssstylename) | false | — | new \[styleName\](#attr-canvasstylename) for the \[header\](#attr-windowheader). |

---
## Class: ResetPasswordTask

### Description
Show user password reset dialog by opening the \[Auth.resetPasswordURL\](#classattr-authenticationresetpasswordurl) in another tab or window.

---
## Method: ValuesManager.itemChanged

### Description
Handler fired whenever a change to a FormItem fires itemChanged() on one of the member forms. Fires after that event.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| item | [FormItem](#type-formitem) | false | — | the FormItem where the change event occurred |
| newValue | [Any](#type-any) | false | — | new value for the FormItem |

---
## Method: CoTProcess.getPromptPart

### Description
Returns a named prompt fragment or concatenation of fragments for inclusion in task prompts. Built-in names:

*   #### "goal"
     – primer from \[attr:CoTProcess.goalPrimer\](#attr-cotprocessgoalprimer), then \[attr:CoTProcess.goal\](#attr-cotprocessgoal).
*   #### "history"
     – primer from \[attr:CoTProcess.historyPrimer\](#attr-cotprocesshistoryprimer), then recent entries (omitted if \[noHistory\](#attr-cotprocessnohistory) is true)
*   #### "transitions"
     – \[attr:CoTProcess.transitionsPrimer\](#attr-cotprocesstransitionsprimer) followed by the current task's transitions
*   #### "errors"
     – primer from \[attr:CoTProcess.errorsPrimer\](#attr-cotprocesserrorsprimer) (or \[attr:CoTTask.errorsPrimer\](#attr-cottaskerrorsprimer)), then current validation errors if any
*   #### "goalData"
     – the raw \[attr:CoTProcess.goal\](#attr-cotprocessgoal) value.

Names matching keys in \[attr:CoTProcess.optionalPrompts\](#attr-cotprocessoptionalprompts) return that text. Pass an Array of names to concatenate multiple parts. Set `omitNewlines` to true to omit surrounding newlines.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| names | [String](#type-string)|[Array of String](#type-array-of-string) | false | — | One or more fragment names |
| omitNewlines | [Boolean](#type-boolean) | false | — | If true, do not surround with newlines |

### Returns

`[String](#type-string)` — Assembled fragment(s)

### Groups

- CoT

---
## Method: EditContext.serializeEditNodesAsJSON

### Description
Serialize the provided \[EditNodes\](#object-editnode) to a JSON representation of \[PaletteNodes\](#object-palettenode). Note that the EditNodes must have been added to this EditContext. The result can be supplied to \[addPaletteNodesFromJSON()\](#method-editcontextaddpalettenodesfromjson) to recreate the EditNodes.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| nodes | [Array of EditNode](#type-array-of-editnode) | false | — | EditNodes to be serialized |
| settings | [SerializationSettings](#type-serializationsettings) | true | — | Additional serialization settings |

### Returns

`[String](#type-string)` — a JSON representtion of the provided EditNodes

---
## Method: Layout.reflow

### Description
Layout members according to current settings.

Members will reflow automatically when the layout is resized, members resize, the list of members changes or members change visibility. It is only necessary to manually call `reflow()` after changing settings on the layout, for example, `layout.reverseOrder`.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| reason | [String](#type-string) | true | — | reason reflow() had to be called (appear in logs if enabled) |

**Flags**: A

---
## Group: angularIntegration

### Description
As with \[other integrations\](#group-integrationintoexistingapps), you can add SmartClient components to your Angular application by providing SmartClient with a DOM element created by Angular (or even the ID of a DOM element before it's been created).

All the same mechanisms for loading the framework apply, although Isomorphic recommends FileLoader's \[cache\](#classmethod-fileloadercache) & \[load\](#classmethod-fileloaderload) functions in most cases, where it's desirable to load the SmartClient runtime in the \[background\](#group-backgrounddownload).

A simple way to facilitate that ability is to install SmartClient using Isomorphic \[npm support\](#group-npmjs), providing the location tag to point at a location that will be bundled with your app. The 'assets' directory is a standard location for such things, so from your project's root directory:

      npm install smartclient-eval --branch=13.0 --location=src/assets --yes
 

Next, use a script tag to load FileLoader itself, and ideally, follow it with a request to cache framework resources. So from perhaps a login.html, registration.html, and/or index.html:

     <script>window.isomorphicDir = "./assets/isomorphic/"; </script>
     <script src="./assets/isomorphic/system/modules/ISC\_FileLoader.js"></script>
     <script>
       isc.FileLoader.cache();
     </script>
 

Now you're ready to build SmartClient components and use them in your Angular components. Here, we have an complete Angular Component, written in TypeScript, that hooks into the Angular Component Lifecycle and calls an imported JavaScript helper function at the appropriate event:
#### list.component.ts

 import {Component, AfterViewInit, ViewChild, ElementRef} from '@angular/core';

 import {drawCanvasOnElement} from '@app/\_helpers/smartclient-framework';
 import {buildLayout} from './js/listComponent';

 @Component({
     template: \`<div #layout style="width:auto; height:250px;"></div>\`
 })
 export class ListComponent implements AfterViewInit {

     @ViewChild('layout', {static: true}) layoutElementRef: ElementRef;

     /\*
      \* When the Angular component creates the '#layout' element in the template,
      \* provide it to the drawCanvasOnElement helper function.  Note that we do
      \* not implement an ngOnDestroy function here to destroy the layout,
      \* since SmartClient while detect the destruction of the nativeElement and in
      \* turn destroy the component
      \*/
     ngAfterViewInit() {
         const ele = this.layoutElementRef.nativeElement;
         drawCanvasOnElement(buildLayout, ele);
     }
 }
 

This looks exactly like any other Angular component, but we import a few very simple JavaScript functions that do the heavy lifting.
#### ./js/listComponent.js

 export function buildLayout(element) {

   const ds = isc.DataSource.create({
     clientOnly: true,
     fields: \[
       {name: 'id', type: 'text', primaryKey: true, canEdit: false, hidden: true},
       {name: 'title', type: 'text', required: true, valueMap: \['Mr', 'Mrs', 'Miss', 'Ms'\]},
       {name: 'firstName', type: 'text', required: true},
       {name: 'lastName', type: 'text', required: true},
       {name: 'email', type: 'text', required: true,
         validators: \[
           {type: 'regexp', expression: '^(\[a-zA-Z0-9\_.\\\\-+\])+@((\[a-zA-Z0-9\\\\-\])+\\\\.)+\[a-zA-Z0-9\]{2,4}$'}
         \]
       },
       {name: 'role', type: 'text', required: true, valueMap: \['User', 'Admin'\]}
     \],
     cacheData: \[{
       id: 1,
       title: 'Mr',
       firstName: 'Joe',
       lastName: 'Bloggs',
       email: 'joe@bloggs.com',
       role: 'User',
       password: 'joe123'
     }\]
   });

   const grid = isc.ListGrid.create({
     dataSource: ds,
     autoFetchData: true,
     canEdit: true,
     canRemoveRecords: true
   });

   const button = isc.Button.create({
     title: 'Add User',
     autoFit: true,
     click: function() {
       grid.startEditingNew();
       return this.Super('click', arguments);
     }
   });

   /\* position the layout on the provided element \*/
   return isc.VLayout.create({
     autoDraw: true,
     htmlElement: element,
     matchElement: true,
     members: \[
       button,
       grid
     \],
     membersMargin: 10
   });
 }
 

This just creates a typical SmartClient Layout containing a databound ListGrid and a Button that manipulates the ListGrid, the same as any other SmartClient component creation. Note that when it's drawn, the layout will be placed in the DOM element created by the Angular component thanks to \[attr:Canvas.htmlElement\](#attr-canvashtmlelement).

Finally, a little helper `drawCanvasOnElement` function that causes the SmartClient runtime to be loaded if it hasn't already, and provides the given element to the builder function when everything is ready.

#### @app/\_helpers/smartclient-framework.js

 /\*
  \* Load the SmartClient Runtime if it hasn't yet been, positioning a spinner placeholder
  \* over the given element until the framework is available.  At that time, provide the
  \* element to a 'builder' function, which will use it to create a component at the right
  \* place.
  \*/
 export function drawCanvasOnElement (builder, element) {

     isc.FileLoader.load(() => {
         builder(element);
     }, {target: element});
 }

---
## Attr: Class.autoCreator

### Description
Specifies the component on which \[method:Class.createAutoChild\](#method-classcreateautochild) should be called to create \[group:autoChildren\](#group-autochildren) defined lazily on this component in the format "autoChild:_autoChildName_". This property may be either specified as a live component, or set to the `_childName_` of another already-created AutoChild.

If left unspecified, the Framework applies rules to determine which component to use as the creator. If this component is itself an autochild, and properties or defaults for the child are defined on its \[attr:Class.creator\](#attr-classcreator) but not on the component itself, then the creator of this component is also used to create the new AutoChild. Otherwise, this component is used.

### Groups

- autoChildren

### See Also

- [autoChildren](#group-autochildren)

**Flags**: IRA

---
## Method: Layout.removeMember

### Description
Removes the specified member from the layout. If it has a resize bar, the bar will be destroyed.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| member | [Canvas](#type-canvas) | false | — | the canvas to be removed from the layout |

---
## Method: ListGrid.getHeaderSpanContextMenuItems

### Description
Return the menus items that should be shown in a menu triggered from a \[headerSpan\](#attr-listgridheaderspans). The default implementation returns the parent element's context menu, unless \[attr:ListGrid.showHeaderSpanContextMenu\](#attr-listgridshowheaderspancontextmenu) is `true`, in which case it returns standard items for showing / hiding fields and freezing / unfreezing header spans. Note that no column picker will be shown unless \[attr:ListGrid.showTreeColumnPicker\](#attr-listgridshowtreecolumnpicker) is `true`.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| headerSpan | [HeaderSpan](#type-headerspan) | false | — | the component representing the headerSpan. This component will have all the properties specified via \[attr:ListGrid.headerSpans\](#attr-listgridheaderspans). |

### Returns

`[Array of MenuItem](#type-array-of-menuitem)` — return false instead to avoid showing any menu

### Groups

- headerSpan

---
## Attr: ListGridField.valueIconWidth

### Description
Width for value icons for this listGrid field. Overrides \[attr:ListGrid.valueIconSize\](#attr-listgridvalueiconsize), \[attr:ListGrid.valueIconWidth\](#attr-listgridvalueiconwidth), and \[attr:ListGridField.valueIconSize\](#attr-listgridfieldvalueiconsize).

### Groups

- imageColumns

**Flags**: IRW

---
## Method: CellSelection.selectSingleCell

### Description
select a single cell and deselect everything else

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| rowNum | [int](#type-int) | false | — | row index of cell to select |
| colNum | [int](#type-int) | false | — | column index of cell to select |

### Returns

`[Boolean](#type-boolean)` — true == selection actually changed, false == no change

### Groups

- selection

---
## Attr: DSRequest.endRow

### Description
End row of requested results, used only with fetch operations.

Note that startRow and endRow are zero-based, inclusive at the beginning and exclusive at the end (like substring), so startRow: 0, endRow: 1 is a request for the first record.

### Groups

- paging

**Flags**: IR

---
## Class: SpacerItem

### Description
A SpacerItem takes up a single cell in the FormLayout, of arbitrary size.

---
## Attr: ListGrid.sorterConstructor

### Description
Widget class for the corner sort button, if showing. This button displays the current sort direction of the primary sort field (either the only sorted field or the first in a \[multi-sort\](#attr-listgridcanmultisort) grid) and reverses the direction of that field when clicked. For consistent appearance, this is usually set to match \[attr:ListGrid.headerButtonConstructor\](#attr-listgridheaderbuttonconstructor)

### Groups

- gridHeader
- appearance

**Flags**: IR

---
## Attr: CalendarEvent.styleName

### Description
CSS style series to use for \[canvas instances\](#attr-calendareventcanvas) that represent this event in the various \[calendar views\](#class-calendarview). The basic series should include three classes - the base style and others suffixed "Header" and "Body".

If not specified on the event, the style can be specified on the \[calendar\](#attr-calendareventstylename), the \[view\](#attr-calendarvieweventstylename) or individually on each \[lane\](#attr-laneeventstylename) or \[sublane\](#attr-lanesublanes).

The name of this field within the CalendarEvent can be changed via \[attr:Calendar.eventStyleNameField\](#attr-calendareventstylenamefield)

**Flags**: IR

---
## Attr: FieldPicker.instructionLabel

### Description
A \[label\](#class-label) displaying the text assigned as the FieldPicker's \[instructions\](#attr-fieldpickerinstructions). Shown across the top of the widget.

**Flags**: IR

---
## Attr: ListGrid.collapseGroupOnRowClick

### Description
If \[attr:ListGrid.canCollapseGroup\](#attr-listgridcancollapsegroup) is true, will a click anywhere on the group row toggle the group's expanded state? If false, the user must click the \[attr:ListGrid.groupIcon\](#attr-listgridgroupicon) directly to toggle the group.

### Groups

- grouping

### See Also

- [ListGrid.groupBy](#method-listgridgroupby)

**Flags**: IR

---
## ClassMethod: Canvas.stopDebuggingOverflow

### Description
Stop tracking and reporting excessive overflow.

### See Also

- [Canvas.startDebuggingOverflow](#classmethod-canvasstartdebuggingoverflow)

---
## Attr: ResultTree.serverKeepParentsOnFilter

### Description
If true, indicates that your own server code will handle the complexities associated with the combination of \[keepParentsOnFilter\](#attr-resulttreekeepparentsonfilter) and \[loadDataOnDemand\](#attr-resulttreeloaddataondemand). If this flag is true and your server code does _not_ handle those complexities, the results are undefined, but most likely you will simply exclude non-matching parents if your tree is load-on-demand, which effectively means that filtering will be broken.

If this flag is not set, SmartClient will use its own automatic client-driven algorithm to ensure that `keepParentsOnFilter` is honored on load-on-demand trees. See the `keepParentsOnFilter` overview for details

**Flags**: IRW

---
## Attr: Scrollbar.cornerSize

### Description
Allows the size of the corner segment to be set independently of the \[attr:Scrollbar.btnSize\](#attr-scrollbarbtnsize).

### Groups

- corner

**Flags**: IR

---
## Attr: CubeGrid.editByCell

### Description
CubeGrids only support editing by cell.

### Groups

- cellEditing

**Flags**: R

---
## Attr: RPCRequest.suppressAutoDraw

### Description
If \[attr:RPCRequest.evalResult\](#attr-rpcrequestevalresult) is set, setting this property to true causes \[attr:Canvas.autoDraw\](#attr-canvasautodraw) to be set to false for the duration of the result evaluation - which is generally what you want if you're returning new components from the server.

This also effects components loaded via the \[classMethod:RPCManager.loadScreen\](#classmethod-rpcmanagerloadscreen) API.

**Flags**: IRWA

---
## ClassMethod: RPCManager.isScreenCached

### Description
Returns true if a screen with the given name has already been cached by a call to \[classMethod:RPCManager.cacheScreens\](#classmethod-rpcmanagercachescreens) or similar (e.g. \[classMethod:RPCManager.loadProject\](#classmethod-rpcmanagerloadproject)), false otherwise.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| screenName | [String](#type-string) | false | — | name of the screen |

### See Also

- [LoadScreenSettings.cacheScreen](#attr-loadscreensettingscachescreen)

---
## Object: RESTAuthentication

### Description
Authentication settings, applicable only to the \[RestConnector\](#group-serverrestconnector)

### Groups

- serverRestConnector

---
## Method: ListGrid.anySelected

### Description
Whether at least one item is selected

### Returns

`[boolean](#type-boolean)` — true == at least one item is selected false == nothing at all is selected

### Groups

- selection

---
## Attr: JSONEncoder.skipNullValues

### Description
If true, don't include properties with null values when encoding an object.

**Flags**: IR

---
## ClassMethod: Page.setIsomorphicDir

### Description
Specify the root directory for Isomorphic-supplied files - the directory containing the `modules/` and `system/` subdirectories shipped as part of the SmartClient package.

Note that this property is commonly specified directly in the bootstrap HTML file by setting `window.isomorphicDir` before loading the SmartClient library files.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| URL | [String](#type-string) | true | — | New IsomorphicDir URL. |

### Groups

- files

---
## Attr: SectionStack.canTabToHeaders

### Description
If true, the headers for the sections (if shown) will be included in the page's tab order for accessibility. May be overridden at the Section level via \[attr:SectionStackSection.canTabToHeader\](#attr-sectionstacksectioncantabtoheader)

If unset, section headers will be focusable if \[staticMethod:isc.setScreenReaderMode\](#staticmethod-iscsetscreenreadermode) has been called. See \[group:accessibility\](#group-accessibility).

**Flags**: IRA

---
## Method: TileLayout.getTile

### Description
Retrieve a tile by index.

The TileLayout consistently uses this method to access tiles, in order to allow subclasses to create tiles on demand.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| index | [int](#type-int) | false | — | index of the tile |

### Returns

`[Canvas](#type-canvas)` — the tile

---
## Group: paging

### Description
—

---
## ClassMethod: Page.getIsomorphicDir

### Description
Return the root directory for Isomorphic-specific files.

### Returns

`[String](#type-string)` — IsomorphicDir URL.

### Groups

- files

---
## Attr: LoadScreenSettings.missingDSIsNotFatal

### Description
If true, server logic does not crash out if it cannot load a DataSource specified in the screen definition. Instead, a stub DataSource is returned, which consists of nothing except the ID and an `unableToLoad` flag, which client-side code can use to determine that the DataSource could not be loaded on the server. Optional, defaults to false (ie, a missing DataSource causes a crash by default)

**Flags**: IRW

---
## Attr: ResultSet.requestProperties

### Description
Allows to set a DSRequest properties to this ResulSet.

**Flags**: IR

---
## Attr: EventCanvas.headerStyle

### Description
CSS class for the \[header area\](#attr-eventcanvasshowheader) of the EventCanvas. If unset, defaults to the \[base styleName\](#attr-eventcanvasstylename) with the suffix "Header".

### Groups

- appearance

**Flags**: IRW

---
## ClassAttr: EventHandler.STOP_BUBBLING

### Description
Return this constant from a child event to stop the event propagating to its parent, without suppressing any native browser handling associated with the event. Developers should not need to modify this value - it should be treated as read-only in most circumstances.

**Flags**: IRA

---
## Method: ListGrid.editFailed

### Description
Called when an attempt to save inline edits fails, due to a validation error or other server error.

The default implementation of editFailed does nothing for normal validation errors, which are displayed before editFailed() is called. For any other errors, the default implementation will call \[classMethod:RPCManager.handleError\](#classmethod-rpcmanagerhandleerror), which by default will result in a warning dialog.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| rowNum | [number](#type-number) | false | — | current index of the row we attempted to save |
| colNum | [number](#type-number) | false | — | index of the column where the edit failed, if applicable |
| newValues | [Object](#type-object)|[Record](#type-record) | false | — | new values that we attempted to save |
| oldValues | [Record](#type-record) | false | — | the complete original values from before the save occurred |
| editCompletionEvent | [EditCompletionEvent](#type-editcompletionevent) | false | — | Edit completion event that led to the save attempt |
| dsResponse | [DSResponse](#type-dsresponse) | true | — | DSResponse, for saves through a DataSource |

### Groups

- editing

---
## Method: Calendar.timelineEventMoved

### Description
Called when a Timeline event is moved via dragging by a user. Return false to disallow the move.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| event | [CalendarEvent](#type-calendarevent) | false | — | the event that was moved |
| startDate | [Date](#type-date) | false | — | new start date of the passed event |
| endDate | [Date](#type-date) | false | — | new end date of the passed event |
| lane | [Lane](#type-lane) | false | — | the Lane in which this event has been dropped |

### Returns

`[Boolean](#type-boolean)` — return false to disallow the move.

**Deprecated**

---
## Attr: ListGridField.includeFrom

### Description
Indicates this field's values should be fetched from another, related DataSource. The individual field will inherit settings such as \[field.type\](#attr-listgridfieldtype) and \[field.title\](#attr-listgridfieldtitle) from the related DataSource just like fields from the primary DataSource.

When \[fechData()\](#method-listgridfetchdata) is called, the automatically created \[object:DSRequest\](#object-dsrequest) will specify \[attr:DSRequest.additionalOutputs\](#attr-dsrequestadditionaloutputs) requesting the field, and any \[type:Criteria\](#type-criteria) generated by the component will likewise refer to the field from the related DataSource.

It's an error to use this property if the ListGrid does not have a DataSource at all. The related DataSource must be loaded or a warning will be logged and the field definition ignored.

This value is expected to be set to the following format `dataSourceID.fieldName` where _dataSourceID_ is the ID of the related dataSource and _fieldName_ is the name of the field from that dataSource from which you wish to retrieve values. Note that if this property is set and \[field.name\](#attr-listgridfieldname) is not explicitly specified, this field's `name` will default to the _fieldName_ value from this property.

Note about automatic cache updates: "update" and "add" operations submitted automatically by this ListGrid will include `dsRequest.additionalOutputs` to ensure all data necessary for cache updates is returned by the server.

If your grid shows data that can be edited elsewhere in the UI (not by inline editing), to avoid problems with \[class:ResultSet\](#class-resultset) automatic cache synchronization, you may need to switch from using `listGridField.includeFrom` to `dataSourceField.includeFrom`. This is because server responses to "add" and "update" operations which are initiated outside of this grid do not know about the `listGridField.includeFrom` setting, and so will not automatically return data for fields included in this way. Switching to `dataSourceField.includeFrom` ensures the field is always included in server responses, avoiding the issue.

### Groups

- display_values

**Flags**: IR

---
## Attr: Snapbar.showDown

### Description
Snapbars show mouse-down styling.

**Flags**: IRW

---
## Attr: ListGrid.operatorIcon

### Description
Inline icon shown inside \[filter editor\](#attr-listgridshowfiltereditor) fields when \[attr:ListGrid.allowFilterOperators\](#attr-listgridallowfilteroperators) is enabled.

**Flags**: I

---
## Attr: ShowHideTask.targetSectionName

### Description
If \[componentId\](#attr-componenttaskcomponentid) targets a SectionStack, this property specifies the name of the target section. Alternately, the target section can be specified by using \[attr:ShowHideTask.targetSectionTitle\](#attr-showhidetasktargetsectiontitle).

**Flags**: IR

---
## Method: DateItem.setSelectionRange

### Description
If \[attr:DateItem.useTextField\](#attr-dateitemusetextfield) is true, falls through to standard \[setSelectionRange()\](#method-textitemsetselectionrange) implementation on this items freeform text entry field. Otherwise has no effect.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| start | [int](#type-int) | false | — | character index for start of new selection |
| end | [int](#type-int) | false | — | character index for end of new selection |

---
## Method: SavedSearches.getApplicationId

### Description
Retrieves the value to saves as the link{SavedSearches.applicationIdField,"applicationIdField"} value for saved searches within this application.

Returns \[this.applicationId\](#attr-savedsearchesapplicationid) if specified, otherwise the current [window.location.pathname](https://www.w3schools.com/jsref/prop_loc_pathname.asp) will be returned by default.  
Set \[attr:SavedSearches.allowNullApplicationId\](#attr-savedsearchesallownullapplicationid) to suppress this behavior of defaulting to the location.pathname.

### Returns

`[String](#type-string)` — applicationId to be stored for saved searches.

---
## Attr: FacadeDataSource.queuedRequests

### Description
An array of derived DS requests that are queued to be \[executed\](#method-datasourceexecute) on the underlying \[inherited\](#attr-datasourceinheritsfrom) DataSource.

When a DS request is made on this FacadeDataSource, if \[queueRequests\](#attr-facadedatasourcequeuerequests) is true, then a new DS request is created based on the given DS request and added to this queue.

To clear the queue, set \[queueRequests\](#attr-facadedatasourcequeuerequests) to false or call \[clearQueue()\](#method-facadedatasourceclearqueue).

**Flags**: R

---
## StaticMethod: isA.nonemptyString

### Description
Is `object` a non-empty String?

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| object | [Object](#type-object) | false | — | object to test |

### Returns

`[boolean](#type-boolean)` — true == `object` is a non-empty string

---
## Method: DrawPane.zoom

### Description
Synonym of \[method:DrawPane.setZoomLevel\](#method-drawpanesetzoomlevel).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| zoomLevel | [float](#type-float) | false | — | Desired zoom level as a float where `1.0` is equivalent to 100% magnification. Must be greater than 0. |

---
## Attr: ComboBoxItem.pickerExitButton

### Description
\[class:NavigationButton\](#class-navigationbutton) to dismiss the picker interface, created when \[attr:ComboBoxItem.pickListPlacement\](#attr-comboboxitempicklistplacement) indicates that the search interface takes over the entire panel or screen.

The following \[passthroughs\](#group-autochildusage) apply:

*   \[pickerExitButtonTitle\](#attr-comboboxitempickerexitbuttontitle) for \[attr:Button.title\](#attr-buttontitle)

### Groups

- panelPlacement

**Flags**: IR

---
## Method: ListGrid.cellContextClick

### Description
Called when a cell receives a contextclick event.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| record | [ListGridRecord](#type-listgridrecord) | false | — | cell record as returned by getCellRecord |
| rowNum | [number](#type-number) | false | — | row number for the cell |
| colNum | [number](#type-number) | false | — | column number of the cell |

### Returns

`[boolean](#type-boolean)` — whether to cancel the event

### Groups

- events

---
## Attr: Canvas.locatePeersType

### Description
\[type:LocatorTypeStrategy\](#type-locatortypestrategy) to use when finding peers of this canvas.

### Groups

- autoTest

**Flags**: IRWA

---
## Group: mobileDevelopment

### Description
SmartClient is designed to automatically adapt to smaller screen sizes and the lower accuracy of touch-based interfaces.

In general, a SmartClient application written with complete ignorance of mobile development will still be highly usable on tablet or handset-sized touch devices. This topic explains all the automatic behaviors that make this possible, and the few areas developers need to consider in order to optimize the mobile experience, the most important being:

*   read about potential issues created by the automatically shown and hidden browser toolbars in Safari on iOS7+, discussed under "minimal-ui" below. SmartClient automatically handles this, but most applications will want to create a non-interactive banner to fill the blank screen area that is rendered unusable by iOS' behavior
*   read about "Automatic touch scrolling" below - if your application does not already have alternative UIs for performing drag operations (as is required anyway for \[accessibility reasons\](#group-accessibility)), this section discusses options for controlling drag scrolling vs dragging of data
*   review your application for the rare screen that has a fixed, very wide width and doesn't allow scrolling. Such screens would already be unusable for narrow desktop browsers but are more of a problem for fixed-size mobile screens. The section "Exceptionally wide screens" below explains strategies for dealing with this.

#### Supported Browsers

*   Safari on iOS devices (iPad, iPhone, iPod Touch)
*   Android's default (WebKit-based) browser 
    #### \*
    
*   Windows Phone default browser, latest release only 
    #### \*\*
    
*   Blackberry 10+ default (WekKit-based) browser 
    #### \*\*
    

#### \*
: Android issues that occur _exclusively_ on rare devices (under a certain percent of market share) will not normally be covered by a Support plan. This is a necessity because highly customized versions of Android are used for a variety of niche devices (even microsatellites)  
#### \*\*
: These browsers generally work and bug reports are accepted, but they do not yet fall under the normal Enterprise+ Support guarantee of fixing every confirmed bug

If you would like to check whether a specific device falls under normal Support, or would like a quote for a Support plan that would include a specific device or platform, [contact Isomorphic here](http://smartclient.com/company/contact.jsp).

#### Adaptive Components

Many SmartClient components automatically change their behavior and/or appearance when used with touch devices in general, or tablets and handsets specifically. There are too many adaptations to comprehensively list, but some of the more obvious behaviors are listed below:

*   \[class:SelectItem\](#class-selectitem) and \[class:ComboBoxItem\](#class-comboboxitem) controls automatically fill the entire screen or a major portion of the screen when activated, and add a control to dismiss the full-screen interface. See \[attr:ComboBoxItem.pickListPlacement\](#attr-comboboxitempicklistplacement) for details
*   \[class:Menu\](#class-menu) components likewise fill the entire screen or a major portion, and offer submenu navigation via a slide-in animation and back button instead of displaying the origin menu and submenu simultaneously
*   \[Calendar\](#attr-calendarminimalui) eliminates the tabs normally used to switch between Day, Week and Month view, instead using device pivot to switch between Day and Week views and offering a compact link to Month view
*   Windows and Dialogs fill the screen by default and remove rounded edges to save space
*   many controls implement an expanded hit area for clicks or drags so that finger touches that are technically outside of the drawn area of the control still activate the control. This accommodates the imprecision of finger touches as compared to mouse clicks, while still showing the same compact appearance as is used for desktop interfaces. This includes the \[class:Slider\](#class-slider) thumb, \[attr:Window.headerControls\](#attr-windowheadercontrols), \[edge-based resizing\](#attr-canvasresizefrom), and many other controls.
*   \[class:SpinnerItem\](#class-spinneritem) switches to side-by-side +/- controls instead of the very small, vertically stacked +/- control typical of desktop interfaces
*   \[class:AdaptiveMenu\](#class-adaptivemenu) can either display menu items inline, or in a drop-down, or mix the two modes according to available space.

In addition to automatic behavior, SmartClient offers Adaptive Layout whereby a \[class:Layout\](#class-layout) member may be _designed_ to render itself at multiple possible sizes, in order to fit into the amount of space available in the Layout. Unlike simply indicating a flexible size on a member, setting an adaptive width or height indicates that the member has two (or more) different _ways_ of rendering itself with different _discrete_ sizes, but does not have the ability to use every additional available pixel.

For more guidance, see the documentation under \[attr:Canvas.canAdaptWidth\](#attr-canvascanadaptwidth) and the ${isc.DocUtils.linkForExampleId('inlinedMenuMobileSample', 'Inlined Menu Mobile')} and ${isc.DocUtils.linkForExampleId('adaptiveMenuMobileSample', 'Adaptive Menu')} samples.

#### Finger / touch event handling

Mobile and touch devices support "touch events" that correspond to finger actions on the screen. By default, SmartClient simply sends touch events to UI components as normal mouse events. Specifically:

*   a finger tap gesture will trigger mouseDown, mouseUp and click events
*   a touch-and-slide interaction will trigger drag and drop, firing the normal SmartClient sequence of dragStart, dragMove, and dragStop
*   a touch-and-hold interaction will trigger a contextMenu event, and will trigger a hover if no contextMenu is shown

This means that most applications that are written with mouse interaction in mind will function with a touch-based UI without special efforts. Some interfaces which rely heavily on mouse hovers may want to display instructions to explicitly tell the user that they have to touch a given element to see more information.

#### Automatic touch scrolling

Components that normally show scrollbars on desktop browsers will, by default, hide scrollbars and allow scrolling via finger dragging instead.

If you are using drag and drop features such as \[attr:ListGrid.canReorderRecords\](#attr-listgridcanreorderrecords), this obviously conflicts with using finger drags for scrolling. There are two options:

1.  Leave touch scrolling active for the grid, but provide additional controls, such as buttons, that enable users to perform the drag operation in a different way. Optionally display scrollbars _in addition to_ leaving touch scrolling active by setting \[attr:Canvas.alwaysShowScrollbars\](#attr-canvasalwaysshowscrollbars) to `true`.
2.  Set \[useTouchScrolling\](#attr-canvasusetouchscrolling) to `false` on the component. Scrollbars will be shown, and finger drags will no longer cause scrolling, so that finger drags can now be used for the drag and drop operation configured on the component

Option #1 above is generally preferred, since it is also considered an \[group:accessibility\](#group-accessibility) violation if drag and drop is the sole way to trigger an operation (keyboard-only users cannot use drag and drop), and also because scrollbars are not usually found in touch interfaces.

If your application is not required to be keyboard accessible, and you prefer to show scrollbars and use finger drags for normal drag operations, you can use \[attr:Canvas.disableTouchScrollingForDrag\](#attr-canvasdisabletouchscrollingfordrag) to make this choice system-wide or on a per-component-type basis.

#### Exceptionally wide screens / forms

If you have designed a screen for desktop use and it is too wide to fit on a handset or tablet-sized screen, there are several possible strategies:

*   #### use \[class:SplitPane\](#class-splitpane)
    : any time you have two or more panes where a choice in one pane decides what is displayed in the other. See the "SplitPane" section further down for details
*   #### rely on horizontal scrolling
    : if you have something like a \[class:DynamicForm\](#class-dynamicform) that has 3 columns of input fields, as long as the form itself or some parent has \[overflow:"auto"\](#attr-canvasoverflow) set, horizontal touch scrolling will be available to reach fields that initially render offscreen. Most of the time, there is already an `overflow:"auto"` parent component as a result of default framework behaviors or application settings that also make sense for desktop mode, so nothing needs to be done.
    
    However, consider whether scrolling is already in use for other purposes: if you have a grid plus an adjacent component to the right, if the adjacent component is entirely offscreen, attempting touch scrollng on the grid will just scroll the grid as such and won't reveal the adjacent component. In this kind of situation, you can:
    
    *   _use \[class:SplitPane\](#class-splitpane)_ as described above, a grid with something adjacent is frequently a good candidate for conversion to `SplitPane`
    *   _make the scrolling component smaller or flexible size_. Whether it's a grid or other scrollable component on the left, this situation usually arises because an inappropriately large fixed size has been set, instead of a \[flexible size\](#attr-canvaswidth).
    *   _leave some blank space_ above or below the grid - this gives the user somewhere to use touch scrolling to move both the grid and adjacent component
    *   _force scrollbars to appear_ by setting \[useTouchScrolling\](#attr-canvasusetouchscrolling) to false. This is another way to give the user a place they can touch in order to scroll the both the grid and adjacent component together
*   #### use \[class:FlowLayout\](#class-flowlayout)
    : a `FlowLayout` can automatically take two side-by-side elements and switch them to vertical stacking when the screen is narrow

#### SplitPane

The \[class:SplitPane\](#class-splitpane) component implements the common pattern of rendering two or three panes simultaneously on desktop machines and on tablets in landscape orientation, while switching to showing a single pane for handset-sized devices or tablets in portrait orientation.

Use `SplitPane` anywhere you have two or more panes in your application where a choice in one pane decides what is displayed in the other pane. For example, you may have a list of Records where details of a single selected Record are shown next to the list. A `SplitPane` is well-suited to this interface since it provides automatic "Back" navigation and a place to show the title of the selected record when only the detail view is showing.

Note that you do not need to use a `SplitPane` as your top-level component containing the whole application, and it _does_ makes sense to use multiple `SplitPane` components in a single application. For example, your top-level container component might be a \[class:TabSet\](#class-tabset), and a \[class:SplitPane\](#class-splitpane) would be used to manage components in tabs which normally show 2 panes side-by-side on desktop browsers.

#### Device type and overriding

In most cases SmartClient will correctly detect the device running your application, and set the flags \[classAttr:Browser.isTouch\](#classattr-browseristouch), \[classAttr:Browser.isHandset\](#classattr-browserishandset), \[classAttr:Browser.isTablet\](#classattr-browseristablet) and \[classAttr:Browser.isDesktop\](#classattr-browserisdesktop) appropriately.

For any uncommon device for which these variables are not set correctly, you can use \[classMethod:Browser.setIsTablet\](#classmethod-browsersetistablet), \[classMethod:Browser.setIsHandset\](#classmethod-browsersetishandset) and \[classMethod:Browser.setIsTouch\](#classmethod-browsersetistouch) to override the auto-detected settings. If you use these APIs, call them 
#### before
 creating or drawing any SmartClient components or using any other SmartClient APIs.

Note that the various automatic behaviors triggered by flags on the \[class:Browser\](#class-browser) class can be overriden at a fine-grained level on individual components. For example, \[class:SplitPane\](#class-splitpane) will use 2-pane display when a tablet is detected, however, for a particularly large, high-resolution tablet device, you could instead use 3-pane display by setting \[attr:SplitPane.deviceMode\](#attr-splitpanedevicemode) to "desktop".

#### Mobile look and feel

We recommend using either the Shiva, Tahoe, Twilight, Stratus or Obsidian skins for applications that support mobile (or a custom skin based on one of these skins). These skins make maximum use of CSS3 to minimize the number of images that need to be loaded and the number of DOM elements used to create components.

We also do 
#### not
 recommend attempting to mimic the native UI of each particular mobile platform, because:

*   if users access the same application via desktop and mobile browsers, consistent appearance and behavior between the desktop and mobile rendering of the application is more important for familiarity than looking similar to other applications on the mobile device
*   mobile platform design overhauls, such as the major changes from iOS6 to iOS7, can easily invalidate efforts to look like native applications on the device
*   there is no single consistent appearance across Android devices because different manufacturers customize the platform a great deal, so efforts to closely mimic any one device won't yield any real consistency

#### iOS 7, browser toolbars and "minimal-ui" setting

Safari in iOS 7.0 will automatically hide and show browser toolbars as the user scrolls around a normal web page, pivots, or touches near edges of the screen. This creates serious problems for web applications, partly because notifications are not reliably fired when toolbars are shown and hidden, and partly because it introduces "dead zones" where an application cannot place interactive controls, since touching there shows browser toolbars instead.

iOS 7.1 introduces a "minimal-ui" setting on the viewport `meta` tag which eliminates most of these problems, by requiring that the user specifically touch the URL bar to reveal browser toolbars. Even with this setting, the top 20px of space _in landscape orientation only_ is still a "dead zone".

SmartClient automatically uses the minimal-ui setting whenever iOS is detected, and also sets \[classAttr:Canvas.defaultPageSpace\](#classattr-canvasdefaultpagespace) to 20px in landscape orientation to avoid components being placed in the dead zone. These default behaviors can be disabled by defining the `isc_useMinimalUI` global variable with the value `false` before the framework is loaded:

 <script type="text/javascript">
 window.isc\_useMinimalUI = false;
 </script>

Whether minimal-ui is used or not, it is recommend to place some kind of non-interactive widget or content in the dead zones created by browser toolbars, for example, a \[class:Label\](#class-label) showing your company name or application name. When using \[classAttr:Canvas.defaultPageSpace\](#classattr-canvasdefaultpagespace) to have all components avoid a dead zone at the top of the page, you can set \[leavePageSpace:0\](#attr-canvasleavepagespace) to allow individual components to place themselves in a dead zone.

#### Configuring the viewport

When a SmartClient application loads, by default a viewport <meta> tag is added to the page which, on touch devices, fixes the page zoom to 100% and disables the pinch-zoom gesture. This is usually the expected behavior of a touch-enabled web application because it makes the application look and feel more like a native app. This default setting can be disabled by defining the `isc_useDefaultViewport` global variable with the value `false` before the framework is loaded:

 <script type="text/javascript">
 window.isc\_useDefaultViewport = false;
 </script>

For more information on the mobile device viewport, see:

*   [Using the viewport meta tag to control layout on mobile browsers \[MDN\]](https://developer.mozilla.org/en-US/docs/Web/HTML/Viewport_meta_tag)
*   [Responsive Web Design - The Viewport \[w3schools\]](https://www.w3schools.com/css/css_rwd_viewport.asp)

#### Orientation Change & Screen Size

When orientation changes, this is treated identically to resizing the browser on a desktop machine. If you've already created a UI that fills the browser and makes good use of available screen space for desktop browsers, the same behaviors will automatically apply when your application runs on mobile devices and the device is pivoted.

If you want to build specialized interfaces that respond to device orientation, the \[classMethod:Page.getOrientation\](#classmethod-pagegetorientation) API may be used to determine the current orientation of the application, and \[the page orientationChange event\](#type-pageevent) will fire whenever the user rotates the screen allowing applications or components to directly respond to the user pivoting their device.

#### Launching native helper apps (phone, facetime, maps..)

Generally, all that's required to launch native mobile apps is to create an ordinary HTML hyperlink (`<a>` tag) with a special prefix for the URL specified in the `href` attribute. For example, the following HTML link will place a call when the user finger-taps it:

   <a href="tel:8675309">Call Jenny</a>

You can provide HTML like this as \[attr:HTMLFlow.contents\](#attr-htmlflowcontents). Or use a field of \[type:"link"\](#type-fieldtype) to cause various \[DataBoundComponents\](#interface-databoundcomponent) to render a DataSourceField value as a clickable URL.

The URL prefixes that are valid for iOS are documented [at Apple.com](https://developer.apple.com/library/ios/featuredarticles/iPhoneURLScheme_Reference/Introduction/Introduction.html#//apple_ref/doc/uid/TP40007899-CH1-SW1). Typically, the same prefixes also work for Android, Windows Phone and others.

#### Configure the soft keyboard

\[attr:TextItem.browserInputType\](#attr-textitembrowserinputtype) can be set to various values such as "email" or "tel" (telephone number) to hint to mobile devices to use a different software keyboard with specialized keys appropriate for entering certain types of data values.

#### Note on mobile platform performance

When the first modern smartphones were released, it was necessary to use tiny, mobile-specific frameworks to get adequate performance for mobile web applications.

The situation is now completely different: through a combination of hardware improvements, optimizations in mobile browsers and vastly improved network speeds, typical mobile devices are easily able to run applications built with full-featured web platforms like SmartClient. For an application that supports both desktop and mobile interfaces, the worst case scenario for platform performance is often 
#### not
 a mobile phone, but an older desktop machine running Internet Explorer.

Unfortunately, there is a lot of out-of-date advice on the web about mobile web development that still advises using ultra-light, feature-poor frameworks for performance reasons. Carefully consider the source and recency of any such advice - the reality is that using such feature-poor frameworks means you will under-deliver with both your desktop _and_ mobile interfaces.

For more background on choosing the right technologies for mobile and desktop web applications, see the [Mobile Strategy Page](http://smartclient.com/product/mobileStrategy.jsp) at smartclient.com.

#### Offline Operation

SmartClient applications support "offline" operation (continuing to work without network access).

Permanent caching of resources such as .js, .css files and images are handled via the standard [HTML5 Manifest](https://www.google.com/search?q=html5+manifest) - just list all the static files your application needs in a manifest file and mobile browsers will cache those resources.

Dynamic data is handled via the \[class:Offline\](#class-offline) APIs as well as special DataSource support enabled by \[attr:DataSource.useOfflineStorage\](#attr-datasourceuseofflinestorage).

The end result is that you can bookmark a SmartClient application to a phone's home screen and use it offline with cached data, much like an installed native application.

## Packaging as a native application

Via "packaging" technologies such as PhoneGap/Cordova and Titanium, a SmartClient web application can be packaged as an installable native application that can be delivered via the "App Store" for the target mobile platform. Applications packaged in this way have access to phone-specific data and services such as contacts stored on the phone, or the ability to invoke the device's camera.

Both Titanium and PhoneGap provide access to the underlying native device APIs such as the accelerometer, geolocation, and UI. Both frameworks enable application development using only JavaScript, CSS and HTML. Additionally they provide development environments that work across a wide variety of devices.

PhoneGap has good support for native device APIs as noted [here](http://www.phonegap.com/about/feature). Titanium has similar support. There are differences between the two environments and how they expose their APIs, though both provide Xcode-compatible projects that can be compiled and run from the Xcode IDE. See \[Integration with Titanium\](#group-titaniumintegration) and \[Integration with PhoneGap\](#group-phonegapintegration) for more information.

---
## Attr: PickList.clickMaskMode

### Description
Determines the behavior of the click-mask thrown up when this pickList is visible.

The default value, "hard", matches the familiar behavior of combos and selects on Windows, Mac and other platforms - mouse-events such as rollovers are blocked and, when a click is received, the picker is hidden and the event is cancelled.

When `clickMaskMode` is "soft", mouse-events continue to fire, meaning that rollover styles, for example, continue to be updated. When a click is received in this mode, the picker is hidden and the click event is allowed to proceed to its target - this means that clicking an item with an open picker will re-open the picker.

**Flags**: IRW

---
## Attr: Window.printBodyStyle

### Description
Style for the Window body in printed output.

**Flags**: IR

---
## Attr: Calendar.baseStyle

### Description
The base name for the CSS class applied to the grid cells of the day and week views of the calendar. This style will have "Dark", "Over", "Selected", or "Disabled" appended to it according to the state of the cell.

See \[group:cellStyleSuffixes\](#group-cellstylesuffixes) for details on how stateful suffixes are combined with the base style to generate stateful cell styles.

### Groups

- appearance

**Flags**: IRW

---
## Attr: RadialGradient.cy

### Description
y coordinate of outer radial

**Flags**: IR

---
## Attr: LoadProjectSettings.drawFirstScreen

### Description
Determines whether the \[attr:LoadProjectSettings.currentScreenName\](#attr-loadprojectsettingscurrentscreenname) screen is drawn after all screens have been loaded. If not drawn, the screen will not be created.

This setting only affects the first project specified in the `projectNames` argument to \[classMethod:RPCManager.loadProject\](#classmethod-rpcmanagerloadproject).

### See Also

- [Project.createScreen](#method-projectcreatescreen)
- [RPCManager.createScreen](#classmethod-rpcmanagercreatescreen)

**Flags**: IRW

---
## Method: Canvas.dragResizeMove

### Description
Executed every time the mouse moves while drag-resizing. If this method does not return false, the \[attr:Canvas.dragTarget\](#attr-canvasdragtarget) (or outline if \[attr:Canvas.dragAppearance\](#attr-canvasdragappearance) is set to "outline") will automatically be moved as appropriate whenever the mouse moves.

### Returns

`[boolean](#type-boolean)` — false to suppress auto-resize of the \[attr:Canvas.dragTarget\](#attr-canvasdragtarget) or outline.

### Groups

- widgetEvents

### See Also

- [Canvas.getOffsetX](#method-canvasgetoffsetx)
- [Canvas.getOffsetY](#method-canvasgetoffsety)
- [EventHandler.getDragRect](#classmethod-eventhandlergetdragrect)

**Flags**: A

---
## Attr: Dialog.styleName

### Description
Style of the Dialog background

### Groups

- appearance

**Flags**: IRW

---
## Attr: RibbonButton.showTitle

### Description
showTitle is not applicable to this class - use \[attr:RibbonButton.showButtonTitle\](#attr-ribbonbuttonshowbuttontitle) instead.

**Flags**: IRW

---
## Attr: ListGrid.headerMenuButton

### Description
If \[attr:ListGrid.showHeaderMenuButton\](#attr-listgridshowheadermenubutton) is true, when the user rolls over the header buttons in this grid the headerMenuButton will be shown over the header button in question. When clicked this button will display the standard header context menu (see \[method:ListGrid.displayHeaderContextMenu\](#method-listgriddisplayheadercontextmenu)).

\[Several properties\](#group-headermenubutton) exist to customize the appearance of the headerMenuButton. Also see the \[type:AutoChild\](#type-autochild) documentation for information on how to make free-form modifications to autoChild widgets

### Groups

- headerMenuButton

**Flags**: RA

---
## ClassAttr: LoginDialog.LOGIN_ERROR_MESSAGE

### Description
Default error message displayed on failed login in the dialog shown by \[staticMethod:isc.showLoginDialog\](#staticmethod-iscshowlogindialog).

### Groups

- i18nMessages

**Flags**: IRW

---
## Attr: DrawSector.radius

### Description
Radius of the sector.

**Flags**: IR

---
## Method: MultiPickerItem.getOptionCriteria

### Description
Return the derived \[attr:MultiPickerItem.optionCriteria\](#attr-multipickeritemoptioncriteria) for this item

### Returns

`[Criteria](#type-criteria)` — criteria to apply to the pickList and expandedPickerGrid

---
## Attr: Tour.tourStepWizardAutoCompleteTitle

### Description
Title for the _Auto Complete_ field in the TourStep Wizard.

### Groups

- i18nMessages

**Flags**: IR

---
## ClassMethod: MultiWindow.resize

### Description
Resizes e existing window with the specified name,

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| name | [String](#type-string) | false | — | unique window name |
| width | [number](#type-number) | false | — | desired new width |
| height | [number](#type-number) | false | — | desired new height |
| callback | [RemoteWindowCallback](#type-remotewindowcallback) | true | — | callback run after \[class:RemoteWindow\](#class-remotewindow) moved |

---
## Method: DrawItem.scaleBy

### Description
Scale the shape by the x, y multipliers

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| x | [float](#type-float) | false | — | scale in the x direction |
| y | [float](#type-float) | false | — | scale in the y direction |

---
## ClassMethod: Page.isDarkSkin

### Description
Returns true if the current skin has a dark background and light text, false otherwise.

### Returns

`[Boolean](#type-boolean)` — true if the current skin has a dark background and light text

---
## Attr: LinearGradient.x2

### Description
X coordinate of the end point. This can be a number or a percentage of the width of the bounding box of the DrawItem to which it is applied.

**Flags**: IR

---
## Attr: GroupNode.groupMembers

### Description
Array of ListGridRecord that belong to this group, or, for multi-field grouping, array of groupNodes of subgroups under this groupNode.

### Groups

- grouping

### See Also

- [ListGrid.groupBy](#method-listgridgroupby)

**Flags**: R

---
## Method: Date.toNormalDate

### Description
Returns the date as a formatted string using the format set up via the `setNormalDisplayFormat()` method. Note that the default formatter for this method is `"toLocaleString"`.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| format | [DateDisplayFormat](#type-datedisplayformat) | false | — | Optional Format for the date returned |

### Returns

`[String](#type-string)` — formatted date string

### Groups

- dateFormatting

---
## Attr: FacetChart.logBase

### Description
When \[attr:FacetChart.useLogGradations\](#attr-facetchartuseloggradations), base value for logarithmic gradation lines. Gradation lines will be shown at every power of this value plus intervening values specified by \[attr:FacetChart.logGradations\](#attr-facetchartloggradations).

### Groups

- gradations

**Flags**: IR

---
## Method: DrawSector.getCenter

### Description
Returns the sector's \[centerPoint\](#attr-drawsectorcenterpoint).

### Returns

`[Point](#type-point)` — the current centerPoint

---
## Attr: ToggleSwitch.defaultValue

### Description
The default value of this ToggleSwitch.

### Groups

- appearance

**Flags**: IRW

---
## Attr: DataBoundComponent.dataFetchMode

### Description
How to fetch and manage records retrieve from the server. See \[type:FetchMode\](#type-fetchmode).

This setting only applies to the \[class:ResultSet\](#class-resultset) automatically created by calling \[fetchData()\](#method-listgridfetchdata). If a pre-existing ResultSet is passed to setData() instead, it's existing setting for \[attr:ResultSet.fetchMode\](#attr-resultsetfetchmode) applies.

### Groups

- databinding

**Flags**: IR

---
## Attr: Shuttle.deselectAllButtonHeight

### Description
Height for the \[attr:Shuttle.deselectAllButton\](#attr-shuttledeselectallbutton)

**Flags**: IR

---
## Method: EditContext.removeAll

### Description
Removes all \[EditNodes\](#object-editnode) from the EditContext, but does not destroy the \[liveObjects\](#attr-editnodeliveobject).

---
## Method: SimpleType.parseInput

### Description
Parser to convert some user-edited value to an underlying data value of this type. This parser is called when storing out values edited in a freeform editor such as a \[class:TextItem\](#class-textitem). Typically this will convert from the format produced by \[method:SimpleType.editFormatter\](#method-simpletypeeditformatter) back to a data value.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| value | [String](#type-string) | false | — | edited value provided by the user |
| field | [FormItem](#type-formitem) | true | — | Editor for this field |
| form | [DynamicForm](#type-dynamicform) | true | — | DynamicForm containing this editor |
| record | [Record](#type-record) | true | — | Current edit values for this record, as displayed in the edit component. |

### Returns

`[Any](#type-any)` — data value derived from display string passed in.

---
## ClassMethod: Canvas.showPrintPreview

### Description
Generate and show a \[class:PrintWindow\](#class-printwindow) containing a \[class:PrintCanvas\](#class-printcanvas) showing a printable view of the components passed in.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| components | [Array of Canvas](#type-array-of-canvas) | false | — | components to get the print HTML for. May also include raw HTML strings which will be folded into the generated print output |
| printProperties | [PrintProperties](#type-printproperties) | true | — | PrintProperties object for customizing the print HTML output |
| printWindowProperties | [PrintWindow Properties](#type-printwindow-properties) | true | — | Properties to apply to the generated print window. |
| callback | [Callback](#type-callback) | true | — | callback to fire when the print preview canvas has been populated with the printable HTML. This callback takes 2 parameters: `printPreview` - a pointer to the generated print canvas shown in the body of the print window. `printWindow` - a pointer to the generated print window and |
| separator | [String](#type-string) | true | — | Optional HTML separator to render between each component's printable HTML |

### Groups

- printing

---
## Attr: TestFunctionResult.record

### Description
Set to the record that was used when testing the generated function. This is the record selected by \[method:FormulaBuilder.getTestRecord\](#method-formulabuildergettestrecord).

### Groups

- formulaFields

**Flags**: IRW

---
## ClassMethod: Canvas.setNativeAutoHideScrollbars

### Description
In some platform/browser configurations, scrollable regions do not show visible scrollbars until the user attempts to interact with the region. The interaction to show the scrollbar varies by browser/OS but may include starting a trackpad scroll or simply rolling over the scrollable element.

This method changes the value of \[attr:Canvas.nativeAutoHideScrollbars\](#attr-canvasnativeautohidescrollbars).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| autoHideNativeScrollbars | [boolean](#type-boolean) | false | — | whether the native scrollbar should auto-hide by default. |

### See Also

- [Canvas.scrollbarConstructor](#attr-canvasscrollbarconstructor)
- [Canvas.showCustomScrollbars](#attr-canvasshowcustomscrollbars)

---
## Attr: FacetChart.autoSortBubblePoints

### Description
Whether to draw data points in order of descending \[point size\](#attr-facetchartpointsizemetric) so that small values are less likely to be completely occluded by larger values. Set this to `false` to draw the data points in the same order that they appear in the data.

### Groups

- appearance

**Flags**: IR

---
## Method: FormItem.show

### Description
Show this form item.

This will cause the form to redraw. If this item had an item.showIf expression, it will be destroyed.

---
## ClassAttr: RPCManager.keepParentsOnFilterMaxNodesExceededMessage

### Description
Default message displayed to the user when a databound \[load-on-demand\](#attr-resulttreeloaddataondemand) \[TreeGrid\](#class-treegrid) is filtered while \[keepParentsOnFilter\](#attr-resulttreekeepparentsonfilter) is in force, and the number of tree nodes matching the filter exceeds \[keepParentsOnFilterMaxNodes\](#attr-resulttreekeepparentsonfiltermaxnodes)

### Groups

- i18nMessages

**Flags**: IRW

---
## Method: Canvas.animateResize

### Description
Animate a resize of this canvas from its current size to the specified size

Note that \[attr:Canvas.animateResizeLayoutMode\](#attr-canvasanimateresizelayoutmode) allows you to control whether child layout is rerun during every step of the animation, or just at the end, since the former may incur significant overhead depending on the widget hierarchy.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| width | [Integer](#type-integer) | false | — | new width (or null for unchanged) |
| height | [Integer](#type-integer) | false | — | new height (or null for unchanged) |
| callback | [AnimationCallback](#type-animationcallback) | true | — | When the resize completes this callback will be fired. Single 'earlyFinish' parameter will be passed if the animation was cut short, for example by a call to the non-animated APIs \[method:Canvas.resizeTo\](#method-canvasresizeto) or \[method:Canvas.resizeBy\](#method-canvasresizeby). |
| duration | [Integer](#type-integer) | true | — | Duration in ms of the animated resize |
| acceleration | [AnimationAcceleration](#type-animationacceleration) | true | — | Optional acceleration effect to apply to the resize |

### Groups

- animation

---
## Method: CancellationController.createSubController

### Description
Creates a new \[class:CancellationController\](#class-cancellationcontroller) which is canceled whenever this `CancellationController` is canceled.

Note that the sub-`CancellationController` may be independently canceled before this parent `CancellationController` is canceled.

### Returns

`[CancellationController](#type-cancellationcontroller)` — a new \[class:CancellationController\](#class-cancellationcontroller) that is canceled whenever this `CancellationController` is canceled.

---
## Method: ListGrid.showFields

### Description
Force an array of fields to be shown. This method does not add new fields to the grid, it simply changes field visibility. If a field.showIf expression exists, it will be destroyed.

Note: for showing multiple fields it is more efficient to call this method than to call \[method:ListGrid.showField\](#method-listgridshowfield) repeatedly.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| field | [Array of String](#type-array-of-string)|[Array of ListGridField](#type-array-of-listgridfield) | false | — | Fields to show. |
| suppressRelayout | [boolean](#type-boolean) | true | — | If passed, don't resize non-explicitly sized columns to fill the available space. |

---
## Attr: Menu.baseStyle

### Description
CSS style for a normal cell

**Flags**: IRW

---
## Class: HStack

### Description
A subclass of Layout that simply stacks members on the horizontal axis without trying to manage their width. On the vertical axis, any members that do not have explicit heights will be sized to match the height of the stack.

### See Also

- [Layout.hPolicy](#attr-layouthpolicy)

---
## Attr: Window.isModal

### Description
If true, when shown this Window will intercept and block events to all other existing components on the page.

Use \[attr:Window.showModalMask\](#attr-windowshowmodalmask) to darken all other elements on the screen when a modal dialog is showing.

Chained modal windows - that is, modal windows that launch other modal windows - are allowed. You can accomplish this by simply creating a second modal Window while a modal Window is showing.

Note only top-level Windows (Windows without parents) can be modal.

### Groups

- modal

**Flags**: IRW

---
## Attr: ToolbarItem.colSpan

### Description
these items span all columns

### Groups

- appearance

**Flags**: IRW

---
## Group: gradations

### Description
—

---
## Attr: MockDSExportSettings.includeCustomSimpleTypes

### Description
Whether to include custom-defined \[SimpleTypes\](#class-simpletype).

**Flags**: IR

---
## Group: lifecycle

### Description
—

---
## Method: ImgButton.setAutoFit

### Description
Setter method for the \[attr:StatefulCanvas.autoFit\](#attr-statefulcanvasautofit) property. Pass in true or false to turn autoFit on or off. When autoFit is set to `false`, canvas will be resized to it's previously specified size.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| autoFit | [boolean](#type-boolean) | false | — | New autoFit setting. |

---
## Attr: Facet.sortFoldersBeforeLeaves

### Description
If \[attr:Facet.separateFolders\](#attr-facetseparatefolders) is true, should folders be displayed above or below leaves? When set to `true` folders will appear above leaves unless the data order has been reversed by setting \[attr:Facet.showParentsLast\](#attr-facetshowparentslast) to `true`.

**Flags**: IR

---
## Attr: AdvancedHiliteEditor.invalidHilitePrompt

### Description
The message to show when the user clicks "Save" without entering any criteria.

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: StatefulCanvas.iconHeight

### Description
Height in pixels of the icon image.

If unset, defaults to \[iconSize\](#attr-statefulcanvasiconsize).

### Groups

- buttonIcon

**Flags**: IR

---
## Attr: ListGrid.tableRowStyle

### Description
The style to apply to <TR> tags in this grid's table. Useful for applying spacing or a custom border between records in the grid.

This is an advanced capability and care should be taken not to use CSS that applies sizes or other settings that could cause sizing/rendering issues when used in conjunction with certain other features, such as \[attr:ListGrid.virtualScrolling\](#attr-listgridvirtualscrolling). For example, the style should apply _box-sizing: border-box;_ to ensure that settings like border and padding don't change the size of row elements. In some cases, the style will also need to apply _display: inline-block;_ for CSS changes to take effect - this is because the default display setting for <TR> elements, _table-row_, has limited styling support.

**Flags**: IRWA

---
## ClassMethod: Log.getDefaultLogPriority

### Description
A common usage of \[classMethod:Class.getDefaultLogPriority\](#classmethod-classgetdefaultlogpriority) is to call the method directly on the Log class.

### Returns

`[LogPriority](#type-logpriority)` — default priority for logging messages on this object.

---
## Attr: FormItem.editProxyConstructor

### Description
Default class used to construct the \[class:EditProxy\](#class-editproxy) for this component when the component is \[first placed into edit mode\](#method-canvasseteditmode).

**Flags**: IR

---
## Method: CSSEditor.editCancelled

### Description
Notification fired when the cancelButton is clicked.

---
## Attr: MetricSettings.filled

### Description
Whether shapes are filled, for example, whether a multi-series line chart appears as a stack of filled regions as opposed to just multiple lines.

If unset, fills will be automatically used when there are multiple facets and stacking is active (so Line and Radar charts will show stacked regions).

You can explicitly set filled:false to create multi-facet Line or Radar charts where translucent regions overlap, or filled:true to fill in a single-facet Line or Radar chart.

### Groups

- chartType

**Flags**: IRW

---
## Attr: TimeItem.millisecondIncrement

### Description
When \[useTextField\](#attr-timeitemusetextfield) is false and \[millisecondValues\](#attr-timeitemmillisecondvalues) is unset, this attribute specifies the increment to use when generating entries for the millisecond picker. For example, if this attribute is set to 5, the millisecond picker will contain only every fifth value between the \[millisecondMinValue\](#attr-timeitemmillisecondminvalue) and \[millisecondMaxValue\](#attr-timeitemmillisecondmaxvalue).

**Flags**: IRW

---
## Attr: Window.restoreButton

### Description
ImgButton that restores the Window via \[method:Window.restore\](#method-windowrestore).

**Flags**: R

---
## Class: Timeline

### Description
Timeline is a trivial subclass of \[class:Calendar\](#class-calendar) that configures the Calendar with settings typical for a standalone timeline view: hides the \[day\](#attr-calendardayview), \[week\](#attr-calendarweekview) and \[month\](#attr-calendarmonthview) tabs and the \[controls bar\](#attr-calendarcontrolsbar) by default.

Note that the \[Calendar module\](#group-loadingoptionalmodules) must be loaded to make use of the Timeline class.

---
## Method: List.getItems

### Description
Return the items at a list of specified positions.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| itemList | [List of Number](#type-list-of-number) | false | — | array of positions |

### Returns

`[Array](#type-array)` — subset of the array, in the same order as itemList

### Groups

- access

---
## Attr: ListGridField.linkTextProperty

### Description
Name of the property in a ListGridRecord that holds the HTML to display in cells of this field if the fieldType is set to "link".

### Groups

- display_values

### See Also

- [ListGridFieldType](#type-listgridfieldtype)
- [FieldType](#type-fieldtype)
- [ListGridRecord.linkText](#attr-listgridrecordlinktext)
- [ListGridField.linkText](#attr-listgridfieldlinktext)
- [ListGrid.linkTextProperty](#attr-listgridlinktextproperty)

**Flags**: IRW

---
## Attr: ListGridRecord.embeddedComponent

### Description
A component that should be rendered on top of this record, similar to a \[record component\](#attr-listgridshowrecordcomponents) but statically defined on the record.

The embedded component will default to covering all fields of the record, but specific fields can be specified via \[attr:ListGridRecord.embeddedComponentFields\](#attr-listgridrecordembeddedcomponentfields).

By default, the embeddedComponent will fill the entire vertical and horizontal space of the record (or of the specified fields). \[attr:ListGridRecord.embeddedComponentPosition\](#attr-listgridrecordembeddedcomponentposition) can be set to control exact sizing behavior.

When creating a component to use as an embedded component the component will most likely end up drawing before the record it is due to be embedded within, therefore it is recommended to set \[autoDraw\](#attr-canvasautodraw) to false on the embedded component.

When a record with an `embeddedComponent` is eliminated from view by filtering or because it is not currently rendered due to \[incremental rendering\](#attr-listgridshowallrecords), the ListGrid may \[method:Canvas.hide\](#method-canvashide) or \[method:Canvas.clear\](#method-canvasclear) it.

If the current dataset is completely replaced (by a call to \[method:ListGrid.setData\](#method-listgridsetdata) or \[method:ListGrid.setDataSource\](#method-listgridsetdatasource), for example), any embedded component is \[deparented\](#method-canvasdeparent) (which implies being \[clear()ed\](#method-canvasclear)).

When a ListGrid is \[destroyed\](#method-canvasdestroy), it will destroy() all embedded components regardless of whether they are currently visible. Use a call to \[method:ListGrid.setData\](#method-listgridsetdata) immediately before destroying the ListGrid to avoid this effect when unwanted.

For more advanced control over the lifecycle of components displayed over records, including deferred creation and pooling, use the \[record components\](#attr-listgridshowrecordcomponents) subsystem.

### Groups

- appearance

**Flags**: IR

---
## Method: Array.equals

### Description
Return whether this list is equal to another list.

Two lists are equal only if they have the same length and all contained items are in the same order and are also equal.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| list | [List](#type-list) | false | — | list to check for equality |

### Returns

`[boolean](#type-boolean)` — whether the specified list is equal to this list

### Groups

- access

---
## Method: DataBoundComponent.getSort

### Description
Return the \[object:SortSpecifier\](#object-sortspecifier)s representing the current sort configuration of this component.

### Returns

`[Array of SortSpecifier](#type-array-of-sortspecifier)` — sortSpecifiersA copy of the current sort specification for this component

---
## Method: ValuesManager.editRecord

### Description
Edit an existing record. Updates this editors values to match the values of the record passed in, via \[method:ValuesManager.setValues\](#method-valuesmanagersetvalues).

This method will also call \[method:DynamicForm.setSaveOperationType\](#method-dynamicformsetsaveoperationtype) to ensure subsequent calls to `saveData()` will use an `update` rather than an `add` operation.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| record | [Record](#type-record) | false | — | the record to be edited as a map of field names to their corresponding values |

### Groups

- dataBoundComponentMethods

### See Also

- [DynamicForm.saveData](#method-dynamicformsavedata)

---
## Attr: Canvas.maxHeight

### Description
Maximum height available to this Canvas. See \[attr:Canvas.maxWidth\](#attr-canvasmaxwidth) for details of behavior.

### Groups

- sizing

### See Also

- [Canvas.dragMaxHeight](#attr-canvasdragmaxheight)

**Flags**: IRWA

---
## Method: Button.setIconOrientation

### Description
Changes the orientation of the icon relative to the text of the button.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| orientation | [String](#type-string) | false | — | The new orientation of the icon relative to the text of the button. |

### Groups

- buttonIcon

---
## Method: Array.setSort

### Description
Sort this Array by a list of \[object:SortSpecifier\](#object-sortspecifier)s.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| sortSpecifiers | [Array of SortSpecifier](#type-array-of-sortspecifier) | false | — | the list of \[object:SortSpecifier\](#object-sortspecifier)s to sort by |

### Returns

`[Array](#type-array)` — the array itself

---
## Attr: FormItem.exportFormat

### Description
\[type:FormatString\](#type-formatstring) used during exports for numeric or date formatting. See \[attr:DataSourceField.exportFormat\](#attr-datasourcefieldexportformat).

### Groups

- exportFormatting

**Flags**: IR

---
## Method: SimpleTile.getInnerHTML

### Description
The default implementation will call \[method:TileGrid.getTileHTML\](#method-tilegridgettilehtml).

### Returns

`[HTMLString](#type-htmlstring)` — HTML contents for the tile, as a String

---
## Attr: ListGrid.editPendingMarkerStyle

### Description
The name of a CSS class used to overlay regular cell styles with additional styling when a cell has unsaved edits - these styles are in addition to the styling applied by \[attr:ListGrid.editPendingCSSText\](#attr-listgrideditpendingcsstext) or \[attr:ListGrid.editPendingBaseStyle\](#attr-listgrideditpendingbasestyle).

You can use a custom class that overlays styling of your choosing, or use the default _pendingMarker_ class which is present in modern skins and provides a small corner-marker in the top-left of unsaved cells.

Once set, this styleName is automatically appended to the style-list for cells with unsaved edits.

### Groups

- appearance

### See Also

- [ListGrid.baseStyle](#attr-listgridbasestyle)

**Flags**: IRWA

---
## Attr: ListGrid.removeFieldProperties

### Description
Configuration properties for the "remove field" displayed when \[attr:ListGrid.canRemoveRecords\](#attr-listgridcanremoverecords) is enabled. These configuration settings will be overlaid on top of the \[attr:ListGrid.removeFieldDefaults\](#attr-listgridremovefielddefaults).

**Flags**: IR

---
## Attr: SavedSearches.screenIdField

### Description
Type: "string". Required because component IDs are not unique if components are loaded as \[screens\](#classmethod-rpcmanagerloadscreen), especially \[Reify Screens\](#group-reifyfordevelopers).

**Flags**: RW

---
## Attr: CubeGrid.hideEmptyFacetValues

### Description
This causes the headers for any combination of facetValues for which there are no cellRecords to be suppressed.

To use this feature, either:

*   all must be provided via \[setData()\](#method-listgridsetdata) before the CubeGrid is first drawn, OR
*   all data must be returned by the first DataSource fetch, OR
*   \[attr:CubeGrid.hideEmptyAxis\](#attr-cubegridhideemptyaxis) must be set to either "row" or "column" so that empty values are only automatically hidden for one axis

This last point is required because there is no way to determine whether a row is empty unless data for all columns of the row has been loaded (and vice-versa). For this reason if you set hideEmptyFacetValues but do not set hideEmptyAxis, the default behavior of \[loading only visible data\](#class-datasource) is automatically disabled and only \[attr:CubeGrid.fixedFacetValues\](#attr-cubegridfixedfacetvalues) will be sent as criteria.

### Groups

- facetLayout

**Flags**: IR

---
## Attr: Shuttle.deselectAllButton

### Description
ImgButton for deselecting the full set of selected data in the shuttle.

**Flags**: IR

---
## Attr: ResultTree.sendNullParentInLinkDataCriteria

### Description
For \[multi-link tree\](#method-treeismultilinktree)s only, should we send up the \[parentId\](#attr-treeparentidfield) in fetch criteria if the criteria value is null? If false, we remove the `parentId` from the criteria when \[fetching link data\](#attr-resulttreelinkdatasource), 
#### if
 the criteria value is null (as it will be by default when fetching the direct child nodes of the tree's root).

Ignored for non-multiLink trees.

### Groups

- multiLinkTree

**Flags**: IR

---
## Attr: DataSourceField.autoGenerated

### Description
Indicates that values for this field are automatically generated by the database or ORM provider. Setting this flag makes the field behave somewhat like a \[sequence field\](#attr-datasourcefieldsequencename), in that server-side logic does not expect client code to provide values for the field on "add" operations. However, it is not entirely the same as a sequence:

*   Sequences must be integers, whereas autoGenerated fields can be of any type
*   SmartClient Server's DataSource implementations are capable of discovering the value that was generated by the database for sequence fields, which may not be possible with an autoGenerated field. See the docs for \[customInsertExpression\](#attr-datasourcefieldcustominsertexpression) for a discussion of this

Unrelated to the `autoGenerated` flag, you have a general ability for field values to be generated by application code (as opposed to being generated by the database or ORM provider). For example, you can use \[DMI methods\](#group-dmioverview), \[server scripts\](#group-serverscript), or \[custom SQL\](#group-customquerying). (Note, if you want to have application code generate values for primaryKey fields, you may need to use an \[operationBinding\](#class-operationbinding) that specifies \[providesMissingKeys\](#attr-operationbindingprovidesmissingkeys)).

### Groups

- dataType

### See Also

- [DataSourceField.sequenceName](#attr-datasourcefieldsequencename)
- [FieldType](#type-fieldtype)
- [SequenceMode](#type-sequencemode)

**Flags**: IR

---
## Attr: ResultTree.autoOpen

### Description
Which nodes should be opened automatically - applied whenever \[setRoot()\](#method-treesetroot) is called, including during initialization and as part of a re-fetch caused, for example, by \[duplicate()\](#method-treeduplicate) or \[invalidateCache()\](#method-resulttreeinvalidatecache).

Options are:

*   "none" - no nodes are opened automatically
*   "root" - opens the \[top-level node\](#attr-resulttreerootnode) - in databound trees, this node is always hidden
*   "all" - when \[loading data on demand\](#attr-resulttreeloaddataondemand), opens the \[top-level node\](#attr-resulttreerootnode) and all of it's direct descendants - otherwise, opens all loaded nodes

**Flags**: IRW

---
## Method: Menu.setItemEnabled

### Description
Enables or disables the menu item according to the value of newState, and redraws the menu if necessary. Returns true if there's a change in the enabled state.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| item | [MenuItem](#type-menuitem)|[int](#type-int) | false | — | MenuItem or visible index of the MenuItem |
| newState | [boolean](#type-boolean) | true | — | true to enable the menu item, false to disable it. If not passed, true is assumed |

### Returns

`[boolean](#type-boolean)` — true if the enabled state was changed

---
## Attr: Button.selected

### Description
Whether this component is selected. For some components, selection affects appearance.

### Groups

- state

**Flags**: IRW

---
## Attr: SCStatefulImgConfig.Selected

### Description
Image to display when the component is \[selected\](#attr-statefulcanvasselected).

May be specified as

*   A \[type:SCImgURL\](#type-scimgurl) indicating the media to load
*   A reference to another entry in this SCStatefulImgConfig via the format `"#state:_otherStateName_"`
*   A modifier to apply to the \[attr:SCStatefulImgConfig.\_base\](#attr-scstatefulimgconfig-base) media via the format `"#modifier:_modifierString_"`

See \[SCStatefulImgConfig overview\](#object-scstatefulimgconfig) for further information.

**Flags**: IRW

---
## Class: SetTitleTask

### Description
Sets the title of a tab, section, window, label, button, form control or facet chart.

For a label, button, window, or chart the \[componentId\](#attr-componenttaskcomponentid) specifies everything necessary to identify the target.

For a tab, section or form control more information is needed. The \[componentId\](#attr-componenttaskcomponentid) identifies the container (i.e. TabSet, SectionStack or DynamicForm) and the individual component is specified as:

*   Tab - \[targetTabName\](#attr-settitletasktargettabname) references the \[attr:Tab.name\](#attr-tabname).
*   Section - \[targetSectionName\](#attr-settitletasktargetsectionname) for \[attr:SectionStackSection.name\](#attr-sectionstacksectionname) or \[targetSectionTitle\](#attr-settitletasktargetsectiontitle) for \[attr:SectionStackSection.title\](#attr-sectionstacksectiontitle).
*   FormItem - \[targetFieldName\](#attr-settitletasktargetfieldname) for \[attr:FormItem.name\](#attr-formitemname).

### See Also

- [TabSet.setTabTitle](#method-tabsetsettabtitle)
- [SectionStack.setSectionTitle](#method-sectionstacksetsectiontitle)
- [Window.setTitle](#method-windowsettitle)
- [FacetChart.title](#attr-facetcharttitle)
- [Label.setContents](#method-labelsetcontents)
- [Button.setTitle](#method-buttonsettitle)
- [FormItem.title](#attr-formitemtitle)

---
## Attr: Canvas.dropTarget

### Description
Delegates a different widget that should actually be dropped on if the cursor is over this widget when the drop completes. If you're building your own "drop indicator" widget, it may need this property set to the main canvas (receiving the drop) to avoid itself being considered a drop target (causing the indicator to flicker).

### Groups

- dragdrop

### See Also

- [EventHandler.getDragTarget](#classmethod-eventhandlergetdragtarget)
- [Canvas.dragTarget](#attr-canvasdragtarget)

**Flags**: IRWA

---
## Attr: TimeItem.hourMinValue

### Description
When \[useTextField\](#attr-timeitemusetextfield) is false and \[hourValues\](#attr-timeitemhourvalues) is unset, this attribute specifies the minimum value present in the hour picker.

Used for specifying a limited set of valid Hour values, or when using the TimeItem to record duration, rather than time per-se. The default is zero in all cases.

See also \[hourMaxValue\](#attr-timeitemhourmaxvalue) and \[hourIncrement\](#attr-timeitemhourincrement).

**Flags**: IRW

---
## Method: NavigationBar.setShowRightButton

### Description
Show or hide the \[rightButton\](#attr-navigationbarrightbutton). The `rightButton` must be a \[control\](#attr-navigationbarcontrols) of this `NavigationBar` or else it will still be hidden.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| show | [Boolean](#type-boolean) | false | — | if `false`, then the `rightButton` will be hidden. If unset or `true` then the `rightButton` will be shown as long as it is a member of the `controls` array. |

---
## Object: NavItem

### Description
Properties for a navigation item in a \[class:NavPanel\](#class-navpanel).

---
## Method: FormItemIcon.click

### Description
Click handler for this icon.

Return false to cancel this event. If this event is not cancelled by the icon-level click handler, it may also be handled at the FormItem level via \[method:FormItem.pickerIconClick\](#method-formitempickericonclick) \[for the picker icon only\], and then \[method:FormItem.iconClick\](#method-formitemiconclick)

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| form | [DynamicForm](#type-dynamicform) | false | — | The Dynamic Form to which this icon's item belongs. |
| item | [FormItem](#type-formitem) | false | — | The Form Item containing this icon |
| icon | [FormItemIcon](#type-formitemicon) | false | — | A pointer to the form item icon clicked |

### Returns

`[boolean](#type-boolean)` — Return false to cancel the event.

### Groups

- formIcons

---
## Attr: Label.valign

### Description
Vertical alignment of label text. See VerticalAlignment type for details.

### Groups

- positioning

**Flags**: IRW

---
## Attr: PickListMenu.canSaveSearches

### Description
Option to save searches is disabled for PickListMenus

**Flags**: IRA

---
## Attr: CoTTransition.label

### Description
Optional UI label override. If omitted, the target's \[description\](#attr-cottaskdescription) is used if present, otherwise \[CoTTask.title\](#cottasktitle).

**Flags**: IR

---
## Attr: FormItemIcon.neverDisable

### Description
If `icon.neverDisable` is true, when this form item is disabled, the icon will remain enabled. Note that disabling the entire form will disable all items, together with their icons including those marked as neverDisable - this property only has an effect if the form is enabled and a specific item is disabled within it.

If this property is true, the icons will also remain enabled if a form item is marked as \[canEdit:false\](#attr-formitemcanedit). For finer grained control over whether icons are enabled for read-only icons see \[attr:FormItem.disableIconsOnReadOnly\](#attr-formitemdisableiconsonreadonly) and \[attr:FormItemIcon.disableOnReadOnly\](#attr-formitemicondisableonreadonly)

### Groups

- formIcons

**Flags**: IRWA

---
## Attr: ListGrid.headerMenuButtonSnapOffsetLeft

### Description
Offset of the right edge of a \[attr:ListGrid.headerMenuButton\](#attr-listgridheadermenubutton) from the right edge of it's parent button.

**Flags**: IRW

---
## Attr: SelectItem.showFocused

### Description
When this item receives focus, should it be re-styled to indicate it has focus?

See \[group:formItemStyling\](#group-formitemstyling) for more details on formItem styling.

### Groups

- formItemStyling

### See Also

- [FormItem.cellStyle](#attr-formitemcellstyle)

**Flags**: IRWA

---
## Method: DataSource.createAlias

### Description
Assigns an alias to this DataSource

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| alias | [String](#type-string) | false | — | The alias assigned to this DataSource. |

---
## Method: ImgSectionHeader.titleHover

### Description
Optional stringMethod to fire when the user hovers over this section header and the title is clipped. If \[attr:ImgSectionHeader.showClippedTitleOnHover\](#attr-imgsectionheadershowclippedtitleonhover) is true, the default behavior is to show a hover canvas containing the HTML returned by \[method:ImgSectionHeader.titleHoverHTML\](#method-imgsectionheadertitlehoverhtml). Return false to suppress this default behavior.

### Returns

`[boolean](#type-boolean)` — false to suppress the standard hover

### Groups

- hovers

### See Also

- [ImgSectionHeader.clipTitle](#attr-imgsectionheadercliptitle)
- [ImgSectionHeader.titleClipped](#method-imgsectionheadertitleclipped)

---
## Method: RelativeDateItem.getFiscalCalendar

### Description
Returns the \[object:FiscalCalendar\](#object-fiscalcalendar) object that will be used by this item's DateChooser.

### Returns

`[FiscalCalendar](#type-fiscalcalendar)` — the fiscal calendar for this chooser, if set, or the global one otherwise

---
## Attr: Shuttle.sourceGridTitle

### Description
Title for the source grid, shown as a \[attr:Canvas.groupTitle\](#attr-canvasgrouptitle)

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: TileLayout.tileSize

### Description
Size of each tile in pixels. Depending on the \[type:TileLayoutPolicy\](#type-tilelayoutpolicy), `tileSize` may be taken as a maximum, minimum or exact size of tiles, or may be irrelevant.

Width and height may be separately set via \[attr:TileLayout.tileHeight\](#attr-tilelayouttileheight) and \[attr:TileLayout.tileWidth\](#attr-tilelayouttilewidth).

### Groups

- sizing

**Flags**: IR

---
## ClassMethod: Messaging.subscribe

### Description
Subscribes the client to the messaging channel identified by channel.

When the server or another connected browser sends a message on this channel, the callback will be invoked with a single 'data' parameter containing the data that was just sent to the channel.

Calling subscribe() again for a channel you are already subscribed to will result in the new callback replacing the old, and will cause the server connection to be re-established.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| channel | [String](#type-string) | false | — | — |
| callback | [MessagingCallback](#type-messagingcallback) | false | — | callback fired whenever data is sent to this channel |
| subscribeCallback | [Callback](#type-callback) | false | — | callback fired when the subscription is established |
| selector | [String](#type-string) | true | — | JMS selector used with Queues to filter the messages that arrive to the channel (optional). |

### Groups

- messaging

---
## Method: Canvas.getContents

### Description
Returns the contents of a Canvas. The contents are an HTML string.

### Returns

`[HTMLString](#type-htmlstring)` — contents of this Canvas

---
## Method: Canvas.shouldDragScroll

### Description
If this widget is showing scrollbars, and a user drags close to the edge of the viewport, should we scroll the viewport in the appropriate direction? Returns this.canDragScroll if there are scrollbars, else false.

### Groups

- events
- dragdrop

**Flags**: A

---
## Method: Canvas.moveTo

### Description
Moves the widget so that its top-left corner is at the specified coordinates.

This method will also accept a single parameter as an object array with left and top given as properties.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| left | [number](#type-number)|[Object](#type-object) | true | — | x-coordinate to move to in LOCAL coordinates or Object with left and top properties. |
| top | [number](#type-number) | true | — | y-coordinate to move to in LOCAL coordinates |

### Returns

`[boolean](#type-boolean)` — whether the component actually moved

### Groups

- positioning

---
## Attr: TabBar.moreTab

### Description
Tab to show as the "more" tab when \[attr:TabBar.showMoreTab\](#attr-tabbarshowmoretab) is enabled and the number of tabs to show exceeds \[attr:TabBar.moreTabCount\](#attr-tabbarmoretabcount).

**Flags**: IR

---
## Attr: DataSource.suppressAutoMappings

### Description
Applies to RestConnector dataSources (\[serverType\](#attr-datasourceservertype) "rest") only, and is overridable per operationBinding (see \[attr:OperationBinding.requestTemplate\](#attr-operationbindingrequesttemplate)).

By default, if you have a \[requestFormat\](#attr-datasourcerequestformat) of "params", `RestConnector` will add your values or criteria as standard HTTP parameters to the the URL it generates for hitting the target REST server - this is described in more detail in the \[type:RESTRequestFormat\](#type-restrequestformat) documentation.

With a `requestFormat` of "json", `RestConnector` will generate a block of JSON from your criteria or values, again as described in the `RESTRequestFormat` docs

You can switch off both of these behaviors by setting this property true

### Groups

- serverRestConnector

**Flags**: IR

---
## Class: SimpleType

### Description
An atomic type such as a string or number, that is generally stored, displayed and manipulated as a single value.

SimpleTypes can be \[created\](#classmethod-simpletypecreate) at any time, and subsequently referred to as a \[field type\](#attr-fieldtype) in \[DataSources\](#class-datasource) and \[DataBoundComponents\](#interface-databoundcomponent). This allows you to define \[validation\](#attr-simpletypevalidators), \[formatting\](#method-simpletypenormaldisplayformatter) and \[editing\](#attr-simpletypeeditortype) behaviors for a type to be reused across all \[DataBoundComponents\](#interface-databoundcomponent).

The SimpleType class also allows data to be stored in some opaque format but treated as simple atomic values as far as SmartClient components are concerned by implementing \[method:SimpleType.getAtomicValue\](#method-simpletypegetatomicvalue) and \[method:SimpleType.updateAtomicValue\](#method-simpletypeupdateatomicvalue) methods. For example, if some record has a field value set to a javascript object with the following properties:

 { stringValue:"A String", length: 9 }
 

this value could be treated as a simple string by defining a SimpleType with \[attr:SimpleType.inheritsFrom\](#attr-simpletypeinheritsfrom) set to `"text"` and a custom `getAtomicValue()` method that simply extracted the _"stringValue"_ attribute from the data object. DataBoundComponents would then display the string value, and use it for sorting and other standard databinding features.

Note that the term "simpleType" is used in the same sense as in [XML Schema](http://www.w3.org/TR/xmlschema-0/), and \[classMethod:XMLTools.loadXMLSchema\](#classmethod-xmltoolsloadxmlschema) will create new SimpleType definitions.

When using the SmartClient Server, SimpleTypes can be defined server-side, and should be defined server-side if validators are going to be declared so that the server will enforce validation. To define server-side SimpleTypes using Component XML you should create file {typeName}.type.xml in the following format:

   <SimpleType name="{typeName}" inheritsFrom="{otherSimpleType}" 
                  editorType="{FormItemClassName}">
     <validators>
       <!-- validator definition just like DataSourceField -->
     </validators>
   </SimpleType>
 

.. and place this file alongside your DataSource files (.ds.xml) files - in any of folders listed in `project.datasources` property in \[server.properties\](#group-server-properties).

SimpleTypes can be loaded via DataSourceLoader or \[loadDS JSP tags\](#group-loaddstag) and should be loaded 
#### before
 the definitions of any DataSources that use them (so generally put all SimpleType definitions first).

Define validators in the server-side type definition, for example:

   <SimpleType name="countryCodeType" inheritsFrom="text">
     <validators>
       <validator type="lengthRange" min="2" max="2"
         errorMessage="Length of country code should be equal to 2." />
       <validator type="regexp" expression="\[A-Z\]\[A-Z\]"
         errorMessage="CountryCode should have only uppercase letters." />
     </validators>
   </SimpleType>
 

For client-side formatters, add these to the type definition after loading it from the server, for example:

     isc.SimpleType.getType("independenceDateType").addProperties({
         normalDisplayFormatter : function (value) {
             if (value == null) return "";
             return "<i>" + (value.getYear() + 1900) + "</i>";
         }
     });
   

Note that formatters must be added to the SimpleType definition 
#### before
 any DataBoundComponent binds to a DataSource that uses the SimpleType.

An example is ${isc.DocUtils.linkForExampleId('formsCustomSimpleType', 'here')}.

---
## Method: DataBoundComponent.findAll

### Description
This API is equivalent to \[method:List.findAll\](#method-listfindall) but searches for a matching record among already-loaded data only. Use \[fetchData\](#method-listgridfetchdata) to load data from the server.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| advancedCriteria | [AdvancedCriteria](#type-advancedcriteria) | false | — | AdvancedCriteria to use with |

### Returns

`[Array](#type-array)` — all matching Objects or null if none found

---
## Attr: ListGrid.originBaseStyle

### Description
Name of a CSS Style to use as the \[attr:ListGrid.baseStyle\](#attr-listgridbasestyle) for a cell that is currently a selection origin for shifted incremental cell selection. Only has an effect if \[attr:ListGrid.canSelectCells\](#attr-listgridcanselectcells) is true.

**Flags**: IRW

---
## Type: DateInputFormat

### Description
3 character string containing the `"M"`, `"D"` and `"Y"` characters to indicate the format of strings being parsed into Date instances via `DateUtil.parseInput()`.

As an example - an input format of "MDY" would parse "01/02/1999" to Jan 2nd 1999

Note: In addition to these standard formats, a custom date string parser function may be passed directly to \[classMethod:DateUtil.setInputFormat\](#classmethod-dateutilsetinputformat) or passed into \[classMethod:DateUtil.parseInput\](#classmethod-dateutilparseinput) as the inputFormat parameter.

---
## Object: RelativeDate

### Description
An object representing a relative date, useful for representing date ranges etc in criteria. RelativeDate objects may be created directly by SmartClient components such as the \[class:RelativeDateItem\](#class-relativedateitem).

RelativeDate objects will have `"_constructor"` set to `"RelativeDate"` and must have a specified \[attr:RelativeDate.value\](#attr-relativedatevalue). Any other attributes are optional.

---
## Attr: Canvas.resizeBarTarget

### Description
When this Canvas is included as a member in a Layout, and \[attr:Canvas.showResizeBar\](#attr-canvasshowresizebar) is set to `true` so that a resizeBar is created, `resizeBarTarget:"next"` can be set to indicate that the resizeBar should resize the next member of the layout rather than this one. For resizeBars that support hiding their target member when clicked on, `resizeBarTarget:"next"` also means that the next member will be the one hidden.

This is typically used to create a 3-way split pane, where left and right-hand sections can be resized or hidden to allow a center section to expand.

#### NOTE:
 as with any Layout, to ensure all available space is used, one or more members must maintain a flexible size (eg 75%, or \*). In a two pane Layout with a normal resize bar, to fill all space after a user resizes, the member on the 
#### right
 should have flexible size. With resizeBarTarget:"next", the member on the 
#### left
 should have flexible size.

### Groups

- layoutMember

### See Also

- [Canvas.showResizeBar](#attr-canvasshowresizebar)

**Flags**: IR

---
## Attr: SavedSearchForm.savedSearchItem

### Description
Automatically generated \[class:SavedSearchItem\](#class-savedsearchitem) for this form.

This may be customized using the \[autoChild subsystem\](#group-autochildusage).

**Flags**: IR

---
## Method: DoubleItem.getValueAsDouble

### Description
Return the value tracked by this form item as a Double. If the value cannot be parsed to a valid double, null will be returned.

### Returns

`[Double](#type-double)` — the value of this element

### See Also

- [FormItem.getValue](#method-formitemgetvalue)

---
## Attr: MultiFileItem.editButton

### Description
Button for launching a picker to add new files for upload. Supports the properties of a \[object:FormItemIcon\](#object-formitemicon).

**Flags**: IR

---
## Attr: Point.x

### Description
The x coordinate of this point.

**Flags**: IR

---
## Method: DynamicForm.getField

### Description
Synonym for dynamicForm.getItem()

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| itemName | [FieldName](#type-fieldname) | false | — | name of the item you're looking for |

### Returns

`[FormItem](#type-formitem)` — FormItem object or null if not found

### Groups

- items

### See Also

- [DynamicForm.getItem](#method-dynamicformgetitem)

---
## Attr: TimeItem.secondIncrement

### Description
When \[useTextField\](#attr-timeitemusetextfield) is false and \[secondValues\](#attr-timeitemsecondvalues) is unset, this attribute specifies the increment to use when generating entries for the second picker. For example, if this attribute is set to 5, the second picker will contain only every fifth value between the \[secondMinValue\](#attr-timeitemsecondminvalue) and \[secondMaxValue\](#attr-timeitemsecondmaxvalue).

**Flags**: IRW

---
## Method: Date.getShortDayName

### Description
Return the abbreviated (up to 3 chars) day of week name for this date (Mon, Tue, etc). To modify the value returned by this method, set \[classAttr:DateUtil.shortDayNames\](#classattr-dateutilshortdaynames)

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| length | [int](#type-int) | false | — | Number of characters to return (Defaults to 3, can't be longer than 3) |

### Returns

`[String](#type-string)` — Abbreviated day name

### Groups

- dateFormatting

---
## Attr: SavedSearchItem.copySearchField

### Description
ListGridField shown in the pickList to allow users to copy existing searches. The field is type "icon" and displays the skin's standard "copy" icon.

**Flags**: IR

---
## Method: ColumnTree.selectRecords

### Description
Select/deselect a list of \[object:Record\](#object-record)s passed in explicitly, or by index.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| records | [Array of Record](#type-array-of-record)|[number](#type-number) | false | — | records (or row numbers) to select |
| newState | [boolean](#type-boolean) | true | — | new selection state (if null, defaults to true) |
| rowNums | [Array of Integer](#type-array-of-integer)|[Integer](#type-integer) | true | — | row numbers to select. Required for \[multi-link trees\](#attr-treemultilinktree) unless row numbers are passed in the "records" param. If passed, the rowNums array should correspond to the records array (ie, rowNums\[0\] refers to the same object as records\[0\]) |
| colNum | [Integer](#type-integer) | true | — | Column number |

### Groups

- selection

---
## ClassMethod: Tour.getTour

### Description
Get a Tour instance by it's ID.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| tourId | [Identifier](#type-identifier) | false | — | tour ID to retrieve |

### Returns

`[Tour](#type-tour)` — the tour, or null if not defined

---
## Attr: DetailViewer.hiliteIconRightPadding

### Description
How much padding should there be on the right of \[hilite icons\](#attr-detailviewerhiliteicons) by default? Can be overridden at the field level

### Groups

- hiliting

**Flags**: IRW

---
## Method: ColorPicker.getRed

### Description
Returns the Red element of the currently-selected color, as an integer from 0-255

### Returns

`[int](#type-int)` — red color component

### See Also

- [ColorPicker.setRed](#method-colorpickersetred)

---
## ClassMethod: DMI.call

### Description
Calls a server-side DMI method. At a minimum, you need to specify the appID (\[.app.xml file\](#group-applicationdeclaration)), \[attr:ServerObject.className\](#attr-serverobjectclassname) or \[attr:ServerObject.ID\](#attr-serverobjectid) and methodName to call. Arguments and callback are optional. There are two ways to invoke this method:

 DMI.call(appID, className, methodName, 
          arg1, arg2 ...argN, callback);
 

or:

 DMI.call({
     appID: appID,
     className: className,
     methodName: methodName,
     arguments: \[arg1, arg2, ...argN\], //optional
     callback: callback, //optional
     requestParams: requestProps // optional
 });
 

If you use the first signature, you must either specify a callback or if you don't want a callback, pass a `null` as the last argument. The second signature allows you to specify requestParams that are applied to the \[object:RPCRequest\](#object-rpcrequest) generated by this DMI call. This allows you to override some defaults - for example to suppress the "Contacting Server" prompt, change it's text; change the timeout or set any other property settable on \[object:RPCRequest\](#object-rpcrequest).

Arguments to be passed to the server method may be specified. If present, each argument will be serialized into JSON, sent to the server and translated to an equivalent Java object to be passed into the method. The translation follows the same rules as for data passed to the server as part of a standard \[RPCRequest\](#attr-rpcrequestdata).  
For example if a server side method has the signature

 someMethod(String title, Map overrides);
 

a DMI call to that method would could pass in a standard String and JavaScript object - for example:

 isc.DMI.call({
     appID: "someApp",
     className: "com.smartclient.demo.MyClass",
     methodName: "someMethod",
     arguments: \["Title String", {field1:"Value 1", field2:"Value 2"}\]
 });
 

Note that you can use the \[group:loadDMIStubsTag\](#group-loaddmistubstag) tag to bind all methods of `ServerObjects` defined in a given .app.xml file and call methods on them directly.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| appID | [String](#type-string)|[Object](#type-object) | false | — | the appID (.app.xml file to look in) or comprehensive request object as documented above. |
| className | [String](#type-string) | false | — | \[attr:ServerObject.className\](#attr-serverobjectclassname) or \[attr:ServerObject.ID\](#attr-serverobjectid) |
| methodName | [String](#type-string) | false | — | the name of the method to call on the serverObject |
| args | [Any](#type-any) | false | — | The next N-1 params specify arguments to the server-side method. |
| callback | [RPCCallback](#type-rpccallback) | false | — | The callback of the response. If you do not want a callback, you must specify a `null` value for this parameter when using the first signature (documented above). |

### Returns

`[RPCRequest](#type-rpcrequest)` — the RPCRequest that was sent to the server.

---
## Attr: ListGrid.savedSearchStoredState

### Description
Set to "criteria" if you want only criteria to be stored for ListGrids and TreeGrids instead of the full viewState of the component.

### See Also

- [SavedSearchItem](#class-savedsearchitem)

**Flags**: IR

---
## Method: DrawSector.setCenterPoint

### Description
Change the center point for this sector.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| left | [Coordinate](#type-coordinate) | false | — | X coordinate of the center point (in the global coordinate system). |
| top | [Coordinate](#type-coordinate) | false | — | Y coordinate of the center point (in the global coordinate system. |

---
## Method: ProcessElement.updateGlobalIDReferences

### Description
Updates references to a global ID within the properties of this process element (i.e. rename). This method is not called as part of workflow execution but is used by \[class:Reify\](#class-reify) to keep workflow event handlers in sync with ID changes within the screen.

Each processElement or Task that has properties that save global IDs (like a component ID or criteria referencing \[ruleContext\](#attr-canvasrulescope)) must be able to update its references on demand by overriding this method or defer to its superclass.

There are a number of helper methods to make this easier listed below.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| oldId | [Identifier](#type-identifier) | false | — | the ID being renamed |
| newId | [Identifier](#type-identifier) | false | — | the new ID to be assigned |

### Returns

`[Boolean](#type-boolean)` — true if any references were updated; false otherwise

### See Also

- [ProcessElement.updateGlobalIDInValueProperty](#method-processelementupdateglobalidinvalueproperty)
- [ProcessElement.updateGlobalIDInValues](#method-processelementupdateglobalidinvalues)
- [ProcessElement.updateGlobalIDInCriteria](#method-processelementupdateglobalidincriteria)

---
## Method: DateItem.getEnteredValue

### Description
Returns the raw text value typed into this items text field if \[attr:DateItem.useTextField\](#attr-dateitemusetextfield) is true (otherwise returns the result of this.getValue()).

### Returns

`[String](#type-string)` — value the user entered

---
## Attr: DataSourceField.canSortClientOnly

### Description
When true, this field can only be used for sorting if the data is entirely client-side.

**Flags**: IRW

---
## Attr: ListGrid.fieldPickerShowSampleValues

### Description
When set to false, sample values of the FieldPicker are never shown. This property applies to the entire FieldPicker.

**Flags**: IR

---
## Class: FieldPicker

### Description
FieldPicker provides a configuration dialog that displays, side-by-side, the available and currently-displayed fields of a \[interface:DataBoundComponent\](#interface-databoundcomponent). It allows for easy customization of the order in which the fields of a \[interface:DataBoundComponent\](#interface-databoundcomponent) are displayed, and of which are visible. If so configured, it also allows for convenient launching of the HiliteEditor, FormulaBuilder, and SummaryBuilder. A FieldPicker instance runs in its own window, a \[class:FieldPickerWindow\](#class-fieldpickerwindow)

---
## Attr: ColumnTree.fields

### Description
An array of field objects, specifying the order, layout, dynamic calculation, and sorting behavior of each field in each column in the columnTree object. In ColumnTrees, the fields array specifies sub-columns within each main column. Each field in the fields array is a ListGridField object.

If \[attr:ColumnTree.dataSource\](#attr-columntreedatasource) is also set, this value acts as a set of overrides as explained in \[attr:DataBoundComponent.fields\](#attr-databoundcomponentfields).

### Groups

- databinding

### See Also

- [ListGridField](#object-listgridfield)

**Flags**: IRW

---
## Attr: Window.maximizeButton

### Description
Button that will make this Window fill the browser via \[method:Window.maximize\](#method-windowmaximize).

**Flags**: R

---
## Attr: Canvas.editNode

### Description
The component's \[object:EditNode\](#object-editnode) for a component that has been created by a \[interface:Palette\](#interface-palette) from a \[object:PaletteNode\](#object-palettenode).

**Flags**: R

---
## Attr: OperationBinding.headers

### Description
Applies to RestConnector dataSources (\[serverType\](#attr-datasourceservertype) "rest") only. This is an operationBinding-level override of \[attr:DataSource.headers\](#attr-datasourceheaders) - see that property's documentation for details

### Groups

- serverRestConnector

**Flags**: IR

---
## Attr: RibbonButton.menuAlign

### Description
The horizontal alignment of this button's menu, in relation to the button. When unset, default behavior is to align the right edges of button and menu if the page is in RTL mode, and the left edges otherwise.

### Groups

- menu

**Flags**: IR

---
## Method: DrawLinePath.getCenter

### Description
Get the center point of the line path.

### Returns

`[Point](#type-point)` — the center point

---
## Method: ListGrid.showFilterWindow

### Description
Shows the dialog for \[attr:ListGrid.filterWindowCriteria\](#attr-listgridfilterwindowcriteria) allowing end-users to edit the advanced filter. This method can be called directly but it is also used to show the dialog when \[attr:ListGrid.allowFilterWindow\](#attr-listgridallowfilterwindow) is enabled and the user chooses the \["Advanced Filtering"\](#attr-listgridadvancedfilteringtext) menu option.

#### Note:
 this feature requires [SmartClient Pro](https://www.smartclient.com/product/) or better.

---
## Attr: ListGrid.fullRowRangeDisplayValue

### Description
Dynamic String specifying the format for the \[row range summary value\](#method-listgridgetrowrangedisplayvalue) when \[type:RowRangeDisplayStyle\](#type-rowrangedisplaystyle) is set to `"full"`.

The following variables are available for evaluation within this string:

*   `rowRange`: the \[formatted row range\](#method-listgridgetformattedrowrange)
*   `rowCount`: the \[formatted row count\](#method-listgridgetformattedrowcount)

### Groups

- i18nMessages

**Flags**: IRW

---
## Attr: OperationBinding.recordName

### Description
For an XML DataSource, tagName of the elements to be used as records.

This is a simple alternative to \[attr:OperationBinding.recordXPath\](#attr-operationbindingrecordxpath) when the elements to be used as records all share a tagName.

When a DataSource has a WebService, `recordName` can also be set to the name of any `complexType` declared within the WebService's WSDL file.

### Groups

- clientDataIntegration

**Flags**: IR

---
## Attr: SectionStack.canCollapseAll

### Description
In \[visibilityMode\](#attr-sectionstackvisibilitymode) "mutex", whether to allow the last remaining expanded section to be collapsed. If false, collapsing the last open section will open the next one (wrapping around at the end).

**Flags**: IRW

---
## Attr: StyleGroup.expanded

### Description
Should this group's section be expanded?

**Flags**: IR

---
## Attr: BuildUIViaAIProgressDialog.title

### Description
Title for this Window, shown if \[showTitle\](#attr-windowshowtitle) is true in the \[header\](#attr-windowheader) (if drawn).

### Groups

- i18nMessages

**Flags**: IRW

---
## Attr: Canvas.autoDraw

### Description
If true, this canvas will draw itself immediately after it is created.

#### Note
 that you should turn this OFF for any canvases that are provided as children of other canvases, or they will draw initially, then be clear()ed and drawn again when added as children, causing a large performance penalty.

For example, the following code is incorrect and will cause extra draw()s:

     isc.Layout.create({
         members : \[
             isc.ListGrid.create()
         \]
     });
 

It should instead be:

     isc.Layout.create({
         members : \[
             isc.ListGrid.create(
#### { autoDraw: false }
)
         \]
     });
 

In order to avoid unwanted autoDrawing systematically, it is recommend that you call \[isc.setAutoDraw(false)\](#staticmethod-iscsetautodraw) immediately after SmartClient is loaded and before any components are created, then set `autoDraw:true` or call draw() explicitly to draw components.

Otherwise, if the global setting for autoDraw remains `true`, you must set autoDraw:false, as shown above, on every component in your application that should not immediately draw: all Canvas children, Layout members, Window items, Tab panes, etc, however deeply nested. Forgetting to set autoDraw:false will result in one more clear()s - these are reported on the Results tab of the \[Developer Console\](#group-debugging), and can be tracked to individual components by using the "clears" log category in the Developer Console.

### Groups

- drawing

**Flags**: IR

---
## Attr: SelectItem.pickerExitButtonTitle

### Description
The title for the \[attr:SelectItem.pickerExitButton\](#attr-selectitempickerexitbutton).

### Groups

- i18nMessages
- panelPlacement

**Flags**: IR

---
## Method: FormItem.getPageTop

### Description
Returns the drawn page-top coordinate of this form item in pixels.

### Returns

`[int](#type-int)` — page-top coordinate in px

### Groups

- positioning

---
## Method: DrawItem.setStartArrow

### Description
Set the arrowhead at the beginning of this path.

#### NOTE:
 Not all DrawItem classes support arrowheads. You can use \[method:DrawItem.supportsStartArrow\](#method-drawitemsupportsstartarrow) to dynamically check whether a DrawItem instance supports this method.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| arrowStyle | [ArrowStyle](#type-arrowstyle) | false | — | style of arrow to use |

---
## ClassMethod: EventHandler.setDragOffset

### Description
Sets the initial coordinate offset of the last event, typically a mouseDown or touchStart, from the drag target. For example, when grabbing and dragging a \[class:Scrollbar\](#class-scrollbar) thumb with the mouse, you'd expect positive coordinates that reflect your position relative to the top, left corner of the thumb. If a drag tracker will be used, call \[classMethod:EventHandler.setDragTracker\](#classmethod-eventhandlersetdragtracker) instead, which takes optional arguments `offsetX` and `offsetY` that act similarly to those passed to this method.

Your canvas can call this method to set the initial drag offset to whatever you want like so:

    dragStart : function () {
        isc.EventHandler.setDragOffset(5, 20);
    }

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| offsetX | [int](#type-int) | false | — | initial x-offset for the drag |
| offsetY | [int](#type-int) | false | — | initial y-offset for the drag |

### Groups

- dragdrop

### See Also

- [Canvas.dragStart](#method-canvasdragstart)

---
## Attr: MetricSettings.gradationZeroLineProperties

### Description
Properties for the gradation line drawn for zero (slightly thicker by default).

### Groups

- gradations

**Flags**: IR

---
## Attr: FormItem.foreignDisplayField

### Description
For items with an \[attr:FormItem.optionDataSource\](#attr-formitemoptiondatasource), this property specifies an explicit display field for records within the option dataSource. Typically this property will be set in conjunction with \[attr:FormItem.displayField\](#attr-formitemdisplayfield) in the case where the name of the displayField within the record being edited differs from the displayField in the optionDataSource.

See \[attr:DataSourceField.foreignDisplayField\](#attr-datasourcefieldforeigndisplayfield) for additional details.

### See Also

- [FormItem.getDisplayFieldName](#method-formitemgetdisplayfieldname)

**Flags**: IR

---
## Attr: DSRequest.startRow

### Description
Starting row of requested results, used only with fetch operations. If unset, 0 is assumed.

Note that startRow and endRow are zero-based, inclusive at the beginning and exclusive at the end (like substring), so startRow: 0, endRow: 1 is a request for the first record.

### Groups

- paging

**Flags**: IR

---
## Attr: ColorPicker.cancelButton

### Description
Cancel button for the ColorPicker

**Flags**: R

---
## Type: MockDSExportFormat

### Description
—

### Values

| Value | Description |
|-------|-------------|
| "reifyCSV" | export as Reify-specific CSV |
| "xmlMockDS" | serialize as XML |
| "jsMockDS" | serialize as JavaScript |

---
## Attr: JSONEncoder.strictQuoting

### Description
Whether all property names should be quoted, or only those property names that are not valid identifiers or are JavaScript reserved words (such as "true").

Encoding only where required produces slightly shorter, more readable output which is still compatible with JavaScript's eval():

 {
     someProp : "someValue",
     "true" : "otherValue",
     otherProp : "otherValue"
 }
 

.. but is not understood by many server-side JSON parser implementations.

**Flags**: IR

---
## Method: Calendar.eventRepositionStart

### Description
Notification fired when a user drags an EventCanvas. Return false to cancel the drag.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| event | [CalendarEvent](#type-calendarevent) | false | — | the event that's about to be moved |

### Returns

`[Boolean](#type-boolean)` — return false to cancel the default drag start behavior

---
## Method: ListGridField.formatInactiveCellValue

### Description
Field-level formatter for inactive content.

If present, this method will be invoked instead of \[method:ListGridField.formatCellValue\](#method-listgridfieldformatcellvalue) in cases where the grid is rendering non-interactive content outside. See \[method:ListGrid.formatInactiveCellValue\](#method-listgridformatinactivecellvalue) for more details.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| value | [Any](#type-any) | false | — | raw value for the cell, from the record for the row |
| record | [ListGridRecord](#type-listgridrecord) | false | — | Record object for the cell. Note: If this is a new row that has not been saved, in an editable grid, it has no associated record object. In this case the edit values will be passed in as this parameter (see \[method:ListGrid.getEditValues\](#method-listgridgeteditvalues)) |
| rowNum | [number](#type-number) | false | — | row number for the cell |
| colNum | [number](#type-number) | false | — | column number for the cell. |
| grid | [ListGrid](#type-listgrid) | false | — | the ListGrid displaying the cell |

### Returns

`[HTMLString](#type-htmlstring)` — HTML to display in the cell

### See Also

- [ListGrid.formatInactiveCellValue](#method-listgridformatinactivecellvalue)

---
## Attr: Calendar.eventHeaderHeight

### Description
When \[eventHeaderWrap\](#attr-calendareventheaderwrap) is false and \[showEventDescriptions\](#attr-calendarshoweventdescriptions) is true, this is the fixed height for the \[header area\](#attr-eventcanvasshowheader) in event canvases.

**Flags**: IR

---
## Attr: FilterBuilder.operatorPickerWidth

### Description
Width for the operator picker formItem displayed in clauses within this FilterBuilder.

**Flags**: IR

---
## Method: ButtonItem.setShowFocusedAsOver

### Description
Sets showFocusedAsOver.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| showFocusedAsOver | [boolean](#type-boolean) | false | — | — |

---
## Attr: FacetChart.extraAxisLabelAlign

### Description
Horizontal alignment of labels shown in extra y-axes, shown to the right of the chart.

### Groups

- labelsAndTitles

**Flags**: IRW

---
## Attr: FormItem.hoverPersist

### Description
Allows interaction with hovers when the cursor is positioned over them.

Overrides the \[same attribute\](#attr-canvashoverpersist) on the parent form.

### Groups

- hovers

### See Also

- [FormItem.hoverFocusKey](#attr-formitemhoverfocuskey)

**Flags**: IRW

---
## Attr: Button.iconAlign

### Description
If this button is showing an icon should it be right or left aligned?

### Groups

- buttonIcon

**Flags**: IR

---
## Attr: DynamicForm.readOnlyDisplay

### Description
If \[attr:DynamicForm.canEdit\](#attr-dynamicformcanedit) is set to `false`, how should the items in this form be displayed to the user?

Can be overridden via \[attr:FormItem.readOnlyDisplay\](#attr-formitemreadonlydisplay) on individual form items.

### Groups

- appearance
- readOnly

**Flags**: IRW

---
## Group: communication

### Description
—

---
## StaticMethod: isc.warn

### Description
Show a modal dialog with a message, icon, and "OK" button. See \[attr:Dialog.warnIcon\](#attr-dialogwarnicon).

The callback will receive boolean true for an OK button click, or null if the Dialog is dismissed via the close button.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| message | [HTMLString](#type-htmlstring) | false | — | message to display |
| callback | [Callback](#type-callback) | true | — | Optional Callback to fire when the user dismisses the dialog. This has the single parameter 'value', indicating the value returned by the Warn dialog from 'okClick()' etc. |
| properties | [Dialog Properties](#type-dialog-properties) | true | — | additional properties for the Dialog. To set \[custom buttons\](#attr-dialogbuttons) for the Dialog, set properties.buttons to an array of buttons eg: { buttons : \[Dialog.OK, Dialog.CANCEL\] } |

### Groups

- Prompting

### See Also

- [Dialog.Warn](#classattr-dialogwarn)
- [isc.say](#staticmethod-iscsay)
- [isc.ask](#staticmethod-iscask)
- [Dialog.okClick](#method-dialogokclick)
- [Dialog.WARN_TITLE](#classattr-dialogwarn-title)

---
## Attr: AsyncOperationParams.cancellationController

### Description
A \[class:CancellationController\](#class-cancellationcontroller) that the asynchronous operation should look to for whether the operation is canceled.

This may be `null` if the invoker of the asynchronous operation does not need the ability to cancel. However, note that the \[result type\](#attr-asyncoperationresulttype) may still be "canceled"; for example, the asynchronous operation may be self-canceling after a timeout.

Implementations of asynchronous operations must treat this `CancellationController` as observe-only, and they cannot \[cancel\](#method-cancellationcontrollercancel) it.

**Flags**: IR

---
## Method: FormItem.mapDisplayToValue

### Description
Given a display value for this FormItem, return the underlying data value. This is done by reverse value-mapping, and/or parsing.

This method is called by the framework to derive an underlying data value for a given display value (ie, the value the user sees and interacts with) in a FormItem. Your own code can call this method if you need to programmatically obtain the underlying data value for a given display value. However, it is 
#### not
 intended as an override point, and you should not treat it as one. If you have a field that requires the stored value to be different from the displayed value, and the requirement cannot be satisfied with a \[valueMap\](#attr-formitemvaluemap) for some reason, you can add custom parsing logic by implementing \[parseEditorValue()\](#method-formitemparseeditorvalue)

This method is also 
#### not
 intended as a place where you can validate, sanitize, transform or canonicalize user input

*   To ensure you get well-formed input values, use \[input masks\](#attr-textitemmask) or the \[change() event\](#method-formitemchange)
*   To transform or canonicalize input values, use a \[mask validator\](#type-validatortype) with "transformTo". See the link to "mask validator" for more details and an example of this
*   To transform or canonicalize input character-by-character as the user types, use \[transformInput()\](#method-formitemtransforminput)

#### Deriving the data value
The process of deriving an underlying data display value from a display value involves the following steps:

*   If the formItem declares a \[method:FormItem.parseEditorValue\](#method-formitemparseeditorvalue) method, it is called
*   Otherwise, if the formItem is of a \[class:SimpleType\](#class-simpletype) that declares a \[parseInput()\](#method-simpletypeparseinput) method, it is called
*   If the formItem is of a `SimpleType` that \[inheritsFrom\](#attr-simpletypeinheritsfrom) "date", "time" or "datetime", it will be parsed as a date, time or datetime. Note, this parsing step is applied on top of custom SimpleType- and FormItem-level parsing
*   If the formItem declares a \[valueMap\](#attr-formitemvaluemap), a value is derived by looking up the display value (including the effects of any parsing we may have done so far) in the valueMap

#### Note:
 Unlike the corollary method \[mapValueToDisplay()\](#method-formitemmapvaluetodisplay), there is no special built-in handling of `[attr:DataSourceField.multiple](#attr-datasourcefieldmultiple):true` fields. If you want an array to be parsed out of some user input, you must write the parser method to do so.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| value | [String](#type-string) | false | — | display value |

### Returns

`[Any](#type-any)` — value re-mapped for storing

### See Also

- [FormItem.mapValueToDisplay](#method-formitemmapvaluetodisplay)

---
## Method: TileGrid.setHilites

### Description
Only supported on ListGrid for now.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| hilites | [Array of Hilite](#type-array-of-hilite) | false | — | Array of hilite objects |

### Groups

- hiliting

---
## Method: TileGrid.filterData

### Description
Retrieves data that matches the provided criteria and displays the matching data in this component.

This method behaves exactly like \[method:ListGrid.fetchData\](#method-listgridfetchdata) except that \[attr:DSRequest.textMatchStyle\](#attr-dsrequesttextmatchstyle) is automatically set to "substring" so that String-valued fields are matched by case-insensitive substring comparison.

For a discussion of the various filtering and criteria-management APIs and when to use them, see the \[Grid Filtering overview\](#group-gridfiltering).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| criteria | [Criteria](#type-criteria) | true | — | Search criteria. If a \[class:DynamicForm\](#class-dynamicform) is passed in as this argument instead of a raw criteria object, will be derived by calling \[method:DynamicForm.getValuesAsCriteria\](#method-dynamicformgetvaluesascriteria) |
| callback | [DSCallback](#type-dscallback) | true | — | callback to invoke when a fetch is complete. Fires only if server contact was required; see \[fetchData()\](#method-listgridfetchdata) for details |
| requestProperties | [DSRequest](#type-dsrequest) | true | — | for databound components only - optional additional properties to set on the DSRequest that will be issued |

### Groups

- dataBoundComponentMethods

### See Also

- [DataBoundComponent.willFetchData](#method-databoundcomponentwillfetchdata)

---
## Attr: ModalWindow.autoCenter

### Description
If true, this Window widget will automatically be centered on the page when shown. If false, it will show up in the last position it was placed (either programmatically, or by user interaction).

#### Note:
 If an auto-centering Window is either programmatically moved or dragged by an end user, auto-centering behavior is automatically turned off. To manually center a Window, you can use \[centerInPage()\](#method-windowcenterinpage). Auto-centering will also be disabled if you pass an explicit \[left\](#attr-canvasleft) or \[top\](#attr-canvastop) value at \[create time\](#classmethod-classcreate).

### Groups

- appearance
- location

**Flags**: IRW

---
## Attr: OperationBinding.transformRawResponseScript

### Description
#### Applicable to \[server-side REST DataSources\](#group-serverrestconnector) only

A scriptlet to be executed on the server after data has been fetched from the REST service by this operation, but before it is processed through templating. See \[attr:DataSource.transformRawResponseScript\](#attr-datasourcetransformrawresponsescript) for further details.

Note, unlike many OperationBinding-level properties, a `transformRawResponseScript` at the OperationBinding level does not hide a `transformRawResponseScript` defined at the DataSource level. Instead, if you define `transformRawResponseScript` against both the DataSource and the OperationBinding, 
#### both
 are run - first the DataSource-level script, then the OperationBinding-level one.

### Groups

- serverScript

**Flags**: IR

---
## Method: DrawItem.showAllKnobs

### Description
Shows all supported control knobs for this drawItem. Updates \[attr:DrawItem.knobs\](#attr-drawitemknobs) to include the supported knobTypes and if necessary draws out the appropriate control knobs.

---
## Method: FormItem.titleHoverHTML

### Description
If defined, this method should return the HTML to display in a hover canvas when the user holds the mousepointer over this item's title. Return null to suppress the hover canvas altogether.

If not defined, \[method:DynamicForm.titleHoverHTML\](#method-dynamicformtitlehoverhtml) will be evaluated to determine hover content instead.

If \[attr:FormItem.canHover\](#attr-formitemcanhover) is set to false, this method is not called.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| item | [FormItem](#type-formitem) | false | — | Pointer to this item |
| form | [DynamicForm](#type-dynamicform) | false | — | This items form |

### Returns

`[HTMLString](#type-htmlstring)` — HTML to be displayed in the hover

### Groups

- Hovers

### See Also

- [FormItem.canHover](#attr-formitemcanhover)
- [FormItem.prompt](#attr-formitemprompt)
- [FormItem.titleHover](#method-formitemtitlehover)
- [FormItem.itemHoverHTML](#method-formitemitemhoverhtml)
- [FormItem.showClippedTitleOnHover](#attr-formitemshowclippedtitleonhover)

**Flags**: A

---
## ClassAttr: ListGrid.BOTH

### Description
A declared value of the enum type \[RecordDropAppearance\](#type-recorddropappearance).

**Flags**: R

---
## Attr: DataSource.autoDiscoverTree

### Description
Causes \[classMethod:Tree.discoverTree\](#classmethod-treediscovertree) to be called on dsResponse.data in order to automatically discover tree structures in the response data.

If autoDiscoverTree is set, discoverTree() is called after the default dsResponse.data has been derived (\[recordXPath\](#attr-operationbindingrecordxpath) and \[valueXPath\](#attr-datasourcefieldvaluexpath) have been applied) and after \[method:DataSource.transformResponse\](#method-datasourcetransformresponse) has been called.

If a DataSourceField is declared with \[childrenProperty:true\](#attr-datasourcefieldchildrenproperty), discoverTree() will be invoked with \[settings.newChildrenProperty\](#attr-discovertreesettingsnewchildrenproperty) set to the name of the field marked as the childrenField. Similarly, if the DataSource has a \[attr:DataSource.titleField\](#attr-datasourcetitlefield) it will be used as the \[settings.nameProperty\](#attr-discovertreesettingsnameproperty).

**Flags**: IR

---
## ClassAttr: Operators.isNullTitle

### Description
Title for the "isNull" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassMethod: AutoTest.setTestRoot

### Description
Sets the implicit root canvas available in scLocators starting "//testRoot\[\]". Setting this property may enable one to use the same script to test identical widget hierarchies that are rooted under different base widgets.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| canvas | [Canvas](#type-canvas) | false | — | the implicit root |

### Groups

- autoTest

---
## ClassAttr: Operators.regexpTitle

### Description
Title for the "regexp" operator

### Groups

- i18nMessages

**Flags**: IR

---
## Method: MultiLinkSelection.getSelection

### Description
Returns the selected nodes in this grid as a list of \[object:NodeLocator\](#object-nodelocator)s.

### Returns

`[Array of NodeLocator](#type-array-of-nodelocator)` — The list of selected node occurences in the grid

### Groups

- selection

---
## Attr: Button.canAdaptWidth

### Description
This flag enables \[adaptive width\](#attr-canvascanadaptwidth) for the button.

If enabled the button will support rendering in a 'collapsed' view if there isn't enough space in a layout to render it at normal size. There are a couple of ways this can be achieved.

*   If \[attr:Button.adaptWidthShowIconOnly\](#attr-buttonadaptwidthshowicononly) is true and this button shows an icon, the title will be hidden if there isn't enough space to render it, allowing it to shrink to either the rendered icon width, or any specified \[minWidth\](#attr-canvasminwidth), whichever is larger.
*   Otherwise, if the button has a specified \[minWidth\](#attr-canvasminwidth), and \[attr:Button.autoFit\](#attr-buttonautofit) is true, autoFit will be temporarily disabled, if there isn't enough room, allowing the title to be clipped

In either case the title will show on hover unless an explicit hover has been specified such as by overriding \[method:Button.titleHoverHTML\](#method-buttontitlehoverhtml).

### See Also

- [Canvas.canAdaptWidth](#attr-canvascanadaptwidth)

**Flags**: IR

---
## Attr: SimpleType.readOnlyDisplay

### Description
Default \[readOnlyDisplay\](#attr-formitemreadonlydisplay) for fields of this type.

For more sophisticated management of read-only behavior, see \[attr:SimpleType.readOnlyEditorType\](#attr-simpletypereadonlyeditortype).

**Flags**: IR

---
## Attr: ShowNextToComponentTask.canOcclude

### Description
Can this component can be positioned on top of the other component if there isn't room to show next to it?

**Flags**: IR

---
## Attr: ListGrid.showSelectionCanvas

### Description
If \[selectionType\](#attr-listgridselectiontype) is set to "single", setting this property to `true` means selection will be displayed to the user with the \[selectionCanvas\](#attr-listgridselectioncanvas) and/or \[selectionUnderCanvas\](#attr-listgridselectionundercanvas) rather than with CSS styling.

If `showSelectionCanvas` is set to `true`, then the `selectionUnderCanvas` will automatically be enabled unless \[showSelectionUnderCanvas\](#attr-listgridshowselectionundercanvas) is set to `false`.

NOTE: It is recommended to use the `selectionUnderCanvas` rather than the `selectionCanvas` if possible because the `selectionCanvas` is stacked on top of the selected record and this may interfere with event handling in rare cases. If no interactive components are shown in the `selectionCanvas` and it simply provides custom styling, then the `selectionUnderCanvas` should be used instead.

With \[frozen fields\](#attr-listgridcanfreezefields), the `selectionCanvas` is displayed only over the non-frozen fields of the selected row.

### Groups

- rowEffects

### See Also

- [ListGrid.showSelectionUnderCanvas](#attr-listgridshowselectionundercanvas)

**Flags**: IRWA

---
## ClassAttr: Authentication.logOutURL

### Description
URL to open for logging the current user out.

This is a dynamic string - text within `${...}` are dynamic variables and will be evaluated as JS code when the message is displayed.

The dynamic variables available are the fields in the \[classMethod:Authentication.getCurrentUser\](#classmethod-authenticationgetcurrentuser) record.

**Flags**: IR

---
## Method: Canvas.getWidth

### Description
Return the width of this object, in pixels.

See \[group:gettingCanvasSize\](#group-gettingcanvassize)

### Returns

`[Number](#type-number)` — width

### Groups

- sizing

---
## Method: ListGridField.recordDoubleClick

### Description
Executed when this field is double-clicked. Note that if \[method:ListGrid.recordDoubleClick\](#method-listgridrecorddoubleclick) is also defined, it will be fired for fields that define a recordDoubleClick handler if the field-level handler returns true. Return false to prevent the grid-level handler from firing.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| viewer | [ListGrid](#type-listgrid) | false | — | the listGrid that contains doubleclick event |
| record | [ListGridRecord](#type-listgridrecord) | false | — | the record that was double-clicked |
| recordNum | [number](#type-number) | false | — | number of the record clicked on in the current set of displayed records (starts with 0) |
| field | [ListGridField](#type-listgridfield) | false | — | the field that was clicked on (field definition) |
| fieldNum | [number](#type-number) | false | — | number of the field clicked on in the listGrid.fields array |
| value | [Object](#type-object) | false | — | value of the cell (after valueMap, etc. applied) |
| rawValue | [Object](#type-object) | false | — | raw value of the cell (before valueMap, etc applied) |

### Returns

`[boolean](#type-boolean)` — false to stop event bubbling

### Groups

- events

### See Also

- [ListGrid.recordClick](#method-listgridrecordclick)

---
## Method: ValuesManager.showErrors

### Description
Method to explicitly show the latest set of validation errors present on this ValuesManager.  
Will redraw all member forms to display (or clear) currently visible errors, and fire \[method:ValuesManager.handleHiddenValidationErrors\](#method-valuesmanagerhandlehiddenvalidationerrors) to allow custom handling of hidden errors.

### Groups

- errors

---
## Group: autoChildren

### Description
An autoChild is an automatically generated subcomponent that a component creates to handle part of its presentation or functionality.

An example is the Window component and its subcomponent the "header".

AutoChildren support a standard set of properties that can be used to customize or skin them.

This topic explains how to use the autoChild system when creating custom components in order to create maximum flexibility. To learn how to use the autoChild system with pre-existing components, \[go here\](#group-autochildusage).

Before reading this topic, be sure you have read the ${isc.DocUtils.linkForDocNode('QuickStart Guide')} material on creating custom components and have reviewed the provided examples.

_Note:_ the autoChild pattern allows you to generate instances of any \[class:Canvas\](#class-canvas) subclass, but FormItems \[may not be created outside of a DynamicForm\](#classmethod-formitemcreate) and as such can not be instantiated as autoChildren using the APIs described below.

#### Basics

The following is an example of creating subcomponents 
#### without
 using the AutoChild pattern. In this case a fictitious "Portlet" class is being created, which uses an instance of isc.Label to serve as it's header.

 isc.defineClass("Portlet", "VLayout").addProperties({
     initWidget : function () {
         this.Super("initWidget", arguments);

         this.headerLabel = isc.Label.create({
             autoDraw:false,
             contents: this.title, 
             styleName: this.titleStyleName,
             portlet:this,
             click : function () { this.portlet.bringToFront() },
             wrap:false,  
             overflow:"hidden", 
             width:"100%"
         });
         this.addMember(this.headerLabel);
         ...
 

While straightforward, this approach provides limited flexibility to someone using the "Portlet" class. There is no way to:

1.  avoid creating the headerLabel, for a "headerless" portlet
2.  use a different, more advanced class as a header (eg, StretchImgButton or a custom class)
3.  skin / change the appearance of the headerLabel, beyond setting its `styleName`
4.  change it's layout behavior (eg enable autoSize)
5.  add or override event handlers

Let's imagine we wanted to add some of the above features. We could change the code like so:

 isc.defineClass("Portlet", "VLayout").addProperties({
     
#### showHeaderLabel:true,
     
#### headerLabelConstructor:isc.Label,
     initWidget : function () {
         this.Super("initWidget", arguments);

         
#### if (this.showHeaderLabel) {
             this.headerLabel = this.headerLabelConstructor.create({
                 autoDraw:false,
                 contents: this.title, 
                 styleName: this.titleStyleName,
                 portlet:this,
                 click : function () { this.portlet.bringToFront() },
                 wrap:false,  
                 overflow:"hidden", 
                 width:"100%"
             }
#### , this.headerLabelProperties
);
             this.addMember(this.headerLabel);
         
#### }
         ...
 

Our additions solve our initial concerns:

*   `showHeaderLabel:false` can be set to suppress the header label
*   `headerLabelConstructor` allows you to switch to a different class
*   `headerLabelProperties` give you a means to add arbitrary properties (skinning properties, sizing properties, event handlers, etc)

However, the code is becoming more verbose and repetitive, and we've created a few additional properties that now need documentation and testing. This extra work is going to be multiplied by every subcomponent we create where we want this kind of flexibility.

Enter the AutoChild system: the purpose of the AutoChild system is to define a standard pattern for creating subcomponents with maximum flexibility. This means:

*   developers creating custom components write less code, have less to test and less to document
*   developers can more easily understand each other's code for custom components, because it follows a standard pattern
*   developers 
    #### using
     custom components have a standard pattern for customization, instead of learning customization APIs for every component separately

The code below uses the autoChild system to create the "headerLabel" subcomponent. This version of the code would still respect all of the customization properties from earlier examples (`headerLabelProperties` et al) and offers several additional degrees of flexibility still to be explained, yet it's significantly shorter. More importantly, this code is less redundant; the "boilerplate" code is gone and what's left is just the actual settings for the headerLabel subcomponent.

 isc.defineClass("Portlet", "VLayout").addProperties({
     headerLabelDefaults : {
         \_constructor:isc.Label,
         click : function () { this.creator.bringToFront() },
         wrap:false,  
         overflow:"hidden", 
         width:"100%"
     },
     initWidget : function () {
         this.Super("initWidget", arguments);

         this.addAutoChild("headerLabel", {
             contents: this.title, 
             styleName: this.titleStyleName
         });
         ...
 

The documentation for \[addAutoChild()\](#method-classaddautochild) and \[group:autoChildUsage\](#group-autochildusage) explains why this code will still respect the `showHeaderLabel` flag and other customization properties even though they aren't mentioned specifically.  
In this case the `_constructor` property has been used to make the headerLabel be generated as an instance of \[class:Label\](#class-label), but the developer could alternatively have used `headerLabelConstructor`. If both `_autoChildName_Constructor` and `_constructor` are set, `_autoChildName_Constructor` will be used.

Note that AutoChildren are not always created as soon as the parent component, and may be created only when the parent is drawn, or in some cases, only when needed. For the best chance of forward compatibility, use properties and defaults instead of accessing the live reference, and if you do access the live reference, access it only when it is clear that the AutoChild must have been created by that point. For example, even if you determined by experimentation that the Window class currently creates it's "header" AutoChild when the Window is created, you should avoid accessing it until the Window has drawn, to leave room for the Window's implementation to change such that creation of the "header" AutoChild is deferred until draw.

#### AutoChildren lifecycle

By default any auto-children created by \[method:Class.addAutoChild\](#method-classaddautochild) or \[method:Class.createAutoChild\](#method-classcreateautochild) will be \[destroyed\](#method-canvasdestroy) when the canvas that created them is destroyed. You can suppress this behavior by setting `dontAutoDestroy` to `true` on the auto child. To do this you could add the property to the defaults or properties block for the autoChild, or pass it into the creating method in the dynamic set of properties.

#### Subclassing a component with autoChildren

If you are subclassing a component that has an autoChild and you want to change defaults for that autoChild, the correct way to do so is to use \[changeDefaults()\](#classmethod-classchangedefaults):

 isc.defineClass("MyWindow", "Window");
 isc.MyWindow.changeDefaults("headerDefaults", { layoutMargin:10 });
 isc.MyWindow.addProperties({ 
    ...
 

`changeDefaults()` creates a copy of the superclass defaults and applies your changes, which is important because you want to inherit the superclass behavior without affecting the superclass, and yet apply overrides.

The following code sample indicates two common incorrect patterns for working with defaults, and the consequences of each:

 isc.defineClass("MyWindow", "Window").addProperties({
     // NO.  Superclass behavior / settings for autoChild
     // won't be inherited.  Use changeDefaults() instead.
     headerDefaults : { ... },
 
     initWidget : function () {
         this.Super("initWidget", arguments);

         // NO.  "headerDefaults" object is shared across the class,
         // changing it affects all instances created from here on.
         // Pass dynamic defaults to addAutoChild() instead
         this.headerDefaults.myProperty = this.newValue;
         ...
 });
 

#### defaults vs properties

For AutoChildren, defaults and properties both provide similar means of adding properties to an AutoChild, and the distinction between them is primarily one of convention: a class that uses AutoChildren should never define a default value for _autoChildName_Properties, so that instances can freely specify _autoChildName_Properties without overriding built-in behavior.

 isc.defineClass("MyWindow", "Window").addProperties({
     // NO.  Any further use of "headerProperties", in
     // instances or in subclasses, would wipe out behavior
     headerProperties : { ... },
 

By consistently using \[classMethod:Class.changeDefaults\](#classmethod-classchangedefaults) whenever you override autoChild defaults in a subclass, you ensure that your classes can in turn be subclassed and extended uniformly.

#### autoParents and creation order

The AutoChild pattern can create an entire hierarchy of generated subcomponents. For example, the \[class:Window\](#class-window) class included with SmartClient uses several AutoChildren as part of the overall header structure: separate autoChildren for the minimize button, close button, and then the header itself, a Layout-derived class that contains all other header controls.

To facilitate construction of hierarchies of autoChildren, the special `autoParent` property may appear in either defaults or properties for an autoChild, and indicates the name of another autoChild that should used as a parent. For example, to create a "closeButton" autoChild that will be a member of the "header" autoChild:

 isc.defineClass("Portlet", "VLayout").addProperties({
     headerDefaults : {
         \_constructor:isc.HLayout,
         ...
     },
     closeButtonDefaults : {
         
#### autoParent:"header",
         \_constructor:isc.ImgButton,
         ...
     },
     initWidget : function () {
         this.Super("initWidget", arguments);

         this.addAutoChild("header");
         this.addAutoChild("closeButton");
         ...
 

In addition to cutting down on code and making inter-autoChild relationships clearer, using `autoParent` rather than manual calls to addMember() allows a subclass of your component to potentially completely rearrange the autoChildren you have defined, while retaining their behavior.

When using `autoParent` to arrange autoChildren, create parents first, then children.

#### Tip:
 if you want all of the behaviors of \[addAutoChild()\](#method-classaddautochild) _except_ automatically adding the autoChild to a parent, set `autoParent:"none"`.

#### special case: TabSets and SectionStacks

An autoChild that appears as a \[attr:Tab.pane\](#attr-tabpane) or \[section item\](#attr-sectionstacksectionitems) does not have a clear way to refer to it's tab or section via the `autoParent` property. For this special case, the TabSet and SectionStack components allow tab.pane / section.items to contain the special string "autoChild:_autoChildName_". This will cause the corresponding autoChild to be automatically created when the tab is selected or section expanded.

Generally, whatever component is creating the AutoChildren should be the logically reusable, self-contained component, and all the meaty logic should appear as methods on that component. Then you know that the \[creator\](#attr-classcreator) is always the same thing, and always where all the logic is.

For example:

 isc.defineClass("Portlet", "VLayout").addProperties({
     ...
     mainTabsDefaults : {
         \_constructor:isc.TabSet,
         tabs : \[
             { title:"First Pane", pane:"autoChild:firstPane" }
         \]
     },
     firstPaneDefaults : {
         ...
     },
     initWidget : function () {
         this.Super("initWidget", arguments);

         // this automatically creates firstPane as an autoChild
         this.addAutoChild("mainTabs");
         ...

### See Also

- [Canvas.autoParent](#attr-canvasautoparent)
- [Class.autoCreator](#attr-classautocreator)

---
## ClassMethod: Page.ignore

### Description
Clear an observation set up by \[classMethod:Page.observe\](#classmethod-pageobserve).

This method is available as `isc.Page.ignore()` or just `isc.ignore()`

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| observerID | [String](#type-string) | false | — | ID returned from \[classMethod:Page.observe\](#classmethod-pageobserve) call we want to clear |

---
## Class: ToolStripMenuButton

### Description
Simple subclass of MenuButton with appearance appropriate for a ToolStrip menu button. Can be used to create an icon-only menu button, and icon with text, or a text only button by setting the icon and title attibutes as required.

---
## Method: ListGrid.getDrawnRowHeight

### Description
Get the drawn height of a row.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| rowNum | [number](#type-number) | false | — | — |

### Returns

`[number](#type-number)` — height

### Groups

- sizing
- positioning

**Flags**: A

---
## Attr: FacetChart.showRegressionLine

### Description
For scatter plots only, whether to display a regression curve that best fits the data of the two metric facet values.

The type of regression curve used depends on the \[type:RegressionLineType\](#type-regressionlinetype) property, which can be:

*   #### "line"
     – to draw a linear regression curve, or
*   #### "polynomial"
     – to draw a polynomial regression curve (of degree \[attr:FacetChart.regressionPolynomialDegree\](#attr-facetchartregressionpolynomialdegree)).

Note that the regression is computed using all of the data points and it does not depend on the values of any non-metric facets. For example, adding a legend facet will not change the regression curve.

See [http://en.wikipedia.org/wiki/Simple\_linear\_regression](http://en.wikipedia.org/wiki/Simple_linear_regression). See [http://en.wikipedia.org/wiki/Polynomial\_regression](http://en.wikipedia.org/wiki/Polynomial_regression).

### Groups

- statistics

### See Also

- [FacetChart.xAxisMetric](#attr-facetchartxaxismetric)
- [FacetChart.yAxisMetric](#attr-facetchartyaxismetric)
- [FacetChart.regressionLineProperties](#attr-facetchartregressionlineproperties)

**Flags**: IRW

---
## Type: PreserveOpenState

### Description
—

### Values

| Value | Description |
|-------|-------------|
| never | Never try to automatically preserve the openState. Nodes will be initially open or closed based solely on the \[attr:Tree.openProperty\](#attr-treeopenproperty) optionally set by the server. |
| whenUnique | If either the \[attr:Tree.idField\](#attr-treeidfield) or \[attr:Tree.nameProperty\](#attr-treenameproperty) has been set on the Tree, (so that nodes have either unique ids or unique paths), preserve openState by respecting the \[attr:Tree.openProperty\](#attr-treeopenproperty) set by the server, then applying the openState. |
| always | Like "whenUnique" but automatically preserves openState even if nodes cannot be uniquely identified. This means that nodes at the same tree positions (eg 3rd child of 5th node under root) will be placed in the same openState, regardless of whether that node has anything to do with the node that previously was at that tree position. |

---
## Attr: CreateScreenSettings.verifyAsError

### Description
Enable \[verifyAsError\](#classattr-rpcmanagerverifyaserror) behavior only for requests using these settings.

### See Also

- [CreateScreenSettings.verifyAsError](#attr-createscreensettingsverifyaserror)
- [LoadProjectSettings.verifyAsError](#attr-loadprojectsettingsverifyaserror)

**Flags**: IRW

---
## Method: Layout.removeMembers

### Description
Removes the specified members from the layout. If any of the removed members have resize bars, the bars will be destroyed.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| members | [Array of Canvas](#type-array-of-canvas)|[Canvas](#type-canvas) | false | — | array of members to be removed, or single member |

---
## Attr: TabSet.bottomEdgeSizes

### Description
If this tabSet will \[show edges\](#attr-tabsetshowpanecontaineredges) for the paneContainer, and \[attr:TabSet.symmetricEdges\](#attr-tabsetsymmetricedges) is set to false, the `leftEdgeSizes`, `rightEdgeSizes`, `topEdgeSizes` and `bottomEdgeSizes` properties allow the sizes of edges for the paneContainer to be customized depending on the \[attr:TabSet.tabBarPosition\](#attr-tabsettabbarposition).

The attribute should be specified an \[edgeSizes map\](#type-edgesizes), specifying the desired edge sizes where for the appropriate \[attr:TabSet.tabBarPosition\](#attr-tabsettabbarposition).

**Flags**: IR

---
## ClassAttr: AI.dataSourceIsRequiredErrorMessage

### Description
—

### Groups

- i18nMessages

**Flags**: RW

---
## Attr: SelectItem.pickButtonWidth

### Description
How large should the pick button be rendered?

**Deprecated**

**Flags**: IRWA

---
## Method: EditContext.makePaletteNodeTree

### Description
Creates a \[class:Tree\](#class-tree) of \[PaletteNodes\](#object-palettenode) from an \[object:EditNode\](#object-editnode) in this context's \[editNodeTree\](#method-editcontextgeteditnodetree), by using \[method:EditContext.makePaletteNode\](#method-editcontextmakepalettenode) on the passed `EditNode` and its descendents within the \[editNodeTree\](#method-editcontextgeteditnodetree).

The root node of the returned \[class:Tree\](#class-tree) will be a PaletteNode derived from the passed `EditNode`.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| editNode | [EditNode](#type-editnode) | false | — | root editNode to make Tree of PaletteNodes from |
| removeAutoIDs | [Boolean](#type-boolean) | false | — | should ID and autoID defaults be removed? |

### Returns

`[Tree](#type-tree)` — a Tree of paletteNodes or null

---
## Type: ValidatorType

### Description
Used to name a validator or reference a standard, built-in \[class:Validator\](#class-validator) - see list below.

To make use of a standard validator type for a field in a DataSource, or DynamicForm instance, specify the `validators` property to an array containing a validator definition where the `type` property is set to the appropriate type.

A custom error message can be specified for any validator type by setting the `errorMessage` property on the validator definition object, and some validator types make use of additional properties on the validator definition object such as `max` or `min`.

For example, to use the `integerRange` validator type:  
  
  `field:{       validators:[         {type:"integerRange", min:1, max:100}       ]     }`

Custom validators can be reused on the client by adding them to the global validator list, via the \[classMethod:Validator.addValidatorDefinition\](#classmethod-validatoraddvalidatordefinition) method.

### Values

| Value | Description |
|-------|-------------|
| isBoolean | Validation will fail if this field is non-empty and has a non-boolean value. |
| isString | Validation will fail if the value is not a string value. |
| isInteger | Tests whether the value for this field is a whole number. If `validator.convertToInteger` is true, float values will be converted into integers and validation will succeed. |
| isFloat | Tests whether the value for this field is a valid floating point number. |
| isFunction | Tests whether the value for this field is a valid expression or function; if it is valid, creates a \[stringMethod\](#group-stringmethods) object with the value and set the resultingValue to the StringMethod. |
| requiredIf | RequiredIf type validators should be specified with an `expression` property set to a \[stringMethod\](#group-stringmethods), which takes four parameters:

*   item - the DynamicForm item on which the error occurred (may be null)
*   validator - a pointer to the validator object
*   value - the value of the field in question
*   record - the "record" object - the set of values being edited by the widget

When validation is performed, the expression will be evaluated (or executed). If it returns `true`, the field will be treated as a required field, so validation will fail if the field has no value, or, in the case of a \[class:FileItem\](#class-fileitem) or \[class:UploadItem\](#class-uploaditem) and if client-side validation is supported by the browser, if no file is selected for upload or the selected file is empty.

To allow server-side enforcement, a `required` validator can be used instead. With the exception of "binary" fields, conditional criteria can be specified with the \[applyWhen\](#attr-validatorapplywhen) property.

See ${isc.DocUtils.linkForExampleId('conditionallyRequired')}.

**NOTE:** A requiredIf validator cannot be used to guarantee that a non-empty file is uploaded. The user's browser might not support client-side file validation. Using a requiredIf validator on a "binary" field may be appropriate in scenarios where the application does not technically require a non-empty file to be uploaded by the user. For example, in a bug tracking application, a file upload may be required if the "Have a test case?" checkbox is checked, but the value of the "Have a test case?" checkbox is not actually saved by the application; instead, whether the user is providing a test case is inferred by whether a non-empty test case file was uploaded. |
| matchesField | Tests whether the value for this field matches the value of some other field. The field to compare against is specified via the `otherField` property on the validator object (should be set to a field name).

See ${isc.DocUtils.linkForExampleId('matchValue')}. |
| equals | Tests whether the value for this field matches some value specified via `value`. |
| notEqual | Tests whether the value for this field does not match some value specified via `value`. |
| isOneOf | Tests whether the value for this field matches any value from an arbitrary list of acceptable values. The set of acceptable values is specified via the `list` property on the validator, which should be set to an array of values. If validator.list is not supplied, the valueMap for the field will be used. If there is no valueMap, not providing validator.list is an error. |
| inSet | Tests whether the value for this field matches any value from an arbitrary list of acceptable values. The set of acceptable values is specified via the `list` property on the validator, which should be set to an array of values. If validator.list is not supplied, the valueMap for the field will be used. If there is no valueMap, not providing validator.list is an error. |
| notInSet | Tests whether the value for this field does not match any value from an arbitrary list of unacceptable values. The set of unacceptable values is specified via the `list` property on the validator, which should be set to an array of values. Not providing validator.list is an error. |
| integerRange | Tests whether the value for this field is a whole number within the range specified. The `max` and `min` properties on the validator are used to determine the acceptable range, inclusive. To specify the range as exclusive of the min/mix values, set `exclusive` to `true`.

See ${isc.DocUtils.linkForExampleId('validationBuiltins')}. |
| lengthRange | This validator type applies to string values only. If the value is a string value validation will fail if the string's length falls outside the range specified by `validator.max` and `validator.min`.

Note that non-string values will always pass validation by this validator type.

Note that the `errorMessage` for this validator will be evaluated as a dynamicString - text within `${...}` will be evaluated as JS code when the message is displayed, with `max` and `min` available as variables mapped to `validator.max` and `validator.min`. |
| contains | Determine whether a string value contains some substring specified via `validator.substring`. |
| doesntContain | Determine whether a string value does 
#### not
 contain some substring specified via `validator.substring`. |
| substringCount | Determine whether a string value contains some substring multiple times. The substring to check for is specified via `validator.substring`. The `validator.operator` property allows you to specify how to test the number of substring occurrences. Valid values for this property are `==`, `!=`, `<`, `<=`, `>`, `>=`.

The number of matches to check for is specified via `validator.count`. |
| regexp | `regexp` type validators will determine whether the value specified matches a given regular expression. The expression should be specified on the `validator` object as the `expression` property.

See ${isc.DocUtils.linkForExampleId('formsRegularExpression')}. |
| mask | Validate against a regular expression mask, specified as `validator.mask`. If validation is successful a transformation can also be specified via the `validator.transformTo` property. This should be set to a string in the standard format for string replacement via the native JavaScript `replace()` method.

See ${isc.DocUtils.linkForExampleId('formsValueTransform')}. |
| dateRange | Tests whether the value for a date field is within the range specified. Range is inclusive, and is specified via `validator.min` and `validator.max`, which should be specified in [XML Schema date format](http://www.w3.org/TR/xmlschema-2/#dateTime) or as a live JavaScript Date object (for client-only validators only). To specify the range as exclusive of the min/mix values, set `exclusive` to `true`.

Note that the `errorMessage` for this validator will be evaluated as a dynamicString - text within `${...}` will be evaluated as JS code when the message is displayed, with `max` and `min` available as variables mapped to `validator.max` and `validator.min`. |
| floatLimit | Validate a field as a valid floating point value within a value range. Range is specified via `validator.min` and `validator.max`. Also checks precision, specified as number of decimal places in `validator.precision`. If `validator.roundToPrecision` is set a value that doesn't match the specified number of decimal places will be rounded to the nearest value that does.

For backwards compatibility only. Use "floatRange" and/or "floatPrecision" instead. |
| floatRange | Tests whether the value for this field is a floating point number within the range specified. The `max` and `min` properties on the validator are used to determine the acceptable range, inclusive. To specify the range as exclusive of the min/mix values, set `exclusive` to `true`.

Note that the `errorMessage` for this validator will be evaluated as a dynamicString - text within `${...}` will be evaluated as JS code when the message is displayed, with `max` and `min` available as variables mapped to `validator.max` and `validator.min`. |
| floatPrecision | Tests whether the value for this field is a floating point number with the appropriate number of decimal places - specified in `validator.precision` If the value is of higher precision and `validator.roundToPrecision` is specified, the value will be rounded to the specified number of decimal places and validation will pass, otherwise validation will fail. |
| required | A non-empty value is required for this field to pass validation.

In the case of a "binary" field, a non-empty file must be uploaded. |
| isUnique | Returns true if the value for this field is unique. The uniqueness check is performed across the whole DataSource unless you specify property `validator.criteriaFields` as a comma-separated string of field names; in that case, the uniqueness check is done in the context of those extra criteria, allowing you to check, for example, whether an employee number is unique for the department and location found on the record being validated. By default the uniqueness check is not case sensitive but this can be controlled through the \[caseSensitive\](#attr-validatorcasesensitive) attribute. You can specify the \[operation\](#attr-datasourceoperationbindings) to use for the uniqueness check with the \[operationId\](#attr-validatoroperationid) attribute.

Validators of this type have \[requiresServer\](#attr-validatordefinitionrequiresserver) set to `true` and do not run on the client, unless all of the following are true:

*   The validation is run in the context of a DataBoundComponent or ValuesManager bound to some DataSource.
*   The DataSource is either clientOnly:true or cacheAllData: true and all data is loaded
*   The item is made available to the validator. Note that the item is not be available during a save performed without a form (eg programmatic save), or if the field is not available in the form.

Note when isUnique validator is executed as part of validation process during update operation, it will perform uniqueness check only for single row updates. If update targets \[multiple records\](#attr-operationbindingallowmultiupdate), then isUnique validator will be skipped. If uniqueness check is needed when updating multiple records, consider using \[custom DMI\](#group-dmioverview) approach to add this check manually.

See ${isc.DocUtils.linkForExampleId('uniqueCheckValidation')}. |
| hasRelatedRecord | Returns true if the record implied by a relation exists. The relation can be derived automatically from the \[attr:DataSourceField.foreignKey\](#attr-datasourcefieldforeignkey) attribute of the field being validated, or you can specify it manually via `validator.relatedDataSource` and `validator.relatedField`.

You can specify at DataSource level that this validator should be automatically applied to all fields that specify a \[foreignKey\](#attr-datasourcefieldforeignkey) - see \[attr:DataSource.validateRelatedRecords\](#attr-datasourcevalidaterelatedrecords).

By default the uniqueness check is not case sensitive but this can be controlled through the \[caseSensitive\](#attr-validatorcasesensitive) attribute.

Validators of this type have \[requiresServer\](#attr-validatordefinitionrequiresserver) set to `true` and do not run on the client.

Note that this validation is generally unnecessary for data coming from a UI. The typical UI uses a \[class:SelectItem\](#class-selectitem) or \[class:ComboBoxItem\](#class-comboboxitem) with an \[optionDataSource\](#attr-formitemoptiondatasource) for user entry, such that the user can't accidentally enter a related record if that doesn't exist, and a typical SQL schema will include constraints that prevent a bad insert if the user attempts to circumvent the UI. The primary purpose of declaring this validation explicitly is to provide clear, friendly error messages for use cases such as \[class:BatchUploader\](#class-batchuploader), where values aren't individually chosen by the user. See also the example ${isc.DocUtils.linkForExampleId('hasRelatedValidation', 'Related Records')}. |
| maxFileSize | This validator type is not for direct usage, instead \[attr:DataSourceField.maxFileSize\](#attr-datasourcefieldmaxfilesize) can be set and `maxFileSize` validator will be added automatically. Use \[classAttr:DataSource.maxFileSizeExceededMessage\](#classattr-datasourcemaxfilesizeexceededmessage) to customize validation error message.

In supported browsers (Internet Explorer 10+, Chrome, Firefox, Safari 6+, Opera 11.1+), returns `true` if the file(s) selected by the user are not larger than the field's \[attr:DataSourceField.maxFileSize\](#attr-datasourcefieldmaxfilesize). If not supported by the browser, the validator will always return `true`.

Note that server-side enforcement of the `maxFileSize` is always required because the user's browser might not support client-side file size checks. Also, any client-side check can be bypassed by a malicious user. |
| custom | Custom client-side validator. \[attr:Validator.condition\](#attr-validatorcondition) will be called to verify data. |
| serverCustom | Custom server-side validator that either evaluates the Velocity expression provided in \[serverCondition\](#attr-validatorservercondition) (see ${isc.DocUtils.linkForExampleId('velocityValidation')}) or makes DMI call to \[serverObject\](#attr-validatorserverobject) to evaluate condition (see ${isc.DocUtils.linkForExampleId('dmiValidation')}).

Validators of this type have \[requiresServer\](#attr-validatordefinitionrequiresserver) set to `true` and do not run on the client. |

---
## Attr: Canvas.proportionalResizing

### Description
If \[attr:Canvas.canDragResize\](#attr-canvascandragresize) is true, this property specifies the conditions for when proportional resizing is used. The default is "none" , which means that proportional resizing is disabled.

### Groups

- dragdrop

### See Also

- [Canvas.proportionalResizeModifiers](#attr-canvasproportionalresizemodifiers)

**Flags**: IR

---
## Attr: ResultSet.initialData

### Description
Initial set of data for the ResultSet.

This data will be treated exactly as though it were the data returned from the ResultSet's first server fetch.

By default, `initialData` will be considered a complete response (all rows that match the \[type:Criteria\](#type-criteria) which the ResultSet was initialized with).

Set \[attr:ResultSet.initialLength\](#attr-resultsetinitiallength) to treat `initialData` as a partial response, equivalent to receiving a \[class:DSResponse\](#class-dsresponse) with `startRow:0`, `endRow:initialData.length` and `totalRows:initialLength`. Normal data paging will then occur if data is requested for row indices not filled via `initialData`.

`initialData` may be provided as a "sparse" array, that is, slots may be left null indicating rows that have not been loaded. In this way you can create a ResultSet that is missing rows at the beginning of the dataset, but has loaded rows toward the end, so that you can create a component that is scrolled to a particular position of a dataset without loading rows at the beginning.

To keep the logic simple and support partial `initialData`, the data is assumed to be already sorted and filtered according to the \[attr:ResultSet.sortSpecifiers\](#attr-resultsetsortspecifiers) and \[attr:ResultSet.criteria\](#attr-resultsetcriteria) supplied to the ResultSet, since otherwise, for partial `initialData`, sorting or filtering would immediately cause the data to be discarded.

If `initialData` is complete and needs to be sorted or filtered, then don't pass the \[attr:ResultSet.sortSpecifiers\](#attr-resultsetsortspecifiers) or \[attr:ResultSet.criteria\](#attr-resultsetcriteria), respectively, when creating the ResultSet. Instead, call \[method:ResultSet.setCriteria\](#method-resultsetsetcriteria) or \[method:ResultSet.setSort\](#method-resultsetsetsort), respectively, on the instance afterwards.

### Groups

- fetching
- cacheSync

### See Also

- [ResultSet.fetchMode](#attr-resultsetfetchmode)
- [ResultSet.useClientFiltering](#attr-resultsetuseclientfiltering)

**Flags**: IA

---
## Attr: ListGrid.rangeRowCountFormat

### Description
Format for the string returned from \[method:ListGrid.getFormattedRowCount\](#method-listgridgetformattedrowcount) when \[row count status\](#method-listgridgetrowcountstatus) is `"range"`.

The following variables are available for evaluation within this string:

*   `minRowCount`: the lower bound of this row count value from \[getRowCountRange()\[0\]\](#method-listgridgetrowcountrange), as a \[locale-formatted number\](#classmethod-numberutiltolocalizedstring).
*   `minRowCount`: the upper bound of this row count value from \[getRowCountRange()\[1\]\](#method-listgridgetrowcountrange), as a \[locale-formatted number\](#classmethod-numberutiltolocalizedstring).

### Groups

- rowRangeDisplay

**Flags**: IRW

---
## Attr: SpacerItem.showTitle

### Description
we never show a separate title cell for spacers

### Groups

- appearance

**Flags**: IRW

---
## Type: TEXTAREA_WRAP

### Description
—

### Values

| Value | Description |
|-------|-------------|
| TextAreaItem.OFF | don't allow wrapping at all |
| TextAreaItem.SOFT | when the entered text reaches the edge of the text area, wrap visibly but don't include line breaks in the textarea value |
| TextAreaItem.HARD | when the entered text reaches the edge of the text area, insert a line break |

---
## Attr: MockDataSource.mockData

### Description
Data intended for a \[class:ListGrid\](#class-listgrid) or \[class:TreeGrid\](#class-treegrid), expressed in a simple text format popularized by mockup tools such as [balsamiq](http://balsamiq.com) and now commonly supported in a variety of mockup tools.

Balsamiq publishes documentation of the grid format [here](https://docs.balsamiq.com/cloud/editing-controls/#the-data-grid-table-control), with a simple example of using tree-specific formatting [here](https://docs.balsamiq.com/cloud/editing-controls/#the-tree-pane).

MockData can also be provided as XML, CSV or JSON text by setting \[type:MockDataFormat\](#type-mockdataformat) to the correct format.

An alternative format of data consisting of an array of \[Records\](#object-record) can also be provided. In this case the records are converted to "grid" \[format\](#type-mockdatatype).

**Flags**: IR

---
## Attr: Canvas.autoShowParent

### Description
If set to true, the widget's parent (if any) will automatically be shown whenever the widget is shown.

### Groups

- appearance

**Flags**: IRWA

---
## Method: Process.setTaskOutput

### Description
Sets the task output of `task` in the \[process state\](#type-state) so it can be used by later tasks with \[method:Process.getLastTaskOutput\](#method-processgetlasttaskoutput) or more commonly with a \[type:TaskInputExpression\](#type-taskinputexpression) property.

If the task sets `bindOutput` the output value is also written into that \[process state\](#attr-processstate) variable.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| task | [ProcessElement](#type-processelement) | false | — | the workflow task setting the output (i.e. this) |
| value | [Any](#type-any) | false | — | the output value for task |

---
## Attr: HiliteRule.hiliteForm

### Description
AutoChild \[class:DynamicForm\](#class-dynamicform) displaying the \[formItems\](#class-formitem) used to specify the hiliting properties of this rule.

This component is an \[type:AutoChild\](#type-autochild) and as such may be customized via `hiliteRule.hiliteFormProperties`.

**Flags**: IR

---
## Method: ValuesManager.isNewRecord

### Description
Returns true if \[attr:ValuesManager.saveOperationType\](#attr-valuesmanagersaveoperationtype) is currently "add". See \[attr:ValuesManager.saveOperationType\](#attr-valuesmanagersaveoperationtype).

### Returns

`[Boolean](#type-boolean)` — whether this form will use an "add" operation when saving

---
## Attr: TreeGrid.customIconDropProperty

### Description
This property allows the developer to rename the \[default node.showDropIcon\](#attr-treenodeshowdropicon) property.

### Groups

- treeIcons

### See Also

- [TreeGrid.customIconProperty](#attr-treegridcustomiconproperty)
- [TreeGrid.showCustomIconDrop](#attr-treegridshowcustomicondrop)

**Flags**: IRWA

---
## StaticMethod: Date.setFirstDayOfWeek

### Description
Sets the global attribute that dictates which day should be treated as the first day of the week in calendars and date calculations. The parameter is expected to be an integer value between 0 (Sunday) and 6 (Saturday).

The default value is picked up from the current locale.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| firstDayOfWeek | [int](#type-int) | false | — | the number of the day to use as the first day of the week |

**Deprecated**

---
## Attr: DateItem.monthSelector

### Description
\[class:SelectItem\](#class-selectitem) for picking a month.

To control which selectors are visible and in what order, use \[attr:DateItem.selectorFormat\](#attr-dateitemselectorformat).

### Groups

- dateItemAppearance

### See Also

- [DateItem.selectorFormat](#attr-dateitemselectorformat)

**Flags**: R

---
## Attr: ComboBoxItem.pendingTextBoxStyle

### Description
Optional "pending" style for this item's text box.

If \[attr:ComboBoxItem.addUnknownValues\](#attr-comboboxitemaddunknownvalues) is false, when the user modifies the value displayed in the combobox item text box, the underlying data value (as returned from item.getValue()) is not immediately updated - instead the value is used to filter the set of results displayed in the comboBoxItem pickList.

While the comboBoxItem is in this pending state (where the result of getEnteredValue() will not necessarily match the display value for whatever is returned by getValue()), the pendingTextBoxStyle may be applied to the text box for the item.

When the element value is updated to display the actual value for the item (typically due to the user selecting a value from the pickList), the standard \[attr:TextItem.textBoxStyle\](#attr-textitemtextboxstyle) will be reapplied.

May be left unset in which case the standard text box style is always applied. Has no effect if \[attr:ComboBoxItem.addUnknownValues\](#attr-comboboxitemaddunknownvalues) is true.

**Flags**: IRW

---
## Attr: TimeItem.ampmItem

### Description
Select item to hold the AM/PM value for the timeItem when \[useTextField\](#attr-timeitemusetextfield) is false.

**Flags**: R

---
## Attr: SavedSearchItem.hint

### Description
Text shown inside the field that serves as an indicator of what this field is for.

### Groups

- i18nMessages

**Flags**: IR

---
## Method: FormItem.setIconShowOnFocus

### Description
Sets \[attr:FormItemIcon.showOnFocus\](#attr-formitemiconshowonfocus) for the supplied icon, and causes that icon's visibility to be updated and the item redrawn as appropriate.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| icon | [Identifier](#type-identifier) | false | — | \[name\](#attr-formitemiconname) of the icon to update |
| showOnFocus | [Boolean](#type-boolean) | false | — | new value of \[attr:FormItemIcon.showOnFocus\](#attr-formitemiconshowonfocus) |

### Groups

- formIcons

---
## Attr: ImgButton.iconWidth

### Description
Width in pixels of the icon image.

If unset, defaults to \[iconSize\](#attr-statefulcanvasiconsize).

### Groups

- buttonIcon

**Flags**: IR

---
## Object: AnimateShowEffect

### Description
Configuration object for effect to apply during an animated show or hide.

---
## Attr: ListGrid.rowSpanSelectionMode

### Description
Chooses the selection mode when \[attr:ListGrid.useRowSpanStyling\](#attr-listgriduserowspanstyling) is enabled. See \[type:RowSpanSelectionMode\](#type-rowspanselectionmode).

**Flags**: IR

---
## Attr: EventCanvas.showContextButton

### Description
When set to true, shows a \[small icon\](#attr-calendareventcanvascontextbutton) in the top corner of an EventCanvas, beside the \[close-icon\](#attr-calendareventcanvascontextbutton). When clicked, shows a \[context menu\](#method-calendargeteventcanvasmenuitems) containing items applicable to this canvas.

**Flags**: IRW

---
## Method: Sound.setSrc

### Description
Update the \[attr:Sound.src\](#attr-soundsrc) of this sound instance at runtime. Note that \[attr:Sound.autoLoad\](#attr-soundautoload) and \[attr:Sound.autoPlay\](#attr-soundautoplay) govern whether this media will be loaded or played immediately when the src value is changed.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| src | [String](#type-string)|[Array of String](#type-array-of-string) | false | — | URL of new audio file to be played by this sound instance. |

---
## Class: Facet

### Description
Facet definition object made use of by the \[CubeGrid\](#class-cubegrid) and \[FacetChart\](#class-facetchart) classes.

---
## Class: EdgedCanvas

### Description
EdgedCanvas acts as a decorative, image-based frame around another single Canvas.

### Groups

- imageEdges

---
## StaticMethod: Date.setFiscalCalendar

### Description
Sets the global fiscal calendar, which is used for all calls to getFiscalYear() / getFiscalWeek() if those methods aren't passed a fiscalCalander.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| fiscalCalendar | [FiscalCalendar](#type-fiscalcalendar) | false | — | the object representing the start month and date of the fiscal year in the current locale |

**Deprecated**

---
## Attr: Menu.target

### Description
Optional target canvas for this menu. Available as a parameter to dynamic menuItem configuration methods such as \[method:MenuItem.checkIf\](#method-menuitemcheckif).

Whenever a Menu is shown as a contextMenu by a widget due to \[attr:Canvas.contextMenu\](#attr-canvascontextmenu) being set, `menu.target` is automatically set to the widget that showed the contextMenu.

If this item has any \[submenus\](#attr-menuitemsubmenu) the `target` will be propagated down to these child menus.

**Flags**: IRW

---
## Method: DrawPane.getDrawingX

### Description
Returns the X coordinate in the \[drawing coordinate system\](#class-drawpane) of the last event. Note: If you need both the X and Y coordinates in the drawing coordinate system of the last event, it is more efficient to call \[getDrawingPoint()\](#method-drawpanegetdrawingpoint) instead.

See the documentation of \[getDrawingPoint()\](#method-drawpanegetdrawingpoint) for a clarifying example.

### Returns

`[int](#type-int)` — X coordinate in the drawing coordinate system of the last event.

**Flags**: A

---
## Attr: EventStreamEvent.deltaX

### Description
The \[horizontal scroll delta\](#classmethod-eventhandlergetwheeldeltax), present for \[wheel events\](#attr-eventstreamcapturewheelevents).

### See Also

- [EventStreamEvent.deltaY](#attr-eventstreameventdeltay)

**Flags**: R

---
## ClassAttr: DrawLabel.defaultSerifFont

### Description
This setting exists due to platform limitations in some versions of Internet Explorer where the browser does not recognize the five generic font families (`cursive`, `fantasy`, `monospace`, `sans-serif`, and `serif`) and instead uses a non-configurable, default font. This setting specifies a specific font to replace the `serif` keyword should a DrawLabel list it in its \[font family\](#attr-drawlabelfontfamily).

**Flags**: IRW

---
## Attr: DateChooser.navigationButtonHeight

### Description
Height of buttons in the \[navigation area\](#attr-datechoosernavigationlayout), used for navigating the \[calendar view\](#attr-datechooserdategrid). If unset, the default, buttons are sized by settings applied by the current skin.

If this attribute is set to a value greater than \[attr:DateChooser.navigationLayoutHeight\](#attr-datechoosernavigationlayoutheight), it will cause the layout to expand to match the button height.

**Flags**: IR

---
## Attr: PrintWindow.printButtonTitle

### Description
Title for the print button

**Flags**: IRW

---
## Attr: AdaptiveMenu.partialInlining

### Description
If there is not enough space to show the full set of items as buttons inline, how should the Adaptive menu behave?  
If `showPartialInlining` is true, the menu will render as many items as inline buttons as can be shown in the available space, plus the menu button to access the remaining items.  
If false, it will show just the menu button.

If there is enough space to show the full set of items inline they will be shown inline regardless of this property.

**Flags**: IRW

---
## Attr: ResultSet.reapplyUnchangedLocalFilter

### Description
To avoid needless work, the ResultSet by default doesn't refilter the data when methods such as \[method:ListGrid.fetchData\](#method-listgridfetchdata) or \[method:ListGrid.filterData\](#method-listgridfilterdata) are called with unchanged criteria. However, this property can be set true for backward compatibility to force refiltering if we're \[filtering locally\](#method-resultsetfilterlocaldata) and the criteria haven't changed. but are narrower than the criteria used to fetch the current cache.

Going forward, we may deprecate this property, so you should move to approach that doesn't require such notification in the case of unchanged criteria.

### See Also

- [ResultSet.willFetchData](#method-resultsetwillfetchdata)

**Flags**: IRWA

---
## Attr: Mail.messageTemplate

### Description
The text that will form the body of the mail message. Like all other `String` properties of `Mail`, you can use Velocity substitution variables in this property.

You must specify either this property or \[templateFile\](#attr-mailtemplatefile), but clearly it makes no sense to specify them both.

### Groups

- mail

**Flags**: IR

---
## ClassAttr: FieldPickerField.alignTitle

### Description
The title displayed for the align property

### Groups

- i18nMessages

**Flags**: IR

---
## Method: Calendar.getWorkdayEnd

### Description
Returns the end of the working day on the passed date. By default, this method returns the value of \[workdayEnd\](#attr-calendarworkdayend).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| date | [Date](#type-date) | false | — | a Date instance |
| laneName | [String](#type-string) | true | — | the name of the relevant lane - only passed for dayView with showDayLanes: true |

### Returns

`[String](#type-string)` — any parsable time-string

---
## Attr: FilterBuilder.operatorPickerProperties

### Description
Properties to combine with the \[attr:FilterBuilder.operatorPicker\](#attr-filterbuilderoperatorpicker) autoChild FormItem.

**Flags**: IR

---
## Class: ScreenLoaderEditProxy

### Description
\[class:EditProxy\](#class-editproxy) that handles \[class:ScreenLoader\](#class-screenloader) objects when editMode is enabled.

### Groups

- devTools

---
## ClassAttr: Operators.iEqualsTitle

### Description
Title for the "iEquals" operator

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: FacetChart.valueAxisLabelProperties

### Description
Properties for labels of value axis.

### Groups

- labelsAndTitles

**Flags**: IRW

---
## Method: List.indexOf

### Description
Return the position in the list of the first instance of the specified object.

If pos is specified, starts looking after that position.

Returns -1 if not found.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| obj | [Any](#type-any) | false | — | object to look for |
| pos | [number](#type-number) | true | — | earliest index to consider |
| endPos | [number](#type-number) | true | — | last index to consider |

### Returns

`[number](#type-number)` — position of the item, if found, -1 if not found

### Groups

- access

---
## Attr: AdvancedCriterionSubquery.queryOutput

### Description
The name of the field that will be used as the output of this query. Only useful if your subquery returns more than one field, and optional even in that case. See the \[Subqueries overview\](#object-advancedcriterionsubquery) for more details

### Groups

- advancedFilter

**Flags**: IR

---
## Attr: Hilite.fieldName

### Description
Name of the field, or array of fieldNames, this hilite should be applied to.

If unset, hilite is applied to every field of the record.

### Groups

- hiliting

**Flags**: IR

---
## Attr: Slider.flipValues

### Description
Specifies whether the value range of the slider should be flipped so that values increase as the thumb is moved down (for a \[vertical\](#attr-slidervertical) slider) or to the left (for a horizontal slider).

**Flags**: IRW

---
## Method: ValuesManager.getValuesAsCriteria

### Description
Retrieves the combined \[criteria values\](#method-dynamicformgetvaluesascriteria) for all member forms.

As with the DynamicForm getValuesAsCriteria, this method may return \[object:AdvancedCriteria\](#object-advancedcriteria) or simple \[type:Criteria\](#type-criteria) depending on whether the `advanced` parameter was passed, whether the \[attr:ValuesManager.operator\](#attr-valuesmanageroperator) is set to `"or"` rather than `"and"`, and whether any member forms return \[object:AdvancedCriteria\](#object-advancedcriteria).

Note that developers can also use \[classMethod:DataSource.combineCriteria\](#classmethod-datasourcecombinecriteria) to combine sub-criteria from various sources, including member forms of a ValuesManager, into a combined criteria object.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| advanced | [boolean](#type-boolean) | false | — | if true, return an \[object:AdvancedCriteria\](#object-advancedcriteria) object even if the form item values could be represented in a simple \[object:Criterion\](#object-criterion) object. |
| textMatchStyle | [TextMatchStyle](#type-textmatchstyle) | true | — | This parameter may be passed to indicate whether the criteria are to be applied to a substring match (filter) or exact match (fetch). When advanced criteria are returned this parameter will cause the appropriate `operator` to be generated for individual fields' criterion clauses. |

### Returns

`[Criteria](#type-criteria)|[AdvancedCriteria](#type-advancedcriteria)` — a \[type:Criteria\](#type-criteria) object, or \[object:AdvancedCriteria\](#object-advancedcriteria)

### Groups

- criteriaEditing

---
## Attr: SpinnerItem.mask

### Description
Not applicable to a SpinnerItem.

**Flags**: IRWA

---
## Attr: ListGrid.escapeKeyEditAction

### Description
What to do when a user hits escape while editing a cell:

*   "cancel": close the editor and discard the current set of edit values
*   "done": just close the editor (the edit is complete, but the edited values are retained).

Note that if \[attr:ListGrid.autoSaveEdits\](#attr-listgridautosaveedits) is true, this may cause a save of the current edit values

### Groups

- editing

**Flags**: IRW

---
## Group: creation

### Description
—

---
## Attr: MetricSettings.logScale

### Description
Whether to use logarithmic scaling for values.

Logarithmic scale charts show an equivalent percentage increase as equivalent distance on the chart. That is, 10 and 100 are the same distance apart as 100 and 1000 (each being a 10 times or 1000% increase).

**Flags**: IR

---
## Method: EditContext.getRootEditNode

### Description
Returns the root \[object:EditNode\](#object-editnode) of the EditContext typically created from \[attr:EditContext.rootComponent\](#attr-editcontextrootcomponent).

### Returns

`[EditNode](#type-editnode)` — the root EditNode

---
## Type: AutoSelectionModel

### Description
Selection model for \[class:CubeGrid\](#class-cubegrid) indicating which cells in the body should be selected when row or column headers are selected.

### Values

| Value | Description |
|-------|-------------|
| "both" | Rows and Columns will be selected on header selection |
| "rows" | Rows will be selected on row-header selection |
| "cols" | Columns will be selected on column-header selection |
| "none" | Selecting row or column headers will not select cells in the body. |

---
## Group: facetLayout

### Description
—

---
## ClassMethod: Page.isAddVersionToSkinCSS

### Description
Returns true if add version to skin CSS is currently turned on.

### Returns

`[Boolean](#type-boolean)` — true == add version to skin CSS is turned on

### Groups

- skins
- files

---
## Attr: DrawItem.resizeViaLocalTransformOnly

### Description
If this DrawItem is showing "resize" \[control knobs\](#attr-drawitemknobs), should resizing the shape solely update the local transform (for example, the DrawItem's \[scale\](#attr-drawitemscale) or \[translation\](#attr-drawitemtranslate))?.

The default is `false`, which means that the DrawItem is allowed to modify its shape properties in order to fit within a given width and height. Some examples:

*   A \[DrawOval\](#class-drawoval) might decrease its \[radius\](#attr-drawovalradius) when resized to a smaller size.
*   A \[DrawPath\](#class-drawpath) might change its \[points\](#attr-drawpathpoints) to lengthen all line segments in the path by some proportion so that it fits into a larger size.

This approach allows a DrawItem to maintain the same \[line width\](#attr-drawitemlinewidth) even as it is being resized.

If this property is set to `true` then all visual aspects of the DrawItem, including the line width and the fill, will be magnified or reduced during resizes as if the DrawItem were placed under a lens.

**Flags**: IR

---
## Attr: DrawItem.titleAutoFitRotationMode

### Description
Whether to rotate the \[attr:DrawItem.titleLabel\](#attr-drawitemtitlelabel) 90 degrees clockwise while trying to maximize its size in accordance with \[attr:DrawItem.titleAutoFit\](#attr-drawitemtitleautofit). If automatic rotation is specified, the default, the label will be rotated if and only if it allows the label to become larger.

### See Also

- [DrawItem.titleLabel](#attr-drawitemtitlelabel)
- [DrawItem.titleAutoFit](#attr-drawitemtitleautofit)

**Flags**: IR

---
## Attr: DSRequest.additionalOutputs

### Description
For fetch, add or update operation, an optional comma separated list of fields to fetch from another, related DataSource.

Fields should be specified in the format `"localFieldName!relatedDataSourceID.relatedDataSourceFieldName"`. where `_relatedDataSourceID_` is the ID of the related dataSource, and `_relatedDataSourceFieldName_` is the field for which you want to fetch related values. The returned field values will be stored on the data returned to the client under the specified `_localFieldName_`. Note that this will be applied in addition to any specified \[attr:DSRequest.outputs\](#attr-dsrequestoutputs).

Note that as with \[attr:DataSourceField.includeFrom\](#attr-datasourcefieldincludefrom), the related dataSource must be linked to the primary datasource via a foreignKey relationship.

Note additionalOutputs sent in request from the browser can be completely disabled in \[server.properties\](#group-server-properties) by setting `datasource.allowClientAdditionalOutputs`:

     datasource.allowClientAdditionalOutputs: false
 

In this case \[attr:DSRequest.additionalOutputs\](#attr-dsrequestadditionaloutputs) sent from the browser will be cleared before executing request. Note that programatically configured additionalOutputs are always allowed, but you can't modify them from within a DMI method, so the only way to execute a request with additionalOutputs that differ from what was sent by the client is to create a new DSRequest

**Flags**: IRA

---
## Class: AutoFitTextAreaItem

### Description
Class for editable multi-line text areas (uses HTML `<TEXTAREA>` object) automatically expands to accommodate its content

---
## Method: StatefulCanvas.getStateSuffix

### Description
Returns the suffix that will be appended to the \[attr:StatefulCanvas.baseStyle\](#attr-statefulcanvasbasestyle) as the component changes \[attr:StatefulCanvas.state\](#attr-statefulcanvasstate) and/or is selected / focused.

Note that suffixes will only be included if the relevant `show_[StateName]_` attributes (EG \[attr:StatefulCanvas.showRollOver\](#attr-statefulcanvasshowrollover), \[attr:StatefulCanvas.showFocused\](#attr-statefulcanvasshowfocused), etc) are set to true.

The following table lists out the standard set of suffixes which may be applied to the base style:

#### CSS Class Applied

#### Description

`_baseStyle_`

Default css style

`_baseStyle_+Selected`

Applied when \[attr:StatefulCanvas.selected\](#attr-statefulcanvasselected) is set to true.

`_baseStyle_+Focused`

Applied when the component has keyboard focus, if \[attr:StatefulCanvas.showFocused\](#attr-statefulcanvasshowfocused) is true, and \[attr:StatefulCanvas.showFocusedAsOver\](#attr-statefulcanvasshowfocusedasover) is not true.

`_baseStyle_+Over`

Applied when \[attr:StatefulCanvas.showRollOver\](#attr-statefulcanvasshowrollover) is set to true and either the user rolls over the component or \[attr:StatefulCanvas.showFocusedAsOver\](#attr-statefulcanvasshowfocusedasover) is true and the component has keyboard focus.

`_baseStyle_+Down`

Applied when the user presses the mouse button on the component if \[attr:StatefulCanvas.showDown\](#attr-statefulcanvasshowdown) is set to true

`_baseStyle_+Disabled`

Applied when the component is \[disabled\](#attr-canvasdisabled) if \[attr:StatefulCanvas.showDisabled\](#attr-statefulcanvasshowdisabled) is true.

_Combined styles_

`_baseStyle_+SelectedFocused`

Combined Selected and focused styling

`_baseStyle_+SelectedOver`

Combined Selected and rollOver styling

`_baseStyle_+FocusedOver`

Combined Focused and rollOver styling

`_baseStyle_+SelectedFocusedOver`

Combined Selected, Focused and rollOver styling

`_baseStyle_+SelectedDown`

Combined Selected and mouse-down styling

`_baseStyle_+FocusedDown`

Combined Focused and mouse-down styling

`_baseStyle_+SelectedFocusedDown`

Combined Selected, Focused and mouse-down styling

`_baseStyle_+SelectedDisabled`

Combined Selected and Disabled styling

### Returns

`[String](#type-string)` — suffix to be appended to the baseStyle

---
## Attr: UploadItem.textBoxStyle

### Description
Base CSS class name for this `UploadItem`'s native file input element.

Note that the customization via CSS of a native file input element allowable by the browser varies widely; in some browsers on certain platforms, it may be possible to customize certain CSS properties, but not in others; or, it may be that the CSS property (e.g. border) is applied differently in some browsers.

If the textBoxStyle is changed at runtime, \[method:FormItem.updateState\](#method-formitemupdatestate) must be called to update the visual state. However, calling updateState() will clear any file selected by the user to be uploaded.

### Groups

- formItemStyling

### See Also

- [FormItem.cellStyle](#attr-formitemcellstyle)

**Flags**: IRW

---
## Attr: Tour.tourStepWizardRecordStepHeaderPrompt

### Description
Prompt for the _Record Step_ window header in the TourStep Wizard.

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: FieldPickerWindow.title

### Description
—

### Groups

- i18nMessages

**Flags**: IR

---
## Method: EditContext.setNodeProperties

### Description
Update an editNode's serializable "defaults" with the supplied properties. If you wish to remove a property from the defaults (rather than setting it to null), then use \[removeNodeProperties()\](#method-editcontextremovenodeproperties) instead.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| editNode | [EditNode](#type-editnode) | false | — | the editNode to update |
| properties | [Canvas Properties](#type-canvas-properties) | false | — | the properties to apply |
| skipLiveObjectUpdate | [Boolean](#type-boolean) | true | — | whether to skip updating the \[liveObject\](#attr-editnodeliveobject), e.g. if you have already updated the liveObject |

### See Also

- [EditContext.removeNodeProperties](#method-editcontextremovenodeproperties)
- [EditContext.getNodeProperty](#method-editcontextgetnodeproperty)

---
## Attr: ResultTree.matchingLeafJoinDepth

### Description
This property allows you to specify the number of ancestor levels SmartClient attempts to retrieve with each request, when using the built-in support for \[keepParentsOnFilter\](#attr-resulttreekeepparentsonfilter) on \[loadDataOnDemand\](#attr-resulttreeloaddataondemand) trees. See the `keepParentsOnFilter` overview for details.

**Flags**: IRW

---
## ClassAttr: AsyncUtil.asyncCanceledMessageGeneric

### Description
A message string to use when displaying an \[object:AsyncOperationResult\](#object-asyncoperationresult) of \[type\](#attr-asyncoperationresulttype) "canceled" to the user, and no \[attr:AsyncOperationResult.cancellationReason\](#attr-asyncoperationresultcancellationreason) is available.

\[classAttr:AsyncUtil.asyncCanceledMessage\](#classattr-asyncutilasynccanceledmessage) is used when a cancellationReason is available.

### Groups

- i18nMessages

### See Also

- [AsyncUtil.getAsyncMessage](#classmethod-asyncutilgetasyncmessage)

**Flags**: RW

---
## Method: RemoteWindow.isShowing

### Description
Checks whether this RemoteWindow is showing.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| callback | [RemoteWindowBooleanCallback](#type-remotewindowbooleancallback) | false | — | callback to receive output |

---
## Attr: Canvas.edgeSize

### Description
Size in pixels for corners and edges

### Groups

- imageEdges

**Flags**: IR

---
## Attr: Canvas.htmlElement

### Description
If specified as a pointer to an HTML element present in the DOM, this canvas will be rendered inside that element on \[draw()\](#method-canvasdraw). If provided as a String, the String will be replaced by a DOM node as returned from document.getElementById(htmlElement) on initialization.

_NOTES:_  
This feature is intended for integration with other JavaScript frameworks and legacy page architectures only; the native browser's reaction to DOM insertion is unspecified and unsupported. For consistent cross-browser layout and positioning semantics, use Canvas parents (especially Layouts) and use absolute positioning at top level.

In some cases, the target element may need a specified height to be rendered correctly. In this cases, you can expect to find a message like the following in the JavaScript console: "isc\_DataView\_0:can't resize to height: 0; clamping to 1 \[enable 'sizing' log for stack trace\]"

Persistence of htmlElement: If \[attr:Canvas.htmlPosition\](#attr-canvashtmlposition) is set to `"replace"` the htmlElement will be removed from the DOM when the canvas is drawn - therefore the htmlElement attribute will be cleared at this time. Otherwise if a Canvas is clear()d and then draw()n again it will be rendered inside the same htmlElement.  
If a Canvas is added as a child to Canvas parent, its htmlElement will be dropped.

\[attr:Canvas.position\](#attr-canvasposition) should typically be set to `"relative"` if the widget is to be rendered inline within a standard page.

### Groups

- htmlElement
- positioning

**Flags**: IRWA

---
## ClassAttr: Canvas.defaultPageSpace

### Description
A fixed number of pixels at the top of the page in which components will not be placed. This is overridable per-instance via the \[attr:Canvas.leavePageSpace\](#attr-canvasleavepagespace) attribute. Essentially, the effect is that all top-level components are shifted down this number of pixels, and the page height is treated as this number of pixels _less_ than the real page height.

This attribute can be useful on certain mobile devices, when components should not be placed in a top portion of the screen. For example, on iOS devices in certain configurations, this can be set to 20 to avoid placing any component into the status bar area. Or, if using iOS 7.1's 'minimal-ui' viewport parameter, this can be set to 20 to avoid placing any component into the top 20px area of the screen, which if tapped on iPhone in landscape, causes Mobile Safari's address bar and tab bar to be shown.

This setting can be changed at runtime by calling \[classMethod:Canvas.setDefaultPageSpace\](#classmethod-canvassetdefaultpagespace).

**Note:** As documented by the \[Mobile Application Development\](#group-mobiledevelopment) page, when the SmartClient application is running in Mobile Safari on iPhone running iOS 7.1 or later, and neither the `isc_useDefaultViewport` nor the `isc_useMinimalUI` global is set to `false` when the framework is loaded, then the framework will automatically set the `defaultPageSpace` to 0 in portrait orientation, and to 20 in landscape orientation.

### Groups

- positioning

**Flags**: IRA

---
## ClassAttr: ListGrid.UP_ARROW_KEYPRESS

### Description
A declared value of the enum type \[EditCompletionEvent\](#type-editcompletionevent).

**Flags**: R

---
## Type: double

### Description
A decimal (or "floating point") number, for example, 5.5. May not be null.

---
## Attr: ValuesManager.updateOperation

### Description
\[operationId\](#attr-dsrequestoperationid) to use when performing update operations.

### Groups

- operations

**Flags**: IRW

---
## Method: FormItem.getVisibleWidth

### Description
Output the drawn width for this item in pixels. This method is only reliable after the item has been drawn into the page.

### Returns

`[Integer](#type-integer)` — width of the form item

### Groups

- sizing

**Flags**: A

---
## Attr: TileLayout.paddingAsLayoutMargin

### Description
If this widget has padding specified (as \[this.padding\](#attr-canvaspadding) or in the CSS style applied to this layout), should it show up as space outside the members, similar to layoutMargin?

If this setting is false, padding will not affect member positioning (as CSS padding normally does not affect absolutely positioned children). Leaving this setting true allows a designer to more effectively control layout purely from CSS.

Note that \[attr:Layout.layoutMargin\](#attr-layoutlayoutmargin) if specified, takes precedence over this value.

### Groups

- layoutMargin

**Flags**: IRWA

---
## Method: TileGrid.loadAllRecords

### Description
Loads all records that match this grid's current filter-criteria, optionally firing a callback when the data arrives.

If the length of the data is \[not known\](#method-resultsetlengthisknown), or is greater than the passed _maxRecords_, this call returns false. No fetch is issued and the _callback_, if passed, is not fired.

If all data is \[already loaded\](#method-resultsetallmatchingrowscached), no fetch is issued and this call returns true. The _callback_, if passed, will be fired, but its parameters will be null, since there was no fetch to provide the values from.

In all other cases, this call returns true and a fetch is issued for all necessary records. When the data arrives, the _callback_ is fired.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| maxRecords | [Integer](#type-integer) | true | — | optional maximum record count - if passed, no fetch takes place if maxRecords is below the known length of the data |
| callback | [DSCallback](#type-dscallback) | true | — | callback to fire if a fetch is issued - if all data was already loaded, the callback is fired with no parameters |

### Returns

`[Boolean](#type-boolean)` — true if a fetch was made or was not needed - false otherwise

### Groups

- dataBoundComponentMethods

---
## Attr: StyleGroup.settings

### Description
The array of \[settings\](#object-stylesetting) to make available for editing in this group.

**Flags**: IR

---
## Method: DataSource.xmlSerialize

### Description
Serialize a JavaScript object as XML.

The JavaScript Object passed to \[method:DataSource.xmlSerialize\](#method-datasourcexmlserialize) becomes an XML element named after the \[attr:DataSource.tagName\](#attr-datasourcetagname) (or \[attr:DataSource.ID\](#attr-datasourceid) if tagName is unset). Each property of the object becomes a subElement. For example, using a DataSource to serialize like this:

     var inputObject = {
        startRow : 5,
        endRow : 50,
        data : \[
           { field1 : "value1", field2: new Date() },
           { field1 : "value3", field2: null }
        \]
     };
     var myDS = isc.DataSource.create({ tagName:"DSRequest" });
     myDS.xmlSerialize(inputObject);
 

.. produces the following XML:

     <DSRequest>
         <startRow>5</startRow>
         <endRow>50</endRow>
         <data>
             <field1>value1</field1>
             <field2>2005-10-14T18:01:16</field2>
         </data>
         <data>
             <field1>value3</field1>
             <field2></field2>
         </data>
     </DSRequest>
 

Various properties on the DataSource and DataSourceField can affect how serialization is performed, see for example \[attr:DataSource.tagName\](#attr-datasourcetagname), \[attr:DataSource.schemaNamespace\](#attr-datasourceschemanamespace), \[attr:DataSourceField.xmlAttribute\](#attr-datasourcefieldxmlattribute), \[attr:DataSourceField.multiple\](#attr-datasourcefieldmultiple) and \[attr:DataSourceField.childTagName\](#attr-datasourcefieldchildtagname). By setting the \[type of a field\](#attr-datasourcefieldtype) to the ID of another DataSource which has further XML serialization settings, you can control serialization of nested structures.

If you are working with a WSDL-described web service, XML serialization is performed automatically by APIs like \[method:WebService.callOperation\](#method-webservicecalloperation) - you only need to know about serialization in order to understand how to put together JavaScript data that will fill in an XML message properly, and for simple messages, setting \[attr:DSRequest.useFlatFields\](#attr-dsrequestuseflatfields) makes that unnecessary as well.

#### Note:
 when trying to send data to a web service, it is best to avoid putting together any XML yourself, instead modify the JavaScript data being fed to SmartClient's SOAP engine. This is because the WSDL and SOAP rules for correctly namespacing and encoding Web Service messages are very complex and are subject to change with new versions of the web service you are contacting, whereas the data itself is easy to manipulate and less likely to change.

To troubleshoot message formation, you can set the log category "xmlSerialize" to `INFO` or `DEBUG` level in order to see diagnostics about XML message formation, and you can use the RPC tab in the Developer Console to see the actual messages being passed to web services.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| data | [Any](#type-any) | false | — | data to be serialized |
| flags | [SerializationContext](#type-serializationcontext) | false | — | options for the serialization engine |

### Returns

`[String](#type-string)` — data as serialized to XML

**Flags**: A

---
## Attr: SplitPane.detailToolStrip

### Description
Toolstrip servicing the \[detailPane\](#attr-splitpanedetailpane).

In \[deviceMode\](#attr-splitpanedevicemode) "desktop" and `deviceMode` "tablet", the `detailToolStrip` is shown _above_ the `detailPane`. In \[deviceMode\](#attr-splitpanedevicemode) "handset", the `detailToolStrip` is created **only** if \[detailToolButtons\](#attr-splitpanedetailtoolbuttons) are specified, and is placed _underneath_ the `detailPane`.

**Flags**: IR

---
## Attr: ListGrid.allowFilterOperators

### Description
Causes a menu item titled \["Filter using"\](#attr-listgridfilterusingtext) to appear in the \[headerContextMenu\](#attr-listgridshowheadercontextmenu) that allows the end user to pick an advanced \[search operator\](#type-operatorid) to use for this field.

Once an operator has been chosen, the active operator is indicated by an \[attr:ListGrid.operatorIcon\](#attr-listgridoperatoricon) placed within the field (you can alternatively cause the icon to \[always be present\](#attr-listgridalwaysshowoperatoricon)). The `operatorIcon` shows the same textual representation of the search operator as is used by the \[attr:FormItem.allowExpressions\](#attr-formitemallowexpressions) feature. Clicking on the icon provides a second way to modify the search operator.

This feature is enabled by default if \[method:DataSource.supportsAdvancedCriteria\](#method-datasourcesupportsadvancedcriteria) is true, for all fields where it is normally possible to filter by typing in a search string. This excludes field types such as "date" or "boolean" which show specialized filter controls. Use \[attr:ListGridField.allowFilterOperators\](#attr-listgridfieldallowfilteroperators) to disable this interface for individual fields, or set \[attr:DataSourceField.canFilter\](#attr-datasourcefieldcanfilter) to false to disallow filtering entirely for a field.

Note that this feature is similar to \[attr:ListGrid.allowFilterExpressions\](#attr-listgridallowfilterexpressions), which allows the end users to directly type in characters such as ">" to control filtering. `allowFilterOperators` is easier to use and more discoverable than `allowFilterExpressions`, and also avoids the drawback where special characters like ">" cannot be used in filter values. However, `allowFilterExpressions` allows users to make use of certain operators that `allowFilterOperators` does not support, such as using the "betweenInclusive" operator by typing "5...10".

When both `allowfilterExpressions` and `allowFilterOperators` are set, filter expressions entered in to the edit-area are parsed and the operator automatically applied to the \[attr:ListGrid.operatorIcon\](#attr-listgridoperatoricon).

If \[attr:ListGrid.allowFilterWindow\](#attr-listgridallowfilterwindow) is enabled another option, \["Advanced Filtering"\](#attr-listgridadvancedfilteringtext), is added to the "Filter using" menu.

### See Also

- [ListGrid.allowFilterWindow](#attr-listgridallowfilterwindow)

**Flags**: IR

---
## Method: FilterBuilder.clearCriteria

### Description
Clear all current criteria.

---
## Class: TabSet

### Description
The TabSet class allows components on several panes to share the same space. The tabs at the top can be selected by the user to show each pane.

Tabs are configured via the `tabs` property, each of which has a `pane` property which will be displayed in the main pane when that tab is selected.

---
## Attr: ListGrid.dragScrollRedrawDelay

### Description
Like \[attr:ListGrid.scrollRedrawDelay\](#attr-listgridscrollredrawdelay), but applies when the component is being drag-scrolled (via a scrollbar). This value is typically set higher than \[attr:ListGrid.scrollRedrawDelay\](#attr-listgridscrollredrawdelay) to avoid too many concurrent fetches to the server for \[class:ResultSet\](#class-resultset)-backed components since it's quite easy to induce such a case with a scrollbar and a grid bound to a large databaset.

### Groups

- performance

**Flags**: IRW

---
## ClassMethod: XMLTools.selectNodes

### Description
Retrieve a set of nodes from an XML element or document based on an XPath expression.

If the target document is namespaced, namespace prefixes declared in the document element of the target document will be available, as well as the default namespace, if declared, under the prefix "default".

To declare your own namespace prefixes, provide a prefix to URI mapping as a simple JS Object, for example:

   {
      az : "http://webservices.amazon.com/AWSECommerceService/2005-03-23",
      xsd : "http://www.w3.org/2001/XMLSchema"
   }
 

#### NOTE:
 this API cannot be supported on the Safari web browser for versions earlier than 3.0.3.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| element | [XMLElement](#type-xmlelement)|[XMLDocument](#type-xmldocument)|[String](#type-string) | false | — | Native XMLElement,document, or xml string to select from |
| expression | [XPath](#type-xpath) | false | — | XPath expression to use to select nodes |
| namespaces | [Map](#type-map)<[Prefix,URI](#type-prefix-uri)> | true | — | namespace mapping used by the expression |

### Returns

`[Array](#type-array)` — list of nodes matching XPath

### Groups

- xmlTransform

---
## Attr: ComboBoxItem.editProxyConstructor

### Description
Default class used to construct the \[class:EditProxy\](#class-editproxy) for this component when the component is \[first placed into edit mode\](#method-canvasseteditmode).

**Flags**: IR

---
## Attr: DetailViewerField.imageHeight

### Description
Height of image shown for fieldTypes image in this field.

If set to a String, assumed to be a property on each record that specifies the image height. For example, if `field.imageHeight` is "logoHeight", `record.logoHeight` will control the height of the image.

### Groups

- imageColumns

### See Also

- [DetailViewerField.imageSize](#attr-detailviewerfieldimagesize)
- [DetailViewerField.imageWidth](#attr-detailviewerfieldimagewidth)

**Flags**: IRW

---
## Attr: Splitbar.showClosedGrip

### Description
If \[attr:Splitbar.showGrip\](#attr-splitbarshowgrip) is true, this property determines whether the grip image displayed should show the `"Closed"` state when the \[attr:Splitbar.target\](#attr-splitbartarget) is hidden. Note that if \[attr:Splitbar.invertClosedGripIfTargetAfter\](#attr-splitbarinvertclosedgripiftargetafter) is true, we may show the "closed" state when the target is visible, rather than when it is hidden.

### Groups

- grip

**Flags**: IRA

---
## Attr: GridRenderer.showClippedValuesOnHover

### Description
If true and a cell's value is clipped, then a hover containing the full cell value is enabled.

Note that standard cell hovers override clipped value hovers. Thus, to enable clipped value hovers, \[canHover\](#attr-gridrenderercanhover) must be unset or null and the corresponding field must have \[showHover\](#attr-listgridfieldshowhover) unset or null as well.

### Groups

- events

### See Also

- [GridRenderer.canHover](#attr-gridrenderercanhover)
- [GridRenderer.cellValueHoverHTML](#method-gridrenderercellvaluehoverhtml)

**Flags**: IRWA

---
## ClassAttr: Browser.isTouch

### Description
Is the application running on a touch device (e.g. iPhone, iPad, Android device, etc.)?

SmartClient's auto-detected value for `isTouch` can be overridden via \[classMethod:Browser.setIsTouch\](#classmethod-browsersetistouch).

**Flags**: RW

---
## Attr: TreeGrid.useAllDataSourceFields

### Description
If true, the set of fields given by the "default binding" (see \[attr:DataBoundComponent.fields\](#attr-databoundcomponentfields)) is used, with any fields specified in `component.fields` acting as overrides that can suppress or modify the display of individual fields, without having to list the entire set of fields that should be shown.

If `component.fields` contains fields that are not found in the DataSource, they will be shown after the most recently referred to DataSource field. If the new fields appear first, they will be shown first.

${isc.DocUtils.linkForExampleId('validationFieldBinding', 'This example')} shows a mixture of component fields and DataSource fields, and how they interact for validation.

This setting may be cleared if a \[class:FieldPicker\](#class-fieldpicker) is used to edit the component's field order.

### Groups

- databinding

### See Also

- [FieldPicker.dataBoundComponent](#attr-fieldpickerdataboundcomponent)

**Flags**: IRW

---
## Attr: ListPropertiesDialog.cancelButton

### Description
The Cancel button. When clicked, the \[cancelClick\](#method-listpropertiesdialogcancelclick) event is fired.

\[cancelButtonTitle\](#attr-listpropertiesdialogcancelbuttontitle) is a \[passthrough\](#group-autochildusage) for the button's \[title\](#attr-buttontitle).

**Flags**: R

---
## Attr: TileLayout.showDragLine

### Description
Set false to prevent the \[attr:TileLayout.dragLine\](#attr-tilelayoutdragline) autochild from showing during dragging.

**Flags**: IRW

---
## Attr: DatabaseBrowser.selectButton

### Description
Instance of Button used to continue once a table has been selected.

**Flags**: IR

---
## Attr: FacetChart.facets

### Description
An Array of facets, exactly analogous to \[attr:CubeGrid.facets\](#attr-cubegridfacets), except that:

*   the "inlinedValues" property can be set on a facet to change data representation as described under \[attr:Chart.data\](#attr-chartdata).
*   for a non-inlined facet, Charts support auto-derivation of facetValues from the data.

In all chart types except "Bubble" and "Scatter", the chart displays a value for each discrete value of one facet (i.e. single-facet charts) or it displays a value for each combination of discrete values of two facets (multi-facet charts). The two discrete facets are the \[data label facet\](#method-facetchartgetdatalabelfacet) and the \[legend facet\](#method-facetchartgetlegendfacet). They are named based on where the \[values\](#attr-facetvalues) of the facet appear in the chart. The facet whose values are rendered as labels along the data axis or in the main chart area is the data label facet, and the facet whose values are rendered in the legend is the legend facet.

For single-facet charts, most chart types have a data label facet as the first facet but no legend facet. Single-facet Pie charts have a legend facet as the first facet but no data label facet. Bubble and Scatter plots may have a legend facet as the second facet, after the metric facet.

In all multi-facet charts, the data label facet is always first and the legend facet is second. In most chart types the data label facet and the legend facet may be swapped on the fly by the user clicking on the "Swap Facets" item of the context menu.

In the case of \[Bar and Column Charts\](#class-facetchart), up to three facets are supported, where the first two facets in that case are taken as the data label facets, and the third facet as the legend facet. This works by positioning both data label facets on the same axis, in a way that clearly shows which inner facet values are associated with each outer facet value.

For databound charts, \[attr:FacetChart.facetFields\](#attr-facetchartfacetfields) may be specified instead of this property. If both are provided, \[attr:FacetChart.facetFields\](#attr-facetchartfacetfields) is definitive but \[class:Facet\](#class-facet) properties will be picked up from \[attr:FacetChart.facets\](#attr-facetchartfacets) also present in the \[attr:FacetChart.facetFields\](#attr-facetchartfacetfields).

**Flags**: IR

---
## ClassMethod: DateUtil.combineLogicalDateAndTime

### Description
Combine a logical date (a value appropriate for a DataSourceField of type "date") with a logical time (a value appropriate for a DataSourceField of type "time") into a datetime value (a value appropriate for a DataSourceField of type "datetime")

This method correctly takes into account the current \[display timezone\](#classmethod-timesetdefaultdisplaytimezone), specifically, the returned datetime value will show the same date and time as the passed date and time objects when rendered by a SmartClient component that has been configured with a field of type "datetime".

For further background on date, time and datetime types, storage and transmission, see \[this overview\](#group-dateformatandstorage).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| date | [Date](#type-date) | false | — | a Date instance representing logical date value |
| time | [Date](#type-date) | false | — | a Date instance representing logical time value |

### Returns

`[Date](#type-date)` — a Date instance representing a datetime value combining the logical date and time passed

---
## Attr: DynamicForm.errorItemProperties

### Description
If \[attr:DynamicForm.showInlineErrors\](#attr-dynamicformshowinlineerrors) is false we show all errors for the form item in a single item rendered at the top of the form.  
This attribute contains a properties block for this item.

### Groups

- validation

**Flags**: IRA

---
## Attr: ListGrid.expansionFieldImageShowSelected

### Description
Should a "\_selected" suffix be added to the \[expansionFieldTrueImage\](#attr-listgridexpansionfieldtrueimage) and \[expansionFieldFalseImage\](#attr-listgridexpansionfieldfalseimage) image URLs for selected rows?

This allows developers to provide separate expansion field media for selected rows, in case the selected row style does not contrast well with the standard expansion field image media.

If both this property and \[attr:ListGrid.expansionFieldImageShowRTL\](#attr-listgridexpansionfieldimageshowrtl) are true, and the grid is in RTL mode, both suffixes will be applied to selected rows' expansion field image (combined as "selected\_rtl")

### Groups

- expansionField

**Flags**: IRA

---
## Attr: TourStep.pointerSnapTo

### Description
Applied directly to \[attr:TourStep.targetView\](#attr-toursteptargetview) \[pointerSettings\](#attr-canvaspointersettings).

### Groups

- snapPositioning

**Flags**: IR

---
## Attr: DataSourceField.columnCode

### Description
See \[attr:DataSource.tableCode\](#attr-datasourcetablecode).

**Flags**: R

---
## Attr: DataSourceField.valueMap

### Description
A \[type:ValueMap\](#type-valuemap) is a set of legal values for a field.

The valueMap can be specified as either an Array of legal values, or as an \[type:Object\](#type-object) where each property maps a stored value to a user-displayable value.

To enforce that a field should be constrained to only the values in the valueMap, either declare \[field.type\](#attr-datasourcefieldtype) as "enum", or use a \[type:ValidatorType\](#type-validatortype) of "isOneOf" with explicitly listed values. Otherwise, although a normal \[class:SelectItem\](#class-selectitem) control will only allow values from the valueMap to be entered, other controls such as a \[ComboBox\](#class-comboboxitem) will allow other values to be entered.

In XML, a valueMap that specifies only a list of legal values is specified as follows:

   <valueMap>
   	<value>Pens & Pencils</value>
   	<value>Stationery</value>
   	<value>Computer Products</value>
   	<value>Furniture</value>
   	<value>Misc</value>
   </valueMap>
 

A ValueMap that specifies stored values mapped to user-visible values is specified as follows:

   <valueMap>
   	<value ID="1">Pens & Pencils</value>
   	<value ID="2">Stationery</value>
   	<value ID="3">Computer Products</value>
   	<value ID="4">Furniture</value>
   	<value ID="5">Misc</value>
   </valueMap>

### Groups

- dataType

**Flags**: IR

---
## Attr: CoTTransition.visibleWhen

### Description
Conditional visibility for this transition, evaluated with the same semantics as \[attr:Canvas.visibleWhen\](#attr-canvasvisiblewhen). When false, the transition is treated as unavailable: it is omitted from prompt fragments (see \["transitions"\](#method-cotprocessgetpromptpart)) and hidden from any UI that lists transitions. If the AI attempts to use a non-visible transition (e.g., emits {goTo} to this target) resulting in a validation error and a retry.

#### Evaluation context
  
The expression is evaluated against the process \[ruleScope\](#attr-processrulescope). In addition, the special identifier `state` is prebound to `process.state`

#### Examples

 // Only show "addField" while total fields < 50
 visibleWhen: {
   operator:"lessThan",
   fieldName:"state.currentDS.fields.length",
   value:50
 }

 // Hide "done" unless we've added at least one field in this run
 visibleWhen: {
   operator:"isNotNull",
   fieldName:"state.lastCreatedField"
 }

 // Require both a DataSource and at least 1 field
 visibleWhen: {
   operator:"and",
   criteria:\[
     { fieldName:"state.currentDS", operator:"isNotNull" },
     { fieldName:"state.currentDS.fields.length", operator:"greaterThan", value:0 }
   \]
 }

**Flags**: IR

---
## Attr: StretchImgButton.height

### Description
Size for this component's vertical dimension. See \[attr:Canvas.height\](#attr-canvasheight) for more details.

Note that if \[attr:StatefulCanvas.autoFit\](#attr-statefulcanvasautofit) is set on non-\[class:StretchImgButton\](#class-stretchimgbutton) instances, this property will be ignored so that the widget is always sized just large enough to accommodate the title.

### Groups

- sizing

### See Also

- [StatefulCanvas.autoFit](#attr-statefulcanvasautofit)

**Flags**: IRW

---
## Method: FormItem.parseEditorValue

### Description
Allows customization of how a used-entered text value is converted to the FormItem's logical stored value (the value available from \[method:FormItem.getValue\](#method-formitemgetvalue)).

This method only applies to form items which show an editable text entry area, such at the \[class:TextItem\](#class-textitem) or \[class:TextAreaItem\](#class-textareaitem).

See also \[method:FormItem.formatEditorValue\](#method-formitemformateditorvalue)

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| value | [String](#type-string) | false | — | value as entered by the user |
| form | [DynamicForm](#type-dynamicform) | false | — | pointer to the dynamicForm containing this item |
| item | [FormItem](#type-formitem) | false | — | pointer to this item |

### Returns

`[Any](#type-any)` — Data value to store for this item.

---
## Attr: ListGrid.valueIconSize

### Description
Default width and height of value icons for this ListGrid. Can be overridden at the listGrid level via explicit \[attr:ListGrid.valueIconWidth\](#attr-listgridvalueiconwidth) and \[attr:ListGrid.valueIconHeight\](#attr-listgridvalueiconheight), or at the field level via \[attr:ListGridField.valueIconSize\](#attr-listgridfieldvalueiconsize), \[attr:ListGridField.valueIconWidth\](#attr-listgridfieldvalueiconwidth) and {ListGridField.valueIconHeight}

### Groups

- imageColumns

### See Also

- [ListGrid.valueIconWidth](#attr-listgridvalueiconwidth)
- [ListGrid.valueIconHeight](#attr-listgridvalueiconheight)
- [ListGridField.valueIconSize](#attr-listgridfieldvalueiconsize)

**Flags**: IRW

---
## Attr: EditNode.liveObject

### Description
Live version of the object created from the \[attr:EditNode.defaults\](#attr-editnodedefaults). For example, if \[attr:EditNode.type\](#attr-editnodetype) is "ListGrid", `liveObject` would be a ListGrid.

**Flags**: IR

---
## Attr: DateChooser.baseWeekdayStyle

### Description
Base CSS style applied to weekdays. Will have "Over", "Selected" and "Down" suffix appended as the user interacts with buttons. Defaults to \[attr:DateChooser.baseButtonStyle\](#attr-datechooserbasebuttonstyle).

See \[group:cellStyleSuffixes\](#group-cellstylesuffixes) for details on how stateful suffixes are combined with the base style to generate stateful cell styles in Grids.

**Flags**: IRW

---
## Attr: Calendar.cancelButton

### Description
An \[type:AutoChild\](#type-autochild) of type \[class:IButton\](#class-ibutton), used to cancel editing of an event and close the \[eventEditor\](#attr-calendareventeditor).

**Flags**: R

---
## Attr: CoTTask.maxRetries

### Description
Maximum number of retries for validation failures for this task. If unset, inherits from \[attr:CoTProcess.maxRetries\](#attr-cotprocessmaxretries). A value of 0 disables retries.

**Flags**: IR

---
## Object: isc

### Description
`window.isc` is the base object for the Isomorphic SmartClient framework. Every SmartClient class is available on this object as `isc._ClassName_`. The `isc` also contains a number of static utility methods.

See also \[Simple Names mode\](#group-simplenamesmode).

---
## Attr: TabSet.symmetricEdges

### Description
If this tabSet will \[show edges\](#attr-tabsetshowpanecontaineredges) for the paneContainer, this property determines whether the same edge media will be used regardless of the tab bar position, or whether different media should be used (necessary if the edge appearance is not symmetrical on all sides).

If this property is set to false the paneContainer edge image URLs will be prefixed with the tabBarPosition of the tabSet - for example `"[SKIN]edge_top_T.gif"` rather than just `"[SKIN]edge_T.gif"`.

When `symmetricEdges` is false, custom edge sizes for the pane container may be specified via \[attr:TabSet.topEdgeSizes\](#attr-tabsettopedgesizes) et al, and custom edge offsets via \[attr:TabSet.topEdgeOffsets\](#attr-tabsettopedgeoffsets) et al.

### Groups

- appearance

**Flags**: IR

---
## Attr: DataSourceField.initRequiresAuthentication

### Description
Whether a user must be authenticated in order to initialize to this field. If this property is set and the user is not authenticated, the SmartClient Server will not allow this field to be initialized.

### Groups

- fieldLevelAuth
- declarativeSecurity

### See Also

- [DataSourceField.editRequiresAuthentication](#attr-datasourcefieldeditrequiresauthentication)

**Flags**: IR

---
## Attr: RPCRequest.isBackgroundRequest

### Description
Is this a background request?

This attribute may be set to true for requests that do not interfere with the normal flow of user interaction within an application.

Background requests are ignored by \[classMethod:AutoTest.waitForSystemDone\](#classmethod-autotestwaitforsystemdone), giving automated testing tools a way to identify specific operations that should not interfere with the flow of the test, without entirely disabling the ability to \[wait for network operations\](#attr-systemwaitconfigincludenetworkoperations).

**Flags**: IRW

---
## Type: DSInheritanceMode

### Description
For DataSources of type "sql" and "hibernate", specifies the kind of inheritance to use when a dataSource specifies \[inheritsFrom\](#attr-datasourceinheritsfrom).

### Values

| Value | Description |
|-------|-------------|
| "full" | Inherit fields by copying them onto the inheriting DataSource's underlying table. When we import a DataSource with this inheritanceMode, we create actual columns for inherited fields on the table we create. With this inheritanceMode, inherited fields are updatable. |
| "none" | Do not physically inherit fields onto the inheriting DataSource's SQL table. Columns will not be created for inherited fields on import, and all generated SQL operations will exclude inherited fields. However, those fields are still part of the DataSource's schema so you can, for example, write \[custom SQL\](#group-customquerying) that returns values for the inherited fields, and they will be delivered to the client. |

### Groups

- fields

---
## Attr: Shuttle.fetchOperation

### Description
\[OperationId\](#attr-dsrequestoperationid) for fetching records from the shuttle's \[class:DataSource\](#class-datasource).

**Flags**: IR

---
## Method: DrawItem.setMoveKnobOffset

### Description
Setter for \[attr:DrawItem.moveKnobOffset\](#attr-drawitemmoveknoboffset).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| newMoveKnobOffset | [Array of int](#type-array-of-int)[] | true | — | the new move knob offset. This is a 2-element array of \[left offset, top offset\]. If null, then `[0,0]` is assumed. |

**Flags**: A

---
## Attr: TreeMenuButton.treeMenu

### Description
AutoChild menu displayed when the button is clicked.

**Flags**: IR

---
## Attr: FusionChart.chartURL

### Description
Full URL to the chart. Needed only if you have renamed the charts such that automatic URL formation won't work.

**Flags**: IR

---
## Class: EventHandler

### Description
The ISC system provides a predictable cross-browser event-handling mechanism for ISC widgets. Events can be handled both at the page level (i.e., globally), and at the level of individual widgets.

With the exception of a few page-specific events ('load', 'unload', 'idle' and 'resize'), events are processed in the following sequence:

1\. The event is sent to any global (page-level) event handlers. These handlers can cancel further propagation of the event by returning false. You can register to listen for any of the events linked in the seeAlso section (below) by calling \[classMethod:Page.setEvent\](#classmethod-pagesetevent) method.

2\. If the event occurred on a form element or a link, it is passed on to the browser so that the element will perform its default action. No widget receives the event.

3\. If the event occurred on an enabled widget (but not on a form element or link inside the widget), it is sent to that widget's event handler, if any. This handler can cancel further propagation of the event by returning false. An "enabled" widget is any widget that defines an event handler for one of the supported events. Interceptable events are defined in the \["widgetEvents" section of Canvas\](#class-canvas-methods-events).

4\. The event is "bubbled" up to the widget's parent in the containment hierarchy, if any. Again, the parent's handler for the event can cancel further propagation by returning false. This step is repeated, with the event "bubbling" up through the containment hierarchy, until a top-level widget is reached or the event is explicitly canceled. In brief, the ISC event model offers the best features of browser event models:

*   Page-first event handling allows you to reliably process or cancel any event before it affects the objects on the page.
*   Event "bubbling" ensures that parent widgets receive events sent to their children, and allows you to create generalized parent-level handlers rather than duplicating code in each child.

Note: Canceling propagation of an event may cancel its side effects as well, including the generation of other (synthetic) events. For example, if a global mouseDown handler returns false, drag-and-drop events will not be generated. Specific effects are discussed in the descriptions of the various events in the following sections.

SmartClient libraries will not interfere with native event handling when events occur outside of a target widget. You can therefore have HTML that is not ISC-based on the same page as widget objects that will react to native events as you would expect.

You can use isc.Event as an alias for isc.EventHandler.

### Groups

- eventHandling

### See Also

- [PageEvent](#type-pageevent)
- [Page.setEvent](#classmethod-pagesetevent)
- [Page.clearEvent](#classmethod-pageclearevent)
- [Canvas#methods#widgetEvents](#class-canvas-methods-widgetevents)

---
## Attr: DynamicForm.clipItemTitles

### Description
Should the titles for form items be clipped if they are too large for the available space?

Can be overridden for individual items via \[attr:FormItem.clipTitle\](#attr-formitemcliptitle).

**Flags**: IRW

---
## Method: Layout.setLayoutMargin

### Description
Method to force a reflow of the layout after directly assigning a value to any of the layout\*Margin properties. Takes no arguments.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| newMargin | [Integer](#type-integer) | true | — | optional new setting for layout.layoutMargin. Regardless of whether a new layout margin is passed, the layout reflows according to the current settings for layoutStartMargin et al |

### Groups

- layoutMargin

---
## Attr: Dialog.messageStyle

### Description
Style to apply to the message text shown in the center of the dialog

**Flags**: IR

---
## Type: KnobType

### Description
Entries for the \[attr:DrawItem.knobs\](#attr-drawitemknobs) array. Each specified knobType will enable some UI allowing the user to manipulate the DrawItem directly.

#### NOTE:
 Not all knob types are supported by each DrawItem type. Refer to the DrawItem type's \[knobs\](#attr-drawitemknobs) attribute documentation for a list of the supported knob types.

### Values

| Value | Description |
|-------|-------------|
| "resize" | Display up to 8 control knobs at the corners specified by \[attr:DrawItem.resizeKnobPoints\](#attr-drawitemresizeknobpoints), allowing the user to drag-resize the item. See also \[attr:DrawItem.cornerResizeKnob\](#attr-drawitemcornerresizeknob) and \[attr:DrawItem.sideResizeKnob\](#attr-drawitemsideresizeknob). |
| "move" | Display a control knob for moving the item around. See also \[attr:DrawItem.moveKnobPoint\](#attr-drawitemmoveknobpoint) and \[attr:DrawItem.moveKnobOffset\](#attr-drawitemmoveknoboffset) |
| "startPoint" | Control knob to manipulate \[attr:DrawLine.startPoint\](#attr-drawlinestartpoint). |
| "endPoint" | Control knob to manipulate \[attr:DrawLine.endPoint\](#attr-drawlineendpoint). |
| "controlPoint1" | Display a draggable control knob along with a DrawLine indicating the angle between controlPoint1 and the startPoint. Dragging the knob will adjust controlPoint1. |
| "controlPoint2" | Display a draggable control knob along with a DrawLine indicating the angle between controlPoint2 and the endPoint. Dragging the knob will adjust controlPoint2. |
| "rotate" | Display a rotation knob above the top resize knob, allowing the user to rotate the item. See also \[attr:DrawItem.rotateKnob\](#attr-drawitemrotateknob). |

---
## Method: TileGrid.recordClick

### Description
Executed when the tileGrid receives a 'click' event on a tile. The default implementation does nothing -- override to perform some action when any record is clicked.  
A record event handler can be specified either as a function to execute, or as a string of script to evaluate. If the handler is defined as a string of script, all the parameters below will be available as variables for use in the script.  
If you want to cancel the click based on the parameters, return false. Otherwise, return true so that the click event be registered with the tile.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| viewer | [TileGrid](#type-tilegrid) | false | — | the TileGrid itself |
| tile | [Canvas](#type-canvas) | false | — | the tile that was clicked on |
| record | [TileRecord](#type-tilerecord) | false | — | the record that was clicked on |

### Groups

- events

---
## Attr: DataBoundComponent.emptyGeneratedHoverContents

### Description
Hover contents to use when the generated hover contents are empty

### Groups

- pseudoFieldGeneration
- i18nMessages

**Flags**: IRW

---
## Attr: TimeItem.hourItemPrompt

### Description
The hover prompt to show for the \[hour picker\](#attr-timeitemhouritem).

### Groups

- i18nMessages

**Flags**: IRW

---
## Attr: DataSource.resultBatchSize

### Description
Very advanced: for servers that do not support paging, and must return large numbers of XML records in one HTTP response, SmartClient breaks up the processing of the response in order to avoid the "script running slowly" dialog appearing for an end user.

If you have a relatively small number of records with a great deal of properties or subobjects on each record, and you have not set \[attr:DataSource.dropExtraFields\](#attr-datasourcedropextrafields) to eliminate unused data, and you see the "script running slowly" dialog, you may need to set this number lower.

**Flags**: IRWA

---
## Attr: TextAreaItem.selectOnFocus

### Description
Allows the \[selectOnFocus\](#attr-dynamicformselectonfocus) behavior to be configured on a per-FormItem basis. Normally all items in a form default to the value of \[attr:DynamicForm.selectOnFocus\](#attr-dynamicformselectonfocus).

### Groups

- focus

**Flags**: IRW

---
## Attr: ListGrid.filterWindowCriteriaIndicator

### Description
Instance of \[class:Canvas\](#class-canvas) used to show visual indicator that \[attr:ListGrid.filterWindowCriteria\](#attr-listgridfilterwindowcriteria) is configured. \[attr:ListGrid.showFilterWindowCriteriaIndicator\](#attr-listgridshowfilterwindowcriteriaindicator) must be enabled to show indicator.

**Flags**: IR

---
## Object: SerializationSettings

### Description
Settings to control \[class:EditContext\](#class-editcontext) serialization.

### Groups

- devTools

---
## Type: FieldFilterMode

### Description
Indicates where a given field can be legally filtered. By default, any field where \[attr:DataSourceField.canFilter\](#attr-datasourcefieldcanfilter) isn't `false` allows filtering either at the server or at the \[client\](#attr-resultsetuseclientfiltering), according to related settings.

This is the recommended behavior, but it can be useful or necessary to limit filtering in some cases.

### Values

| Value | Description |
|-------|-------------|
| "both" | \- filter on the client where possible and contact the server when necessary |
| "serverOnly" | \- any change to criteria for a field causes cache invalidation and a trip to the server. This mode is quite useful for cases where client filtering can't replicate server filtering, such as:

*   search engines that consider something a match based on word roots (like treating "sunken" as a match for "sink")
*   server-side formatting, where values are delivered as HTML or even as images, where the value seen in the browser no longer matches the search text
*   searching large files where the files won't be delivered to the client

By using this mode only for fields that are special, you can preserve the performance benefits of client-side filtering on other fields. |

---
## Attr: Button.iconStyle

### Description
Base CSS style applied to the icon image. If set, as the `StatefulCanvas` changes \[state\](#attr-statefulcanvasstate) and/or is \[selected\](#attr-statefulcanvasselected), suffixes will be appended to `iconStyle` to form the className set on the image element.

The following table lists out the standard set of suffixes which may be appended:

CSS Class Applied

Description

`_iconStyle_`

Default CSS style

`_iconStyle_+Selected`

Applied when \[attr:StatefulCanvas.selected\](#attr-statefulcanvasselected) and \[attr:StatefulCanvas.showSelectedIcon\](#attr-statefulcanvasshowselectedicon) are true.

`_iconStyle_+Focused`

Applied when the component has keyboard focus, if \[attr:StatefulCanvas.showFocusedIcon\](#attr-statefulcanvasshowfocusedicon) is true, and \[attr:StatefulCanvas.showFocusedAsOver\](#attr-statefulcanvasshowfocusedasover) is not true.

`_iconStyle_+Over`

Applied when \[attr:StatefulCanvas.showRollOverIcon\](#attr-statefulcanvasshowrollovericon) is set to true and either the user rolls over the component or \[attr:StatefulCanvas.showFocusedAsOver\](#attr-statefulcanvasshowfocusedasover) is true and the component has keyboard focus.

`_iconStyle_+Down`

Applied when the user presses the mouse button on the component if \[attr:StatefulCanvas.showDownIcon\](#attr-statefulcanvasshowdownicon) is set to true

`_iconStyle_+Disabled`

Applied when the component is \[disabled\](#attr-canvasdisabled) if \[attr:StatefulCanvas.showDisabledIcon\](#attr-statefulcanvasshowdisabledicon) is true.

_Combined styles_

`_iconStyle_+SelectedFocused`

Combined Selected and focused styling

`_iconStyle_+SelectedOver`

Combined Selected and rollOver styling

`_iconStyle_+FocusedOver`

Combined Focused and rollOver styling

`_iconStyle_+SelectedFocusedOver`

Combined Selected, Focused and rollOver styling

`_iconStyle_+SelectedDown`

Combined Selected and mouse-down styling

`_iconStyle_+FocusedDown`

Combined Focused and mouse-down styling

`_iconStyle_+SelectedFocusedDown`

Combined Selected, Focused and mouse-down styling

`_iconStyle_+SelectedDisabled`

Combined Selected and Disabled styling

In addition, if \[attr:StatefulCanvas.showRTLIcon\](#attr-statefulcanvasshowrtlicon) is true, then in RTL mode, a final "RTL" suffix will be appended.

### Groups

- buttonIcon

**Flags**: IRW

---
## Attr: Slider.valueStyle

### Description
CSS style for the floating \[valueLabel\](#attr-slidervaluelabel), visible when \[attr:Slider.showValue\](#attr-slidershowvalue) is true.

**Flags**: IR

---
## Attr: ListGrid.clearAllSortingText

### Description
If we're showing a \[headerContextMenu\](#attr-listgridshowheadercontextmenu) for this grid, this attribute will be shown as the menu item title to clear any existing sort on all fields. This menu-item is displayed only in the context menu for the sorter button.

### Groups

- i18nMessages

**Flags**: IRW

---
## Method: ListGrid.getRowCountStatus

### Description
This method indicates whether \[method:ListGrid.getRowCount\](#method-listgridgetrowcount) reflects an accurate row-count for this listGrid. An accurate row count may not currently be available if \[progressiveLoading\](#attr-datasourceprogressiveloading) is active.

See \[type:RowCountStatus\](#type-rowcountstatus) for further details.

### Returns

`[RowCountStatus](#type-rowcountstatus)` — Current row-count status for this grid

### Groups

- rowRangeDisplay

---
## Method: EventStream.getAsSeleneseCommands

### Description
Creates and returns Selenese that represents the events captured by the stream as an array of \[Selenium commands\](#object-seleniumcommand). Compare with \[method:EventStream.getAsSeleneseHTML\](#method-eventstreamgetasselenesehtml), where you'll also find more common details.

Just as when retrieving the Selenese as HTML, if a \[method:EventStream.transformSelenese\](#method-eventstreamtransformselenese) function has been defined, it's called before returning the Selenese.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| settings | [SeleneseSettings](#type-selenesesettings) | true | — | — |

### Returns

`[Array of SeleniumCommand](#type-array-of-seleniumcommand)` — —

### Groups

- automatedTesting
- experimental

---
## Attr: ColorPicker.satFieldTitle

### Description
The title for the 'Sat' field in the complex chooser.

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: DataSource.beanClassName

### Description
This property has different meanings depending on the \[serverType\](#attr-datasourceservertype):

#### For SQL DataSources (DataSources with serverType "sql")
  
If set, results from the database will be used to create one instance of the indicated Java bean per database row. Otherwise a Map is used to represent each row retrieved from SQL.

With this feature active, a DSResponse from this DataSource will contain a Collection of instances of the indicated `beanClassName`, available via DSResponse.getData(). This creates a couple of possibilities:

Add business logic for derived properties, such as computed formulas

For example, declare a DataSourceField named "revenueProjection". By default this field will call getRevenueProjection() on your bean to retrieve the value to send to the client. Your implementation of getRevenueProjection() could apply some kind of formula to other values loaded from the database.

Call business logic on retrieved beans via DMI

By adding a \[DMI\](#group-dmioverview) method that calls DSRequest.execute() to retrieve a DSResponse, you have an opportunity to call business logic methods on the beans representing each row affected by the DSRequest. For example, notify a related BPEL process of changes to certain fields.

By using `beanClassName` on a specific \[class:OperationBinding\](#class-operationbinding), you can:

*   Use a bean to represent your data only when it matters; for example, avoid the overhead of using a bean for "fetch" operations, but do use a bean for "update" operations so that you can execute relevant business logic after the update completes.
*   Skip the use of beans for complex reporting queries that produce results unrelated to your persistent object model. Set beanClassName to blank ("") on a specific operationBinding to override DataSource.beanClassName for that specific operation.
*   For SQL joins that produce additional data fields, use a special, operation-specific bean that represents a join of multiple entities and contains business logic specific to that joined dataset

Note that `beanClassName` affects what numeric field types will be used for inbound DSRequest data. For fields with numeric types, the \[record data\](#attr-dsrequestdata) in DSRequests will automatically be converted to the type of the target field, before the request is received in a \[class:DMI\](#class-dmi). For details, see \[group:dsRequestBeanTypes\](#group-dsrequestbeantypes).

Note that \[DMI\](#group-dmioverview) also has a built-in facility for populating a bean with the inbound \[attr:DSRequest.data\](#attr-dsrequestdata) - just declare the bean as a method argument.

#### For generic DataSources (DataSources with serverType "generic")
  
\[Reify\](#group-reify) sets this property when it creates a generic DataSource using the Javabean Wizard. It has no built-in server-side effects.

#### For Hibernate DataSources (DataSources with serverType "hibernate")
  
The name of the Java bean or POJO class that is mapped in Hibernate. This will typically be the fully-qualified class name - eg `com.foo.MyClass` - but it may be the simple class name - just `MyClass` - or it may be some other value. It all depends on how your classes have been mapped in Hibernate.

The declared Java bean will affect how its properties will be mapped to built-in numeric types, see \[Hibernate Integration overview\](#group-hibernateintegration) for details.

Note: If you are intending to use Hibernate as a data-access layer only, you do not need to create Hibernate mappings or Java objects: SmartClient will generate everything it needs on the fly.

#### For JPA DataSources (DataSources with serverType "jpa" or "jpa1")
  
The fully qualified class name of the JPA annotated entity.

#### NOTE for Hibernate and JPA users:
 When you use JPA, or use Hibernate as a full ORM system (ie, not just allowing SmartClient Server to drive Hibernate as a data access layer), the beans returned on the server-side are 
#### live
. This means that if you make any changes to them, the ORM system will persist those changes. This is true even if the beans were created as part of a fetch operation.

This causes a problem in the common case where you want to use a DMI or custom DataSource implementation to apply some post-processing to the beans fetched from the persistent store. If you change the values in the beans directly, those changes will be persisted.

If you want to alter the data returned from a JPA or Hibernate persistent store as part of a fetch request just so you can alter what gets sent to the client, you can use the server-side `DSResponse`'s `getRecords()` method. This will return your bean data in "record" format - ie, as a List of Maps. You can alter these records without affecting your persistent store, and then call `setData()` on the `DSResponse`), passing the altered list of records. See the server-side Javadocs for `DSResponse` for details of these two methods.

### See Also

- [OperationBinding.beanClassName](#attr-operationbindingbeanclassname)

**Flags**: IR

---
## Attr: StatefulCanvas.state

### Description
Current "state" of this widget. The state setting is automatically updated as the user interacts with the component (see \[attr:StatefulCanvas.showRollOver\](#attr-statefulcanvasshowrollover), \[attr:StatefulCanvas.showDown\](#attr-statefulcanvasshowdown), \[attr:StatefulCanvas.showDisabled\](#attr-statefulcanvasshowdisabled)).

StatefulCanvases will have a different appearance based on their current state. By default this is handled by changing the css className applied to the StatefulCanvas - see \[attr:StatefulCanvas.baseStyle\](#attr-statefulcanvasbasestyle) and \[method:StatefulCanvas.getStateSuffix\](#method-statefulcanvasgetstatesuffix) for a description of how this is done.

For \[class:Img\](#class-img) or \[class:StretchImg\](#class-stretchimg) based subclasses of StatefulCanvas, the appearance may also be updated by changing the src of the rendered image. See \[attr:Img.src\](#attr-imgsrc) and \[attr:StretchImgButton.src\](#attr-stretchimgbuttonsrc) for a description of how the URL is modified to reflect the state of the widget in this case.

### Groups

- state

### See Also

- [State](#type-state)
- [state](#group-state)

**Flags**: IRWA

---
## Group: reflection

### Description
In order to specify a SmartGWT class as a constructor in \[Component XML\](#group-componentxml) or \[Component Schema\](#group-componentschema), or for other purposes, such as for {@link com.smartgwt.client.docs.AutoChildUsage autoChildren} or for {@link com.smartgwt.client.data.DataSourceField#setEditorType(Class)}, you must first register the class with the {@link com.smartgwt.client.bean.BeanFactory} reflection mechanism.

If you want to register {@link com.smartgwt.client.widgets.Canvas} and all its subclasses found in the classpath (including your custom subclasses), you can use the {@link com.smartgwt.client.bean.BeanFactory.CanvasMetaFactory} interface to do this automatically:

>  GWT.create(BeanFactory.CanvasMetaFactory.class);

Similarly, to register {@link com.smartgwt.client.widgets.form.fields.FormItem} and all its subclasses found in the classpath (including your custom subclasses), you can use the {@link com.smartgwt.client.bean.BeanFactory.FormItemMetaFactory}.

>  GWT.create(BeanFactory.FormItemMetaFactory.class);

Alternatively, if only specific classes need to be instantiated and configured dynamically, you can register just those classes by annotating them with the {@link com.smartgwt.client.bean.BeanFactory.Generate} annotation instead. For instance:

>  {@literal @}BeanFactory.Generate
>  public class MyCanvas extends Canvas {
>      ...
>  }

For framework classes (where you cannot annotate the class directly), you can supply an array of Class literals to the annotation. For instance:

>  {@literal @}BeanFactory.Generate({Canvas.class, TreeGrid.class})
>  public interface EmptyInterface {
>      ...
>  }

When you supply an array of class literals, the class you annotate (here `EmptyInterface`) will 
#### not
 itself have a BeanFactory generated for it. Thus, you can use an empty inner interface for this purpose.

If there are only a limited number of classes which require dynamic configuration, it will save code size to use the {@link com.smartgwt.client.bean.BeanFactory.Generate} annotation to generate factories for those specific types, rather than using {@link com.smartgwt.client.bean.BeanFactory.CanvasMetaFactory} or {@link com.smartgwt.client.bean.BeanFactory.FormItemMetaFactory}. Once a factory is generated for a class, GWT's opportunities to prune dead code are more limited for that class, since it cannot know what properties will be set or retrieved at run-time.

---
## Attr: DetailViewerField.displayField

### Description
If `displayField` is defined for the field then the DetailViewer will display the `displayField` attribute of records instead of the attribute given by the \[attr:DetailViewerField.name\](#attr-detailviewerfieldname) of the field.

**Flags**: IR

---
## ClassMethod: Messaging.unsubscribe

### Description
Unsubscribes the client from the messaging channel identified by channel.

This will cause a reconnect to the server - for this reason we defer the actual reconnect to allow for multiple unsubscribe() calls in sequence.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| channel | [String](#type-string) | false | — | — |

### Groups

- messaging

---
## Attr: ListGrid.booleanPartialImage

### Description
Image to display for a partially true value in a boolean field (typically selection). The special value "blank" means that no image will be shown.

To turn this off explicitly set \[attr:ListGridField.suppressValueIcon\](#attr-listgridfieldsuppressvalueicon) to true.

If this, \[attr:ListGrid.booleanTrueImage\](#attr-listgridbooleantrueimage) and \[attr:ListGrid.booleanFalseImage\](#attr-listgridbooleanfalseimage) are unset, this will be set to the default \[attr:CheckboxItem.partialSelectedImage\](#attr-checkboxitempartialselectedimage).

\[Spriting\](#group-skinning) can be used for this image, by setting this property to a \[type:SCSpriteConfig\](#type-scspriteconfig) formatted string. Alternatively developers can omit this property and instead use CSS directly in the \[attr:ListGrid.booleanBaseStyle\](#attr-listgridbooleanbasestyle) property to provide a "boolean true" appearance.

### Groups

- imageColumns

### See Also

- [ListGrid.booleanTrueImage](#attr-listgridbooleantrueimage)
- [ListGrid.booleanFalseImage](#attr-listgridbooleanfalseimage)
- [ListGrid.printBooleanPartialImage](#attr-listgridprintbooleanpartialimage)

**Flags**: IRWA

---
## Method: Calendar.setZones

### Description
Sets the \[zones\](#attr-calendarzones) used to highlight areas of this calendar.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| zones | [Array of CalendarEvent](#type-array-of-calendarevent) | false | — | array of zones to display |

---
## Attr: ListGrid.headerButtonProperties

### Description
Properties to apply to all header buttons. Overrides defaults applied via \[attr:ListGrid.headerButtonDefaults\](#attr-listgridheaderbuttondefaults).

### Groups

- gridHeader
- appearance

**Flags**: IRA

---
## Method: ListGrid.cellErrorIconOut

### Description
Optional stringMethod to fire when the mouse moves off the error icon of a cell with validation errors.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| record | [ListGridRecord](#type-listgridrecord) | false | — | cell record as returned by getCellRecord() |
| rowNum | [number](#type-number) | false | — | row number for the cell |
| colNum | [number](#type-number) | false | — | column number of the cell |

### Returns

`[boolean](#type-boolean)` — false to suppress the standard behavior (clear the standard error message hover if it is showing)

### Groups

- events

### See Also

- [ListGrid.showErrorIcons](#attr-listgridshowerroricons)

**Flags**: A

---
## Attr: MultiPickerItem.canSelectFolders

### Description
For multiPickerItems with \[selectionStyle:"pickTree"\](#type-selectionstyle), should the user be able to select and deselect folders?

If false, selection checkboxes will only be visible by leaf nodes within the pickTree data set.

Note that this flag may be set to true in conjunction with \[includeSelectedParents:false\](#attr-multipickeritemincludeselectedparents). In this case the user may check and uncheck parent nodes as a convenient way to select or unselect all their children due to \[cascading selection\](#attr-multipickeritemcascadeselection), but the parent nodes themselves won't be present in the item's value.

**Flags**: IR

---
## ClassMethod: Time.toShortTime

### Description
Given a date object, return the time associated with the date as a short string. If no formatter is passed, use the standard formatter set up via \[classMethod:Time.setShortDisplayFormat\](#classmethod-timesetshortdisplayformat)

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| date | [Date](#type-date) | false | — | Date to convert to a time string. |
| formatter | [TimeDisplayFormat](#type-timedisplayformat)|[FormatString](#type-formatstring)|[Function](#type-function) | true | — | Optional custom formatter to use. Will accept a function (which will be passed a pointer to the Date to format), a format string, or a string designating a standard formatter |
| logicalTime | [boolean](#type-boolean) | true | — | Is the date passed in a representation of a logical time value such as a value from a `"time"` type field on a dataSource or a datetime value? For datetime values the formatted string will respect any custom \[display timezone\](#classmethod-timesetdefaultdisplaytimezone). If not explicitly specified, the date passed in will be assumed to be a datetime unless it was created explicitly as a time via \[classMethod:Time.createLogicalTime\](#classmethod-timecreatelogicaltime) or similar APIs. |

### See Also

- [Time.toTime](#classmethod-timetotime)

---
## Attr: StatefulCanvas.showMenuOnClick

### Description
If true, this widget will fire \[showContextMenu()\](#method-canvasshowcontextmenu) to show the \[context menu\](#attr-canvascontextmenu) if one is defined, rather than \[click()\](#method-canvasclick), when the left mouse is clicked.

Note that this property has a different interpretation in \[class:IconButton\](#class-iconbutton) as \[IconButton.showMenuOnClick\](#attr-ribbonbuttonshowmenuonclick).

### Groups

- menu

**Flags**: IRW

---
## Method: DataBoundComponent.getFieldNum

### Description
Find the index of a currently visible field.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| fieldName | [FieldName](#type-fieldname)|[Field](#type-field) | false | — | field name or field |

### Returns

`[int](#type-int)` — index of field within currently visible fields, or -1 if not found.

---
## Attr: AIRequest.cancellationController

### Description
If provided, the \[class:CancellationController\](#class-cancellationcontroller) that will be looked to for whether the AI request is canceled.

**Flags**: IR

---
## Attr: DrawnValue.barThickness

### Description
For bar and column charts, thickness of the bar representing this data value.

**Flags**: IR

---
## ClassMethod: DataSource.makeFileSpec

### Description
Converts a file path to a \[object:FileSpec\](#object-filespec).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| path | [String](#type-string) | false | — | The path to convert, e.g. "employees.ds.xml" |

### Returns

`[FileSpec](#type-filespec)` — The equivalent FileSpec, e.g. {fileName: "employees", fileType: "ds", fileFormat: xml"}

### Groups

- fileSource

---
## Class: GridTransferDataTask

### Description
Transfer selected records from one grid to another.

### See Also

- [ListGrid.transferSelectedData](#method-listgridtransferselecteddata)

---
## Method: FacetChart.getDataLineWidth

### Description
Specifies the width to use for data lines in the chart. No default implementation. If not defined or null is returned, the line width will be set by the appropriate chart properties, such as \[attr:FacetChart.dataLineProperties\](#attr-facetchartdatalineproperties), \[attr:FacetChart.barProperties\](#attr-facetchartbarproperties), or \[attr:FacetChart.bubbleProperties\](#attr-facetchartbubbleproperties).

Note that this method is simply an override point, since it has no default implementation.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| index | [Number](#type-number) | false | — | index of the legend facet value to target |
| facetValueId | [String](#type-string)|[Number](#type-number)|[Date](#type-date) | false | — | id of the legend facet value to target |
| purpose | [String](#type-string) | false | — | purpose for the requested width - such as "legend", "line", "area", "points", etc. |

### Returns

`[int](#type-int)` — width to use for data lines or null to use \[type:ChartType\](#type-charttype) default

### See Also

- [DrawItem.lineWidth](#attr-drawitemlinewidth)
- [FacetChart.getDataLineColor](#method-facetchartgetdatalinecolor)

---
## Attr: DrawLinePath.connectorOrientation

### Description
The ConnectorOrientation controlling the orientation and behavior of this line's tail segments.

### Groups

- line

**Flags**: IR

---
## ClassAttr: RPCResponse.STATUS_LOGIN_SUCCESS

### Description
Indicates that the login succeeded.

### Groups

- statusCodes
- constant

### See Also

- [RPCRequest](#object-rpcrequest)

**Flags**: R

---
## Attr: RecordEditor.filterImg

### Description
\[Icon\](#attr-buttonicon) to show on the \[attr:RecordEditor.actionButton\](#attr-recordeditoractionbutton) if this component is being used as a \[attr:ListGrid.filterEditor\](#attr-listgridfiltereditor).

Note that this \[type:SCImgURL\](#type-scimgurl) will be resolved using the \[attr:RecordEditor.skinImgDir\](#attr-recordeditorskinimgdir) defined for the RecordEditor.

**Flags**: IR

---
## Attr: DataSource.auditDataSourceID

### Description
For DataSources with \[auditing enabled\](#attr-datasourceaudit), optionally specifies the ID of the audit DataSource. If this property is not specified, the ID of the audit DataSource will be `audit_[OriginalDSID]`

**Flags**: IR

---
## Type: Double

### Description
A decimal (or "floating point") number, for example, 5.5. Null is allowed.

### See Also

- [double](#type-double)

---
## Method: GridRenderer.refreshCellStyle

### Description
Refresh the styling of an individual cell without redrawing the grid.

The cell's CSS class and CSS text will be refreshed, to the current values returned by getCellStyle() and getCellCSSText() respectively.

The cell's contents (as returned by getCellValue()) will 
#### not
 be refreshed. To refresh both styling and contents, call refreshCell() instead.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| rowNum | [number](#type-number) | false | — | row number of cell to refresh |
| colNum | [number](#type-number) | false | — | column number of cell to refresh |

### Groups

- appearance

### See Also

- [GridRenderer.refreshCell](#method-gridrendererrefreshcell)

---
## Attr: DataBoundComponent.descriptionField

### Description
Name of the field that has a long description of the record, or has the primary text data value for a record that represents an email message, SMS, log or similar.

This attribute has the same function as \[attr:DataSource.descriptionField\](#attr-datasourcedescriptionfield) but can be set for a component with no dataSource, or can be used to override the dataSource setting.

**Flags**: IR

---
## Attr: Canvas.animateScrollTime

### Description
Default time for performing an animated scroll. If unset, `this.animateTime` will be used by default instead

### Groups

- animation

**Flags**: IRWA

---
## Method: DynamicForm.getEditorType

### Description
Returns the form item type (Class Name) to be created for some field.  
By default `field.editorType` will be used if present - otherwise backs off to deriving the appropriate form item type from the data type of the field (see \[type:FormItemType\](#type-formitemtype) for details).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| field | [Object](#type-object) | false | — | field definition for which we are deriving form item type. |
| values | [Object](#type-object) | true | — | Current set of values being edited by this form. May be null. |

### Returns

`[String](#type-string)` — form item type for the field

### Groups

- editing

**Flags**: A

---
## Attr: Calendar.dateEditingStyle

### Description
Indicates the type of controls to use in event-windows. Valid values are those in the \[DateEditingStyle\](#type-dateeditingstyle) type.

If unset, the editing style will be set to the field-type on the DataSource, if there is one. If there's no DataSource, it will be set to "date" if the \[granularity\](#attr-calendartimelinegranularity) is "day" or larger and "time" if granularity is "minute" or smaller, otherwise "datetime".

**Flags**: IR

---
## Method: Calendar.getMonthViewHoverHTML

### Description
This method returns the hover HTML to be displayed when the user hovers over a cell displayed in the calendar month view tab.

Default implementation will display a list of the events occurring on the date the user is hovering over. Override for custom behavior. Note that returning null will suppress the hover altogether.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| date | [Date](#type-date) | false | — | Date the user is hovering over |
| events | [Array of CalendarEvent](#type-array-of-calendarevent) | false | — | array of events occurring on the current date. May be empty. |

### Returns

`[HTMLString](#type-htmlstring)` — HTML string to display

---
## Attr: ListGrid.aiFilterWindowHint

### Description
The inline hint-text displayed in the user-entry area in the \[attr:ListGrid.aiFilterWindow\](#attr-listgridaifilterwindow).

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: FieldPickerWindow.fieldPicker

### Description
A \[FieldPicker\](#class-fieldpicker) for altering the working field-set in a \[Data-bound component\](#interface-databoundcomponent).

**Flags**: IR

---
## Method: ResultSet.resort

### Description
Forcibly resort this ResultSet by the current list of \[object:SortSpecifier\](#object-sortspecifier)s.

---
## Attr: Calendar.zoneTitleOrientation

### Description
The vertical alignment of the header-text in each \[zone\](#attr-calendarzones).

**Flags**: IR

---
## Attr: TimeItem.showMillisecondItem

### Description
Controls whether to display the \[attr:TimeItem.millisecondItem\](#attr-timeitemmilliseconditem) when \[attr:TimeItem.useTextField\](#attr-timeitemusetextfield) is false.

**Flags**: IRW

---
## StaticMethod: History.setHistoryTitle

### Description
Sets the title associated with all history entries. This is the string that appears in the history drop-down. If left unset, this default to the history id that is passed into \[staticMethod:History.addHistoryEntry\](#staticmethod-historyaddhistoryentry).

Note: Currently, this works in IE only. You may call this method in all other browsers, but it will not change what's displayed in the history drop-down.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| title | [String](#type-string) | false | — | The title to show in the history drop-down. |

---
## Attr: RangeSlider.vertical

### Description
Whether the rangeSlider should be vertical or horizontal. Default is horizontal.

**Flags**: IR

---
## Class: SpinnerItem

### Description
Item for picking a number. Includes arrow buttons to increase / decrease the value

---
## Class: IPickTreeItem

### Description
Subclass of \[class:PickTreeItem\](#class-picktreeitem) which shows an \[class:IMenuButton\](#class-imenubutton) rather than a simple \[class:MenuButton\](#class-menubutton) as it's main button.

---
## Attr: SavedSearchForm.hint

### Description
If set this property will override \[attr:SavedSearchItem.hint\](#attr-savedsearchitemhint) on the automatically generated \[class:SavedSearchItem\](#class-savedsearchitem).

### Groups

- i18nMessages

**Flags**: IR

---
## Method: LoginDialog.loginFunc

### Description
User-supplied callback function to process login transactions.

If the user clicks the "Log in" button, the credentials entered by the user are passed to loginFunc as an Object with properties "username" and "password" (NOTE: both property names are all lowercase), as the variable "credentials". For example:

{ username: "barney", password: "rUbbL3" }

This function should then attempt to log in by whatever means is necessary. The second parameter to the loginFunc, "dialogCallback", is a function, which must be called _whether login succeeds or fails_ with a true/false value indicating whether login succeeded.

If the login dialog is dismissable (settable as properties.dismissable, default false) and the user dismisses it, loginFunc will be fired with null for the credentials.

The following code shows typical usage. This code assumes you have created a global function sendCredentials() that send credentials to some authentication system and fires a callback function with the result:

 ...
 loginFunc : function (credentials, dialogCallback) {
     if (credentials == null) return; // dismissed

     // send credentials
     sendCredentials(credentials, function (loginSucceeded) {
         // report success or failure
         dialogCallback(loginSucceeded);
     })
 })
 ...

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| credentials | [Object](#type-object) | false | — | Login credentials supplied by the user |
| dialogCallback | [Function](#type-function) | false | — | Function that must be called once the login transaction completes |

---
## Attr: MetricSettings.fixedFacetValue

### Description
For a \[single-facet\](#attr-metricsettingsmultifacet) chart of an extra value axis, this property provides a constant facet value for the second facet. By varying the value of the other facet in multi-facet data, the chart obtains the series of values to plot. The default facet value is the first facet value of the second facet.

**Flags**: IR

---
## Attr: DateTimeItem.displayFormat

### Description
This property can be used to customize the format in which datetimes are displayed.  
Should be set to a standard \[type:DateDisplayFormat\](#type-datedisplayformat) or a function which will return a formatted date time string.

If unset, the standard shortDateTime format as set up in \[classMethod:DateUtil.setShortDatetimeDisplayFormat\](#classmethod-dateutilsetshortdatetimedisplayformat) will be used.

#### NOTE: you may need to update the \[inputFormat\](#attr-datetimeiteminputformat) to ensure the DateItem is able to parse user-entered date strings back into Dates

### See Also

- [DateTimeItem.inputFormat](#attr-datetimeiteminputformat)

**Flags**: IRW

---
## Group: formLayout

### Description
#### FormItem Placement in Columns and Rows

With the default tabular layout mechanism, items are laid out in rows from left to right until the number of columns, specified by \[form.numCols\](#attr-dynamicformnumcols), is filled, then a new row is begun. Flags on FormItems, including \[startRow\](#attr-formitemstartrow), \[endRow\](#attr-formitemendrow), \[colSpan\](#attr-formitemcolspan) and \[rowSpan\](#attr-formitemrowspan), control row and column placement and spanning.

Note that the most common form items (TextItem, SelectItem, etc) take up 
#### two
 columns by default: one for the form control itself, and one for it's title. The default setting of \[form.numCols:2\](#attr-dynamicformnumcols) will result in one TextItem or SelectItem per row.

Note also that ButtonItems have both startRow:true and endRow:true by default. You must set startRow and/or endRow to `false` on a ButtonItem in order to place a button in the same row as any other item.

The log category "tablePlacement" can be enabled from the Developer Console to watch items being placed. You can also set \[form.cellBorder:1\](#attr-dynamicformcellborder) to reveal the table structure for layout troubleshooting purposes.

#### Row and Column Sizing

\[attr:DynamicForm.colWidths\](#attr-dynamicformcolwidths) controls the widths of form columns. FormItems that have "\*" for \[attr:FormItem.width\](#attr-formitemwidth) will fill the column. FormItems with a numeric width will have that width in pixels regardless of the column's specified width, which may cause the column to overflow as described under \[attr:DynamicForm.fixedColWidths\](#attr-dynamicformfixedcolwidths).

For row heights, the largest pixel height specified on any item in the row is taken as a minimum size for the row. Then, any rows that have "\*" or "%" height items will share any height not taken up by fixed-sized items.

Individual item heights are controlled by \[item.height\](#attr-formitemheight). This may be specified as an integer (pixel value), or a percentage string, or the special string "\*", which indicates an item should fill the available space.  
Percentages allow developers to determine how the available space in the form is split amongst items. For example if a form has 4 items in a single column, 2 of which have an absolute pixel height specified, and 2 of which are have heights of `"30%"` and `"70%"` respectively, the percentage sized items will split up the available space after the fixed size items have been rendered.  
Note that \[item.cellHeight\](#attr-formitemcellheight) may be specified to explicitly control the height of an item's cell. In this case the specified \[item.height\](#attr-formitemheight) will govern the size of the item within the cell (and if set to a percentage, this will be interpreted as a percentage of the cellHeight).

#### Managing Overflow

Forms often contain labels, data values, or instructional text which can vary in size based on the skin, data values, or internationalization settings. There are a few ways to deal with a form potentially varying in size:

1.  Allow scrolling when necessary, using \[overflow:auto\](#attr-canvasoverflow), either on the immediate form, or on some parent.
2.  Place the form in a Layout along with a component that can render any specified size, such as a \[class:ListGrid\](#class-listgrid). In this case, the Layout will automatically shrink the grid in order to accommodate the form.
3.  Ensure that the form can always render at a designed minimum size by reducing the number of cases of variable-sized text, and testing remaining cases across all supported skins. For example, move help text into hovers on help icons, or clip long text values at a maximum length and provide a hover to see the rest.

#### Adaptive Layout

To have various automatic adjustments made to render your form items in a single column, you can use \[linearMode\](#attr-dynamicformlinearmode). Importantly, you can have this mode automatically applied to a form on \[handset devices\](#classattr-browserishandset) by setting \[linearOnMobile\](#attr-dynamicformlinearonmobile) true. For further details and the properties that are available to customize this mode, see the \[linearMode\](#attr-dynamicformlinearmode) documentation.

Several examples of Form Layout are available ${isc.DocUtils.linkForExampleId('formsLayout', 'here')}.

### See Also

- [FormItem.width](#attr-formitemwidth)
- [FormItem.height](#attr-formitemheight)
- [DynamicForm.itemLayout](#attr-dynamicformitemlayout)

---
## Method: Canvas.setBottom

### Description
Resizes the widget vertically to position its bottom edge at the specified coordinate.

NOTE: if you're setting multiple coordinates, use setRect(), moveTo() or resizeTo() instead

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| bottom | [number](#type-number) | false | — | new bottom coordinate |

### Groups

- sizing

---
## Method: FormItem.getGridColNum

### Description
If this formItem is part of a \[class:ListGrid\](#class-listgrid)'s \[inline edit form\](#attr-listgridcanedit), returns the number of the grid column this formItem is responsible for editing, but 
#### only
 if a row is currently being edited. If the formItem is not part of a ListGrid inline edit for any reason, this method returns null. Reasons for a formItem not being part of an inline edit include

*   The item is part of an ordinary DynamicForm, not an inline edit form
*   There is no row in the grid currently being edited
*   A row is being edited, but this formItem is not currently visible and is being excluded because of horizontal incremental rendering (where SmartClient avoids drawing grid columns that would not be visible without scrolling)

### Returns

`[Integer](#type-integer)` — The grid column number being edited by this formItem, or null, as described above

---
## Attr: RibbonButton.menuIconHeight

### Description
The height of the icon for this button.

### Groups

- menu

**Flags**: IRW

---
## ClassAttr: Log.WARN

### Description
A declared value of the enum type \[LogPriority\](#type-logpriority).

**Flags**: R

---
## ClassMethod: TabIndexManager.focusInTarget

### Description
Request the TabIndexManager shift focus to a registered focus target.

This method does not directly change the focus within the DOM - instead it invokes the `shiftFocusCallback` registered for the specified target if it is marked as `canFocus:true`.

Returns false if the target had no no `shiftFocusCallback`, the `shiftFocusCallback` returned false, or if the target is marked as not `canFocus:true`

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| ID | [String](#type-string) | false | — | target to shift focus to |

### Returns

`[boolean](#type-boolean)` — returns false to indicate failure to shift focus.

---
## Attr: FilteredList.dataSource

### Description
Optional dataSource to specifying field names and types for records within this List. Note that since a full data set should be provided to the list via \[attr:FilteredList.allRows\](#attr-filteredlistallrows), this filteredList will not issue fetch requests against this DataSource.

If no DataSource was explicitly specified, filteredList will automatically generate its own DataSource with \[dropUnknownCriteria\](#attr-datasourcedropunknowncriteria) set to false.

**Flags**: IR

---
## Object: FacetValue

### Description
Facet value definition object made use of by the \[CubeGrid\](#class-cubegrid) and \[FacetChart\](#class-facetchart) classes (contained by facets).

---
## Method: ListGrid.setHeaderSpans

### Description
Update the headerSpans configuration on the grid dynamically.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| headerSpans | [Array of HeaderSpan](#type-array-of-headerspan) | false | — | same configuration block as that passed to \[attr:ListGrid.headerSpans\](#attr-listgridheaderspans). |

### Groups

- headerSpan

---
## Class: BaseWidget

### Description
Base class for \[class:Canvas\](#class-canvas) and \[class:DrawItem\](#class-drawitem).

---
## Class: SectionItem

### Description
Header item for a collapsible section in a \[class:DynamicForm\](#class-dynamicform). Each `SectionItem` is associated with a number of other `item`s in the form, which will be shown or hidden as a group when the section is expanded or collapsed. Clicking on a `SectionItem` will expand or collapse the section.

To make a form where only one section is expanded at a time, set \[attr:DynamicForm.sectionVisibilityMode\](#attr-dynamicformsectionvisibilitymode) to "mutex".

### See Also

- [DynamicForm.sectionVisibilityMode](#attr-dynamicformsectionvisibilitymode)

---
## Method: Gauge.setDialRadius

### Description
All DrawItems currently associated with this Gauge are destroyed and new DrawItems are created instead.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| dialRadius | [float](#type-float) | false | — | Radius in pixels of the dial |

---
## Method: PortalLayout.setCanShrinkColumnWidths

### Description
Sets \[attr:PortalLayout.canShrinkColumnWidths\](#attr-portallayoutcanshrinkcolumnwidths) and reflows to reflect the new setting.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| canShrink | [boolean](#type-boolean) | false | — | Whether columns can shrink to avoid overflowing the PortalLayout's width. |

### Groups

- sizing

### See Also

- [PortalLayout.canShrinkColumnWidths](#attr-portallayoutcanshrinkcolumnwidths)
- [PortalLayout.canStretchColumnWidths](#attr-portallayoutcanstretchcolumnwidths)

---
## Method: Canvas.encloses

### Description
Returns true if the rectangle of this widget encloses the rectangle of the specified widget.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| other | [Canvas](#type-canvas) | false | — | other canvas to test for enclosure |

### Returns

`[Boolean](#type-boolean)` — true if this canvas encloses other; false otherwise

### Groups

- positioning

---
## StaticMethod: isc.showConsole

### Description
Method available on the isc object to open the Developer Console.

### Groups

- debug

---
## Method: ListGrid.setFieldIcon

### Description
Change the \[attr:ListGridField.icon\](#attr-listgridfieldicon) for a field after the grid is created

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| fieldName | [String](#type-string) | false | — | field to update |
| icon | [SCImgURL](#type-scimgurl) | false | — | icon for the field |

---
## Method: SectionItem.isExpanded

### Description
Returns a boolean indicating whether this SectionItem is expanded.

### Returns

`[Boolean](#type-boolean)` — true if the section is expanded false if not

---
## Attr: DynamicForm.target

### Description
The name of a window or frame that will receive the results returned by the form's action. The default null indicates to use the current frame.

#### NOTE:
 this is used only in the very rare case that a form is used to submit data directly to a URL. Normal server contact is through \[DataBound Component Methods\](#group-databoundcomponentmethods).

### Groups

- submitting

**Flags**: IRWA

---
## Attr: Tab.pane

### Description
Specifies the pane associated with this tab. You have three options for the value of the pane attribute:

*   #### ID
     - The global ID of an already created Canvas (or subclass).
*   #### Canvas
     - A live instance of a Canvas (or subclass).
*   #### AutoChildShortcut
     - String with format "autoChild:_autoChildName_"

You can change the pane associated with a given tab after the TabSet has been created by calling \[method:TabSet.updateTab\](#method-tabsetupdatetab).

### See Also

- [autoChildren](#group-autochildren)
- [TabSet.updateTab](#method-tabsetupdatetab)

**Flags**: IR

---
## Attr: NotifyAction.dismissMessage

### Description
Should a click on this action automatically dismiss the associated message?

**Flags**: IR

---
## ClassMethod: MathFunction.getRegisteredFunctionIndex

### Description
Returns an index of all registered functions by name

### Returns

`[int](#type-int)` — —

### Groups

- formulaFields

---
## Attr: DateItem.autoUseTextField

### Description
When set to true, the default, and when \[useTextField\](#attr-dateitemusetextfield) is set to false, such that the item displays multiple separate pickers, `useTextField` is automatically switched on when the item is rendering in a non-interactive way, such as when printing, or when \[canEdit\](#attr-formitemcanedit) is false and the read-only display-mode is \[static\](#attr-formitemreadonlydisplay).

### Groups

- basics

**Flags**: IR

---
## Attr: Menu.canSaveSearches

### Description
Option to save searches is disabled for menus

**Flags**: IRA

---
## Method: ListGrid.setCanRemoveRecords

### Description
Updates the \[attr:ListGrid.canRemoveRecords\](#attr-listgridcanremoverecords) property for this listGrid at runtime.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| canRemove | [boolean](#type-boolean) | false | — | new canRemoveRecords value |

---
## Attr: DetailViewer.fieldPickerFieldProperties

### Description
Names of properties on \[object:DetailViewerField\](#object-detailviewerfield) for which the \[class:FieldPicker\](#class-fieldpicker) should show an editing interface, for convenience.

For example, specify \["decimalPad", "decimalPrecision"\] to allow end users to modify \[attr:DetailViewerField.decimalPad\](#attr-detailviewerfielddecimalpad) and \[attr:DetailViewerField.decimalPrecision\](#attr-detailviewerfielddecimalprecision) respectively.

**Flags**: IR

---
## Attr: MultiSortPanel.otherSortLevelTitle

### Description
The title-text to appear in the first column for all sort-levels other than the first.

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: ListGrid.applyFormulaAfterSummary

### Description
If \[attr:ListGridField.userFormula\](#attr-listgridfielduserformula) is set for some field, and this grid is showing \[group summaries\](#attr-listgridshowgroupsummary) or a \[grid summary\](#attr-listgridshowgridsummary), this property determines what field value should be present in those summary rows. Should the field's user-formula be applied to the calculated summary row (applyFormulaAfterSummary `true`), or should a standard grid or group summary be applied to the user-formula values displayed in the grid (applyFormulaAfterSummary `false`)?

May be overridden at the field level via \[attr:ListGridField.applyAfterSummary\](#attr-listgridfieldapplyaftersummary)

**Flags**: IRW

---
## ClassAttr: DrawLabel.defaultCursiveFont

### Description
This setting exists due to platform limitations in some versions of Internet Explorer where the browser does not recognize the five generic font families (`cursive`, `fantasy`, `monospace`, `sans-serif`, and `serif`) and instead uses a non-configurable, default font. This setting specifies a specific font to replace the `cursive` keyword should a DrawLabel list it in its \[font family\](#attr-drawlabelfontfamily).

**Flags**: IRW

---
## Class: CancelItem

### Description
Button that cancels any changes in the form, by calling \[method:DynamicForm.cancelEditing\](#method-dynamicformcancelediting) when clicked. See \[method:DynamicForm.cancelEditing\](#method-dynamicformcancelediting) for details on what happens when a form editing is cancelled.

---
## Attr: RadialGradient.r

### Description
radius

**Flags**: IR

---
## Attr: DateRangeItem.fromTitle

### Description
The title for the \[from\](#attr-daterangeitemfromfield) part of the range.

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: CoTTask.outputFields

### Description
Shorthand for \[attr:CoTTask.outputDS\](#attr-cottaskoutputds), causing a temporary DataSource to be created to validate AI outputs. See \[attr:CoTTask.outputDS\](#attr-cottaskoutputds) for details of how validation is performed.

**Flags**: IR

---
## Attr: ComboBoxItem.completeOnEnter

### Description
If true, when the pickList is showing, the user can select the current value by hitting the `Enter` key.

If not explicitly set, completeOnEnter will default to false for items embedded in a \[filtering interface\](#class-searchform), true otherwise.

**Flags**: IRW

---
## Attr: Layout.managePercentBreadth

### Description
If set, a Layout with breadthPolicy:"fill" will specially interpret a percentage breadth on a member as a percentage of available space excluding the \[attr:Layout.layoutMargin\](#attr-layoutlayoutmargin). If false, percentages work exactly as for a non-member, with layoutMargins, if any, ignored.

**Flags**: IR

---
## Attr: MultiSortDialog.fields

### Description
The list of fields which the user can choose to sort by.

**Flags**: IR

---
## Attr: FacetChart.logScalePointColor

### Description
Whether to use logarithmic scaling for the \[color scale\](#attr-facetchartcolorscalemetric) of the data points. Defaults to the value of \[attr:FacetChart.logScale\](#attr-facetchartlogscale).

### Groups

- dataPoints

### See Also

- [FacetChart.pointColorLogBase](#attr-facetchartpointcolorlogbase)

**Flags**: IR

---
## Method: Canvas.pageScrollUp

### Description
This method is the programmatic equivalent of the user pressing the "Page Up" key while this widget has the focus. It scrolls the widget's content upwards by the viewport height, if the content can be scrolled that far upwards

---
## Attr: LoadingIndicatorSettings.message

### Description
Optional HTML text message to display in the loading indicator.

**Flags**: IRW

---
## Attr: DataSourceField.includeFrom

### Description
Indicates that this field should be fetched from another, related DataSource.

The `includeFrom` attribute should be of the form "_dataSourceId_._fieldName_", for example:

    <field includeFrom="supplyItem.itemName"/>
 

A \[attr:DataSourceField.foreignKey\](#attr-datasourcefieldforeignkey) declaration must exist between the two DataSources, establishing either a 1-to-1 relationship or a many-to-1 relationship from this DataSource to the related DataSource. The inclusion can be indirect (traverse multiple DataSources) so long as there is a chain of `foreignKey` declarations from the target DataSource to the DataSource where the `includeFrom` field is declared. You may use dot-notation to provide an explicit path between DataSources, or provide the name of only the last DataSource in the chain to have the complete path calculated for you at runtime. i.e., either of the following are acceptable forms, where foreign keys are defined to link records in the current DataSource to Employee records and in turn to Office records:

   <field includeFrom="Employee.Office.territory"/>
   <!-- OR -->
   <field includeFrom="Office.territory"/>
 

Note that when using the shorthand form, there is potential ambiguity: there could be multiple ways in which two DataSources are related via different intervening DataSources, so the auto-discovered relation may be different depending on which other DataSources are loaded in the page. For this reason, explicitly spelling out the inclusion path is preferred.

Nested inclusions, where an included field is itself an included field, are also supported - for details on this and other complex scenarios see \[attr:DataSourceField.includeVia\](#attr-datasourcefieldincludevia) docs.

In all cases, \[attr:DataSourceField.name\](#attr-datasourcefieldname) will default to the name of the included field, or you can specify a different name.

If both DataSources are SQLDataSources, HibernateDataSources or JPADataSources (with Hibernate as the provider) the related data will be retrieved via a SQL join and criteria and sort directions applied to the field work normally (they become part of the generated SQL query).

Note that includeFrom is also supported between two clientOnly or MockDataSources, but not for any other combination (for example, a RestDataSource cannot use includeFrom with a clientOnly DataSource). Here, the related data (including any values derived via \[attr:DataSourceField.includeSummaryFunction\](#attr-datasourcefieldincludesummaryfunction)) will be retrieved from cacheData after the primary (fetch, add, or update) operation has returned its response.

Otherwise, the related data will be retrieved via performing a DSRequest against the related DataSource once the data from the primary DataSource has been retrieved. In this case, criteria or sorting directions applied to the included field are only allowed if data paging is not in use (for example \[attr:ListGrid.dataFetchMode\](#attr-listgriddatafetchmode):"basic"); otherwise, criteria and sort direction are ignored for the included field and a warning is logged on the server.

#### Editing included fields

An included field is \[canEdit:false\](#attr-datasourcefieldcanedit) by default. Note that included fields are not updatable, even if you set canEdit:true; the server will simply drop values for included fields if client code sends them.

When thinking about editing an included field value, typically what is really intended is to edit the value of the `foreignKey` field. For example, take the scenario of a system that tracks accounts and the employees assigned to manage them. Given a DataSource "account" related one-to-one with DataSource "employee" by a "managerId" foreignKey field, we might declare an `includeFrom` so that the name of the account manager can be shown with each "account" record.

Editing the manager's name while viewing the account would be intended to pick a new account manager, and 
#### not
 to change the legal name of the employee who happens to be the current account manager.

To correctly set up this scenario, declare an `includeFrom` field that is hidden, but is used as the \[displayField\](#attr-datasourcefielddisplayfield) for the foreign key field:

 <field name="managerId" foreignKey="employee.id" displayField="managerName" /> 
 <field name="managerName" includeFrom="employee.name" hidden="true"/> 
 

Now:

*   the "managerId" foreignKey field is shown in grids and forms, but takes its displayed value from the hidden `includeFrom` field. Note that when the `foreignKey` and `displayField` are specified, the framework automatically defaults \[attr:DataSourceField.useLocalDisplayFieldValue\](#attr-datasourcefielduselocaldisplayfieldvalue) to true to ensure the displayed value is picked up from the record being edited.
*   the automatically chosen editor will be a SelectItem with \[optionDataSource\](#attr-selectitemoptiondatasource) set to "employees": it will allow picking a different "employee" record from the "employee" DataSource.
*   saving will save the ID of a new "employee" record to the "managerId" foreign key field, as intended

You can alternatively set `editorType="ComboBoxItem"` on the "managerId" field to allow typeahead search of the "employee" DataSource. Note that the \[attr:DataSourceField.foreignDisplayField\](#attr-datasourcefieldforeigndisplayfield) attribute allows developers to have a different fieldName be used locally as a displayField from the field name for the display field in the foreign dataSource.

#### Including fields that use summary functions

The \[Include Summary Function\](#attr-datasourcefieldincludesummaryfunction) feature is used for including from a related DataSource where there are multiple related records. It applies a \[type:SummaryFunction\](#type-summaryfunction) to the related records aggregating them into single value. It is regularly used on directly included fields, but it supports indirect inclusions as well, when entire `includeFrom`+`includeSummaryFunction` setup is included from another DataSource. See \[attr:DataSourceField.includeSummaryFunction\](#attr-datasourcefieldincludesummaryfunction) docs for more details.

For best results, ensure that the field with `includeFrom` has its \[attr:DataSourceField.type\](#attr-datasourcefieldtype) explicitly set to the included field's `type`.

#### `includeFrom` combined with `[multiple](#attr-datasourcefieldmultiple):true`

If you specify `[multiple](#attr-datasourcefieldmultiple):true` on an `includeFrom` field, it has one of two quite different meanings:

1.  It is including a field which is itself marked `multiple:true`, across a regular many-to-one or one-to-one \[relation\](#group-datasourcerelations). In this case, the value of the included field is likely to be a flattened list of text values stored in a regular text field - see \[attr:DataSourceField.multipleStorage\](#attr-datasourcefieldmultiplestorage)
2.  It is including multiple related values across a one-to-many or many-to-many relation

The first of these is exactly the same as any other regular `includeFrom`, except that it will have normal `multiple:true` processing applied to the included value, so the client sees a true list of values rather than a flat string of text.

The second is more involved. With this type of `includeFrom` we will actually fetch multiple records from the included DataSource. You should read the 
#### One-to-many
 and 
#### Many-to-many
 sections of the \[relations overview\](#group-datasourcerelations) to make sure you understand how these relation types work, but essentially you declare a \[foreignKey\](#attr-datasourcefieldforeignkey) on a field that is also marked `multiple:true`, and this causes SmartClient to return a list of key values that your client-side code can use to obtain the related records (some SmartClient UI components will do this automatically).

Once one of these relation types is in place, it is also possible to declare `includeFrom` fields that make use of the relation to include fields other than the identifying key field, for convenience. For example, if a 
#### Country
 dataSource declared a one-to-many relation to a 
#### City
 dataSource, like this:

     <field name="majorCities" multiple="true" foreignKey="City.cityId" />
 

The same dataSource could make use of that relation to include the names of all related cities for convenience, so you can show a list of "Major Cities" against each country without having to go back to the server and fetch the actual City records. The declaration would look like this:

     <field name="cityNames" multiple="true" includeFrom="City.cityName" />
 

With 
#### Many-to-many
 related includeFroms - which require a "middle" dataSource, and thus a three-part `foreignKey` declaration - you may specify either the entire inclusion path, or just the endpoint. For example, if your 
#### Country
 dataSource has a many-to-many relation with a 
#### River
 dataSource - necessary, because most countries contain more than one river, and many rivers flow through more than one country - via the following `foreignKey` definition:

     <field name="rivers" multiple="true" foreignKey="CountryRivers.Rivers.riverId" />
 

you could `includeFrom` the list of related river names with either this:

     <field name="riverNames" multiple="true" includeFrom="CountryRivers.Rivers.name" />
 

or slightly simpler, this:

     <field name="riverNames" multiple="true" includeFrom="Rivers.name" />
 

If just the endpoint is specified, SmartClient will figure out the remainder of the path based on the available `foreignKey`s; if there is ambiguity that makes this impossible - ie, two `foreignKey` fields that target the same endpoint via different paths - you can either specify the entire include path in the `includeFrom` definition, or declare an \[includeVia\](#attr-datasourcefieldincludevia) setting on the field.

### Groups

- dataSourceRelations

**Flags**: IR

---
## Attr: DynamicForm.revertValueKey

### Description
Keyboard shortcut that causes the value of the currently focused form item to be reverted to whatever value would be shown if \[method:DynamicForm.resetValues\](#method-dynamicformresetvalues) were called.

**Flags**: IR

---
## Method: RangeSlider.changed

### Description
Notification fired when the selected range is changed by the end user.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| startValue | [float](#type-float) | false | — | new start value |
| endValue | [float](#type-float) | false | — | new end value |
| isDragging | [boolean](#type-boolean) | false | — | whether the user is still in the middle of a drag, so that expensive operations can be avoided if needed |

---
## Group: title

### Description
—

---
## Method: DynamicForm.valuesAreValid

### Description
Method to determine whether the current form values would pass validation. This method operates client-side, without contacting the server, running validators on the form's values and returning a value indicating whether validation was successful.

Unlike \[method:DynamicForm.validate\](#method-dynamicformvalidate) this method will not store the errors on the DynamicForm or display them to the user.

Note that \[method:DynamicForm.checkForValidationErrors\](#method-dynamicformcheckforvalidationerrors) allows for checking for server-side errors, and finding out what those errors are via a callback.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| validateHiddenFields | [boolean](#type-boolean) | false | — | Should validators be processed for non-visible fields such as dataSource fields with no associated item or fields with visibility set to `"hidden"`? |
| returnErrors | [boolean](#type-boolean) | true | — | If unset, this method returns a simple boolean value indicating success or failure of validation. If this parameter is passed, this method will return an object mapping each field name to the errors(s) encountered on validation failure, or null if validation was successful. |

### Returns

`[boolean](#type-boolean)|[Map](#type-map)` — Boolean value indicating validation success, or if `returnErrors` was specified, an object mapping field names to the associated errors, for those fields that failed validation, or null if validation succeeded.

### Groups

- validation

---
## Attr: TourConfirmStep.targetViewDefaults

### Description
Defaults for the \[attr:TourConfirmStep.targetView\](#attr-tourconfirmsteptargetview) autoChild.

**Flags**: IR

---
## Attr: Window.headerControls

### Description
Array of members to show in the Window header.

The default value of `headerControls` is an Array of Strings listing the standard header controls in their default order:

    headerControls : \["headerIcon", "headerLabel", 
                      "minimizeButton", "maximizeButton", "closeButton"\]
 

You can override `headerControls` to change the order of standard controls in the header. You can also omit standard controls this way, although it more efficient to use the related "show" property if available (eg \[attr:Window.showMinimizeButton\](#attr-windowshowminimizebutton)).

By embedding a Canvas directly in this list you can add arbitrary additional controls to the header, for example, an additional button (eg return to dock) or a DynamicForm with various kinds of input controls.

Note that having added controls to headerControls, you can still call APIs directly on those controls to change their appearance, and you can also show() and hide() them if they should not be shown in some circumstances.

Tip: custom controls need to set layoutAlign:"center" to appear vertically centered.

#### Component XML:

To define `headerControls` in Component XML a special set of components are used as markers. The standard header controls can be explicitly specified as:

  <headerControls>
      <WindowHeaderIcon/>
      <WindowHeaderLabel/>
      <WindowMinimizeButton/>
      <WindowMaximizeButton/>
      <WindowCloseButton/>
  </headerControls>

### Groups

- windowHeader

**Flags**: IR

---
## Attr: Tree.titleProperty

### Description
Name of the property on a \[object:TreeNode\](#object-treenode) that holds the title of the node as it should be shown to the user. Default value is "title". See \[attr:TreeNode.title\](#attr-treenodetitle) for usage.

**Flags**: IRW

---
## Attr: DataSource.serverConstructor

### Description
This property allows you to write and use custom DataSource subclasses on the server, by specifying either

*   the fully-qualified name of the DataSource subclass that should be instantiated server-side for this dataSource, or
*   the token "spring:" followed by a valid Spring bean ID, if you wish to instantiate your custom dataSource object using Spring dependency injection. For example, `"spring:MyDataSourceBean"`. See also \[group:serverInit\](#group-serverinit) for special concerns with framework initialization when using Spring. It is also particularly important that you read the discussion of caching and thread-safety linked to below, as there are special considerations in this area when using Spring.
*   the token "cdi:" followed by a valid CDI bean name, if you wish to instantiate your custom dataSource object using CDI dependency injection. For example, `"cdi:MyDataSourceBean"`.

One reason you might wish to do this would be to override the validate() method to provide some arbitrary custom validation (such as complex database lookups, validation embedded in legacy applications, etc). It is also possible - though obviously a more substantial task - to override the execute() method in your custom DataSource. This is one way of creating a completely customized DataSource implementation.

#### Note:
 If you use this property, you are responsible for making sure that it refers to a valid server-side class that extends `com.isomorphic.datasource.BasicDataSource`, or to a Spring bean of the same description. If your implementation relies on methods or state only present in certain specialized subclasses of DataSource (for example, you want the normal behavior and features of a HibernateDataSource, but with a specialized validate() method), then you should extend the subclass rather than the base class.

NOTE: Please take note of the points made in \[this discussion\](#group-serverdatasourceimplementation) of caching and thread-safety issues in server-side DataSources.

**Flags**: IR

---
## ClassAttr: Dialog.ASK_TITLE

### Description
Default title for the dialog displayed in response to the \[staticMethod:isc.ask\](#staticmethod-iscask) method. Note that a custom title can be specified as the `title` attribute of the `properties` parameter passed to that method.

### Groups

- i18nMessages

**Flags**: IRW

---
## Attr: ListGrid.dataProperties

### Description
For databound ListGrids, this attribute can be used to customize the \[class:ResultSet\](#class-resultset) object created for this grid when data is fetched

### Groups

- databinding

**Flags**: IRWA

---
## Attr: DetailViewer.fetchRequestProperties

### Description
If \[attr:DetailViewer.autoFetchData\](#attr-detailviewerautofetchdata) is `true`, this attribute allows the developer to declaratively specify \[object:DSRequest\](#object-dsrequest) properties for the initial \[fetchData()\](#method-listgridfetchdata) call.

Note that any properties governing more specific request attributes for the initial fetch (such as \[autoFetchTextMatchStyle\](#attr-databoundcomponentautofetchtextmatchstyle) and initial sort specifiers) will be applied on top of this properties block.

### Groups

- databinding

**Flags**: IR

---
## Attr: FacetChart.colorMutePercent

### Description
Should be set to a number between -100 and 100. If set, all colors in the chart are "muted" by this percentage by shifting them toward white (or for negative numbers, toward black).

**Flags**: IR

---
## Attr: Canvas.leavePageSpace

### Description
If set, overrides the global \[classAttr:Canvas.defaultPageSpace\](#classattr-canvasdefaultpagespace).

### Groups

- positioning

**Flags**: IRWA

---
## Type: FieldName

### Description
Name for a field.

Must be unique across all fields of its containing field container as well as a valid JavaScript identifier, as specified by ECMA-262 Section 7.6.

Note: The \[staticMethod:String.isValidID\](#staticmethod-stringisvalidid) function can be used to test whether a name is a valid JavaScript identifier.

---
## Attr: ListGridField.maxWidth

### Description
When \[attr:ListGrid.showHeader\](#attr-listgridshowheader) is false and a field is subject to autofitting (see \[attr:ListGrid.autoFitFieldWidths\](#attr-listgridautofitfieldwidths)), sets the maximum width of the field. The actual effective maximum will be the largest of this property, \[attr:ListGridField.minWidth\](#attr-listgridfieldminwidth), and \[attr:ListGrid.minFieldWidth\](#attr-listgridminfieldwidth). That is, \[attr:ListGridField.minWidth\](#attr-listgridfieldminwidth) and \[attr:ListGrid.minFieldWidth\](#attr-listgridminfieldwidth) dominate this property.

### Groups

- appearance

### See Also

- [ListGridField.width](#attr-listgridfieldwidth)

**Flags**: IRW

---
## Attr: DateRangeDialog.rangeItem

### Description
—

**Flags**: IR

---
## Method: ValuesManager.getValuesAsAdvancedCriteria

### Description
Return an AdvancedCriteria object based on the current set of values within memberForms.

Similar to \[method:ValuesManager.getValuesAsCriteria\](#method-valuesmanagergetvaluesascriteria), except the returned criteria object is guaranteed to be an AdvancedCriteria object, even if none of the form's fields has a specified \[attr:FormItem.operator\](#attr-formitemoperator)

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| textMatchStyle | [TextMatchStyle](#type-textmatchstyle) | true | — | If specified the text match style will be used to generate the appropriate `operator` for per field criteria. |

### Returns

`[AdvancedCriteria](#type-advancedcriteria)` — a \[object:AdvancedCriteria\](#object-advancedcriteria) based on the form's current values

### Groups

- criteriaEditing

---
## Method: TreeGrid.getDropFolder

### Description
When the user is dragging a droppable element over this grid, this method returns the folder which would contain the item if dropped. This is the current drop node if the user is hovering over a folder, or the node's parent if the user is hovering over a leaf.

### Returns

`[TreeNode](#type-treenode)|[NodeLocator](#type-nodelocator)` — If this is a regular treeGrid, the target drop folder; if this is a treeGrid based on a \[multiLink tree\](#attr-treemultilinktree), a NodeLocator unambiguously identifying the specific occurence of the drop folder in the tree

### Groups

- events

---
## Attr: DetailViewer.showDetailFields

### Description
Whether to show fields marked `detail:true` when a DataBoundComponent is given a DataSource but no `component.fields`.

The `detail` property is used on DataSource fields to mark fields that shouldn't appear by default in a view that tries to show many records in a small space.

### Groups

- databinding

**Flags**: IR

---
## Method: TimeItem.setSelectionRange

### Description
If \[attr:TimeItem.useTextField\](#attr-timeitemusetextfield) is true, falls through to standard \[setSelectionRange\](#method-textitemsetselectionrange) implementation on this items freeform text entry field. Otherwise has no effect.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| start | [int](#type-int) | false | — | character index for start of new selection |
| end | [int](#type-int) | false | — | character index for end of new selection |

---
## ClassAttr: FacetChart.invalidPolynomialDegreeMessage

### Description
Warning message issued when an invalid polynomial degree is entered into the prompt dialog created by the `"Polynomial Degree..."` option in the context menu for scatter plots.

### Groups

- i18nMessages

**Flags**: IRW

---
## Attr: Layout.members

### Description
An array of canvases that will be contained within this layout. You can set the following properties on these canvases (in addition to the standard component properties):

*   \[layoutAlign\](#attr-canvaslayoutalign) -- specifies the member's alignment along the breadth axis; valid values are "top", "center" and "bottom" for a horizontal layout and "left", "center" and "right" for a vertical layout (see \[attr:Layout.defaultLayoutAlign\](#attr-layoutdefaultlayoutalign) for default implementation.)
*   \[showResizeBar\](#attr-canvasshowresizebar) -- set to true to show a resize bar (default is false)

Height and width settings found on members are interpreted by the Layout according to the \[layout policy\](#attr-layoutvpolicy).

Note that it is valid to have null slots in the provided `members` Array, and the Layout will ignore those slots. This can be useful to keep code compact, for example, when constructing the `members` Array, you might use an expression that either returns a component or null depending on whether the component should be present. If the expression returns null, the null slot will be ignored by the Layout.

**Flags**: IRW

---
## Attr: AIFieldBuilder.pendingSuggestTitleHint

### Description
The hint to display in the \[titleField\](#attr-summarybuildertitlefield) when a suggested title is being generated.

### Groups

- i18nMessages

### See Also

- [AIFieldBuilder.initialAutoSuggestTitleHint](#attr-aifieldbuilderinitialautosuggesttitlehint)

**Flags**: IR

---
## Attr: DataSource.dataFormat

### Description
Indicates the format to be used for HTTP requests and responses when fulfilling DSRequests (eg, when \[method:DataSource.fetchData\](#method-datasourcefetchdata) is called).

### Groups

- clientDataIntegration
- serverDataIntegration

**Flags**: IR

---
## Attr: PortalLayout.numColumns

### Description
Initial number of columns to show in this PortalLayout. Note that after initialization columns should be added / removed via \[method:PortalLayout.addColumn\](#method-portallayoutaddcolumn) and \[method:PortalLayout.removeColumn\](#method-portallayoutremovecolumn). numColumns is ignored if you initialize the \[attr:PortalLayout.portlets\](#attr-portallayoutportlets) attribute, since the portlets attribute will imply how many columns to create.

### See Also

- [PortalLayout.portlets](#attr-portallayoutportlets)

**Flags**: IR

---
## Method: DrawGroup.scaleBy

### Description
Scale all drawItem\[\] shapes by the x, y multipliers

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| x | [float](#type-float) | false | — | scale in the x direction |
| y | [float](#type-float) | false | — | scale in the y direction |

---
## Attr: ImgSplitbar.src

### Description
The base filename or stateful image configuration for the image. Note that as the \[state\](#attr-statefulcanvasstate) of the component changes, the image displayed will be updated as described in \[group:statefulImages\](#group-statefulimages).

### Groups

- appearance

**Flags**: IR

---
## Attr: ListGrid.canMultiGroup

### Description
When true, indicates that this ListGrid supports grouping on multiple fields.

**Flags**: IRW

---
## Attr: RibbonGroup.styleName

### Description
CSS class applied to this RibbonGroup.

### Groups

- appearance

**Flags**: IRW

---
## Method: PickTreeItem.setValueTree

### Description
Setter to change the \[attr:PickTreeItem.valueTree\](#attr-picktreeitemvaluetree) at runtime

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| valueTree | [Tree](#type-tree) | false | — | new value tree for the item |

---
## Attr: ProcessElement.forceSingle

### Description
Should \[multiple record processing\](#attr-processelementsupportsmultipleinputrecords) be suppressed for this task instance? This property can be set at any time is checked before executing the task and after each execution during processing of multiple last task output records.

Note that since this property applies to an instance of a task that could be used multiple times in a process (by branching) care should be taken to restore the property value after execution completes. See \[method:ProcessElement.completeElement\](#method-processelementcompleteelement) or \[method:ProcessElement.reset\](#method-processelementreset).

**Flags**: IRW

---
## ClassMethod: ClassFactory.overwriteClass

### Description
Intentionally clobber an existing SmartClient Class, if it already exists. Works identically to \[classMethod:ClassFactory.defineClass\](#classmethod-classfactorydefineclass), except that no warning is logged to the console.

---
## Attr: ListGrid.invalidSummaryValue

### Description
Value to display to the user if showing summary values (through \[attr:ListGrid.showGridSummary\](#attr-listgridshowgridsummary), \[attr:ListGrid.showGroupSummary\](#attr-listgridshowgroupsummary) or \[listGridFieldType:"summary"\](#type-listgridfieldtype)), and the summary function returns `"null"` (implying it was unable to calculate a valid summary value). This property will only be used in the default formatting behavior. If an explicit formatter has been specified - via \[method:ListGrid.formatCellValue\](#method-listgridformatcellvalue) or \[formatGridSummary()\](#attr-listgridfieldformatgridsummary), for example - this property has no effect.

**Flags**: IRWA

---
## Method: MenuButton.setShowMenuBelow

### Description
Setter for the 'showMenuButtonBelow' property - determines whether the menu will be shown above or below the `MenuButton`.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| below | [boolean](#type-boolean) | false | — | True if the menu should be shown below the `MenuButton`. |

### Groups

- menu

---
## ClassAttr: GroupingMessages.byMillisecondsTitle

### Description
Title to use for the menu option which groups a time field by milliseconds.

### Groups

- i18nMessages

**Flags**: IRW

---
## Attr: FormItem.showValueIconOnly

### Description
If \[attr:FormItem.valueIcons\](#attr-formitemvalueicons) is set, this property may be set to show the valueIcon only and prevent the standard form item element or text from displaying

### Groups

- valueIcons

**Flags**: IRW

---
## Attr: Slider.minValue

### Description
The minimum slider value. The slider value is equal to minValue when the thumb is at the bottom or left of the slider (unless flipValues is true, in which case the minimum value is at the top/right of the slider)

### See Also

- [Slider.flipValues](#attr-sliderflipvalues)

**Flags**: IRW

---
## Attr: FormItem.optionTextMatchStyle

### Description
If this item has a specified `optionDataSource`, this property determines the textMatchStyle to use when interpretating any \[attr:FormItem.optionCriteria\](#attr-formitemoptioncriteria) during the fetch to map valueField values to displayField values.

### Groups

- databinding
- searchCriteria

**Flags**: IRA

---
## Attr: CubeGrid.indentVTreeFacets

### Description
Turns on indenting of any \[hierarchical\](#attr-facetistree) column facets. This can be overridden at the facet level via \[attr:Facet.indentVTree\](#attr-facetindentvtree). Setting this property also ensures that the header is sized tall enough to accommodate the fully expanded facet.

The amount of indenting per level can be set with \[attr:CubeGrid.vTreeFacetIndent\](#attr-cubegridvtreefacetindent), and the direction of the indenting specified with \[attr:CubeGrid.vTreeFacetIndentDirection\](#attr-cubegridvtreefacetindentdirection).

Note that if you specify an explicit height for such a fscet, such as by setting \[attr:Facet.height\](#attr-facetheight) or \[attr:Facet.labelHeight\](#attr-facetlabelheight), then the greater of that or the space required to accommodate the fully expanded facet will determine the actual height used.

### See Also

- [Facet.indentVTree](#attr-facetindentvtree)
- [CubeGrid.vTreeFacetIndent](#attr-cubegridvtreefacetindent)
- [CubeGrid.vTreeFacetIndentDirection](#attr-cubegridvtreefacetindentdirection)

**Flags**: IR

---
## Attr: GridEditProxy.generateEditableHilites

### Description
Controls whether highlights created while in edit mode are editable by end users at runtime (when the grid is no longer in edit mode). See \[attr:Hilite.canEdit\](#attr-hilitecanedit).

**Flags**: IR

---
## Attr: Layout.paddingAsLayoutMargin

### Description
If this widget has padding specified (as \[this.padding\](#attr-canvaspadding) or in the CSS style applied to this layout), should it show up as space outside the members, similar to layoutMargin?

If this setting is false, padding will not affect member positioning (as CSS padding normally does not affect absolutely positioned children). Leaving this setting true allows a designer to more effectively control layout purely from CSS.

Note that \[attr:Layout.layoutMargin\](#attr-layoutlayoutmargin) if specified, takes precedence over this value.

### Groups

- layoutMargin

**Flags**: IRWA

---
## Method: ImgButton.setDisabled

### Description
Enable or disable this object

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| disabled | [boolean](#type-boolean) | false | — | true if this widget is to be disabled |

### Groups

- enable
- state

---
## Method: RemoteWindow.getInfo

### Description
Checks whether this RemoteWindow is showing.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| callback | [RemoteWindowMapCallback](#type-remotewindowmapcallback) | false | — | callback to receive output |

---
## Attr: StaticTextItem.applyAlignToText

### Description
If the \[textAlign\](#attr-formitemtextalign) is unset, should the \[align\](#attr-formitemalign) setting, if set, be used for this `StaticTextItem`'s `textAlign`?

### Groups

- appearance

**Flags**: IRA

---
## Method: Gauge.addSector

### Description
Adds a new sector.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| newSector | [GaugeSector](#type-gaugesector)|[double](#type-double) | false | — | the new GaugeSector or the new sector's value. This is formatted with \[method:Gauge.formatLabelContents\](#method-gaugeformatlabelcontents) to get its label. |

### Returns

`[int](#type-int)` — the index of the newly-added sector.

---
## ClassAttr: RPCResponse.STATUS_MAX_FILE_SIZE_EXCEEDED

### Description
Indicates that an uploaded file's size exceeded the maximum file size allowed.

### Groups

- statusCodes
- constant

### See Also

- [RPCResponse.STATUS_FILE_REQUIRED_ERROR](#classattr-rpcresponsestatus-file-required-error)
- [RPCRequest](#object-rpcrequest)

**Flags**: R

---
## Attr: FacetChart.dataPointProperties

### Description
Common properties to apply for all data points (see \[attr:FacetChart.showDataPoints\](#attr-facetchartshowdatapoints)).

### Groups

- dataPoints

**Flags**: IR

---
## Attr: DateItem.useTextField

### Description
When set to true, the item uses a \[single text field\](#attr-dateitemtextfield) for working with the item's value.

When false or unset, the default, the item's value is represented by separate \[day\](#attr-dateitemdayselector), \[month\](#attr-dateitemmonthselector), and/or \[year\](#attr-dateitemyearselector) selectors. In this mode, null values are not supported, and a default value of Today will be enforced if no \[defaultValue\](#attr-formitemdefaultvalue) is specified. This means that a DateItem with `useTextField` set to false is effectively a \[required\](#attr-formitemrequired) field.

If you want to change the appearance of a DateItem, you will need to configure some autoChildren such as \[attr:DateItem.textField\](#attr-dateitemtextfield) via \[attr:DateItem.textFieldProperties\](#attr-dateitemtextfieldproperties), or in `useTextField:false` mode, the \[attr:DateItem.daySelector\](#attr-dateitemdayselector) and other selectors, configured via `daySelectorProperties` et al.

### Groups

- basics

**Flags**: IR

---
## Method: ScreenLoader.setDataContextBinding

### Description
Set the dataContextBinding property.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| binding | [DataContext](#type-datacontext) | false | — | the new DataContext binding |

### Groups

- dataContext

---
## Group: dataContext

### Description
—

---
## Attr: TextItem.width

### Description
Default width for fields.

### Groups

- appearance

**Flags**: IRW

---
## ClassMethod: Canvas.getPrintPreview

### Description
Creates a printCanvas containing the full printHTML for a series of components, passing it as an argument to the callback (if supplied) when it fires. Note that the generated preview canvas will be drawn automatically by this method. Developers may also explicitly create a PrintCanvas instance and populate it with HTML derived from the \[method:Canvas.getPrintHTML\](#method-canvasgetprinthtml) for finer grained control over when the print canvas is drawn.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| components | [Array of Canvas](#type-array-of-canvas) | false | — | components to get the print HTML for. May also include raw HTML strings which will be folded into the generated print output |
| printProperties | [PrintProperties](#type-printproperties) | true | — | PrintProperties object for customizing the print HTML output |
| previewProperties | [Canvas Properties](#type-canvas-properties) | true | — | properties to apply to the generated printPreview Canvas. |
| callback | [PrintCanvasCallback](#type-printcanvascallback) | true | — | callback to fire when the print preview canvas has been populated with the printable HTML. The generated canvas will be passed to the callback as a single `printPreview` parameter. |
| separator | [String](#type-string) | true | — | optional string of HTML to render between each component |

### Groups

- printing

---
## Attr: CoTProcess.transitionsPrimer

### Description
Primer text shown before the transitions list when using \[method:CoTProcess.getPromptPart\](#method-cotprocessgetpromptpart) with "transitions".

**Flags**: IR

---
## Object: isA

### Description
A library of functions for determining the types of other objects.  
  
The "isA" methods for the basic JavaScript types are much faster and more consistent across platforms than JavaScript's "typeof" operator.  
  
An isA method is automatically created for every ISC Class and Interface definition, for example, isA.Canvas().

---
## Attr: ListGridField.valueField

### Description
Specifies the \[attr:ListGridField.optionDataSource\](#attr-listgridfieldoptiondatasource) field used to retrieve the stored values that are to be mapped to the display values (specified by \[attr:ListGridField.displayField\](#attr-listgridfielddisplayfield)). Note that if this field is editable this will also be applied to this field's editors.

### Groups

- display_values

**Flags**: IRW

---
## Group: integrationIntoExistingApps

### Description
SmartClient can be easily integrated into any existing web application, regardless of the technology used, because it's careful not to interfere with the functionality or appearance of content created by other frameworks.

SmartClient components can be adapted to your existing application's layout by using the \[attr:Canvas.htmlElement\](#attr-canvashtmlelement) and \[attr:Canvas.matchElement\](#attr-canvasmatchelement) APIs, for example, allowing them to be placed appropriately and respond automatically to DOM-level create, destroy, and resize events.

Using this strategy, replacing another table or list component with a SmartClient ListGrid can be as simple as \[loading\](#group-backgrounddownload) the framework and creating the ListGrid:

   isc.FileLoader.load(function() {
       isc.DataSource.load('User', function() {
           isc.ListGrid.create({dataSource: 'User', htmlElement: 'userGrid', matchElement: true});
       });
   });
 

A screen or even an entire project could be imported from \[Reify\](#group-reifyfordevelopers) and added in a similar fashion:

   const callback = (project, projects, rpcResponse) => {
       const screen = project.createStartScreen({
         htmlElement: 'userScreen'
       });
   };
   isc.FileLoader.load(function() {
     isc.Reify.loadProject('your-proj', callback, {userName: 'you', password: 'secret'});
   });
 

The \[Angular\](#group-angularintegration) documentation topic illustrates these points with a simple approach to integration of a ListGrid in that environment, but the same concepts apply to any existing web application, including those written in Angular, React, Vue, jQuery, Backbone, Svelte, etc.

---
## Attr: FormItem.linearEndRow

### Description
Specifies \[attr:FormItem.endRow\](#attr-formitemendrow) for an item in \[linearMode\](#attr-dynamicformlinearmode), overriding the default of `true` in that mode.

### Groups

- formLayout

**Flags**: IRW

---
## Attr: ButtonItem.enableWhen

### Description
Criteria to be evaluated to determine whether this item should be enabled. This property is incompatible with \[readOnlyWhen\](#attr-formitemreadonlywhen) and any setting you provide for the latter will be ignored if this property is set.

Criteria are evaluated against the ${isc.DocUtils.linkForRef('method:DynamicForm.getValues','form\\'s current values')} as well as the current \[rule context\](#attr-canvasrulescope). Criteria are re-evaluated every time form values or the rule context changes, whether by end user action or by programmatic calls.

A basic criteria uses textMatchStyle:"exact". When specified in \[Component XML\](#group-componentxml) this property allows \[shorthand formats\](#group-xmlcriteriashorthand) for defining criteria.

Note: A ButtonItem using enableWhen must have a \[name\](#attr-formitemname) defined. \[shouldSaveValue\](#attr-canvasitemshouldsavevalue) can be set to `false` to prevent the field from storing its value into the form's values.

### Groups

- ruleCriteria

**Flags**: IR

---
## Group: simpleNamesMode

### Description
When SmartClient runs in "simple names" mode (the default), all ISC Classes and several global methods are installed as JavaScript global variables, that is, properties of the browser's "window" object. When simple names mode is disabled (called "portal mode"), the framework uses only the global variable: "isc" and global variables prefixed with "isc\_".

Portal mode is intended for applications which must integrate with fairly arbitrary JavaScript code written by third-party developers, and/or third party JavaScript frameworks, where it is important that each framework stays within it's own namespace.

In portal mode, all references to ISC classes and global functions must be prefixed with "isc.", for example:

 
      Canvas.create(addProperties({}, myDefaults))

 

would become

      isc.Canvas.create(isc.addProperties({}, myDefaults));

 

Portal mode is enabled by setting `window.isc_useSimpleNames = false` 
#### before
 SmartClient is loaded, generally inside the <head> element.

---
## Attr: CubeGrid.canSelectHeaders

### Description
Determines whether row or column facetValue headers can be selected.

**Flags**: IRW

---
## Attr: DiscoverTreeSettings.typeProperty

### Description
Each discovered child is labeled with a configurable "typeProperty" set to the value of the property that held the children

**Flags**: IRW

---
## Method: Callbacks.RemoteWindowMapCallback

### Description
Callback reporting the result of a \[class:RemoteWindow\](#class-remotewindow) operation yielding a map.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| remoteWindow | [RemoteWindow](#type-remotewindow) | false | — | window affected |
| result | [Map](#type-map) | false | — | result |

---
## Attr: Calendar.otherDayBodyBaseStyle

### Description
The base name for the CSS class applied to the day body of the month view of the calendar. This style will have "Dark", "Over", "Selected", or "Disabled" appended to it according to the state of the cell.

See \[group:cellStyleSuffixes\](#group-cellstylesuffixes) for details on how stateful suffixes are combined with the base style to generate stateful cell styles.

### Groups

- appearance

**Flags**: IRW

---
## Attr: FormItemEventInfo.overInlineError

### Description
True if the event occurred over the form's \[single error item\](#attr-dynamicformerroritemproperties).

**Flags**: R

---
## Attr: DrawShapeCommand.args

### Description
The command arguments. The number of arguments and their types depend on this command's \[type\](#attr-drawshapecommandtype).

**Flags**: IR

---
## Method: TileGrid.getTitleField

### Description
Method to return the fieldName which represents the "title" for records in this Component.  
If this.titleField is explicitly specified it will always be used. Otherwise, default implementation will check \[attr:DataSource.titleField\](#attr-datasourcetitlefield) for databound compounds.  
For non databound components returns the first defined field name of `"title"`, `"name"`, or `"id"` where the field is visible. If we don't find any field-names that match these titles, the first field in the component will be used instead.

### Returns

`[String](#type-string)` — fieldName for title field for this component.

---
## Attr: ListGrid.checkboxFieldImageWidth

### Description
If \[attr:ListGrid.selectionAppearance\](#attr-listgridselectionappearance) is set to `"checkbox"` this property may be set to govern the width of the checkbox image displayed to indicate whether a row is selected. If unset, the checkboxField image will be sized to match the \[attr:ListGrid.booleanImageWidth\](#attr-listgridbooleanimagewidth) for this grid.

### Groups

- checkboxField

**Flags**: IR

---
## Attr: MockDSExportSettings.requestProperties

### Description
The properties that will be specified on the \[object:DSRequest\](#object-dsrequest) when fetching records. You can pass an array of different request properties matching the length of the `dsNames` param of \[classMethod:Reify.getMockDS\](#classmethod-reifygetmockds) or \[classMethod:Reify.showMockDS\](#classmethod-reifyshowmockds) if you want the fetch for each \[class:DataSource\](#class-datasource) made with different properties.

**Flags**: IR

---
## Attr: CoTTask.stateUpdates

### Description
Declarative mapping from \[StatePaths\](#type-statepath) to \[TaskInputExpressions\](#type-taskinputexpression), or just a single StatePath if the entire outputs object should be applied to a single path. When the task completes successfully (no validation errors), each mapping is applied to update \[attr:Process.state\](#attr-processstate). Shorthand: a String path means the entire outputs go to that path.

**Flags**: IR

---
## Attr: RPCRequest.useSimpleHttp

### Description
When set to true, assume the request is not going to the SmartClient server, and hence send a simple HTTP request that does not use SmartClient-specific request encoding.

Values specified in \[attr:RPCRequest.params\](#attr-rpcrequestparams) are sent to to the server as HTTP request parameters. If \[attr:RPCRequest.httpMethod\](#attr-rpcrequesthttpmethod) is "GET", parameters appear in the request URL, otherwise if httpMethod is "POST", parameters are encoded in the request body (exactly like an HTML form does). These parameters are then accessible via typical server-side APIs for retrieving HTTP parameters, eg, servletRequest.getParameter(paramName) in Java Servlets.

Note that if \[attr:RPCRequest.httpMethod\](#attr-rpcrequesthttpmethod) method is POST and \[attr:RPCRequest.data\](#attr-rpcrequestdata) is supplied, \[attr:RPCRequest.data\](#attr-rpcrequestdata) is assumed to be a string to post as the HTTP request body, and \[attr:RPCRequest.params\](#attr-rpcrequestparams) are sent as URL parameters instead. This usage is for sending custom request bodies such as the XML payloads used for SOAP. In this case, \[attr:RPCRequest.contentType\](#attr-rpcrequestcontenttype) is typically also set to indicate the content type of the request body.

Setting `useSimpleHttp` to true also automatically sets \[attr:RPCRequest.serverOutputAsString\](#attr-rpcrequestserveroutputasstring) to true as well.

**Flags**: IRWA

---
## Attr: SavedSearchEditor.cancelButton

### Description
Button used to cancel changes.

**Flags**: IR

---
## Method: Canvas.setAriaState

### Description
Set a specific \[ARIA state\](#attr-canvasariastate) for this component.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| stateName | [String](#type-string) | false | — | aria state to update |
| stateValue | [String](#type-string)|[Boolean](#type-boolean)|[Integer](#type-integer)|[Float](#type-float) | false | — | value for the aria state |

### Groups

- accessibility

---
## Attr: Calendar.showDateChooser

### Description
Determines whether the \[dateChooser\](#attr-calendardatechooser) is displayed.

### Groups

- visibility

**Flags**: IR

---
## Method: DrawCurve.setStartPoint

### Description
Update the startPoint

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| left | [Coordinate](#type-coordinate) | false | — | left coordinate for start point, in pixels |
| top | [Coordinate](#type-coordinate) | false | — | top coordinate for start point, in pixels |

---
## Attr: PaletteNode.icon

### Description
Icon for this paletteNode.

**Flags**: IR

---
## Method: ListGrid.hilitesChanged

### Description
Notification method executed whenever the end user uses the HiliteEditor to change the set of hilites applied to this grid. This method will not be called after a purely programmatic change to the hilites made with a call to \[setHilites()\](#method-databoundcomponentsethilites). The array of currently applied hilite objects is accessible via \[getHilites()\](#method-databoundcomponentgethilites).

### Groups

- hiliting

---
## Attr: FacetChart.zoomChartSlider

### Description
Slider controls shown on the mini-chart which is created when \[attr:FacetChart.canZoom\](#attr-facetchartcanzoom) is enabled.

### Groups

- zoom

**Flags**: IR

---
## Method: Progressbar.getLength

### Description
Returns the current width of a horizontal progressbar, or height of a vertical progressbar.

### Returns

`[Number](#type-number)` — the length of the progressbar

---
## Attr: ColumnTree.showOpenIcons

### Description
If true, show a different icon for `open` folders than closed folders. This is achieved by appending the \[attr:ColumnTree.openIconSuffix\](#attr-columntreeopeniconsuffix) onto the \[attr:ColumnTree.folderIcon\](#attr-columntreefoldericon) URL \[for example `"[SKIN]/folder.gif"` might be replaced by `"[SKIN]/folder_open.gif"`.  
#### Note
 If this property is set to `false` the same icon is shown for open folders as for closed folders, unless a custom folder icon was specified. This will be determined by \[attr:ColumnTree.folderIcon\](#attr-columntreefoldericon) plus the \[attr:ColumnTree.closedIconSuffix\](#attr-columntreeclosediconsuffix).

### Groups

- treeIcons

**Flags**: IRW

---
## Method: DetailViewer.fieldIsVisible

### Description
Check whether a field is currently visible

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| field | [String](#type-string)|[DetailViewerField](#type-detailviewerfield) | false | — | field to be checked |

### Returns

`[boolean](#type-boolean)` — true if the field is currently visible, false otherwise.

---
## Method: Tree.remove

### Description
Removes a node, along with all its children. See \["Modifying ResultTrees"\](#class-resulttree) when working with a `ResultTree` for limitations. Note, if this is a \[multi-link tree\](#method-treeismultilinktree), you must pass in a \[object:NodeLocator\](#object-nodelocator) rather than a node or id.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| node | [TreeNode](#type-treenode)|[String](#type-string)|[Integer](#type-integer)|[NodeLocator](#type-nodelocator) | false | — | node to remove, or the node's ID, or a NodeLocator |

### Returns

`[Boolean](#type-boolean)` — true if the tree was changed as a result of this call

---
## Object: NotifyAction

### Description
Represents an action that's associated with a message. Similar to the object form of \[type:Callback\](#type-callback), except a title must also be specified, which is rendered as a clickable link in the message (unless \[wholeMessage\](#attr-notifyactionwholemessage) is set).

### See Also

- [Notify.configureMessages](#classmethod-notifyconfiguremessages)

---
## Method: Canvas.dropOut

### Description
Executed when the dragged object is no longer over this drop target, including when the drag interaction is ending with a drop on this drop target. If you have set a visual indication in dropOver or dropMove, you should reset it to its normal state in dropOut.

### Returns

`[boolean](#type-boolean)` — false to prevent this event from bubbling to this widget's parent, true or undefined to bubble.

### Groups

- widgetEvents

### See Also

- [Canvas.getOffsetX](#method-canvasgetoffsetx)
- [Canvas.getOffsetY](#method-canvasgetoffsety)

**Flags**: A

---
## Method: Deck.removePane

### Description
Remove a pane from this deck.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| pane | [Canvas](#type-canvas) | false | — | pane to remove |

---
## Attr: ListGrid.canEdit

### Description
Can the user edit cells in this listGrid? Can be set for the listGrid, and overridden for individual fields.  
If 'canEdit' is false at the listGrid level, fields can never be edited - in this case the canEdit property on individual fields will be ignored.  
If 'canEdit' is set to true at the listGrid level, setting the 'canEdit' property to false at the field level will prevent the field from being edited inline unless a custom override of \[method:ListGrid.canEditCell\](#method-listgridcaneditcell) allows it.  
If 'canEdit' is not set at the listGrid level, setting 'canEdit' to true at the field level enables the field to be edited inline.

For more information on editing, see the \[editing overview\](#group-editing).

### Groups

- editing

### See Also

- [ListGrid.startEditing](#method-listgridstartediting)
- [ListGridField.canEdit](#attr-listgridfieldcanedit)
- [ListGrid.recordEditProperty](#attr-listgridrecordeditproperty)
- [ListGrid.canEditCell](#method-listgridcaneditcell)
- [ListGrid.fields](#attr-listgridfields)

**Flags**: IRW

---
## Method: ColorPicker.getBlue

### Description
Returns the Blue element of the currently-selected color, as an integer from 0-255

### Returns

`[int](#type-int)` — blue color component

### See Also

- [ColorPicker.setBlue](#method-colorpickersetblue)

---
## Attr: SetFilterItem.expandedPickListFields

### Description
If \[attr:SetFilterItem.canExpand\](#attr-setfilteritemcanexpand) is true, this is the list of fields to display in the \[interface:PickList\](#interface-picklist) or \[pickTree\](#attr-multipickeritempicktree) when the picker is expanded

**Flags**: IR

---
## Type: FormMethod

### Description
Form METHOD parameters - how the form fields are submitted to the server

### Values

| Value | Description |
|-------|-------------|
| DynamicForm.GET | GET request -- URL encoding (~4K max) |
| DynamicForm.POST | POST request -- separate field encoding (no max) |

### Groups

- submitting

---
## Method: Tree.getParents

### Description
Given a node, return an array of the node's ancestors, with the immediate parent first, then the grandparent, and so on. The node itself is not included in the result. For example, for the following tree:

 root
   foo
     bar
 

Calling `tree.getParents(bar)` would return: `[foo, root]`. Note that the returned array will contain references to the nodes, not the names.

Note, for reasons of backwards compatibility, if you pass this method a `TreeNode` instance on a \[multi-link tree\](#method-treeismultilinktree), it will return an array representing one path through the node's ancestors, which is unlikely to be useful. To get the ancestor chain of a specific node occurence, you must pass a \[object:NodeLocator\](#object-nodelocator) that specifies the full ID-based path to that occurence. If what you actually want is a list of the node's direct parents, see \[method:Tree.getMultiLinkParents\](#method-treegetmultilinkparents).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| node | [TreeNode](#type-treenode)|[NodeLocator](#type-nodelocator) | false | — | node in question, or a NodeLocator |

### Returns

`[Array](#type-array)` — array of node's parents

---
## Object: FiscalCalendar

### Description
An object representing the start date for fiscal years in the current locale.

A fiscal year spans a configurable date range - it may not exactly match a calendar year in length and it can start on any date within the calendar year and potentially end in the next calendar year.

Developers may specify explicit fiscal year start dates by adding \[object:FiscalYear\](#object-fiscalyear) objects to the \[fiscal years array\](#attr-fiscalcalendarfiscalyears). If none are provided, or if there is no entry for the given year, one is manufactured based on the default \[month\](#attr-fiscalcalendardefaultmonth) and \[date\](#attr-fiscalcalendardefaultdate).

---
## Method: DataSource.renameFile

### Description
Rename a file stored in this DataSource. Note, if \[automatic file versioning\](#attr-datasourcefileversionfield) is switched on for the dataSource, all versions of the file are renamed.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| oldFileSpec | [FileSpec](#type-filespec)|[String](#type-string) | false | — | Either a FileSpec, or a String which will be parsed to determine the fileName, fileType and fileFormat of the file to rename. For instance, "employees.ds.xml" would be parsed as {fileName: "employees", fileType: "ds", fileFormat: "xml"}. Depending on the configuration of the DataSource, the fileType and fileFormat may be optional. |
| newFileSpec | [FileSpec](#type-filespec)|[String](#type-string) | false | — | Either a FileSpec, or a String which will be parsed to determine the fileName, fileType and fileFormat to rename the file to. For instance, "employees.ds.xml" would be parsed as {fileName: "employees", fileType: "ds", fileFormat: "xml"}. If the fileType or fileFormat are not provided, then they will not be changed. |
| callback | [DSCallback](#type-dscallback) | true | — | Callback executed with the results. The `data` parameter is either an array of records represening the renamed file(s), or null to indicate an error. The records will have their `fileName` fields and `fileType` fields populated, but not the `fileContents` field. You can examine `[dsResponse.status](#attr-dsresponsestatus)` and `[dsResponse.data](#attr-dsresponsedata)` for additional information about any error. |

### Groups

- fileSource

---
## Attr: OperationBinding.outputs

### Description
Specifies, for this operationBinding only, the list of field names that should be returned to the client. Typically this will be a subset of the \[attr:DataSource.fields\](#attr-datasourcefields), but note that this is not a requirement; `outputs` can include fields that are not defined in the DataSource's field list. In this case, the server will return extra fields even if \[attr:DataSource.dropExtraFields\](#attr-datasourcedropextrafields) is true.

You specify this property as a string containing a comma-separated list of field names (eg, "foo, bar, baz")

Note that this setting overrides \[attr:DSRequest.outputs\](#attr-dsrequestoutputs) and \[attr:DataSourceField.outputWhen\](#attr-datasourcefieldoutputwhen) setting, meaning fields listed in operationBinding.outputs will be returned to the client regardless of those settings.

### See Also

- [DataSourceField.outputWhen](#attr-datasourcefieldoutputwhen)
- [DSRequest.outputs](#attr-dsrequestoutputs)

**Flags**: IR

---
## Class: Shuttle

### Description
Shuttle-style selection component allowing uses to select records by moving them from a set of source records to a set of target records

---
## Method: RelativeDateItem.setFiscalCalendar

### Description
Sets the \[object:FiscalCalendar\](#object-fiscalcalendar) object that will be used by this item's DateChooser. If unset, the \[global fiscal calendar\](#classmethod-dateutilgetfiscalcalendar) is used.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| fiscalCalendar | [FiscalCalendar](#type-fiscalcalendar) | true | — | the fiscal calendar for this chooser, if set, or the global one otherwise |

---
## Class: IconButton

### Description
A simple subclass of \[RibbonButton\](#class-ribbonbutton).

**Deprecated**

---
## Attr: MultiComboBoxItem.pickListConstructor

### Description
The Class to use when creating a picker of \[type "list"\](#attr-picklistdatasettype) for a FormItem. Must be a subclass of the builtin default, \[PickListMenu\](#class-picklistmenu).

### Groups

- pickList

**Flags**: IR

---
## Method: DataSource.recordsAreEqual

### Description
Convenience method to test if two records are equal. Testing is done only for the fields defined in the DataSource, anything else is ignored.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| record1 | [Any](#type-any) | false | — | record to be compared against. |
| record2 | [Any](#type-any) | false | — | record to be compared. |

### Returns

`[boolean](#type-boolean)` — true if the records are equal, false otherwise.

---
## Attr: StretchImgButton.autoFit

### Description
If true, ignore the specified size of this widget and always size just large enough to accommodate the title. If `setWidth()` is explicitly called on an autoFit:true button, autoFit will be reset to `false`.

Note that for StretchImgButton instances, autoFit will occur horizontally only, as unpredictable vertical sizing is likely to distort the media. If you do want vertical auto-fit, this can be achieved by simply setting a small height, and having overflow:"visible"

### Groups

- sizing

**Flags**: IRW

---
## Attr: StretchImgButton.definingProperty

### Description
This attribute denotes the name of a property to use as a \[getDefiningPropertyName()\](#method-canvasgetdefiningpropertyname) for this property when generating and resolving \[AutoTest locators with search segments\](#type-autotestlocator).

**Flags**: IRWA

---
## Method: List.getLength

### Description
Return the number of items in this list

### Returns

`[Number](#type-number)` — number of items in the list

### Groups

- access

---
## Attr: ToggleSwitch.thumbOffset

### Description
Spacing to apply inside of this ToggleSwitch, outside of the \[attr:ToggleSwitch.thumb\](#attr-toggleswitchthumb).

### Groups

- appearance

**Flags**: IRW

---
## Group: gridFiltering

### Description
This overview discusses various ways that \[search criteria\](#type-criteria) can be applied to a \[grid\](#class-listgrid) to filter the data being displayed.

Typically, there are two types of criteria that affect how a grid matches data:

*   Implicit criteria - hidden criteria, applied by the developer, to the \[grid\](#attr-listgridimplicitcriteria) or its \[dataSource\](#attr-datasourceimplicitcriteria), and never made available to users
*   Explicit criteria - public criteria, which may be applied by the developer or entered by the user - this criteria may be displayed to and modified by the user at runtime in various ways

A grid may have both implicit criteria, and explicit criteria that may come from multiple sources. When data is fetched, the implicit-criteria and any sources of \[explicit criteria\](#method-listgridgetcriteria) are \[combined\](#classmethod-datasourcecombinecriteria) and used to match records.

Note, however, that attempts to fetch with more restrictive criteria may not result in a server-trip, because \[class:ResultSet\](#class-resultset)s implement local filtering adaptively and may not require a server-trip if a filter can be achieved from local caches.

#### Initial Filter Criteria
You can provide an initial filter for a grid by setting \[implicit criteria\](#attr-listgridimplicitcriteria), which is never shown to the user, or \[initial criteria\](#attr-listgridinitialcriteria), which may be shown for editing in the grid's builtin \[filter-row\](#attr-listgridshowfiltereditor). You can also provide both types, if only some parts of the criteria should be public.
#### Filter Row Criteria
Grids provide a \[filter-row\](#attr-listgridfiltereditor) that allows users to apply search-values on a per-field basis. When \[attr:ListGrid.allowFilterOperators\](#attr-listgridallowfilteroperators) is true, the default, users can modify the \[search operator\](#object-operator) assigned to a given field via the grid's \[header context-menu\](#attr-listgridheadercontextmenu), allowing for more complex matching. If the selected operator is not the field's \[default operator\](#attr-listgridfieldfilteroperator), or if \[attr:ListGrid.alwaysShowOperatorIcon\](#attr-listgridalwaysshowoperatoricon) is true, the current operator is indicated in a small icon in each filter-field.

Developers can interact with a field's search operator with \[method:ListGrid.getFieldSearchOperator\](#method-listgridgetfieldsearchoperator), \[method:ListGrid.setFieldSearchOperator\](#method-listgridsetfieldsearchoperator) and \[method:ListGrid.clearFieldSearchOperator\](#method-listgridclearfieldsearchoperator).

Criteria in the filter-row reflects current public criteria that \[can be edited\](#method-formitemcaneditcriterion). Developers can retrieve this criteria with \[method:ListGrid.getFilterEditorCriteria\](#method-listgridgetfiltereditorcriteria) and set it with \[method:ListGrid.setFilterEditorCriteria\](#method-listgridsetfiltereditorcriteria). When the filter-row is showing, Calls to APIs such as \[method:ListGrid.setCriteria\](#method-listgridsetcriteria) or \[method:ListGrid.fetchData\](#method-listgridfetchdata) will apply criteria to the filter-row, if the editors there allow it. Any criteria applied by these methods, that cannot be edited by the associated field's filter-editor, are still applied to fetches and will be returned by calls to \[method:ListGrid.getCriteria\](#method-listgridgetcriteria) or \[method:ListGrid.getFilterEditorCriteria\](#method-listgridgetfiltereditorcriteria), but are not shown to the user for editing.

Developers may specify a field's \[filterEditor-type\](#attr-listgridfieldfiltereditortype), and this can be a custom \[class:FormItem\](#class-formitem) class that uses \[getCriterion()\](#method-formitemgetcriterion), \[setCriterion()\](#method-formitemsetcriterion) and \[canEditCriterion()\](#method-formitemcaneditcriterion) to manage the criteria it works with.

For more complicated cases or more control, developers can implement \[method:ListGrid.filterEditorSubmit\](#method-listgridfiltereditorsubmit).

Criteria from the filter-row is combined with other sources of criteria when data is fetched.

#### External Criteria
If you have external logic, or a \[form\](#class-searchform) outside of the grid, that produces criteria, you can apply the criteria by passing it to \[fetchData\](#method-listgridfetchdata) or \[filterData\](#method-listgridfilterdata). The primary difference between these two APIs is that `filterData` applies a \[attr:DSRequest.textMatchStyle\](#attr-dsrequesttextmatchstyle) of _substring_, so that records are matched by case-insensitive substring comparison.

If you have the `FilterEditor` showing, these external criteria will be appear in the filterEditor, where supported. Developers can apply additional external criteria without that effect by passing them to \[method:DataBoundComponent.setImplicitCriteria\](#method-databoundcomponentsetimplicitcriteria), or by setting \[attr:ListGrid.searchForm\](#attr-listgridsearchform) to the external criteria form.

If you need more power or variance than the filter-row provides, you can set \[attr:ListGrid.allowFilterWindow\](#attr-listgridallowfilterwindow) to show a full-blown \[class:FilterBuilder\](#class-filterbuilder), to construct more complex criteria that can also include logical operators like _or_.

All sources of criteria are combined to match records when data is fetched.

#### Saving Criteria
Grid criteria can be saved and restored with \[view-state\](#method-listgridgetviewstate) and via the \[class:SavedSearches\](#class-savedsearches) feature, which is turned on by default.

---
## Attr: FormValidateValuesTask.passThruOutput

### Description
Does this processElement pass through output from the last executed task (i.e. transient state)?

See \[taskInputExpressions\](#type-taskinputexpression) for details on the transient state outputs.

Note that this property does not affect the task at all but is an indicator to the user and to the workflow editor of the behavior of the task as coded (See \[method:Process.passThruTaskOutput\](#method-processpassthrutaskoutput)).

**Flags**: IR

---
## Group: loadDMIStubsTag

### Description
See \[group:jspTags\](#group-jsptags)

_produces:_ JavaScript

Creates global bindings for all serverObjects defined in the `rpcBindings` section of the .app.xml file specified by the `ID` or `name` attribute of this tag. Once you've loaded your `rpcBindings` using this tag, you can call methods on the `ServerObjects` defined there directly. For example, you can load the example.app.xml (located in /shared/app directory of the webRoot of the SDK) like this:

 <isomorphic:loadDMIStubs ID="example"/>
 

Whereas using \[classMethod:DMI.call\](#classmethod-dmicall) you would have had to invoke the `getTimeStamp` method like this:

 DMI.call("example", "GetTimeStampDMI", "getTimeStamp", new Date(), "alert(data)";
 

Having loaded the stubs of the `example` .app.xml, you can then call `getTimeStamp` like this:

 GetTimeStampDMI.getTimeStamp(new Date(), "alert(data)");
 

or this:

 GetTimeStampDMI.getTimeStamp({
     arguments: \[new Date()\],
     callback: "alert(data)"
 });
 

or this:

 GetTimeStampDMI.call({
     methodName: "getTimeStamp",
     arguments: \[new Date()\],
     callback: "alert(data)"
 });
 

As with \[classMethod:DMI.call\](#classmethod-dmicall), the last argument must be the callback - if you don't want a callback, simply specify `null` as the callback. The name of the global binding created will be the same as the \[attr:ServerObject.ID\](#attr-serverobjectid) or the non-qualified name of the \[attr:ServerObject.className\](#attr-serverobjectclassname) (java namespace, if any, will be stripped).

#### Tag Attributes:

#### ID or name
  
_value format_: String - name of .app.xml file to load (minus the .app.xml extension)  
_default value_: NONE

This attribute specifies the name of the file that contains the rpcBindings to load. UI files are located in `[webroot]/shared/app` by default. This location is changeable in \[\[webroot\]/WEB-INF/classes/server.properties\](#group-server-properties) by setting the config parameter `project.apps` to the directory where your .app.xml files are located. We recommend that for prototyping, at least, you use the default directory.

### See Also

- [DMI](#class-dmi)

---
## Attr: ListGridField.showDownIcon

### Description
If using an icon for this button, whether to switch the icon image when the mouse goes down on the button.

### Groups

- buttonIcon

### See Also

- [ListGridField.icon](#attr-listgridfieldicon)

**Flags**: IR

---
## Attr: FormItem.validateOnChange

### Description
If true, form items will be validated when each item's "change" handler is fired as well as when the entire form is submitted or validated.

Note that this property can also be set at the form level or on each validator; If true at the form or field level, validators not explicitly set with `validateOnChange:false` will be fired on change - displaying errors and rejecting the change on validation failure.

### Groups

- changeHandling

### See Also

- [DynamicForm.validateOnChange](#attr-dynamicformvalidateonchange)

**Flags**: IRW

---
## Method: StretchImgButton.addToRadioGroup

### Description
Add this widget to the specified mutually exclusive selection group with the ID passed in. Selecting this widget will then deselect any other StatefulCanvases with the same radioGroup ID. StatefulCanvases can belong to only one radioGroup, so this method will remove from any other radiogroup of which this button is already a member.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| groupID | [String](#type-string) | false | — | \- ID of the radiogroup to which this widget should be added |

### Groups

- state
- event handling

---
## Attr: DrawItem.knobs

### Description
Array of control knobs to display for this item. Each \[type:KnobType\](#type-knobtype) specified in this array will turn on UI element(s) allowing the user to manipulate this drawItem. To update the set of knobs at runtime use \[method:DrawItem.showKnobs\](#method-drawitemshowknobs) and \[method:DrawItem.hideKnobs\](#method-drawitemhideknobs).

#### NOTE:
 Unless otherwise documented, DrawItem types only support "resize" and "move" knobs.

**Flags**: IR

---
## ClassMethod: DataSource.getDataSource

### Description
Lookup a DataSource by ID.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| ID | [GlobalId](#type-globalid) | false | — | DataSource ID |

### Returns

`[DataSource](#type-datasource)` — the DataSource with this ID, if loaded, otherwise null.

---
## Attr: DataBoundComponent.initialCriteria

### Description
Criteria to be used when \[attr:DataBoundComponent.autoFetchData\](#attr-databoundcomponentautofetchdata) is set.

This property supports \[group:dynamicCriteria\](#group-dynamiccriteria) - use \[attr:Criterion.valuePath\](#attr-criterionvaluepath) to refer to values in the \[attr:Canvas.ruleScope\](#attr-canvasrulescope).

**Flags**: IR

---
## Attr: FormItem.hint

### Description
Specifies "hint" string to show next to the form item to indicate something to the user. This string generally appears to the right of the form item.

### Groups

- appearance

### See Also

- [FormItem.hintStyle](#attr-formitemhintstyle)

**Flags**: IRW

---
## Type: SQLPagingStrategy

### Description
The technique SmartClient Server's SQL DataSource should use to select a "page" of data from a table.

### Values

| Value | Description |
|-------|-------------|
| "sqlLimit" | Specify the paging directly in the SQL query we generate. The way this is done varies considerably from database to database: with some it is a straightforward built-in facility while others require arcane tricks or simply don't support the idea. This is the most efficient method, where available. Note that this strategy is not supported for operations that make use of a \[customSQL\](#attr-operationbindingcustomsql) clause, because it depends upon being able to determine the size of the whole dataset without actually retrieving the whole dataset. Ordinary operations do this by means of an automatically-generated "row count query", but we cannot generate such a query for a `customSQL` operation. |
| "jdbcScroll" | Implement the paging behavior by use of the `absolute()` method of the JDBC `ResultSet`. |
| "dropAtServer" | Implement the paging behavior by fetching the entire resultset from the database and dropping any unnecessary rows on the server before returning the data to the client. This approach is extremely inefficient, but also extremely straightforward; it is intended as a fallback option, for situations where the more sophisticated approaches cause problems (a JDBC driver that throws vague exceptions when `absolute()` is called, for example) |
| "none" | No paging behavior: we always return the entire resultset to the client. |

### See Also

- [DataSource.sqlPaging](#attr-datasourcesqlpaging)
- [OperationBinding.sqlPaging](#attr-operationbindingsqlpaging)

---
## Attr: FormulaBuilder.titleField

### Description
TextItem that allows users to set the title for this field.

### Groups

- formulaFields

**Flags**: IR

---
## ClassMethod: Canvas.setAutoResizeAutoChildAttributes

### Description
Should registered autoChild attributes be automatically resized with \[controls\](#classmethod-canvasresizecontrols) and \[text\](#classmethod-canvasresizefonts)?

If true, attributes registered for resize with policy `"controls"` will be resized when `resizeControls()` runs, and icons registered with policy `"fonts"` will resize when `resizeFonts()` runs.

To resize autoChild attributes with other policies, developers should call \[classMethod:Canvas.resizeAutoChildAttributes\](#classmethod-canvasresizeautochildattributes) directly

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| autoResize | [boolean](#type-boolean) | false | — | true if attributes should be auto-resized |

---
## Attr: FacetChart.radarRotateLabels

### Description
This property controls whether to rotate the labels on the \[data label facet\](#method-facetchartgetdatalabelfacet) of radar or \[attr:FacetChart.stacked\](#attr-facetchartstacked) pie charts so that each label is parallel to its radial gradation (these are the labels that appear around the perimeter). For now, "auto" means the same thing as "always" - but this may change in the future if heuristics are added to determine when the affected labels are likely to overlap and not be legible. If rotateLabels is "never" then the labels will not be rotated.

### Groups

- labelsAndTitles

### See Also

- [FacetChart.rotateLabels](#attr-facetchartrotatelabels)
- [FacetChart.radialLabelOffset](#attr-facetchartradiallabeloffset)

**Flags**: IR

---
## Class: Notify

### Description
Notify provides a means to display on-screen messages that are automatically dismissed after a configurable amount of time, as an alternative to \[modal notification\](#staticmethod-iscconfirm) dialogs that can lower end user productivity. Messages may be shown at a particular location, specified either with viewport-relative coordinates, or as an edge or center location relative to the viewport or a canvas. Messages can be configured to appear and disappear instantly, by sliding into (or out of) view, or by fading in (or out).

One or more \[actions\](#object-notifyaction) can be provided when \[addMessage()\](#classmethod-notifyaddmessage) is called to display a message. They will be rendered as links on which to click to execute the action.

The behavior and appearance of messages are configured per \[type:NotifyType\](#type-notifytype), which is simply a string that identifies that message group, similar to \[log category\](#method-classlogwarn). By calling \[configureMessages()\](#classmethod-notifyconfiguremessages) with the `NotifyType`, it can be assigned a \[object:NotifySettings\](#object-notifysettings) configuration to control message animation, placement, and the the \[class:Label\](#class-label) used to render each message, allowing styling and autofit behavior to be configured.

Messages of the same `NotifyType` may be stacked to provide a visible history, with a configurable stacking direction and maximum stacking depth. Details on how to configure messages are provided in the documentation for \[object:NotifySettings\](#object-notifysettings).

Messages for different `NotifyType`s are stacked separately and animated by independent Framework pipelines. It's up to you to configure the placement of supported `NotifyType`s in your app so that they don't overlap, as the Framework doesn't manage it. For example, separate `NotifyType`s could be assigned separate screen edges, or assigned a different \[attr:NotifySettings.positionCanvas\](#attr-notifysettingspositioncanvas).

To dismiss a message manually before its scheduled duration expires, you may call \[dismissMessage()\](#classmethod-notifydismissmessage) with a `NotifyType` (to dismiss all such messages) or an ID previously returned by \[addMessage()\](#classmethod-notifyaddmessage) (to dismiss that single message).

#### Warnings and Errors

Each notification may be assigned a \[messagePriority\](#attr-notifysettingsmessagepriority) in the settings passed to \[addMessage()\](#classmethod-notifyaddmessage). By default, all `NotifyType`s are configured to have priority \[classAttr:Notify.MESSAGE\](#classattr-notifymessage), except for "error" and "warn" `NotifyType`s, which are configured with priority \[classAttr:Notify.ERROR\](#classattr-notifyerror) and \[classAttr:Notify.WARN\](#classattr-notifywarn), respectively.

The \[messagePriority\](#attr-notifysettingsmessagepriority) determines the default styling of a message, and which message to remove if a new message is sent while the message stack is already at its limit. We recommended applying a \[messagePriority\](#attr-notifysettingsmessagepriority) as the best approach for showing pre-styled warnings and errors, since that allows you to interleave them with ordinary messages in a single `NotifyType`.

Alternatively, you can display pre-styled warnings and errors by calling \[addMessage()\](#classmethod-notifyaddmessage) with the separate `NotifyType`s "warning" and "error", respectively, but then you must take care to \[assign each NotifyType\](#classmethod-notifyconfiguremessages) used to a separate screen location to avoid one rendering on top of the other.

#### Viewport Considerations

Messages are edge or corner-aligned based on the \[viewport width\](#classmethod-pagegetscrollwidth) and \[viewport height\](#classmethod-pagegetscrollheight) of the current page rather than screen, so you may need to scroll to see the targeted corner or edge. Note that widgets placed offscreen below or to the right of a page may cause the browser to report a larger viewport, and prevent messages from being visible, even if no scrollbars are present. If you need to stage widgets offscreen for measurement or other reasons, place them above or to the left.

#### Modal Windows and Click Masks

Messages are always shown above all other widgets, including \[modal windows\](#attr-windowismodal) and \[click masks\](#method-canvasshowclickmask). This is because it's expected that messages are "out of band" and logically indepedent of the widget hierarchy being shown. We apply this layering policy even for windows and widgets created by \[object:NotifyAction\](#object-notifyaction)s. If there may a scenario where a message can block a window created by an action, set \[attr:NotifySettings.canDismiss\](#attr-notifysettingscandismiss) to true so that an unobstructed view of the underlying widgets can be restored.

In the linked sample, note how we take care to reuse the existing modal window, if any, if the "Launch..." link is clicked, so that repeated clicks never stack windows over each other.

### See Also

- [isc.say](#staticmethod-iscsay)
- [isc.confirm](#staticmethod-iscconfirm)

---
## Attr: NavPanel.navGrid

### Description
The \[class:TreeGrid\](#class-treegrid) used to display \[object:NavItem\](#object-navitem)s.

**Flags**: IR

---
## Attr: ListGrid.groupTitleField

### Description
When a list grid is \[grouped\](#method-listgridgroupby), each group shows under an auto generated header node. By default the title of the group will be shown, with a hanging indent in this node, and will span all columns in the grid. Setting this property causes the titles of auto-generated group nodes to appear as though they were values of the designated field instead of spanning all columns and record values in the designated groupTitleField will appear indented under the group title in a manner similar to how a TreeGrid shows a Tree.

Note if \[attr:ListGrid.showGroupSummaryInHeader\](#attr-listgridshowgroupsummaryinheader) is true, the header nodes will not show a single spanning title value by default - instead they will show the summary values for each field. In this case, if groupTitleField is unset, a \[groupTitleColumn\](#attr-listgridshowgrouptitlecolumn) can be automatically generated to show the title for each group.

### Groups

- grouping

### See Also

- [ListGrid.groupBy](#method-listgridgroupby)

**Flags**: IR

---
## Attr: DataBoundComponent.reapplyingAsyncFilterAndSortMessage

### Description
The HTML-format message displayed to users while asynchronous filters are being re-evaluated on a list of records.

### Groups

- i18nMessages

**Flags**: IRW

---
## ClassAttr: Operators.notStartsWithTitle

### Description
Title for the "notStartsWith" operator

### Groups

- i18nMessages

**Flags**: IR

---
## ClassMethod: DataSource.flattenCriteria

### Description
Returns new criteria that has at most one top-level LogicalOperator ("and" or "or"). This new criteria will be considered "flat" by \[classMethod:DataSource.isFlatCriteria\](#classmethod-datasourceisflatcriteria).

Not all AdvancedCriteria can be flattened and remain logically equivalent. When criteria will be logically modified by flattening, all criteria that appear anywhere in the AdvancedCriteria structure will appear under a single top-level operator, which will be the same top-level operator as the passed AdvancedCriteria.

For example, given criteria like this (in the JSON representation of AdvancedCriteria):

      { operator: "and", criteria: \[
         { fieldName: "continent", operator: "equals", value: "Europe"},
         { operator: "or", criteria: \[
            { fieldName: "countryName", operator: "iEndsWith", value: "land"},
            { fieldName: "population", operator: "lessThan", value: 3000000}
         \]}
        \]
      }
 

The returned criteria would be:

      { operator: "and", criteria: \[
         { fieldName: "continent", operator: "equals", value: "Europe"},
         { fieldName: "countryName", operator: "iEndsWith", value: "land"},
         { fieldName: "population", operator: "lessThan", value: 3000000}
       \]}
 

This returned criteria is not logically equivalent to the passed criteria - the "iEndsWith" and "lessThan" criteria that were formerly nested under a logical "or" operator must now _both_ be satisfied instead of _either_ being satisfied. You can use \[classMethod:DataSource.canFlattenCriteria\](#classmethod-datasourcecanflattencriteria) to detect whether an AdvancedCriteria is going to be changed by `flattenCriteria()`.

Because the returned criteria may not be logically equivalent, `flattenCriteria` should not be used as a means of simplifying criteria to make server implementation easier or anything of the kind. The primary purpose of returning logically different criteria is to enable an end user to switch from an interface for editing nested criteria to an interface that can't handle nested criteria and convert the criteria while preserving as much as possible.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| criteria | [AdvancedCriteria](#type-advancedcriteria) | false | — | the AdvancedCriteria to flatten |

### Returns

`[AdvancedCriteria](#type-advancedcriteria)` — flattened criteria

---
## Attr: OperationBinding.dataTransport

### Description
Transport to use for this operation. Defaults to \[attr:DataSource.dataTransport\](#attr-datasourcedatatransport), which in turn defaults to \[classAttr:RPCManager.defaultTransport\](#classattr-rpcmanagerdefaulttransport). This would typically only be set to enable "scriptInclude" transport for contacting \[JSON\](#attr-datasourcedataformat) web services hosted on servers other than the origin server.

When using the "scriptInclude" transport, be sure to set \[attr:DataSource.callbackParam\](#attr-datasourcecallbackparam) or \[attr:OperationBinding.callbackParam\](#attr-operationbindingcallbackparam) to match the name of the query parameter name expected by your JSON service provider.

### Groups

- clientDataIntegration

### See Also

- [RPCTransport](#type-rpctransport)
- [DataSource.callbackParam](#attr-datasourcecallbackparam)

**Flags**: IR

---
## Method: TreeGrid.openFolder

### Description
Opens a folder.

Executed when a folder node receives a 'doubleClick' event. If you override this method, the single parameter passed will be a reference to the relevant folder node in the tree's data.

See the ListGrid Widget Class for inherited recordClick and recordDoubleClick events.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| node | [TreeNode](#type-treenode) | false | — | node to open |
| path | [String](#type-string) | true | — | optional parameter containing the full path to the node. This is essential context for a \[multi-link tree\](#attr-treemultilinktree), but is not required in ordinary trees |

### See Also

- [TreeGrid.closeFolder](#method-treegridclosefolder)
- [TreeGrid.folderOpened](#method-treegridfolderopened)
- [ListGrid](#class-listgrid)

**Flags**: A

---
## Attr: Tour.tourWizardShowProgressTitle

### Description
Title for the _Show Progress_ picker in the Tour Wizard.

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: DrawImage.top

### Description
Top coordinate in pixels relative to the \[local coordinate system\](#class-drawpane).

**Flags**: IRW

---
## Attr: FacetChart.canZoom

### Description
Enables "zooming" on the X axis, specifically, only a portion of the overall dataset is shown in the main chart, and a \[second smaller chart\](#attr-facetchartzoomchart) appears with slider controls allowing a range to be selected for display in the main chart.

A \[labelCollapseMode\](#attr-facetchartlabelcollapsemode) is automatically enabled if unset and is based on the type of the first non-null data value.

### Groups

- zoom

**Flags**: IR

---
## Attr: SavedSearchItem.editProxyConstructor

### Description
Default class used to construct the \[class:EditProxy\](#class-editproxy) for this component when the component is \[first placed into edit mode\](#method-canvasseteditmode).

**Flags**: IR

---
## Class: SectionHeader

### Description
Simple SectionHeader class based on a Label with an icon, skinnable via CSS.

---
## Attr: RestDataSource.dataURL

### Description
Default URL to contact to fulfill all DSRequests. RestDataSources also allow per-operationType dataURLs to be set via

*   \[attr:RestDataSource.fetchDataURL\](#attr-restdatasourcefetchdataurl)
*   \[attr:RestDataSource.addDataURL\](#attr-restdatasourceadddataurl)
*   \[attr:RestDataSource.updateDataURL\](#attr-restdatasourceupdatedataurl)
*   \[attr:RestDataSource.removeDataURL\](#attr-restdatasourceremovedataurl)

#### NOTE:
: when using \[queuing\](#classmethod-rpcmanagerstartqueue) with RestDataSource, an HTTP request containing mixed \[operationTypes\](#attr-dsrequestoperationtype) (such as a mixture of "add", "update" and "remove" operations resulting from \[Grid Mass Editing\](#attr-listgridautosaveedits)) can only go to one URL, so you should not set distinct URLs for each `operationType`; doing so will break queuing of mixed operationTypes: multiple requests will be sent to distinct URLs, and a warning logged.

**Flags**: IR

---
## Attr: DynamicForm.canTabToIcons

### Description
Should users be able to tab into the \[icons\](#attr-formitemicons) and \[picker icon\](#attr-formitemshowpickericon) for items within this form by default?

May be overridden at the item level by \[attr:FormItem.canTabToIcons\](#attr-formitemcantabtoicons).

Developers may also suppress tabbing to individual icons by setting \[attr:FormItemIcon.tabIndex\](#attr-formitemicontabindex) to `-1`.

### Groups

- formIcons

**Flags**: IRWA

---
## Attr: HTMLPane.contentsURL

### Description
If specified the HTMLFlow will load its contents from this URL instead of displaying \[this.contents\](#attr-htmlpanecontents). May be combined with parameters if \[attr:HTMLPane.contentsURLParams\](#attr-htmlpanecontentsurlparams) were specified.

The HTML retrieved from the target URL may be a complete standalone page to be rendered into its own scope using an IFRAME, or a fragment of HTML to display within this component's handle. See \[type:ContentsType\](#type-contentstype) and \[attr:HTMLPane.autoDeriveContentsType\](#attr-htmlpaneautoderivecontentstype) for more information.

Note that the link{loadingMessage} and \[httpMethod\](#attr-htmlflowhttpmethod) features only apply if contentsURL was set and contentsType was not explicitly set to `"page"`

### Groups

- contentLoading

**Flags**: IRW

---
## Attr: ColorPicker.lessButtonTitle

### Description
The title for the button that switches to a less complex view.

### Groups

- i18nMessages

**Flags**: IR

---
## Object: CreateScreenSettings

### Description
Controls what class and instance substitutions, if any, are applied during a call to \[classMethod:RPCManager.createScreen\](#classmethod-rpcmanagercreatescreen). Classes and instances can be mapped (constructed as) other classes, and existing widget instances can be returned for new ones.

### See Also

- [CreateScreenSettings.classSubstitutions](#attr-createscreensettingsclasssubstitutions)
- [CreateScreenSettings.componentSubstitutions](#attr-createscreensettingscomponentsubstitutions)

---
## Method: ImgButton.setActionType

### Description
Update the 'actionType' for this canvas (radio / checkbox / button) If the canvas is currently selected, and the passed in actionType is 'button' this method will deselect the canvas.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| actionType | [SelectionType](#type-selectiontype) | false | — | new action type |

### Groups

- state
- event handling

---
## Method: String.pluralize

### Description
Given a number, this method will return the plural version of the string if appropriate.

The plural value will be derived from \[classAttr:String.pluralNounMap\](#classattr-stringpluralnounmap) if present, otherwise the plural value will be created by adding a lower or upper case `"s"` character to the string.

### Returns

`[String](#type-string)` — plural version of the string

---
## Attr: CubeGrid.showHoverTipsTitle

### Description
Title for the show hover tips menu item.

### Groups

- i18nMessages

**Flags**: IRW

---
## Method: RPCRequest.xhr_onProgress

### Description
Progress event notification fired repeatedly during requests with \[attr:RPCRequest.transport\](#attr-rpcrequesttransport) set to `"xmlHttpRequest"`.

This callback will be invoked from the native [XMLHttpRequest progress event](https://developer.mozilla.org/en-US/docs/Web/API/XMLHttpRequest/progress_event).

This is typically useful to provide visual feedback to the user when a lengthy download is in progress.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| progressEvent | [Object](#type-object) | false | — | The native [ProgressEvent](https://developer.mozilla.org/en-US/docs/Web/API/ProgressEvent) with attributes indicating the `loaded` content so far, and, if `Content-Length` headers were set on the response, the `total` download size. Note that this is a native event produced by the browser and SmartClient does not guarantee consistency for the event object, or the timing of the `onprogress` event notifications across browsers. |
| request | [RPCRequest](#type-rpcrequest) | false | — | the request that initiated the download |

---
## Attr: PickList.showAllOptions

### Description
If true, even non-matching options will be shown, with configurable \[separator rows\](#attr-picklistseparatorrows) in between. Not valid for \[databound pickLists\](#attr-picklistoptiondatasource).

**Flags**: IR

---
## Attr: Shuttle.sortDirection

### Description
\[Sort direction\](#attr-listgridsortdirection) for this item's list of options. Will be applied to \[attr:Shuttle.sourceGrid\](#attr-shuttlesourcegrid) and \[attr:Shuttle.targetGrid\](#attr-shuttletargetgrid). To specify initial sort for each grid separately, these properties may be set per grid using the standard \[autoChild pattern\](#type-autochild).

**Flags**: IR

---
## Attr: RichTextEditor.toolbar

### Description
Layout used to contain each of the \[attr:RichTextEditor.controlGroups\](#attr-richtexteditorcontrolgroups).

**Flags**: R

---
## Attr: FacetChart.showDataValuesMode

### Description
Strategy for determining whether and when to show data-values - either in the chart, near the shape representing a value (above columns of a column chart for example, or adjacent to points in a line chart), in hovers, or some combination of both, including \[automatic rotation\](#attr-facetchartrotatedatavalues) where supported.

Depending on the chart type, there are different options for showing data-values - eg, \[stacked-charts\](#attr-facetchartstacked) cannot show values inline in the chart-body; column-charts can, and they can rotate titles if they're wider than their columns; pie charts can show some data-values in the chart but not others; all the types can show values in hovers.

If set to _never_, then data-values will never be shown; _inChartOnly_ allows data-values in the chart-body, where supported and where they will fit, but suppresses them in hovers and _inHoverOnly_ always shows all data-values in hovers.

If set to _auto_, first try to show values in the chart, where the chart-type supports it, and where they'll fit. If they don't all fit, show the ones that do, including rotating them if necessary, if the chart-type allows it, and then switch on hovers as well, as needed. This mode is particularly useful in situations where the chart-type can be changed by the user.

### Groups

- labelsAndTitles

**Flags**: IRW

---
## Method: Slider.setMaxValueLabel

### Description
Sets the \[attr:Slider.maxValueLabel\](#attr-slidermaxvaluelabel) property of the slider

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| labelText | [String](#type-string) | false | — | new label text |

---
## Attr: LoadProjectSettings.currentScreenName

### Description
The name of the screen within the project to return first when loading. A null value means to use the currentScreenName as specified in the project file.

This setting only affects the first project specified in the `projectNames` argument to \[classMethod:RPCManager.loadProject\](#classmethod-rpcmanagerloadproject).

**Flags**: IRW

---
## Attr: Calendar.indicatorCanvas

### Description
AutoChild component created for each \[indicator\](#attr-calendarindicators) entry.

**Flags**: A

---
## Attr: TextItem.escapeHTML

### Description
By default HTML characters will be escaped when \[canEdit\](#attr-formitemcanedit) is false and \[readOnlyDisplay\](#attr-formitemreadonlydisplay) is "static", so that the raw value of the field (for example `"<b>AAA</b>"`) is displayed to the user rather than the interpreted HTML (for example `" #### AAA "`). Setting `escapeHTML` false will instead force HTML values in a textItem to be interpreted by the browser in that situation.

### Groups

- appearance

**Flags**: IRW

---
## Attr: TextItem.maskOverwriteMode

### Description
During entry into a \[masked field\](#attr-textitemmask), should keystrokes overwrite current position value? By default new keystrokes are inserted into the field.

**Flags**: IRWA

---
## Attr: RichTextEditor.backgroundColorPrompt

### Description
The prompt for the built-in \[backgroundColor\](#type-controlname) control.

### Groups

- i18nMessages

**Flags**: IRW

---
## ClassAttr: StatefulCanvas.SELECTED

### Description
A declared value of the enum type \[Selected\](#type-selected).

**Flags**: R

---
## ClassAttr: DateItem.MONTH_YEAR

### Description
A declared value of the enum type \[DateItemSelectorFormat\](#type-dateitemselectorformat).

**Flags**: R

---
## Method: ListGrid.getDataSource

### Description
The DataSource that this component should bind to for default fields and for performing \[DataSource requests\](#object-dsrequest).

### Returns

`[DataSource](#type-datasource)` — Datasource object for this ListGrid instance.

---
## Attr: SavedSearchForm.markAsDefaultHoverText

### Description
If set this property will override \[attr:SavedSearchItem.markAsDefaultHoverText\](#attr-savedsearchitemmarkasdefaulthovertext) on the automatically generated \[class:SavedSearchItem\](#class-savedsearchitem).

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: SectionStack.closeSectionIconSize

### Description
Pixel width/height for the \[attr:SectionStack.closeSectionIcon\](#attr-sectionstackclosesectionicon).

**Flags**: IR

---
## ClassMethod: EventHandler.rightButtonDown

### Description
Returns true if the right mouse button is being pressed.

### Returns

`[Boolean](#type-boolean)` — true == right button is down, false == up

### Groups

- mouseEvents

### See Also

- [EventHandler.leftButtonDown](#classmethod-eventhandlerleftbuttondown)
- [EventHandler.middleButtonDown](#classmethod-eventhandlermiddlebuttondown)

---
## Attr: ImgProperties.imgDir

### Description
Specifies the image-specific image directory to override the default.

**Flags**: IRW

---
## Attr: MultiFileItem.pickerAddAnotherFileButtonTitle

### Description
The contents of the "Add another" file button in the picker launched by the \[edit button\](#attr-multifileitemeditbutton).

### Groups

- i18nMessages

**Flags**: IR

---
## Method: GridRenderer.getCellElementId

### Description
Get the DOM ID that should be used for a cell element if \[screen reader mode\](#staticmethod-iscsetscreenreadermode) is enabled or \[attr:GridRenderer.writeOutRowElementId\](#attr-gridrendererwriteoutrowelementid) is true.

Note that for integration with automated testing tools, we recommend using \[classMethod:AutoTest.getLocator\](#classmethod-autotestgetlocator) and \[classMethod:AutoTest.getElement\](#classmethod-autotestgetelement) to identify specific elements within the DOM wherever possible. These are more robust than simple cell locators as they can identify the DOM element representing a specific data elements using primary key and other approaches rather than relying on the generated DOM structure.

When using incremental rendering, the `rowNum` and `colNum` params represents virtual coordinates, and the `physicalRowNum` param represents the index that the row/cell will ultimately have in table.rows or row.cells.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| rowNum | [number](#type-number) | false | — | #### virtual
 row number |
| physicalRowNum | [number](#type-number) | false | — | #### physical
 row number |
| colNum | [number](#type-number) | false | — | #### virtual
 col number |
| physicalColNum | [number](#type-number) | false | — | #### physical
 col number |

### Returns

`[String](#type-string)` — ID for the cell element. This should be unique within the DOM.

**Flags**: A

---
## Attr: DataSourceField.relatedTableAlias

### Description
For a \[SQL DataSource\](#group-sqldatasource) field that specifies a \[foreignKey\](#attr-datasourcefieldforeignkey), this property defines the table alias name to use in generated SQL.

Aliasing is necessary when the same table appears more than once in a query. This can happen when using \[Multiple `includeFrom` \\n fields referring to the same related DataSource\](#attr-datasourcefieldincludevia). It can also happen when a \[foreignKey\](#attr-datasourcefieldforeignkey) definition references the same dataSource that the field is defined in; this happens with hierarchical structures, for example where every Employee reports to another Employee, a so-called "self join", and it _always_ requires `relatedTableAlias` to be specified; failure to do so will result in invalid SQL.

In case of indirect relationship, when more than single join is needed to join the target table, and \[includeVia\](#attr-datasourcefieldincludevia) is missing, generated alias is a concatenation of `relatedTableAlias` and FK field names starting with the first `relatedTableAlias` met in chain of relations leading to the target table.

See the "Automatically generated table aliases" section of the \[SQL Templating\](#group-customquerying) for more details.

### Groups

- dataSourceRelations

### See Also

- [DataSource.relatedTableAlias](#attr-datasourcerelatedtablealias)
- [DataSourceField.includeVia](#attr-datasourcefieldincludevia)

**Flags**: IR

---
## Attr: TreeNode.iconPadding

### Description
Developers may customize the padding between the folder or leaf node icon and the text content of the tree cell for individual nodes.

You can change the name of this property by setting \[attr:TreeGrid.iconPaddingProperty\](#attr-treegridiconpaddingproperty)

### Groups

- treeIcons

**Flags**: IRA

---
## Method: Slider.getValue

### Description
Returns the current slider value.

### Returns

`[float](#type-float)` — current slider value

---
## Attr: RadioGroupItem.editProxyConstructor

### Description
Default class used to construct the \[class:EditProxy\](#class-editproxy) for this component when the component is \[first placed into edit mode\](#method-canvasseteditmode).

**Flags**: IR

---
## Method: SearchForm.criteriaChanged

### Description
Notification method fired when the criteria are modified in this SearchForm. As the user edits values, this method will be fired after a \[configurable delay\](#attr-searchformcriteriachangeddelay).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| criteria | [Criteria](#type-criteria) | false | — | Current criteria of the form (matches \[method:DynamicForm.getValuesAsCriteria\](#method-dynamicformgetvaluesascriteria)) |
| form | [SearchForm](#type-searchform) | false | — | the SearchForm being edited |

---
## Attr: RPCRequest.downloadResult

### Description
If enabled, causes the RPCRequest to download the requested resource as a file, either showing the browser's Save dialog or displaying the file-content in \[a new browser window\](#attr-rpcrequestdownloadtonewwindow).

Download requests will use \[transport\](#attr-rpcrequesttransport): "hiddenFrame" by default.

In this mode, the download will be performed by a standard HTTP request issued by the browser. If \[DSRequest.downloadToNewWindow\](#attr-rpcrequestdownloadtonewwindow) is true, the request will be targeted against a new browser window, and if the resulting file can be displayed inline by the browser it will be. If \[DSRequest.downloadToNewWindow\](#attr-rpcrequestdownloadtonewwindow) is not true, or the browser cannot display the returned file inline, the browser will download the file and store it to the user's file system.

Download requests with \[transport\](#attr-rpcrequesttransport): "hiddenFrame" do not fire any callbacks.

If a developer explicitly sets `request.transport` to "xmlHttpRequest", the browser will instead use an XMLHttpRequest to download the data from the server. This mode differs from hiddenFrame downloads in various ways:

*   Explicit \[attr:RPCRequest.httpHeaders\](#attr-rpcrequesthttpheaders) may be sent to the server in this mode
*   Instead of automatically downloading the response to the user's filesystem, the server response will be available as a [Blob](https://developer.mozilla.org/en-US/docs/Web/API/Blob), and the \[method:RPCRequest.downloadCallback\](#method-rpcrequestdownloadcallback) will be invoked, if specified.  
    Returning `false` from the downloadCallback will suppress the default behavior of saving the file to the user's filesystem, giving developers an opportunity to take other actions, such as generating a data URL from the Blob.
*   xmlHttpRequest download does not have a built-in progress bar to indicate download progress. Developers may make use of the \[method:RPCRequest.xhr\_onProgress\](#method-rpcrequestxhr-onprogress) event to indicate download progress if required.

**Flags**: IRWA

---
## Attr: TreeGrid.customIconOpenProperty

### Description
This property allows the developer to rename the \[default node.showOpenIcon\](#attr-treenodeshowopenicon) property.

### Groups

- treeIcons

### See Also

- [TreeGrid.customIconProperty](#attr-treegridcustomiconproperty)
- [TreeGrid.showCustomIconOpen](#attr-treegridshowcustomiconopen)

**Flags**: IRWA

---
## Attr: DetailViewer.loadingMessage

### Description
The string to display in the body of a detailViewer which is loading records. Use `"${loadingImage}"` to include \[a loading image\](#classattr-canvasloadingimagesrc).

### Groups

- emptyMessage

**Flags**: IRW

---
## Object: DataQuestionSettings

### Description
Settings for a data question.

### Groups

- answerEngine

---
## ClassAttr: Browser.isTablet

### Description
Is the application running on a tablet device (e.g. iPad, Nexus 7)?

SmartClient can correctly determine whether the device is a tablet in most cases. On any uncommon device for which this variable is incorrect, you can define the `isc_isTablet` global with the correct value, and SmartClient will use `isc_isTablet` for `Browser.isTablet` instead of its own detection logic. Alternatively, you can use \[classMethod:Browser.setIsTablet\](#classmethod-browsersetistablet) to change this global variable before any components are created.

The value of this variable is only meaningful on touch devices.

**Flags**: RW

---
## Method: TabSet.setPaneContainerOverflow

### Description
Update \[attr:TabSet.paneContainerOverflow\](#attr-tabsetpanecontaineroverflow) after creation.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| newOverflow | [Overflow](#type-overflow) | false | — | new overflow setting |

---
## Attr: FacetChart.tickMarkToValueAxisMargin

### Description
Margin between the tick marks and the labels of the \[extra value axes\](#attr-facetchartextraaxismetrics).

### Groups

- ticks

**Flags**: IR

---
## Attr: MinimalScrollbar.setInteractiveOnMouseOver

### Description
Always set to \[attr:MinimalScrollbar.interactive\](#attr-minimalscrollbarinteractive) mode on roll over.

**Flags**: IRW

---
## Attr: DataBoundAIRequest.maxRetries

### Description
The maximum number of retries for any one particular request to AI.

Note that multiple AI requests may be involved in processing the data-bound AI request. This limit is the maximum number of retries of any one request. For example, if there are 2 requests made to AI, then each one would be submitted at most `1 + maxRetries` number of times for up to `2 * (1 + maxRetries)` total requests.

If unset, then \[classAttr:AI.defaultMaxRetries\](#classattr-aidefaultmaxretries) will be used.

**Flags**: IR

---
## Attr: DetailViewer.emptyMessageStyle

### Description
CSS style to display this message in

### Groups

- emptyMessage

**Flags**: IRWA

---
## ClassMethod: TabIndexManager.removeTarget

### Description
Removes a target from this TabIndexManager. Any children of this target will also be removed - developers wishing to preserve children should first call \[classMethod:TabIndexManager.moveTarget\](#classmethod-tabindexmanagermovetarget) to move the children out of this parent

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| ID | [String](#type-string) | false | — | target to remove |

---
## Attr: FacetChartEditProxy.dataSeparatorChar

### Description
If \[inline editing\](#type-inlineeditevent) for this chart edits the \[attr:FacetChart.data\](#attr-facetchartdata), character that should be used as a separator between values, or between pairs of label vs values.

The \[dataEscapeChar\](#attr-facetcharteditproxydataescapechar) can be used to enter the separator char as part of a field name or value.

**Flags**: IR

---
## Attr: TreeGrid.selectedIconSuffix

### Description
If \[attr:TreeGrid.showSelectedIcons\](#attr-treegridshowselectedicons) is true, this suffix will be appended to the \[attr:TreeGrid.folderIcon\](#attr-treegridfoldericon) for selected nodes in this grid.

### Groups

- treeIcons

**Flags**: IR

---
## Attr: DataSource.autoCacheAllData

### Description
When a DataSource is not \[attr:DataSource.cacheAllData\](#attr-datasourcecachealldata):true and a fetch results in the entire dataset being retrieved, this attribute being set to true causes the DataSource to automatically switch to `cacheAllData:true` and prevent further server-trips for fetch requests.

\[cacheAllData\](#attr-datasourcecachealldata) is automatically enabled in either of these conditions:

*   The request has no criteria and no startRow/endRow request properties. The latter can be accomplished by disabling paging with a \[dataFetchMode\](#attr-databoundcomponentdatafetchmode) setting of "basic" or "local" or by an explicit fetchData request with those request properties excluded.
*   The request has no criteria but has startRow/endRow specified and the response received has all data available (`startRow:0` and `endRow:totalRows`).

### Groups

- clientData

**Flags**: IR

---
## Attr: ListGrid.aiSortFieldMaxRecordsMessage

### Description
The message to show when a user asks the AI to sort more than the \[maximum allowed records\](#attr-databoundcomponentaisortfieldmaxrecords).

### Groups

- i18nMessages

**Flags**: IRW

---
## ClassAttr: Operators.iNotEqualFieldTitle

### Description
Title for the "iNotEqualField" operator

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: ListGrid.groupSummaryRecordProperty

### Description
If \[attr:ListGrid.showGroupSummary\](#attr-listgridshowgroupsummary) is true, this attribute will be set to true on each record object representing a group-level summary row.

**Flags**: IRW

---
## Attr: Canvas.isGroup

### Description
Should a grouping frame be shown around this canvas if a non-empty string has been specified for \[attr:Canvas.groupTitle\](#attr-canvasgrouptitle).

### Groups

- appearance

### See Also

- [Canvas.groupBorderCSS](#attr-canvasgroupbordercss)
- [Canvas.groupLabelStyleName](#attr-canvasgrouplabelstylename)
- [Canvas.groupLabelBackgroundColor](#attr-canvasgrouplabelbackgroundcolor)

**Flags**: IR

---
## Attr: DateItem.dateFormatter

### Description
If \[attr:DateItem.useTextField\](#attr-dateitemusetextfield) is `true` this property can be used to customize the format in which dates are displayed for this item.  
Should be set to a standard \[type:DateDisplayFormat\](#type-datedisplayformat).

As with any formItem rendering out a date value, if no explicit dateFormatter is supplied, dateFormatter will be derived from \[attr:DynamicForm.dateFormatter\](#attr-dynamicformdateformatter) or \[attr:DynamicForm.datetimeFormatter\](#attr-dynamicformdatetimeformatter), depending on the specified \[attr:FormItem.type\](#attr-formitemtype) for this field, if set, otherwise from the standard default \[classMethod:DateUtil.setShortDisplayFormat\](#classmethod-dateutilsetshortdisplayformat) or \[classMethod:DateUtil.setShortDatetimeDisplayFormat\](#classmethod-dateutilsetshortdatetimedisplayformat).

NOTE: For entirely custom formats, developers may apply a custom \[method:DateItem.formatEditorValue\](#method-dateitemformateditorvalue) method. To ensure the DateItem is able to parse user-entered date strings back into Dates, for most cases developers can specify an explicit \[attr:DateItem.inputFormat\](#attr-dateiteminputformat), or if necessary a custom \[method:DateItem.parseEditorValue\](#method-dateitemparseeditorvalue).

This attribute does not have an effect if a native HTML5 date or datetime input is being used. See \[attr:DateItem.browserInputType\](#attr-dateitembrowserinputtype).

**Flags**: IRW

---
## Method: Canvas.linkHTML

### Description
Generates the HTML for a standard link (anchor) element.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| href | [String](#type-string) | false | — | URL for the link to point to |
| text | [HTMLString](#type-htmlstring) | true | — | HTML to display in the link element (defaults to the href) |
| target | [String](#type-string) | true | — | Target window for the link (defaults to opening in a new, unnamed window) |
| ID | [String](#type-string) | true | — | optional ID for the link element to be written out |
| tabIndex | [Integer](#type-integer) | true | — | optional tabIndex for the link |
| accessKey | [String](#type-string) | true | — | optional accessKey for the link |

### Returns

`[HTMLString](#type-htmlstring)` — HTML for the link

**Flags**: A

---
## Attr: ListGrid.editSelectionType

### Description
If \[attr:ListGrid.selectOnEdit\](#attr-listgridselectonedit) is true, what should be the edit-selection behavior be?

Default setting of `"single"` will cause the edit row to be automatically selected and any other selection in the grid to be dropped.  
If set to `"multiple"`, selection will be additive (as a record goes into edit mode, it is selected in addition to any pre-existant selection).

If set to `null` behavior is as follows:

*   For grids with \[attr:ListGrid.selectionType\](#attr-listgridselectiontype) set to `"simple"` edit rows will be selected additively - this is the same behavior as if the `editSelectionType` was `"multiple"`
*   Otherwise edit rows will be selected singly - this is the same behavior as if the `editSelectionType` was `"single"`

**Flags**: IRW

---
## Attr: Facet.collapsed

### Description
For tree facets, default collapse state for parent nodes.

#### Note:
 This property is specific to \[CubeGrids\](#class-cubegrid).

**Flags**: IR

---
## ClassMethod: AutoTest.variableIsDefined

### Description
Determine whether a variable has been explicitly set via \[classMethod:AutoTest.setVariable\](#classmethod-autotestsetvariable) or \[classMethod:AutoTest.storeLocatorResult\](#classmethod-autoteststorelocatorresult).

This method will return true if the variable has been set to any value, including `null`, or false if the variable has never been set or has been \[cleared\](#classmethod-autotestclearvariable).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| name | [String](#type-string) | false | — | variable to retrieve |

### Returns

`[Boolean](#type-boolean)` — true

---
## Method: ResultSet.rangeIsLoaded

### Description
Whether the given range of rows has been loaded. Unlike getRange(), will not trigger a server fetch.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| startRow | [number](#type-number) | false | — | start position, inclusive |
| endRow | [number](#type-number) | false | — | end position, exclusive |

### Returns

`[boolean](#type-boolean)` — true if all rows in the given range have been loaded, false if any rows in the range have not been loaded or are still in the process of being loaded

**Flags**: A

---
## Attr: DynamicForm.showInlineErrors

### Description
If true, field errors are written into the form next to the item(s) where the errors occurred. Errors may appear as text or just an icon (via \[attr:DynamicForm.showErrorText\](#attr-dynamicformshowerrortext):false).

If false, errors are written at the top of the form.

To do some other kind of error display, override \[method:DynamicForm.showErrors\](#method-dynamicformshowerrors).

### Groups

- validation

**Flags**: IRW

---
## Method: ResultTree.willFetchData

### Description
Will changing the criteria for this resultTree require fetching new data from the server or can the new criteria be satisfied from data already cached on the client?

This method can be used to determine whether \[method:TreeGrid.fetchData\](#method-treegridfetchdata) or \[method:TreeGrid.filterData\](#method-treegridfilterdata) will cause a server side fetch when passed a certain set of criteria.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| newCriteria | [Criteria](#type-criteria) | false | — | new criteria to test. |

### Returns

`[Boolean](#type-boolean)` — true if server fetch would be required to satisfy new criteria.

---
## Group: clientServerIntegration

### Description
Like client-server desktop applications, SmartClient browser-based applications interact with remote data and services via background communication channels. Background requests retrieve chunks of data rather than new HTML pages, and update your visual components in place rather than rebuilding the entire user interface.

#### DataSources

First you must create \[DataSources\](#class-datasource) that describe the objects from your object model that will be loaded or manipulated within your application. All of SmartClient's most powerful functionality builds on the concept of a DataSource, and because of SmartClient's databinding framework (see \[interface:DataBoundComponent\](#interface-databoundcomponent)), it's as easy to create a DataSource that can configure an unlimited number of components as it is to configure a single component.

For background information on how to create DataSources, \[bind\](#interface-databoundcomponent) components to DataSources and initiate \[object:DSRequest\](#object-dsrequest)s, please see the _Data Binding_ chapter of the _SmartClient Quickstart Guide_.

#### Data Integration

DataSources provide a data-provider agnostic API to SmartClient Visual Components that allow them to perform the 4 CRUD operations (
#### C
reate, 
#### R
etrieve, 
#### U
pdate, 
#### D
elete). By "agnostic" we mean that the implementation details - the nuts and bolts of how a given DataSource actually retrieves or updates data - are unknown to bound SmartClient components. One effect of this is that DataSources are "pluggable": they can be replaced without affecting the User Interface.

When a visual component, or your own custom code, performs a CRUD operation on a DataSource, the DataSource creates a \[object:DSRequest\](#object-dsrequest) (DataSource Request) representing the operation. "Data Integration" is the process of fulfilling that DSRequest by creating a corresponding \[class:DSResponse\](#class-dsresponse) (DataSource Response), by using a variety of possible approaches to connect to the ultimate data provider.

There are two main approaches to integrating DataSources with your server technology:

*   \[Server-side integration\](#group-serverdataintegration): DataSource requests from the browser arrive as Java Objects on the server. You deliver responses to the browser by returning Java Objects. The various server-side integration possibilities are discussed later in this article.
*   \[Client-side integration\](#group-clientdataintegration): DataSource requests arrive as simple HTTP requests which your server code receives directly (in Java, you use the Servlet API or .jsps to handle the requests). Responses are sent as XML or JSON which you directly generate.

The possible approaches are summarized in the diagram below. Paths 2, 3 and 4 are client-side integration approaches, and path 1 includes all server-side integration approaches.

![](skin/ClientServerIntegration.png)

SmartClient supports, out of the box, codeless connectivity to various kinds of common data providers, including SQL and Hibernate. SmartClient also provides functionality and tools for accelerated integration with broad categories of data providers, such as Java Object-based persistence mechanisms (JPA, EJB, MyBatis, in-house written systems), and REST and WSDL web services in XML or JSON formats. Ultimately, a DataSource can be connected to anything that is accessible via HTTP or HTTPS, and also to in-browser persistence engines such as [Google Gears](http://gears.google.com).

#### Choosing a Data Integration Approach

This section aims to help you decide which of the many possible data integration approaches is best for your particular circumstances. The recommendations given here will guide you to the approach that involves the least effort.

![](skin/dataIntegrationFlowchart.png)

*   If you have a Java server:

*   If your ultimate storage is a SQL database:

*   Use the SQLDataSource unless you have a very large amount of pre-existing JPA or Hibernate code - small amounts of business logic can be easily migrated. Be sure to read the overview of \[SQLDataSource vs JPA/Hibernate\](#group-sqlvsjpa) in order to understand the large benefits the SQLDataSource provides
*   Derive DataSource definitions from existing tables or Hibernate mappings using the \[autoDeriveSchema\](#attr-datasourceautoderiveschema) feature, or from Java Beans via the \[schemaBean\](#attr-datasourceschemabean) feature. Or, use the \[Admin Console\](#group-adminconsole) to generate tables from DataSource definitions you create by hand

*   If your ultimate storage is not a SQL database:

*   If your persistence is based on Java Beans, use the \[schemaBean\](#attr-datasourceschemabean) feature to derive DataSource definitions from any Java bean
*   write a \[custom DataSource\](#group-writecustomdatasource) that provides the CRUD operations you want to support.

*   Whether or not your storage is SQL, add business logic either declaratively in the DataSource definition, via \[DMI\](#group-dmioverview), or any combination of the two:
    *   The <criteria> and <values> properties of an \[class:OperationBinding\](#class-operationbinding) allow you to dynamically set data values at transaction-processing time, using built-in \[Velocity support\](#group-velocitysupport)
    *   Override the `validate()` method of the DataSource to provide extra custom validations - just call `super` to obtain the list of errors derived from SmartClient validations, then add to that list as required with your own custom code
    *   Override the `execute()` method of the DataSource to add extra processing either before or after the SmartClient processing
    *   Use \[Transaction Chaining\](#group-transactionchaining) to dynamically set data values according to the results of earlier transactions
    *   For SQL DataSources, use \[SQL Templating\](#group-customquerying) to change, add to or even completely replace the SQL sent to the database, and to implement special query requirements
    *   For JPA DataSources, use \[custom JQL queries\](#attr-operationbindingcustomjql) to implement special query requirements
    *   For Hibernate DataSources, use \[custom HQL queries\](#attr-operationbindingcustomhql) to implement special query requirementsRead more about the server-side request processing flow and how to customize it in \[the server integration overview\](#group-serverdataintegration).

*   If you do not have a Java server:

*   If you are not obliged to use a pre-existing network protocol, use the \[class:RestDataSource\](#class-restdatasource)
*   Otherwise, use \[client-side data integration\](#group-clientdataintegration) features to create a custom client-side DataSource that adapts the DataSource protocol to your existing services

  
#### RPCs: Unstructured Server Communication

SmartClient also supports "unstructured" client-server operations. These \[object:RPCRequest\](#object-rpcrequest)s (Remote Procedure Call Requests) are a low-level, very flexible mechanism for custom client-server communications. In an nutshell, RPCRequests:

*   may contain arbitrary data
*   are always initiated by custom code (a call to \[classMethod:RPCManager.send\](#classmethod-rpcmanagersend)), and have their responses handled by custom code (the callback passed to `send()`)

RPCRequests are relatively rare. Most client-server communications are better done in a structured fashion using a \[object:DSRequest\](#object-dsrequest) (DataSource Request). Note that _any_ RPCRequest can alternatively be framed as a \[DataSource fetch\](#method-datasourcefetchdata); depending on the circumstances, this may be more convenient.

See the \[class:RPCManager\](#class-rpcmanager) documentation for further information on RPCRequests.

---
## Method: Flashlet.setSrc

### Description
Sets the source file for the flash component

---
## Attr: Menu.iconBodyStyleName

### Description
If set, the CSS style used for the body of this menu when there _is_ an icon field. In RTL mode, the `iconBodyStyleName` is suffixed with "RTL", which allows skins to apply different styles in LTR and RTL modes.

Note: Any skin which uses `iconBodyStyleName` should add "RTL" styles as well, even if identical to LTR styles. Otherwise, menus may lose their styling in RTL mode.

### Groups

- appearance

### See Also

- [Menu.iconFillSpaceStyleName](#attr-menuiconfillspacestylename)

**Flags**: IR

---
## Method: CubeGrid.collapseField

### Description
Collapses the specified field. No-ops if it's not showing, or it it's already collapsed.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| facetValueMap | [FacetValueMap](#type-facetvaluemap) | false | — | field specified as a facetValueMap |

### Returns

`[Boolean](#type-boolean)` — whether specified field was actually collapsed

---
## Attr: RichTextEditor.editAreaBackgroundColor

### Description
Background color for the \[edit canvas\](#attr-richtexteditoreditarea).

**Flags**: IR

---
## Object: Shadow

### Description
A class used to define a shadow used in a Draw<Shape> Types.

---
## Attr: AdaptiveMenu.menuButtonTitle

### Description
Title used for the \[class:MenuButton\](#class-menubutton).

**Flags**: IR

---
## Attr: DataBoundComponent.fieldEditorWindowTitle

### Description
The title for the \[Window\](#attr-databoundcomponentfieldeditorwindow) used to edit calculated fields.

This is a dynamic string - text within `${...}` are dynamic variables and will be evaluated as JS code whenever the message is displayed.

Two dynamic variables are available - "builderType", either Formula or Summary, and "fieldTitle", which is the title of the calculated field being edited.

### Groups

- i18nMessages

**Flags**: IRWA

---
## Method: ProcessElement.updateGlobalIDInCriteria

### Description
Updates \[object:AdvancedCriteria\](#object-advancedcriteria) \[object:Criterion\](#object-criterion) \[type:TaskInputExpression\](#type-taskinputexpression) values containing ruleScope references.

This method is a helper to implement task-specific \[method:ProcessElement.updateGlobalIDReferences\](#method-processelementupdateglobalidreferences).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| criteria | [AdvancedCriteria](#type-advancedcriteria) | false | — | the criteria to be updated in place |
| oldId | [Identifier](#type-identifier) | false | — | the ID being renamed |
| newId | [Identifier](#type-identifier) | false | — | the new ID to be assigned |

### Returns

`[Boolean](#type-boolean)` — true if any references were updated; false otherwise

---
## Attr: ListGrid.recordCanSelectProperty

### Description
If set to false on a record, selection of that record is disallowed.

**Flags**: IRA

---
## Attr: GridFetchDataTask.applyToImplicitCriteria

### Description
Should criteria be applied to the grid as \[implicit criteria\](#attr-listgridimplicitcriteria)? When criteria is applied this way, it is not shown to the user and cannot be changed by the user.

**Flags**: IR

---
## Method: MultiSortPanel.getSortLevel

### Description
Return a \[object:SortSpecifier\](#object-sortspecifier) object for the requested levelNum.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| levelNum | [number](#type-number) | false | — | The index of the level to return a SortSpecifier for |

### Returns

`[SortSpecifier](#type-sortspecifier)` — A SortSpecifier representing the requested levelNum

---
## Attr: DataSource.jsonSuffix

### Description
Allows you to specify an arbitrary suffix string to apply to all json format responses sent from the server to this application.

The inclusion of such a suffix ensures your code is not directly executable outside of your application, as a preventative measure against [javascript hijacking](http://www.google.com/search?q=javascript+hijacking).

Only applies to responses formatted as json objects. Does not apply to responses returned via scriptInclude type transport.

### See Also

- [OperationBinding.dataFormat](#attr-operationbindingdataformat)
- [OperationBinding.dataTransport](#attr-operationbindingdatatransport)

**Flags**: IRA

---
## Method: GridRenderer.getRowHeight

### Description
Return the height this row should be. Default is this.cellHeight. If \[attr:GridRenderer.fixedRowHeights\](#attr-gridrendererfixedrowheights) is false, the row may be rendered taller than this specified size.

If records will be variable height, you should switch on \[virtualScrolling\](#attr-gridrenderervirtualscrolling).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| record | [ListGridRecord](#type-listgridrecord) | false | — | cell record as returned by getCellRecord |
| rowNum | [number](#type-number) | false | — | row number |

### Returns

`[number](#type-number)` — height in pixels

---
## Attr: RichTextEditor.fontSelectorItem

### Description
The \[type:AutoChild\](#type-autochild) \[class:SelectItem\](#class-selectitem) used for choosing the font to apply to the current selection.

**Flags**: IR

---
## Attr: FieldPicker.confirmText

### Description
—

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: PortalLayout.canAddColumns

### Description
Can the user add columns to this PortalLayout?

Columns may be added via the \[column menu\](#attr-portallayoutshowcolumnmenus), or by dragging a portlet and dropping next to an existing column, if \[attr:PortalLayout.dropTypes\](#attr-portallayoutdroptypes) includes the drop type for the portlet.

Note that if \[attr:PortalLayout.removeEmptyColumns\](#attr-portallayoutremoveemptycolumns) is true, when the user drags every portlet out of a portalLayout column, the column will be removed automatically.

**Flags**: IRW

---
## Attr: MathFunction.description

### Description
A short description of this function

### Groups

- formulaFields

**Flags**: IR

---
## Attr: ListGrid.showRecordComponents

### Description
When enabled, \[method:ListGrid.createRecordComponent\](#method-listgridcreaterecordcomponent) will be called when saved rows are being rendered, and any returned component will be displayed embedded within the row or cell.

recordComponents are not created for newly added rows which have not yet been saved. See the \[Handling Unsaved Records overview\](#group-unsavedrecords) for more information.

Depending on the \[attr:ListGrid.showRecordComponentsByCell\](#attr-listgridshowrecordcomponentsbycell) setting, `createRecordComponent()` will be called either once per row, or once for every cell.

Depending on \[attr:ListGrid.recordComponentPosition\](#attr-listgridrecordcomponentposition), components can either be placed underneath normal record or cell content ("expand" setting) or placed so that they overlap normal cell content ("within" setting). For the "within" setting, the default is to fill the row or cell, but the component can specify percent size or even use \[snapTo-positioning\](#attr-canvassnapto) to place itself within the row or cell.

The "expand" setting is incompatible with \[frozen columns\](#attr-listgridcanfreezefields) _unless_ all `recordComponents` are the same height and they are present in every row, in which case the fixed height of all `recordComponents` can be set via \[attr:ListGrid.recordComponentHeight\](#attr-listgridrecordcomponentheight) to re-enable frozen fields.

Using `recordComponents` potentially means creating one component for every visible grid row or cell and so can impact performance. Before using this subsystem:

*   consider using \[attr:ListGridField.valueIcons\](#attr-listgridfieldvalueicons) (possibly with a specified \[method:ListGridField.valueIconClick\](#method-listgridfieldvalueiconclick) handler) for icons based on field values which may be displayed alone in the cell or alongside standard content (see \[attr:ListGridField.showValueIconOnly\](#attr-listgridfieldshowvalueicononly));
*   for clickable icons representing actions that can be taken on a record, also consider using \[a field of type "icon"\](#type-listgridfieldtype), or multiple such fields
*   for controls that only need to appear on rollover, consider \[rollOver controls\](#attr-listgridshowrollovercanvas)
*   if you are trying to customize the editor for a field, you can provide a custom control via \[attr:ListGridField.editorType\](#attr-listgridfieldeditortype), and \[attr:FormItem.icons\](#attr-formitemicons) are a common way to add clickable buttons. You can also \[provide different controls per record\](#method-listgridgeteditortype). These options are usually better that using `recordComponents` as custom editors, since you won't have to manage issues like making the `recordComponent` appear only when editing, having changes affect \[editValues\](#group-editing), triggering saves and handling validation errors, etc.

See \[type:RecordComponentPoolingMode\](#type-recordcomponentpoolingmode) for an overview of how best to optimize use of `recordComponents` for different data sets.

Regardless of the pooling mode, you can explicitly refresh record components via \[method:ListGrid.invalidateRecordComponents\](#method-listgridinvalidaterecordcomponents) and \[method:ListGrid.refreshRecordComponent\](#method-listgridrefreshrecordcomponent).

_Interaction with \[column auto-fit\](#attr-listgridautofitfieldwidths)_: per-cell record components are not taken into account when determining the size for column auto fit. The default \[method:ListGrid.getDefaultFieldWidth\](#method-listgridgetdefaultfieldwidth) implementation looks at cell content only. We typically recommend that, for fields showing record-components, \[attr:ListGridField.autoFitWidth\](#attr-listgridfieldautofitwidth) and \[attr:ListGridField.canAutoFitWidth\](#attr-listgridfieldcanautofitwidth) be disabled, or if the record components are of a predictable size, a \[attr:ListGridField.defaultWidth\](#attr-listgridfielddefaultwidth) be specified.  
This is particularly pertinent where \[attr:ListGrid.recordComponentPosition\](#attr-listgridrecordcomponentposition) is set to "within", in which case cells' content is often empty or completely covered by record-components.

### Groups

- recordComponents

### See Also

- [ListGrid.recordComponentPosition](#attr-listgridrecordcomponentposition)
- [ListGrid.showRecordComponentsByCell](#attr-listgridshowrecordcomponentsbycell)
- [RecordComponentPoolingMode](#type-recordcomponentpoolingmode)
- [ListGrid.showRecordComponent](#method-listgridshowrecordcomponent)
- [ListGrid.createRecordComponent](#method-listgridcreaterecordcomponent)
- [ListGrid.updateRecordComponent](#method-listgridupdaterecordcomponent)

**Flags**: IRW

---
## Group: fieldGeneration

### Description
—

---
## Attr: FormItem.inputFormat

### Description
For fields of type `"date"`, if this is an editable field such as a \[class:TextItem\](#class-textitem), this property allows you to specify the \[inputFormat\](#attr-dateiteminputformat) applied to the item.

### See Also

- [FormItem.dateFormatter](#attr-formitemdateformatter)

**Flags**: IRWA

---
## Attr: AUN.loopThreshold

### Description
Maximum number of times AUN can return to the same screen (identified by component structure hash) before considering it stuck in a loop.

This detects when the AI is making actions but not making progress (e.g., repeatedly clicking the same button, navigating back and forth between two screens).

AUN will stop if either this limit is reached OR if \[attr:AUN.maxSteps\](#attr-aunmaxsteps) is exceeded.

Screen identity is determined by the \[class:UISession\](#class-uisession) structure hash of visible components, so different arrangements of the same components count as different screens.

**Flags**: IR

---
## Attr: SliderItem.shouldSaveValue

### Description
Should this item's value be saved in the form's values and hence returned from \[form.getValues()\](#method-dynamicformgetvalues)?

`shouldSaveValue:false` is used to mark formItems which do not correspond to the underlying data model and should not save a value into the form's \[values\](#attr-dynamicformvalues). Example includes visual separators, password re-type fields, or checkboxes used to show/hide other form items.

A `shouldSaveValue:false` item should be given a value either via \[attr:FormItem.defaultValue\](#attr-formitemdefaultvalue) or by calling \[form.setValue(item, value)\](#method-dynamicformsetvalue) or \[formItem.setValue(value)\](#method-formitemsetvalue). Providing a value via \[form.values\](#attr-dynamicformvalues) or \[form.setValues()\](#method-dynamicformsetvalues) will automatically switch the item to `shouldSaveValue:true`.

Note that

*   if an item is shouldSaveValue true, but has no name, a warning is logged, and shouldSaveValue will be set to false.

### Groups

- formValues

**Flags**: IR

---
## Attr: DynamicForm.operator

### Description
When \[attr:FormItem.operator\](#attr-formitemoperator) has been set for any \[class:FormItem\](#class-formitem) in this form, what logical operator should be applied across the \[criteria\](#object-criterion) produced by the form items? Only applicable to forms that have a \[dataSource\](#attr-databoundcomponentdatasource).

**Flags**: IR

---
## ClassAttr: DateUtil.shortMonthNames

### Description
This property may be set to an array of shortened month-names.  
For example:

 \["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"\]
 

The appropriate month name will then be returned from \[method:Date.getShortMonthName\](#method-dategetshortmonthname), and may be used whenever SmartClient components display month-names (for example in the \[DateItem class\](#class-dateitem)).

### Groups

- i18nMessages

**Flags**: IRWA

---
## Method: ListGrid.getSummaryTitle

### Description
Return the summary title of particular field. This is the title of the field to be used in the show / hide fields context menu. Default implementation will use \[method:ListGridField.getSummaryTitle\](#method-listgridfieldgetsummarytitle) or \[attr:ListGridField.summaryTitle\](#attr-listgridfieldsummarytitle) if specified, otherwise \[attr:ListGridField.title\](#attr-listgridfieldtitle).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| field | [ListGridField](#type-listgridfield) | false | — | field for which we're returning the title |

### Returns

`[String](#type-string)` — Field summary title.

### Groups

- i18nMessages
- display

**Flags**: A

---
## Method: DetailViewer.getViewState

### Description
Returns a snapshot of the current view state of this DetailViewer.  
This includes the field state of the DetailViewer, returned as a \[type:DetailViewerViewState\](#type-detailviewerviewstate) object.  
This object can be passed to \[method:DetailViewer.setViewState\](#method-detailviewersetviewstate) to reset this detail viewer's view state to the current state (assuming the same data / fields are present in the detail viewer).

### Returns

`[DetailViewerViewState](#type-detailviewerviewstate)` — current view state for the detail viewer.

### Groups

- viewState

### See Also

- [DetailViewerViewState](#type-detailviewerviewstate)
- [DetailViewer.setViewState](#method-detailviewersetviewstate)

---
## Attr: Canvas.shadowSoftness

### Description
Softness, or degree of blurring, of the shadow.

A shadow with `softness:x` is 2x pixels larger in each direction than the element throwing the shadow, and the media for each edge should be x pixels wide/tall.

Defaults to `shadowDepth` if unset.

### Groups

- shadow

**Flags**: IRWA

---
## Group: dsRequestBeanTypes

### Description
For fields with numeric types, the \[record data\](#attr-dsrequestdata) in DSRequests will automatically be converted to the type of the target field, before the request is received in a \[class:DMI\](#class-dmi).

For example, if \[your bean\](#attr-datasourcebeanclassname) has a field "price" of type Float, an "update" DSRequest with a new value for this field will use the Java Float type for the new value, whereas in the absence of a bean, the Double type would ordinarily be used (see \[attr:RPCRequest.data\](#attr-rpcrequestdata)).

This happens only for fields of type _integer_, _sequence_, _intEnum_ and _float_. Because the conversion is performed as part of server-side validation, it applies only to "update" or "add" requests, and does not apply to \[attr:DSRequest.oldValues\](#attr-dsrequestoldvalues), which will continue to use the generic types listed in \[attr:RPCRequest.data\](#attr-rpcrequestdata).

Note that, while values for non-numeric fields will still use basic Java types (for example, values for Java Enum fields will arrive \[as Strings by \\n default\](#attr-datasourceenumtranslatestrategy)), manual conversion of the remaining data is not necessary; the server-side API `DataSource.setProperties()` does all remaining conversion necessary to populate a bean from the request data (see that API's docs for details), and this conversion will be performed automatically if your DMI logic calls `execute()` on the DSRequest.

You may need to explicitly define what Java type must be used during conversion for a given field. This can be achieved by setting \[attr:DataSourceField.javaClass\](#attr-datasourcefieldjavaclass) property.

If conversion fails, because of target field using an abstract Java type or invalid class defined in DSField.javaClass property etc, conversion will fall back to its default behavior, i.e. Java type will be guessed from the actual field value. It would be Long for integer based types and Double for float type or, if the value would appear to exceed the ranges of these types, BigInteger and BigDecimal accordingly.

---
## Attr: DrawKnob.knobShape

### Description
The \[class:DrawItem\](#class-drawitem) instance rendered into this DrawKnob's drawPane

**Flags**: R

---
## Method: FacetChart.setDataColors

### Description
Setter for \[attr:FacetChart.dataColors\](#attr-facetchartdatacolors).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| dataColors | [Array of CSSColor](#type-array-of-csscolor) | false | — | New set of data colors |

---
## Method: CubeGrid.facetLabelClick

### Description
Method handler fired when the user clicks on a facet label.

### Groups

- events

---
## Method: SectionStack.getSectionNumber

### Description
Returns the position of the specified section in the SectionStack. The numbering is zero-based.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| sectionName | [String](#type-string) | false | — | name of a section for which you want to obtain the position. |

### Returns

`[number](#type-number)` — Position of the section in the SectionStack or -1 if the specified section is not a member of this SectionStack.

---
## Attr: GaugeSector.value

### Description
—

**Flags**: IR

---
## Attr: DynamicForm.showErrorIcons

### Description
\[showErrorIcons\](#attr-dynamicformshowerroricons), \[showErrorText\](#attr-dynamicformshowerrortext), \[errorOrientation\](#attr-dynamicformerrororientation), and \[showErrorStyle\](#attr-dynamicformshowerrorstyle) control how validation errors are displayed when they are displayed inline in the form (next to the form item where there is a validation error). To instead display all errors at the top of the form, set \[showInlineErrors\](#attr-dynamicformshowinlineerrors):false.

`showErrorIcons`, `showErrorText`, `errorOrientation` and `showErrorStyle` are all boolean properties, and can be set on a DynamicForm to control the behavior form-wide, or set on individual FormItems.

The HTML displayed next to a form item with errors is generated by \[method:FormItem.getErrorHTML\](#method-formitemgeterrorhtml). The default implementation of that method respects `showErrorIcons` and `showErrorText` as follows:

`showErrorIcons`, or `showErrorIcon` at the FormItem level controls whether an error icon should appear next to fields which have validation errors. The icon's appearance is governed by \[attr:FormItem.errorIconSrc\](#attr-formitemerroriconsrc), \[attr:FormItem.errorIconWidth\](#attr-formitemerroriconwidth) and \[attr:FormItem.errorIconHeight\](#attr-formitemerroriconheight)

`showErrorText` determines whether the text of the validation error should be displayed next to fields which have validation errors. The attribute \[attr:DynamicForm.showTitlesWithErrorMessages\](#attr-dynamicformshowtitleswitherrormessages) may be set to prefix error messages with the form item's title + `":"` (may be desired if the item has \[attr:FormItem.showTitle\](#attr-formitemshowtitle) set to false).  
If `showErrorText` is unset, the error text will be shown if \[attr:DynamicForm.linearMode\](#attr-dynamicformlinearmode) is true (or \[attr:DynamicForm.linearOnMobile\](#attr-dynamicformlinearonmobile) is true for mobile devices), otherwise it will not be shown.

In addition to this:

\[attr:DynamicForm.errorOrientation\](#attr-dynamicformerrororientation) controls where the error HTML should appear relative to form items. Therefore the combination of \[attr:DynamicForm.showErrorText\](#attr-dynamicformshowerrortext)`:false` and \[attr:DynamicForm.errorOrientation\](#attr-dynamicformerrororientation)`:"left"` creates a compact validation error display consisting of just an icon, to the left of the item with the error message available via a hover (similar appearance to ListGrid validation error display).  
If `errorOrientation` is unset, the error orientation will default to "top" if \[attr:DynamicForm.linearMode\](#attr-dynamicformlinearmode) is enabled (or \[attr:DynamicForm.linearOnMobile\](#attr-dynamicformlinearonmobile) is true for mobile devices) and error text is not showing, "left" otherwise.

`showErrorStyle` determines whether fields with validation errors should have special styling applied to them. Error styling is achieved by applying suffixes to existing styling applied to various parts of the form item. See \[type:FormItemBaseStyle\](#type-formitembasestyle) for more on this.

### Groups

- validation

**Flags**: IRW

---
## Attr: ListGrid.dateInputFormat

### Description
If this is an editable listGrid, this property will specify the \[inputFormat\](#attr-dateiteminputformat) applied to editors for fields of type `"date"`. May be overridden per field via \[attr:ListGridField.inputFormat\](#attr-listgridfieldinputformat).

### See Also

- [ListGrid.dateFormatter](#attr-listgriddateformatter)

**Flags**: IRWA

---
## Method: Chart.getFacet

### Description
Get a facet definition by facetId.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| facetId | [String](#type-string) | false | — | the id of the facet to retrieve |

### Returns

`[Facet](#type-facet)` — the Facet if found, or null

### See Also

- [Facet](#class-facet)

---
## Attr: FacetValue.isMinimizeValue

### Description
Used to determine which facetValue is to be shown when the facet is minimized.

#### Note:
 This property is specific to \[CubeGrids\](#class-cubegrid). See \[attr:CubeGrid.canMinimizeFacets\](#attr-cubegridcanminimizefacets).

**Flags**: IR

---
## Attr: SimpleType.groupingModes

### Description
A set of key-value pairs that represent the names and titles of the grouping modes available to values of this type, for use in components that support grouping.

Some types provide a set of builtin groupingModes, as covered \[here\](#group-builtingroupingmodes).

Use \[method:SimpleType.getGroupValue\](#method-simpletypegetgroupvalue) and \[method:SimpleType.getGroupTitle\](#method-simpletypegetgrouptitle) to implement custom grouping logic for each of the grouping modes you provide.

**Flags**: IRW

---
## Attr: ListGrid.showHeaderSpanContextMenu

### Description
Whether to show a context menu on the header span with standard items for showing and hiding fields. Not supported for \[class:CubeGrid\](#class-cubegrid).

### Groups

- gridHeader

### See Also

- [ListGrid.getHeaderSpanContextMenuItems](#method-listgridgetheaderspancontextmenuitems)

**Flags**: IR

---
## Attr: StretchImg.ignoreRTL

### Description
Should the \[items\](#attr-stretchimgitems) for this StretchImg display left-to-right even if this page is displaying \[right to left text\](#classmethod-pageisrtl)?

Only has an effect if this StretchImg is horizontal (\[vertical\](#attr-stretchimgvertical) is set to false).

Having this property set to true is usually desirable for the common pattern of media consisting of fixed size "end caps" and a stretchable center, because it allows the same media to be used for LTR and RTL pages.

If set to false, items will be displayed in RTL order for RTL pages.

### Groups

- RTL
- appearance

**Flags**: IRW

---
## Class: StatefulCanvas

### Description
A component that has a set of possible states, and which presents itself differently according to which state it is in. An example is a button, which can be "up", "down", "over" or "disabled".

---
## Method: Callbacks.RunTaskCallback

### Description
Called when \[method:Process.runTask\](#method-processruntask) has finished executing the specified task.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| task | [Task](#type-task) | false | — | The task instance that was executed. |
| process | [Process](#type-process) | false | — | The owning process instance. |
| outputs | [Object](#type-object) | false | — | Task outputs, if any (for \[CoTTask\](#class-cottask), this is the final `$outputs` JSON). May be null if the task does not produce outputs. |

---
## Class: GridSelectRecordsTask

### Description
Select or deselect one or more records as specified by criteria. Target records will also be scrolled into view or, for a tree, parent folders will be opened to reveal the node.

Task Output:

*   On a select, the set of newly selected records is the output, even if other records are also selected.
*   On a deselect, the entire set of de-selected records is the output.

---
## ClassAttr: Hover.hoverCanvas

### Description
This is a single-instance widget, used to show contextual hover HTML and created lazily on the first call to \[classMethod:Hover.show\](#classmethod-hovershow).

This component is created using the \[autoChild pattern\](#type-autochild), so you can configure it using \[autoChild defaults\](#classattr-hoverhovercanvasdefaults) and \[properties\](#classattr-hoverhovercanvasproperties), or change its type with \[classAttr:Hover.hoverCanvasConstructor\](#classattr-hoverhovercanvasconstructor). Note that size and position are managed by the Hover subsystem, so not all \[Canvas settings\](#class-canvas) are supported.

To fully customize what a hover looks like, see \[classMethod:Hover.showHoverComponent\](#classmethod-hovershowhovercomponent), which allows entirely custom widgets such as \[grids\](#class-listgrid) to be shown as hovers.

**Flags**: RA

---
## Method: ResultSet.getProperty

### Description
Like \[method:List.getProperty\](#method-listgetproperty). Checks only loaded rows and will not trigger a fetch.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| property | [String](#type-string) | false | — | name of the property to look for |

### Returns

`[Array](#type-array)` — array of the values of property in each item of this list

### Groups

- iteration

---
## Attr: DataSourceField.required

### Description
Indicates this field must be non-null in order for a record to pass validation. Or, in the case of a "binary" field, a non-empty file must be uploaded. Setting this property has the same effect as giving the field a \["required" validator\](#type-validatortype).

Note that `required` should not be set for a server-generated field, such as a sequence, or validation will fail on the client.

#### Conditionally required fields
Adding an \[applyWhen\](#attr-validatorapplywhen) condition to a `required` validator introduces subtle complexities to the process of validating an existing record. The client is not guaranteed to know the full and complete state of the record it is editing because it is common for a \[class:DynamicForm\](#class-dynamicform) to be editing a subset of fields. When a field is _unconditionally_ required, things are simple: if the DynamicForm has a \[class:FormItem\](#class-formitem) for that field, then the `required` validation passes if that FormItem has a value, and fails if it does not. If the form has no FormItem for the field, it can assume that the field has a value because otherwise it would have failed validation when we attempted to add it (when we are adding a record, we of course do know the full and complete state of the record - it is whatever we are about to add).

When a field is _conditionally_ required, the client can no longer assume that all required fields will have a value. It may be the case that the condition of requirement was not met when the record was added, but now it is. For example, consider these field definitions:

    <field name="yearsAtCurrentAddress" type="integer" />
    <field name="previousAddress" type="text" >
      <validator type="required" errorMessage="Previous address is required if you have been at your current address less than three years">
        <applyWhen operator="and">
          <criteria>
            <criterion fieldName="yearsAtCurrentAddress" operator="lessThan" value="3" />
          </criteria>
        </applyWhen>
      </validator>
    </field>
 

Imagine a record for this DataSource is added where the user has entered a value of "3" for "yearsAtCurrentAddress", and no previous address. Later, the value of that field is changed to "2". If this is done using a form that is also showing the "previousAddress" field, we will know that "previousAddress" has not been provided, so we can fail the validation and the user will get a helpful error message explaining what the problem is.

However, if the form does not also show the "previousAddress" field, we may choose to use an \[class:OperationBinding\](#class-operationbinding) that uses \[outputs\](#attr-operationbindingoutputs) to trim the record down to just the fields the form does contain, in the interests of avoiding information leakage. Or perhaps that value is automatically culled from the record before the client sees it by the application of a \[declarative security rule\](#attr-datasourcefieldviewrequires). Whatever the reason, if the client does not have the complete record, it is not possible for the client to sensibly apply this validation. And because the client has no way of knowing if a value is missing because it is genuinely null, or because it has been trimmed away by the server, we must treat any null value with suspicion (unless it has a matching FormItem - the presence of the FormItem means that the user can edit the value, so it would make no sense to pair it with a trimmed record that excludes that field value).

When this happens, we mark the validation as having passed on the client, but in need of running on the server. The server validation makes use of the "storedRecord" facility (look for the description of 
#### $storedRecord
 in the \[Velocity support overview\](#group-velocitysupport)) to overlay the changed record on top of the existing record as it currently exists in the database. This gives the validator the complete record including both changed and unchanged values, so it is able to carry out the required check in a meaningful way. However, you should be aware that the combination of conditional "required" validators and DynamicForms that edit partial records can result in a validation that cannot run on the client and must do both a server roundtrip and a database fetch.

### Groups

- dataType

### See Also

- [Validator.applyWhen](#attr-validatorapplywhen)

**Flags**: IR

---
## Method: Menu.getVisibleItemNum

### Description
Given a MenuItem, return its index in the currently visible set of items.

To get the index of the item in the \[full set of items\](#method-menugetallitems), including \[hidden items\](#attr-menuitemhidden), use \[method:Menu.getItemNum\](#method-menugetitemnum) instead

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| item | [MenuItem](#type-menuitem) | false | — | Menu Item to find |

### Returns

`[int](#type-int)` — index of the item in the visible items, or -1 if not found.

### Groups

- menuItems

### See Also

- [Menu.filterHiddenItems](#attr-menufilterhiddenitems)

---
## Attr: FilterBuilder.fieldDataSource

### Description
If specified, the FilterBuilder will dynamically fetch DataSourceField definitions from this DataSource rather than using \[attr:FilterBuilder.dataSource\](#attr-filterbuilderdatasource). The \[class:FieldPicker\](#class-fieldpicker) will default to being a \[class:ComboBoxItem\](#class-comboboxitem) rather than a \[class:SelectItem\](#class-selectitem) so that the user will have type-ahead auto-completion.

The records returned from the `fieldDataSource` must have properties corresponding to a \[object:DataSourceField\](#object-datasourcefield) definition, at a minimum, \["name"\](#attr-datasourcefieldname) and \["type"\](#attr-datasourcefieldtype). Any property legal on a DataSourceField is legal on the returned records, including \[valueMap\](#attr-datasourcefieldvaluemap).

Even when a `fieldDataSource` is specified, \[attr:FilterBuilder.dataSource\](#attr-filterbuilderdatasource) may still be specified in order to control the list of \[valid operators\](#method-datasourcesettypeoperators) for each field.

**Flags**: IR

---
## Attr: MultiPickerItem.textMatchStyle

### Description
textMatchStyle to apply to \[option criteria\](#method-multipickeritemgetoptioncriteria) for this item

**Flags**: IR

---
## Group: constant

### Description
—

---
## Attr: SpinnerItem.decreaseIconProperties

### Description
FormItemIcon properties applied to the \[decreaseIcon\](#attr-spinneritemdecreaseicon) AutoChild of this SpinnerItem.

**Flags**: IR

---
## Method: ListGrid.hideDragHandles

### Description
Hides the \[drag handle field\](#attr-listgriddraghandlefield), if currently shown.

### Groups

- dragHandleField

### See Also

- [ListGrid.showDragHandles](#method-listgridshowdraghandles)

---
## Attr: FormItem.top

### Description
Top coordinate of this item in pixels. Applies only when the containing DynamicForm sets `itemLayout:"absolute"`.

**Flags**: IRWA

---
## Method: ListGrid.headerHover

### Description
Handle a hover over a button in the header.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| fieldNum | [number](#type-number) | false | — | field number for the header that was hovered |

### Groups

- events
- gridHeader
- hovers

### See Also

- [ListGrid.headerHoverHTML](#method-listgridheaderhoverhtml)

**Flags**: A

---
## Attr: DynamicForm.minHintWidth

### Description
Minimum horizontal space made available for \[attr:FormItem.hint\](#attr-formitemhint) text. Typically this reflects how much space the hint text takes up before it wraps. May be overridden at the item level via \[attr:FormItem.minHintWidth\](#attr-formitemminhintwidth).

This setting does not apply to hints that are \[shown in field\](#attr-textitemshowhintinfield).

### See Also

- [DynamicForm.wrapHintText](#attr-dynamicformwraphinttext)

**Flags**: IR

---
## Attr: ImgButton.showRollOverIcon

### Description
If using an icon for this button, whether to switch the icon image on mouse rollover.

### Groups

- buttonIcon

**Flags**: IR

---
## Attr: ListGrid.autoFitMaxRecords

### Description
If \[attr:ListGrid.autoFitData\](#attr-listgridautofitdata) is set to `"vertical"` or `"both"` this property provides the maximum number of records for which the ListGrid will expand. If more records are present, scrolling will be introduced to reach them as normal. If unset, by default the ListGrid will expand to accommodate as many records as are present.

### Groups

- autoFitData

**Flags**: IRW

---
## Attr: SimpleType.inheritsFrom

### Description
Name of another SimpleType from which this type should inherit.

Validators, if any, will be combined. All other SimpleType properties default to the inherited type's value.

**Flags**: IR

---
## Attr: LoadProjectSettings.requestProperties

### Description
Allows customizing the projectLoader servlet request properties. Properties that conflict with proper operation of the servlet will be overridden by \[classMethod:RPCManager.loadProject\](#classmethod-rpcmanagerloadproject).

**Flags**: IRA

---
## ClassAttr: AI.noAIEngineSupportingVisionRequestsIsRegisteredErrorMessage

### Description
—

### Groups

- i18nMessages

**Flags**: RW

---
## ClassAttr: SelectionOutline.labelBackgroundColor

### Description
The background color for the selection label. It corresponds to the CSS background-color attribute. You can set this property to an RGB value (e.g. #22AAFF) or a named color (e.g. red) from a list of browser supported color names.

**Flags**: RW

---
## ClassAttr: Array.DATE_VALUES

### Description
This is a built-in comparator for the \[find\](#method-arrayfind) and \[findIndex\](#method-arrayfindindex) methods of Array. Passing this comparator to those methods will find instances where Dates in the search criteria match Dates in the array members (ordinarily, Javascript only regards Dates as equal if they refer to the exact same object). This comparator compares _logical_ dates; the time elements of the values being compared are ignored, so two Dates representing different times on the same day will be considered equal.

### See Also

- [Array.DATETIME_VALUES](#classattr-arraydatetime-values)

**Flags**: R

---
## Attr: Canvas.hoverHeight

### Description
If `this.showHover` is true, this property can be used to customize the height of the hover canvas shown.

### Groups

- hovers

### See Also

- [Canvas.showHover](#attr-canvasshowhover)

**Flags**: IRW

---
## Group: monthViewFormatting

### Description
—

---
## Object: EventStreamData

### Description
A JavaScript object representing the state of a live \[class:EventStream\](#class-eventstream) instance, including all captured events retained by the stream. When \[method:EventStream.end\](#method-eventstreamend) is called to complete capturing, a `EventStreamData` object is returned.

Note that `EventStreamData` is essentially JSON, except that dates remain JavaScript \[object:Date\](#object-date)s, rather than being converted to string format. This ensures that if you \[serialize\](#classmethod-jsonencode) the data and then \[deserialize\](#classmethod-jsondecode) it, dates round trip properly and time zone information is not lost.

### Groups

- experimental

### See Also

- [EventStreamEvent](#object-eventstreamevent)

---
## Attr: DataSource.sequenceMode

### Description
For fields of \[type\](#attr-datasourcefieldtype) "sequence" in a dataSource of \[serverType\](#attr-datasourceservertype) "sql", indicates the \[type:SequenceMode\](#type-sequencemode) to use. This property has no effect for fields or dataSources of other types.

You can set a default sequenceMode for all DataSources of a given database type by setting property "sql.{database\_type}.default.sequence.mode" in `server.properties`. You set a global default sequenceMode that applies to all database types by setting property "sql.default.sequence.mode". For example:

   sql.mysql.default.sequence.mode: jdbcDriver

**Flags**: IR

---
## Method: WebService.getFetchDS

### Description
Retrieve a DataSource that provides read-only access to records returned by a web service operation.

\[DataBound Components\](#interface-databoundcomponent) can be bound to the returned DataSource, and the \[fetchData()\](#method-listgridfetchdata) method can be invoked to retrieve data from the web service.

The returned DataSource is only capable of the "fetch" \[DataSource operation\](#group-datasourceoperations), not "update", "add" or "remove". To create a DataSource capable of full read-write access, use \[attr:DataSource.operationBindings\](#attr-datasourceoperationbindings) with the \[wsOperation\](#attr-operationbindingwsoperation) property set to associate each DataSource operation with a web service operation.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| operationName | [String](#type-string) | false | — | name of the web service operation to invoke to fetch records |
| resultType | [String](#type-string) | false | — | tag or type name of the XML element to be returned as DataSource records |
| operationBindingProperties | [OperationBinding Properties](#type-operationbinding-properties) | true | — | Optional additional properties for the operationType:"fetch" \[operationBinding\](#class-operationbinding) which this method automatically creates. This can be used to set properties such as \[attr:OperationBinding.useFlatFields\](#attr-operationbindinguseflatfields) or \[attr:OperationBinding.recordXPath\](#attr-operationbindingrecordxpath) |

### Groups

- webService

---
## Attr: ListGrid.canAddAISummaryFields

### Description
Adds an item to the header context menu allowing users to launch a dialog to define a new field based on an AI summary of the entire record.

AI summary fields can be persisted via \[method:ListGrid.getFieldState\](#method-listgridgetfieldstate) and \[method:ListGrid.setFieldState\](#method-listgridsetfieldstate).

**Flags**: IRW

---
## Attr: DSRequest.textMatchStyle

### Description
For "fetch" operations, how search criteria should be interpreted for text fields: one of "exact" for exact match, "exactCase" for case-sensitive exact match, "startsWith" for matching at the beginning only, or "substring" for substring match. All `textMatchStyle` settings except "exactCase" are case-insensitive; use \[object:AdvancedCriteria\](#object-advancedcriteria) for greater control over matching.

This property defaults to the value of \[attr:DataSource.defaultTextMatchStyle\](#attr-datasourcedefaulttextmatchstyle) if it is not explicitly provided on the `DSRequest`. Note, however, that DSRequests issued by \[class:ListGrid\](#class-listgrid)s and other \[components\](#interface-databoundcomponent) will generally have a setting for textMatchStyle on the component itself (see \[attr:ListGrid.autoFetchTextMatchStyle\](#attr-listgridautofetchtextmatchstyle), for example).

This setting is respected by the built-in server-side connectors for SQL, JPA and Hibernate. A custom server-side DataSource implementation should generally respect this flag as well, or server-side filtering will not match client-side filtering, which will require \[disabling client-side filtering\](#attr-resultsetuseclientfiltering), a huge performance loss.

**Flags**: IR

---
## Method: PortalLayout.getPortletArray

### Description
Returns a multi-level array of the \[Portlets\](#class-portlet) in this PortalLayout, where the first level corresponds to columns, the second to rows, and the third to Portlets within rows.

### Returns

`[Array of Array of Array of Portlet](#type-array-of-array-of-array-of-portlet)` — portlets

### See Also

- [PortalLayout.getPortlets](#method-portallayoutgetportlets)

---
## Attr: Canvas.isSnapAlignCandidate

### Description
Flag to disable snapping to alignment against this Canvas when _other_ Canvases dragged into the same parent when \[attr:Canvas.childrenSnapAlign\](#attr-canvaschildrensnapalign) is enabled on this Canvas' parent.

### Groups

- snapGridDragging

**Flags**: IRW

---
## Method: FilterBuilder.filterChanged

### Description
Handler fired when there is a change() event fired on any FormItem within the filterBuilder.

---
## Class: IconImgButton

### Description
A specialized subclass of \[class:ImgButton\](#class-imgbutton) designed to show an icon that launches a \[context menu\](#attr-canvascontextmenu) when clicked. The icon is specified as the \[src\](#attr-iconimgbuttonsrc) property.

### See Also

- [StatefulCanvas.showMenuOnClick](#attr-statefulcanvasshowmenuonclick)

---
## Method: StretchImg.setIgnoreRTL

### Description
Setter for \[attr:StretchImg.ignoreRTL\](#attr-stretchimgignorertl).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| ignoreRTL | [boolean](#type-boolean) | false | — | new value for ignoreRTL. |

**Flags**: A

---
## Attr: FormulaBuilder.sampleHeaderTitle

### Description
The default title for the "Sample" panel, which displays a sample result for the formula.

### Groups

- i18nMessages

**Flags**: IRWA

---
## Attr: GridRenderer.baseStyle

### Description
The base name for the CSS class applied to cells. This style will have "Dark", "Over", "Selected", or "Disabled" appended to it according to the state of the cell.

### Groups

- cellStyling

### See Also

- [GridRenderer.getCellStyle](#method-gridrenderergetcellstyle)
- [GridRenderer.getBaseStyle](#method-gridrenderergetbasestyle)

**Flags**: IR

---
## Attr: Lane.sublanes

### Description
Array of \[object:Lane\](#object-lane) objects that will share the available space in the parent Lane, vertically in \[timelines\](#attr-calendartimelineview) and horizontally in \[day views\](#attr-calendardayview).

Only one level of sublanes is supported, so this attribute only has an effect on \[top-level lanes\](#attr-calendarlanes).

Note that this feature is mutually exclusive with the \[auto arrangement\](#attr-calendareventautoarrange) of events that share time.

**Flags**: IR

---
## ClassMethod: Time.getDefaultDisplayTimezone

### Description
Returns the default display timezone set up by \[classMethod:Time.setDefaultDisplayTimezone\](#classmethod-timesetdefaultdisplaytimezone). If no explicit timezone has been set this will return the browser locale timezone offset.

### Returns

`[String](#type-string)` — String of the format `+/-HH:MM`

---
## Attr: GridRenderer.emptyCellValue

### Description
Value to show in empty cells (when getCellValue returns null).

### Groups

- cellStyling

**Flags**: IRW

---
## Attr: Process.state

### Description
Current state of a process. As with Records in general, any field of a Record may contain a nested Record or Array of Records, so the process state is essentially a hierarchical data structure.

#### Transient state
In addition to the explicit process state there is a "transient state." The transient state represents the complete output of each of the last tasks of each type within the current process execution. This allows easy reference to the previous task output with \[taskInputExpressions\](#type-taskinputexpression).

**Flags**: IRW

---
## Method: DynamicForm.setTarget

### Description
Sets the \[target\](#attr-dynamicformtarget) for this form.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| target | [String](#type-string) | false | — | New submission target |

---
## Attr: TreeGrid.openerIconSize

### Description
Default width and height in pixels of the opener icons, that is, the icons which show the open or closed state of the node, typically a \[+\] or \[-\] symbol, if not overridden by \[attr:TreeGrid.openerIconWidth\](#attr-treegridopenericonwidth)/\[attr:TreeGrid.openerIconHeight\](#attr-treegridopenericonheight).

If \[attr:TreeGrid.showConnectors\](#attr-treegridshowconnectors) is true, the opener icon includes the connector line, and defaults to \[cellHeight\](#attr-listgridcellheight).

Otherwise, `openerIconSize` defaults to \[attr:TreeGrid.iconSize\](#attr-treegridiconsize).

### Groups

- treeIcons

**Flags**: IRW

---
## Attr: DrawnValue.record

### Description
The data record of the data point from which this `drawnValue` was created.

Note that a chart with an \[inlined facet\](#attr-facetinlinedvalues) or a \[multi-axis chart\](#attr-facetchartextraaxismetrics) may define multiple data points in the same record, each of which will correspond to a different `drawnValue`. The way to uniquely identify the data value of this particular `drawnValue` is to use the \[attr:DrawnValue.facetValues\](#attr-drawnvaluefacetvalues).

**Flags**: IR

---
## Attr: ServerObject.bean

### Description
For use when \[attr:ServerObject.lookupStyle\](#attr-serverobjectlookupstyle) is `"spring"` or `"cdi"`, id (name) of the bean to ask Spring (CDI) to create.

**Flags**: IR

---
## Attr: Canvas.hoverMoveWithMouse

### Description
If `this.showHover` is true, should this widget's hover canvas be moved with the mouse while visible?

### Groups

- hovers

### See Also

- [Canvas.showHover](#attr-canvasshowhover)

**Flags**: IRW

---
## Method: DynamicForm.fetchData

### Description
Retrieve data that matches the provided criteria, and edit the first record returned

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| criteria | [Criteria](#type-criteria) | true | — | search criteria |
| callback | [DSCallback](#type-dscallback) | true | — | callback to invoke on completion |
| requestProperties | [DSRequest](#type-dsrequest) | true | — | additional properties to set on the DSRequest that will be issued |

### Groups

- dataBoundComponentMethods

---
## Method: ViewLoader.getView

### Description
Retrieve the current view. May be null if the view has not yet been loaded, or has been explicitly set to null.

### Returns

`[Canvas](#type-canvas)` — the current view

### Groups

- contentLoading

---
## Attr: RPCRequest.downloadToNewWindow

### Description
When \[downloadResult\](#attr-rpcrequestdownloadresult) is true, setting this attribute to true causes the content of the downloaded file to be displayed in a new browser window.

Note that this setting is currently incompatible with \[transport:"xmlHttpRequest"\](#attr-rpcrequesttransport). See the \[downloadResult\](#attr-rpcrequestdownloadresult) documentation for more details on xmlHttpRequest downloads

**Flags**: IRWA

---
## ClassMethod: Page.setTitle

### Description
Set the title of the page, which is typically shown as part of the browser window title

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| title | [String](#type-string) | false | — | the browser page title |

---
## Attr: Calendar.implicitCriteria

### Description
Criteria that are never shown to or edited by the user and are cumulative with any criteria provided via \[attr:DataBoundComponent.initialCriteria\](#attr-databoundcomponentinitialcriteria) and related methods.

This property supports \[group:dynamicCriteria\](#group-dynamiccriteria) - use \[attr:Criterion.valuePath\](#attr-criterionvaluepath) to refer to values in the \[attr:Canvas.ruleScope\](#attr-canvasrulescope).

**Flags**: IRW

---
## Attr: DateChooser.previousYearButton

### Description
A button shown in the \[navigation layout\](#attr-datechoosernavigationlayout) that shifts the calendar view backward by a year.

**Flags**: IR

---
## ClassMethod: Offline.goOnline

### Description
Explicitly sets this session into online mode. This setting will override whatever state the browser reports. This allows users to manually set an application into offline or online state.

### See Also

- [Offline.goOffline](#classmethod-offlinegooffline)
- [Offline.useNativeOfflineDetection](#classmethod-offlineusenativeofflinedetection)

---
## Attr: ToolStrip.verticalStyleName

### Description
Default stylename to use if \[this.vertical\](#attr-toolstripvertical) is true. If unset, the standard \[attr:ToolStrip.styleName\](#attr-toolstripstylename) will be used for both vertical and horizontal toolstrips.

Note that this property only applies to the widget at init time. To modify the styleName after this widget has been initialized, you should simply call \[setStyleName()\](#method-canvassetstylename) rather than updating this property.

### Groups

- appearance

**Flags**: IR

---
## Method: Tree.getFolders

### Description
Returns all the first-level folders of a node.  
  
For load on demand trees (those that only have a partial representation client-side), this method will return only nodes that have already been loaded from the server.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| node | [TreeNode](#type-treenode) | false | — | node in question |

### Returns

`[Array of TreeNode](#type-array-of-treenode)` — List of immediate children that are folders

---
## Method: ListGrid.getHeaderContextMenuItems

### Description
If \[attr:ListGrid.showHeaderContextMenu\](#attr-listgridshowheadercontextmenu) is `true` this method returns the menu items to be displayed in the default header context menu.

This method is called at various times, including during redraws, as the mouse moves over a ListGrid header button and each time the menu is actually displayed - this allows for dynamic content depending on the current state of the grid and its fields.

Consequently, this method should not instantiate any classes, because they'll be re-created on each call, resulting in a leak - your implementation should return an array of menuItem config-blocks only, so you shouldn't instantiate actual Menu instances to apply as the \[submenu\](#attr-menuitemsubmenu) of items - instead, set submenu to a simple array of menuItems. If your use-case necessitates that class instances are created, because specific submenus have a different Menu class, for example, you should keep a reference to them and either, if their content is dynamic, destroy and recreate them with the new items, or just return the existing instances otherwise.

The default set of menu items includes items for built-in ListGrid features like showing and hiding fields, freezing fields or grouping by them, and other functions.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| fieldNum | [Integer](#type-integer) | true | — | Index of the field the user clicked in the \[fields\](#attr-listgridfields) array. 
#### Note:
 if the user right-clicked the sorter button this parameter will be `null`. |

### Returns

`[Array of MenuItem](#type-array-of-menuitem)` — —

### Groups

- gridHeader

---
## Attr: NotifyAction.methodName

### Description
The method to invoke on the \[attr:NotifyAction.target\](#attr-notifyactiontarget) when the action is executed.

**Flags**: IR

---
## Method: DataSource.formatFieldValue

### Description
Formats the supplied value using the \[class:SimpleType\](#class-simpletype) derived from the field definition.

Note that if \[attr:DataSourceField.format\](#attr-datasourcefieldformat) is defined for a date, time or numeric-based value, or \[attr:DataSourceField.dateFormatter\](#attr-datasourcefielddateformatter) or \[attr:DataSourceField.timeFormatter\](#attr-datasourcefieldtimeformatter) is defined for a date or time-based value, that format is given priority and used to format the value rather than the `SimpleType`.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| field | [DataSourceField](#type-datasourcefield)|[FieldName](#type-fieldname) | false | — | name of the field to use to format value |
| value | [Any](#type-any) | false | — | raw value to be formatted |

### Returns

`[String](#type-string)` — formatted value or null

---
## ClassAttr: Canvas.loadingImageSrc

### Description
Image URL to be displayed while data is being loaded (if enabled for the widget waiting for data). Must be square; \[classAttr:Canvas.loadingImageSize\](#classattr-canvasloadingimagesize) specifies the width and height.

### Groups

- animation

### See Also

- [ListGrid.loadingDataMessage](#attr-listgridloadingdatamessage)
- [DetailViewer.loadingMessage](#attr-detailviewerloadingmessage)
- [HTMLFlow.loadingMessage](#attr-htmlflowloadingmessage)
- [ViewLoader.loadingMessage](#attr-viewloaderloadingmessage)

**Flags**: RWA

---
## Attr: DynamicForm.linearAutoSpanItems

### Description
When a form is rendered in \[attr:DynamicForm.linearMode\](#attr-dynamicformlinearmode), should each item appear on its own row, spanning the full set of rendered columns by default?

**Flags**: IRW

---
## Attr: Canvas.keepInParentRect

### Description
Constrains drag-resizing and drag-repositioning of this canvas to either the rect of its parent (if set to true) or an arbitrary rect based on its parent (if set to a \[Left,Top,Width,Height\] rect array). In the latter mode you may use negative offsets for left/top and a width/height greater than the visible or scroll width of the parent to allow positioning beyond the confines of the parent.

If this canvas has no parent, constrains dragging to within the browser window.

Affects target and outline dragAppearance, not tracker.

Note: keepInParentRect affects only user drag interactions, not programmatic moves.

Example use cases:  
`keepInParentRect: true` - confine to parent  
`keepInParentRect: [0, 0, 500, 500]` - confine to top left 500x500 region within parent  
`keepInParentRect: [0, 0, 10000, 10000]` - in combination with overflow: "auto", confine to parent, but allow moving off the right and bottom of the parent to force scrolling (and hence enlarge the scrollWidth of the parent).

### Groups

- dragdrop

**Flags**: IRWA

---
## Attr: MenuBar.menus

### Description
An array of menu object initializers or instantiated menu objects. Buttons for each menu item will automatically be created. See the Menu Widget Class for fundamental menu properties and other properties. Titles for the buttons are derived from the `title` property of each menu.

### See Also

- [Menu](#class-menu)

**Flags**: IRW

---
## ClassAttr: DynamicForm.NORMAL

### Description
A declared value of the enum type \[Encoding\](#type-encoding).

**Flags**: R

---
## ClassMethod: Class.changeDefaults

### Description
Changes a set of defaults defined as a JavaScript Object. For these kind of properties, simply calling \[method:Class.addProperties\](#method-classaddproperties) would replace the original Object with yours, wiping out settings required for the basic functionality of the component. This method instead applies your overrides over the existing properties, without destroying non-overridden properties.

For example let's say you have a component that's defined as follows

 isc.defineClass("MyComponent");
 isc.MyComponent.addProperties({
     simpleProperty: "some value",
     propertyBlock : {
       foo: "bar",
       zoo: "moo"
     }
 }
 

If you wanted to override simpleProperty, you can just call \[method:Class.addProperties\](#method-classaddproperties) like this:

 isc.MyComponent.addProperties({
     simpleProperty: "my override"
 });
 

If you want to override the value of `propertyBlock.moo` above, but you don't want to clobber the value of `propertyBlock.zoo`. If you use the above pattern like so:

 isc.MyComponent.addProperties({
     propertyBlock: {
         foo: "new value",
         zoo: "moo"
     }
 });
 

You need to re-specify the value of `propertyBlock.zoo` which you didn't want to override. Failing to re-specify it would destroy the value.

Instead of re-specifying the value, you can use this method to modify the value of `foo` - like this:

 isc.MyComponent.changeDefaults("propertyBlock", {
     foo: "new value"
 });
 

See also the \[type:AutoChild\](#type-autochild) system for information about standard sets of defaults that are available for customization.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| defaultsName | [String](#type-string) | false | — | name of the property to change |
| newDefaults | [Object](#type-object) | false | — | overrides for defaults |

**Flags**: A

---
## Method: EditPane.getPaletteNodesFromJS

### Description
Obtain \[PaletteNodes\](#object-palettenode) from a JavaScript source representation.

By default, components that have \[global IDs\](#attr-canvasid) will not actually be allowed to take those global IDs - instead, only widgets that have one of the global IDs passed as the `globals` parameter will actually receive their global IDs. To override this behavior, pass the special value \[classAttr:RPCManager.ALL\_GLOBALS\](#classattr-rpcmanagerall-globals) for the `globals` parameter.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| jsCode | [String](#type-string) | false | — | JavaScript code to eval. |
| callback | [PaletteNodeCallback](#type-palettenodecallback) | false | — | Callback used to return the PaletteNodes |
| globals | [Array of String](#type-array-of-string) | true | — | widgets to allow to take their global IDs |

### See Also

- [Callbacks.PaletteNodeCallback](#method-callbackspalettenodecallback)

---
## Attr: TileGrid.wrapValues

### Description
Whether values should be allowed to wrap by default, or should be shown on one line regardless of length.

**Flags**: IR

---
## Method: Array.slide

### Description
Slide element at position start to position destination, moving all the other elements to cover the gap.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| start | [number](#type-number) | false | — | start position |
| destination | [number](#type-number) | false | — | destination position for the value at start |

**Flags**: A

---
## Attr: TourStep.bindEnteredText

### Description
When set on a step with an \[actionType\](#attr-tourstepactiontype) of "change", the entered or selected value will be automatically bound to the specified value in the \[tour state\](#attr-processstate).

**Flags**: IR

---
## Method: ColumnTree.getRecord

### Description
Retrieve a record by index.

If `colNum` is passed, returns the record found in that column at that index, or null if the column doesn't exist or the index is too high.

With no `colNum` parameter, a record's index is it's position counting from the first record of the first column and including all records in each column. Note that both index and colNum are zero-based - so the first column is column 0, not column 1.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| index | [int](#type-int) | false | — | index of record to return. |
| colNum | [Integer](#type-integer) | true | — | optional index of the column |

### Returns

`[TreeNode](#type-treenode)` — node at the specified index

---
## ClassAttr: RPCResponse.STATUS_MAX_LOGIN_ATTEMPTS_EXCEEDED

### Description
Indicates that too many authentication attempts have been made and the server refuses to accept any more login attempts.

### Groups

- statusCodes
- constant

### See Also

- [RPCRequest](#object-rpcrequest)

**Flags**: R

---
## Attr: RichTextEditor.pasteSelectionPrompt

### Description
The prompt for the built-in \[pasteSelection\](#type-controlname) control.

### Groups

- i18nMessages

**Flags**: IRW

---
## Attr: TreeGrid.canReorderRecords

### Description
Indicates whether records can be reordered by dragging within this `ListGrid`.

**NOTE:** If `canReorderRecords` is initially enabled or might be \[dynamically enabled\](#method-listgridsetcanreorderrecords) after the grid is created, it may be desirable to disable \[touch scrolling\](#attr-canvasusetouchscrolling) so that touch-dragging a record starts a reorder operation rather than a scroll, but see the discussion of \[drag handles\](#method-listgridshowdraghandles). If \[attr:Canvas.disableTouchScrollingForDrag\](#attr-canvasdisabletouchscrollingfordrag) is set to `true`, then touch scrolling will be disabled automatically. However, for \[accessibility\](#group-accessibility) reasons, it is recommended to leave touch scrolling enabled and provide an alternative set of controls that can be used to perform drag-reordering of records.

### Groups

- treeGridDrop

### See Also

- [TreeNode.canDrag](#attr-treenodecandrag)
- [TreeNode.canAcceptDrop](#attr-treenodecanacceptdrop)
- [ListGrid.showDragHandles](#method-listgridshowdraghandles)

**Flags**: IRWA

---
## Method: DataBoundComponent.editHilites

### Description
Shows a \[HiliteEditor\](#class-hiliteeditor) interface allowing end-users to edit the data-hilites currently in use by this DataBoundComponent.

### Groups

- hiliting

---
## Attr: Menu.fillSpaceStyleName

### Description
If set, alternative body style for the menu used when there is no icon field and the \[attr:Menu.placement\](#attr-menuplacement) settings indicate the menu will be filling a portion of the screen or a panel. Generally this alternative style should not have rounded or excessively large edges. If unset, then \[attr:Menu.bodyStyleName\](#attr-menubodystylename) is used instead.

When there is an icon field, \[attr:Menu.iconFillSpaceStyleName\](#attr-menuiconfillspacestylename), if set, overrides this setting.

### Groups

- appearance

**Flags**: IR

---
## Method: EditTree.makePaletteNode

### Description
Creates a \[object:PaletteNode\](#object-palettenode) from an \[object:EditNode\](#object-editnode) in this context's \[editNodeTree\](#method-edittreegeteditnodetree).

This essentially creates a new \[object:PaletteNode\](#object-palettenode) with the \[attr:EditNode.defaults\](#attr-editnodedefaults) from the passed `editNode`. The returned `paletteNode` could then be used with \[method:EditContext.addFromPaletteNode\](#method-editcontextaddfrompalettenode) to effectively create a copy of the original editNode - specifically a new editNode with a new \[attr:EditNode.liveObject\](#attr-editnodeliveobject) created from the same defaults.

However note that `makePaletteNode()` does not copy descendant nodes - use \[method:EditTree.makePaletteNodeTree\](#method-edittreemakepalettenodetree) for that.

May return null if the passed editNode cannot validly by transformed into a paletteNode, for example if \[attr:EditNode.canDuplicate\](#attr-editnodecanduplicate) was set false.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| editNode | [EditNode](#type-editnode) | false | — | the editNode to use to make a paletteNode |

### Returns

`[PaletteNode](#type-palettenode)` — paletteNode derived from the editNode or null

---
## Attr: UploadItem.capture

### Description
This attribute enables camera capture functionality for mobile devices, accepting the following values:

*   Set it to "user" to capture using the front-facing camera.
*   Set it to "environment" to capture using the rear-facing camera.

Please note that in the latest versions of Android and iOS, utilizing this attribute will consistently load the rear camera. This behavior is due to the direct camera software's ability to switch between the two cameras seamlessly.

When working with the capture functionality of iPhones and Android devices, it's important to consider the supported DataSourceField.mimeTypes for audio, video, and image files that can be used with the fileItem.accept attribute. Here's a list of commonly supported mime types for capturing on these devices:

Supported Image Mime Types:

*   image/jpeg: JPEG image format (.jpg, .jpeg)
*   image/png: Portable Network Graphics format (.png)

Supported Audio Mime Types:

*   audio/3gpp: 3GPP format, commonly used for audio capture.
*   audio/mp4: MP4 format, widely supported for audio capture.

Supported Video Mime Types:

*   video/3gpp: 3GPP format, commonly used for video capture.
*   video/mp4: MP4 format, widely supported for video capture.

#### Behavior Based on 'accept' Attribute

The behavior of using the capture attribute depends on the value used in the accept attribute. For example:

*   _accept="image/\*"_ will load the camera ready to take pictures.
*   _accept="audio/\*"_ will load the default audio recorder, not the camera.
*   _accept="video/\*"_ will load the camera in video mode, ready to capture videos.

Please note that the SmartClient framework does not control the native device behavior beyond these attribute settings.

Lastly, keep in mind that these settings have no effect on desktop browsers; they apply exclusively to mobile devices.

This information is "circa 2023" and may not apply to all devices.

**Flags**: IR

---
## Attr: CubeGrid.dataSource

### Description
DataSource to use to fetch CubeGrid data.

The DataSource should have a field named after each facetId. The CubeGrid will submit requests for data as DataSource "fetch" operations that request \[cellRecords\](#object-cellrecord) only for currently visible area (including \[drawAheadRatio\](#attr-listgriddrawaheadratio)). The \[type:Criteria\](#type-criteria) passed in each fetch operation will be a \[object:FacetValueMap\](#object-facetvaluemap) that corresponds to a rectangular swath of cells the CubeGrid needs data for, for example:

      { region:"west", product:\["chair", "table"\], timePeriod:"Q1 2004" }
 

Note that in the criteria above, the Array value for the "product" facet indicates the CubeGrid needs cellRecords for both the "chair" and "table" facetValues.

\[attr:CubeGrid.fixedFacetValues\](#attr-cubegridfixedfacetvalues), if any, are always sent in each "fetch" operation.

Scrolling, expanding/collapsing tree facets, pivoting, and changing the currently visible facets may all trigger data requests.

The CubeGrid will generally attempt to fetch a minimal set of data to fill the viewport, sending multiple fetch operations in a batch (via \[queueing\](#classmethod-rpcmanagerstartqueue)) which minimally describe newly revealed areas without specifying each individual cell. The CubeGrid will automatically handle being provided _more_ data than was asked for, so server-side fetch-ahead policies can be implemented without any client-side customization.

Note that the \[SQL connector\](#attr-datasourceservertype) shipped with the SmartClient SDK is capable of responding to the CubeGrid's data requests without writing any custom server code.

**Flags**: IR

---
## Group: columnControls

### Description
—

---
## Attr: DetailViewerField.valueMap

### Description
A property list (or an expression that evaluates to a property list) specifying a mapping of internal values to display values for the field (row).

**Flags**: IR

---
## Attr: Calendar.dataSource

### Description
The DataSource that this component should bind to for default fields and for performing \[DataSource requests\](#object-dsrequest).

Can be specified as either a DataSource instance or the String ID of a DataSource.

### Groups

- databinding

**Flags**: IRW

---
## Attr: FacetChart.showValueOnHover

### Description
Shows the value of the nearest data value in a floating label whenever the mouse moves within the main chart area. The visual element representing the data value will also be emphasized by brightening or highlighting it (appearance differs by chart type).

Calculates nearest value based on \[method:FacetChart.getNearestDrawnValue\](#method-facetchartgetnearestdrawnvalue).

The data value will be formatted using \[method:FacetChart.formatDataValue\](#method-facetchartformatdatavalue). The label's appearance is controlled by \[attr:FacetChart.hoverLabelProperties\](#attr-facetcharthoverlabelproperties).

### Groups

- appearance

**Deprecated**

**Flags**: IR

---
## Method: ResultSet.filterLocalData

### Description
Derive the current filtered set of data from the cache of all matching rows.

This method is automatically called by \[method:ResultSet.setCriteria\](#method-resultsetsetcriteria) when criteria have actually changed, as well as in various other situations. You could only need to call this method directly if:

*   you know that client-side filtering is enabled (\[attr:ResultSet.useClientFiltering\](#attr-resultsetuseclientfiltering):true) and active \[method:ResultSet.allMatchingRowsCached\](#method-resultsetallmatchingrowscached).
*   you have directly, programmatically modified data within the ResultSet such that it no longer matches the filter criteria
*   you want your modified records to disappear from the list of visible records (that is, those accessible via \[method:ResultSet.get\](#method-resultsetget))

**Flags**: A

---
## Attr: ImgTab.skinImgDir

### Description
Base path for the images. 
#### Note
 that when used within a TabSet, the \[attr:TabSet.tabBarPosition\](#attr-tabsettabbarposition) is appended as an additional path segment, yielding "images/Tab/top/" et al.

**Flags**: IRW

---
## Attr: Canvas.opacity

### Description
Renders the widget to be partly transparent. A widget's opacity property may be set to any number between 0 (transparent) to 100 (opaque). Null means don't specify opacity directly, 100 is fully opaque. Note that heavy use of opacity may have a performance impact on some older browsers.

In older versions of Internet Explorer (Pre IE9 / HTML5), opacity is achieved through proprietary filters. If \[filters have been disabled\](#classattr-canvasneverusefilters) within this application developers must set \[attr:Canvas.useOpacityFilter\](#attr-canvasuseopacityfilter) to true for specific components on which opacity support is required.

Also note that opacity is incompatible with \[backMasks\](#attr-canvasusebackmask).

### Groups

- cues

**Flags**: IRWA

---
## Attr: DetailViewerField.imageURLSuffix

### Description
If this field has type set to `"image"`, the value of this property will be appended to the end of the URL for the icon displayed.

### Groups

- imageColumns

**Flags**: IRWA

---
## Attr: Label.iconWidth

### Description
Width in pixels of the icon image.

If unset, defaults to \[iconSize\](#attr-statefulcanvasiconsize).

### Groups

- buttonIcon

**Flags**: IR

---
## ClassMethod: Page.getAppFilesDir

### Description
Returns the directory for application-specific files (other than images).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| URL | [String](#type-string) | true | — | New app files URL. |

### Groups

- files
- images

---
## Group: gridValidation

### Description
ListGrids support automatic validation of edited cells / records. This group is a collection of APIs related to the validation subsystem.

Default validation occurs in response to the user navigating between edit cells (see \[attr:ListGrid.validateByCell\](#attr-listgridvalidatebycell)) or whenever edited values are to be committed to the server for saving. Standard validation can also be triggered for a cell or row programmatically at any time.  
When standard validation occurs, \[attr:ListGridField.validators\](#attr-listgridfieldvalidators) will be run on each cell to be validated.  
In addition to this standard behavior developers can add custom errors to fields via \[method:ListGrid.setFieldError\](#method-listgridsetfielderror) / \[method:ListGrid.setFieldError\](#method-listgridsetfielderror).

### See Also

- [editing](#group-editing)

---
## ClassMethod: Canvas.resizeControlsTo

### Description
Resizes controls as if calling \[classMethod:Canvas.resizeControls\](#classmethod-canvasresizecontrols), but takes a final target size instead of a delta representing the change from a current size. Note that all the same limitations apply.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| targetDelta | [int](#type-int) | false | — | the final size, expressed as a differential from the default |

---
## Group: elements

### Description
Manipulating native form elements

---
## Attr: CubeGrid.bodyMinWidth

### Description
Minimum width for the body of this cubeGrid.

### Groups

- gridLayout

**Flags**: IRWA

---
## Method: DrawItem.setLineWidth

### Description
Update lineWidth for this drawItem.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| width | [int](#type-int) | false | — | new pixel lineWidth |

---
## ClassAttr: RPCResponse.STATUS_AUTHORIZATION_FAILURE

### Description
Indicates a \[Declarative Security\](#group-declarativesecurity) failure on the server. See the error handling section in \[RPCManager documentation\](#class-rpcmanager) for more information.

### Groups

- statusCodes
- constant

### See Also

- [RPCRequest](#object-rpcrequest)

**Flags**: R

---
## Method: IMenuButton.setShowMenuBelow

### Description
Setter for the 'showMenuButtonBelow' property - determines whether the menu will be shown above or below the `MenuButton`.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| below | [boolean](#type-boolean) | false | — | True if the menu should be shown below the `MenuButton`. |

### Groups

- menu

---
## Group: fields

### Description
—

---
## Method: Canvas.getViewportWidth

### Description
Returns the width of the viewport onto the scrollable content.

See \[group:gettingCanvasSize\](#group-gettingcanvassize)

### Returns

`[number](#type-number)` — width of the viewport, in pixels

### Groups

- sizing

**Flags**: A

---
## ClassAttr: RPCManager.timeoutErrorMessage

### Description
Default message displayed to user when an operation fails to return from the server within the timeout period specified by \[classAttr:RPCManager.defaultTimeout\](#classattr-rpcmanagerdefaulttimeout).

### Groups

- i18nMessages

### See Also

- [RPCManager.defaultTimeout](#classattr-rpcmanagerdefaulttimeout)

**Flags**: IRW

---
## Attr: TileGrid.implicitCriteria

### Description
Criteria that are never shown to or edited by the user and are cumulative with any criteria provided via \[attr:DataBoundComponent.initialCriteria\](#attr-databoundcomponentinitialcriteria) and related methods.

This property supports \[group:dynamicCriteria\](#group-dynamiccriteria) - use \[attr:Criterion.valuePath\](#attr-criterionvaluepath) to refer to values in the \[attr:Canvas.ruleScope\](#attr-canvasrulescope).

**Flags**: IRW

---
## Attr: DrawPolygon.knobs

### Description
DrawPolygon only supports the "move" knob type.

### See Also

- [DrawItem.knobs](#attr-drawitemknobs)

**Flags**: IR

---
## Attr: FormItem.valueIconWidth

### Description
If \[attr:FormItem.valueIcons\](#attr-formitemvalueicons) is specified, use this property to specify a width for the value icon written out.

### Groups

- valueIcons

### See Also

- [FormItem.valueIconHeight](#attr-formitemvalueiconheight)
- [FormItem.valueIconSize](#attr-formitemvalueiconsize)

**Flags**: IRW

---
## Attr: SliderItem.vertical

### Description
Indicates whether this is a vertical or horizontal slider.

**Flags**: IR

---
## Method: DynamicForm.getValuesAsAdvancedCriteria

### Description
Return an AdvancedCriteria object based on the current set of values within this form.

Similar to \[method:DynamicForm.getValuesAsCriteria\](#method-dynamicformgetvaluesascriteria), except the returned criteria object is guaranteed to be an AdvancedCriteria object, even if none of the form's fields has a specified \[attr:FormItem.operator\](#attr-formitemoperator)

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| textMatchStyle | [TextMatchStyle](#type-textmatchstyle) | true | — | If specified the text match style will be used to generate the appropriate `operator` for per field criteria. |

### Returns

`[AdvancedCriteria](#type-advancedcriteria)` — a \[object:AdvancedCriteria\](#object-advancedcriteria) based on the form's current values

### Groups

- criteriaEditing

---
## Method: ListGrid.saveAllEdits

### Description
Save a number of outstanding edits for this ListGrid. If no rows are specified, all outstanding edits will be saved.

Note that if \[attr:ListGrid.saveRequestProperties\](#attr-listgridsaverequestproperties) is specified and the grid is performing a databound save, these properties will be applied to each generated DSRequest.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| rows | [Array of Number](#type-array-of-number) | true | — | optionally specify which rows to save |
| saveCallback | [Callback](#type-callback) | true | — | If specified this callback will be fired on a successful save of the specified rows. Note that if there are no pending edits to be saved this callback will not fire - you can check for this condition using \[method:ListGrid.hasChanges\](#method-listgridhaschanges) or \[method:ListGrid.rowHasChanges\](#method-listgridrowhaschanges). Use \[method:ListGrid.editFailed\](#method-listgrideditfailed) to find out about failures encountered during saving (on a per-row basis). |

### Returns

`[boolean](#type-boolean)` — true if a save has been initiated (at least one row had changes, passed client-side validation, and a save has been attempted). False otherwise

### Groups

- editing

---
## Attr: Layout.minMemberLength

### Description
Minimum size, in pixels, below which flexible-sized members should never be shrunk, even if this requires the Layout to overflow. Note that this property only applies along the _length_ axis of the Layout, and has no affect on _breadth_.

Does not apply to members given a fixed size in pixels - such members will never be shrunk below their specified size in general.

### Groups

- layoutPolicy

### See Also

- [Canvas.minWidth](#attr-canvasminwidth)

**Flags**: IRW

---
## Attr: SavedSearchForm.overflow

### Description
SavedSearchForms are sized to fit their single item by default

**Flags**: IRW

---
## Attr: FacetChart.maxBarThickness

### Description
Bars will not be drawn over this thickness, instead, margins will be increased.

### Groups

- barChart

### See Also

- [FacetChart.getMinClusterSize](#method-facetchartgetminclustersize)

**Flags**: IR

---
## Attr: ListGrid.criteriaIndicatorColor

### Description
The color of the \[filterWindow criteria indicator\](#attr-listgridshowfilterwindowcriteriaindicator).

**Flags**: IR

---
## ClassAttr: AutoTest.implicitNetworkWait

### Description
Controls whether certain AutoTest APIs wait for network operations to complete before returning true. When value is true, \[classMethod:AutoTest.isElementClickable\](#classmethod-autotestiselementclickable) will return false until all network operations have completed.

### Groups

- autoTest

**Flags**: IRW

---
## Attr: Canvas.updateTabPositionOnReparent

### Description
Should canvases with a \[parent canvas\](#method-canvasgetparentcanvas) be added to the TabIndexManager under the parent as described in \[method:Canvas.updateChildTabPositions\](#method-canvasupdatechildtabpositions) and \[method:Canvas.updateChildTabPosition\](#method-canvasupdatechildtabposition)?

If set to false, the tab-position will not be modified on parent change.

This property is useful for cases where the tab position of a widget will be managed by something other than the parent canvas, for example for \[canvasItem canvases\](#attr-canvasitemcanvas).

**Flags**: IRWA

---
## ClassMethod: DrawItem.computeAngle

### Description
Computes the angle in degrees from the positive X axis to the difference vector 
#### v
2 - 
#### v
1 between the two given vectors.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| px1 | [double](#type-double) | false | — | X coordinate of 
#### v
1 |
| py1 | [double](#type-double) | false | — | Y coordinate of 
#### v
1 |
| px2 | [double](#type-double) | false | — | X coordinate of 
#### v
2 |
| py2 | [double](#type-double) | false | — | Y coordinate of 
#### v
2 |

### Returns

`[double](#type-double)` — the angle in degrees, in the range \[0, 360).

---
## Method: ListGridField.formatCellValue

### Description
Return the HTML to display in cells of this field.

Given the raw value for this field as taken from the record Formatter to apply to the static values displayed in cells for this field.

_Example usage_: formatting a currency value stored in cents (so "100" to "$1.00")  
The value passed to this method is the raw value for the cell.  
Takes precedence over `formatCellValue` defined at the grid level for cells in this field.

Note: this formatter will not be applied to the values displayed in cells being edited. The \[formatEditorValue()\](#method-listgridfieldformateditorvalue) is provided for that purpose.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| value | [Any](#type-any) | false | — | raw value for the cell, from the record for the row |
| record | [ListGridRecord](#type-listgridrecord) | false | — | Record object for the cell. Note: If this is a new row that has not been saved, in an editable grid, it has no associated record object. In this case the edit values will be passed in as this parameter (see \[method:ListGrid.getEditValues\](#method-listgridgeteditvalues)) |
| rowNum | [number](#type-number) | false | — | row number for the cell |
| colNum | [number](#type-number) | false | — | column number for the cell. |
| grid | [ListGrid](#type-listgrid) | false | — | the ListGrid displaying the cell |

### Returns

`[HTMLString](#type-htmlstring)` — HTML to display in the cell

### Groups

- display_values

### See Also

- [ListGrid.formatCellValue](#method-listgridformatcellvalue)
- [ListGridField.formatEditorValue](#method-listgridfieldformateditorvalue)

---
## Method: ListGrid.setHideOnTablet

### Description
Updates the \[attr:ListGridField.hideOnTablet\](#attr-listgridfieldhideontablet) attribute at runtime.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| field | [ListGridField](#type-listgridfield)|[String](#type-string) | false | — | field or field name to update |
| hideOnTablet | [Boolean](#type-boolean) | false | — | new setting for hideOnTablet property |

---
## ClassAttr: Canvas.CLIP_H

### Description
A declared value of the enum type \[Overflow\](#type-overflow).

**Flags**: R

---
## Attr: FieldPicker.removeText

### Description
—

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: AIProgressMessage.content

### Description
The content of the message.

**Flags**: IR

---
## Attr: DataSource.sqlPaging

### Description
The paging strategy to use for this DataSource. If this property is not set, the default paging strategy, specified with the \[server.properties\](#group-server-properties) setting `sql.defaultPaging`, is used.

This setting can be overridden with the \[attr:OperationBinding.sqlPaging\](#attr-operationbindingsqlpaging) property.

#### NOTE:
 Operations that involve a \[customSQL\](#attr-operationbindingcustomsql) clause ignore this property, because customSQL operations usually need to be treated as special cases. For these operations, the paging strategy comes from the \[server.properties\](#group-server-properties) setting `sql.defaultCustomSQLPaging` or `sql.defaultCustomSQLProgressivePaging`, depending on whether or not \[progressiveLoading\](#attr-datasourceprogressiveloading) is in force. Note that these can always be overridden by a `sqlPaging` setting on the OperationBinding.

### See Also

- [OperationBinding.sqlPaging](#attr-operationbindingsqlpaging)

**Flags**: IRW

---
## Attr: FormSaveDataTask.unboundNotifyMessage

### Description
The default message to be shown when a target form is not bound to a DataSource.

### Groups

- i18nMessages

**Flags**: IR

---
## Group: loadISCTag

### Description
See \[group:jspTags\](#group-jsptags)

_produces:_ HTML

This tag sets window.isomorphicDir and loads a default set of SmartClient modules and a skin. SmartClient modules are JavaScript files that need to be loaded via `<SCRIPT SRC=/some/filename.js></SCRIPT>` blocks as part of the loading HTML page. These and \[optional\](#group-loadingoptionalmodules) modules are stored in the `[webroot]/isomorphic/system/modules` directory. A skin defines the look and feel of your website and typically consists of at least one CSS file and some SmartClient UI Component default overrides. Skins are located in `[webroot]/isomorphic/skins`. Loading a skin consists of loading the corresponding `load_skin.js` - residing at top-level in each skin directory.

The default set of modules loaded by this tag are: `Core, Foundation, Containers, Grids, Forms, Drawing, DataBinding, Calendar`.  
The default skin is the `Tahoe` skin.  
So, for example inserting this into your JSP:

 <isomorphic:loadISC/>
 

Produces the output like:

 <SCRIPT>window.isomorphicDir='isomorphic/';</SCRIPT>
 <SCRIPT SRC=isomorphic/system/modules/ISC\_Core.js></SCRIPT>
 <SCRIPT SRC=isomorphic/system/modules/ISC\_Foundation.js></SCRIPT>
 <SCRIPT SRC=isomorphic/system/modules/ISC\_Containers.js></SCRIPT>
 <SCRIPT SRC=isomorphic/system/modules/ISC\_Grids.js></SCRIPT>
 <SCRIPT SRC=isomorphic/system/modules/ISC\_Forms.js></SCRIPT>
 <SCRIPT SRC=isomorphic/system/modules/ISC\_Drawing.js></SCRIPT>
 <SCRIPT SRC=isomorphic/system/modules/ISC\_DataBinding.js></SCRIPT>
 <SCRIPT SRC=isomorphic/system/modules/ISC\_Calendar.js></SCRIPT>
 <SCRIPT src=isomorphic/skins/Tahoe/load\_skin.js></SCRIPT>
 

_(Note: The output you see may differ slightly from the above. The isomorphicDir will be set to an appropriate value based on the location of the file in the file system, and the target URLs for resources may include version information as described in the 
#### versionStyle
 attribute details below.)_

#### Tag Attributes:

#### skin
  
_value format_: Name of skin to load. See the `[webroot]/isomorphic/skins` directory for a list of available skins. You can also create your own skin by copying an existing skin directory recursively, modifying anything you need, and using your new skin name as the value here.  
_default value_: "Tahoe"

This selects a skin other than the default. The value of this attribute is used as a path component to `load_skin.js`. For example, specifying:

 <isomorphic:loadISC skin="Stratus"/>
 

Produces the following `load_skin.js` directive (in addition to all the standard module loads):

 <SCRIPT src=isomorphic/skins/Stratus/load\_skin.js></SCRIPT>
 

#### versionStyle
  
_value format_: one of "param", "pathSegment" or "none"  
_default value_: "param"

By default the URLs generated by a `loadISC` tag include version information. This ensures that the browser will reliably fetch new resources each time a new version of SmartClient is loaded, even if the browser has been instructed to cache these files indefinitely.

\[The default setting of `"param"`\](#group-server-properties) appends a URL parameter of the format "`?isc_version=_SmartClient_Version_`" to each of the `<SCRIPT SRC=... >` tags used to load the framework.

The alternative setting of `"pathSegment"` instead adds a new segment to the URL path of the format "`isc_version._SmartClient_Version_`". The `"isc_version."` prefix is derived from the \[isc.versionPathSegmentPrefix in server.properties\](#group-server-properties). The versioned path-segment will always be added after the isomorphicDir, so the generated output might look like this:

 <SCRIPT>window.isomorphicDir='isomorphic/isc\_version._version_';</SCRIPT>
 <SCRIPT SRC=isomorphic/isc\_version._version_/system/modules/ISC\_Core.js></SCRIPT>
 <SCRIPT SRC=isomorphic/isc\_version._version_/system/modules/ISC\_Foundation.js></SCRIPT>
 ... etc
 

Note that the `"param"` setting ensures that the browser will request new versions of the SmartClient JavaScript libraries, but does not ensure that other resources such as CSS and images under the skin directory will be re-fetched. The `"pathSegment"` setting ensures the browser will request new versions of all SmartClient resources. In order to support this, the SmartClient resources must be made available at the generated URLs. The server side FileDownload servlet, or the dedicated VersionedURLFilter filter will automatically handle stripping out SmartClient-version path segments - see the server side JavaDocs for details.

For more information on caching of resources see the \[caching overview\](#group-caching).

#### skinDir
  
_value format_: path or URL up to and including the name of the skin  
_default value_: automatically derived from the value of the `skin` attribute

This attribute is usable in lieu of the `skin` attribute and allows you to specify the full path or URL to the directory containing the load\_skin.js for your skin. This allows you to move the directory containing the skin anywhere you want - including to a completely different server.

#### includeModules
  
_value format_: Comma separated list of additional modules to load. See the `[webroot]/isomorphic/system/modules` directory for a list of loadable modules. The leading "ISC\_" is optional, spaces after commas are also optional.  
_default value_: NONE

This attribute allows you to specify SmartClient modules that you want to load in addition to the default set of modules. For example, specifying:

 <isomorphic:loadISC includeModules="Analytics"/>
 

Will add a tag to load the module to the generated block of `SCRIPT` tags described above:

 <SCRIPT SRC=isomorphic/system/modules/ISC\_Analytics.js></SCRIPT>
 

SmartClient modules must be loaded in a particular order and may have dependencies on other modules. The `loadISC` automatically resolves any missing dependencies and includes them in the list of modules to load. The list of modules to load is also automatically reordered as required by this tag, so you can specify just the modules you care about, in any order, and `loadISC` will do the right thing.  
The skin will always be loaded after all modules.

#### modules
  
_value format_: Comma separated list of modules to load. See the `[webroot]/isomorphic/system/modules` directory for a list of loadable modules. The leading "ISC\_" is optional, spaces after commas are also optional.  
_default value_: `"Core,Foundation,Containers,Grids,Forms,Drawing,DataBinding,Calendar"`

Specifying this attribute overrides the default set of modules loaded by `loadISC`. This is useful if you don't need to load all of the default modules on a particular page.

#### locale
  
_value format_: String - name of locale to load _default value_: null

Use this attribute to specify a locale to load. The default value of null omits locale loading, which effectively means the framework default "en" locale is used. Note that if you're using a mix of `loadISC` and `loadModules` tags, or multiple `loadModules` tags, the right place to specify this attribute is on the last `loadModules` tag.

#### isomorphicURI
  
_value format_: absolute or relative (from current URI) path to the `isomorphic` directory (by default, located in webRoot).  
_default value_: automatically derived

This value sets `window.isomorphicDir` and defines the base path to SmartClient modules from the currently executing JSP. By default, this value is automatically derived and you don't need to override it. Generally, an override is only required if you're pointing multiple web application deployments at one base URL for cache coherence reasons.

#### defer
  
_value format_: boolean - acceptable values: "true" or "false"  
_default value_: "false"

This attribute applies only if you're using the optional Network Performance component of SmartClient. By default, the modules specified by the `loadISC` tag are loaded synchronously - that is, the browser waits for each module to download before rendering any HTML on the page. Specifying `defer="true"` makes the module load asynchronous. In this mode, all the page content except the modules specified by `loadISC` is loaded and rendered first, and then the SmartClient modules are loaded. The asynchronous mode makes it possible to render some content and allow the user to interact with the site immediately, while SmartClient modules load in the background.

Note that typically SmartClient modules are delivered compressed with cache headers, so the download delay really only affects first time users of your site, those whose cached versions have expired, or if you've upgraded your SmartClient module to a newer version that the user has cached.

Using this directive is equivalent to calling \[classMethod:FileLoader.load\](#classmethod-fileloaderload).

#### cacheOnly
  
_value format_: boolean - acceptable values: "true" or "false"  
_default value_: "false"

This attribute applies only if you're using the optional Network Performance component of SmartClient. This works like `defer` (see above), except that the modules are only loaded into the browser cache, but not executed. This means that when the specified modules download, they'll be added to the browser cache, but will not be available to the execution context of the page. Actually executing the module code takes some processing time on the client, whereas simply caching it does not. The typical use case for this directive is on some intermediary page before the user gets to a SmartClient-enabled page. For example, you could include a cacheOnly `loadISC` tag on a login page that does not use SmartClient components, but protects a SmartClient-enabled application. While the user is typing in their credentials, the SmartClient modules will cache in the background, then once the user logs in and is sent to a SmartClient-enabled page, the modules are simply read from cache.

Using this directive is equivalent to calling \[classMethod:FileLoader.cache\](#classmethod-fileloadercache).

#### onload
  
_value format_: String - any javascript code  
_default value_: NONE

This attribute applies only if you're using the optional Network Performance component of SmartClient. This attribute is usable in conjunction with `defer` and `cacheOnly` attributes. This attribute allows you to specify a callback to execute when loading or caching of the specified modules has completed. You can use this to, for example, replace portions of the page with SmartClient components once SmartClient has loaded.

The value of this attribute is passed as the `onload` handler to the generated \[classMethod:FileLoader.cache\](#classmethod-fileloadercache) or \[classMethod:FileLoader.load\](#classmethod-fileloaderload) call as appropriate.

#### useSimpleNames
  
_value format_: boolean - acceptable values: "true" or "false"  
_default value_: "true"

Setting this attribute to false puts SmartClient in namespace mode. See \[object:isc\](#object-isc) for more info.

---
## Method: Canvas.dragMove

### Description
Executed every time the mouse moves while dragging this canvas.

### Returns

`[boolean](#type-boolean)` — false to cancel drag interaction.

### Groups

- widgetEvents

### See Also

- [Canvas.getOffsetX](#method-canvasgetoffsetx)
- [Canvas.getOffsetY](#method-canvasgetoffsety)

**Flags**: A

---
## Method: SectionStack.addItem

### Description
Add a canvas as an item to a section.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| section | [String](#type-string)|[Number](#type-number) | false | — | ID or index of the section to add item to |
| item | [Canvas](#type-canvas) | false | — | Item to insert into the section |
| index | [Number](#type-number) | false | — | Index into section to insert item |

---
## Group: javaModuleDependencies

### Description
Note that if you are using GWT, GWT itself also has an Apache 2.0 license, however tools and test environments that you may use during development have different license (such as Eclipse - Eclipse Public License). Also, specific GWT widgets, not required by Smart GWT, have licenses different from core GWT (such as JFreeChart's LGPL license). See [Google's summary of terms](http://code.google.com/webtoolkit/terms.html) for details.

If you are using \[server scripting\](#group-serverscript) with the Javascript language, dependencies are JVM-specific. Java versions earlier than 6 do not include JSR223 support at all, so server scripting is not an option with those JVMs. Versions of the Oracle and OpenJDK JVMs from 6 to 14 inclusive include a JS engine by default - Rhino in Java 6 and 7, and Nashorn from 8 to 14 - so Javascript server scripting works out of the box with no dependencies with those versions. Oracle and OpenJDK JVMs from version 15 onwards do not include JS support automatically. However, we ship the standalone OpenJDK implementation of Nashorn with SmartClient, so Javascript scripting still works out of the box as long as you leave that dependency in place. You can also leave that dependency in place with JDK versions from 8 to 14 - the OpenJDK implementation will mask the built-in Oracle implementation, but you should not notice any difference. See the Server Scripting documentation for more details of your options with this.

\[Maven\](#group-mavensupport) users should generally refer to the POMs bundled with the SDK, and installed for them by the official [Isomorphic plugin for Maven](http://github.smartclient.com/isc-maven-plugin/). For others, the following is a short description of the functionality contained in each SmartClient server JAR, and a link to the documentation listing its dependencies. Please refer to that documentation for more detail on the dependency graph, including version numbers, transitive dependencies, and licensing.

.jmd-module { width: 140px; text-align: right; vertical-align: top; padding-right: 10px; } .jmd-optional { text-decoration: underline; margin-top: 10px; margin-bottom: 8px; }

[isomorphic\_core\_rpc](./mavendoc/isomorphic-core-rpc.html)

This is the core SmartClient module. It provides the RPC, DMI, and DataSource support. Please note that both commons-collections-3.x and commons-collections4-4.x are required and safe to include side by side in the CLASSPATH (different third party libs rely on one or the other). The same is true of commons-lang and commons-lang3.

Optional Dependencies

*   _freemarker_ - if you're using the built-in support for REST via the \[RESTHandler servlet\](#group-servletdetails) servlet
*   _isomorphic\_js\_parser_ - if you're using the built-in support for REST via the \[RESTHandler servlet\](#group-servletdetails) servlet with JSON payloads
*   _xercesImpl_ - if you're using JDK < 1.5
*   _javax.mail_ - if you plan to use the Mail messaging feature
*   _javax.persistence_ - if you plan to use the metadata-from-annotations feature. Note that if you are using JPA, or a recent version of Hibernate, then you are probably already using this library.
*   _poi and commons-math_ - if you plan to export datasets in Microsoft Excel 97 (xls) or 2007 (xlsx) formats.
*   _poi-ooxml, poi-ooxml-schemas, and commons-compress_ - also needed if you plan to export data in Excel 2007 (xlsx) format
*   _isomorphic\_contentexport_ - if you plan to export to PDF format
*   _isomorphic\_jpa_ - if you plan to use BatchDS Generator (even if you are not using JPA, although the generated DataSources will not require JPA at runtime if you are not using JPA).
*   _log4j_ - if you plan to use log4j logging (used by default)
*   _slf4j-log4j12_ - if you plan to use slf4j with log4j (for example), or any other slf4j bridge library depending on which logging framework will be used. See \[group:serverLogging\](#group-serverlogging) for information on server-side logging and how to configure it.
*   _groovy_ - if you plan to use Groovy with the \[group:serverScript\](#group-serverscript) feature. Note, we also recommend that you use Groovy as the evaluation engine if you intend to use Java as an inline scripting language. See the "Server Scripting" documentation.
*   _commons-digester3 and commons-beanutils_ - if you plan to use Velocity Tools.
*   _nashorn-core and asm-util_ - if you are using server scripting with the Javascript language, and you want out of the box support with JDK versions from 15 onwards, as described in the paragraph above
*   _parquet-hadoop-bundle_ - columnar reader/writer and schema APIs for Parquet files; enables reading row groups, pages and converting values to Java types as used by the fetcher.
*   _hadoop-common_ - Hadoop core utilities and filesystem/config plumbing that Parquet’s Hadoop layer links against, even when reading over HTTP instead of HDFS.
*   _hadoop-mapreduce-client-core_ - MapReduce abstractions (InputSplit, job/config classes) that Parquet’s Hadoop integration references for compatibility; no MR jobs are run here, but the APIs must be present on the classpath.
*   _hadoop-shaded-protobuf\_3\_7_ - shaded Protobuf runtime required by Hadoop internals used transitively by the Parquet Hadoop layer; avoids clashing with other protobuf versions.
*   _hadoop-shaded-guava_ - shaded Guava utilities used by Hadoop/Parquet (collections, I/O helpers, preconditions) without exposing Guava to the app’s dependency graph.
*   _snappy-java_ - native/portable Snappy codec to decompress Parquet column chunks that are Snappy-encoded; needed for fast reads of compressed datasets.
*   _woodstox-core_ - high-performance StAX XML parser used by Hadoop for reading XML configs and other streaming XML tasks required by transitive code paths.
*   _stax2-api_ - StAX2 extension API implemented by Woodstox; required at runtime whenever Woodstox is on the classpath to satisfy XML stream parser interfaces.

[isomorphic\_contentexport](./mavendoc/isomorphic-contentexport.html)

Provides support for PDF Export.

Optional Dependencies

*   _batik-anim, batik-awt-util, batik-bridge, batik-css, batik-dom, batik-ext, batik-gvt, batik-parser, batik-script, batik-svg-dom, batik-util, batik-xml_ \-
    
    These are all required to use \[classMethod:RPCManager.exportImage\](#classmethod-rpcmanagerexportimage), or when using \[classMethod:RPCManager.exportContent\](#classmethod-rpcmanagerexportcontent) to export a DrawPane or FacetChart only in IE8 or earlier, or if a DrawPane has a DrawImage which loads a cross-domain image.
    
    #### NOTE:
     Between iText 2.0.x and iText 2.1.x there is a binary (but not source) incompatibility that causes a server-side `NoSuchMethodError` when exporting, e.g., charts in Internet Explorer. This is a [known issue](http://code.google.com/p/flying-saucer/issues/detail?id=126) with the Flying Saucer product that is fixed by using core-renderer-R8-isomorphic.jar and iText-2.1.7.jar in the lib-iTextAlternate/ directory instead of core-renderer.jar and iText-2.0.8.jar in the lib/ directory. To use iText 2.1.7 with the Server Framework, exclude lib/core-renderer.jar and lib/iText-2.0.x.jar from the application's classpath and instead add lib-iTextAlternate/core-renderer-R8-isomorphic.jar and lib-iTextAlternate/iText-2.1.7.jar.
    

[isomorphic\_tools](./mavendoc/isomorphic-tools.html)

Contains back-end logic for the "Admin Console" tool visible in the Developer Console, and also standalone from the SDK home page. Also contains the various data importers and exporters, and the server-side components of the BatchUploader.

[isomorphic\_cdi](./mavendoc/isomorphic-cdi.html)

Support for \[DMI\](#group-dmioverview) dispatches to Spring beans (via \[attr:ServerObject.lookupStyle\](#attr-serverobjectlookupstyle) : "cdi").

[isomorphic\_spring](./mavendoc/isomorphic-spring.html)

Support for \[DMI\](#group-dmioverview) dispatches to Spring beans (via \[attr:ServerObject.lookupStyle\](#attr-serverobjectlookupstyle) : "spring").

[isomorphic\_spring\_hibernate3](./mavendoc/isomorphic-spring.html)

Support for Spring + Hibernate 3, see the Compatibility section of \[group:springIntegration\](#group-springintegration) for more details.

[isomorphic\_realtime\_messaging](./mavendoc/isomorphic-messaging.html)

Server support required for the SmartClient Realtime Messaging Module. Install this if you're using this 'push' technology. For more information, see \[Messaging\](#group-messaging).

[isomorphic\_hibernate](./mavendoc/isomorphic-hibernate.html)

Contains support for Hibernate DataSources as described here: \[group:hibernateIntegration\](#group-hibernateintegration).

[isomorphic\_jpa](./mavendoc/isomorphic-jpa.html)

Contains support for JPA DataSources as described \[here\](#group-jpaintegration)

[isomorphic\_sql](./mavendoc/isomorphic-sql.html)

The SmartClient SQLDataSource.

[isomorphic\_autotest](./mavendoc/isomorphic-autotest.html)

Support for \[automated testing and Continuous Integration\](#group-automatedtesting)

Optional Dependencies

*   _jna_ - if testing with IE on Windows environments
*   _servlet-api_ - needed only if you intend to run TestRunner from a standalone process (ie, from a normal Java program, not a webapp).
    
    However, it should not be deployed to a servlet container such as Tomcat or Jetty. The best case is that the file will be unused and a source of confusion for anybody looking at the webapp's library usage; the worst case is that it will conflict with the container's own implementation of the Servlet API.
    

[isomorphic\_js\_parser](./mavendoc/isomorphic-js-parser.html)

A parser capable of reading a JSON byte stream and creating an in-memory Java object structure to match. Used by any mechanism that relies on JSON-style configuration. Examples include FileAssembly definitions in JSON format, any use of the rulesFile with a URIRegexFilter (Java Servlet) or subclass.

[isomorphic\_compression](./mavendoc/isomorphic-compression.html)

This is a part of the Network Performance Module. The isomorphic\_compression module is required for dynamic and static compression of various assets delivered to the browser. For more information, see: \[group:compression\](#group-compression).

[isomorphic\_assembly](./mavendoc/isomorphic-assembly.html)

This is part of the Network Performance Module. The isomorphic\_assembly module is required for file assembly and stripping. For more information, see: \[group:fileAssembly\](#group-fileassembly).

[isomorphic\_scheduler](./mavendoc/isomorphic-scheduler.html)

Server-side libraries providing \[DataSource adapters\](#group-quartzadapters) for the [Quartz](http://www.quartz-scheduler.org) API.

[isomorphic\_m2pluginextras](./mavendoc/isomorphic-m2pluginextras.html)

A small collection of tools / utilities for use by Maven builds, Ant Scripts, and command line invocation.

[isomorphic\_spring\_hibernate4](./mavendoc/isomorphic-spring.html)

Support for Spring + Hibernate 4, see the Compatibility section of \[group:springIntegration\](#group-springintegration) for more details.

---
## Attr: Window.hiliteHeaderSrc

### Description
If \[attr:Window.showHeaderBackground\](#attr-windowshowheaderbackground) is true, this governs the URL of the image to use in the header's highlighted state when the window is \[flashed\](#method-windowflash)

### Groups

- appearance
- header

**Flags**: IRWA

---
## Attr: Button.definingProperty

### Description
This attribute denotes the name of a property to use as a \[getDefiningPropertyName()\](#method-canvasgetdefiningpropertyname) for this property when generating and resolving \[AutoTest locators with search segments\](#type-autotestlocator).

**Flags**: IRWA

---
## ClassAttr: Operators.lessThanFieldTitle

### Description
Title for the "lessThanField" operator

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: Shuttle.selectedValues

### Description
Initial selected values for the shuttle.

If specified, the shuttle will be initialized with records with matching \[attr:Shuttle.valueField\](#attr-shuttlevaluefield) being selected.

See also \[attr:Shuttle.selectedRecords\](#attr-shuttleselectedrecords) for initializing selection with specific records. If both properties are specified, `selectedValues` will have no effect

To update the selection by value at runtime use \[method:Shuttle.setSelectedByValue\](#method-shuttlesetselectedbyvalue)

**Flags**: IR

---
## Attr: MenuButton.title

### Description
Default title for the button.

### Groups

- i18nMessages

**Flags**: IRW

---
## Attr: RichTextEditor.toolbarBackgroundColor

### Description
The background color for the toolbar.

**Flags**: IR

---
## Type: TableMode

### Description
Controls the display mode of TableView record display

### Values

| Value | Description |
|-------|-------------|
| TableView.PLAIN | The default mode which displays a list of rows |
| TableView.GROUPED | Grouped table is a set of rows embedded in a rounded rectangle |

---
## Method: FormItem.hideIcon

### Description
This method will hide some icon in this item's \[attr:FormItem.icons\](#attr-formitemicons) array, if it is currently visible. Note that once this method has been called, any previously specified \[method:FormItemIcon.showIf\](#method-formitemiconshowif) will be discarded.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| icon | [Identifier](#type-identifier) | false | — | \[name\](#attr-formitemiconname) of the icon to be hidden. |

---
## Attr: FiscalCalendar.defaultMonth

### Description
The default zero-based month-number to use for calculating fiscal dates when no \[fiscal years\](#attr-fiscalcalendarfiscalyears) are provided. This value together with \[attr:FiscalCalendar.defaultDate\](#attr-fiscalcalendardefaultdate) will be used as the start date for the fiscal years where no explicitly specified fiscalYear configuration is present.  
See also \[attr:FiscalCalendar.defaultYearMode\](#attr-fiscalcalendardefaultyearmode).

**Flags**: IRW

---
## Attr: ListGrid.exportRawValues

### Description
Dictates whether the data in this grid should be exported raw by \[exportClientData()\](#method-listgridexportclientdata). If set to true, data will not be processed by field-formatters during exports. Decreases the time taken for large exports. This property can also be set at the \[field level\](#attr-listgridfieldexportrawvalues).

**Flags**: IR

---
## Type: DetailViewerViewState

### Description
An object containing the stored grouping information for a detailViewer. Note that this object is not intended to be interrogated directly, but may be stored (for example) as a blob on the server for state persistence across sessions.

### Groups

- viewState

---
## Type: HTMLString

### Description
A String of HTML, such as "text".

In many contexts, such as \[attr:Button.title\](#attr-buttontitle) and \[method:ListGrid.formatCellValue\](#method-listgridformatcellvalue), an HTML String can be specified, allowing you to use normal HTML tags and CSS to do formatting or styling.

However, bear in mind that if you attempt any kind of layout or advanced styling in such an HTML string, different browsers may render the HTML differently - use SmartClient \[layout\](#class-layout) and \[styling\](#attr-canvasstylename) features wherever possible to avoid this. See also \[type:CSSStyleName\](#type-cssstylename).

---
## StaticMethod: isc.showPrompt

### Description
Method available on the isc object to show a modal prompt to the user. This method will display the message using the Dialog.Prompt singleton object.  
Note: if this prompt is to be shown to the user during some slow JavaScript logic, we advise calling this method, then using \[method:Class.delayCall\](#method-classdelaycall) or \[classMethod:Timer.setTimeout\](#classmethod-timersettimeout) to kick off the slow logic in a separate thread. This ensures that the prompt is showing before the lengthy execution begins.

Use `"${loadingImage}"` to include \[a loading image\](#classattr-canvasloadingimagesrc).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| message | [HTMLString](#type-htmlstring) | false | — | message to display |
| properties | [Dialog Properties](#type-dialog-properties) | true | — | additional properties for the Dialog, applied before the Dialog is shown |

### Groups

- Prompting

### See Also

- [Dialog.Prompt](#classattr-dialogprompt)

---
## Class: BrowserPlugin

### Description
Container for a Browser Plugin.

---
## Attr: DrawItem.zIndex

### Description
Relative stacking order of this draw item with respect to other items in the same \[class:DrawPane\](#class-drawpane) or \[class:DrawGroup\](#class-drawgroup).

null means that the zIndex has not been resolved. Upon adding this draw item to a `DrawPane` or `DrawGroup`, this item's zIndex will be resolved to the next higher auto-assigned zIndex. Note that this may still be less than another item's zIndex if \[bringToFront()\](#method-drawitembringtofront) was called on that item.

If two items within the same `DrawPane` or `DrawGroup` have the same zIndex, then they are stacked in the order in which they were added to the `DrawPane` or `DrawGroup`.

When the `DrawPane`'s \[drawingType\](#attr-drawpanedrawingtype) is "bitmap", zIndex, \[method:DrawItem.bringToFront\](#method-drawitembringtofront), and \[method:DrawItem.sendToBack\](#method-drawitemsendtoback) are not supported for \[class:DrawLabel\](#class-drawlabel)s on iOS due to platform limitations.

### Groups

- zIndex

**Flags**: IR

---
## Method: Tree.getLeaves

### Description
Return all the first-level leaves of a node.  
  
For load on demand trees (those that only have a partial representation client-side), this method will return only nodes that have already been loaded from the server.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| node | [TreeNode](#type-treenode) | false | — | node in question |

### Returns

`[Array of TreeNode](#type-array-of-treenode)` — List of immediate children that are leaves.

---
## Attr: Lane.styleName

### Description
The base style-name for normal cells in this Lane.

### Groups

- appearance

**Flags**: IRW

---
## Group: networkPerformance

### Description
This section describes various methods for optimizing delivery of your SmartClient-based application to the browser. The various techniques discussed here should enable you to drastically reduce the time to load your SmartClient based application and to cut down on bandwidth costs and server-side CPU usage.

_Note that in addition to these network performance considerations, you should also be aware of the recommended application design practices discussed in \[group:smartArchitecture\](#group-smartarchitecture)._

There are three main ways of improving the performance of your application:

#### Compression

You'll want to deliver as much of your application assets compressed as possible. For a start, the SmartClient modules come pre-compressed. The \[group:compression\](#group-compression) section describes how to make sure that SmartClient modules and your application logic are delivered compressed and how to enable dynamic compression of your dynamic content.

Compression drastically reduces transfer times to the browser. Compression ratios for css and javascript files can be as high as 8:1.

#### Caching

The \[group:caching\](#group-caching) section deals with delivering as much content as possible with caching headers. Setting these headers allows the end-user's browser and any intermediary proxies to keep a local copy of the file across browser reloads, ensuring the subsequent visits require almost no fetches from the server. Eliminating these fetches is also important for the reasons explained under File Assembly below.

#### File Assembly

Modern browsers limit the number of HTTP connections they use to fetch the assets required to render your pages - typically to just 2 connections. As a result, connection latency can play a much higher role than available bandwidth and the two connection limit effectively drastically limits the user's usable bandwidth. For this reason, it's important to minimize the number of HTTP requests made to the server. The File Assembly services make it easy to deliver multiple css and javascript file via one HTTP response. Assembling files together also helps to increase the compression ratio because the compression engine has more redundant data to work with.

#### FileLoader

The FileLoader is a standalone client-side module that allows you to performing caching or loading of various resources in the background on any page. The typical usage pattern is to use this module to pre-cache SmartClient modules, skin images, and application logic while the user is, for example filling in a login form. See the \[object:FileLoader\](#object-fileloader) documentation on usage.

#### SSL Considerations

Some quirks to be aware of when optimizing for pages serviced via HTTPS:

*   If your top-level https page loads an image via http, IE will pop a warning to the user asking if it's ok to serve the "unsecure" content. Firefox does not pop an alert, bug shows a different lock icon to indicate that not all content is served from a secure server.
*   Firefox will not write images fetched via SSL to disk, even if expires headers are set. But it will cache them in memory for the duration of the browser session. This makes the use of the \[object:FileLoader\](#object-fileloader) even more important for SSL applications. IE will cache SSL content across browser restarts.
*   If your only concern is with actual security and not with perception, it makes a lot of sense to serve the top-level page via plain HTTP and then use the SmartClient RPC mechanism to fetch sensitive data with no-cache headers via HTTPS. Unfortunately this almost never practical because most users look for the secure lock icon on the top-level page and may become worried that the application is not secure if they don't see it.

#### Other Tips

1\. Modern applications often use a number of cookies to keep track of session state, application state, etc. If you don't limit the paths these cookies are served for, you can easily end up with these cookies being sent to the server with every HTTP request as part of the HTTP headers. This can severely limit bandwidth where a large number of requests are made - typically for skin images. Also note that most technologies used by end-users to connect to the internet such as DSL and Cable are half-duplex, meaning that downstream must pause for upstream traffic to be sent and these connections also are asymmetric, allowing much faster download speeds than upload speeds. As a result, the limited upstream capability of most connections ends up limiting the download bandwidth by delaying the download of other assets required to render the page.

2\. Whenever possible, don't set the "Cache-Control" header to "private" - this tells intermediary proxies to not allow caching of the specified content, eliminating that cache as a useful intermediary for other users behind it.

3\. For a good overview of performance considerations, see this post: [http://www.die.net/musings/page\_load\_time/](http://www.die.net/musings/page_load_time/)

---
## Method: EditTree.getPaletteNodesFromXML

### Description
Obtain \[PaletteNodes\](#object-palettenode) from an XML representation, but do not add them to the EditContext.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| xmlString | [String](#type-string) | false | — | XML string |
| callback | [PaletteNodeCallback](#type-palettenodecallback) | false | — | Callback used to return the PaletteNodes |

### See Also

- [Callbacks.PaletteNodeCallback](#method-callbackspalettenodecallback)
- [EditTree.serializeAllEditNodes](#method-edittreeserializealleditnodes)
- [EditTree.serializeEditNodes](#method-edittreeserializeeditnodes)

---
## Method: GradientEditor.getGradient

### Description
Returns the current state of the widget as a CSS gradient

### Returns

`[String](#type-string)` — the gradient definition

---
## Method: ListGrid.setSortState

### Description
Reset this grid's sort state (sort field and direction or list of \[object:SortSpecifier\](#object-sortspecifier)s) to match the \[type:ListGridSortState\](#type-listgridsortstate) object passed in.  
Used to restore previous state retrieved from the grid by a call to \[method:ListGrid.getSortState\](#method-listgridgetsortstate).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| sortState | [ListGridSortState](#type-listgridsortstate) | false | — | Object describing the desired sort state for the grid. |

### Groups

- viewState

### See Also

- [ListGrid.getSortState](#method-listgridgetsortstate)

---
## Method: Label.setStyleName

### Description
Dynamically change the CSS class for this widget. For a Label, this is equivalent to \[setBaseStyle()\](#method-statefulcanvassetbasestyle).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| newStyle | [CSSStyleName](#type-cssstylename) | false | — | new CSS style name |

---
## Attr: ColorPicker.basicColorLabel

### Description
The label shown above the basic color blocks.

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: TreeGrid.showSelectedIcons

### Description
If true, show a different icon for selected nodes than unselected nodes. This is achieved by appending the \[attr:TreeGrid.selectedIconSuffix\](#attr-treegridselectediconsuffix) onto the \[attr:TreeGrid.folderIcon\](#attr-treegridfoldericon) URL or \[attr:TreeGrid.nodeIcon\](#attr-treegridnodeicon) for selected records.

If appropriate, this suffix will be combined with the \[attr:TreeGrid.openIconSuffix\](#attr-treegridopeniconsuffix) or \[attr:TreeGrid.closedIconSuffix\](#attr-treegridclosediconsuffix) (see \[attr:TreeGrid.showOpenIcons\](#attr-treegridshowopenicons). So a treeGrid with its `folderIcon` property set to `"[SKIN]/folder.gif"`, with both `showSelectedIcons` and `showOpenIcons` set to true would show an icon with the URL `"[SKIN]/folder_open_selected.gif"` for a folder that was both selected and opened.

### Groups

- treeIcons

**Flags**: IRW

---
## Type: DragDataAction

### Description
What do we do with data that's been dropped into another list?

### Values

| Value | Description |
|-------|-------------|
| "none" | Don't do anything, resulting in the same data being in both lists. |
| Canvas.COPY | Copy the data leaving the original in our list. |
| Canvas.MOVE | Remove the data from this list so it can be moved into the other list. |

### Groups

- dragdrop

---
## Method: ListGrid.setDataSource

### Description
Bind to a new DataSource.

Like passing the "dataSource" property on creation, binding to a DataSource means that the component will use the DataSource to provide default data for its fields.

When binding to a new DataSource, if the component has any existing "fields" or has a dataset, these will be discarded by default, since it is assumed the new DataSource may represent a completely unrelated set of objects. If the old "fields" are still relevant, pass them to setDataSource().

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| dataSource | [GlobalId](#type-globalid)|[DataSource](#type-datasource) | false | — | DataSource to bind to |
| fields | [Array of DataSourceField](#type-array-of-datasourcefield) | true | — | optional array of fields to use |

---
## Attr: OperationBinding.preventHTTPCaching

### Description
Configures \[attr:DataSource.preventHTTPCaching\](#attr-datasourcepreventhttpcaching) on a per-operationType basis.

**Flags**: IR

---
## Class: FieldPickerWindow

### Description
A dialog for picking fields to display from among the available fields.

This is typically useful in scenarios where there are many more fields than can reasonably fit on screen. The application can start off displaying a few of the fields by default (such as the most commonly-needed fields), and show a FieldPickerWindow to allow the user to customize which fields to display as well as the order in which to display them.

---
## Attr: GridRenderer.showHover

### Description
If true, and canHover is also true, when the user hovers over a cell, hover text will pop up next to the mouse. The contents of the hover is determined by \[method:GridRenderer.cellHoverHTML\](#method-gridrenderercellhoverhtml).

### Groups

- events

### See Also

- [GridRenderer.canHover](#attr-gridrenderercanhover)
- [GridRenderer.cellHoverHTML](#method-gridrenderercellhoverhtml)

**Flags**: RW

---
## Attr: ListGridField.summaryValue

### Description
The value to display for a ListGridField when it appears in the \[summaryRow\](#attr-listgridsummaryrow). The default for normal fields is null and for special fields, like the \[checkboxField\](#attr-listgridcheckboxfield), the default is to show a blank value (a non-breaking space).

**Flags**: IRW

---
## Attr: ListGridField.editorValueIcons

### Description
When some cell in this field is being edited, setting this property will specify the value icons to display in the cell's editor. If unset, the editor's valueIcons will be determined in the same way as it would be for a static cell.

### Groups

- imageColumns

**Flags**: IRW

---
## Object: MultiWindowSettings

### Description
Allows specifying settings to apply to the \[class:MultiWindow\](#class-multiwindow) of a child window.

---
## Method: ListGrid.getUserCriteriaState

### Description
Returns a snapshot of the current user-provided criteria for this ListGrid.

This object can be passed to \[method:ListGrid.setUserCriteriaState\](#method-listgridsetusercriteriastate) to reset this grid's user-criteria to the current state.

### Returns

`[ListGridUserCriteriaState](#type-listgridusercriteriastate)` — current criteria state for the grid.

### Groups

- viewState

### See Also

- [ListGridUserCriteriaState](#type-listgridusercriteriastate)
- [ListGrid.setUserCriteriaState](#method-listgridsetusercriteriastate)

---
## Method: CancellationController.cancel

### Description
Requests cancellation of all asynchronous operations that are polling \[attr:CancellationController.canceled\](#attr-cancellationcontrollercanceled) or \[observing\](#method-classobserve) this method. Also cancels any \[sub-`CancellationController`\](#method-cancellationcontrollercreatesubcontroller)s of this `CancellationController` that are not already canceled.

\[this.cancellationReason\](#attr-cancellationcontrollercancellationreason) is set to the provided `reason` only on the first call to cancel().

For observers of this method, the recommended practice is to capture the `returnVal` and only perform the cancellation steps if the `returnVal` was `true`. This is because it could happen that cancel() is called a second time before the observers finish.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| reason | [HTMLString](#type-htmlstring) | true | — | A reason for cancellation. |

### Returns

`[Boolean](#type-boolean)` — `true` if this was the first call to cancel(); `false` otherwise.

---
## Attr: FormItem.linearColSpan

### Description
Specifies a column span for an item in \[linearMode\](#attr-dynamicformlinearmode), overriding the default value of "\*" in that mode.

### Groups

- formLayout

### See Also

- [FormItem.colSpan](#attr-formitemcolspan)

**Flags**: IRW

---
## Attr: Calendar.laneEventPadding

### Description
The pixel space to leave between events and the edges of the \[lane\](#attr-calendarlanes) or \[sublane\](#attr-lanesublanes) they appear in. Only applicable to \[timelines\](#attr-calendartimelineview) and to \[dayViews\](#attr-calendardayview) showing \[day lanes\](#attr-calendarshowdaylanes).

**Flags**: IRW

---
## Attr: CanvasItem.prompt

### Description
This text is shown as a tooltip prompt when the cursor hovers over this item.

When the item is \[read-only\](#method-formitemsetcanedit) a different hover can be shown with \[attr:FormItem.readOnlyHover\](#attr-formitemreadonlyhover). Or, when the item is \[disabled\](#attr-formitemdisabled) or read-only with \[readOnlyDisplay:disabled\](#attr-formitemreadonlydisplay) a different hover can be shown with \[attr:FormItem.disabledHover\](#attr-formitemdisabledhover).

Note that when the form is \[disabled\](#attr-canvasdisabled), or when this item \[suppresses hovers\](#attr-formitemcanhover), this prompt will not be shown.

### Groups

- basics

**Flags**: IRW

---
## Type: SCClassName

### Description
Name of a SmartClient Class, that is, a Class that has been created via \[staticMethod:isc.defineClass\](#staticmethod-iscdefineclass), including Classes built into SmartClient, such as "ListGrid".

---
## Class: FormItemEditProxy

### Description
\[class:EditProxy\](#class-editproxy) that handles \[class:FormItem\](#class-formitem)s when editMode is enabled.

### Groups

- devTools

---
## ClassMethod: Browser.setIsTablet

### Description
Setter for \[classAttr:Browser.isTablet\](#classattr-browseristablet) to allow this global variable to be changed at runtime. This advanced method is provided to override SmartClient's detection of devices, since the framework can only detect devices that existed at the time the platform was released. Any changes to \[classAttr:Browser.isDesktop\](#classattr-browserisdesktop), \[classAttr:Browser.isHandset\](#classattr-browserishandset), or \[classAttr:Browser.isTablet\](#classattr-browseristablet) must be made before any component is created; **it is an application error** to attempt to change `isDesktop`, `isHandset`, or `isTablet` after components have been created.

Note that setting `Browser.isTablet` might affect the values of \[classAttr:Browser.isDesktop\](#classattr-browserisdesktop) and \[classAttr:Browser.isHandset\](#classattr-browserishandset).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| isTablet | [boolean](#type-boolean) | false | — | new setting for `Browser.isTablet`. |

**Flags**: A

---
## Attr: OperationBinding.transformResponseScript

### Description
Scriptlet to be executed after the DataSource operation which is configured by this operationBinding. See \[attr:DataSource.transformResponseScript\](#attr-datasourcetransformresponsescript) for further details.

Note, unlike many OperationBinding-level properties, a `transformResponseScript` at the OperationBinding level does not hide a `transformResponseScript` defined at the DataSource level. Instead, if you define `transformResponseScript` against both the DataSource and the OperationBinding, 
#### both
 are run - first the DataSource-level script, then the OperationBinding-level one.

### Groups

- serverScript

**Flags**: IR

---
## Method: FacetChartEditProxy.setInlineEditText

### Description
Save the new value into the component's state. Called by the \[attr:EditProxy.inlineEditForm\](#attr-editproxyinlineeditform) to commit the change.

Updates the component's `facets` and `data`.

Lines starting with "--" or "==" are considered titles. A single title is used as the chart title. Titles are matched to the next series of data. If titles are provided for each series, a legend will be shown.

Series data can be entered as a list of values separated by commas (see \[dataSeparatorChar\](#attr-facetcharteditproxydataseparatorchar)) or as a valueMap-style list of `label:value` pairs. The first data series defines the number of chart values and the titles, if provided.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| newValue | [String](#type-string) | false | — | the new component data |

---
## Attr: FacetChart.drawTitleBackground

### Description
should a background color be set behind the Title. Use \[attr:FacetChart.titleBackgroundProperties\](#attr-facetcharttitlebackgroundproperties) to set these values if this is true.

### Groups

- chartTitle

**Flags**: IRW

---
## Attr: WebService.serviceNamespace

### Description
Namespace of this WebService, derived from the `targetNamespace` attribute of the `<wsdl:definitions>` element.

### Groups

- webService

**Flags**: R

---
## Method: ListGridField.getRecordSummary

### Description
Only applies to \["summary"-type\](#type-listgridfieldtype) fields. If specified, this method will be called to generate the record summary value to be displayed for each row in this field. When this method is called, current values for other record summary fields have not necessarily been stored on the record, but are accessible via \[method:ListGrid.getRecordSummary\](#method-listgridgetrecordsummary).

The grid is passed to be able to evaluate dependency record summary values via ListGrid.getRecordSummary(). Other than that, the properties and state of the grid should not be used in the implementation of this method. To do so would be a source of undefined behavior.

Note that if implemented, this is called instead of making use of the \[attr:ListGridField.recordSummaryFunction\](#attr-listgridfieldrecordsummaryfunction).

If \[attr:ListGrid.showGridSummary\](#attr-listgridshowgridsummary) or \[attr:ListGrid.showGroupSummary\](#attr-listgridshowgroupsummary) is true, this field's value in the summary row\[s\] will still be calculated by calling this method. In this case, the record object passed in will contain summary values for each field. If custom handling is required for this case, it may be detected by checking the record object's \[attr:ListGridRecord.isGroupSummary\](#attr-listgridrecordisgroupsummary) and \[attr:ListGridRecord.isGridSummary\](#attr-listgridrecordisgridsummary) attributes.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| record | [ListGridRecord](#type-listgridrecord) | false | — | record for which a summary is being generated |
| field | [ListGridField](#type-listgridfield) | false | — | this field |
| grid | [ListGrid](#type-listgrid) | false | — | the grid |

### Returns

`[Any](#type-any)` — summary value to display

**Flags**: A

---
## Group: i18n

### Description
#### Internationalizing SmartClient Applications

Internationalizing a SmartClient application involves creating locale-specific versions of all strings, images, and possibly colors. In some cases, component layout may be affected as well (for example date field order differs between some locales).

#### Character Encodings

In order to deliver content in different languages to the browser and have it be displayed correctly, it is important that the browser and server agree on the character encoding being used to send the page.

Generally speaking, you can use whatever character encoding you prefer, so long as you're consistent about serving your files to the browser with exactly the same encoding as was used to save the file to disk. Keep in mind though that the character encoding you choose must be supported by all browsers you intend to support. Isomorphic recommends that, where possible, you use the UTF-8 encoding. Regardless of which character encoding you choose, keep in mind that for the browser to correctly display non-ASCII characters, you 
#### must
 explicitly set the character encoding of your page to match the encoding you used to save the file. Browsers have built-in heuristics to guess the character encoding, but they can't be relied upon to work 100% of the time.

There are two ways to explicitly tell the browser what character encoding is being used for a given page. One is to set the "Content-Type" HTTP header, for example:

 Content-Type: text/html; charset=UTF-8
 

If you're using JSP on the back-end, you can set this header as follows:

 <%@ page contentType="text/html; charset=UTF-8"%>
 

Or using Java Servlet APIs in a Servlet as follows:

 response.setContentType("text/html; charset=UTF-8");
 

Note that the latter needs to be done before any content is written to the response output stream.

The other approach to setting the content encoding is to use an HTML META tag to embed it in the page itself (note that this applies to HTML documents only). The META tag must go inside the <HEAD> HTML element - e.g. as follows:

 <HEAD>
 <META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=UTF-8">
 </HEAD>
 

In addition, for a .html or other static (non-.jsp) file, you must also ensure that the file itself is saved in UTF-8 encoding. Advanced text editors (including the Eclipse IDE) can show you the encoding of a text file and allow you to change it. In Eclipse this is in the Preferences area (search for "Encoding") and UTF-8 is 
#### not the default
 for .html files, and should be changed.

Isomorphic recommends that you follow 
#### all
 of the above approaches for maximum compatibility. For example, if you omit the META tag approach, pages saved by the user using the browser save function may not render correctly when subsequently read from disk because HTTP headers are not available in that context. Conversely, not providing the HTTP header or not saving the file in UTF-8 can result in application servers delivering the file in the encoding in which it is saved, or in their own default and incorrect content encoding.

If you're using a given character encoding pervasively in your pages, you can also configure your web server or application server to use that character encoding as the default for all pages of a given mime type or some other criteria (depending on the capability of your server) - for example on a per-directory basis.

For more information on character encodings, character sets, and working with HTML, please see W3C's tutorial here: [http://www.w3.org/International/tutorials/tutorial-char-enc/](http://www.w3.org/International/tutorials/tutorial-char-enc/)

#### NOTE: Default Encoding

As mentioned above, Isomorphic recommends the use of UTF-8 encoding. However, it is not possible to configure some servlet engines to do this by default. Both Tomcat and Jetty default to the ISO-8859-1 character set (commonly known as Latin-1), even if the Java VM specifies a different encoding (the Tomcat documentation claims that this behavior is a requirement of the Servlet specification).

To work around this, we change charset encoding to UTF-8 on every request/response that goes through two core Isomorphic servlets: `IDACall` and `DataSourceLoader`. If you need to change this, you can do so by adding `init-param` settings to your `web.xml` file. Please see the Javadocs for those two servlets for examples of how to do this.

#### Framework Message Localization

SmartClient components include standard prompts and error messages in various cases, and all such messages support localization.

Language packs are included in the directory smartclientSDK/isomorphic/locales. To load a language pack, simply include the desired locale via a standard HTML <script src=> tag, for example:

    <SCRIPT SRC="isomorphic/locales/frameworkMessages\_pt.properties"></SCRIPT>
 

.. to load the Portuguese locale.

Alternatively can use the `locale` attribute on the `loadISC` or `loadModules` jsp tags:

   <isomorphic:loadISC skin="Enterprise" locale="pt"/> 
 

Or, if you have the \[Network Performance\](#group-networkperformance), you can use the \[classMethod:FileLoader.loadLocale\](#classmethod-fileloaderloadlocale)/\[classMethod:FileLoader.cacheLocale\](#classmethod-fileloadercachelocale) APIs:

   isc.FileLoader.loadLocale("pt");
 

To see various locales, have a look at the ${isc.DocUtils.linkForExampleId('changeLocales', 'Localization example')}.

If you find that the language pack you are using has any incorrect or missing translations, or you want to add a new language pack, please visit [this forums thread](http://forums.smartclient.com/showthread.php?t=9987) for instructions on how to contribute translations so that they will be added to future SmartClient builds.

You can alternatively maintain your own private additions or overrides to the default language packs. A complete list of standard messages is presented \[here\](#group-i18nmessages).  
To customize these messages, use \[method:Class.addProperties\](#method-classaddproperties) or \[classMethod:Class.addClassProperties\](#classmethod-classaddclassproperties) to override default values at the instance or class level respectively. For example, the class property \[classAttr:RPCManager.timeoutErrorMessage\](#classattr-rpcmanagertimeouterrormessage) is displayed to the user in a warning dialog when a SmartClient operation fails to complete. This can be modified using the \[classMethod:Class.addClassProperties\](#classmethod-classaddclassproperties) method, as follows:

 isc.RPCManager.addClassProperties({timeoutErrorMessage:"Custom Timeout Message"});
 

#### Application Message Localization

Text such as button titles typically appears in the middle of JavaScript code:

     isc.Button.create({ title: "Click me!"});
 

If you are on the Java platform and your JavaScript code appears in a .jsp, you can use the JSTL Core package (Java Server Pages Standard Tag Library) to replace that static "Click me!" text with a localized reference. This can be done as follows:

     <%@ taglib prefix="fmt" uri="/WEB-INF/fmt.tld" %>
     <SCRIPT>
     isc.Button.create({ title: <fmt:message key="buttonTitle"> });
     </SCRIPT>
 

Assuming you've set the current Locale and provided a resource bundle with the relevant translated text, the above would create a button with a title that comes from the locale-specific bundle you provided. For more information, see Sun's i18n tutorial: [http://java.sun.com/docs/books/tutorial/i18n/](http://java.sun.com/docs/books/tutorial/i18n/).

Note that this approach does not imply that your JavaScript must appear in the midst of an HTML page. A .jsp file can be used to return a pure JavaScript response via just removing the <SCRIPT> tags in the example above, and targetting the .jsp with a <SCRIPT SRC=> tag from another .jsp or .html file.

A second common technique is to load internationalized messages as a JavaScript Object mapping from a message name to the internationalized message. For example, if your messages are stored in Java .properties format, you could load your .properties file as a standard Java [Properties object](http://docs.oracle.com/javase/6/docs/api/java/util/Properties.html), and use the server-side com.isomorphic.js.JSTranslater.toJSVariable() API to output the properties as a JavaScript variable.

If the variable name chosen was 'i18nMessages', code to make use of the .properties data would look like:

     isc.Button.create({ title: i18nMessages\["buttonTitle"\] });
 

Approaches for non-Java platforms are similar, and generally any approach that works for HTML or JavaScript files works with SmartClient. See the end of this section for pointers to additional resources.

#### Localizing Server-side Error Messages

If you are providing error messages from server-side code, use standard Java techniques to determine the locale (`servletRequest.getLocale()`) and load ResourceBundles. Note that if you are using \[DMI validation\](#attr-validatorserverobject), the HttpServletRequest is available via the standard \[DMI\](#group-dmioverview) approach: just declare it as an additional parameter, and it is provided.

#### Support for Right-to-Left (RTL) languages

SmartClient includes support for RTL languages. To enable, simply set `dir="rtl"` on the HTML element:

    <HTML dir="rtl">
 

ListGrid columns, horizontal layouts, scrolling directions, etc will reverse order automatically.

Because RTL in some cases requires additional media files, RTL is only supported for the Enterprise, EnterpriseBlue and Graphite skins.

#### DataSource and Component XML localization

Please see the separate article on \[DataSource and Component XML Localization\](#group-datasourcelocalization)

#### Localized Number and Currency Formatting

Please see the separate article on \[Localized Number Formatting\](#group-localizednumberformatting)

#### Image, CSS localization

Most SmartClient components use a mixture of text, CSS and images to render. If you wish to provide locale-specific images or use locale-specific CSS, you can create localized copies of a SmartClient skin named after the locale and modify images as you see fit. A skin is specified at load time using either the `skin` attribute of the `<isomorphic:loadISC>` tag or by loading the skin directly using a script tag like so: <SCRIPT SRC=/isomorphic/skins/\[skin\]/load\_skin.js>. If you're using the `loadISC` tag, you can specify a locale-specific skin like so:

 <isomorphic:loadISC skin="\[localeName\]"/>
 

Or you can use a script tag like so:

 <SCRIPT SRC=/isomorphic/skins/\[localeName\]/load\_skin.js></SCRIPT>
 

Where the `[localeName]` is the name of the current locale - you'll have this in the current page context as you'll need it to use the JSTL <fmt:setLocale> tag.

Resources:

#### Java

*   Sun's i18n tutorial: [http://java.sun.com/docs/books/tutorial/i18n/](http://java.sun.com/docs/books/tutorial/i18n/)
*   JSTL documentation home page: [https://www.oracle.com/java/technologies/jstl-documentation.html](https://www.oracle.com/java/technologies/jstl-documentation.html)
*   Apache taglibs: [https://tomcat.apache.org/taglibs/index.html](https://tomcat.apache.org/taglibs/index.html)

#### .NET

*   MSDN Developer Resource: "Developing World-Ready Applications": [https://docs.microsoft.com/en-us/dotnet/core/extensions/best-practices-for-developing-world-ready-apps](https://docs.microsoft.com/en-us/dotnet/core/extensions/best-practices-for-developing-world-ready-apps)

#### PHP

*   PHP Gettext manual: [http://us2.php.net/gettext](http://us2.php.net/gettext)

---
## Attr: ListGrid.drawAllMaxCells

### Description
If drawing all rows would cause less than `drawAllMaxCells` cells to be rendered, the full dataset will instead be drawn even if \[showAllRecords\](#attr-listgridshowallrecords) is false and the viewport size and \[attr:ListGrid.drawAheadRatio\](#attr-listgriddrawaheadratio) setting would normally have caused incremental rendering to be used.

The `drawAllMaxCells` setting prevents incremental rendering from being used in situations where it's really unnecessary, such as a 40 row, 5 column dataset (only 200 cells) which happens to be in a grid with a viewport showing only 20 or so rows. Incremental rendering causes a brief "flash" during scrolling as the visible portion of the dataset is redrawn, and a better scrolling experience can be obtained in this situation by drawing the entire dataset up front, which in this example would have negligible effect on initial draw time.

`drawAllMaxCells:0` disables this features. You may want to disable this feature if performance is an issue and:

*   you are very frequently redraw a grid
*   you do a lot of computation when rendering each cell (eg formulas)
*   you are showing many grids on one screen and the user won't scroll most of them

### Groups

- performance

**Flags**: IRWA

---
## Attr: MetricSettings.showAxisLine

### Description
Whether to show an axis line for this extra value axis if it is not placed directly adjacent to the chart rect. The default setting is the value of the \[showChartRect\](#attr-facetchartshowchartrect) property of the FacetChart.

**Flags**: IR

---
## Type: ClickMaskMode

### Description
Passed as a parameter to \[method:Canvas.showClickMask\](#method-canvasshowclickmask) to determine the masks behavior when clicked.

### Values

| Value | Description |
|-------|-------------|
| "hard" | When the mask receives a click, it will fire its click action, and cancel the event, leaving the clickMask up. |
| "soft" | When the mask receives a click, it will fire its click action, then dismiss the clickMask and allow the event to proceed to its target. |

### Groups

- clickMask

---
## Attr: ListGrid.recordCustomStyleProperty

### Description
Denotes the name of a property that can be set on records to display a custom style. For example if this property is set to `"customStyle"`, setting `record.customStyle` to a css styleName will cause the record in question to render out with that styling applied to it. Note that this will be a static style - it will not be modified as the state of the record (selected / over etc) changes.

### See Also

- [ListGrid.getCellStyle](#method-listgridgetcellstyle)
- [ListGrid.recordBaseStyleProperty](#attr-listgridrecordbasestyleproperty)

**Flags**: IRW

---
## Attr: DecisionTask.failureElement

### Description
ID of the next sequence or element to proceed to if the criteria do not match.

**Flags**: IR

---
## Method: MenuBar.removeMenus

### Description
Dynamically remove menus from the menuBar. Will update the visible set of buttons as appropriate.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| menus | [Array](#type-array) | false | — | Array of menus to remove (will accept actual Menu components, or numbers representing the index of the menus in the current menus array) |

---
## Attr: MenuButton.menu

### Description
The menu to show.

For a menu button with no menu (menu: null) the up/down arrow image can be suppressed by setting \[showMenuButtonImage\](#attr-menubuttonshowmenubuttonimage): `false`.

### Groups

- menu

**Flags**: IRW

---
## ClassAttr: Window.HORIZONTAL

### Description
A declared value of the enum type \[ContentLayoutPolicy\](#type-contentlayoutpolicy).

**Flags**: R

---
## Attr: Calendar.canSelectEvents

### Description
When set to true, makes individual \[event canvases\](#class-eventcanvas) selectable. Events may be selected via a single click, as well as being included in the page's tab order. The current selected event is shown in a special style and pressing TAB or Shift-TAB will move the selection first among the events in the same lane, and then among those in the next or previous lane.

Pressing Enter while an editable event is selected will show either the event- \[dialog\](#attr-calendareventdialog) or \[editor\](#attr-calendareventeditor). Pressing Delete will remove the event.

Note that when this property is false, single clicking the event canvas for an editable event will bring up an editing interface for that event. When true this is no longer the case - a user can double click to bring up the editing interface instead (a single click will simply select the event canvas).

**Flags**: IR

---
## Attr: FacetChart.standardDeviations

### Description
When \[attr:FacetChart.showStandardDeviationLines\](#attr-facetchartshowstandarddeviationlines) is set, the number of standard deviation lines drawn and their respective standard deviation away from the mean are specified by this property. The default is to display lines corresponding to the mean plus or minus one standard deviation.

Note that having zero in this list of standard deviations is identical to drawing a line at the mean.

For example assume that chart1 and chart2 both plot data with mean 1 and standard deviation 0.1. chart1 will draw a blue line at the value 1 and two red lines at the values 0.7 and 1.2. chart2 will draw three red lines at values 0.9, 1.0, and 1.1.

 isc.FacetChart.create({
     ID: "chart1",
     standardDeviations: \[-3, 2\],
     showExpectedValueLine: true,
     showStandardDeviationLines: true,
     expectedValueLineProperties: { lineColor: "blue" },
     standardDeviationLineProperties: { lineColor: "red" },
     // ...
 });

 isc.FacetChart.create({
     ID: "chart2",
     standardDeviations: \[-1, 0, 1\],
     showExpectedValueLine: false,
     showStandardDeviationLines: true,
     expectedValueLineProperties: { lineColor: "blue" },
     standardDeviationLineProperties: { lineColor: "red" },
     // ...
 });

### Groups

- statistics

**Flags**: IR

---
## Group: reifyMaven

### Description
SmartClient \[support for Maven\](#group-mavensupport) includes the ability to [import](http://github.smartclient.com/isc-maven-plugin/reify-import-mojo.html) (and optionally, [verify](http://github.smartclient.com/isc-maven-plugin/reify-validate-mojo.html) ) assets from [reify.com](http://reify.com) into your project either on-demand or during your build process. Using the [example configuration](http://github.smartclient.com/isc-maven-plugin/examples/configuration.html), the import command might look something like the following:

   mvn com.isomorphic:isc-maven-plugin:1.4.5:reify-import -Pisc
 

**Important:** This flow is unidirectional. That is, whatever changes are to be made to these resources should be made using the collaborative Reify environment and then re-imported. There is, by design, no reason to modify them locally, and the plugin takes steps to notify you when that happens. Refer to the \[Reify for Developers\](#group-reifyfordevelopers) documentation topic for further discussion.

---
## Attr: ScreenLoader.dataContextBinding

### Description
A \[object:DataContextBinding\](#object-datacontextbinding) to be applied to the loaded screen via \[method:Canvas.setDataContext\](#method-canvassetdatacontext).

### Groups

- dataContext

**Flags**: IWR

---
## Method: ListPropertiesDialog.applyClick

### Description
Notification method fired when the \[Apply button\](#attr-listpropertiesdialogapplybutton) is clicked.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| listProperties | [ListProperties](#type-listproperties) | false | — | the list properties to apply |

---
## Attr: StretchImgButton.labelHPad

### Description
The padding for a StretchImgButton's label is determined as follows.

If `labelHPad` is set it will specify the horizontal padding applied to the label. Similarly if `labelVPad` is set it will specify the vertical padding for the label, regardless of the button's \[vertical\](#attr-stretchimgbuttonvertical) setting.

Otherwise `labelLengthPad` can be set to specify the label padding along the length axis (ie: horizontal padding if \[attr:StretchImgButton.vertical\](#attr-stretchimgbuttonvertical) is false, otherwise vertical padding), and `labelBreadthPad` can be set to specify the label padding along the other axis.

Otherwise the padding on the length axis will match the \[attr:StretchImgButton.capSize\](#attr-stretchimgbuttoncapsize) and will be set to zero on the breadth axis.

So by default the label will be sized to match the center image of the StretchImgButton, but these settings allow the label to partially or wholly overlap the caps.

**Flags**: IRW

---
## ClassAttr: FieldPickerField.frozenTitle

### Description
The title displayed for the frozen property

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: RPCResponse.STATUS_REQUIRED_CRITERIA_MISSING

### Description
Indicates that an operation binding configured to require \[attr:OperationBinding.requiredCriterion\](#attr-operationbindingrequiredcriterion) has received none.

### Groups

- statusCodes
- constant

**Flags**: R

---
## Attr: Slider.rangeFormat

### Description
\[type:FormatString\](#type-formatstring) for numeric formatting of the range labels. If unset, defaults to \[attr:Slider.valueFormat\](#attr-slidervalueformat)

### Groups

- appearance

**Flags**: IR

---
## Attr: TourStep.afterInputTarget

### Description
Target component which must clicked to process \[attr:TourStep.expectedValue\](#attr-tourstepexpectedvalue) entered into \[target\](#attr-toursteptarget) with \[actionType\](#attr-tourstepactiontype) of "change".

This is commonly used for a dialog where the must select a value and then click a submit button.

Target may be specified as a \[type:GlobalId\](#type-globalid) for a Component or FormItem, or as a \[type:AutoTestLocator\](#type-autotestlocator) for an element.

**Flags**: IR

---
## Attr: ListGrid.canConfigureViaAI

### Description
Whether to show the \[Configure via AI\](#attr-listgridconfigureviaaitext) menu-item, which allows users to task the AI with performing multiple advanced configuration steps, such as grouping, hiliting and filtering, by entering plain-text commands.

### Groups

- ai

**Flags**: IRW

---
## Attr: DataSource.script

### Description
Default scriptlet to be executed on the server for each operation. If \[attr:OperationBinding.script\](#attr-operationbindingscript) is specified, it will be executed for the operation binding in question instead of running this scriptlet.

Scriptlets are used similarly to DMIs configured via \[attr:DataSource.serverObject\](#attr-datasourceserverobject) or \[attr:OperationBinding.serverObject\](#attr-operationbindingserverobject) - they can add business logic by modifying the DSRequest before it's executed, modifying the default DSResponse, or taking other, unrelated actions.

For example:

    <DataSource>
       <script language="groovy">
          ... Groovy code ...
       </script>
      ... other DataSource properties
    </DataSource>
 

Scriptlets can be written in any language supported by the "JSR 223" standard, including Java itself. See the \[DMI Script Overview\](#group-dmioverview) for rules on how to return data, add additional imports, and other settings.

The following variables are available for DMI scriptlets:

*   _requestContext_: RequestContext (from com.isomorphic.servlet)
*   _dataSource_: the current DataSource (same as DSRequest.getDataSource())
*   _dsRequest_: the current DSRequest
*   _criteria_: shortcut to DSRequest.getCriteria() (a Map)
*   _values_: shortcut to DSRequest.getValues() (a Map)
*   _oldValues_: shortcut to DSRequest.getOldValues() (a Map)
*   _log_: an instance of `com.isomorphic.log.Logger`, so your scripts can log in the same manner as regular Java code
*   _config_: an instance of `com.isomorphic.base.Config`, so your scripts have access to your `server.properties` settings
*   _sqlConnection_: 
    #### SQLDataSource only
    : the current SQLConnection object. If using \[automatic transactions\](#attr-datasourceautojointransactions) are enabled, this SQLConnection is in the context of the current transaction
*   _rpcManager_: the current RPCManager
*   _applicationContext_: the Spring ApplicationContext (when applicable)
*   _beanFactory_: the Spring BeanFactory (when applicable)

Scriptlets also have access to a set of contextual variables related to the Servlets API, as follows:

*   _servletRequest_: the current ServletRequest
*   _session_: the current HttpSession
*   _servletResponse_: the current ServletResponse 
    #### (advanced use only)
    
*   _servletContext_: the current ServletContext
    #### (advanced use only)
    

As with DMI in general, be aware that if you write scriptlets that depend upon these variables, you preclude your DataSource from being used in the widest possible variety of circumstances. For example, adding a scriptlet that relies on the `HttpSession` prevents your DataSource from being used in a command-line process.

_Note that if a dataSource configuration has both a `<script>` block and a specified \[serverObject\](#attr-operationbindingserverobject) for some operation, the script block will be executed, and the serverObject ignored._

**Flags**: IR

---
## Attr: FormItem.printTextBoxStyle

### Description
Base CSS class name for a form item's text box element when getting printable HTML for the form. If unset \[attr:FormItem.textBoxStyle\](#attr-formitemtextboxstyle) will be used instead. Note that focused styling will never be displayed while printing, though error and disabled styling will.

By default this style will be used for printHTML for the item even if the item is \[canEdit:false\](#attr-formitemcanedit) with \[readOnlyDisplay:static\](#attr-formitemreadonlydisplay).  
To override this behavior, developers may also specify a custom print style for this state via the \[attr:FormItem.printReadOnlyTextBoxStyle\](#attr-formitemprintreadonlytextboxstyle).

### Groups

- printing
- formItemStyling

**Flags**: IRW

---
## ClassMethod: Notify.addMessage

### Description
Displays a new message, subject to the \[stored configuration\](#classmethod-notifyconfiguremessages) for the passed `notifyType`, overridden by any passed `settings`. Returns an opaque `MessageID` that can be passed to \[classMethod:Notify.dismissMessage\](#classmethod-notifydismissmessage) to clear it.

Note that an empty string may be passed for `contents` if `actions` have been provided, so you may have the message consist only of your specified actions.

Most users should do all configuration up front via a call to \[classMethod:Notify.configureMessages\](#classmethod-notifyconfiguremessages). The `settings` argument in this method is provided to allow adjustment of properties that affect only one message, such as \[autoFitWidth\](#attr-notifysettingsautofitwidth), \[styleName\](#attr-notifysettingsstylename), or \[labelProperties\](#attr-notifysettingslabelproperties). Making changes to \[stacking\](#type-multimessagemode)-related properties via this argument isn't supported, unless specifically documented on the property.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| contents | [HTMLString](#type-htmlstring) | false | — | message to be displayed |
| actions | [Array of NotifyAction](#type-array-of-notifyaction) | true | — | actions (if any) for this message |
| notifyType | [NotifyType](#type-notifytype) | true | — | category of message; default "message" |
| settings | [NotifySettings](#type-notifysettings) | true | — | display and behavior settings for this message that override the \[configured\](#classmethod-notifyconfiguremessages) settings for the `notifyType` |

### Returns

`[MessageID](#type-messageid)` — opaque identifier for message

### See Also

- [isc.say](#staticmethod-iscsay)
- [isc.confirm](#staticmethod-iscconfirm)
- [isc.notify](#staticmethod-iscnotify)

---
## Attr: TourStep.allowDropOnDescendants

### Description
For \[actionType:"drag"\](#attr-tourstepactiontype) tourSteps with a \[attr:TourStep.dropTarget\](#attr-tourstepdroptarget), should we allow the drop to complete and the tour to proceed if the user drops on a descendant of the drop target.

For example - if a user has been prompted to drag a component into a Layout, but the layout already contains a nested child layout, should the user be able to drop into that child layout and continue the tour?

If unset this will be derived from \[attr:Tour.allowDropOnDescendants\](#attr-tourallowdropondescendants)

**Flags**: IR

---
## Attr: Calendar.eventEditor

### Description
An \[type:AutoChild\](#type-autochild) of type \[class:DynamicForm\](#class-dynamicform) which displays \[event data\](#object-calendarevent). This form is created within the \[event editor layout\](#attr-calendareventeditorlayout)

**Flags**: R

---
## Attr: Dialog.defaultWidth

### Description
—

### Groups

- appearance

**Flags**: IR

---
## Method: ListGrid.formatInactiveCellValue

### Description
Formatter for inactive content.

If present, this method will be invoked instead of \[method:ListGrid.formatCellValue\](#method-listgridformatcellvalue) in cases where the grid is rendering non-interactive content outside. Examples of cases where this can happen include:

*   dragTracker HTML for a row when \[attr:ListGrid.dragTrackerMode\](#attr-listgriddragtrackermode) is set to "record"
*   measurement HTML used for sizing columns during autoFit
*   measurement HTML used for sizing rows when \[attr:ListGrid.fixedRecordHeights\](#attr-listgridfixedrecordheights) is false and the grid has both frozen and unfrozen fields

May also be overridden at the \[field level\](#method-listgridfieldformatinactivecellvalue).

This is useful for cases where it would not be appropriate to render the standard formatted cell value outside of the body of the grid. An example might be if the formatted value contains a DOM element with a specified ID - an approach sometimes used for integrating third party components into SmartClient listGrid cells. In this case developers will wish to avoid having the framework render an element with the same ID outside of the grid, and should instead return HTML that would render at the same size, with an appropriate appearance.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| value | [Any](#type-any) | false | — | raw value for the cell being |
| record | [ListGridRecord](#type-listgridrecord) | false | — | Record object for the cell. Note: If this is a new row that has not been saved, in an editable grid, it has no associated record object. In this case the edit values will be passed in as this parameter. |
| rowNum | [number](#type-number) | false | — | row number for the cell |
| colNum | [number](#type-number) | false | — | column number for the cell. |

### Returns

`[HTMLString](#type-htmlstring)` — formatted value to display in the cell.

### See Also

- [ListGrid.formatCellValue](#method-listgridformatcellvalue)
- [ListGridField.formatInactiveCellValue](#method-listgridfieldformatinactivecellvalue)

---
## Method: Process.reset

### Description
Reset process to its initial state, so process can be started again.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| state | [Record](#type-record) | true | — | new state of the process |

---
## Attr: NavPanel.navLayout

### Description
The layout serving as the \[navigationPane\](#attr-splitpanenavigationpane) of this panel. By default it contains only the \[attr:NavPanel.navGrid\](#attr-navpanelnavgrid), but other members can be added before or after, respectively, via \[attr:NavPanel.navBeforeMembers\](#attr-navpanelnavbeforemembers) and \[attr:NavPanel.navAfterMembers\](#attr-navpanelnavaftermembers).

**Flags**: IR

---
## Method: WebService.getOutputHeaderSchema

### Description
Get the schema for each part of the SOAP header for the output message of a given operation, as a mapping from part name to schema. For example, given WSDL like:

     <soap:header part="SessionHeader"/>
     <soap:header part="CallOptions"/>
 

The following schema would be returned:

     { SessionHeader : _sessionHeaderPartSchema_,
       CallOptions : _callOptionsPartSchema_ }
 

The schema are instances of \[class:DataSource\](#class-datasource) that can be inspected to discover the elements and types that are legal in that header part, and can construct a valid SOAP header part if \[method:DataSource.xmlSerialize\](#method-datasourcexmlserialize) is invoked.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| operationName | [String](#type-string) | false | — | name of an operation from this web service |

### Returns

`[Object](#type-object)` — mapping from partName to schema

---
## Attr: Calendar.showEventHeaders

### Description
When rendering the \[canvas\](#attr-calendareventcanvas) for an event, whether to show the \[header area\](#attr-eventcanvasshowheader), typically containing suitable title text - \[by default\](#method-calendargeteventheaderhtml), the event's \[name\](#attr-calendarnamefield).

The default is true - if set to false, the event's \[body area\](#attr-eventcanvasshowbody) will fill the canvas.

**Flags**: IR

---
## Method: TileLayout.setTileSize

### Description
Sets the height and width of tiles.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| size | [int](#type-int) | false | — | size |

### Groups

- tileLayout

---
## Method: TableView.formatRecord

### Description
Formatter to apply to record display.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| record | [ListGridRecord](#type-listgridrecord) | false | — | record to format |

### Returns

`[HTMLString](#type-htmlstring)` — formatted record contents

---
## ClassMethod: AutoTest.locateCanvasFromDOMElement

### Description
Given an element in the DOM, returns the canvas containing this element, or null if the element is not contained in any canvas handle.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| element | [DOMElement](#type-domelement) | false | — | DOM element within in the page |

### Returns

`[Canvas](#type-canvas)` — canvas containing the element, or null if none apply

### Groups

- autoTest

---
## Attr: CreateScreenSettings.htmlElement

### Description
Simplifies integrating a screen with an existing JavaScript app. Does the following:

*   Sets \[attr:CreateScreenSettings.suppressAutoDraw\](#attr-createscreensettingssuppressautodraw): true
*   Sets \[attr:Canvas.htmlElement\](#attr-canvashtmlelement) of the screen's top widget to the DOM element
*   Sets the screen's top widget to have \[attr:Canvas.position\](#attr-canvasposition): "relative"
*   Draws the screen by calling \[method:Canvas.draw\](#method-canvasdraw) on the top widget

If you need to apply additional, custom configuration, for example setting \[attr:Canvas.htmlPosition\](#attr-canvashtmlposition), then instead of using this property, you can call \[classMethod:RPCManager.createScreen\](#classmethod-rpcmanagercreatescreen) with \[attr:CreateScreenSettings.suppressAutoDraw\](#attr-createscreensettingssuppressautodraw): true, and then manually configure and draw the screen:

     var screen = isc.RPCManager.createScreen("My Screen", {suppressAutoDraw: true});
     screen.setHtmlElement(element);
     screen.setHtmlPosition("replace");
     screen.position = "relative";
     screen.draw();

**Flags**: IR

---
## Attr: AIFieldRequest.valueClass

### Description
The class of value that AI will be asked to generate for the field.

**Flags**: IR

---
## Method: ListGrid.unsort

### Description
Turn sorting off, typically because data has changed and is no longer sorted.

Calling `unsort()` disables visual indication of which columns are sorted, and calls `unsort()` on the underlying dataset if supported.

Note that a grid viewing a paged dataset may not be able to support \[method:ResultSet.unsort\](#method-resultsetunsort) because the sort order is what establishes the row numbering that allows data to be fetched in batches. In this case the dataset will be explicitly sorted to an empty array which may cause the cache to be invalidated and a new fetch.

`unsort()` is automatically called in response to edits or changes to the data set that would cause records to be reordered. See \[group:editing\](#group-editing) for further details on editing records in a sorted ListGrid.

### Groups

- sorting

---
## Method: CubeGrid.getSelectedCells

### Description
Returns an array of the selected cell records.  
_methodType_ getter

### Returns

`[Array of CellRecord](#type-array-of-cellrecord)` — array of the selected cell records

### Groups

- selection

---
## Attr: EditTree.rootComponent

### Description
Root of data to edit. Must contain the "type" property, with the name of a valid \[schema\](#class-datasource) or nothing will be able to be dropped on this EditContext. A "liveObject" property representing the rootComponent is also suggested. Otherwise, a live object will be created from the palette node.

Can be retrieved at any time. Use \[method:EditTree.getRootEditNode\](#method-edittreegetrooteditnode) to retrieve the \[object:EditNode\](#object-editnode) created from the rootComponent.

### Groups

- devTools

**Flags**: IR

---
## Attr: Palette.defaultEditContext

### Description
Default EditContext that this palette should use. Palettes generally create components via drag and drop, but may also support creation via double-click or other UI idioms when a defaultEditContext is set.

**Flags**: IRW

---
## Type: AdminSearches

### Description
Policy for choosing between admin searches fetched from the DataSource vs. those declared locally on a component.

### Values

| Value | Description |
|-------|-------------|
| "preferSaved" | Combine both sets of records, but report the search record from the DataSource if two records have the same search name. |
| "preferLocal" | Combine both sets of records, but report the search record from \[adminSavedSearches\](#attr-databoundcomponentadminsavedsearches) if two records have the same search name. |
| "localOnly" | Only report the records from \[adminSavedSearches\](#attr-databoundcomponentadminsavedsearches). |

---
## Attr: EventCanvas.showBody

### Description
Renders a body DIV that fills the main area of the canvas, or all of it if no \[header\](#attr-eventcanvasshowheader) is shown. This area typically displays an \[event description\](#attr-calendareventdescription). This area can be styled via \[attr:EventCanvas.bodyStyle\](#attr-eventcanvasbodystyle) and the HTML it shows is retrieved from a call to \[getBodyHTML()\](#method-eventcanvasgetbodyhtml). The default is taken from \[attr:Calendar.showEventDescriptions\](#attr-calendarshoweventdescriptions).

**Flags**: IRW

---
## Attr: DateRange.end

### Description
The end of this DateRange.

**Flags**: IR

---
## Attr: PortalLayout.overflow

### Description
Controls how the PortalLayout reacts when column widths or \[class:Portlet\](#class-portlet) widths overflow the width of the PortalLayout. By default, the PortalLayout scrolls when necessary. You can also use overflow: visible or overflow: hidden, with the usual results -- see \[attr:PortalLayout.canResizePortlets\](#attr-portallayoutcanresizeportlets) for a further explanation of column widths.

Note that overflowing height is also affected by \[columnOverflow\](#attr-portallayoutcolumnoverflow). By default, each column will scroll individually -- you can change columnOverflow to "auto" to scroll the whole PortalLayout instead.

### Groups

- sizing

### See Also

- [PortalLayout.canResizePortlets](#attr-portallayoutcanresizeportlets)
- [PortalLayout.columnOverflow](#attr-portallayoutcolumnoverflow)
- [Canvas.overflow](#attr-canvasoverflow)

**Flags**: IRW

---
## Method: Layout.getChildTabPosition

### Description
Layouts ensure children are ordered in the tab-sequence with members being reachable first (in member order), then any non-member children.

As with \[method:Canvas.getChildTabPosition\](#method-canvasgetchildtabposition) if \[method:Canvas.setRelativeTabPosition\](#method-canvassetrelativetabposition) was called explicitly called for some child, it will be respected over member order.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| child | [Canvas](#type-canvas) | false | — | The child for which the tab position should be returned |

### Returns

`[Integer](#type-integer)` — tab position of the child within this layout.

---
## Method: Calendar.updateEventCanvasComponent

### Description
Called from \[method:EventCanvas.setEvent\](#method-eventcanvassetevent) when \[attr:Calendar.showEventCanvasComponents\](#attr-calendarshoweventcanvascomponents) is true and the eventCanvas already has a \[component\](#method-calendarcreateeventcanvascomponent). This method is expected to update the passed `component` as necessary, based on the \[current event\](#attr-eventcanvasevent).

By default, if the passed `component` has methods called `setEvent` or `setData`, those methods are called automatically.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| canvas | [EventCanvas](#type-eventcanvas) | false | — | the eventCanvas to update the component for |
| component | [Canvas](#type-canvas) | false | — | the component to be updated the canvas in question |

### See Also

- [Calendar.createEventCanvasComponent](#method-calendarcreateeventcanvascomponent)

---
## Attr: FacetChart.gradationZeroLineProperties

### Description
Properties for the gradation line drawn for zero (slightly thicker by default).

### Groups

- gradations

**Flags**: IR

---
## Attr: ComboBoxItem.sortField

### Description
Specifies one or more fields by which this item should be initially sorted. It can be a \[field name\](#attr-listgridfieldname), or an array of field names - but note that, if multiple fields are supplied, then each will be sorted in the same \[direction\](#attr-listgridsortdirection).

For full sorting control, set \[initialSort\](#attr-picklistinitialsort) to a list of custom \[sortSpecifiers\](#object-sortspecifier).

This attribute can also be set to the index of a field in the fields array, but note that it will be converted to a string (field name) after initialization.

### Groups

- sorting

**Flags**: IR

---
## Attr: SetFilterItem.toggleUseUnselectedValuesOnSelectAll

### Description
Should this item toggle between tracking selected options and using them to generate "inSet" criteria and unselected options and using them to generate "notInSet" criteria when the user clicks the \[attr:MultiPickerItem.selectAllButton\](#attr-multipickeritemselectallbutton) and \[attr:MultiPickerItem.deselectAllButton\](#attr-multipickeritemdeselectallbutton) on an unfiltered list of options.

See \[attr:SetFilterItem.useUnselectedValues\](#attr-setfilteritemuseunselectedvalues) for more detail

**Flags**: IRA

---
## Attr: ImgButton.width

### Description
Size for this component's horizontal dimension. See \[attr:Canvas.width\](#attr-canvaswidth) for more details.

Note that if \[attr:StatefulCanvas.autoFit\](#attr-statefulcanvasautofit) is set, this property will be ignored so that the widget is always sized just large enough to accommodate the title.

### Groups

- sizing

### See Also

- [StatefulCanvas.autoFit](#attr-statefulcanvasautofit)

**Flags**: IRW

---
## Attr: FormItem.picker

### Description
The component that will be displayed when \[method:FormItem.showPicker\](#method-formitemshowpicker) is called due to a click on the \[picker icon\](#attr-formitemshowpickericon).

Can be specified directly as a Canvas, or created automatically via the \[type:AutoChild\](#type-autochild) pattern. The default autoChild configuration for the picker is a Canvas with backgroundColor set and no other modifications.

Note that the picker is not automatically destroyed with the FormItem that uses it, in order to allow recycling of picker components. To destroy a single-use picker, override \[method:Canvas.destroy\](#method-canvasdestroy).

**Flags**: IRW

---
## ClassAttr: StatefulCanvas.STATE_DOWN

### Description
A declared value of the enum type \[State\](#type-state).

**Flags**: R

---
## ClassAttr: CubeGrid.ASCENDING

### Description
A declared value of the enum type \[FacetIndentDirection\](#type-facetindentdirection).

**Flags**: R

---
## Method: DrawItem.supportsEndArrow

### Description
Does this DrawItem \[support\](#classmethod-classismethodsupported) \[method:DrawItem.setEndArrow\](#method-drawitemsetendarrow)? For example, this is false for \[class:DrawRect\](#class-drawrect) and \[class:DrawOval\](#class-drawoval), and true for \[class:DrawLine\](#class-drawline).

### Returns

`[boolean](#type-boolean)` — whether setEndArrow() is supported by this DrawItem.

**Flags**: A

---
## Attr: Canvas.canFocus

### Description
Can this widget be allowed to become the target of keyboard events?

If canFocus is unset (the default), only scrollable widgets with visible scrollbars are focusable, to allow for keyboard scrolling.

A widget normally receives focus by being clicked on or tabbed to.

### Groups

- focus
- events

**Flags**: IRWA

---
## Type: FormatString

### Description
A String to be used as a format specifier for a date, datetime, time or numeric field, via the \[format\](#attr-datasourcefieldformat) and \[exportFormat\](#attr-datasourcefieldexportformat) properties.

For fields with a numeric type, the format string is similar to java.text.NumberFormat (see [DecimalFormat JavaDoc](http://docs.oracle.com/javase/7/docs/api/java/text/DecimalFormat.html)), and for date, time, and datetime types, the format string is similar to java.text.SimpleDateFormat (see [SimpleDateFormat JavaDoc](http://docs.oracle.com/javase/7/docs/api/java/text/SimpleDateFormat.html)).

Note that all the client-side formatting described in this section is is done by the \[NumberUtil.format()\](#classmethod-numberutilformat) and \[DateUtil.format()\](#classmethod-dateutilformat) methods. These are static utility methods that your own code can call if you need to programmatically format a date or number using a `FormatString`

There are 3 possible contexts where a `FormatString` may be interpreted, and each has slightly different limitations:

#### in-browser rendering & client-driven exports
Almost complete support for Java's SimpleDateFormat/DecimalFormat, as described below, with some small extensions for formatting with awareness of a \[object:FiscalCalendar\](#object-fiscalcalendar).

This category includes cases where code running in the browser does the rendering and the rendered result is passed to the server, such as \[client-driven export\](#method-listgridexportclientdata) and \[PDF export of the printed view\](#classmethod-rpcmanagerexportcontent).

#### Excel export
Almost the same as in-browser rendering, with minor limitations due to missing features in Excel. Exact differences are described under \[attr:DataSourceField.exportFormat\](#attr-datasourcefieldexportformat).
#### non-Excel server export
For example, CSV, XML or JSON \[export formats\](#type-exportformat) provided via \[method:DataSource.exportData\](#method-datasourceexportdata). Full support for SimpleDateFormat/DecimalFormat as provided by whichever Java version you have installed on the server. However note that depending on the context of the export, the default behavior may be to ignore format strings, since formatting intended for end users wouldn't be desirable if data exchange is the goal. See the \[Export Formatting overview\](#group-exportformatting) for details.

#### Date Format

#### Format token

#### Description

#### Sample value

yy

Year as a two-digit number

"99" or "07"

yyyy

Year as a four-digit number

"1999" or "2007"

YY

Week year as a two-digit number (week year is the year associated with the entire week deemed to contain a given date, and it may differ from calendar year. For example, the week year of December 31 2012 is 2013)

"99" or "07"

YYYY

Week year as a four-digit number

"1999" or "2007"

LL

Fiscal year as a two-digit number (\[object:FiscalCalendar\](#object-fiscalcalendar))

"99" or "07"

LLLL

Fiscal year as a four-digit number

"1999" or "2007"

M

Month in year

"1" to "12"

MM

Month in year with leading zero if required

"01" to "12"

MMM

Short month name (\[classAttr:DateUtil.shortMonthNames\](#classattr-dateutilshortmonthnames))

"Jan" to "Dec"

MMMM

Full month name (\[classAttr:DateUtil.monthNames\](#classattr-dateutilmonthnames))

"January" to "December"

w

Week in year

"1" to "52"

ww

Week in year with leading zero if required

"01" to "52"

C

Week in fiscal year (\[object:FiscalCalendar\](#object-fiscalcalendar))

"7" or "29"

CC

Week in fiscal year with leading zero if required

"07" or "29"

d

Day of the month

"1" to "31"

dd

Day of the month with leading zero if required

"01" to "31"

ddd

Short day name (\[classAttr:DateUtil.shortDayNames\](#classattr-dateutilshortdaynames))

"Mon" to "Sun"

dddd

Full day name. (\[classAttr:DateUtil.dayNames\](#classattr-dateutildaynames))

"Monday" to "Sunday"

E

Short day name ("EE" and "EEE" are equivalent; all are exactly the same as "ddd" - "E" is supported purely to conform with SimpleDateFormat)

"Mon" to "Sun"

EEEE

Full day name (exactly the same as "dddd")

"Monday" to "Sunday"

D

Day in year

"1" to "366"

DD

Day in year with leading zero if required

"01" to "366"

c

Day in fiscal year (\[object:FiscalCalendar\](#object-fiscalcalendar))

"5" or "204"

cc

Day in fiscal year with leading zero if required

"05" or "204"

u

Day number in week (1 is Monday)

"1" to "7"

H

Hour in day, 0-23 (24-hour clock)

"0" to "23"

HH

Hour in day with leading zero if required (24-hour)

"00" to "23"

h

Hour in day, 1-12 (12-hour clock)

"1" to "12"

hh

Hour in day with leading zero if required (12-hour)

"01" to "12"

m

Minute in hour

"0" to "59"

mm

Minute in hour with leading zero if required

"00" to "59"

s

Second in minute

"0" to "59"

ss

Second in minute with leading zero if required

"00" to "59"

S

Millisecond in second

"0" to "999"

SSS

Millisecond in second with leading zero(s) if required

"000" to "999"

a

The AM/PM designator (\[classAttr:Time.AMIndicator\](#classattr-timeamindicator))

" am" or " pm"

Note that all text that doesn't represent tokens specified above will be passed through to the output, but such unmapped character sequences are reserved for future use. To future-proof your code, you may single quote `"'"` any text to escape it to ensure no formatting is applied, guaranting that it's passed through unaltered. Thus, a format of `"h'h'"` might end up as `"5h"`. To create a single quote itself, use two in a row - for example `"h o''clock"`.

#### Examples - various formatted versions of the datetime "2006-08-03 11:26:18"

"M/d/yy"

8/3/06

"MMMM yyyy"

August 2006

"HH:mm"

11:26

"d MMM yyyy, H:ma"

3 Aug 2006, 11:26 am

"dd/MM/yyyy"

03/08/2006

"CC/LLLL"

53/2006 (assuming the fiscal year ends in the first week of August)

#### `SimpleDateFormat` specifiers that we do 
#### not
 support:

*   Era designator, BC/AD (G)
*   Day of week in month (F)
*   Hour in day, 24-hour, with 1-based instead of normal 0-based numbering (hours are 1-24) (k)
*   Hour in day, 12-hour, with 0-based instead of normal 1-based numbering (hours are 0-11) (K)
*   Timezone (z, Z, X)

#### Number Format

#### Format char

#### Description

0

Digit, zero is displayed

#

Digit, zero is not displayed

\-

Minus sign

.

Decimal separator

%

Multiply by 100 and show as percentage

‰ (\\u2030)

Multiply by 1000 and show as per mille. See below.

,

Indicates digit grouping should be used - eg 1,000,000. See below.

;

Separates positive and negative subpatterns. See below.

¤ (\\u00A4)

As a prefix or suffix, indicates the local currency symbol should be used. Note that you must use special notation to include this character in an XML file (such as a .ds.xml file). See below.

'

Used to quote special characters in a prefix or suffix, for example, "'#'#" formats 123 to "#123". To create a single quote itself, use two in a row: "# o''clock".

All other characters in the format string are taken literally and output unchanged.

#### Examples

#### Format string

#### Zero value

#### Positive value: 12345.678

#### Negative value: -2345.123

"0.00"

0.00

12345.68

\-2345.12

",##0.00"

0.00

12,345.68

\-2,345.12

"0.###"

0

12345.678

\-2345.123

"¤,0.00"

$0.00

$12,345.68

\-$2345.12

"0.0#%"

0.0%

1234567.8%

\-234512.3%

"0.0#‰"

0.0‰

12345678.0‰

\-2345123.0‰

"0.0#'%'"

0.0%

12345.68%

\-2345.12%

"0.00;(0.00)"

0.0%

12345.68

(2345.12)

  
Note, the above examples include cases where there are multiple '#' characters in the integer part of the number format (ie, to the left of the decimal separator, or the entire format if there is no separator). We support this pattern simply because `DecimalFormat` does: the extra '#' characters are not significant. In other words, the format "##0.00" produces exactly the same formatting as "0.00", and "##,###,###.##" produces exactly the same formatting as ",#.##". However, multiple '0' characters in the integer part of the format _are_ significant, as are both '#' and '0' characters in the decimal part of the format (ie, to the right of any decimal separator).

The ";" character marks the boundary between two subpatterns - the first to be used for formatting positive numbers (and 0), the second for negative numbers. Specifying a separate pattern for negative numbers is optional: if no negative subpattern is specified, negative numbers are formatted like positive numbers, but with a leading "-" sign.

The "¤" symbol (\\u00A4) is documented in the Java DecimalFormat class as a placeholder for the currency symbol appropriate to the current locale. For client-driven exports, we replace it with the \[localized currency symbol\](#classattr-numberutilcurrencysymbol). Likewise, we use \[decimalSymbol\](#classattr-numberutildecimalsymbol) and \[groupingSymbol\](#classattr-numberutilgroupingsymbol) to localize the formatting of numbers. Note that "\\u00A4" is the correct way to specify this character in Javascript code. If you need to specify the character in an XML file - the common requirement is in a .ds.xml DataSource descriptor file - you must use the code "&#x00A4;" instead.

The "‰" per mille symbol is specified as "\\u2030" in Javascript code; in XML or HTML you can use either the equivalent notation "&#x2030;" or the special HTML code "&permil;".

#### `DecimalFormat` features that we do 
#### not
 support:

*   Scientific notation
*   Doubled currency symbol means "use international currency symbol"
*   We do not support arbitrary digit grouping, by providing patterns of the '#' and ',' characters, like `DecimalFormat` does. Grouping in SmartClient FormatStrings is enabled with a single "," character somewhere before or within the number-formatting part of the string - extra "," characters within the number-formatting part of the string are tolerated, but they have no effect. Grouping in SmartClient always causes digits to be gathered in groups of three

### See Also

- [DataSourceField.format](#attr-datasourcefieldformat)
- [DataSourceField.exportFormat](#attr-datasourcefieldexportformat)
- [DateUtil.format](#classmethod-dateutilformat)
- [NumberUtil.format](#classmethod-numberutilformat)
- [Time.toTime](#classmethod-timetotime)
- [Time.toShortTime](#classmethod-timetoshorttime)

---
## Attr: Canvas.testDataContext

### Description
A \[object:DataContext\](#object-datacontext) to be used if no \[attr:Canvas.dataContext\](#attr-canvasdatacontext) is provided (directly or indirectly via a parent). If a DataContext is provided it completely replaces the `testDataContext`.

DataSources included in the `testDataContext` are immediately provided to \[rule context\](#attr-canvasrulescope) when used if no other component has done so already. These records are found in rule context 'dataContext' section (ex. `dataContext.Customer` for a Customer record in `testDataContext`) so they do not conflict with normal DataSource records.

### Groups

- dataContext

### See Also

- [DataContext](#object-datacontext)

**Flags**: IR

---
## Method: ListGrid.exportClientData

### Description
Exports this component's data with client-side formatters applied, so is suitable for direct display to users, using the specified \[export format\](#attr-dsrequestexportas).

A variety of DSRequest settings, such as \[exportAs\](#attr-dsrequestexportas) and \[DSRequest.exportFilename\](#attr-dsrequestexportfilename), affect the exporting process: see \[exportResults\](#attr-dsrequestexportresults) for further detail.

If this component is \[databound\](#method-databoundcomponentsetdatasource) and not all records that match the current \[filter-criteria\](#method-listgridgetcriteria) have \[been loaded\](#method-resultsetallmatchingrowscached), you can call \[method:ListGrid.loadAllRecords\](#method-listgridloadallrecords) - this method accepts a callback which is fired when all necessary data has arrived. When that callback fires, a call to `exportClientData` will have access to the full dataset for the filter.

This feature requires the SmartClient server.

If your ListGrid has custom formatters, formatted values will be exported by default, with HTML normalized to text where possible. Since some levels of HTML normalizing aren't possible, this may result in missing or incorrect export values. In this case, you have three options:

*   Set \[exportRawValues\](#attr-listgridfieldexportrawvalues) on the field. This will export the raw underlying value of the field; your formatter will not be called
*   Have your formatter call \[isExportingClientData()\](#method-listgridisexportingclientdata) and perform whatever alternative formatting you require if that method returns true
*   Set \[exportRawNumbers\](#attr-listgridfieldexportrawnumbers) on the field. This will export the raw underlying number of the field; your formatter will not be called

Note that during export, the \[attr:ListGridField.escapeHTML\](#attr-listgridfieldescapehtml) setting on a field determines how escaped and unescaped HTML values are handled. In particular, if `escapeHTML` is not set for a field, a value like "<FOO>" will be exported as the empty string, and you'd need the escaped value "&lt;FOO&gt;" to end up exporting "<FOO>".

Ordinarily, calls to this method go through the static classMethod \[classMethod:DataSource.exportClientData\](#classmethod-datasourceexportclientdata). In this case, no server-side DataSources are required. However, if this component is \[databound\](#method-databoundcomponentsetdatasource) and you specify a valid \[operationId\](#attr-dsrequestoperationid) in the properties passed to this method, the call will go through the instance method \[method:DataSource.exportClientData\](#method-datasourceexportclientdata) instead. As the documentation for that method explains, this allows you more control on the server side. This approach requires both the SmartClient server and server-side DataSource definitions.

To export data from this component's dataSource, see \[exportData\](#method-databoundcomponentexportdata), which does not include client-side formatters, but 
#### does
 include formatters declared in the `.ds.xml` file. `exportData()` relies on both the SmartClient server and server-side DataSources.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| requestProperties | [DSRequest Properties](#type-dsrequest-properties) | true | — | Request properties for the export. Note that specifying \[exportData\](#attr-dsrequestexportdata) on the request properties allows the developer to pass in an explicit data set to export. |
| callback | [RPCCallback](#type-rpccallback) | true | — | Optional callback. If you specify \[exportToClient\](#attr-dsrequestexporttoclient): false in the request properties, this callback will fire after export completes. Otherwise the callback will fire right before the download request is made to the server. |

### See Also

- [DataSource.exportClientData](#method-datasourceexportclientdata)
- [exportFormatting](#group-exportformatting)

---
## Attr: DynamicForm.linearNumCols

### Description
Specifies the \[number of columns\](#attr-dynamicformnumcols) when the form is being rendered in \[attr:DynamicForm.linearMode\](#attr-dynamicformlinearmode), overriding any automatically derived value in that mode.

### Groups

- formLayout

**Flags**: IRW

---
## Attr: Gradient.colorStops

### Description
An array of color stops for this gradient.

**Flags**: IR

---
## Method: StatefulCanvas.setBaseStyle

### Description
Sets the base CSS style. As the component changes state and/or is selected, suffixes will be added to the base style.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| style | [CSSStyleName](#type-cssstylename) | false | — | new base style |

---
## Method: FilteredList.setAllRows

### Description
Updates \[attr:FilteredList.allRows\](#attr-filteredlistallrows) at run time.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| allRows | [Array of Records](#type-array-of-records) | false | — | New set of unfiltered cache data |

---
## Attr: DateChooser.yearMenuStyle

### Description
Style for the pop-up year menu.

**Flags**: IR

---
## Attr: ListGrid.fastCellUpdates

### Description
#### Note: This property only has an effect in Internet Explorer

Advanced property to improve performance for dynamic styling of gridRenderer cells in Internet Explorer, at the expense of slightly slower initial drawing, and some limitations on supported styling options.

`fastCellUpdates` speeds up the dynamic styling system used by rollovers, selections, and custom styling that calls \[method:GridRenderer.refreshCellStyle\](#method-gridrendererrefreshcellstyle), at the cost of slightly slower draw() and redraw() times.

Notes:

*   When this property is set, ListGrid cells may be styled using the \[attr:ListGrid.tallBaseStyle\](#attr-listgridtallbasestyle). See \[method:ListGrid.getBaseStyle\](#method-listgridgetbasestyle) for more information.
*   If any cell styles specify a a background image URL, the URL will be resolved relative to the page location rather than the location of the CSS stylesheet. This means cell styles with a background URL should either supply a fully qualified path, or the background image media should be made available at a second location for IE.
*   fastCellUpdates will not work if the styles involved are in an external stylesheet loaded from a remote host. Either the stylesheet containing cell styles needs to be loaded from the same host as the main page, or the cell styles need to be inlined in the html of the bootstrap page.
*   fastCellUpdates will not work if the css styles for cells are defined in a `.css` file loaded via `@import`. Instead the `.css` file should be loaded via a `<link ...>` tag.

### Groups

- performance

**Flags**: I

---
## ClassAttr: TableView.WHOLE_RECORD

### Description
A declared value of the enum type \[NavigationMode\](#type-navigationmode).

**Flags**: R

---
## Type: Overflow

### Description
—

### Values

| Value | Description |
|-------|-------------|
| Canvas.VISIBLE | Content that extends beyond the widget's width or height is displayed. Note: To have the content be sized only by the drawn size of the content set the overflow to be Canvas.VISIBLE and specify a small size, allowing the size to expand to the size required by the content. Leaving the width / height for the widget undefined will use the default value of 100, and setting the size to zero may cause the widget not to draw. |
| Canvas.HIDDEN | Content that extends beyond the widget's width or height is clipped (hidden). |
| Canvas.AUTO | Horizontal and/or vertical scrollbars are displayed only if necessary. Content that extends beyond the remaining visible area is clipped. |
| Canvas.SCROLL | Horizontal and vertical scrollbars are always drawn inside the widget. Content that extends beyond the remaining visible area is clipped, and can be accessed via scrolling. |
| Canvas.CLIP_H | Clip horizontally but extend the canvas's clip region vertically if necessary.  
#### Note:
 only supported for specific widget subclasses. |
| Canvas.CLIP_V | Clip vertically but extend the canvas's clip region horizontally if necessary.  
#### Note:
 only supported for specific widget subclasses. |

### Groups

- sizing

---
## Class: RPCResponse

### Description
Encapsulates an RPC response from the server. Instances of this class are automatically created and optionally passed to you in the callback you specify as part of your RPCRequest.

### See Also

- [RPCRequest](#object-rpcrequest)
- [Callbacks.RPCCallback](#method-callbacksrpccallback)

---
## Method: DataBoundComponent.getSelectionLength

### Description
Returns the number of selected records.

### Returns

`[int](#type-int)` — number of selected records

### Groups

- selection

---
## Attr: PortalLayout.canResizePortlets

### Description
Should the height and width of \[Portlets\](#class-portlet) be drag-resizable?

Note that changing the 
#### height
 of a Portlet will change the height of all the Portlets in the same row to match.

If the height of Portlets causes a column to overflow, that column will scroll vertically (independent of other columns), depending on the \[columnOverflow\](#attr-portallayoutcolumnoverflow) setting.

Changing the 
#### width
 of a Portlet will potentially cause columns to stretch and shrink their displayed widths in order to accommodate the Portlets, depending on the value of \[canStretchColumnWidths\](#attr-portallayoutcanstretchcolumnwidths) and \[canShrinkColumnWidths\](#attr-portallayoutcanshrinkcolumnwidths).

However, the instrinsic width of the columns will remain the same, so that the columns will resume their former widths when no longer necessary to stretch or shrink to accommodate the widths of Portlets. To allow drag-resizing of the intrinsic width of columns, see \[canResizeColumns\](#attr-portallayoutcanresizecolumns).

The net effect is that (by default) PortalLayouts behave like layouts when Portlet sizes do not cause overflow, but behave more like stacks when overflow occurs.

### Groups

- sizing

### See Also

- [PortalLayout.canResizeColumns](#attr-portallayoutcanresizecolumns)
- [PortalLayout.canStretchColumnWidths](#attr-portallayoutcanstretchcolumnwidths)
- [PortalLayout.canShrinkColumnWidths](#attr-portallayoutcanshrinkcolumnwidths)
- [PortalLayout.columnOverflow](#attr-portallayoutcolumnoverflow)

**Flags**: IRW

---
## Attr: TextItem.selectOnClick

### Description
Allows the \[selectOnClick\](#attr-dynamicformselectonclick) behavior to be configured on a per-FormItem basis. Normally all items in a form default to the value of \[attr:DynamicForm.selectOnClick\](#attr-dynamicformselectonclick).

### Groups

- focus

**Flags**: IRW

---
## Attr: DetailViewer.valueAlign

### Description
Horizontal alignment of values in this viewer. If unspecified, defaults to `"right"` when in RTL mode and `"left"` otherwise.

### Groups

- values

**Flags**: IRW

---
## Method: DrawItem.computeAngle

### Description
Computes the angle in degrees from the positive X axis to the difference vector 
#### v
2 - 
#### v
1 between the two given vectors.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| px1 | [double](#type-double) | false | — | X coordinate of 
#### v
1 |
| py1 | [double](#type-double) | false | — | Y coordinate of 
#### v
1 |
| px2 | [double](#type-double) | false | — | X coordinate of 
#### v
2 |
| py2 | [double](#type-double) | false | — | Y coordinate of 
#### v
2 |

### Returns

`[double](#type-double)` — the angle in degrees, in the range \[0, 360).

---
## Attr: ListGrid.useAdvancedCriteria

### Description
Should the \[filter-editor\](#attr-listgridshowfiltereditor) in this grid always produce \[object:AdvancedCriteria\](#object-advancedcriteria)?

### Groups

- criteriaEditing

**Flags**: IRW

---
## Attr: DynamicForm.disableValidation

### Description
If set to true, client-side validators will not run on the form when validate() is called. Server-side validators (if any) will still run on attempted save.

### Groups

- validation

### See Also

- [DynamicForm.saveData](#method-dynamicformsavedata)
- [DynamicForm.submit](#method-dynamicformsubmit)

**Flags**: IRW

---
## Attr: Calendar.selectedCellStyle

### Description
The base name for the CSS class applied to a cell that is selected via a mouse drag.

### Groups

- appearance

**Flags**: IRW

---
## Attr: Calendar.bringEventsToFront

### Description
If set to true, clicking an event will bring it to the front of the zorder.

### Groups

- calendarEvent

**Flags**: IR

---
## Attr: FormItem.hintClassName

### Description
CSS class for the "hint" string.

### Groups

- appearance

### See Also

- [FormItem.hint](#attr-formitemhint)

**Deprecated**

**Flags**: IR

---
## Method: Canvas.moveBy

### Description
Moves the widget deltaX pixels to the right and deltaY pixels down. Pass negative numbers to move up and/or to the left.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| deltaX | [int](#type-int) | false | — | amount to move horizontally (may be negative) |
| deltaY | [int](#type-int) | false | — | amount to move vertically (may be negative) |

### Returns

`[Boolean](#type-boolean)` — whether the component actually moved

### Groups

- positioning

---
## ClassAttr: DataSource.requiredCriterionMessage

### Description
A message returned by a `DataSource` when an operation requires criteria, but none was provided.

### Groups

- i18nMessages

**Flags**: IRW

---
## ClassAttr: Media.svgDefaultSize

### Description
The default-size in pixels for any request for an SVG symbol that doesn't provide any sizes (none of width/height/imageWidth/imageHeight on the widget or "size" in the src-string). In this way, unsized SVGs will render at a useable default size, rather than at browser-default size, which is 300x150 and never desirable.

### Groups

- svgSymbols

**Flags**: IR

---
## Method: PortalLayout.willAcceptDrop

### Description
This method has been overridden to support drag-reorder of PortalColumns, and adding of new rows by dropping directly on the PortalLayout, as described in \[attr:PortalLayout.dropTypes\](#attr-portallayoutdroptypes)

### Returns

`[Boolean](#type-boolean)` — true if the widget object being dragged can be dropped on this widget, false if it cannot (and `drop()` should not bubble), null to permit `drop()` to bubble to parent elements

---
## Attr: Canvas.mouseStillDownInitialDelay

### Description
Amount of time (in milliseconds) before mouseStillDown events start to be fired repeatedly for this canvas. See \[method:Canvas.mouseStillDown\](#method-canvasmousestilldown) for details.

### Groups

- events

**Flags**: IRWA

---
## Method: EditContext.substitutedNode

### Description
Notification fired when a different \[object:PaletteNode\](#object-palettenode) is substituted for one being dropped into a container.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| origNode | [PaletteNode](#type-palettenode) | false | — | node that was originally dropped |
| newNode | [PaletteNode](#type-palettenode) | false | — | node that was substituted |
| parentNode | [EditNode](#type-editnode) | false | — | parent node of the drop |

---
## Attr: MiniDateRangeItem.textBoxStyle

### Description
Base CSS class name for a form item's text box element.

See \[group:formItemStyling\](#group-formitemstyling) for an overview of formItem styling, and the \[group:CompoundFormItem\_skinning\](#group-compoundformitem-skinning) discussion for special skinning considerations.

If the `textBoxStyle` is changed at runtime, \[updateState()\](#method-formitemupdatestate) must be called to update the visual state of this item.

### Groups

- formItemStyling

### See Also

- [FormItem.cellStyle](#attr-formitemcellstyle)

**Flags**: IRW

---
## Attr: DSRequest.exportShowHeaderSpanTitles

### Description
When you erxport a \[class:ListGrid\](#class-listgrid) that has \[headerSpans\](#attr-listgridheaderspans), should headerSpans also be exported. See \[attr:DSRequest.exportSpanTitleSeparator\](#attr-dsrequestexportspantitleseparator) for details of of what it means to export headerSpans to different export targets.

Note that \[attr:DSRequest.exportPropertyIdentifier\](#attr-dsrequestexportpropertyidentifier) controls whether field names or titles are appended to the headerSpan titles (and used for fields without headerSpans).

**Flags**: IR

---
## Attr: TimeItem.minuteItemProperties

### Description
Custom properties to apply to this timeItem's generated \[minute picker\](#attr-timeitemminuteitem).

**Flags**: IRA

---
## Attr: MinimalScrollbar.autoHideDelay

### Description
If \[attr:MinimalScrollbar.autoShow\](#attr-minimalscrollbarautoshow) is true, the scrollbar will auto hide after the user has stopped interacting with it for this many milliseconds.

**Flags**: IRW

---
## Method: ListGrid.setBodyStyleName

### Description
Update the \[bodyStyleName\](#attr-listgridbodystylename) for this listGrid.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| styleName | [CSSStyleName](#type-cssstylename) | false | — | new body style name |

---
## Attr: ListGrid.showExpansionEditorSaveButton

### Description
When \[type:ExpansionMode\](#type-expansionmode) is _editor_, should a Save button be shown below the the expanded editor?

Note that if an expanded-row containing an editor is collapsed while changes are outstanding, changes will be either be automatically updated to the grid, or will first show a confirmation dialog, according to the value of \[attr:ListGrid.expansionEditorShowSaveDialog\](#attr-listgridexpansioneditorshowsavedialog).

### Groups

- expansionField

**Flags**: RW

---
## Group: items

### Description
Manipulating the items that belong to a form.  
  
An item manages an atomic value (eg a String, Number, Date, etc) that appears as one of the properties in the overall form's values. Some items exist purely for layout or appearance purposes (eg SpacerItem) and do not manage a value.

---
## Attr: TreeGrid.cantDragMultipleNodeOccurencesMessage

### Description
For \[Multi-link trees\](#method-treeismultilinktree) only, the message displayed when the user attempts to drag two or more occurrences of the same node into a parent.

### Groups

- i18nMessages

### See Also

- [TreeGrid.canDragRecordsOut](#attr-treegridcandragrecordsout)
- [TreeGrid.canAcceptDroppedRecords](#attr-treegridcanacceptdroppedrecords)
- [TreeGrid.canReorderRecords](#attr-treegridcanreorderrecords)
- [TreeGrid.parentAlreadyContainsChildMessage](#attr-treegridparentalreadycontainschildmessage)

**Flags**: IR

---
## ClassAttr: SortSpecifierUtil.descendingSortDescription

### Description
The description of

### Groups

- i18nMessages

**Flags**: IRW

---
## Method: ResultSet.find

### Description
Like \[method:List.find\](#method-listfind). Checks only loaded rows and will not trigger a fetch.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| propertyName | [String](#type-string)|[Object](#type-object)|[AdvancedCriteria](#type-advancedcriteria) | false | — | property to match, or if an Object is passed, set of properties and values to match |
| value | [Any](#type-any) | true | — | value to compare against (if propertyName is a string) |

### Returns

`[Object](#type-object)` — first matching object or null if not found

### Groups

- access
- find

---
## Method: CalendarView.isVerticalView

### Description
Returns true if this is the \[week\](#attr-calendarweekview) or \[day\](#attr-calendardayview) view, false otherwise.

### Returns

`[boolean](#type-boolean)` — true if this is a Week or Day view

---
## Attr: DataBoundComponent.asyncErrorHoverProperties

### Description
Properties to use for a hover displaying information about a non-successful asynchronous operation.

Only the properties mentioned on the documentation of \[classMethod:Hover.show\](#classmethod-hovershow) will have an effect.

### Groups

- fieldGeneration
- pseudoFieldGeneration

**Flags**: IRW

---
## Attr: FormItem.type

### Description
The DynamicForm picks a field renderer based on the type of the field (and sometimes other attributes of the field).

### Groups

- appearance

### See Also

- [FormItemType](#type-formitemtype)
- [FieldType](#type-fieldtype)

**Flags**: IR

---
## Attr: DataSourceField.sequenceName

### Description
For a DataSource with \[serverType:"sql"\](#attr-datasourceservertype) with a field of type "sequence", the name of the SQL sequence that should be used when inserting new records into this table.

Note that this is never required for SQL tables that are generated from SmartClient DataSources (a default sequence name of tableName + "\_" + columnName is chosen, but see the notes below regarding this), and is never required for databases where inserting null into a sequence column is sufficient (MySQL, SQL Server, DB2 and others).

You would only need to set sequenceName if you are integrating with a pre-existing table stored in a database where the sequence must be named for insertion to work (Oracle, Postgres, Firebird) OR you are trying to use the same sequence across multiple DataSources.

#### Note:
 If you specify the `sql.{database type}.sequence.name.prefix` and/or `sql.{database type}.sequence.name.suffix` properties in your \[server.properties\](#group-server-properties) file,the generated sequence name will include the prefix and/or suffix. For example, with a prefix of "order\_system\_" and a suffix of "\_seq", the sequence generated for column "orderNumber" on table "orders" would be:

     order\_system\_orders\_orderNumber\_seq

### Groups

- sqlDataSource

**Flags**: IR

---
## Attr: TextAreaItem.textBoxStyle

### Description
Base CSS class to apply to this item's input element. NOTE: See the \[group:CompoundFormItem\_skinning\](#group-compoundformitem-skinning) discussion for special skinning considerations.

### Groups

- appearance

**Flags**: IRW

---
## ClassMethod: Authentication.setAvailableRoles

### Description
Specify the full set of available user roles.

Note that if the current user has been marked as a \[superUser\](#classmethod-authenticationissuperuser), \[classMethod:Authentication.getRoles\](#classmethod-authenticationgetroles) will return the full set of available roles.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| roles | [Array of String](#type-array-of-string) | false | — | full set of possible user roles. |

---
## Class: Messaging

### Description
The Real-Time Messaging module creates a channel for messages to be sent from the server to the client (a.k.a. "server push") in real-time (as opposed to periodically polling the server for updates).

See \[Messaging overview\](#group-messaging) for information.

---
## Method: SavedSearches.getLocalDataSource

### Description
This method returns an automatically generated custom DataSource to store saved searches for a component in HTML5 localStorage. Note that this dataSource will only be used to store savedSearches if there is no \[shared default dataSource\](#attr-savedsearchesdefaultdatasource) specified, and if \[attr:ListGrid.savedSearchDS\](#attr-listgridsavedsearchds) is not set for the component.

The offline storage key for the data will be generated by combining the \[attr:SavedSearches.offlineStorageKey\](#attr-savedsearchesofflinestoragekey) with the component identifier retrieved from \[method:SavedSearches.getSavedSearchId\](#method-savedsearchesgetsavedsearchid).

#### Note:
 The dataSources returned by this method will suppress logging their requests to the \[Developer Console RPC tag\](#group-devconsolerpctab) by default. This is done so developers can more easily see dataSource requests and responses that were explicitly initiated by application code, to simplify debugging. However, if a developer has explicitly created a SavedSearch dataSource either as the \[global default\](#attr-savedsearchesdefaultdatasource) or at the \[component level\](#attr-listgridsavedsearchds), requests to access and update SavedSearch data will be logged as with any other dataSource.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| componentId | [Canvas](#type-canvas)|[String](#type-string) | false | — | Component to retrieve the dataSource for, or saved search component identifier as returned by \[method:SavedSearches.getSavedSearchId\](#method-savedsearchesgetsavedsearchid) |

### Returns

`[DataSource](#type-datasource)` — dataSource for SavedSearches backed by HTML5 local storage.

---
## Method: TimeItem.setValue

### Description
Set the value of the form item to the value passed in

NOTE: for valueMap'd items, newValue should be data value not displayed value

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| newValue | [Any](#type-any) | false | — | value to set the element to |

---
## Object: SystemWaitConfig

### Description
Configuration object for \[classMethod:AutoTest.waitForSystemDone\](#classmethod-autotestwaitforsystemdone)

---
## Attr: Canvas.skinImgDir

### Description
Default directory for skin images (those defined by the class), relative to the Page-wide \[skinDir\](#classmethod-pagegetskindir).

### Groups

- images

**Flags**: IRWA

---
## Method: Canvas.enable

### Description
Enables this widget and any children / peers of this widget.

### Groups

- enable

---
## Method: TreeGrid.getOpenIcon

### Description
Get the appropriate open/close opener icon for a node. Returns null if \[attr:TreeGrid.showOpener\](#attr-treegridshowopener) is set to false.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| node | [TreeNode](#type-treenode) | false | — | tree node in question |

### Returns

`[URL](#type-url)` — URL for the icon to show the node's open state

**Flags**: A

---
## Group: RTL

### Description
—

---
## Method: Calendar.adjustCriteria

### Description
Gets the criteria to use when the calendar date ranges shift. This would be called, for example, when the next button is clicked and new events may need to be fetched. Override this function to add any custom criteria to the default criteria constructed by the calendar.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| defaultCriteria | [Criterion](#type-criterion) | false | — | default criteria generated by the calendar |

### Returns

`[Criterion](#type-criterion)` — modified criteria

---
## Attr: ListGridField.sortByMappedValue

### Description
If \[attr:ListGridField.valueMap\](#attr-listgridfieldvaluemap) is set, and the grid is \[sorted\](#method-listgridsetsort) by this field, should the data be sorted by the underlying data value or the mapped display value. If unset, will sort by display value. Set to `false` to sort by underlying data value. Note that this has no effect if a \[method:ListGridField.sortNormalizer\](#method-listgridfieldsortnormalizer) has been specified.

**Flags**: IRW

---
## Method: TabSet.tabDeselected

### Description
Optional handler to fire when a tab is deselected. Returning false will cancel the new selection, leaving tab `ID` selected. As with \[method:TabSet.tabSelected\](#method-tabsettabselected) this method only fires when the tabset is drawn.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| tabNum | [Integer](#type-integer) | false | — | the index of the deselected tab |
| tabPane | [Canvas](#type-canvas) | false | — | the deselected tab's pane if set |
| ID | [GlobalId](#type-globalid) | false | — | the ID of the deselected tab |
| tab | [Tab](#type-tab) | false | — | the deselected tab object (not tab button instance) |
| newTab | [Tab](#type-tab) | false | — | the tab object being selected |
| name | [TabName](#type-tabname) | false | — | the name of the deselected tab |

### Returns

`[boolean](#type-boolean)` — return false to cancel the tab deselection

---
## ClassMethod: Reify.showMockDS

### Description
Shows the result of running \[classMethod:Reify.getMockDS\](#classmethod-reifygetmockds) in a \[modal window\](#class-modalwindow) so it can be copied and pasted as needed into \[Reify\](#group-reifyfordevelopers) or elsewhere.

Note that the callback is fired when the window is closed, not when it's populated.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| dsNames | [Array of String](#type-array-of-string)|[String](#type-string) | false | — | \[ID\](#attr-datasourceid)s of the desired DataSources |
| callback | [MockDSExportCallback](#type-mockdsexportcallback) | false | — | called with the complete export or serialization |
| settings | [MockDSExportSettings](#type-mockdsexportsettings) | false | — | controls format and what records and metadata to include |

---
## ClassMethod: NumberUtil.format

### Description
Return the parameter number formatted according to the parameter \[type:FormatString\](#type-formatstring). This method is used to implement the \[attr:DataSourceField.format\](#attr-datasourcefieldformat) functionality, but it can also be used to format arbitrary numbers programmatically.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| number | [Number](#type-number) | false | — | The number to format |
| format | [FormatString](#type-formatstring) | false | — | The format to apply |

### Returns

`[String](#type-string)` — formatted number string

---
## Attr: ComboBoxItem.separateValuesList

### Description
AutoChild used to show \[attr:ComboBoxItem.specialValues\](#attr-comboboxitemspecialvalues).

**Flags**: IR

---
## ClassMethod: SchemaSet.get

### Description
Retrieve a SchemaSet object by it's schemaNamespace.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| schemaNamespace | [String](#type-string) | false | — | uri from the "targetNamespace" attribute of the <xsd:schema> element from the XML Schema or WSDL file this SchemaSet was derived from. |

### Returns

`[SchemaSet](#type-schemaset)` — the requested SchemaSet, or null if not loaded

**Flags**: A

---
## Attr: RibbonGroup.label

### Description
AutoChild \[Label\](#class-label) used to display the \[title text\](#attr-ribbongrouptitle) for this group.

Can be customized via the standard \[type:AutoChild\](#type-autochild) pattern, and various convenience APIs exist for configuring it after initial draw: see \[setShowTitle\](#method-ribbongroupsetshowtitle), \[setTitle\](#method-ribbongroupsettitle), \[setTitleAlign\](#method-ribbongroupsettitlealign), \[setTitleHeight\](#method-ribbongroupsettitleheight), \[setTitleOrientation\](#method-ribbongroupsettitleorientation) and \[setTitleStyle\](#method-ribbongroupsettitlestyle).

**Flags**: IR

---
## Attr: Calendar.zoneCanvas

### Description
AutoChild component created for each \[zone\](#attr-calendarzones) entry.

**Flags**: A

---
## Group: reifyCustomDataSources

### Description
DataSources placed in the project dataSources directory (\[webroot\]/shared/ds by default) will be detected by Reify whenever it is started, and appear in the DataSource listing in the lower right-hand corner automatically.

If you have created a custom subclass of DataSource (eg, as a base class for several DataSources that contact the same web service), you can use it with Reify by:

*   creating an XML version of the DataSource using the XML tag <DataSource> and the `constructor` property set to the name of your custom DataSource subclass (as described \[group:componentXML\](#group-componentxml) under the heading _Custom Components_)
*   modifying \[webroot\]/tools/visualBuilder/globalDependencies.xml to load the JavaScript code for your custom DataSource class. See examples in that file.

### See Also

- [toolsDeployment](#group-toolsdeployment)
- [reifyCustomComponents](#group-reifycustomcomponents)
- [reify](#group-reify)

---
## Method: DrawRect.isPointInPath

### Description
Returns true if the given point in the drawing coordinate system is within this DrawItem's shape, taking into account local transforms.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| x | [int](#type-int) | false | — | X coordinate of the test point. |
| y | [int](#type-int) | false | — | Y coordinate of the test point. |

### Returns

`[boolean](#type-boolean)` — —

---
## Attr: DateRangeItem.toDate

### Description
Initial value for the "to" date.

**Flags**: IRW

---
## Method: FormItem.getValueAsFloat

### Description
Return the value tracked by this form item as a Float. If the value cannot be parsed to a valid float, null will be returned.

### Returns

`[Float](#type-float)` — value of this element

### See Also

- [FormItem.getValue](#method-formitemgetvalue)

---
## Attr: TextAreaItem.supportsCutPasteEvents

### Description
Does the current formItem support native cut and paste events?

This attribute only applies to freeform text entry fields such as \[class:TextItem\](#class-textitem) and \[class:TextAreaItem\](#class-textareaitem), and only if \[attr:TextAreaItem.changeOnKeypress\](#attr-textareaitemchangeonkeypress) is true. If true, developers can detect the user editing the value via cut or paste interactions (triggered from keyboard shortcuts or the native browser menu options) using the \[method:FormItem.isCutEvent\](#method-formitemiscutevent) and \[method:FormItem.isPasteEvent\](#method-formitemispasteevent) methods. This allows custom cut/paste handling to be added to the various change notification flow methods including \[method:FormItem.change\](#method-formitemchange), and \[method:FormItem.transformInput\](#method-formitemtransforminput).

**Flags**: IRW

---
## Attr: TourStep.showInputValidationMessage

### Description
Should \[inputValidationNotifyMessage\](#attr-tourstepinputvalidationnotifymessage) be shown as detailed in \[type:TourInputValidationMode\](#type-tourinputvalidationmode)? Defaults from \[attr:Tour.showInputValidationMessage\](#attr-tourshowinputvalidationmessage) if not set.

If set to `false` reporting messages to the user are suppressed and therefore \[method:Tour.notifyValidationMessage\](#method-tournotifyvalidationmessage) will not be called.

**Flags**: IR

---
## Method: DrawImage.setSrc

### Description
Change the URL of the image displayed.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| src | [URL](#type-url) | false | — | new URL |

---
## Attr: SerializationSettings.indent

### Description
Overrides the default indention setting during serialization. XML defaults to indented and JSON defaults to non-indented.

**Flags**: IR

---
## Attr: ListGrid.confirmDiscardEditsMessage

### Description
If `this.confirmDiscardEdits` is true, this property can be used to customize the error message string displayed to the user in a dialog with options to cancel the action, or save or discard pending edits in response to sort/filter actions that would otherwise drop unsaved edit values.

### Groups

- editing
- i18nMessages

**Flags**: IRW

---
## Method: Canvas.moveBelow

### Description
Puts this widget just below the specified widget in the stacking order, so it appears behind the specified widget if both widgets have the same parent.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| canvas | [Canvas](#type-canvas) | false | — | canvas to move below |

### Groups

- zIndex

---
## Attr: MinimalScrollbar.interactive

### Description
Is this scrollbar currently in "interactive" mode? If true, the scrollbar will be shown with a more prominent appearance, making it clear the user can interact with it by clicking the track or dragging the thumb.

If \[attr:MinimalScrollbar.setInteractiveOnMouseOver\](#attr-minimalscrollbarsetinteractiveonmouseover) is true, this property will automatically be updated on mouseOver.

**Flags**: IRW

---
## Attr: ListGrid.groupTitleColumnDefaults

### Description
Default properties for the automatically generated `groupTitleColumn`. Default object includes properties to enable autoFitWidth to group title values.

To modify the behavior or appearance of this column, developers may set \[attr:ListGrid.groupTitleColumnProperties\](#attr-listgridgrouptitlecolumnproperties) at the instance level, or override this object at the class level. If overriding this object, we recommend using \[classMethod:Class.changeDefaults\](#classmethod-classchangedefaults) rather than replacing this object entirely.

See \[attr:ListGrid.showGroupTitleColumn\](#attr-listgridshowgrouptitlecolumn) for an overview of the groupTitleColumn.

**Flags**: IR

---
## Attr: FilterViaAIProgressDialog.title

### Description
Title for this Window, shown if \[showTitle\](#attr-windowshowtitle) is true in the \[header\](#attr-windowheader) (if drawn).

### Groups

- i18nMessages

**Flags**: IRW

---
## ClassMethod: EventHandler.middleButtonDown

### Description
Returns true if the middle mouse button is being pressed.

Checking whether the middle mouse button is pressed can be used to implement power user shortcuts; however, note that many pointing devices do not have a middle button. Thus, the application should **not** require the user to press a middle button in order to perform some action.

### Returns

`[boolean](#type-boolean)` — true if the middle mouse button is pressed; false otherwise.

### Groups

- mouseEvents

### See Also

- [EventHandler.leftButtonDown](#classmethod-eventhandlerleftbuttondown)
- [EventHandler.rightButtonDown](#classmethod-eventhandlerrightbuttondown)

**Flags**: A

---
## Method: StatefulCanvas.setIgnoreRTL

### Description
Setter for \[ignoreRTL\](#attr-statefulcanvasignorertl).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| ignoreRTL | [boolean](#type-boolean) | false | — | new value for ignoreRTL. |

**Flags**: A

---
## ClassMethod: AutoTest.isSystemDone

### Description
Returns a boolean to indicate whether the current application is fully loaded with no pending operations, and is ready for user interaction. This includes the following checks:

*   page has finished loading
*   all ListGrids (as defined by isc.isA.ListGrid) satisfy \[classMethod:AutoTest.isGridDone\](#classmethod-autotestisgriddone)
*   all TileGrids that are drawn satisfy \[classMethod:AutoTest.isTileGridDone\](#classmethod-autotestistilegriddone)
*   all TileLayouts that are drawn satisfy \[classMethod:AutoTest.isTileLayoutDone\](#classmethod-autotestistilelayoutdone)
*   all DynamicForms that are drawn satisfy \[classMethod:AutoTest.isFormDone\](#classmethod-autotestisformdone)
*   all Canvii that are drawn satisfy \[classMethod:AutoTest.isCanvasDone\](#classmethod-autotestiscanvasdone)

In addition to this the `options` parameter allows developers to check additional criteria as documented under \[object:SystemDoneConfig\](#object-systemdoneconfig).

Note: \[classMethod:AutoTest.waitForSystemDone\](#classmethod-autotestwaitforsystemdone) will poll this method repeatedly to check for all pending actions being complete. The \[object:SystemWaitConfig\](#object-systemwaitconfig) parameter of that method allow the user to speciofy which actions to wait for. By default \[classMethod:AutoTest.waitForSystemDone\](#classmethod-autotestwaitforsystemdone) will wait for _all_ actions to complete, including queued redraws, timers, network requests, as well as page load and comopnent level `is_Component_Done` checks.

Depending on your application configuration, it is possible that this method will not be able to determine whether it is truly in a busy state. Some examples include:

*   If \[attr:SystemDoneConfig.includeTimers\](#attr-systemdoneconfigincludetimers) is true and the application has a constantly running background timer to perform some ongoing polling action or similar, this method may return `false` even though the application is ready for interaction
*   Similarly if \[attr:SystemDoneConfig.includeRedraws\](#attr-systemdoneconfigincluderedraws) is true, and the application is using messaging, or some other mechanism to periodically refresh component(s) such that they are repeatedly marked as dirty, this method may return `false` even though the application is ready for interaction
*   If this application makes use of some third-party library to perform asynchronous actions, this method may return `true` even when the application is waiting on a response from this third-party tool.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| options | [SystemDoneConfig](#type-systemdoneconfig)|[boolean](#type-boolean) | true | — | This parameter determines what specific outstanding actions are required to be completed before the system is considered "done" with current processing. If passed as a boolean rather than a SystemDoneConfig object, this determines whether the system should wait for \[pending redraws\](#method-canvasmarkforredraw). |

### Returns

`[boolean](#type-boolean)` — whether loaded page is 'done' as described above

### Groups

- autoTest

---
## Class: Button

### Description
The Button widget class implements interactive, style-based button widgets.

---
## Attr: StatefulCanvas.showDisabledIcon

### Description
If using an icon for this button, whether to switch the icon image if the button becomes disabled.

### Groups

- buttonIcon

**Flags**: IR

---
## ClassMethod: FilterBuilder.getFilterDescription

### Description
Returns a human-readable string describing the clauses in this advanced criteria or criterion.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| criteria | [AdvancedCriteria](#type-advancedcriteria)|[Criterion](#type-criterion) | false | — | Criteria to convert to a readable string |
| dataSource | [DataSource](#type-datasource) | false | — | DataSource to provide definitions of operators |
| criteriaOutputSettings | [CriteriaOutputSettings](#type-criteriaoutputsettings) | true | — | optional configuration settings for the output |

### Returns

`[String](#type-string)` — Human-readable string describing the clauses in the passed criteria

---
## Method: SummaryBuilder.fireOnClose

### Description
Override to execute a callback function when the Format is Cancelled or Saved.

### Groups

- summaryFields

**Flags**: A

---
## Attr: DSResponse.offlineTimestamp

### Description
Timestamp (millisecond value) to indicate when this dsResponse was cached in \[offline storage\](#class-offline). Not applicable if the response has never been stored offline.

### Groups

- offlineGroup

**Flags**: R

---
## Attr: FormItem.value

### Description
Value for this form item. This value may be set directly on the form item initialization block but is not updated on live items and should not be directly accessed. Once a form item has been created by the dynamicForm use \[method:FormItem.setValue\](#method-formitemsetvalue) and \[method:FormItem.getValue\](#method-formitemgetvalue) directly.

### Groups

- basics

**Flags**: IR

---
## Attr: DrawTriangle.points

### Description
Array of points of the triangle. specified in the \[local coordinate system\](#class-drawpane).

**Flags**: IRW

---
## ClassAttr: Messaging.websocketURL

### Description
URL where the WebSocket endpoint is registered. On the server, the URI of the endpoint is controled by the server.properties configuration setting `messaging.websocket.URI` and defaults to `/isomorphic/websocket`

This URL must ultimately start with ws:// or wss://, but you may specify this value as starting with http:// or https:// and it will be automatically converted to ws(s)://

**Flags**: IR

---
## Attr: ListGrid.dataArity

### Description
A ListGrid is a \[dataArity\](#attr-databoundcomponentdataarity):multiple component.

### Groups

- databinding

**Flags**: IRWA

---
## Attr: MultiGroupDialog.addLevelButtonTitle

### Description
The title-text to appear on the addLevelButton.

Note, this is a passthrough property which, when set, is passed through to the \[MultiGroupPanel\](#class-multigrouppanel) contained in this dialog. You only need to consider the properties on the MultiGroupPanel for i18n.

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: StateTask.fieldListsLengthMismatchMessage

### Description
The default message to be reported with \[getInvalidTaskMessage()\](#method-processelementgetinvalidtaskmessage) when the `inputFieldList` and `outputFieldList` properties do not have the same length.

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: ImgSectionHeader.clipTitle

### Description
If the title for this section header is too large for the available space, should the title be clipped?

This feature is supported only in browsers that support the CSS UI text-overflow property (IE6+, Firefox 7+, Safari, Chrome, Opera 9+).

**Flags**: IR

---
## Attr: Flashlet.pluginsPage

### Description
This attribute specifies the page the user should go to to get the plugin required to view this flashlet.

The default pluginsPage is: "http://www.macromedia.com/shockwave/download/index.cgi?P1\_Prod\_Version=ShockwaveFlash"

**Flags**: IR

---
## Attr: Tab.prompt

### Description
Specifies the prompt to be displayed when the mouse hovers over the tab.

After the TabSet has been created, you can change a tab's `prompt` property by calling \[method:TabSet.setTabProperties\](#method-tabsetsettabproperties).

**Flags**: IR

---
## Attr: FormItem.changeOnKeypress

### Description
Should this form item fire its \[change\](#method-formitemchange) handler (and store its value in the form) on every keypress? Set to `false` to suppress the 'change' handler firing (and the value stored) on every keypress.

Note: If `false`, the value returned by \[getValue\](#method-formitemgetvalue) will not reflect the value displayed in the form item element as long as focus is in the form item element.

### Groups

- eventHandling
- values

**Flags**: IRW

---
## Attr: SelectItem.pickListFields

### Description
This property allows the developer to specify which field\[s\] will be displayed in the drop down list of options.

Only applies to databound pickLists (see \[attr:PickList.optionDataSource\](#attr-picklistoptiondatasource), or pickLists with custom data set up via the advanced \[method:PickList.getClientPickListData\](#method-picklistgetclientpicklistdata) method.

If this property is unset, we display the \[attr:PickList.displayField\](#attr-picklistdisplayfield), if specified, otherwise the \[attr:PickList.valueField\](#attr-picklistvaluefield).

If there are multiple fields, column headers will be shown for each field, the height of which can be customized via the \[attr:PickList.pickListHeaderHeight\](#attr-picklistpicklistheaderheight) attribute.

Each field to display should be specified as a \[object:ListGridField\](#object-listgridfield) object. Note that unlike in \[listGrids\](#class-listgrid), dataSource fields marked as \[hidden:true\](#attr-datasourcefieldhidden) will be hidden by default in pickLists. To override this behavior, ensure that you specify an explicit value for \[showIf\](#method-listgridfieldshowif).

### Groups

- pickList

### See Also

- [SelectItem.valueField](#attr-selectitemvaluefield)
- [PickList.pickListHeaderHeight](#attr-picklistpicklistheaderheight)

**Flags**: IRA

---
## Attr: Label.iconSpacing

### Description
Pixels between icon and title text.

### Groups

- buttonIcon

**Flags**: IR

---
## Attr: ListGrid.canFreezeFields

### Description
Whether an interface should be shown to allow user is allowed to dynamically "freeze" or "unfreeze" columns with respect to horizontally scrolling. If unset, this property defaults to `true` unless:

*   \[this.fixedRecordHeights\](#attr-listgridfixedrecordheights) is `false`
*   \[this.bodyOverflow\](#attr-listgridbodyoverflow) is `"visible"`
*   \[this.autoFitData\](#attr-listgridautofitdata) is set to `"horizontal"` or `"both"`
*   Any field has overflow set to `"visible"`

Note that the `canFreezeFields` setting enables or disables the user interface for freezing and unfreezing fields only. Fields can be programmatically frozen via setting \[field.frozen\](#attr-listgridfieldfrozen) to true when the grid is created, or dynamically frozen and unfrozen via \[method:ListGrid.freezeField\](#method-listgridfreezefield) and \[method:ListGrid.unfreezeField\](#method-listgridunfreezefield).

Developers should also be aware that if the cell content for some field exceeds the specified \[attr:ListGrid.cellHeight\](#attr-listgridcellheight), and \[attr:ListGrid.enforceVClipping\](#attr-listgridenforcevclipping) is not set to true, this can cause misalignment between rows in frozen and unfrozen columns. See the \[Frozen fields overview\](#group-frozenfields) for more on this.

### Groups

- frozenFields

**Flags**: IRW

---
## Group: comboBoxItemCriteria

### Description
A ComboBoxItem generates two different types of criteria in different circumstances:

1.  The criteria used against the \[optionDataSource\](#attr-comboboxitemoptiondatasource) to retrieve what is shown in the drop-down \[pickList\](#attr-comboboxitempicklist), and also to retrieve individual display values via the \[fetchMissingValues\](#attr-textitemfetchmissingvalues) behavior
2.  The criteria that are generated for searching in some other component when the ComboBoxItem is used as part of a \[class:SearchForm\](#class-searchform), such as in the \[FilterEditor of a ListGrid\](#attr-listgridshowfiltereditor), or in a separate SearchForm (perhaps configured via \[attr:ListGrid.searchForm\](#attr-listgridsearchform))

This overview covers the latter case: how a ComboBoxItem creates criteria for searching some in some other component.

#### Explicitly selected option:
  
If a user explicitly selects an option from the ComboBox drop down pickList, default behavior is to generate an \[advanced criterion\](#method-comboboxitemhasadvancedcriteria) with \[operator:"equals"\](#type-operatorid) to exactly match the selected option.

This reflects user expectation. If you are, for example, filtering a grid of Orders, and you have a ComboBoxItem as part of a search interface that allows you to pick a specific salesRep, then you expect to see only orders handled by that salesRep.

Exceptions: If the target DataSource does not \[support advanced criteria\](#method-datasourcesupportsadvancedcriteria), or \[attr:ComboBoxItem.generateExactMatchCriteria\](#attr-comboboxitemgenerateexactmatchcriteria) has been explicitly set to false, simple criteria will be generated. Also note that if a \[ComboBoxItem.operator\](#attr-formitemoperator) has been specified, it will be used instead of setting the operator to `"equals"`.

#### Unrecognized value:
  
If, instead of picking an option, a user enters some text into the ComboBoxItem's textbox that does not exactly match one of the available options, the generated filter criterion will not be an advanced criterion by default. Instead it will behave like a normal \[class:TextItem\](#class-textitem), generating a simple criterion value unless advanced criteria were \[explicitly requested\](#method-dynamicformgetvaluesasadvancedcriteria), or the item also has a specified \[ComboBoxItem.operator\](#attr-formitemoperator).

This again reflects user expectation. If you are, for example, filtering a grid of Orders, and you have a ComboBoxItem as part of a search interface that allows you to pick Sales Reps, then if you enter just "John", you would expect to see all orders that were handled by anyone named "John".

#### Criterion field
:  
By default, if a specific value has been chosen, the generated Criterion targets the valueField with an exact match (with exceptions explained above).

However, if a search value has been entered without picking a specific record, the generated Criterion targets the displayField if it differs from the valueField. This is correct behavior - if we consider the example of showing all Orders entered by any Sales Rep called "John", we'd need to apply criteria to the display field (containing the Sales Reps' names) rather than the valueField (likely to be an ID or similar).

Developers may override this behavior by specifying an explicit \[ComboBoxItem.criteriaField\](#attr-formitemcriteriafield). If specified this will be used in the generated criteria whether the user selected an option from the pickList or entered a new value into the text box.

---
## ClassAttr: Tree.isNodeLocatorProperty

### Description
Name of property that identifies a \[NodeLocator\](#object-nodelocator) object for any \[multi-link tree\](#method-treeismultilinktree)s.

**Flags**: IRW

---
## Attr: DateChooser.headerStyle

### Description
CSS style applied to the day-of-week headers. By default this applies to all days of the week. To apply a separate style to weekend headers, set \[attr:DateChooser.weekendHeaderStyle\](#attr-datechooserweekendheaderstyle)

**Flags**: IRW

---
## Attr: LoadProjectSettings.verifyAsError

### Description
Enable \[verifyAsError\](#classattr-rpcmanagerverifyaserror) behavior only for requests using these settings.

### See Also

- [CreateScreenSettings.verifyAsError](#attr-createscreensettingsverifyaserror)
- [LoadProjectSettings.verifyAsError](#attr-loadprojectsettingsverifyaserror)

**Flags**: IRW

---
## Attr: MockDSExportSettings.numLevels

### Description
The number of levels of nodes to include, for DataSources that define a \[tree relationship\](#group-treedatabinding) between fields by declaring a \[foreignKey\](#attr-datasourcefieldforeignkey) on one field that refers to another from that same DataSource.

### See Also

- [MockDSExportSettings.rootCriteriaOnly](#attr-mockdsexportsettingsrootcriteriaonly)

**Flags**: IR

---
## Method: FormItem.getIconTabPosition

### Description
Returns the desired tab-position of some icon with respect to other focusable sub-elements for this formItem.

Default implementation returns the index of the icon in the icons array, (plus one if a pickerIcon is showing) meaning users can tab through icons in order. Has no effect for non-focusable icons.

### Returns

`[Integer](#type-integer)` — desired position in the tab-order within this item's sub-elements

---
## Attr: RibbonButton.iconOrientation

### Description
This attribute is not supported in this subclass. However, RTL mode is still supported.

**Flags**: IRW

---
## Method: Deck.hideCurrentPane

### Description
Hides the current pane, without showing any other pane.

---
## Method: CoTProcess.mockOutput

### Description
Process-level provider of synthetic AI output used when mocking is in effect and the current task does not implement \[method:CoTTask.mockOutput\](#method-cottaskmockoutput) or returns null from that method.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| task | [CoTTask](#type-cottask) | false | — | The task requesting mocked output |

### Returns

`[Object](#type-object)` — Fake AI output for the given task

### Groups

- CoTMocking

---
## Group: contentLoading

### Description
—

---
## Attr: OperationBinding.qualifyColumnNames

### Description
Specifies, for this specific operationBinding, whether to qualify column names with table names in any SQL we generate. Overrides the \[attr:DataSource.qualifyColumnNames\](#attr-datasourcequalifycolumnnames) property. Only applicable to dataSources of \[serverType\](#attr-datasourceservertype) "sql".

**Flags**: IR

---
## Attr: DetailViewer.labelPrefix

### Description
text to put before a label

### Groups

- labels

**Flags**: IRW

---
## Method: DOMGrid.setRootElement

### Description
Set the root element (or document) to view in the tree.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| rootElement | [DOMElement](#type-domelement) | false | — | new root element |

---
## Method: Menu.setItemHidden

### Description
Hides or shows the menu item according to the value of newState, and redraws the menu if necessary. Returns true if there's a change in the hidden state.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| item | [MenuItem](#type-menuitem)|[number](#type-number) | false | — | MenuItem in question, or its index. Note that if an index is passed it will be interpreted as the index in the full specified set of items rather than the visible-index of the item. |
| newState | [boolean](#type-boolean) | true | — | true to hide the menu item, false to show it. |

### Returns

`[boolean](#type-boolean)` — true if the hidden state was changed

### See Also

- [Menu.filterHiddenItems](#attr-menufilterhiddenitems)

---
## Attr: TimeItem.hourValues

### Description
An array of values to make available in the \[hour picker\](#attr-timeitemhouritem) when \[useTextField\](#attr-timeitemusetextfield) is false.

Used for specifying a limited set of valid Hour values, or when using the TimeItem to record duration, rather than time per-se.

See \[hourMinValue\](#attr-timeitemhourminvalue), \[hourMaxValue\](#attr-timeitemhourmaxvalue) and \[hourIncrement\](#attr-timeitemhourincrement) for another method of controlling the content in the hour picker.

**Flags**: IRW

---
## Attr: ImgTab.showRollOver

### Description
Should we visibly change state when the mouse goes over this tab

**Flags**: IRW

---
## Method: SimpleType.updateAtomicValue

### Description
Optional method to update a live data value with an edited atomic value (such as a string or number). If defined this method will be called when the user edits data in a field of this type, allowing the developer to convert from the atomic type to a raw data value for storage.

Note that if the user is editing a field which did not previously have a value, the 'currentValue' will be null. This method should handle this (creating a new data value).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| atomicValue | [Any](#type-any) | false | — | New atomic value. This should match the underlying atomic type specified by the \[attr:SimpleType.inheritsFrom\](#attr-simpletypeinheritsfrom) attribute. |
| currentValue | [Any](#type-any) | false | — | Existing data value to be updated. |
| reason | [String](#type-string) | false | — | The reason your updateAtomicValue() method is being called. See \[method:SimpleType.getAtomicValue\](#method-simpletypegetatomicvalue) for the reason strings used by the framework |

### Returns

`[Any](#type-any)` — Updated data value.

---
## Attr: ValidatorDefinition.action

### Description
\[type:Callback\](#type-callback), function, or JavaScript expression called after every validation (i.e. call to \[attr:ValidatorDefinition.condition\](#attr-validatordefinitioncondition)) whether it passed or failed. This allows the validator perform an operation on the field based on the validation outcome.

An `action()` function is not needed to report an error message only.

For the required parameters, see the documentation for \[ValidatorActionCallback\](#method-callbacksvalidatoractioncallback).

**Flags**: IR

---
## ClassAttr: Operators.endsWithFieldTitle

### Description
Title for the "endsWithField" operator

### Groups

- i18nMessages

**Flags**: IR

---
## Method: Selection.deselectItem

### Description
Deselect a particular item by its position in the list

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| position | [number](#type-number) | false | — | index of the item to be selected |

### Returns

`[boolean](#type-boolean)` — true == selection actually changed, false == no change

### Groups

- selection

---
## Method: DataBoundComponent.addSummaryField

### Description
Convenience method to display a \[class:SummaryBuilder\](#class-summarybuilder) to create a new Summary Field. This is equivalent to calling \[editSummaryField()\](#method-databoundcomponenteditsummaryfield) with no parameter.

### Groups

- summaryFields

---
## Attr: FacetValue.titleHilite

### Description
Hilite style to apply to the title for this facetValue.

#### Note:
 This property is specific to \[CubeGrids\](#class-cubegrid). See \[attr:CubeGrid.hilites\](#attr-cubegridhilites).

**Flags**: IR

---
## Attr: ListGridField.autoFit

### Description
When set, this attribute causes this field to be auto-sized directly by effectively setting \[attr:ListGridField.autoFitWidth\](#attr-listgridfieldautofitwidth) to true and applying an \[attr:ListGridField.autoFitWidthApproach\](#attr-listgridfieldautofitwidthapproach). This direct approach is different from and less verbose than applying \[similar properties\](#attr-listgridautofitfieldwidths) on the \[grid\](#class-listgrid) and overriding them on a per-field basis.

### Groups

- autoFitFields

**Flags**: IRW

---
## Attr: FacetChart.hoverRectProperties

### Description
Properties for rectangle that draws behind of a floating hover label that represents the data value. See \[attr:FacetChart.showValueOnHover\](#attr-facetchartshowvalueonhover) for more details.

### Groups

- appearance

**Flags**: IR

---
## Method: DateItem.getFiscalCalendar

### Description
Returns the \[object:FiscalCalendar\](#object-fiscalcalendar) object that will be used by this item's DateChooser.

### Returns

`[FiscalCalendar](#type-fiscalcalendar)` — the fiscal calendar for this chooser, if set, or the global one otherwise

---
## Attr: StateTask.value

### Description
If a stateTask does not declare \[inputs\](#attr-taskinputs), it must declare a `value` which should be assigned to the output field.

See \[attr:StateTask.type\](#attr-statetasktype) for how the value is interpreted.

**Flags**: IR

---
## Attr: DataSource.fileNameField

### Description
The native field name used by this DataSource on the server to represent the `fileName` for \[FileSource Operations\](#group-filesource) operations. Any extensions to the fileName to indicate type or format (e.g. ".ds.xml") are stored in the \[fileTypeField\](#attr-datasourcefiletypefield) and \[fileFormatField\](#attr-datasourcefileformatfield), if specified for this DataSource.

If not specified for a DataSource, the fileNameField will be inferred on the server as follows:

*   If there is a field named "fileName", "name", or "title", then that field is used.
*   Otherwise, if there is a single primary key, and it has the type "text", then that field is used.
*   Otherwise, an error is logged

### Groups

- fileSource

**Flags**: IR

---
## Attr: AIRequest.historyConclusion

### Description
When this engine does not support multiple messages, all of the messages of the request must be concatenated together. This text is included verbatim before the concatenation of all-but-the-last non-system message.

**Flags**: IR

---
## Attr: Tab.visibleWhen

### Description
Criteria to be evaluated to determine whether this Tab should be visible.

A basic criteria uses textMatchStyle:"exact". When specified in \[Component XML\](#group-componentxml) this property allows \[shorthand formats\](#group-xmlcriteriashorthand) for defining criteria.

### Groups

- ruleCriteria

**Flags**: IR

---
## Method: ListGrid.getEditedRecord

### Description
Returns the combination of unsaved edits (if any) and original values (if any) for a given row being edited.

The returned value is never null, and can be freely modified.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| valuesID | [number](#type-number)|[Object](#type-object) | false | — | rowNum of the record being edited, or an Object containing values for all the record's primary keys |

### Returns

`[Object](#type-object)` — A copy of the record with unsaved edits included

### Groups

- editing

---
## Attr: Shuttle.valueField

### Description
This field is expected to be unique for records within the shuttle's data set. If not explicitly specified the \[dataSource.primaryKey\](#class-datasource) will be used.

May be used to \[select records by value\](#method-shuttlesetselectedbyvalue) and to retrieve the current \[selected values\](#method-shuttlegetselectedvalues).

**Flags**: IR

---
## Attr: DataBoundComponent.dragTrackerStyle

### Description
CSS Style to apply to the drag tracker when dragging occurs on this component.

**Flags**: IRW

---
## Attr: DSResponse.dataSource

### Description
The DataSource of this DSResponse.

### Groups

- dsResponse

**Flags**: IR

---
## Attr: LoadProjectSettings.password

### Description
Overrides \[classAttr:Reify.password\](#classattr-reifypassword) setting the account password for \[method:Reify.loadProject\](#method-reifyloadproject).

Note that this setting only applies when using \[method:Reify.loadProject\](#method-reifyloadproject).

**Flags**: IR

---
## Method: List.addAt

### Description
Add a single item to this array at a specific position in the list, sliding other items over to fit.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| obj | [Object](#type-object) | false | — | object to add |
| pos | [number](#type-number) | false | — | position in the list to add at |

### Returns

`[Object](#type-object)` — object that was added

### Groups

- modification

---
## Attr: TreeGridField.treeField

### Description
The field containing `treeField: true` will display the \[class:Tree\](#class-tree). If no field specifies this property, if a field named after the \[attr:Tree.titleProperty\](#attr-treetitleproperty) of the Tree is present in \[attr:TreeGrid.fields\](#attr-treegridfields), that field will show the tree. Note that when using a DataSource, you typically define the title field via \[attr:DataSource.titleField\](#attr-datasourcetitlefield) and the generated \[class:ResultTree\](#class-resulttree) automatically uses this field.

If none of the above rules apply, the first field in \[attr:TreeGrid.fields\](#attr-treegridfields) is assigned to display the \[class:Tree\](#class-tree).

Note that if \[attr:TreeGrid.treeFieldMinWidth\](#attr-treegridtreefieldminwidth) is specified, this will act as a default minimum width for tree fields (taking precedence over \[treeGrid.minFieldWidth\](#attr-listgridminfieldwidth)).

### Groups

- treeField

**Flags**: IRW

---
## Method: Tree.removeChildren

### Description
Removes all children of the node and sets it to a loaded state. For non-\[class:ResultTree\](#class-resulttree)s, or non-\[paged\](#attr-resulttreefetchmode) `ResultTree`s, \[method:Tree.add\](#method-treeadd) or \[method:Tree.addList\](#method-treeaddlist) can then be used to provide new children. For \[paged\](#attr-resulttreefetchmode) `ResultTrees`, \[method:DataSource.updateCaches\](#method-datasourceupdatecaches) must be used to insert nodes into the cache as local data, since such `ResultTree`s are considered read-only, and \[method:Tree.add\](#method-treeadd) and \[method:Tree.addList\](#method-treeaddlist) are not perrmitted.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| node | [TreeNode](#type-treenode) | false | — | folder in question |

### Groups

- loadState

### See Also

- [Tree.getLoadState](#method-treegetloadstate)
- [Tree.reloadChildren](#method-treereloadchildren)

---
## Attr: DateChooser.baseWeekStyle

### Description
Base CSS style applied to cells in the \[fiscal week column\](#attr-datechoosershowweekchooser).

**Flags**: IRW

---
## Method: CalendarView.rebuild

### Description
Rebuild this CalendarView, including re-fetching its data as necessary. To avoid re-fetching the data, pass 'false' to this method, or call \[refreshEvents()\](#method-calendarviewrefreshevents) instead.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| refreshData | [Boolean](#type-boolean) | true | — | If false, prevents data from bing refreshed. |

---
## Method: RibbonGroup.setTitleOrientation

### Description
This method forcibly sets the \[vertical orientation\](#attr-ribbongrouptitleorientation) of this group's \[title label\](#attr-ribbongrouplabel) after initial draw.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| orientation | [VerticalAlignment](#type-verticalalignment) | false | — | the new orientation for the title, either bottom or top |

### Groups

- ribbonGroup

---
## ClassAttr: Log.DEBUG

### Description
A declared value of the enum type \[LogPriority\](#type-logpriority).

**Flags**: R

---
## Attr: FormItem.left

### Description
Left coordinate of this item in pixels. Applies only when the containing DynamicForm sets `itemLayout:"absolute"`.

**Flags**: IRWA

---
## Method: Header.setTitle

### Description
Setter for the \[title\](#attr-headertitle).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| newTitle | [HTMLString](#type-htmlstring) | false | — | the new title HTML. |

---
## Type: NullAccessType

### Description
The possible access types for records with a null \[ownerIdField\](#attr-datasourceowneridfield) (only applicable if `ownerIdField` is specified)

### Values

| Value | Description |
|-------|-------------|
| "none" | The default value, means that users have no access to records with a null `ownerIdField`. In this case, users can only see their own records (ie, those where the `ownerIdField` matches the currently authenticaed user's id) |
| "view" | Users are allowed read-only access to records with a null `ownerIdField`. In this case, users can see records with a null owner as well as their own records. |
| "edit" | Users are allowed read, update and delete access to records with a null `ownerIdField`. In this case, users can see and fully manage records with a null owner, as well as their own records. |

### See Also

- [DataSource.ownerIdField](#attr-datasourceowneridfield)
- [DataSource.ownerIdNullAccess](#attr-datasourceowneridnullaccess)
- [DataSource.ownerIdNullRole](#attr-datasourceowneridnullrole)

---
## ClassMethod: MultiWindow.minimize

### Description
Minimizes the existing window with the specified name,

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| name | [String](#type-string) | false | — | unique window name |
| callback | [RemoteWindowCallback](#type-remotewindowcallback) | true | — | callback run after \[class:RemoteWindow\](#class-remotewindow) minimized |

---
## Method: Tree.hasLeaves

### Description
Return whether this node has any children that are leaves.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| node | [TreeNode](#type-treenode) | false | — | node in question |

### Returns

`[Boolean](#type-boolean)` — true if the node has children that are leaves

---
## Attr: EditTree.canShowFilterEditor

### Description
Option to show filter editor is disabled for editTree

**Flags**: IRA

---
## ClassMethod: DataSource.addSearchOperator

### Description
Add a new search operator to all DataSources.

See also \[method:DataSource.addSearchOperator\](#method-datasourceaddsearchoperator) for adding operators to specific DataSources only.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| operator | [Operator](#type-operator) | false | — | definition of the operator to add |

### Groups

- advancedFilter

---
## StaticMethod: isA.Date

### Description
Is `object` a Date object?

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| object | [Object](#type-object) | false | — | object to test |

### Returns

`[boolean](#type-boolean)` — true == `object` is a Date

---
## ClassAttr: FacetChart.allChartTypes

### Description
All \[ChartTypes\](#type-charttype) that are supported by this class. Should be defined by concrete implementations of the charting interface.

**Flags**: R

---
## ClassMethod: XMLTools.nativeXMLAvailable

### Description
Returns true if the current browser exposes an XML parser that can be used for SmartClient XML operations like web service bindings and XML processing. See \[group:platformDependencies\](#group-platformdependencies) for more information on when the XML parser may not available and what features are impacted as a result.

### Returns

`[boolean](#type-boolean)` — true if native XML processing is available, false otherwise.

---
## Attr: Criterion.operator

### Description
Operator this criterion applies.

### Groups

- advancedFilter

**Flags**: IR

---
## Method: GridRenderer.getCellRecord

### Description
Return the record that holds the value for this cell.

Implementing `getCellRecord` is optional: the actual HTML placed into each grid cell comes from `getCellValue`, and a valid grid can be created without any notion of "records" at all.

If you do implement `getCellRecord`, the value you return is passed to you as the "record" parameter in other methods.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| rowNum | [number](#type-number) | false | — | row number for the cell |
| colNum | [number](#type-number) | false | — | column number of the cell |

### Returns

`[Object](#type-object)` — record for this cell

---
## Method: StyleSheetHandler.renameClass

### Description
Rename the passed _oldClass_ to _newClass_ in all rules that reference it.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| oldName | [String](#type-string) | false | — | name of the CSS class to rename in the stylesheet |
| newName | [String](#type-string) | false | — | new name for the CSS class |

### Returns

`[boolean](#type-boolean)` — returns true if a class was renamed, false otherwise

---
## Method: Callbacks.AsyncMultipleValuesGenerationResultCallback

### Description
Callback fired with the result of an asynchronous operation to generate multiple values.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| result | [AsyncMultipleValuesGenerationResult](#type-asyncmultiplevaluesgenerationresult) | false | — | The result. |

---
## Attr: SelectItem.filterLocally

### Description
If `filterLocally` is set for this item, and this item is showing options from a dataSource, fetch the entire set of options from the server, and use these values to map the item value to the appropriate display value. Also use `"local"` type filtering on drop down list of options.

This means data will only be fetched once from the server, and then filtered on the client.

Note - when this property is set to `false`, filtering will still be performed on the client if a complete set of data for some criteria has been cached by a fetch, and a subsequent fetch has more restrictive criteria. To explicitly disable client-side filtering set the \[attr:SelectItem.useClientFiltering\](#attr-selectitemuseclientfiltering) property to false.

### See Also

- [FormItem.filterLocally](#attr-formitemfilterlocally)

**Flags**: IRA

---
## Attr: Canvas.animateMoveAcceleration

### Description
Default acceleration effect for performing an animated move. If unset, `this.animateAcceleration` will be used by default instead

### Groups

- animation

**Flags**: IRWA

---
## Method: ListGrid.hasChanges

### Description
Whether the grid as a whole has any unsaved edits, in any row. Note that this method will return true if any rows are \[marked as removed\](#method-listgridmarkrecordremoved) in addition to any rows that have unsaved edits.

Note that if this grid is bound to a \[dataSource\](#attr-listgriddatasource), and an asynchronous save has been submitted, this method will compare the local edit values against the submitted values by default, returning false (no changes), if they match. This is useful for detecting whether the user is actively editing values and hasn't yet committed them.

The `ignorePendingValues` parameter may be used by developers who want to ignore this case and simply compare edit values against the record in the local data set.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| ignorePendingValues | [Boolean](#type-boolean) | true | — | If true, this method will compare the current edit values against the underlying records in the dataset, not taking pending edit values into account |

### Returns

`[Boolean](#type-boolean)` — returns true of any unsaved edits are present

### Groups

- editing

---
## Method: ListGrid.fetchRowCount

### Description
For databound grids, method will fall through to \[method:ResultSet.fetchRowCount\](#method-resultsetfetchrowcount), allowing developers to request an accurate row count from the dataSource when \[progressive loading is active\](#attr-datasourceprogressiveloading).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| callback | [RowCountCallback](#type-rowcountcallback) | true | — | Callback to fire when the fetch request completes. To retrieve details of the row-count that was retrieved from the server, use the `getRowCount()` and `getRowCountStatus()` methods. |
| dsRequest | [DSRequest Properties](#type-dsrequest-properties) | true | — | Custom properties for the row count fetch request |

### Groups

- rowRangeDisplay

---
## Attr: ListGridField.rotateTitle

### Description
Whether to rotate the field's title so it's rendered vertically from bottom to top. If unset, default behavior is derived from \[attr:ListGrid.rotateHeaderTitles\](#attr-listgridrotateheadertitles).

### See Also

- [ListGrid.rotateHeaderTitles](#attr-listgridrotateheadertitles)

**Flags**: IR

---
## Method: RemoteWindow.move

### Description
Moves this RemoteWindow.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| x | [number](#type-number) | false | — | desired x-offset of left edge |
| y | [number](#type-number) | false | — | desired y-offset of top edge |
| callback | [RemoteWindowCallback](#type-remotewindowcallback) | true | — | callback run after it's moved |

---
## Method: ListGrid.rowOver

### Description
Called when the mouse pointer enters a row

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| record | [ListGridRecord](#type-listgridrecord) | false | — | cell record as returned by getCellRecord |
| rowNum | [number](#type-number) | false | — | row number for the cell |
| colNum | [number](#type-number) | false | — | column number of the cell |

### Returns

`[boolean](#type-boolean)` — whether to cancel the event

### Groups

- events

---
## Method: Callbacks.LoadScreenCallback

### Description
A \[type:Callback\](#type-callback) to evaluate when a screen is loaded via \[classMethod:RPCManager.loadScreen\](#classmethod-rpcmanagerloadscreen).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| screen | [Canvas](#type-canvas) | true | — | The last top-level component loaded |
| rpcResponse | [RPCResponse](#type-rpcresponse) | true | — | — |
| suppressedGlobals | [Map](#type-map) | true | — | A collection of suppressed globals. |

---
## Method: ResultSet.transformData

### Description
`transformData()` provides an opportunity to modify data that has been returned from the server, before it has been integrated into the client-side cache.

If data is not immediately suited for client-side use when it is returned from the ultimate data store, this method allows it to be transformed on the client so that such transform operations do not impact server scalability.

It is legal for `transformData()` to modify not only the records, but also their number (by modifying startRow and endRow on the \[class:DSResponse\](#class-dsresponse) object).

See also \[method:DataSource.transformResponse\](#method-datasourcetransformresponse) for an alternative entry point which applies to all DSResponses for a DataSource.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| newData | [Any](#type-any) | false | — | data returned from the server |
| dsResponse | [DSResponse](#type-dsresponse) | false | — | the DSResponse object returned by the server |

### Returns

`[Array of Objects](#type-array-of-objects)` — the modified data, ready to be cached

---
## Attr: DataSourceField.escapeHTML

### Description
When data values are displayed in DataBound components, by default strings will be interpreted as HTML by the browser in most cases.

If set, this property will be picked up by components bound to this dataSource, notifying them that any HTML characters should be escaped when displaying values for this field.

### See Also

- [ListGridField.escapeHTML](#attr-listgridfieldescapehtml)

**Flags**: IR

---
## Attr: DrawRect.top

### Description
Top coordinate in pixels relative to the \[local coordinate system\](#class-drawpane).

**Flags**: IRW

---
## Object: AIRequest

### Description
Represents a request to AI for a response.

---
## ClassAttr: Operators.betweenInclusiveTitle

### Description
Title for the "betweenInclusive" operator

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: TextItem.textBoxStyle

### Description
Base CSS class name for this item's input element. NOTE: See the \[group:CompoundFormItem\_skinning\](#group-compoundformitem-skinning) discussion for special skinning considerations.

For a rounded text item, you can set `textBoxStyle` to "roundedTextItem". This style exists only in Enterprise, EnterpriseBlue and Graphite skins. There is no corresponding rounded style for SelectItem or ComboBoxItem as this creates an awkward seam with the pop-up list (and a rounded pop-up list wouldn't help: data could not be flush to corners). For these reasons we recommend rounded inputs only in limited cases like single standalone fields.

### Groups

- appearance

**Flags**: IRW

---
## ClassMethod: MultiWindow.getDataContext

### Description
Returns the \[object:DataContext\](#object-datacontext) provided by the \[classMethod:MultiWindow.open\](#classmethod-multiwindowopen) call that opened this window, or a newly created (on demand) \[object:DataContext\](#object-datacontext) if this is the main application window, or no DataContext was provided.

### Returns

`[DataContext](#type-datacontext)` — \[object:DataContext\](#object-datacontext) for this window

---
## StaticMethod: Date.combineLogicalDateAndTime

### Description
Combine a logical date (a value appropriate for a DataSourceField of type "date") with a logical time (a value appropriate for a DataSourceField of type "time") into a datetime value (a value appropriate for a DataSourceField of type "datetime")

This method correctly takes into account the current \[display timezone\](#classmethod-timesetdefaultdisplaytimezone), specifically, the returned datetime value will show the same date and time as the passed date and time objects when rendered by a SmartClient component that has been configured with a field of type "datetime".

For further background on date, time and datetime types, storage and transmission, see \[this overview\](#group-dateformatandstorage).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| date | [Date](#type-date) | false | — | a Date instance representing logical date value |
| time | [Date](#type-date) | false | — | a Date instance representing logical time value |

### Returns

`[Date](#type-date)` — a Date instance representing a datetime value combining the logical date and time passed

**Deprecated**

---
## Attr: Validator.errorMessage

### Description
Text to display if the value does not pass this validation check.

If unspecified, default error messages exist for all built-in validators, and a generic message will be used for a custom validator that is not passed.

Server-side this string evaluates in a Velocity context where the variables $value and $fieldName are available and refer to the supplied value and the field name, respectively. Note that if the validator is intended to run both on the client and server, you shouldn't use these velocity vars as they will not be expanded on the client and the user may then see raw uninterpolated strings.

**Flags**: IR

---
## Attr: DetailViewer.hiliteIconSize

### Description
Default width and height of \[hilite icons\](#attr-detailviewerhiliteicons) for this component. Can be overridden at the component level via explicit \[hiliteIconWidth\](#attr-detailviewerhiliteiconwidth) and \[hiliteIconHeight\](#attr-detailviewerhiliteiconheight), or at the field level via \[hiliteIconSize\](#attr-listgridfieldhiliteiconsize), \[hiliteIconWidth\](#attr-listgridfieldhiliteiconwidth) and \[hiliteIconHeight\](#attr-listgridfieldhiliteiconheight)

### Groups

- hiliting

### See Also

- [DetailViewer.hiliteIconWidth](#attr-detailviewerhiliteiconwidth)
- [DetailViewer.hiliteIconHeight](#attr-detailviewerhiliteiconheight)
- [DetailViewerField.hiliteIconSize](#attr-detailviewerfieldhiliteiconsize)

**Flags**: IRW

---
## Attr: Mail.subject

### Description
The string to appear in the subject line of the message. Like all other `String` properties of `Mail`, you can use Velocity substitution variables in this property.

If you specify a "Subject:" line in the body of your email, the subject will be parsed and this property will be ignored.

### Groups

- mail

**Flags**: IR

---
## Attr: Gauge.borderColor

### Description
Color for gauge sector borders.

### See Also

- [DrawItem.lineColor](#attr-drawitemlinecolor)

**Flags**: IR

---
## ClassMethod: Authentication.setCurrentUser

### Description
Set up the current user. This method makes the user record available in the \[attr:Canvas.ruleScope\](#attr-canvasrulescope) as "auth.currentUser".

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| user | [Record](#type-record) | false | — | Record with attributes detailing the current user |

---
## Method: ListGrid.getGroupMembers

### Description
For a \[grouped\](#attr-listgridgroupbyfield) grid, returns all the direct children of the supplied node in the \[attr:ListGrid.groupTree\](#attr-listgridgrouptree) if `recordsOnly` false. Otherwise, if `recordsOnly` is true, returns instead a list of all descendants under the supplied node that are actual records from the grid's original data - i.e. that are not other group nodes (for multi-grouping) or summary records.

Note that null may be returned if the grid is not currently grouped or the supplied node is not a valid \[object:GroupNode\](#object-groupnode).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| node | [GroupNode](#type-groupnode) | false | — | node from \[attr:ListGrid.groupTree\](#attr-listgridgrouptree) |
| recordsOnly | [boolean](#type-boolean) | false | — | `true` to return all descendants that are actual records from the grid's original data, or `false` to return all immediate children of the supplied group node |

### Returns

`[Array of ListGridRecord](#type-array-of-listgridrecord)` — records under the supplied node, as specified above, or null if we're not grouping or the node isn't a group node

### Groups

- grouping

---
## Class: TimeItem

### Description
A \[class:FormItem\](#class-formitem) for editing \[logical-time\](#classmethod-dateutilcreatelogicaltime) values, which are Date instances where only the time-portion is relevant.

The item renders with one of two appearances, depending on the value of \[attr:TimeItem.useTextField\](#attr-timeitemusetextfield) - when set to true, the default appearance, times are edited directly as text-values. In this mode, values are formatted according to \[attr:TimeItem.timeFormatter\](#attr-timeitemtimeformatter), with defaults coming from \[attr:TimeItem.timeFormatter24Hour\](#attr-timeitemtimeformatter24hour) and \[attr:TimeItem.timeFormatter12Hour\](#attr-timeitemtimeformatter12hour), depending on the value of \[use24HourTime\](#attr-timeitemuse24hourtime). See also \[classMethod:Time.setNormalDisplayFormat\](#classmethod-timesetnormaldisplayformat) for system-wide settings.

TimeItem automatically accepts both 12 and 24 hour time as well as partial times and a variety of possible time value separators. Examples:

		11:34:45 AM	=> 11:34:45
		1:3:5 AM	=> 01:30:50
		1:3p		=> 13:30:00
		11 34 am	=> 11:34:00
		11-34		=> 11:34:00
		113445		=> 11:34:45
		13445		=> 01:34:45
		1134		=> 11:34:00
		134			=> 01:34:00
 

When `useTextField` is set to false, the item provides separate pickers for \[hour\](#attr-timeitemhouritem), \[minute\](#attr-timeitemminuteitem) and \[second\](#attr-timeitemseconditem) values. By default, the pickers edit times in \[24-hour format\](#attr-timeitemuse24hourtime), meaning the `hourItem` shows values from 0-23. When \[use24HourTime\](#attr-timeitemuse24hourtime) is set to false, the `hourItem` is limited to a range of 1-12, and the \[am/pm picker\](#attr-timeitemampmitem) is displayed. Note that \[getValue()\](#method-formitemgetvalue) always returns a Date instance that represents a \[logical-time\](#classmethod-dateutilcreatelogicaltime) in 24-hour format.

Values entered by the user are stored as JavaScript `Date` objects in local time. The day, month and year values of this `Date` object are not relevant and should be ignored.

By default, when used in a \[class:SearchForm\](#class-searchform) or as a field in a \[class:ListGrid\](#class-listgrid)'s \[filter editor\](#attr-listgridshowfiltereditor), TimeItems will automatically generate AdvancedCriteria - for example, entering "11:00" into the item will generate a \[betweenInclusive\](#type-operatorid) Criterion that selects all times between 11:00:00 and 11:59:59. If the form is databound and the DataSource is marked as being \[allowAdvancedCriteria\](#attr-datasourceallowadvancedcriteria):false, the criteria generated will be simple, checking for data with logical time values equal to the displayed value.

To edit \[logical-Date values\](#classmethod-dateutilcreatelogicaldate), see \[class:DateItem\](#class-dateitem), and to edit \[datetime values\](#classmethod-dateutilcreatedatetime), see \[class:DateTimeItem\](#class-datetimeitem). For \[relative-date features\](#type-relativedatestring), see \[class:RelativeDateItem\](#class-relativedateitem).

For detailed information on working with dates, times and datetimes, see the \[Date and Time Format and Storage overview\](#group-dateformatandstorage).

---
## Attr: Canvas.shadowVOffset

### Description
Vertical offset for the \[shadow\](#attr-canvasshowshadow). Takes precedence over \[attr:Canvas.shadowOffset\](#attr-canvasshadowoffset) if set. Has no effect if \[css-shadows\](#attr-canvasusecssshadow) are not being used for this canvas.

### Groups

- shadow

**Flags**: IRWA

---
## Method: DrawImage.setRect

### Description
Updates the drawImage to match the specified coordinates and size in \[local coordinates\](#class-drawpane).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| left | [Integer](#type-integer) | false | — | new left coordinate |
| top | [Integer](#type-integer) | false | — | new top coordinate |
| width | [Integer](#type-integer) | false | — | new width |
| height | [Integer](#type-integer) | false | — | new height |

---
## Method: AIEngine.canSupportVisionRequests

### Description
Whether this AI engine can handle vision requests, or requests where one or more of the messages is an image.

### Returns

`[boolean](#type-boolean)` — `true` if this AI engine can handle vision requests; `false` otherwise.

---
## Attr: Layout.enforcePolicy

### Description
Whether the layout policy is continuously enforced as new members are added or removed and as members are resized.

This setting implies that any member that resizes larger, or any added member, will take space from other members in order to allow the overall layout to stay the same size.

### Groups

- layoutPolicy

**Flags**: IRWA

---
## Attr: DSRequest.oldValues

### Description
For an `update` or `remove` operation, the original values from the record that is being updated or removed. `oldValues` is automatically added to DSRequests submitted by DataBound Components. Available on the server via `DSRequest.getOldValues()`.

The server can compare the `oldValues` to the most recent stored values in order to detect that the user was looking at stale values when the user submitted changes (NOTE: this means of detecting concurrent edit is sometimes called "optimistic concurrency" or "long transactions").

In applications where a policy of "last update wins" is not appropriate when updating certain fields, special UI can be shown for this case. For example, on detecting concurrent edit, the server may send back a special `dsResponse.status` code that the client application detects, offering the user a choice of proceeding with the operation, discarding edits, or reconciling new and old values in a special interface.

See the \[group:concurrentEdits\](#group-concurrentedits) overview for more on handling concurrent edits in SmartClient DataSources.

**Flags**: IR

---
## Attr: Tour.tourCompleteTitle

### Description
Title for the _Tour Complete_ dialog displayed after recording a Tour.

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: Flashlet.params

### Description
A map of key/value pairs to pass to the flashlet as parameters. Note that these will be set on the outer <object> element as well as the inner <embed> element.

**Flags**: IR

---
## Attr: DrawItem.fillOpacity

### Description
Opacity of the fillColor, as a number between 0 (transparent) and 1 (opaque).

### Groups

- fill

**Flags**: IRW

---
## Method: FormItem.hide

### Description
Hide this form item.  
  
This will cause the form to redraw. If this item had an item.showIf expression, it will be destroyed.

---
## Attr: ListGridField.filterEditorType

### Description
If this ListGrid is showing a filter row, this property can be used to specify the form item class to use for the filter form item associated with this field (Only used if this field is not canFilter:false).  
Note: If this is not specified, the edit-form item type may be derived from the 'editorType' property, typically inherited from datasource fields, or from the 'type' of the field (showing the appropriate form item for the data-type).

### Groups

- filterEditor

**Flags**: IRWA

---
## Attr: ListGrid.booleanTrueImage

### Description
Image to display for a true value in a boolean field. The special value "blank" means that no image will be shown.

To turn this off explicitly set \[attr:ListGridField.suppressValueIcon\](#attr-listgridfieldsuppressvalueicon) to true.

If this, \[attr:ListGrid.booleanFalseImage\](#attr-listgridbooleanfalseimage) and \[attr:ListGrid.booleanPartialImage\](#attr-listgridbooleanpartialimage) are unset, this will be set to the default \[attr:CheckboxItem.checkedImage\](#attr-checkboxitemcheckedimage).

\[Spriting\](#group-skinning) can be used for this image, by setting this property to a \[type:SCSpriteConfig\](#type-scspriteconfig) formatted string. Alternatively developers can omit this property and instead use CSS directly in the \[attr:ListGrid.booleanBaseStyle\](#attr-listgridbooleanbasestyle) property to provide a "boolean true" appearance.

### Groups

- imageColumns

### See Also

- [ListGrid.booleanFalseImage](#attr-listgridbooleanfalseimage)
- [ListGrid.booleanPartialImage](#attr-listgridbooleanpartialimage)
- [ListGrid.printBooleanTrueImage](#attr-listgridprintbooleantrueimage)

**Flags**: IRWA

---
## Attr: Calendar.eventDragGap

### Description
The number of pixels to leave to the right of events so overlapping events can still be added using the mouse.

**Flags**: IRW

---
## ClassAttr: Dialog.Ask

### Description
A singleton Dialog instance that will be shown in response to a \[staticMethod:isc.askForValue\](#staticmethod-iscaskforvalue) call. Notes:  
Because this is a singleton object, properties set on the Ask object directly will persist each time it is shown.  
Developers should use the `askForValue()` method to show this object rather than manipulating the Dialog directly.

### Groups

- Prompting

### See Also

- [isc.askForValue](#staticmethod-iscaskforvalue)

**Flags**: A

---
## Attr: DetailViewerEditProxy.dataEscapeChar

### Description
If \[inline editing\](#attr-editproxyinlineeditevent) for this viewer edits the \[attr:DetailViewer.data\](#attr-detailviewerdata), character that can be used to enter literal separator chars (such as the \[dataSeparatorChar\](#attr-detailviewereditproxydataseparatorchar)) or literal leading or trailing whitespace.

Repeat this character twice to enter it literally. For example, with the default of "\\", inputting "\\\\" would result in a literal backslash in the value.

**Flags**: IR

---
## ClassMethod: RPCManager.getTransactionDescription

### Description
Returns a brief description of the transaction in the following format for logging purposes: `"Transaction with _n_ operation(s). [dsName1.operationType; dsName2.operationType; ...]"`

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| transactionNum | [Integer](#type-integer) | false | — | The number of the transaction to return timing data for |

### Returns

`[String](#type-string)` — transaction description

---
## Method: ColumnTree.nodeSelected

### Description
Called when a node is selected in any column. Default behavior is to show the next level of the tree in a column to the right of the current column.

The new column will be created if it is not already showing. Any columns further to the right, showing deeper levels of the tree, will be removed.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| column | [ListGrid](#type-listgrid) | false | — | the column where a node was selected |
| node | [TreeNode](#type-treenode) | false | — | the node that was selected |

### Returns

`[boolean](#type-boolean)` — override and return false to cancel the default action

---
## Method: DataSource.updateData

### Description
Perform an "update" DataSource operation against this DataSource, to update values in an existing DataSource record.

If a callback was provided, it will be invoked when the operation completes successfully. If the operation fails, the callback will not be invoked unless \[DSRequest.willHandleError\](#attr-rpcrequestwillhandleerror) is true. See the \[error handling overview\](#group-errorhandling) for more information.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| updatedRecord | [Record Properties](#type-record-properties) | false | — | updated record |
| callback | [DSCallback](#type-dscallback) | true | — | callback to invoke on completion |
| requestProperties | [DSRequest Properties](#type-dsrequest-properties) | true | — | additional properties to set on the DSRequest that will be issued |

### Groups

- operations

---
## Method: TabSet.getTabObject

### Description
Get the tab Object originally passed to \[attr:TabSet.tabs\](#attr-tabsettabs), by index, name or ID. If passed a tab Object, just returns it.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| tab | [int](#type-int)|[GlobalId](#type-globalid)|[TabName](#type-tabname)|[Tab](#type-tab) | false | — | — |

### Returns

`[Tab](#type-tab)` — the tab, or null if not found

---
## Method: ListGrid.setAutoFitFieldWidths

### Description
Setter for \[attr:ListGrid.autoFitFieldWidths\](#attr-listgridautofitfieldwidths). Modifies the default auto-fit-width behavior for fields in this grid. Note that this may be overridden at the field level via \[attr:ListGridField.autoFitWidth\](#attr-listgridfieldautofitwidth).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| autoFit | [boolean](#type-boolean) | false | — | New value for autoFitFieldWidths |
| dontResetWidths | [boolean](#type-boolean) | true | — | If autoFitFieldWidths was true, and is being set to false, should fields be resized to their originally specified size? Pass in this parameter to suppress this behavior. |

---
## Method: FormItem.getFieldName

### Description
Return the name for the this formItem.

### Returns

`[String](#type-string)` — name for this form item

### Groups

- drawing

**Flags**: A

---
## Attr: MultiPickerItem.cascadeSelection

### Description
For multiPickerItems with \[selectionStyle:"pickTree"\](#type-selectionstyle), and \[canSelectFolders:true\](#attr-multipickeritemcanselectfolders), should \[attr:TreeGrid.cascadeSelection\](#attr-treegridcascadeselection) be enabled on our pickTree?

**Flags**: IR

---
## ClassAttr: Selection.NONE

### Description
A declared value of the enum type \[SelectionStyle\](#type-selectionstyle).

**Flags**: R

---
## Attr: NavigationBar.rightButtonTitle

### Description
\[Title\](#attr-buttontitle) for the \[rightButton\](#attr-navigationbarrightbutton).

**Flags**: IRW

---
## Method: ListGrid.showRecordComponent

### Description
When \[attr:ListGrid.showRecordComponents\](#attr-listgridshowrecordcomponents) is true, return false from this method to prevent the recordComponent system from processing the passed record or cell.

#### If \[showRecordComponentsByCell\](#attr-listgridshowrecordcomponentsbycell) is true, it is important to implement this method
 - especially if the grid has many fields - otherwise, the internal automatic detection will process every visible cell, checking, for example, whether a component already exists for that cell, before eventually running \[method:ListGrid.createRecordComponent\](#method-listgridcreaterecordcomponent) to check if one is required. Implementing this method avoids all that processing for cells that aren't expected to have components.

The second parameter is only applicable if \[attr:ListGrid.showRecordComponentsByCell\](#attr-listgridshowrecordcomponentsbycell) is true.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| record | [ListGridRecord](#type-listgridrecord) | false | — | record being processed |
| colNum | [Integer](#type-integer) | true | — | column index of the cell in which the record component may be shown. Will be null unless showRecordComponentsByCell is true. |

### Returns

`[boolean](#type-boolean)` — return false to cancel showRecordComponent behavior

### Groups

- recordComponents

---
## Attr: ListGrid.reselectOnUpdate

### Description
If true, when an update operation occurs on a selected record in a \[databound\](#attr-listgriddatasource) listGrid, ensure the updated record is re-selected when the operation completes. The \[attr:ListGrid.reselectOnUpdateNotifications\](#attr-listgridreselectonupdatenotifications) attributes governs whether \[method:ListGrid.selectionUpdated\](#method-listgridselectionupdated) and \[method:ListGrid.selectionChanged\](#method-listgridselectionchanged) will fire when this occurs.

**Flags**: IRA

---
## Attr: EditNode.editProxyProperties

### Description
Properties to be applied to the \[liveObject\](#attr-editnodeliveobject).\[editProxy\](#attr-canvaseditproxy) when created.

Note that the `editProxy` is created the first time a component is placed into editMode, so any `editProxyProperties` must be set before then.

**Flags**: IR

---
## Method: Portlet.getPortalPosition

### Description
Gets the position of the Portlet within its \[class:PortalLayout\](#class-portallayout). Returns null if the Portlet is not in a PortalLayout.

### Returns

`[PortalPosition](#type-portalposition)` — the position of the Portlet

---
## Attr: Canvas.useOpacityFilter

### Description
Configures where the Opacity filter is used for IE6-8.

With the default of null, opacity filters are used unless \[classAttr:Canvas.neverUseFilters\](#classattr-canvasneverusefilters) has been set. When set explicitly to true, opacity filters are used even if `neverUseFilters` is true.

See \[group:IEFilters\](#group-iefilters) for background.

### Groups

- IEFilters

**Flags**: IR

---
## Attr: Canvas.hoverDelay

### Description
If `this.canHover` is true, how long should the mouse be kept over this widget before the hover event is fired

### Groups

- hovers

### See Also

- [Canvas.canHover](#attr-canvascanhover)
- [Canvas.hover](#method-canvashover)

**Flags**: IRW

---
## Class: ScreenLoader

### Description
The ScreenLoader component can be used to load \[ComponentXML Screens\](#group-componentxml) into a running application.

A ScreenLoader is a VLayout, and can be provided anywhere a Canvas can be used: as a Tab pane, and Layout member, etc. When a ScreenLoader draws, it shows a \[loading message\](#attr-screenloaderloadingmessage) if \[enabled\](#attr-screenloadershowloadingmessage), performs an RPC to the \[screenLoaderURL\](#classattr-rpcmanagerscreenloaderurl) to load the screen, if necessary, and finally embeds the \[screen\](#attr-screenloaderscreenname) within the layout.

The last top-level UI component (Canvas subclass) defined by the screen is set as the layout contents. Top-level in this case means that the UI component is not contained in another UI component as a member or child.

The ScreenLoader relies on the XMLHttpRequest object which can be disabled by end-users in some supported browsers. See \[group:platformDependencies\](#group-platformdependencies) for more information.

---
## Method: ListGrid.hideFields

### Description
Force an array of fields to be hidden.

NOTE: If a field.showIf expression exists, it will be destroyed.

When hiding multiple fields, this method should be called rather than calling \[method:ListGrid.hideField\](#method-listgridhidefield) repeatedly for each field to hide.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| fields | [Array of String](#type-array-of-string)|[Array of ListGridField](#type-array-of-listgridfield) | false | — | fields to hide |
| suppressRelayout | [boolean](#type-boolean) | true | — | if passed, don't relayout non-explicit sized fields to fit the available space |

---
## Attr: Slider.labelWidth

### Description
The width of the labels used to display the minimum, maximum and current values of the slider.

**Flags**: IRW

---
## ClassAttr: AsyncUtil.asyncCanceledMessage

### Description
A message string to use when displaying an \[object:AsyncOperationResult\](#object-asyncoperationresult) of \[type\](#attr-asyncoperationresulttype) "canceled" to the user, and a \[attr:AsyncOperationResult.cancellationReason\](#attr-asyncoperationresultcancellationreason) is available.

\[classAttr:AsyncUtil.asyncCanceledMessageGeneric\](#classattr-asyncutilasynccanceledmessagegeneric) is used when no cancellationReason is available.

### Groups

- i18nMessages

### See Also

- [AsyncUtil.getAsyncMessage](#classmethod-asyncutilgetasyncmessage)

**Flags**: RW

---
## Method: Canvas.enclosesRect

### Description
Returns true if the rectangle of this widget encloses the rectangle coordinates passed in, and false otherwise.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| left | [number](#type-number)|[Array of number](#type-array-of-number) | false | — | left coord of rect (or rect array) |
| top | [number](#type-number) | false | — | top coord of rect |
| width | [number](#type-number) | false | — | width of rect |
| height | [number](#type-number) | false | — | height of rect |

### Returns

`[boolean](#type-boolean)` — true if this canvas encloses the rectangle passed in; false otherwise

### Groups

- positioning

---
## Attr: LoadProjectSettings.verifyComponents

### Description
Enables verification that any screen \[created\](#attr-loadprojectsettingsdrawfirstscreen) on load contains a component having a `localId` equal to the given key, and that it is an instance (or subclass) of the key's value. Example:

   {'customerListGrid': 'ListGrid'}
 

You may verify the presence of Tabs, SectionStackSections, and FormItems by providing their names following the parent component's id in dot-separated notation. Example:

   {
     'mainTabSet.customersTab': 'ImgTab',
     'mainSectionStack.customerStackSection': 'SectionStackSection',
     'customerDetailsForm.customerNameItem': 'TextItem'
   }
 

Findings are always reported to the console, and may also be presented to the user with a warning dialog by setting \[attr:LoadProjectSettings.verifyAsError\](#attr-loadprojectsettingsverifyaserror) or \[classAttr:RPCManager.verifyAsError\](#classattr-rpcmanagerverifyaserror).

### See Also

- [LoadProjectSettings.verifyDataSources](#attr-loadprojectsettingsverifydatasources)
- [RPCManager.loadProject](#classmethod-rpcmanagerloadproject)

**Flags**: IR

---
## Attr: BuildViaAIProgressDialog.title

### Description
Title for this Window, shown if \[showTitle\](#attr-windowshowtitle) is true in the \[header\](#attr-windowheader) (if drawn).

### Groups

- i18nMessages

**Flags**: IRW

---
## ClassMethod: Media.getIconSet

### Description
Retrieves an \[object:IconSet\](#object-iconset) that was previously registered with \[addIconSet()\](#classmethod-mediaaddiconset) or passed to \[useMedia()\](#classmethod-mediausemedia).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| iconSet | [String](#type-string)|[IconSet](#type-iconset) | false | — | an \[object:IconSet\](#object-iconset) or its \[name\](#attr-iconsetname) |

### Groups

- stockIcons
- media

---
## Attr: PickList.pickListWidth

### Description
Default width to show the pickList. If not specified, the width of this form item's element will be used instead.

Note that this is a minimum value - by default if the values displayed in this pickList are wider than the specified width the list will expand to accommodate them.

### Groups

- pickList

**Flags**: IRW

---
## Method: StatefulCanvas.getAriaStateDefaults

### Description
Retrieves dynamically calculated default \[ARIA state mapping\](#attr-canvasariastate) properties for this canvas. These will be combined with explicitly specified aria state as described in \[method:Canvas.getAriaState\](#method-canvasgetariastate).

Overridden by StatefulCanvas to pick up \[aria-label\](#method-statefulcanvasgetarialabel).

### Returns

`[Object](#type-object)` — dynamically calculated default aria state properties

**Flags**: A

---
## Method: FormItem.getValueIcon

### Description
Except when \[printing\](#group-printing) and \[getPrintValueIcon()\](#method-formitemgetprintvalueicon) is implemented, implementing this stringMethod allows the developer to specify the image source for an icon to be displayed for the current form item value.

The special value "blank" means that no image will be displayed. This is typically used in conjunction with \[method:FormItem.getValueIconStyle\](#method-formitemgetvalueiconstyle) to implement spriting of the value icon. Note that when spriting the value icon, it is recommended to implement `getPrintValueIcon()` and \[getPrintValueIconStyle()\](#method-formitemgetprintvalueiconstyle) when printing.

Takes precedence over \[attr:FormItem.valueIcons\](#attr-formitemvalueicons)

The returned \[type:SCImgURL\](#type-scimgurl), if not `null` or "blank", will be suffixed with \[FormItem.imageURLSuffix\](#attr-formitemimageurlsuffix).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| value | [Any](#type-any) | false | — | value of the item. |

### Returns

`[SCImgURL](#type-scimgurl)` — the image source or `null` if no value icon should be displayed.

### Groups

- valueIcons

### See Also

- [FormItem.getPrintValueIcon](#method-formitemgetprintvalueicon)

---
## Attr: OperationBinding.description

### Description
An optional description of the operationBinding's behavior. Not automatically exposed on any component, but useful for developer documentation, and as such is included on any \[OpenAPI specification\](#group-openapisupport) generated by the framework. Markdown is a commonly used syntax, but you may also embed HTML content in a CDATA tag.

**Flags**: IR

---
## Method: DrawGroup.scaleTo

### Description
Scale the each item in the drawGroup by the x, y multipliers

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| x | [float](#type-float) | false | — | scale in the x direction |
| y | [float](#type-float) | false | — | scale in the y direction |

---
## Attr: DrawLinePath.startTop

### Description
Starting top coordinate of the line. Overrides top coordinate of \[attr:DrawLinePath.startPoint\](#attr-drawlinepathstartpoint) if both are set.

**Flags**: IR

---
## Method: HiliteEditor.saveHilites

### Description
Save the set of Hilites and fire the \[callback\](#attr-hiliteeditorcallback).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| callback | [Callback](#type-callback) | false | — | the function to call when saving is complete |

---
## Attr: AIRequest.responseType

### Description
The type of content expected from AI.

If this type is "number", then the response from AI is constrained by \[attr:AIRequest.responseMinimum\](#attr-airequestresponseminimum) and \[attr:AIRequest.responseMaximum\](#attr-airequestresponsemaximum).

**Flags**: IR

---
## ClassAttr: Dialog.YES_BUTTON_TITLE

### Description
Title for the `"Yes"` button.

### Groups

- i18nMessages

### See Also

- [DialogButtons](#type-dialogbuttons)

**Flags**: IRW

---
## Attr: ComponentTask.unsupportedComponentMessage

### Description
The default message to be reported with \[getInvalidTaskMessage()\](#method-processelementgetinvalidtaskmessage) when a target component type is not supported for the task.

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Canvas.ABSOLUTE

### Description
A declared value of the enum type \[Positioning\](#type-positioning).

**Flags**: R

---
## Type: AutoFitEvent

### Description
Event on a listGrid header to trigger auto-fit of the listgrid field.

### Values

| Value | Description |
|-------|-------------|
| "doubleClick" | React to a double click on the listGrid header. |
| "click" | React to a click on the listGrid header. |
| "none" | No event will trigger auto-fit. |

### Groups

- autoFitFields

---
## ClassMethod: DateUtil.setDefaultDateSeparator

### Description
Sets a new default separator that will be used when formatting dates. By default, this is a forward slash character: "/"

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| separator | [String](#type-string) | false | — | separator to use in dates |

### Groups

- dateFormatting

---
## ClassMethod: DateUtil.format

### Description
Return the parameter date formatted according to the parameter \[type:FormatString\](#type-formatstring). This method is used to implement the \[DataSourceField.format\](#attr-datasourcefieldformat) functionality, but it can also be used to format arbitrary dates programmatically.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| date | [Date](#type-date) | false | — | The date to format |
| format | [FormatString](#type-formatstring) | false | — | The format to apply to this date |

### Returns

`[String](#type-string)` — formatted date string

### Groups

- dateFormatting

---
## Attr: Calendar.startDate

### Description
The start date of the calendar \[timeline view\](#class-timeline). Has no effect in other views. If not specified, defaults to a timeline starting from the beginning of the current \[timelineGranularity\](#attr-calendartimelinegranularity) and spanning \[a default of 20\](#attr-calendardefaulttimelinecolumnspan) columns of that granularity.

To set different start and \[end\](#attr-calendarenddate) dates after initial draw, see \[setTimelineRange\](#method-calendarsettimelinerange).

Note that the value you provide may be automatically altered if showing \[header-levels\](#attr-calendarheaderlevels), to fit to header boundaries.

**Flags**: IR

---
## Attr: Layout.layoutRightMargin

### Description
Space outside of all members, on the right-hand side. Defaults to \[attr:Layout.layoutMargin\](#attr-layoutlayoutmargin).

Requires a manual call to `setLayoutMargin()` if changed on the fly.

### Groups

- layoutMargin

**Flags**: IRW

---
## Method: FilterClause.getCriterion

### Description
Return the criterion specified by this FilterClause.

### Returns

`[Criteria](#type-criteria)` — The single criterion for this FilterClause

---
## Method: ListGrid.sorterClick

### Description
Notification method fired when the user clicks on the corner \[sort button\](#attr-listgridsorterconstructor). Return false to suppress the sort.

### Returns

`[boolean](#type-boolean)` — return false to suppress the sort

### Groups

- events
- sorting

**Flags**: A

---
## Type: PickListItemIconPlacement

### Description
For PickList items with \[type:PickListItemIconPlacement\](#type-picklistitemiconplacement) set such that the pickList does not render near-origin, possible location for rendering formItemIcons.

### Values

| Value | Description |
|-------|-------------|
| "pickerNavigationBar" | icon will be displayed in the \[pickerNavigationBar\](#attr-comboboxitempickernavigationbar) only (and not rendered inline within the formItem itself) |
| "formItem" | icon will be displayed inline within the form item itself (and not within the \[pickerNavigationBar\](#attr-comboboxitempickernavigationbar) |
| "both" | icon will be displayed both inline (within the form item itself) and within the \[pickerNavigationBar\](#attr-comboboxitempickernavigationbar) |

---
## Attr: ComboBoxItem.filterLocally

### Description
If `filterLocally` is set for this item, and this item is showing options from a dataSource, fetch the entire set of options from the server, and use these values to map the item value to the appropriate display value. Also use `"local"` type filtering on drop down list of options.

This means data will only be fetched once from the server, and then filtered on the client.

Note - when this property is set to `false`, filtering will still be performed on the client if a complete set of data for some criteria has been cached by a fetch, and a subsequent fetch has more restrictive criteria. To explicitly disable client-side filtering set the \[attr:ComboBoxItem.useClientFiltering\](#attr-comboboxitemuseclientfiltering) property to false.

### See Also

- [FormItem.filterLocally](#attr-formitemfilterlocally)

**Flags**: IRA

---
## Attr: FormItem.pickerIconPrompt

### Description
Prompt to show when the user hovers the mouse over the picker icon.

### Groups

- pickerIcon
- i18nMessages

**Flags**: IR

---
## Attr: ListGrid.editFailedBaseStyle

### Description
A base name for the CSS class applied to cells when editing has failed.  
If this listGrid is editable, this style will be applied to any edited cells for which validation failed.  
As with the default 'baseStyle' property, this style will have "Dark", "Over", "Selected", or "Disabled" appended to it according to the state of the cell.  
If null, cells for which editing has failed will be rendered using the normal base style classNames, but with custom CSSText applied as derived from `this.editFailedCSSText`

### Groups

- appearance

### See Also

- [ListGrid.baseStyle](#attr-listgridbasestyle)
- [ListGrid.editFailedCSSText](#attr-listgrideditfailedcsstext)

**Flags**: IRWA

---
## Attr: CheckboxItem.checkedDescription

### Description
The description shown in a hover when \[attr:FormItem.showOldValueInHover\](#attr-formitemshowoldvalueinhover) is enabled and a value represents the checked state.

### Groups

- i18nMessages

**Flags**: IRA

---
## Attr: Menu.submenuFieldDefaults

### Description
Default properties for the automatically generated submenu column. Default object includes properties to set width, align and to show submenu icon for this column.

To modify the behavior or appearance of this column, developers may set \[attr:Menu.submenuFieldProperties\](#attr-menusubmenufieldproperties) at the instance level, or override this object at the class level. If overriding this object, we recommend using \[classMethod:Class.changeDefaults\](#classmethod-classchangedefaults) rather than replacing this object entirely.

See \[attr:Menu.showSubmenus\](#attr-menushowsubmenus) for an overview of the submenu column.

**Flags**: IR

---
## Attr: FormSaveDataTask.clearAfterSave

### Description
The form will be \[cleared\](#method-dynamicformclearvalues) after a successful save unless this property is set to `false`.

**Flags**: IR

---
## Method: Dialog.closeClick

### Description
Handles a click on the close button of this window. The default implementation calls \[close()\](#method-windowclose) and returns false to prevent bubbling of the click event.

Override this method if you want other actions to be taken. Custom implementations may call `close()` to trigger the default behavior.

### Returns

`[Boolean](#type-boolean)` — Return false to cancel bubbling the click event

### Groups

- buttons

---
## Type: MessagePriority

### Description
A positive integer representing the priority of a message. Lower numerical values have higher priority.

### See Also

- [NotifySettings.messagePriority](#attr-notifysettingsmessagepriority)

---
## Attr: LoginDialog.passwordItemTitle

### Description
Specifies the title of the "passwordItem" field of the \[attr:LoginDialog.loginForm\](#attr-logindialogloginform).

**Flags**: IR

---
## Attr: TileRecord.tileProperties

### Description
Additional properties to be passed when creating a tile for this record.

**Flags**: IRW

---
## Method: DataSource.getDataProtocol

### Description
Returns the appropriate \[attr:OperationBinding.dataProtocol\](#attr-operationbindingdataprotocol) for a \[object:DSRequest\](#object-dsrequest)

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| dsRequest | [DSRequest](#type-dsrequest) | false | — | DataSource Request object |

### Returns

`[DSProtocol](#type-dsprotocol)` — DataProtocol to be used for this request operation.

**Flags**: A

---
## Attr: Window.headerBackground

### Description
Img background component for the header, for gradient or image-based display

**Flags**: R

---
## Method: FilterBuilder.addCriterion

### Description
Add a new criterion, including recursively adding sub-criteria for a criterion that contains other criteria.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| criterion | [Criterion](#type-criterion) | false | — | new criterion to be added |

---
## Attr: ListGrid.autoFitMaxHeight

### Description
If \[attr:ListGrid.autoFitData\](#attr-listgridautofitdata) is set to `"vertical"` or `"both"` this property provides an upper limit on how far the ListGrid will expand vertically to accommodate its content. If content exceeds this height, scrollbars will be introduced as usual. In addition to this property, \[attr:ListGrid.autoFitMaxRecords\](#attr-listgridautofitmaxrecords) allows you to limit vertical expansion based on the number of rows to be rendered.

Note: Unlike \[attr:ListGrid.autoFitMaxWidth\](#attr-listgridautofitmaxwidth), this property cannot be set to a string percentage value; it must be a numeric pixel value or `null`.

### Groups

- autoFitData

**Flags**: IRW

---
## Method: RemoteWindow.resize

### Description
Resizes this RemoteWindow.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| width | [number](#type-number) | false | — | desired new width |
| height | [number](#type-number) | false | — | desired new height |
| callback | [RemoteWindowCallback](#type-remotewindowcallback) | true | — | callback run after it's resized |

---
## Method: DynamicForm.setAction

### Description
Sets the \[action\](#attr-dynamicformaction) for this form.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| action | [URL](#type-url) | false | — | New action URL |

---
## Attr: TableView.infoField

### Description
Field to display as part of individual record in "summary" \[type:RecordLayout\](#type-recordlayout)s.

### See Also

- [RecordLayout](#type-recordlayout)

**Flags**: IRW

---
## Attr: AdvancedCriterionSubquery.queryFK

### Description
The default for a subquery is that the records are joined to the main DataSource on the first \[foreignKey\](#attr-datasourcefieldforeignkey) one-to-many relationship found, in field order. So for example, querying `Customer`s with a subquery on `Order`s, we discover `Order.customerId` FK pointing to `Customer.id`. More complicated relations are also auto-discovered: for example, querying `Customer`s with a subquery on `OrderLine`s, we will discover the link to `Customer` via `OrderLine.orderNumber` and then `Order.customerId`.

For many use cases, there is only one relation between any two DataSources, so this default discovery of the relation is often sufficient. However, if you need to, you can optionally specify a `queryFK` as the fieldName of a `foreignKey` from the "many" to the "one". If the relation is indirect - as with the join from `OrderLine` to `Customer` described above - you can specify `queryFK` as a dot-separated path from "many" to "one", like this: `queryFK: "orderNumber.customerId"` (but note that this is optional - often, a start point is all that is required to identify the relation-path to use)

#### NOTE:
The `queryFK` property leverages the \[includeVia\](#attr-datasourcefieldincludevia) feature, and so is constrained by the same restrictions as that feature. Primarily, this means that `queryFK` can only name a `foreignKey` field on the \[subquery dataSouce\](#attr-advancedcriterionsubquerydatasource); it is not valid to name a field on the main dataSource. In practice, this is not usually a restriction because typically the subquery dataSource will be at the "many" end of a direct or indirect relation to the main dataSource, and so is naturally the one that declares the `foreignKey`

You can also specify the special value "\*none\*" for `queryFK`, which means the aggregation query should be done independently from the main query, to simply produce a value separately without any joins to the main dataset. A subquery that specifies `queryFK: "*none*"` is quite unusual because most use cases of subqueries require a join to the parent dataSource; however, valid use cases do exist - see the "Simple valueQuery" example on the \[subquery overview page\](#object-advancedcriterionsubquery)

### Groups

- advancedFilter

**Flags**: IR

---
## Method: PortalLayout.setShowColumnMenus

### Description
Sets \[attr:PortalLayout.showColumnMenus\](#attr-portallayoutshowcolumnmenus) and updates existing columns to reflect the new setting.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| showMenus | [boolean](#type-boolean) | false | — | Whether to show column menus |

---
## Method: TimeItem.getDuration

### Description
When \[useTextField\](#attr-timeitemusetextfield) is set to false, this method returns the value of the time expressed as a duration in the \[timeUnit\](#type-timeunit) provided. If no timeUnit is passed, the default is the smallest unit for which a picker is visible.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| timeUnit | [TimeUnit](#type-timeunit) | true | — | the unit of the return value |

### Returns

`[int](#type-int)` — the item's value, expressed as a duration in the TimeUnit passed

**Flags**: A

---
## Attr: ListGrid.hilites

### Description
Hilites to be applied to the data for this grid. See \[group:hiliting\](#group-hiliting).

It is undefined behavior to share the same record objects, or the same \[class:ResultSet\](#class-resultset) instances, among multiple grids if one of the grid's fields specifies a \[userFormula\](#attr-listgridfielduserformula), \[userSummary\](#attr-listgridfieldusersummary), \[aiFieldPrompt\](#attr-listgridfieldaifieldprompt), or \[aiHoverRequest\](#attr-listgridfieldaihoverrequest), or if one of the grids has a \[object:Hilite\](#object-hilite) with an asynchronous filter in the hilite's \[criteria\](#attr-hilitecriteria).

### Groups

- hiliting

**Flags**: IRW

---
## Method: CubeGrid.recordHasChanges

### Description
If this cubeGrid can be edited, this method will return true if the record passed in has been edited, but the edits have not yet been saved to the CubeGrid's data object.

Note that if this grid is bound to a \[dataSource\](#attr-listgriddatasource), and an asynchronous save has been submitted, this method will compare the local edit values against the submitted values by default, returning false (no changes), if they match. This is useful for detecting whether the user is actively editing values and hasn't yet committed them.

The `ignorePendingValues` parameter may be used by developers who want to ignore this case and simply compare edit values against the record in the local data set.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| rowNum | [number](#type-number) | false | — | row index of record to check for changes |
| colNum | [number](#type-number) | false | — | column index of the record to check for changes |
| ignorePendingValues | [Boolean](#type-boolean) | true | — | If true, this method will compare the current edit values against the underlying records in the dataset, not taking pending edit values into account |

### Returns

`[Boolean](#type-boolean)` — true if the record has been edited but not yet saved

### Groups

- editing

---
## Attr: DataBoundComponent.hiliteState

### Description
Initial hilite state for the grid.

\[attr:ListGrid.viewState\](#attr-listgridviewstate) can be used to initialize all view properties of the grid. When doing so, `hiliteState` is not needed because `viewState` includes it as well. If both are provided, `hiliteState` has priority for hilite state.

To retrieve current state call \[getHiliteState\](#method-databoundcomponentgethilitestate).

### Groups

- viewState

**Flags**: IRW

---
## Attr: Calendar.allowLongEvents

### Description
When set to true, provides an intuitive way for users to view and interact with multi-day events, or events marked as lasting \[all day\](#attr-calendaralldayfield). If you've seen the calendars provided by Google, Apple or Microsoft, you'll already be familiar with the approach.

In vertical views, long-events are displayed in a \[horizontal area\](#attr-calendarviewlongeventslayout) across the top of the main grid. In the \[MonthView\](#attr-calendarmonthview), each week of date-cells has its own area for displaying long-events, which may wrap from one week to the next. You can click or drag in this area to create new events, and click or drag existing events there to edit or move them, respectively. The style of this area may be \[customized\](#attr-calendarlongeventlayoutstylename).

Long events are rendered using a subclass of \[EventCanvas\](#class-eventcanvas), with custom \[content\](#method-calendargetlongeventhtml), \[hover-content\](#method-calendargetlongeventhoverhtml) and \[styling\](#attr-calendarlongeventstylename).

**Flags**: RWA

---
## Method: Selection.isSelected

### Description
Return true if a particular item is selected

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| item | [Object](#type-object) | false | — | object to check |

### Returns

`[boolean](#type-boolean)` — true == object is selected, false == object is not selected

### Groups

- selection

---
## Method: Calendar.getLongEventLayoutHoverHTML

### Description
Returns the text to be displayed in a \[hover\](#attr-canvasshowhover) when the mouse is held over the \[separate layout\](#attr-calendarviewlongeventslayout) where \[long-events\](#method-calendarislongevent) are displayed.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| layout | [Canvas](#type-canvas) | false | — | the longEventsLayout over which the mouse is hovered |
| view | [CalendarView](#type-calendarview) | true | — | the view in which the event is being rendered |

### Returns

`[HTMLString](#type-htmlstring)` — the HTML to display in the hover for this longEventsLayout

---
## Attr: Scrollbar.trackStartImg

### Description
The StretchItem for the start of a scrollbar track. The default is: `{ name:"track_start", width:"trackStartSize", height:"trackStartSize" }`

**Flags**: IR

---
## Attr: MinimalScrollbar.autoShow

### Description
Should this scrollbar automatically show itself when the scroll position / size changes and hide itself after a \[delay\](#attr-minimalscrollbarautohidedelay) when left untouched?

**Flags**: IRW

---
## Type: SelectionAppearance

### Description
How data selection should be presented to the user.

### Values

| Value | Description |
|-------|-------------|
| "rowStyle" | selected rows should be shown with different appearance - see \[method:ListGrid.getCellStyle\](#method-listgridgetcellstyle) and optionally \[attr:ListGrid.selectionCanvas\](#attr-listgridselectioncanvas). |
| "checkbox" | an extra, non-data column should be automatically added to the ListGrid, showing checkboxes that can be toggled to select rows. See \[method:ListGrid.getCheckboxField\](#method-listgridgetcheckboxfield). |

---
## Attr: ListGridField.sortByDisplayField

### Description
For a field with \[attr:ListGridField.displayField\](#attr-listgridfielddisplayfield) configured, should client-side sorting be performed on the display field value? Unless explicitly set to `false`, the display field value is used.

### Groups

- display_values

**Flags**: IRW

---
## Attr: RangeSlider.minValue

### Description
Set the minimum value (left/top of slider).

**Flags**: IRW

---
## Attr: ListGrid.errorIconWidth

### Description
Height of the error icon, if we're showing icons when validation errors occur.

### Groups

- errorIcon

**Flags**: IRW

---
## Attr: Button.showDisabled

### Description
Should we visibly change state when disabled?

### Groups

- state

**Flags**: IRW

---
## Attr: MiniDateRangeItem.pickerIconPrompt

### Description
The prompt to show when the mouse is hovered over the \[attr:MiniDateRangeItem.pickerIcon\](#attr-minidaterangeitempickericon).

### Groups

- i18nMessages

**Flags**: IR

---
## Method: Canvas.getImgURL

### Description
Return the full URL for an image to be drawn in this canvas.

If the passed URL begins with the special prefix "\[SKIN\]", it will have the widget.skinImgDir and Page.skinImgDir prepended. Otherwise the image is assumed to be application-specific, and will have the widget.appImgDir and Page.appImgDir automatically prepended.

Note that if passed an absolute path (starting with "/" or "http://" for example), no extra image directory information will be prepended to the generated URL.//

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| URL | [String](#type-string) | false | — | URL local to skin or application image directory |
| imgDir | [String](#type-string) | true | — | optional image directory to override the default for this Canvas |

### Returns

`[String](#type-string)` — URL to use

### Groups

- images

**Flags**: A

---
## Attr: PickList.singleClickFolderToggle

### Description
When this item is showing a \[tree-based picker\](#attr-picklistdatasettype), the default behavior is for folder open-state to be toggled by double-clicking. Set this attribute to true to toggle folders on a single-click instead.

Note: when set to true, users can only choose leaf-nodes, since clicking folders would simply toggle them.

**Flags**: IR

---
## Attr: StretchImg.src

### Description
The base URL for the image.

The \[type:State\](#type-state) for the component will be combined with this URL using the same approach as described in \[attr:Img.src\](#attr-imgsrc). Then the image segment \[name\](#attr-stretchitemname) as specified by each \[object:StretchItem\](#object-stretchitem) is added.

For example, for a stretchImg in "Over" state with a `src` of "button.png" and a segment name of "stretch", the resulting URL would be "button\_Over\_stretch.png".

### Groups

- appearance

### See Also

- [StretchImg.hSrc](#attr-stretchimghsrc)
- [StretchImg.vSrc](#attr-stretchimgvsrc)

**Flags**: IRW

---
## Method: Class.getCallTrace

### Description
Returns a one-line summary of the current method call, showing method name and passed arguments. This function is available as a static on every ISC Class and as an instance method on every instance of an ISC Class.  
General best practice is to call the method as "this.getCallTrace(arguments)" whenever "this" is an instance, or call the static classMethod on the \[class:Log\](#class-log) class otherwise.

Note the `arguments` object is required in most cases for this method to function. In some browsers, it can be derived automatically, but developers looking to debug on multiple platforms should not rely on this.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| args | [Arguments](#type-arguments) | true | — | arguments object from the call to trace. If ommitted, where supported, arguments will be derived from the calling function, or if this is not supported, the method will not function. |

### Groups

- debug

---
## Method: DrawLinePath.moveStartPointTo

### Description
Moves the line path such that the \[attr:DrawLinePath.startPoint\](#attr-drawlinepathstartpoint) ends up at the specified point.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| left | [Integer](#type-integer) | false | — | new left coordinate in pixels |
| top | [Integer](#type-integer) | false | — | new top coordinate in pixels |

---
## Attr: EventStreamEvent.threadCode

### Description
A symbolic thead ID useful for debugging, present when a JavaScript error is hit processing an event.

### See Also

- [EventStreamEvent.errorTrace](#attr-eventstreameventerrortrace)
- [EventStreamEvent.errorEvent](#attr-eventstreameventerrorevent)

**Flags**: R

---
## Attr: TourWindow.contentComponents

### Description
Additional content components to show below \[attr:TourWindow.contents\](#attr-tourwindowcontents) or \[attr:TourWindow.title\](#attr-tourwindowtitle) if there are no other content.

**Flags**: IR

---
## Type: Callback

### Description
A `Callback` is an arbitrary action to be fired - usually passed into a method to be fired asynchronously as a notificaction of some event.  
The `callback` can be defined in the following formats:

*   a function
*   A string containing an expression to evaluate
*   An object with the following properties:  
    \- target: fire in the scope of this target - when the action fires, the target will be available as `this`.  
    \- methodName: if specified we'll check for a method on the target object with this name.  
    

`Callbacks` are fired via the \[classMethod:Class.fireCallback\](#classmethod-classfirecallback) method, which allows named parameters to be passed into the callback at runtime. If the Callback was specified as a string of script, these parameters are available as local variables at eval time.  
For specific SmartClient methods that make use of `Callback` objects, see local documentation for information on parameters and scope.

---
## Method: FacetChart.getMinChartHeight

### Description
Returns the \[minimum height\](#attr-facetchartminchartheight) for the chart body.

---
## Class: Portlet

### Description
Custom subclass of Window configured to be embedded within a \[class:PortalLayout\](#class-portallayout).

---
## Method: FormItem.focusInItem

### Description
Move the keyboard focus into this item's focusable element

### Groups

- eventHandling
- focus

---
## Method: ListGrid.getExpansionComponent

### Description
When \[attr:ListGrid.canExpandRecords\](#attr-listgridcanexpandrecords) is true, gets the embedded-component to show as a given record's expansionComponent. This component is then housed in \[a VLayout\](#attr-listgridexpansionlayout) and embedded into a record's row.

By default, this method returns one of a set of built-in components, according to the value of \[listGrid.expansionMode\](#type-expansionmode). You can override this method to return any component you wish to provide as an expansionComponent.

As long as the record is expanded, this component may be retrieved via a call to \[method:ListGrid.getCurrentExpansionComponent\](#method-listgridgetcurrentexpansioncomponent).

When an expanded record is collapsed, the component is disassociated from the record and may or may not be automatically destroyed. By default, built-in components will be destroyed on unembed according to the \[pooling mode\](#attr-listgridexpansioncomponentpoolingmode) being used. Custom expansion components, created via an override of getExpansionComponents(), will 
#### _not_
 be auto-destroyed - developers should override \[method:ListGrid.collapseRecord\](#method-listgridcollapserecord) to take care of clean-up for such components.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| record | [ListGridRecord](#type-listgridrecord) | false | — | record to get the expansionComponent for |

### Returns

`[Canvas](#type-canvas)|[Canvas Properties](#type-canvas-properties)` — the component to embed

### Groups

- expansionField

### See Also

- [ListGrid.expansionScreen](#attr-listgridexpansionscreen)

---
## Attr: DataSourceField.updateRequiresAuthentication

### Description
Whether a user must be authenticated in order to update to this field. If this property is set and the user is not authenticated, the SmartClient Server will not allow this field to be updated.

### Groups

- fieldLevelAuth
- declarativeSecurity

### See Also

- [DataSourceField.editRequiresAuthentication](#attr-datasourcefieldeditrequiresauthentication)

**Flags**: IR

---
## Method: ListGrid.setSelectionAppearance

### Description
Changes selectionAppearance on the fly.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| selectionAppearance | [SelectionAppearance](#type-selectionappearance) | false | — | new selection appearance |

---
## Method: EditTree.destroyAll

### Description
Removes all \[EditNodes\](#object-editnode) from the EditContext, and calls \[destroy()\](#method-canvasdestroy) on the \[liveObjects\](#attr-editnodeliveobject).

---
## Method: Array.unsort

### Description
Turn sorting off for this array, indicating that the current sort order should be preserved. Return true if this is supported in this List. Some implementations may not support this -- they should return false to indicate to the caller that sort order must be maintained (eg: in the case where sort order is derived from the server, etc).

### Returns

`[boolean](#type-boolean)` — true == list supports unsorting, false == not supported.

### Groups

- sorting

**Flags**: A

---
## Method: DataSource.getSearchOperator

### Description
Get the \[object:Operator\](#object-operator) definition for an \[type:OperatorId\](#type-operatorid).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| operatorId | [OperatorId](#type-operatorid) | false | — | the id of the operator |

### Returns

`[Operator](#type-operator)` — the \[object:Operator\](#object-operator) definition

### Groups

- advancedFilter

---
## Method: ViewLoader.handleError

### Description
This method is called when a transport error occurs. Typically, this is the result of the server returning an HTTP error code such as 404 - document not found. You can inspect the RPCResponse object for the reasons for the error and take appropriate action. Typical properties to look at are rpcResponse.status, and rpcResponse.httpResponseCode.

This method is called from the response processing pipeline. If you want to provide your own HTML response as the result of the error, you can do so by setting rpcResponse.data to your HTML string. Returning false from this method suppresses any further response handling. The default implementation of this method causes an error message to be logged to the Developer Console and sets the HTML to the error string.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| rpcRequest | [RPCRequest](#type-rpcrequest) | false | — | The RPCRequest that was made to the server |
| rpcResponse | [RPCResponse](#type-rpcresponse) | false | — | The RPCResponse that was received |

### Returns

`[boolean](#type-boolean)` — false to suppress further response processing

### Groups

- contentLoading

---
## Attr: Canvas.dragResizeAppearance

### Description
If \[attr:Canvas.canDragResize\](#attr-canvascandragresize) is true, this attribute specifies the visual appearance to show during drag resize. If unset \[attr:Canvas.dragAppearance\](#attr-canvasdragappearance) will be used.

### Groups

- dragdrop

**Flags**: IRWA

---
## Attr: FacetChart.dataLabelFacetsMargin

### Description
Determines separation between the set of inner data labels and the set of outer data labels for charts that support multiple data label facets. See the discussion of "Three Facet Bar and Column Charts" in the \[overview\](#class-facetchart).

### Groups

- labelsAndTitles

**Flags**: IRW

---
## Attr: DebugOverflowSettings.loggingTimeout

### Description
How often to log the \[overflow threshold\](#attr-debugoverflowsettingsselfoverflowthreshold) being crossed, expressed in milliseconds. A setting of null or zero disable the limitation.

If this property is a positive number, and fewer than that many milliseconds have elapsed since the last time we logged an overflow problem for a canvas, then logging will be skipped for that canvas.

**Flags**: IRW

---
## Attr: DateChooser.showDoubleYearIcon

### Description
If this property is set to true the previous and next year buttons will render out the previous and next month button icons twice rather than using the \[attr:DateChooser.prevYearIcon\](#attr-datechooserprevyearicon) and \[attr:DateChooser.nextYearIcon\](#attr-datechoosernextyearicon).

Set to `true` by default as not all skins contain media for the year icons.

**Flags**: IRW

---
## Method: DataSource.viewFile

### Description
Display a file stored in a field of type:"binary" in a new browser window.

This will open a new browser window to show the file. Depending on the file type, the user's installed plugins and applications, and the user's browser settings, this may cause the file to be actually displayed in the new browser window, or may prompt the user to either launch an external application to view the file or save the file to disk.

Note that if this method is called for a record with no associated file, the target window's new URL may not be functional. By default when dataSources encounter a \[binary type fields\](#type-fieldtype), an additional field, `<fieldName>_filename`, is generated to store the filename for the binary field value. If this field is present in the data source but has no value for this record, developers can assume they're working with a record with no stored file. If this field is not present in some custom dataSource configuration, or the record is not loaded on the client, an additional server transaction may be required to determine whether the record has an associated file before calling this method to view a file.

See the overview of \[Binary Fields\](#group-binaryfields) for details.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| data | [Record](#type-record) | false | — | Record to download. Only required to have a value for the primary key field. |
| fieldName | [FieldName](#type-fieldname) | true | — | Optional name of the binary field containing the file. If not provided, the first binary field is used. |
| requestProperties | [DSRequest Properties](#type-dsrequest-properties) | true | — | Additional properties to set on the DSRequest that will be issued. |

---
## Attr: FacetChart.lowErrorMetric

### Description
`lowErrorMetric` and \[attr:FacetChart.highErrorMetric\](#attr-facetcharthigherrormetric) can be used to cause error bars to appear above and below the main data point.

`lowErrorMetric` and `highErrorMetric` provide the name of an additional attributes that appears in each Record holding the low error value and high error value respectively.

Error bars are supported for single-axis charts only.

### See Also

- [FacetChart.metricFacetId](#attr-facetchartmetricfacetid)

**Flags**: IR

---
## Attr: TableView.navIcon

### Description
The navigation icon shown next to records when \[attr:TableView.showNavigation\](#attr-tableviewshownavigation) is true and \[type:NavigationMode\](#type-navigationmode) is set to "navIconOny".

**Flags**: IRW

---
## Attr: GridRenderer.showHoverOnDisabledCells

### Description
If \[attr:GridRenderer.showHover\](#attr-gridrenderershowhover) is true, should cell hover HTML be displayed on disabled cells?

**Flags**: IRWA

---
## Type: MenuFieldID

### Description
Simple string identifiers for standard menu fields.

### Values

| Value | Description |
|-------|-------------|
| "icon" | Displays the icon field for the menu. This field contains the item's specified icon (if there is one), or if the item is checked, the checkmark icon for the item. |
| "title" | Displays the item's title |
| "key" | Displays the key field for the menu. This field contains the name or title of any shortcut keys for this menu item. |
| "subMenu" | Field to display the submenu image for items that have a submenu. |

---
## Attr: MultiPickerItem.pickList

### Description
The MultiPickerItem `pickList` is a filterable ListGrid \[type:AutoChild\](#type-autochild) for viewing and selecting the list of available options when \[type:SelectionStyle\](#type-selectionstyle) is `"pickList"`.

It is rendered inside the \[attr:MultiPickerItem.pickerLayout\](#attr-multipickeritempickerlayout) along with the optional \[attr:MultiPickerItem.selectionList\](#attr-multipickeritemselectionlist)

**Flags**: IR

---
## Attr: FormulaBuilder.invalidBlankPrompt

### Description
When \[testFunction\](#method-formulabuildertestfunction) reports an empty formula, this attribute provides the error-text to display in the \[message-label\](#attr-formulabuildermessagelabel).

This is a dynamic string - text within `${...}` are dynamic variables and will be evaluated as JS code when the message is displayed.

Only one dynamic variable, builderType, is available and represents the type of this builder, either Formula or Summary.

The default output is:

`_Invalid blank [Formula/Summary]_`

### Groups

- i18nMessages

**Flags**: IRWA

---
## Method: ListGrid.getFields

### Description
Get the array of all 
#### currently visible
 fields for this ListGrid.

This list fields is only valid once the ListGrid has been \[drawn\](#method-canvasdraw) or once \[method:ListGrid.setFields\](#method-listgridsetfields) has been called explicitly. If called earlier, only the list of directly specified fields will be returned (the Array passed to create()).

This Array should be treated as 
#### read-only
. To modify the set of visible fields, use \[method:ListGrid.showField\](#method-listgridshowfield), \[method:ListGrid.hideField\](#method-listgridhidefield) and related APIs. To update properties of individual fields, use \[method:ListGrid.setFieldProperties\](#method-listgridsetfieldproperties) or more specific APIs such as \[method:ListGrid.setFieldTitle\](#method-listgridsetfieldtitle).

To get the Array of all fields, including fields that are not currently visible or were specified implicitly, use \[method:ListGrid.getAllFields\](#method-listgridgetallfields).

### Returns

`[Array of ListGridField](#type-array-of-listgridfield)` — Array of all currently visible fields

---
## Attr: NotifySettings.maxStackDismissMode

### Description
Specifies how to pick which message to dismiss when the \[attr:NotifySettings.maxStackSize\](#attr-notifysettingsmaxstacksize) is reached, and the lowest priority value (highest numerical \[messagePriority\](#attr-notifysettingsmessagepriority)) is shared by more than one message.

We can simply dismiss the oldest message of that \[messagePriority\](#attr-notifysettingsmessagepriority), or we can pick the message with the least time left until it's auto-dismissed.

### See Also

- [NotifySettings.duration](#attr-notifysettingsduration)
- [Notify.dismissMessage](#classmethod-notifydismissmessage)

**Flags**: IR

---
## Method: StyleSheetHandler.loaded

### Description
Has this handler's \[styleSheet\](#attr-stylesheethandlerstylesheet) been loaded into the DOM?

---
## Method: DrawGroup.moveBy

### Description
Updates the `DrawGroup`'s left coordinate by `dX` and the top coordinate by `dY`. Note that this does not move or resize the items in this `DrawGroup`.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| dX | [Distance](#type-distance) | false | — | change to left coordinate in pixels |
| dY | [Distance](#type-distance) | false | — | change to top coordinate in pixels |

---
## Attr: FacetChart.legendLabelProperties

### Description
Properties for labels shown next to legend color swatches.

### Groups

- legend

**Flags**: IR

---
## Attr: EditTree.defaultPalette

### Description
\[interface:Palette\](#interface-palette) to use when an \[object:EditNode\](#object-editnode) is being created directly by this EditContext, instead of being created due to a user interaction with a palette (eg dragging from a \[class:TreePalette\](#class-treepalette), or clicking on \[class:MenuPalette\](#class-menupalette)).

If no defaultPalette is provided, the EditContext uses an automatically created \[class:HiddenPalette\](#class-hiddenpalette).

**Flags**: IR

---
## Attr: MiniDateRangeItem.dateDisplayFormat

### Description
Format for displaying dates to the user.

If this attribute is unset, the display value is formatted intelligently according to the dates involved. For example, if both dates appear in the same month, the value will be formatted as

`Month date1 - date2, Year`

and, if in different months of the same year,

`Month1 date1 - Month2 date2, Year`.

If either date-value is unset, the display-value is formatted according to \[fromDateOnlyPrefix\](#attr-minidaterangeitemfromdateonlyprefix) and \[toDateOnlyPrefix\](#attr-minidaterangeitemtodateonlyprefix).

**Flags**: IR

---
## Method: ListGrid.setBodyOverflow

### Description
Update the \[bodyOverflow\](#attr-listgridbodyoverflow) for this listGrid.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| overflow | [Overflow](#type-overflow) | false | — | new overflow setting for the body |

**Flags**: A

---
## Method: Calendar.getSublaneEvents

### Description
For views that support \[lanes\](#attr-calendarlanes) and allow \[sublanes\](#attr-calendarusesublanes), returns the array of events in the current dataset that apply to the passed lane and sublane in the passed or current view.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| lane | [Lane](#type-lane)|[String](#type-string) | false | — | lane object or name to get the events for |
| sublane | [Lane](#type-lane)|[String](#type-string) | false | — | sublane object or name to get the events for |
| view | [CalendarView](#type-calendarview) | true | — | the view in which the passed sublane lives - uses the selected view if unset |

### Returns

`[Array of CalendarEvent](#type-array-of-calendarevent)` — the list of events that apply to the passed sublane and view

---
## Attr: RichTextEditor.strikethroughSelectionPrompt

### Description
The prompt for the built-in \[strikethroughSelection\](#type-controlname) control.

### Groups

- i18nMessages

**Flags**: IRW

---
## Attr: HiddenItem.colSpan

### Description
hidden fields don't take up any columns

### Groups

- appearance

**Flags**: IRW

---
## Method: EventStream.getCypressScript

### Description
Builds a full Cypress test file by framing event commands in describe/it blocks. It adds a beforeEach with cy.visit, viewport setup, optional waits, and then the test steps.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| eventStream | [EventStream](#type-eventstream) | false | — | Stream of events to convert. |
| targetUrl | [String](#type-string) | true | — | URL to visit in beforeEach; defaults to current page. |
| testName | [String](#type-string) | true | — | Name of the it() block; defaults to "Test". |
| testDescription | [String](#type-string) | true | — | Description of the describe() block; defaults to "Testing". |

### Returns

`[String](#type-string)` — Complete Cypress spec code ready to paste into a \`.spec.js\`.

### Groups

- smartClientCypress
- autoTest

### See Also

- [EventStream.getCypressEventScript](#classmethod-eventstreamgetcypresseventscript)
- [EventStream.getCypressScriptFromData](#classmethod-eventstreamgetcypressscriptfromdata)

---
## Type: AsyncOperationResultType

### Description
The type of result of an asynchronous operation.

### Values

| Value | Description |
|-------|-------------|
| "success" | The asynchronous operation completed successfully. |
| "error" | The asynchronous operation encountered an error. |
| "canceled" | The asynchronous operation was canceled. |
| "disabled" | The asynchronous operation is disabled. |
| "deferred" | The asynchronous operation was deferred. |

### See Also

- [AsyncOperationResult](#object-asyncoperationresult)

---
## Attr: DateItem.wrapHintText

### Description
If this item is showing a \[attr:FormItem.hint\](#attr-formitemhint), should the hint text be allowed to wrap? Setting this property to `false` will render the hint on a single line without wrapping, expanding the width required to render the item if necessary.

If unset this property will be picked up from the \[attr:DynamicForm.wrapHintText\](#attr-dynamicformwraphinttext) setting.

This setting does not apply to hints that are \[shown in field\](#attr-textitemshowhintinfield).

### See Also

- [FormItem.minHintWidth](#attr-formitemminhintwidth)

**Flags**: IR

---
## Method: Tour.notifyValidationMessage

### Description
Notify user of expected value entry validation message. Default implementation uses the \[Notify system\](#class-notify) to show the message in it's default position. See \[notifyType\](#type-notifytype) for notification configuration details.

Override this method to display message by a different means.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| message | [String](#type-string) | false | — | message provided by \[attr:TourStep.inputValidationNotifyMessage\](#attr-tourstepinputvalidationnotifymessage) |

---
## Method: DrawRect.moveTo

### Description
Move the drawRect to the specified position

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| left | [Integer](#type-integer) | false | — | new left coordinate |
| top | [Integer](#type-integer) | false | — | new top coordinate |

---
## Attr: FacetChart.drawTitleBoundary

### Description
Whether a boundary should be drawn below the title area for circumstances where the chart area already has an outer border. If the chart has no outer border, then the \[attr:FacetChart.titleBackgroundProperties\](#attr-facetcharttitlebackgroundproperties) settings should be used instead.

### Groups

- chartTitle

**Flags**: IRW

---
## Attr: FormItem.autoComplete

### Description
Should this item allow browser auto-completion of its value? Applies only to items based on native HTML form elements (\[class:TextItem\](#class-textitem), \[class:PasswordItem\](#class-passworditem), etc), and will only have a user-visible impact for browsers where native autoComplete behavior is actually supported and enabled via user settings.

Alternatively, \[attr:FormItem.autoCompleteKeywords\](#attr-formitemautocompletekeywords) can be specified, in which case this setting is ignored. If `autoCompleteKeywords` are not provided, and `autoComplete` is not set on this FormItem, the value of \[attr:DynamicForm.autoComplete\](#attr-dynamicformautocomplete) is used.

Note that even with this value set to `"none"`, native browser auto-completion may occur for log in forms (forms containing username and \[password\](#class-passworditem) fields). This behavior varies by browser, and is a result of an [intentional change by some browser developers](https://www.google.com/search?q=password+ignores+autocomplete+off) to disregard the HTML setting _autocomplete=off_ for password items or log-in forms.

In some browsers any form redraw (including a redraw from a call to \[method:DynamicForm.setValues\](#method-dynamicformsetvalues)) will re-populate the form with the natively remembered login credentials. This can make it very difficult to control the values displayed to the user, as a call to 'setValues()' may appear to be ignored. While behavior varies by browser we have specifically observed this behavior in Safari. Moreover in this browser, if the user asks the browser to remember login credentials for a URL, any form with a password item and a text item may be auto-filled with the remembered login credentials, even if the form's configuration and field names differ from those on the login form.

If an application has both an initial log in form, and a separate form within the application which makes contains a Password item (a use case might be an interface for a user with manager privileges for modifying other users' passwords), this will cause the second form to autofill with unexpected values.

Should this arise, developers can avoid this by making the initial log in interface into a separate log in page from the main application page. This is often good practice in any case for reasons outlined in the "Authentication" section of the Quick Start guide.

### Groups

- autoComplete

### See Also

- [DynamicForm.autoComplete](#attr-dynamicformautocomplete)

**Flags**: IRW

---
## Attr: PortalLayout.columnBorder

### Description
Border to show around columns in this PortalLayout

**Flags**: IRW

---
## Attr: ListGrid.filterWindowFilter

### Description
Instance of \[class:FilterBuilder\](#class-filterbuilder) shown in \[attr:ListGrid.filterWindow\](#attr-listgridfilterwindow) by \[method:ListGrid.showFilterWindow\](#method-listgridshowfilterwindow). See \[attr:ListGrid.filterWindow\](#attr-listgridfilterwindow) for more information on the filter defaults and changing them.

**Flags**: IR

---
## Attr: ListGrid.useCopyPasteShortcuts

### Description
For ListGrids with \[canSelectCells:true\](#attr-listgridcanselectcells), enabling this property will cause the listGrid to intercept standard browser copy/paste shortcut keys and perform the following behavior.

*   _ctrl+c_: retrieve selected cell data via a call to \[method:ListGrid.getSelectedCellData\](#method-listgridgetselectedcelldata), and temporarily store it in memory in a "clipboard" variable.
*   _ctrl+v_: apply any previously copied data stored in the "clipboard" variable into the current grid selection via \[method:ListGrid.applyCellData\](#method-listgridapplycelldata).
*   _ctrl+d_: copy cell values from top row of selected cells down to all rows
*   _ctrl+r_: copy cell values from left column of selected cells right to all columns

#### Note:
 setting this property to true will disable standard copy and paste behavior to the native Browser or OS-level clipboard. To copy data to and from applications outside of the browser, use the technique shown in the ${isc.DocUtils.linkForExampleId('gridToExcel', 'Grid to Excel')} and ${isc.DocUtils.linkForExampleId('excelToGrid', 'Excel to Grid')} samples.

If this property is unset, default behavior will enable these shortcuts if \[attr:ListGrid.canSelectCells\](#attr-listgridcanselectcells) is true, and \[attr:ListGrid.canDragSelectText\](#attr-listgridcandragselecttext) and \[attr:ListGrid.selectCellTextOnClick\](#attr-listgridselectcelltextonclick) are both false, so as to minimize the chances of interfering with native copy and paste of cell content.

**Flags**: IRW

---
## Attr: TreeGrid.connectorIconWidth

### Description
Width in pixels of the connector-icons, that is, the icons which show the open or closed state of the node when using \[connectors\](#attr-treegridshowconnectors), typically a \[+\] or \[-\] symbol with connecting lines.

If not specified, \[attr:TreeGrid.openerIconWidth\](#attr-treegridopenericonwidth) is used instead.

### Groups

- treeIcons

**Flags**: IRW

---
## Attr: FusionChart.fusionVersion

### Description
Version of FusionCharts to assume. If version is "2.3", different names are used for the .swf files for each chart (to match the default names in FusionCharts 2.3), and a lower version of Flash is required (6.0).

**Flags**: IR

---
## Attr: RelativeDateItem.minQuantity

### Description
Minimum value to allow in the \[attr:RelativeDateItem.quantityField\](#attr-relativedateitemquantityfield).

**Flags**: IR

---
## Attr: MultiGroupPanel.invalidListPrompt

### Description
This is a dynamic string - text within `${...}` will be evaluated as JS code when the message is displayed.

Default value returns

``_Columns may only be used once: `[some field's title]` is used multiple times_``

### Groups

- i18nMessages

**Flags**: IR

---
## ClassAttr: Hover.hoverCanvasDefaults

### Description
Defaults to apply to the Hover canvas shown when the user hovers over some widget. By default this property is set to this object:  

       { defaultWidth:100, 
         defaultHeight:1,
         baseStyle:"canvasHover",
         align:"left",
         valign:"top",
         opacity:null
        }
 

  
Note that these properties can be overridden by individual widgets showing hovers, by modifying \[attr:Canvas.hoverWidth\](#attr-canvashoverwidth), \[attr:Canvas.hoverHeight\](#attr-canvashoverheight), \[attr:Canvas.hoverStyle\](#attr-canvashoverstyle), \[attr:Canvas.hoverAlign\](#attr-canvashoveralign), \[attr:Canvas.hoverVAlign\](#attr-canvashovervalign), \[attr:Canvas.hoverOpacity\](#attr-canvashoveropacity), and \[attr:Canvas.hoverWrap\](#attr-canvashoverwrap).

**Flags**: IRW

---
## Attr: ListGridField.canToggle

### Description
Allows a boolean or \[valueMapped\](#type-valuemap) field to be edited without going into edit mode. When this attribute is set, clicking on the field will change the value - for boolean fields toggling between `true` and `false`, and for valueMapped fields, advancing the value to the next option in the valueMap.

To enable this feature, \[attr:ListGrid.canEdit\](#attr-listgridcanedit) must be set to true. For boolean type fields `canToggle` is true by default, meaning setting `canEdit` to true implies the user can toggle the value via a single click without going into edit mode. You can disable this by explicitly setting `canToggle` to false for a boolean field.  
Note that you can enable toggling only (without allowing the user to edit other fields) by just setting \[grid.editEvent:"none"\](#attr-listgrideditevent).

If \[attr:ListGrid.editEvent\](#attr-listgrideditevent) is set to "click", when the user clicks on the field, the value will be toggled, and inline editing will be triggered as usual. Otherwise the toggled value will be saved immediately to the server, or if \[attr:ListGrid.autoSaveEdits\](#attr-listgridautosaveedits) has been set to false, will be stored as an edit value for the record.

### Groups

- editing

**Flags**: IRWA

---
## StaticMethod: History.getCurrentHistoryId

### Description
Returns the current history id as reflected by the current URL.

### Returns

`[String](#type-string)` — The current history id as reflected by the current URL.

---
## Attr: EditContext.selectedAppearance

### Description
Appearance that is applied to selected component.

This value is applied as a default to \[attr:EditProxy.selectedAppearance\](#attr-editproxyselectedappearance).

### See Also

- [EditContext.selectedBorder](#attr-editcontextselectedborder)
- [EditContext.selectedTintColor](#attr-editcontextselectedtintcolor)
- [EditContext.selectedTintOpacity](#attr-editcontextselectedtintopacity)

**Flags**: IR

---
## Type: ArrowKeyEditAction

### Description
What to do if the user hits Up or Down arrow key while editing a cell.

### Values

| Value | Description |
|-------|-------------|
| "none" | The grid will take no special action when the user presses up or down arrow keys within an editor |
| "editNext" | The grid will intercept up and down arrow keypresses and navigate to the next or previous edit row by generating an appropriate \[type:EditCompletionEvent\](#type-editcompletionevent) |

### Groups

- editing

---
## Attr: RPCRequest.serverOutputAsString

### Description
Setting this flag makes the body of the HTTP response available as a String in the \[attr:RPCRequest.callback\](#attr-rpcrequestcallback) as \[attr:RPCResponse.data\](#attr-rpcresponsedata). This is typically only useful if you are sending a request that will 
#### not
 be received by the SmartClient Java Server, however in that case, set \[attr:RPCRequest.useSimpleHttp\](#attr-rpcrequestusesimplehttp):true instead, which implies `serverOutputAsString:true`.

`serverOutputAsString:true` allows you to, for example, load the contents of static files off your webserver into a string for processing on the client with no server support. The \[attr:RPCRequest.actionURL\](#attr-rpcrequestactionurl) must be in the same domain as the current page for this to work.

This feature relies on the XMLHttpRequest object which can be disabled by end-users in some supported browsers. See \[group:platformDependencies\](#group-platformdependencies) for more information.

Generally this API is used for either \[non-Java backends\](#group-nonjavabackend) or for advanced usage such as content that requires processing before it can be used in SmartClient components (such as client-side web scraping). Note that SmartClient provides higher-level APIs for loading common types of data, see eg \[class:HTMLFlow\](#class-htmlflow) for HTML content, \[class:ViewLoader\](#class-viewloader) for loading SmartClient components, \[classMethod:XMLTools.loadXML\](#classmethod-xmltoolsloadxml) for loading XML, \[attr:RPCRequest.evalResult\](#attr-rpcrequestevalresult) for loading [JSON](http://www.json.org/), and \[class:DataSource\](#class-datasource) for loading structured data in various formats.

**Flags**: IRWA

---
## Attr: SavedSearchItem.canEditSearch

### Description
Whether existing searches can be edited.

If no explicit value is set, it will be defaulted to `false` if the \[target is a grid\](#attr-savedsearchitemtargeteditscriteria). Searches can be edited by simply selecting them, using the grid's standard UI to edit the search, and then saving that as the original search.

**Flags**: IR

---
## Method: String.startsWith

### Description
Returns `true` if this string starts with another string, or if the other string occurs at the given `position` within this string.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| substring | [String](#type-string) | false | — | other string to check |
| position | [int](#type-int) | true | — | optional position in this string. Defaults to 0. |

### Returns

`[boolean](#type-boolean)` — `true` if `substring` occurs within this string at position `position`.

### Groups

- stringProcessing

---
## Type: OperatorId

### Description
An operator is used as part of a \[object:Criterion\](#object-criterion) when specifying \[object:AdvancedCriteria\](#object-advancedcriteria).

This list of operators indicates the set of operators built into SmartClient DataSources, which can be used for both client and server-side filtering. Some operators offer case-insensitive versions, prefixed with a lower-case _i_, such as `iContains`. 
#### Note that such operators are intended for text-based searches and are not available to numeric or date fields (integer/float/date/datetime and derivatives), where there is no use for case.

You can extend the list of operators with \[method:DataSource.addSearchOperator\](#method-datasourceaddsearchoperator).

### Values

| Value | Description |
|-------|-------------|
| "equals" | exactly equal to |
| "notEqual" | not equal to |
| "iEquals" | exactly equal to, if case is disregarded |
| "iNotEqual" | not equal to, if case is disregarded |
| "greaterThan" | Greater than |
| "lessThan" | Less than. Note that `null` is treated as equivalent to an arbitrarily small value, so null field values will always be returned by `lessThan` / `lessOrEqual` filter operations by default. |
| "greaterOrEqual" | Greater than or equal to |
| "lessOrEqual" | Less than or equal to |
| "contains" | Contains as sub-string (match case) |
| "startsWith" | Starts with (match case) |
| "endsWith" | Ends with (match case) |
| "iContains" | Contains as sub-string (case insensitive) |
| "iStartsWith" | Starts with (case insensitive) |
| "iEndsWith" | Ends with (case insensitive) |
| "notContains" | Does not contain as sub-string (match case) |
| "notStartsWith" | Does not start with (match case) |
| "notEndsWith" | Does not end with (match case) |
| "iNotContains" | Does not contain as sub-string (case insensitive) |
| "iNotStartsWith" | Does not start with (case insensitive) |
| "iNotEndsWith" | Does not end with (case insensitive) |
| "iBetween" | shortcut for "greaterThan" + "and" + "lessThan" (case insensitive) |
| "iBetweenInclusive" | shortcut for "greaterOrEqual" + "and" + "lessOrEqual" (case insensitive) |
| "matchesPattern" | Basic GLOB matching using wildcards (see \[attr:DataSource.translatePatternOperators\](#attr-datasourcetranslatepatternoperators) for more information on available patterns) |
| "iMatchesPattern" | Basic GLOB matching using wildcards (case insensitive) (see \[attr:DataSource.translatePatternOperators\](#attr-datasourcetranslatepatternoperators) for more information on available patterns) |
| "containsPattern" | GLOB matching using wildcards. Value is considered to meet the criterion if it contains the pattern. See \[attr:DataSource.translatePatternOperators\](#attr-datasourcetranslatepatternoperators) for more information on available patterns) |
| "startsWithPattern" | GLOB matching using wildcards. Value is considered to meet the criterion if it starts with the pattern.See \[attr:DataSource.translatePatternOperators\](#attr-datasourcetranslatepatternoperators) for more information on available patterns) |
| "endsWithPattern" | GLOB matching using wildcards. Value is considered to meet the criterion if it starts with the pattern.See \[attr:DataSource.translatePatternOperators\](#attr-datasourcetranslatepatternoperators) for more information on available patterns) |
| "iContainsPattern" | GLOB matching using wildcards. Value is considered to meet the criterion if it contains the pattern. Matching is case insensitive. See \[attr:DataSource.translatePatternOperators\](#attr-datasourcetranslatepatternoperators) for more information on available patterns) |
| "iStartsWithPattern" | GLOB matching using wildcards. Value is considered to meet the criterion if it starts with the pattern. Matching is case insensitive.See \[attr:DataSource.translatePatternOperators\](#attr-datasourcetranslatepatternoperators) for more information on available patterns) |
| "iEndsWithPattern" | GLOB matching using wildcards.Value is considered to meet the criterion if it ends with the pattern. Matching is case insensitive. See \[attr:DataSource.translatePatternOperators\](#attr-datasourcetranslatepatternoperators) for more information on available patterns) |
| "regexp" | Regular expression match - built-in SQL only, JPA and Hibernate do not support regexp operator. Additionally, when using PostgreSQL, it is supported only starting from PostgreSQL version 9.3. |
| "iregexp" | Regular expression match (case insensitive) - regexp operator limitations apply. |
| "isBlank" | value is either null or the empty string. For numeric fields it behaves as isNull |
| "notBlank" | value is neither null nor the empty string. For numeric fields it behaves as notNull |
| "isNull" | value is null |
| "notNull" | value is non-null. Note empty string ("") is non-null |
| "inSet" | value is in a set of values. Specify criterion.value as an Array |
| "notInSet" | value is not in a set of values. Specify criterion.value as an Array |
| "equalsField" | matches another field (match case, specify fieldName as criterion.value) |
| "notEqualField" | does not match another field (match case, specify fieldName as criterion.value) |
| "iEqualsField" | matches another field (case insensitive, specify fieldName as criterion.value) |
| "iNotEqualField" | does not match another field (case insensitive, specify fieldName as criterion.value) |
| "greaterThanField" | Greater than another field (specify fieldName as criterion.value) |
| "lessThanField" | Less than another field (specify fieldName as criterion.value) |
| "greaterOrEqualField" | Greater than or equal to another field (specify fieldName as criterion.value) |
| "lessOrEqualField" | Less than or equal to another field (specify fieldName as criterion.value) |
| "containsField" | Contains as sub-string (match case) another field value (specify fieldName as criterion.value) |
| "startsWithField" | Starts with (match case) another field value (specify fieldName as criterion.value) |
| "endsWithField" | Ends with (match case) another field value (specify fieldName as criterion.value) |
| "iContainsField" | Contains as sub-string (case insensitive) another field value (specify fieldName as criterion.value) |
| "iStartsWithField" | Starts with (case insensitive) another field value (specify fieldName as criterion.value) |
| "iEndsWithField" | Ends with (case insensitive) another field value (specify fieldName as criterion.value) |
| "notContainsField" | Does not contain as sub-string (match case) another field value (specify fieldName as criterion.value) |
| "notStartsWithField" | Does not start with (match case) another field value (specify fieldName as criterion.value) |
| "notEndsWithField" | Does not end with (match case) another field value (specify fieldName as criterion.value) |
| "iNotContainsField" | Does not contain as sub-string (case insensitive) another field value (specify fieldName as criterion.value) |
| "iNotStartsWithField" | Does not start with (case insensitive) another field value (specify fieldName as criterion.value) |
| "iNotEndsWithField" | Does not end with (case insensitive) another field value (specify fieldName as criterion.value) |
| "and" | all subcriteria (criterion.criteria) are true |
| "not" | all subcriteria (criterion.criteria) are false |
| "or" | at least one subcriteria (criterion.criteria) is true |
| "between" | shortcut for "greaterThan" + "lessThan" + "and". Specify criterion.start and criterion.end |
| "betweenInclusive" | shortcut for "greaterOrEqual" + "lessOrEqual" + "and". Specify criterion.start and criterion.end |
| "exists" | One or more related records exist (for \[AdvancedCriteria subqueries\](#object-advancedcriterionsubquery)). |
| "notExists" | No related records exist (for \[AdvancedCriteria subqueries\](#object-advancedcriterionsubquery)). |

### Groups

- advancedFilter

---
## Method: ListGrid.hideField

### Description
Force a field to be hidden.  
  
NOTE: If a field.showIf expression exists, it will be destroyed.

Note also that if multiple fields are to be hidden it is more efficient to call \[method:ListGrid.hideFields\](#method-listgridhidefields) passing in the array of fields to hide rather than to call this method repeatedly. In particular, this will ensure \[method:ListGrid.recalculateSummaries\](#method-listgridrecalculatesummaries) is only run once.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| field | [String](#type-string)|[ListGridField](#type-listgridfield) | false | — | field to hide |
| suppressRelayout | [boolean](#type-boolean) | true | — | if passed, don't relayout non-explicit sized fields to fit the available space |

---
## Attr: TabSet.tabBarPosition

### Description
Which side of the TabSet the TabBar should appear on.

### Groups

- tabBar

**Flags**: IR

---
## Attr: ListGrid.autoFitWidthApproach

### Description
When a user requests column autofitting via the \[header context menu\](#method-listgridgetheadercontextmenuitems) or via a \[mouse gesture\](#attr-listgridheaderautofitevent), what autofit approach is used.

For information about auto-fitting specific fields, see \[attr:ListGridField.autoFit\](#attr-listgridfieldautofit).

### Groups

- autoFitFields

**Flags**: IRW

---
## Attr: FacetChart.scaleStartColor

### Description
The starting color of the color scale when the data points are colored according to a \[color scale metric\](#attr-facetchartcolorscalemetric). If neither this property nor the \[scaleEndColor\](#attr-facetchartscaleendcolor) is set then the whole color range is used by default.

Note that using CSS color shortcuts (e.g. "lightblue") is not allowed for this property.

### Groups

- dataPoints

**Flags**: IRW

---
## Attr: MultiSortPanel.iconSize

### Description
The size for the images in the \[Level Up\](#attr-multisortpanellevelupbutton) and \[Level Down\](#attr-multisortpanelleveldownbutton) buttons.

**Flags**: IR

---
## Method: DrawItem.hover

### Description
If \[canHover\](#attr-drawitemcanhover) is true for this DrawItem, the hover() string method will be fired when the user hovers over this DrawItem. If this method returns false, it will suppress the default behavior of showing a hover canvas if \[showHover\](#attr-drawitemshowhover) is true.

### Returns

`[boolean](#type-boolean)` — false to cancel the hover event.

### Groups

- hovers

---
## Method: DrawPane.destroyItems

### Description
Permanently \[destroy\](#method-drawitemdestroy) all DrawItems currently associated with this DrawPane, leaving the DrawPane itself intact

---
## Method: ListGrid.cellSelectionChanged

### Description
Called when (cell-based) selection changes within this grid.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| cellList | [Array](#type-array) | false | — | Array of cells whos selected state was modified. |

### Returns

`[boolean](#type-boolean)` — Returning false will prevent the GridRenderer styling from being updated to reflect the selection change.

### Groups

- selection

**Flags**: A

---
## Group: loadAssemblyTag

### Description
See \[group:jspTags\](#group-jsptags)

_produces:_ HTML

This tag emits the files listed under a single FileAssemblyEntry in your \[group:fileAssembly\](#group-fileassembly) config file. Note that as stated in the \[group:fileAssembly\](#group-fileassembly) docs, you can always include a file assembly by writing out a properly formatted <script> or <link> HTML tag and referencing the same URI as listed in the FileAssemblyEntry that you wish to include, but the <loadAssembly> JSP tag provides a useful mechanism to easily switch between development and production mode (via the 
#### assemble
 attribute - see below) as well as a few other control points.

#### Tag Attributes:

#### URI
  
_value format_: A URI that exactly matches one of the FileAsemblyEntry URIs in your \[group:fileAssembly\](#group-fileassembly) configuration file.  
_default value_: NONE

This attribute selects the specific assembly that you wish to include from the file assembly config file and is required.

#### assemble
  
_value format_: boolean - acceptable values: "true" or "false"  
_default value_: "true"

This attribute controls the manner in which the files listed in your FileAssemblyEntry are emitted onto the page. When set to "true" (the default), the loadAssembly tag simply emits a <script> or <link> HTML tag (depending on the extension) and references the URI you specified. This is what you want for production deployment.

When set to "false", the loadAssembly tag emits separate <script> or <link> HTML tags for each file listed under the FileAssemblyEntry. This is what you frequently want for development because it allows browser tools like Firebug and native browser debuggers to properly report line numbers for errors in a manner that is easily traceable to the source file and location.

The recommended best practice is to parametrize the value of the assemble attribute based on the deployment target and use a rewrite mechanism either in your packaging script (e.g. Ant) or the deployment tool to conditionally set this value such that it is set to "false" in development and "true" in production. For example, like so with Ant:

 assemble="<%=\\"prd\\" == \\"@app.server.target@\\"%>"
 

Note that you then need corresponding logic in your Ant build.xml that does something like:

 <property name="app.server.target" value="prd"/>
 <replace file="${war.dir}/your.jsp" token="@app.server.target@" value="\\${app.server.target}"/>
 

#### locale
  
_value format_: valid locale string - see \[group:dataSourceLocalization\](#group-datasourcelocalization) for more details and examples.  
_default value_: as set by the OS/JVM defaults

#### media
  
_value format_: any valid value of the media attribute of the HTML <link> element.  
_default value_: NONE

This attribute is valid only for FileAssembly entries with a URI that ends with ".css". When set, the value of this attribute is output as the value of the `media` attribute of the <link> element that is emitted onto the page. See e.g. [http://www.w3schools.com/tags/att\_link\_media.asp](http://www.w3schools.com/tags/att_link_media.asp) for valid values of the `media` attribute and a discussion of when/how to use them.

#### configFile
  
_value format_: Path to \[group:fileAssembly\](#group-fileassembly) configuration file exactly as it would be supplied to the servlet config via the `configFile` init-param.  
_default value_: Automatically derived from \[group:fileAssembly\](#group-fileassembly) servlet configuration.

This attribute enables an explicit override of the \[group:fileAssembly\](#group-fileassembly) config file use to match the URI entries. Providing this value is not required - it is auto-derived automatically from the settings you provide on the \[group:fileAssembly\](#group-fileassembly) servlet. But in rare instances (certain non-compliant servlet containers and/or extremely tight java security settings) this auto-derivation can fail and you can use this attribute to provide an explicit setting.

---
## Type: DataURLFormat

### Description
The data URL MIME type to use when \[method:DrawPane.getDataURL\](#method-drawpanegetdataurl) is called to convert the drawing to a data URL.

### Values

| Value | Description |
|-------|-------------|
| "any" | Any MIME type supported by the browser is acceptable. Note: The exact MIME type used may depend on the browser, and may change from version to version of SmartClient. |
| "png" | Generate an `image/png` data URL. |

---
## Method: Tree.addList

### Description
Add a list of nodes to some parent. See \["Modifying ResultTrees"\](#class-resulttree) when working with a `ResultTree` for limitations.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| nodeList | [List of TreeNode](#type-list-of-treenode) | false | — | The list of nodes to add |
| parent | [String](#type-string)|[TreeNode](#type-treenode) | false | — | Parent of the nodes being added. You can pass in either the \[object:TreeNode\](#object-treenode) itself, or a path to the node (as a String), in which case a \[method:Tree.find\](#method-treefind) is performed to find the node. |
| position | [number](#type-number) | true | — | Position of the new nodes in the children list. If not specified, the nodes will be added at the end of the list. |

### Returns

`[List](#type-list)` — List of added nodes.

### See Also

- [sharingNodes](#group-sharingnodes)

---
## Attr: MultiPickerItem.showSelectionList

### Description
Should a \[list of selected items\](#attr-multipickeritemselectionlist) be displayed below the \[interface:PickList\](#interface-picklist) if \[type:SelectionStyle\](#type-selectionstyle) is `"pickList"`?

**Flags**: IR

---
## Attr: DataSourceField.exportFormat

### Description
An optional \[type:FormatString\](#type-formatstring) for this field, for use when \[exporting\](#method-databoundcomponentexportdata) data to spreadsheet formats (XLS and OOXML/XLSX), XML, JSON or CSV. You can use this property to override the normal \[format\](#attr-datasourcefieldformat) of this field, if any, specifically for exports, for both server-based and client-driven exports.

Note, for server-driven exports you can specify default formats for date, time and datetime fields by specifying properties `export.format.default.date`, `export.format.default.time` and `export.format.default.datetime` in your `server.properties` file. Similarly, default formats for float and integer fields can be specified with `export.format.default.float` and `export.format.default.integer`, respectively. These formats will be used for fields that do not have a "format" or "exportFormat" property specified in the `.ds.xml` file.

Specifically when exporting to spreadsheet formats, the `FormatString` is translated to the type of format string used by spreadsheet programs like Excel. A handful of features are not present in Excel format strings, and some features behave slightly differently. These differences are explained below.

#### Excel cannot handle dates prior to January 1st 1900
This is a well-known limitation of Excel dates; it is not a formatting issue as such.

#### Currency symbols become fixed to the current locale at export time
The placeholder currency symbol "¤" (\\u00A4) in a numeric format string is rendered as the \[localized currency symbol\](#classattr-numberutilcurrencysymbol). When exporting, the format string provided to Excel contains the currency symbol for the current locale of the SmartClient application, and not a placeholder currency symbol that would make Excel pick up a currency symbol based on the operating system locale. We do this to ensure that the spreadsheet reflects the _application's_ localization, rather than the localization of the current user's computer, because they may be different.

#### Rounding differences
The approach to rounding a positive number to a set number of decimal places is fairly universally agreed upon for non-specialized requirements: add 0.5 (or 0.05, or 0.005, or whatever) to the number and then truncate. This leads to the well understood convention that numbers exactly halfway between two possible rounding outcomes, go to the larger one. So 7.5 becomes 8 and 7.15 becomes 7.2.

However, there is no such universal agreement when it come to rounding negative numbers. Some take the view that you should round by taking the number to the larger absolute value, so -7.15 becomes -7.2. Others feel that you should round by taking the number to the larger value in the sense of it being "less negative", so -7.15 becomes -7.1.

SmartClient formatting takes the first approach and rounds negative numbers away from zero. We do this simply because that is what Java DecimalFormat does. Unfortunately, Excel does the opposite. Therefore, you will see rounding differences on negative numbers on exact 50% boundaries: SmartClient will format -7.15 as -7.2, while Excel will format the same value as -7.1.

#### Different treatment of '#'
Both SmartClient and Excel use '#' to mean "digit, do not show zeroes". However, Excel does not implement this strictly in the integer part when the number it is formatting has a value of 0 in the integer part. So, with a format of "#.##", the value 0.25 is formatted as "0.25". SmartClient (like Java DecimalFormat) is strict: with that format, 0.25 is formatted as ".25"; if you want to match Excel's output, you must use the format "0.##".

#### Miscellaneous edge cases
There is quite a lot of variation in behavior between Java DecimalFormat and Excel around the edges. For actual error cases - for example, a format string that just contains nonsense - it is normal and expected that the SmartClient behavior and the Excel behavior do not match - this is just two systems producing different garbage out for the same garbage in, which is to be expected. For valid but weird usages - for example, a format with multiple percent signs - SmartClient's formatting is in line with what DecimalFormat does, unless DecimalFormat throws an Exception, in which case we just do the thing that seems most sensible, or the thing that was easiest to implement.

Known differences in behavior in edge cases include:

*   SmartClient ignores formatting characters in the number part of the format string, whereas Excel rejects the format (this behavior may vary with different releases of Excel and supposedly compatible libraries: POI, for example, will accept such format strings). If you attempt to format 5.175 with the format string "#b0.#a#", SmartClient will return "5.72", and Excel will reject the format
*   SmartClient ignores quoted characters in the number part of the format string, whereas Excel preserves them. If you attempt to format 5.175 with the format string "#'b'0.#'a'#", SmartClient will return "5.72", and Excel will return "b5.7a2"
*   If you specify the empty string as a format string, SmartClient returns the result of calling toString() on the number; Excel uses the built-in "General" format. These two approaches will generally give the same or very similar results, but that is really a coincidence: the correct way to obtain matching results in the browser and the spreadsheet is to specify a valid format string
*   If you specify a format string that contains no number part (ie, no '#' or '0' characters), SmartClient does what DecimalFormat does, which is to output the integer part of the number alongside the fixed part of the format. Excel just outputs the fixed part. So, if you attempt to format -5.3 with the format string "'Hello world'", SmartClient will output "-Hello world5", whereas Excel will output just "Hello world"
*   If you specify multiple percent signs in the format, SmartClient treats all but the first one as static text, so 0.5 formatted with "#%%%" is "50%%%" (ie, all the signs are preserved but there is only one multiplcation by 100). Excel multiplies for each percent sign, so 0.5 formatted with "#%%%" is "500000%%%"

#### Date format functionality not supported by Excel
The following date/time/datetime functionality is not supported by Excel; if you use formatters that use any of this functionality, your values will be exported to Excel incorrectly formatted. In cases like this, we recommend that you use a separate `exportFormat`, with the intent of exporting your values in a way that is similar to your application formatting (which would be specified with the \[format\](#attr-datasourcefieldformat) property), but within the confines of what Excel supports.

*   Fiscal year, week and day (LL, LLLL, C, CC, c, cc)
*   Week in year (w, ww)
*   Day in year (D, DD)
*   Day number in week (u)
*   Explicit control over whether to use 12- or 24-hour notation. In Excel, this is implied by the presence or absence of the AM/PM designator
*   If the user's operating system locale is different to the locale in use in the SmartClient application, day and month names may be different in the spreadsheet

#### Number format functionality not supported by Excel
The only SmartClient number-formatting functionality not supported for export to Excel is "multiply by 1000 and show as per mille".

#### Limit on number of custom Excel formats
Excel limits the number of custom format strings in a single spreadsheet to somewhere between 200 and 250, depending on your locale and language. Hitting this limit in an export would require hundreds of field definitions, each defining unique `FormatStrings`. If you do hit the limit, the only workaround is to use fewer unique `FormatStrings`.

#### Controlling number format
If we give Excel a formatted number like "500,000" it will not treat that value as a number, so sums and other basic spreadsheet features won't work. So we use the heuristic that if your formatted value parses as a number, you probably want it treated as a number in the spreadsheet, so we give Excel the unformatted numeric value and tell Excel it's a numeric data value.

You might expect that we would give Excel _both_ the formatted value and the numeric value, but this is only possible by creating what's called a "custom format" for that cell, which as the section above mentions, is limited in that only a few hundred can be created.

With this Excel limitation in mind, it makes sense to just go with the default behavior. If you decide otherwise, one option is to use \[exportNumbersAsFormattedString\](#attr-dsrequestexportnumbersasformattedstring), but see the docs for that property for the drawbacks of doing this.

### See Also

- [DataSourceField.format](#attr-datasourcefieldformat)

**Flags**: IRW

---
## Group: rects

### Description
—

---
## Attr: Layout.locateMembersBy

### Description
Part of the \[group:automatedTesting\](#group-automatedtesting) system, strategy to use when generated locators for members from within this Layout's members array.

### Groups

- autoTest

**Flags**: IRWA

---
## Class: FormItem

### Description
A UI component that can participate in a DynamicForm, allowing editing or display of one of the \[values tracked by the form\](#attr-dynamicformvalues).

FormItems are never created via the \[create()\](#classmethod-classcreate) method, instead, an Array of plain \[JavaScript objects\](#type-object) are passed as \[attr:DynamicForm.items\](#attr-dynamicformitems) when the form is created.

See the \[class:DynamicForm\](#class-dynamicform) documentation for details and sample code.

---
## Class: CancellationController

### Description
Provides a mechanism for canceling asynchronous operations.

---
## Method: ValuesManager.filterData

### Description
Retrieve data that matches the provided criteria, and edit the first record returned.  
Differs from \[method:DynamicForm.fetchData\](#method-dynamicformfetchdata) in that a case insensitive substring match will be performed against the criteria to retrieve the data.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| criteria | [Criteria](#type-criteria) | true | — | search criteria |
| callback | [DSCallback](#type-dscallback) | true | — | callback to invoke on completion |
| requestProperties | [DSRequest](#type-dsrequest) | true | — | additional properties to set on the DSRequest that will be issued |

### Groups

- dataBoundComponentMethods

---
## ClassAttr: PickList.selectAllStoredValue

### Description
Special constant used to indicate that choosing this value from the \[attr:PickList.specialValues\](#attr-picklistspecialvalues) list should result in selecting all of the values of the field. Only for use with `specialValues` - cannot be used elsewhere.  
This attribute may only be used when all matching records are being loaded, not when data paging is in use.

**Flags**: IR

---
## Method: ListGrid.setFixedRecordHeights

### Description
Setter for \[attr:ListGrid.fixedRecordHeights\](#attr-listgridfixedrecordheights)

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| fixedRecordHeights | [boolean](#type-boolean) | false | — | New fixedRecordHeights value |

---
## Attr: PresetCriteriaItem.shouldSaveValue

### Description
Should this item's value be saved in the form's values and hence returned from \[form.getValues()\](#method-dynamicformgetvalues)?

`shouldSaveValue:false` is used to mark formItems which do not correspond to the underlying data model and should not save a value into the form's \[values\](#attr-dynamicformvalues). Example includes visual separators, password re-type fields, or checkboxes used to show/hide other form items.

A `shouldSaveValue:false` item should be given a value either via \[attr:FormItem.defaultValue\](#attr-formitemdefaultvalue) or by calling \[form.setValue(item, value)\](#method-dynamicformsetvalue) or \[formItem.setValue(value)\](#method-formitemsetvalue). Providing a value via \[form.values\](#attr-dynamicformvalues) or \[form.setValues()\](#method-dynamicformsetvalues) will automatically switch the item to `shouldSaveValue:true`.

Note that

*   if an item is shouldSaveValue true, but has no name, a warning is logged, and shouldSaveValue will be set to false.

### Groups

- formValues

**Flags**: IR

---
## Attr: SearchForm.canEditFieldAttribute

### Description
This property is overridden in SearchForm to allow editing of dataSource fields marked as `canFilter:true` by default.

### See Also

- [DataBoundComponent.canEditFieldAttribute](#attr-databoundcomponentcaneditfieldattribute)

**Flags**: IRA

---
## Attr: AnimateShowEffect.endsAt

### Description
Use \[attr:AnimateShowEffect.endAt\](#attr-animateshoweffectendat) instead.

**Deprecated**

**Flags**: IR

---
## Attr: OperationBinding.groupBy

### Description
List of fields to group by when using \[server-side summarization\](#group-serversummaries).

Valid only for an operation of type "fetch". See the \[Server Summaries overview\](#group-serversummaries) for details and examples of usage.

### Groups

- serverSummaries

### See Also

- [OperationBinding.summaryFunctions](#attr-operationbindingsummaryfunctions)

**Flags**: IR

---
## Attr: HTMLFlow.supportsContentsAsPage

### Description
Can this component have its \[attr:HTMLFlow.contents\](#attr-htmlflowcontents) specified as a complete standalone HTML page to be rendered into an embedded IFRAME?

If true, if \[type:ContentsType\](#type-contentstype) is specified as, or \[derived to be\](#attr-htmlflowautoderivecontentstype) "page", the contents will be rendered into an embedded IFRAME using the `srcdoc` attribute rather than written directly into the component handle.

If false, contentsType has no effect unless contents are being loaded from an explicitly specified \[attr:HTMLFlow.contentsURL\](#attr-htmlflowcontentsurl)

**Flags**: IRW

---
## Attr: HiliteViaAIProgressDialog.title

### Description
Title for this Window, shown if \[showTitle\](#attr-windowshowtitle) is true in the \[header\](#attr-windowheader) (if drawn).

### Groups

- i18nMessages

**Flags**: IRW

---
## ClassMethod: SelectionOutline.getLabelBackgroundColor

### Description
Returns the background color for the selection label.

---
## Attr: Layout.membersMargin

### Description
Space between each member of the layout.

Requires a manual call to `reflow()` if changed on the fly.

### Groups

- layoutMargin

**Flags**: IRW

---
## Attr: Facet.cellAlign

### Description
Default alignment of cells (in the body) for this facet.

#### Note:
 This property is specific to \[CubeGrids\](#class-cubegrid).

### See Also

- [CubeGrid.cellAlign](#attr-cubegridcellalign)

**Flags**: IR

---
## ClassMethod: DataSource.getSimpleErrors

### Description
Getter method for extracting server-side validation errors for an attempted "update" or "add" operation, as a JS Object where each property name is a field name from the record and each property value is an array of error message strings. For example:

     {
         userId : \["A user with this userId already exists"\],
         orderId : \["Must be a numeric value", "No Order with ID '6A18294' exists"\]
     }
 

The Java API DSResponse.addError(fieldName, errorMessage) is used to send server-side errors to the client. See the Java Server Reference for details.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| dsResponse | [DSResponse](#type-dsresponse) | false | — | response from which you want to extract the errors |

### Returns

`[Object](#type-object)` — Map of fieldName to error messages for the errors included in the DSResponse.

### Groups

- errorHandling

---
## Attr: StyleSetting.editorProperties

### Description
FormItem properties to apply to editors for this setting.

**Flags**: IR

---
## Method: Menu.setItemProperties

### Description
Set arbitrary properties for a particular menu item.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| item | [MenuItem](#type-menuitem)|[int](#type-int) | false | — | MenuItem or visible index of the MenuItem |
| properties | [MenuItem Properties](#type-menuitem-properties) | false | — | properties to apply to the item |

---
## Object: StyleGroup

### Description
An ordinary JavaScript object with properties that define an editable group of \[settings\](#object-stylesetting) for use in \[class:CSSEditor\](#class-csseditor)s.

---
## Method: WebService.callOperation

### Description
Invoke a web service operation.

The `data` parameter will be serialized to XML to form the input message for the operation, as described by \[method:DataSource.xmlSerialize\](#method-datasourcexmlserialize). Namespacing, element ordering, and SOAP encoding rules are automatically followed. If the web service you are trying to contact requires a complicated nested structure, consider using \[attr:WSRequest.useFlatFields\](#attr-wsrequestuseflatfields) to simplify the required JavaScript input data.

The `resultType` selects what part of the message should be decoded to JavaScript and made available as the "data" variable in the callback. The `resultType` parameter can be either:

*   an XPath. "data" will be always be an Array, containing the selected elements as decoded by \[classMethod:XMLTools.toJS\](#classmethod-xmltoolstojs). All properties will have String value.
*   the name of an XML Schema type found somewhere in the response. You can use the WSDL tab of the Developer Console to analyze the WSDL file for an appropriate type name. "data" will be an Array, containing the decoded elements as decoded by \[method:DataSource.recordsFromXML\](#method-datasourcerecordsfromxml). In this case, since the XML Schema type of the selected data is known, properties will have correct type (eg "date" fields will have JavaScript Date objects)
*   null. "data" will an Object representing the entire <SOAP:Body> as decoded to JavaScript. As above, properties will have correct type.

In the callback, you also receive the XML document returned by the web service as "xmlDoc".

NOTE: `callOperation()` is appropriate for simple operations that do not involve DataBound Components, such as logging into a web service, or retrieving simple String data. `callOperation()` can also be used to retrieve small, read-only datasets such as the option list for a SelectItem, but only if the dataset is guaranteed to remain small enough for paging to be unnecessary. For any larger datasets or anything that will be edited, DataSource integration is more appropriate.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| operationName | [String](#type-string) | false | — | Name of the operation to invoke |
| data | [Object](#type-object) | false | — | data to serialize as XML to form the inbound message of the operation |
| resultType | [Type](#type-type)|[ElementName](#type-elementname)|[XPath](#type-xpath) | false | — | Type, Element name, or XPath that should be selected from the result. For XPaths, see \[attr:WSRequest.xmlNamespaces\](#attr-wsrequestxmlnamespaces) for available namespace prefixes and how to add more. |
| callback | [Callback](#type-callback) | false | — | Callback to invoke on completion. Signature callback(data, xmlDoc, rpcResponse, wsRequest) |
| requestProperties | [WSRequest Properties](#type-wsrequest-properties) | false | — | Additional properties for the WSRequest, such as HTTPHeaders |

### Groups

- webService

---
## Method: EditPane.makePaletteNode

### Description
Creates a \[object:PaletteNode\](#object-palettenode) from an \[object:EditNode\](#object-editnode) in this context's \[editNodeTree\](#method-editpanegeteditnodetree).

This essentially creates a new \[object:PaletteNode\](#object-palettenode) with the \[attr:EditNode.defaults\](#attr-editnodedefaults) from the passed `editNode`. The returned `paletteNode` could then be used with \[method:EditContext.addFromPaletteNode\](#method-editcontextaddfrompalettenode) to effectively create a copy of the original editNode - specifically a new editNode with a new \[attr:EditNode.liveObject\](#attr-editnodeliveobject) created from the same defaults.

However note that `makePaletteNode()` does not copy descendant nodes - use \[method:EditPane.makePaletteNodeTree\](#method-editpanemakepalettenodetree) for that.

May return null if the passed editNode cannot validly by transformed into a paletteNode, for example if \[attr:EditNode.canDuplicate\](#attr-editnodecanduplicate) was set false.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| editNode | [EditNode](#type-editnode) | false | — | the editNode to use to make a paletteNode |

### Returns

`[PaletteNode](#type-palettenode)` — paletteNode derived from the editNode or null

---
## Attr: RESTAuthentication.authToken

### Description
For a \[RestConnector DataSource\](#group-serverrestconnector) using \[bearerToken authentication\](#type-restauthenticationtype), the token to use. This attribute is for use when you are using bearerToken auth with a long-lived token, such as a fixed API key, rather than a regularly changing refresh/accept pattern. If you need to use the refresh/accept token pattern, omit this attribute and instead declare an \[authentication dataSource\](#attr-restauthenticationdatasource)

### Groups

- serverRestConnector

**Flags**: IR

---
## Attr: TestFunctionResult.result

### Description
When a formula or summary format is valid, _result_ contains the result returned by the generated function when it was executed.

### Groups

- formulaFields

**Flags**: IRW

---
## Attr: StretchImgButton.iconWidth

### Description
Width in pixels of the icon image.

If unset, defaults to \[iconSize\](#attr-statefulcanvasiconsize).

### Groups

- buttonIcon

**Flags**: IR

---
## Attr: PrintProperties.omitControls

### Description
An array of Strings indicating the classNames of controls that should be omitted from printing. By default, `omitControls` includes all button-based controls, menus and similar interactive controls that are typically useless in printed output.

All subclasses of the specified classes are also omitted.

See also \[attr:PrintProperties.includeControls\](#attr-printpropertiesincludecontrols).

### Groups

- printing

**Flags**: IR

---
## ClassAttr: Reify.serverURL

### Description
URL of Reify server to use when calling \[method:Reify.loadProject\](#method-reifyloadproject). This URL is assumed to only specify the server root, so \[classAttr:Reify.projectLoaderPath\](#classattr-reifyprojectloaderpath) will be appended to it when sending the actual request. Can be overridden by \[attr:LoadProjectSettings.serverURL\](#attr-loadprojectsettingsserverurl).

Note that, unless this URL is on your local VPN, it is recommended to use `https` to protect your login credentials.

**Flags**: IRW

---
## Attr: SummarizeRecordsResult.recordSummaries

### Description
If any batch is non-successful or the \[attr:SummarizeRecordsRequest.aiFieldRequest\](#attr-summarizerecordsrequestaifieldrequest) is \[numerical\](#classmethod-aiisaifieldrequestnumerical), `null`; otherwise, the generated summaries (text) or unordered categories for the corresponding \[records\](#attr-summarizerecordsrequestrecords) of the \[request\](#object-summarizerecordsrequest).

### See Also

- [SummarizeRecordsResult.recordNumericalSummaries](#attr-summarizerecordsresultrecordnumericalsummaries)

**Flags**: IR

---
## Attr: LoadProjectSettings.allowPlaceholders

### Description
Should \[Placeholders\](#class-placeholder) in loaded screens be rendered as placeholders? If property is not set actual components are created instead of the Placeholders.

**Flags**: IR

---
## Method: FacetChart.getMinContentWidth

### Description
Returns the \[attr:FacetChart.minContentWidth\](#attr-facetchartmincontentwidth) for this facet chart when \[attr:FacetChart.autoScrollContent\](#attr-facetchartautoscrollcontent) is enabled.

### Returns

`[int](#type-int)` — Min content width

---
## Type: StackDirection

### Description
—

### Values

| Value | Description |
|-------|-------------|
| "up" | older messages move up |
| "down" | older messages move down |
| "right" | older messages move right |
| "left" | older messages move left |

---
## Method: Calendar.dateChanged

### Description
Fires whenever the user changes the current date, including picking a specific date or navigating to a new week or month.

---
## Attr: OperationBinding.lineBreakStyle

### Description
The style of line-breaks to use in the exported output. See \[type:LineBreakStyle\](#type-linebreakstyle) for more information.

**Flags**: IR

---
## Attr: MultiPickerItem.expansionWidth

### Description
Width for the \[attr:MultiPickerItem.pickerLayout\](#attr-multipickeritempickerlayout) in expanded mode when \[attr:MultiPickerItem.canExpand\](#attr-multipickeritemcanexpand) is true

**Flags**: IRW

---
## Attr: SplitPane.navigationPane

### Description
An arbitrary widget that is visible in all configurations when the \[currentPane\](#attr-splitpanecurrentpane) is "navigation" (it may also be visible when the `currentPane` is "list" or "detail").

The `navigationPane` is typically used for navigation, to initialize the content of the \[listPane\](#attr-splitpanelistpane) (when using a `listPane`) or the \[detailPane\](#attr-splitpanedetailpane). For example, in an email application the `navigationPane` pane widget could be a \[class:TreeGrid\](#class-treegrid) of the inboxes and folders.

**Flags**: IRW

---
## Attr: DataSourceField.description

### Description
An optional description of the DataSourceField's meaning. It is not automatically exposed on any component, but it is useful for developer documentation, and as such it is included on any \[OpenAPI specification\](#group-openapisupport) generated by the framework. Markdown is a commonly-used syntax, but you may also embed HTML content. When embedding HTML in the description in a .ds.xml file (see \[group:dataSourceDeclaration\](#group-datasourcedeclaration)), it is recommended to wrap the HTML in a CDATA tag.

This description is also provided to AI when AI is asked to work with the field. Best practices for the description are:

*   Start with a plain language explanation of what the field represents in the real world, its business concept or core purpose. For example: `order_subtotal` might be "Total price of the customer's order before tax and shipping."
*   If the field involves time, clarify what moment in time the value applies to, and how the value relates to other timestamps in the record. For example: `updated_timestamp` might be "The last time when any value of the record was updated. Always greater or equal to 'created\_timestamp'."
*   If a numeric field, clearly identify the units if there are any.
*   When not \[required\](#attr-datasourcefieldrequired) (i.e. the value may be `NULL`), describe the interpretation of a `NULL` value. Does the absence of a value have a specific meaning, or does it mean that the data is not available, unknown, or pending?
*   If values are constrained within a certain range or domain, identify the bounds or possible values.
*   If values take a certain format, identify this format and fully describe each part.
*   Include descriptions of how the field relates to or depends on others.
*   Give a brief note about how the field is populated. This might include the source of the data, formula(s) used to calculate the value, and the frequency and timing of updates.

Sample values in the description may be appropriate, but a better practice is to provide \[sampleData\](#attr-datasourcesampledata) on the data source, which show AI sample values in the context of complete record(s) from the data source.

### See Also

- [DataSource.description](#attr-datasourcedescription)

**Flags**: IRW

---
## Attr: ListGrid.cellRole

### Description
Returns the default WAI ARIA role for cells within this listGrid. See \[method:ListGrid.getCellRole\](#method-listgridgetcellrole)

**Flags**: IRWA

---
## StaticMethod: Date.getFiscalYear

### Description
Returns the \[object:FiscalYear\](#object-fiscalyear) object for the fiscal year in which the passed date exists.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| date | [Date](#type-date)|[int](#type-int) | false | — | the date to get the fiscal year for |
| fiscalCalendar | [FiscalCalendar](#type-fiscalcalendar) | true | — | the object representing the start of the fiscal period |

### Returns

`[FiscalYear](#type-fiscalyear)` — the \[object:FiscalYear\](#object-fiscalyear) object for the passed date

**Deprecated**

---
## ClassMethod: Hover.hide

### Description
Hide hoverCanvas shown via \[classMethod:Hover.show\](#classmethod-hovershow)

---
## Attr: DrawGroup.width

### Description
Width of the \[group rectangle\](#method-drawgroupgetgrouprect) in pixels relative to the \[class:DrawPane\](#class-drawpane) (the "drawing coordinate system").

**Flags**: IRW

---
## Attr: ShowHideTask.showRecursively

### Description
Set to `false` to not show a component's parents.

**Flags**: IR

---
## Method: ListGrid.drawAreaChanged

### Description
Notification method that fires when the drawArea changes due to scrolling. Receives the previous drawArea co-ordinates as parameters. Call \[method:ListGrid.getDrawArea\](#method-listgridgetdrawarea) to get the new drawArea co-ordinates.

Note that if this grid is showing any \[frozen fields\](#attr-listgridfieldfrozen), they will not be included in the `oldStartCol`, `oldEndCol` range reported by this method. Frozen fields are assumed never to be scrolled out of view.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| oldStartRow | [number](#type-number) | false | — | the startRow from before the drawArea changed |
| oldEndRow | [number](#type-number) | false | — | the endRow from before the drawArea changed |
| oldStartCol | [number](#type-number) | false | — | the startCol from before the drawArea changed |
| oldEndCol | [number](#type-number) | false | — | the endCol from before the drawArea changed |

**Flags**: A

---
## Method: SectionStack.setItems

### Description
Sets a new list of canvii as items into the specified section by removing the existing items, then adding the new ones. Initial items for a section should be specified using the property \[attr:SectionStackSection.items\](#attr-sectionstacksectionitems).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| section | [String](#type-string)|[Number](#type-number) | false | — | ID or index of the section to set items on |
| items | [Array of Canvas](#type-array-of-canvas) | false | — | new items to add |

---
## Method: Window.setBodyStyle

### Description
Setter for \[bodyStyle\](#attr-windowbodystyle).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| newBodyStyle | [CSSStyleName](#type-cssstylename) | false | — | new \[styleName\](#attr-canvasstylename) for the \[body\](#attr-windowbody). |

---
## Attr: FilterClause.fieldPickerProperties

### Description
Properties to combine with the \[class:FieldPicker\](#class-fieldpicker) autoChild FormItem.

**Flags**: IR

---
## Attr: TabBar.baseLineSrc

### Description
Sets \[attr:StretchImg.src\](#attr-stretchimgsrc) for the \[group:baseLine\](#group-baseline) StretchImg.

### Groups

- baseLine

**Flags**: IR

---
## Attr: Canvas.hideUsingDisplayNone

### Description
When this widget is hidden (see \[attr:Canvas.visibility\](#attr-canvasvisibility) and \[method:Canvas.hide\](#method-canvashide)), should display:none be applied to the \[outer element\](#method-canvasgetouterelement)?

This setting is not supported for general use, but in certain cases, it has been shown that display:none is a work-around for browser bugs involving burn-through of iframes or plugins, where the content of the iframe or plugin may still be visible despite the containing widget being hidden.

### Groups

- appearance

### See Also

- [Visibility](#type-visibility)

**Flags**: IRA

---
## Attr: PaletteNode.idPrefix

### Description
Prefix used to create unique component ID. If not specified, \[attr:PaletteNode.type\](#attr-palettenodetype) is used.

**Deprecated**

**Flags**: IR

---
## Type: Distance

### Description
A number representing the width, height, or radius of a \[class:DrawItem\](#class-drawitem) in the \[class:DrawPane\](#class-drawpane). \[attr:DrawRect.width\](#attr-drawrectwidth) is an example of a \[class:DrawItem\](#class-drawitem) attribute that's a `Distance`. A `Distance` is not limited to integers except for \[type:DrawingType\](#type-drawingtype) "vml".

---
## Attr: DSRequestModifier.fieldName

### Description
The name of the field to add or replace on the DSRequest - whether this appears in the DSRequest's values or criteria depends on whether this is part of a \[attr:OperationBinding.values\](#attr-operationbindingvalues) or \[attr:OperationBinding.criteria\](#attr-operationbindingcriteria) attribute.

**Flags**: IR

---
## Attr: Calendar.alternateLaneStyles

### Description
When showing a \[Timeline\](#attr-calendartimelineview), or a \[day view\](#attr-calendardayview) when \[attr:Calendar.showDayLanes\](#attr-calendarshowdaylanes) is true, whether to make lane boundaries more obvious by showing alternate lanes in a different color.

**Flags**: IRW

---
## Attr: DataSource.auditUserFieldName

### Description
For DataSources with \[auditing enabled\](#attr-datasourceaudit), specifies the field name used to store the user who performed the operation. If empty string is specified as the field name, the audit DataSource will not store this field.

**Flags**: IR

---
## Attr: RibbonButton.icon

### Description
Icon to show to the left of or above the title, according to the button's \[orientation\](#attr-ribbonbuttonvertical).

When specifying `vertical = true`, this icon will be stretched to the \[attr:RibbonButton.largeIconSize\](#attr-ribbonbuttonlargeiconsize) unless a \[attr:RibbonButton.largeIcon\](#attr-ribbonbuttonlargeicon) is specified.

### Groups

- icon

**Flags**: IRW

---
## Attr: ComboBoxItem.useClientFiltering

### Description
For \[databound\](#attr-comboboxitemoptiondatasource) items, this property will be passed to the generated ResultSet data object for the pickList as \[attr:ResultSet.useClientFiltering\](#attr-resultsetuseclientfiltering). Setting to false will disable filtering on the client and ensure criteria are always passed to the DataSource directly.

**Flags**: IRA

---
## Group: errorIcon

### Description
—

---
## Attr: ListGrid.selectionCanvas

### Description
AutoChild created and embedded in the grid if \[showSelectionCanvas\](#attr-listgridshowselectioncanvas) is `true` and the \[selectionType\](#attr-listgridselectiontype) is "single". This component will be created and displayed above the selected record whenever the selection changes.

NOTE: It is recommended to use the \[selectionUnderCanvas\](#attr-listgridselectionundercanvas) rather than the `selectionCanvas` if possible because the `selectionCanvas` is stacked on top of the selected record and this may interfere with event handling in rare cases. If no interactive components are shown in the `selectionCanvas` and it simply provides custom styling, then the `selectionUnderCanvas` should be used instead.

The `selectionCanvas` has the following read-only attributes set:  
\- `this.grid` - a pointer to the grid  
\- `this.record` - a pointer to the currently selected record in the grid

### Groups

- rowEffects

### See Also

- [ListGrid.selectionUnderCanvas](#attr-listgridselectionundercanvas)

**Flags**: RA

---
## Method: ListGrid.createRecordComponent

### Description
When \[attr:ListGrid.showRecordComponents\](#attr-listgridshowrecordcomponents) is true, this method is called to create per-row or per-cell embedded components to display in the grid.

The colNum parameter is applicable only when \[attr:ListGrid.showRecordComponentsByCell\](#attr-listgridshowrecordcomponentsbycell) is true.

If this row should not have a `recordComponent`, return null.

This method should create and return a new component for the record passed in every time it is called and never return the same Canvas instance twice. To re-use components with different rows, set \[type:RecordComponentPoolingMode\](#type-recordcomponentpoolingmode) to "recycle". In this mode, in addition to implementing this method, developers should also implement \[method:ListGrid.updateRecordComponent\](#method-listgridupdaterecordcomponent) which allows already created components to be altered for re-use in new records. See the \[attr:ListGrid.showRecordComponents\](#attr-listgridshowrecordcomponents) overview for more information.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| record | [ListGridRecord](#type-listgridrecord) | false | — | record to create a component for |
| colNum | [Integer](#type-integer) | false | — | cell to which the component applies |

### Returns

`[Canvas](#type-canvas)` — return the component to embed in the passed record

### Groups

- recordComponents

---
## Attr: SelectItem.pickerNavigationBar

### Description
\[class:NavigationBar\](#class-navigationbar) created when \[attr:SelectItem.pickListPlacement\](#attr-selectitempicklistplacement) indicates that the search interface takes over the entire panel or screen.

### Groups

- panelPlacement

**Flags**: IR

---
## Attr: ListGrid.canShowFilterEditor

### Description
Should a menu item allowing the user to show or hide the \[filter editor\](#attr-listgridshowfiltereditor) be displayed in the \[headerContextmenu\](#attr-listgridheadercontextmenu)?

Note that if this ListGrid is not \[bound to a dataSource\](#attr-listgriddatasource) it can not be filtered. In this case the context menu option to show the filterEditor will not be displayed even if `canShowFilterEditor` is true.

Enabling \[filter via AI\](#attr-listgridfilterviaaimode) forces this setting to true.

### Groups

- filterEditor

### See Also

- [ListGrid.showFilterEditorTitle](#attr-listgridshowfiltereditortitle)
- [ListGrid.hideFilterEditorTitle](#attr-listgridhidefiltereditortitle)

**Flags**: IRW

---
## Method: DynamicForm.getSaveOperationType

### Description
Returns the \[type:DSOperationType\](#type-dsoperationtype) to be performed when \[method:DynamicForm.saveData\](#method-dynamicformsavedata) or \[method:ValuesManager.saveData\](#method-valuesmanagersavedata) is called.  
Valid options are `"add"` or `"update"`.

If a \[object:DSRequest\](#object-dsrequest) configuration object is passed in containing an explicit operationType this will be returned. Otherwise \[this.saveOperationType\](#attr-dynamicformsaveoperationtype) will be returned if set. Note that `saveOperationType` is automatically set via calls to data binding methods such as \[method:DynamicForm.editNewRecord\](#method-dynamicformeditnewrecord), or it may be \[set explicitly\](#method-dynamicformsetsaveoperationtype).

If no explicit saveOperationType is present, the system will use the following heuristic to determine the save operationType:

*   If the form has no value for the \[primaryKey field\](#method-datasourcegetprimarykeyfield) this method will return "add". The assumption is that this is a new record, and the field will be populated when the record is created, (as with a "sequence" type field).
*   If, ${isc.DocUtils.linkForRef('method:DynamicForm.setValues','when the form\\'s values were populated')}, the form had value for the \[primaryKey field\](#method-datasourcegetprimarykeyfield) but it has subsequently be changed, this method will return "add". In this case the value has been changed, either by the user or programmatically so a different (new) record is assumed. This is determined by looking at the \[oldValues\](#method-dynamicformgetoldvalues) for the form.
*   If the \[primaryKey field\](#method-datasourcegetprimarykeyfield) is editable and a value is now present for the primary key field, but was not present in the \[oldValues\](#method-dynamicformgetoldvalues) for the form, this method will return "add". In this case either no initial values were provided, or a 'sparse' set of values for a new record (with no primary key) were provided to the form and the user has subsequently explicitly entered a new primaryKey field value.
*   Otherwise this method will return "update". Either the primaryKey field is non editable, or the user has not changed it from its initial value.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| requestProperties | [DSRequest Properties](#type-dsrequest-properties) | true | — | Optional DSRequest config block for the save operation |

### Returns

`[DSOperationType](#type-dsoperationtype)` — Operation type for the save request.

---
## Attr: Calendar.hideUnusedLanes

### Description
When set to true, hides any \[lane\](#attr-calendarlanes) that doesn't have any active events in the current dataset.

**Flags**: IRW

---
## Attr: PaletteNode.idName

### Description
Name used to create unique component ID. If not specified, \[attr:PaletteNode.type\](#attr-palettenodetype) is used.

Note: idName must follow all rules for a \[type:Identifier\](#type-identifier).

**Flags**: IR

---
## Attr: MultiFilePicker.showInWindow

### Description
If set true, the picker will be displayed inside a Window.

**Flags**: IR

---
## Attr: ListGrid.canSaveSearches

### Description
When enabled (the default), causes a "Saved views >" submenu to appear in the header context menu, last, allowing the user to create new saved searches, select previously saved searches, and edit or copy existing searches.

Note that disabling this feature does not mean that saved searches are disallowed - you can stil implement a separate UI via a \[class:SavedSearchItem\](#class-savedsearchitem) that targets this component. But, when disabled, the grid-integrated menu described above will not be shown.

This feature uses the global settings found in \[class:SavedSearches\](#class-savedsearches). Some aspects can be overridden for this component. See \[attr:ListGrid.savedSearchDS\](#attr-listgridsavedsearchds), \[attr:ListGrid.savedSearchAdminRole\](#attr-listgridsavedsearchadminrole).

To avoid leaking local storage, this setting will be disregarded, disabling the feature, unless the grid specifies \[savedSearchId\](#attr-databoundcomponentsavedsearchid), or an explicit \[local or global ID\](#method-canvasgetlocalid) is present.

#### Note:
 this feature requires [SmartClient Pro](https://www.smartclient.com/product/) or better.

**Flags**: IR

---
## Attr: DSResponse.fromOfflineCache

### Description
If set, indicates that this response came from the offline cache, not the server. This flag is the only reliable way for application code to determine the source of a response.

### Groups

- offlineGroup

**Flags**: R

---
## Attr: DetailViewerField.target

### Description
By default, clicking a link rendered by this item opens it in a new browser window. You can alter this behavior by setting this property. The value of this property will be passed as the value to the `target` attribute of the anchor tag used to render the link. `target` is applicable only if the field type is set to "link".

### See Also

- [DetailViewerField.type](#attr-detailviewerfieldtype)

**Flags**: IRW

---
## Method: DataSource.getFieldOperatorMap

### Description
Get the list of \[object:Operator\](#object-operator)s available for this field, as a \[type:ValueMap\](#type-valuemap) from \[type:OperatorId\](#type-operatorid) to the \[attr:Operator.title\](#attr-operatortitle) specified for the \[object:Operator\](#object-operator), or the corresponding property in \[class:Operators\](#class-operators) if \[attr:Operator.titleProperty\](#attr-operatortitleproperty) is set.

This valueMap is suitable for use in a UI for building queries, similar to the \[class:FilterBuilder\](#class-filterbuilder), and optionally omits operators marked \[attr:Operator.hidden\](#attr-operatorhidden):true.

It is also possible to have this function return only operators of a given \[type:OperatorValueType\](#type-operatorvaluetype), or everything except operators of that type. This is useful, for example, if you want to return all the logical operators (like "and"), or everything except the logical operators.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| field | [String](#type-string)|[DataSourceField](#type-datasourcefield) | false | — | Field (or field name) to obtain operator map for. |
| includeHidden | [boolean](#type-boolean) | true | — | whether to include Operators marked hidden:true |
| valueType | [OperatorValueType](#type-operatorvaluetype) | true | — | If passed, returns only operators of this \[type:OperatorValueType\](#type-operatorvaluetype) |
| omitValueType | [boolean](#type-boolean) | true | — | If set, reverses the meaning of the `valueType` parameter, so operators of that \[type:OperatorValueType\](#type-operatorvaluetype) are the only ones omitted |

### Returns

`[ValueMap](#type-valuemap)` — mapping from \[type:OperatorId\](#type-operatorid) to title, as described above

### Groups

- advancedFilter

### See Also

- [DataSource.getTypeOperatorMap](#method-datasourcegettypeoperatormap)

---
## Attr: DrawnValue.facetValues

### Description
FacetValues for the data value.

**Flags**: IR

---
## Method: ListGrid.redrawHeader

### Description
Redraw just the \[grid header\](#attr-listgridheader)

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| rightNow | [boolean](#type-boolean) | false | — | If true, redraw the grid header with a direct inline call to its redraw() method. Otherwise, \[mark the header for redraw\](#method-canvasmarkforredraw) |

---
## Attr: Calendar.canEditSublane

### Description
Can events be moved between sublanes?

If so, the event can be dragged to a different \[sublane\](#attr-lanesublanes) within the same parent Lane and, when it's editor is shown, an additional drop-down widget is provided allowing the sublane to be altered.

If the sublane is locked, but the \[parent lane\](#attr-calendarcaneditlane) isn't, an update to the event's \[lane name\](#attr-calendarlanenamefield) will be allowed, assuming that the new Lane has an existing sublane with the same name.

In either case, the event's \[sublane\](#attr-calendarsublanenamefield) is updated automatically.

This setting can be overridden on each \[event\](#attr-calendareventcaneditsublane).

**Flags**: IR

---
## Method: ListGrid.getValueIcon

### Description
Returns the appropriate valueIcon for a cell based on the field and the data value for the cell. Default implementation returns null if \[attr:ListGridField.suppressValueIcon\](#attr-listgridfieldsuppressvalueicon) is true otherwise looks at \[attr:ListGridField.valueIcons\](#attr-listgridfieldvalueicons).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| field | [ListGridField](#type-listgridfield) | false | — | field associated with the cell |
| value | [Any](#type-any) | false | — | data value for the cell's record in this field. |
| record | [ListGridRecord](#type-listgridrecord) | false | — | record associated with this cell |

### Returns

`[SCImgURL](#type-scimgurl)` — url for the icon

### Groups

- imageColumns

---
## Attr: EventCanvas.bodyStyle

### Description
CSS class for the \[body area\](#attr-eventcanvasshowbody) of the EventCanvas. If unset, defaults to the \[base styleName\](#attr-eventcanvasstylename) with the suffix "Body".

### Groups

- appearance

**Flags**: IRW

---
## Class: DateRangeDialog

### Description
Simple modal dialog for collecting a date range from the end user.

---
## Method: Callbacks.AIResponseCallback

### Description
Callback fired when a response is received from an AI engine.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| aiResponse | [AIResponse](#type-airesponse) | false | — | The response. |
| aiRequest | [AIRequest](#type-airequest) | false | — | The original request. |

---
## Attr: Tour.stepActionButtonTitle

### Description
Default value for \[attr:TourStep.actionButtonTitle\](#attr-tourstepactionbuttontitle) for steps other than the first and last ones.

Default titles for the first and last steps are configured by \[firstStepActionButtonTitle\](#attr-tourfirststepactionbuttontitle) and \[lastStepActionButtonTitle\](#attr-tourlaststepactionbuttontitle) respectively.

### Groups

- i18nMessages

### See Also

- [Tour.stepCancelButtonTitle](#attr-tourstepcancelbuttontitle)

**Flags**: IR

---
## Attr: DataQuestionSettings.applicationPurpose

### Description
A human-readable (and thus AI-readable) description of the purpose of the application.

**Flags**: IR

---
## Attr: TabSet.titleEditorProperties

### Description
Properties for the auto-generated \[attr:TabSet.titleEditor\](#attr-tabsettitleeditor). This is the text item we use to edit tab titles in this tabSet.

### See Also

- [TabSet.titleEditor](#attr-tabsettitleeditor)
- [TabSet.canEditTabTitles](#attr-tabsetcanedittabtitles)

**Flags**: IR

---
## Method: FacetChart.getChartWidth

### Description
Get the width of the central chart area, where data elements appear.

This is only allowed to be called when \[method:FacetChart.chartDrawn\](#method-facetchartchartdrawn) fires.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| recalc | [boolean](#type-boolean) | false | — | if false then cached value will be returned, otherwise will be recalculated. |

### Returns

`[float](#type-float)` — the width of the central chart area.

---
## Attr: HiliteRule.removeIconSize

### Description
When set, dictates the size of the \[remove button\](#attr-hiliteruleremovebutton) shown for this HiliteRule.

**Flags**: IR

---
## Attr: Validator.validateOnChange

### Description
If true, validator will be validated when each item's "change" handler is fired as well as when the entire form is submitted or validated. If false, this validator will not fire on the item's "change" handler.

Note that this property can also be set at the form/grid or field level; If true at any level and not explicitly false on the validator, the validator will be fired on change - displaying errors and rejecting the change on validation failure.

**Flags**: IRW

---
## Attr: ToolStripSpacer.space

### Description
Size of spacer. If not specified, spacer fills remaining space.

**Flags**: IR

---
## ClassAttr: ListGrid.INCREMENTAL

### Description
A declared value of the enum type \[type:GroupTreeChangeType\](#type-grouptreechangetype)

**Flags**: R

---
## Attr: Snapbar.showRollOver

### Description
Snapbars show rollover styling.

**Flags**: IRW

---
## ClassMethod: DateUtil.setShowChooserFiscalYearPickers

### Description
Sets the global attribute that dictates whether the \[choosers\](#class-datechooser) shelled from \[DateItems\](#class-dateitem) show a UI for working with Fiscal Years.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| showChooserFiscalYearPickers | [boolean](#type-boolean) | false | — | whether to show Fiscal Year pickers in DateChoosers by default |

---
## StaticMethod: isc.shallowClone

### Description
Creates a shallow copy of the passed-in Object or Array of Objects, that is, copies all properties of an Object to a new Object, so that the clone now has exactly the same property values as the original Object.

If `shallowClone()` is passed an immutable type such as String and Number, it is returned unchanged. Dates are copied via `new Date(originalDate.getTime())`.

Note that if an Array is passed, all non-Array elements of the Array will be shallow cloned. For a copy of an Array that contains exactly the same elements (not copies), use Array.duplicate().

Only an Array directly passed to `shallowClone()` is copied. Arrays contained within Arrays will not be copied.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| object | [Object](#type-object)|[Array](#type-array)|[Object](#type-object) | false | — | object to be cloned |

### Returns

`[Object](#type-object)|[Array of Object](#type-array-of-object)` — a shallow copy of the passed-in data

---
## Method: ProcessElement.getEditorType

### Description
Returns the workflow task editor type to be used edit instances of this type of process element. The default implementation returns `this.editorType` but a custom override could determine an editor type based on the property values.

---
## Attr: ListGridRecord.backgroundComponent

### Description
Has no effect unless \[attr:ListGrid.showBackgroundComponents\](#attr-listgridshowbackgroundcomponents) is `true`.

Canvas created and embedded in the body behind a given record. When set, either as a Canvas or Canvas Properties, will be constructed if necessary, combined with the autoChild properties specified for \[attr:ListGrid.backgroundComponent\](#attr-listgridbackgroundcomponent) and displayed behind this record in the page's z-order, meaning it will only be visible if the cell styling is transparent.

### Groups

- rowEffects

**Flags**: IR

---
## ClassAttr: FacetChart.chartTypeColumnTitle

### Description
Title for the `"Column"` item in the `"Chart Type"` submenu in the context menu.

### Groups

- i18nMessages

**Flags**: IRW

---
## Attr: OperationBinding.multiInsertNonMatchingStrategy

### Description
For "add" operations on dataSources of \[serverType\](#attr-datasourceservertype) "sql" only, this property sets the multi-insert "non matching" strategy for this \[operation\](#class-operationbinding). Only has an effect if the \[add request\](#method-datasourceadddata) specifies a list of records as the data, and only if \[multiInsertStrategy\](#attr-operationbindingmultiinsertstrategy) is set to "multipleValues" either globally or at the \[DSRequest\](#object-dsrequest), \[OperationBinding\](#class-operationbinding), or \[DataSource\](#class-datasource) level.

Note that this setting overrides the equivalent \[dataSource setting\](#attr-datasourcemultiinsertnonmatchingstrategy), and can in turn be overridden at the \[DSRequest level\](#attr-dsrequestmultiinsertnonmatchingstrategy)

### See Also

- [OperationBinding.multiInsertStrategy](#attr-operationbindingmultiinsertstrategy)
- [OperationBinding.multiInsertBatchSize](#attr-operationbindingmultiinsertbatchsize)

**Flags**: IRW

---
## Method: ListGrid.updateData

### Description
Perform a DataSource "update" operation to update existing records in this component's DataSource.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| updatedRecord | [Record](#type-record) | false | — | updated record |
| callback | [DSCallback](#type-dscallback) | true | — | method to call on operation completion |
| requestProperties | [DSRequest Properties](#type-dsrequest-properties) | true | — | additional properties to set on the DSRequest that will be issued |

### Groups

- dataBoundComponentMethods

---
## Method: GridRenderer.rowMouseDown

### Description
Called when a row receives a mousedown event.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| record | [ListGridRecord](#type-listgridrecord) | false | — | record object returned from 'getCellRecord()' |
| rowNum | [number](#type-number) | false | — | row number for the cell |
| colNum | [number](#type-number) | false | — | column number of the cell |

### Returns

`[boolean](#type-boolean)` — whether to cancel the event

### Groups

- events

**Flags**: A

---
## Attr: AdaptiveMenu.inlineImgButton

### Description
\[class:ToolStripButton\](#class-toolstripbutton) to display when \[attr:AdaptiveMenu.showIconOnlyInline\](#attr-adaptivemenushowicononlyinline) is set for one \[object:MenuItem\](#object-menuitem)

**Flags**: R

---
## Attr: ListGrid.summaryRowDataSource

### Description
If \[attr:ListGrid.showGridSummary\](#attr-listgridshowgridsummary) is true, by default summary values are calculated on the client based on the current data-set for the grid (see \[method:ListGrid.getGridSummary\](#method-listgridgetgridsummary) and \[method:ListGrid.getGridSummaryFunction\](#method-listgridgetgridsummaryfunction)).

In some cases however it may make sense to calculate summary values on the server and retrieve them via a dataSource fetch. If set, this property specifies a dataSource to fetch against for the summary row.

The fetch may be further customized via \[attr:ListGrid.summaryRowCriteria\](#attr-listgridsummaryrowcriteria) and \[attr:ListGrid.summaryRowFetchRequestProperties\](#attr-listgridsummaryrowfetchrequestproperties). Note that if \[attr:ListGrid.maxSummaryRowRecords\](#attr-listgridmaxsummaryrowrecords) is specified this will be passed to the server as the \[attr:DSRequest.endRow\](#attr-dsrequestendrow) for the summaryRowFetchRequest. Developers may modify this property in order to display multiple summaryRowRecords from a summaryRowDataSource fetch

Note that specifying a `summaryRowDataSource` completely bypasses the standard client-side grid summary calculation logic.

**Flags**: IRA

---
## Method: Tree.openAll

### Description
Open all nodes under a particular node.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| node | [TreeNode](#type-treenode)|[String](#type-string)|[Integer](#type-integer)|[NodeLocator](#type-nodelocator) | true | — | node from which to open folders, or the node's ID, or a NodeLocator object (if not specified, the root node is used) |

---
## Group: image

### Description
Utilities to render images

---
## Attr: TreeGrid.groupByField

### Description
Not applicable to TreeGrids, as the \[attr:TreeGrid.data\](#attr-treegriddata) already represents a tree.

### Groups

- grouping

### See Also

- [TreeGrid.groupBy](#method-treegridgroupby)

**Flags**: IR

---
## Group: performance

### Description
—

---
## Method: Array.add

### Description
Add an object to this list, at the end

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| object | [Any](#type-any) | false | — | object to add |

### Returns

`[Any](#type-any)` — pointer to the object passed in

### Groups

- modification

---
## Method: SpinnerItem.getPreviousValue

### Description
When \[min\](#attr-spinneritemmin) and \[max\](#attr-spinneritemmax) are both null or unspecified, this method is called to get the previous lower value from the currentValue. The default implementation returns (currentValue 
#### +
 step) because the step parameter is based on _the opposite_ of \[this.step\](#attr-spinneritemstep).

To indicate that the given currentValue is the minimum value, return currentValue again.

Implementations should expect to be passed any value for currentValue. Also, if \[attr:SpinnerItem.step\](#attr-spinneritemstep) is non-negative, getPreviousValue() must induce a [monotonically decreasing (non-increasing) function](http://en.wikipedia.org/wiki/Monotonic_function); otherwise, getPreviousValue() must induce a monotonically increasing function.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| currentValue | [number](#type-number) | false | — | the current value of this SpinnerItem |
| step | [number](#type-number) | false | — | a suggested step value based on the opposite of \[this.step\](#attr-spinneritemstep) and how long the user has been continuously decreasing the value. |

### Returns

`[number](#type-number)` — the next higher value

### See Also

- [SpinnerItem.getNextValue](#method-spinneritemgetnextvalue)

**Flags**: A

---
## Attr: TabSet.tabBarProperties

### Description
This attribute allows developers to specify custom properties for this tabset's \[attr:TabSet.tabBar\](#attr-tabsettabbar)

**Flags**: IR

---
## Method: DataSource.compareDates

### Description
Convenience method to compare two Date objects appropriately, depending on whether the passed-in fieldName refers to a field of \[type\](#type-fieldtype) "datetime" or "date". In the former case, the dates are compared using \[classMethod:DateUtil.compareDates\](#classmethod-dateutilcomparedates); in the latter case, or if the supplied fieldName is null or unknown to this DataSource, the dates are compared using \[classMethod:DateUtil.compareLogicalDates\](#classmethod-dateutilcomparelogicaldates).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| date1 | [Date](#type-date) | false | — | First date in comparison |
| date2 | [Date](#type-date) | false | — | Second date in comparison |
| fieldName | [FieldName](#type-fieldname) | false | — | The name of the field for which the comparison is being run |

### Returns

`[Number](#type-number)` — 0 if equal, -1 if first date > second date, 1 if second date > first date

**Flags**: A

---
## Attr: MenuItem.keyTitle

### Description
A string to display in the shortcut-key column for this item. If not specified, the first KeyName value in \[attr:MenuItem.keys\](#attr-menuitemkeys) will be used by default.

### Groups

- menuKeys

**Flags**: IR

---
## ClassMethod: Class.fireCallback

### Description
Fire some arbitrary action specified as a \[type:Callback\](#type-callback). Returns the value returned by the action.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| callback | [Callback](#type-callback) | false | — | Action to fire. |
| argNames | [String](#type-string) | true | — | Comma separated string of variable names. If the callback passed in was a string of script, any arguments passed to the callback will be available as local variables with these names. |
| args | [Array](#type-array) | true | — | Array of arguments to pass to the method. Note that the number of arguments should match the number of argNames. |
| target | [Object](#type-object) | true | — | If specified the callback will be evaluated in the scope of this object - the `this` keyword will be a pointer to this target when the callback is fired. |

### Returns

`[Any](#type-any)` — returns the value returned by the callback method passed in.

---
## Method: DataSource.setCacheAllData

### Description
Call this method to switch cacheAllData on or off after initialization. Passing a `shouldCache` value of false clears any existing client-side cache, cancels any outstanding requests for a full cache and issues any other pending requests normally.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| shouldCache | [Boolean](#type-boolean) | false | — | New value for \[attr:DataSource.cacheAllData\](#attr-datasourcecachealldata) |

### Groups

- clientData

---
## Attr: DrawItem.keepInParentRect

### Description
Constrains drag-resizing and drag-repositioning of this draw item to either the current visible area of the \[draw pane\](#class-drawpane) or an arbitrary bounding box (if set to an array of the form `[left, top, left + width, top + height]`). When using a bounding box-type argument the left/top values can be negative, or the width/height values can be greater than the dimensions of the viewable area, to allow positioning or resizing the draw item beyond the confines of the draw pane.

Note: keepInParentRect affects only user drag interactions, not programmatic moves or resizes.

**Flags**: IRWA

---
## Method: TreeGrid.isExportingClientData

### Description
Returns true if this component is currently \[exporting client data\](#method-treegridexportclientdata). This method can be called from custom cell formatters if you need to return a different formatted value for an export than for a live TreeGrid

### Returns

`[boolean](#type-boolean)` — returns true if this component is currently exporting client data

### See Also

- [TreeGrid.exportClientData](#method-treegridexportclientdata)

---
## ClassAttr: RPCManager.defaultTimeout

### Description
In milliseconds, how long the RPCManager waits for an RPC request to complete before returning an error.

Default of 240000 milliseconds is four minutes. If set to zero, the RPCManager will not enforce a timeout, however, see \[attr:RPCRequest.timeout\](#attr-rpcrequesttimeout) for a discussion of default timeouts that are built into browsers.

**Flags**: RW

---
## Attr: Canvas.left

### Description
Number of pixels the left side of the widget is offset to the right from its default drawing context (either its parent's topleft corner, or the document flow, depending on the value of the \[attr:Canvas.position\](#attr-canvasposition) property).

Can also be set as a percentage, specified as a String ending in '%', eg, "50%". In this case the top coordinate is considered as a percentage of the specified width of the \[parent\](#method-canvasgetparentcanvas).

### Groups

- positioning

**Flags**: IRW

---
## Attr: DataSourceField.title

### Description
Default user-visible title for this field.

This will be picked up by \[interface:DataBoundComponent\](#interface-databoundcomponent)s and other views over this data source.

Note this property frequently does not need to be set since \[attr:DataSource.autoDeriveTitles\](#attr-datasourceautoderivetitles) (on by default) usually picks an appropriate user-visible title if you have a reasonable naming convention for your field names.

Note that if this field is being displayed in a \[class:ListGrid\](#class-listgrid) bound to this data source, the \[attr:ListGridField.headerTitle\](#attr-listgridfieldheadertitle) attribute may be used to specify a different string for display in the column header.

### Groups

- componentBinding

### See Also

- [Field.exportTitle](#attr-fieldexporttitle)

**Flags**: IRW

---
## Method: Gauge.setLabelPrefix

### Description
Sets the \[labelPrefix\](#attr-gaugelabelprefix) property and re-creates all sector labels.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| labelPrefix | [String](#type-string) | false | — | the new label prefix. |

---
## Attr: EditPane.canGroupSelect

### Description
Should a group selection outline covering the outermost bounding boxes of all selected components be shown in this container?

Treated as `true` if not set and hoop selection is enabled (see \[attr:EditProxy.canSelectChildren\](#attr-editproxycanselectchildren) and \[selectionType\](#attr-editcontextselectiontype).

**Flags**: IR

---
## Attr: Button.iconSpacing

### Description
Pixels between icon and title text.

### Groups

- buttonIcon

**Flags**: IR

---
## Method: SavedSearchForm.searchChanged

### Description
Event fired whenever a user changes the currently selected saved search, modifies a saved search or adds a new saved search.

If a \[attr:SavedSearchForm.targetComponent\](#attr-savedsearchformtargetcomponent) has been specified, `searchChanged` automatically applies the new search to the `targetComponent` unless the event is cancelled by returning false.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| newCriteria | [Criteria](#type-criteria) | false | — | new criteria |
| searchData | [String](#type-string) | false | — | search data |

### Returns

`[boolean](#type-boolean)` — whether to automatically apply the search to the \[attr:SavedSearchForm.targetComponent\](#attr-savedsearchformtargetcomponent)

---
## Attr: Window.fillSpaceStyleName

### Description
Alternative style for the window used whenever \[attr:Window.placement\](#attr-windowplacement) settings indicate the menu will be filling a portion of the screen or a panel. Generally this alternative style should not have rounded or excessively large edges.

**Flags**: IR

---
## Method: PickList.getPickListFilterCriteria

### Description
\[StringMethod\](#group-stringmethods) to return a set of filter criteria to be applied to the data displayed in the pickList when it is shown.

If this is a databound item the criteria will be passed as criteria to \[method:DataSource.fetchData\](#method-datasourcefetchdata). Otherwise an equivalent client-side filter will be performed on the data returned by \[method:PickList.getClientPickListData\](#method-picklistgetclientpicklistdata).

By default combines \[attr:FormItem.optionCriteria\](#attr-formitemoptioncriteria) with \[attr:PickList.pickListCriteria\](#attr-picklistpicklistcriteria) if specified, otherwise an empty set of criteria so all records will be displayed.

Note that if no \[optionCriteria\](#attr-formitemoptioncriteria) are present and \[pickListCriteria\](#attr-picklistpicklistcriteria) were specified as a simple criteria object rather than an \[object:AdvancedCriteria\](#object-advancedcriteria), the generated fetch operation to populate the pickList will contain these simple criteria (and \[pickList.textMatchStyle\](#attr-picklisttextmatchstyle) will determine how these criteria are interpreted).  
However if \[optionCriteria\](#attr-formitemoptioncriteria) are specified as a simple criteria object, an \[object:AdvancedCriteria\](#object-advancedcriteria) object may be generated for the fetch even if pickListCriteria are not present, or also defined in simple criteria object format. See \[attr:PickList.useOptionTextMatchStyleInPickList\](#attr-picklistuseoptiontextmatchstyleinpicklist) for details.

### Returns

`[Criteria](#type-criteria)` — criteria to be used for databound or local filtering

**Flags**: A

---
## Attr: CheckboxItem.showValueIconFocusedAsOver

### Description
When \[showValueIconFocused\](#attr-checkboxitemshowvalueiconfocused) is set to true, this attribute determines the state-name to use for the 'FocusedOver' state - when true, 'FocusedOver' will use the 'Over' media/style, otherwise it will use the 'Focused' media/style.

### Groups

- valueIcons

**Flags**: IRWA

---
## Method: ListGrid.fetchData

### Description
Retrieves data from the DataSource that matches the specified criteria.

For a discussion of the various filtering and criteria-management APIs and when to use them, see the \[Grid Filtering overview\](#group-gridfiltering).

When `fetchData()` is first called, if data has not already been provided via \[setData()\](#method-listgridsetdata), this method will create a \[class:ResultSet\](#class-resultset), which will be configured based on component settings such as \[attr:DataBoundComponent.fetchOperation\](#attr-databoundcomponentfetchoperation) and \[attr:DataBoundComponent.dataPageSize\](#attr-databoundcomponentdatapagesize), as well as the general purpose \[attr:ListGrid.dataProperties\](#attr-listgriddataproperties). The created ResultSet will automatically send a DSRequest to retrieve data from \[listGrid.dataSource\](#attr-listgriddatasource), and from then on will automatically manage paging through large datasets, as well as performing filtering and sorting operations inside the browser when possible - see the \[class:ResultSet\](#class-resultset) docs for details.

#### NOTE:
 do not use 
#### both
 \[autoFetchData:true\](#attr-databoundcomponentautofetchdata) 
#### and
 a call to `fetchData()` - this may result in two DSRequests to fetch data. Use either \[autoFetchData\](#attr-databoundcomponentautofetchdata) and \[type:Criteria\](#type-criteria) 
#### or
 a manual call to fetchData() passing criteria.

Whether a ResultSet was automatically created or provided via \[setData()\](#method-listgridsetdata), subsequent calls to fetchData() will simply call \[method:ResultSet.setCriteria\](#method-resultsetsetcriteria).

Changes to criteria may or may not result in a DSRequest to the server due to \[client-side filtering\](#attr-resultsetuseclientfiltering). You can call \[willFetchData(criteria)\](#method-databoundcomponentwillfetchdata) to determine if new criteria will result in a server fetch.

If you need to force data to be re-fetched, you can call \[invalidateCache()\](#method-listgridinvalidatecache) and new data will automatically be fetched from the server using the current criteria and sort direction. 
#### NOTE:
 when using `invalidateCache()` there is no need to 
#### also
 call `fetchData()` and in fact this could produce unexpected results.

This method takes an optional callback parameter (set to a \[type:DSCallback\](#type-dscallback)) to fire when the fetch completes. Note that this callback will not fire if no server fetch is performed. In this case the data is updated synchronously, so as soon as this method completes you can interact with the new data. If necessary, you can use \[willFetchData()\](#method-databoundcomponentwillfetchdata) to determine whether or not a server fetch will occur when `fetchData()` is called with new criteria.

In addition to the callback parameter for this method, developers can use \[dataArrived()\](#method-listgriddataarrived) to be notified every time data is loaded.

By default, this method assumes a \[type:TextMatchStyle\](#type-textmatchstyle) of "exact"; that can be overridden by supplying a different value in the requestProperties parameter. See \[method:DataBoundComponent.willFetchData\](#method-databoundcomponentwillfetchdata);

#### Changing the request properties

Changes to \[type:TextMatchStyle\](#type-textmatchstyle) made via `requestProperties` will be honored in combination with the fetch criteria, possibly invalidating cache and triggering a server request if needed, as documented for \[willFetchData()\](#method-databoundcomponentwillfetchdata). In contrast, changes to \[operationId\](#attr-dsrequestoperationid) in the request properties will cause the \[class:ResultSet\](#class-resultset) or \[class:ResultTree\](#class-resulttree) to be rebuilt, always refetching from the server. However, changes to other request properties after the initial fetch won't be detected, and no fetch will get triggered based on that new request context.

To pick up such changes, we recommend that you call \[setData(\[\])\](#method-listgridsetdata) (passing an empty array to ensure the data model is cleared), and then call this method to fetch again. If you try to do it by calling \[invalidateCache()\](#method-listgridinvalidatecache), you may see duplicate fetches if you haven't already updated the data context by calling this method with the new request properties, and fail to do so before the component is \[redrawn\](#method-canvasredraw).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| criteria | [Criteria](#type-criteria) | true | — | Search criteria. If a \[class:DynamicForm\](#class-dynamicform) is passed in as this argument instead of a raw criteria object, will be derived by calling \[method:DynamicForm.getValuesAsCriteria\](#method-dynamicformgetvaluesascriteria) |
| callback | [DSCallback](#type-dscallback) | true | — | callback to invoke when a fetch is complete. Fires only if server contact was required |
| requestProperties | [DSRequest](#type-dsrequest) | true | — | additional properties to set on the DSRequest that will be issued |

### Groups

- dataBoundComponentMethods

### See Also

- [ListGrid.refreshData](#method-listgridrefreshdata)

---
## Method: DrawRect.getBoundingBox

### Description
Returns the top, left, top+height, left+width

### Returns

`[Array of double](#type-array-of-double)` — x1, y1, x2, y2 coordinates

---
## Attr: Operator.hidden

### Description
Whether this operator should be offered to users by default in interfaces such as the \[class:FilterBuilder\](#class-filterbuilder).

Setting hidden:true means the operator can be used in a programmatic search, for example, by calling \[method:ResultSet.setCriteria\](#method-resultsetsetcriteria), but does not appear in the UI.

### Groups

- advancedFilter

**Flags**: IR

---
## ClassAttr: DateItem.YEAR_MONTH_DAY

### Description
A declared value of the enum type \[DateItemSelectorFormat\](#type-dateitemselectorformat).

**Flags**: R

---
## Type: RelativeDateShortcut

### Description
A RelativeDateShortcut is a special string that represents a shortcut to a date phrase that can be automatically mapped to a \[type:RelativeDateString\](#type-relativedatestring) for use in widgets that leverage relative-dates, such as the \[class:RelativeDateItem\](#class-relativedateitem).

Note that some shortcuts indicate a time period but do not directly indicate whether the value refers to the start or end of the time period in question. This ambiguity can be resolved by specifying an explicit \[type:RelativeDateRangePosition\](#type-relativedaterangeposition) when calling APIs that convert from RelativeDates to absolute date values. This is the case for _$today_, _$tomorrow_, _$yesterday_, _$weekAgo_, _$weekFromNow_, _$monthAgo_ and _$monthFromNow_. If a range position is not explicitly passed, these will all default to the start of the day in question.

Builtin options include

*   $now - this moment
*   $today - the current day. By default this resolves to the start of the current day though an explicit \[type:RelativeDateRangePosition\](#type-relativedaterangeposition) may be used to specify the end of the current day.
*   $startOfToday - the start of today
*   $endOfToday - the end of today (one millisecond before the $startOfTomorrow)
*   $yesterday - the previous day.
*   $startOfYesterday - the start of yesterday
*   $endOfYesterday - the end of yesterday (one millisecond before the $startOfToday)
*   $tomorrow - the following day
*   $startOfTomorrow - the start of tomorrow
*   $endOfTomorrow - the end of tomorrow
*   $weekAgo - the current day of the previous week
*   $weekFromNow - the current day of the next week
*   $startOfWeek - the start of the current week
*   $endOfWeek - the end of the current week
*   $monthAgo - the current day of the previous month
*   $monthFromNow - the current day of the following month
*   $startOfMonth - the start of the current month
*   $endOfMonth - the end of the current month
*   $startOfYear - the start of the current year
*   $endOfYear - the end of the current year

### See Also

- [RelativeDateString](#type-relativedatestring)

---
## Method: TabSet.setCanCloseTabs

### Description
Changes this TabSet's \[canCloseTabs\](#attr-tabsetcanclosetabs) property.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| canCloseTabs | [boolean](#type-boolean) | false | — | the new value for canCloseTabs. |

---
## Attr: DataSourceField.multipleStorageSeparator

### Description
For fields that are \[multiple:true\](#attr-datasourcefieldmultiple) and use \[attr:DataSourceField.multipleStorage\](#attr-datasourcefieldmultiplestorage), the separator used in the "simpleString" \[type:MultipleFieldStorage\](#type-multiplefieldstorage) mode.

Default value of null means the \[attr:DataSourceField.multipleValueSeparator\](#attr-datasourcefieldmultiplevalueseparator) is used instead.

NOTE: "simpleString" storage concatenates the stringified forms of each of the multiple values together, delimited with the `multipleStorageSeparator` character(s). If you use this storage mode with String values that themselves contain the `multipleStorageSeparator`, they will not be correctly retrieved. To avoid this, use a multi-character delimiter that is not likely to occur in regular text, or switch to "json" storage

### Groups

- multipleField

**Flags**: IR

---
## Attr: UserTask.previousElement

### Description
Previous workflow \[sequence\](#attr-processsequences) or \[element\](#attr-processelements) that is helpful for wizards. This element will be executed if \[method:UserTask.goToPrevious\](#method-usertaskgotoprevious) method of userTask will be invoked. You can get userTask for attached form by using \[userTask\](#attr-dynamicformusertask) property.

**Flags**: IR

---
## ClassMethod: Validator.create

### Description
A Validator shouldn't be created directly. Instead pass \[type:Properties\](#type-properties) as each Validator in \[attr:FormItem.validators\](#attr-formitemvalidators) or wherever a Validator is needed.

---
## Method: Canvas.mouseWheel

### Description
Executed when the mouse wheel is actuated.

### Returns

`[Boolean](#type-boolean)` — false to prevent this event from bubbling to this widget's parent, true or undefined to bubble.

### Groups

- widgetEvents

### See Also

- [EventHandler.getWheelDelta](#classmethod-eventhandlergetwheeldelta)
- [Canvas.getOffsetX](#method-canvasgetoffsetx)
- [Canvas.getOffsetY](#method-canvasgetoffsety)

**Flags**: A

---
## Attr: DataSource.operationBindings

### Description
Optional array of OperationBindings, which provide instructions to the DataSource about how each DSOperation is to be performed.

When using the SmartClient Server, OperationBindings are specified in your DataSource descriptor (.ds.xml file) and control server-side behavior such as what Java object to route DSRequest to (\[attr:OperationBinding.serverObject\](#attr-operationbindingserverobject)) or customizations to SQL, JQL and HQL queries (\[attr:OperationBinding.customSQL\](#attr-operationbindingcustomsql), \[attr:OperationBinding.customJQL\](#attr-operationbindingcustomjql) and \[attr:OperationBinding.customHQL\](#attr-operationbindingcustomhql)). See the ${isc.DocUtils.linkForExampleId('javaDataIntegration', 'Java Integration samples')}.

For DataSources bound to WSDL-described web services using \[attr:DataSource.serviceNamespace\](#attr-datasourceservicenamespace), OperationBindings are used to bind each DataSource \[operationType\](#attr-operationbindingoperationtype) to an \[operation\](#attr-operationbindingwsoperation) of a WSDL-described \[web service\](#class-webservice), so that a DataSource can both fetch and save data to a web service.

For example, this code accomplishes part of the binding to the [SalesForce partner web services](http://www.google.com/search?q=sforce+partner+wsdl)

 isc.DataSource.create({
    serviceNamespace : "urn:partner.soap.sforce.com",
    operationBindings : \[
        { operationType:"fetch", wsOperation:"query", recordName: "sObject" },
        { operationType:"update", wsOperation:"update", recordName: "SaveResult" },
        { operationType:"add", wsOperation:"create", recordName: "SaveResult" },
        { operationType:"remove", wsOperation:"delete", recordName: "DeleteResult" }
    \],
    ...
 }); 
 

NOTE: additional code is required to handle authentication and other details, see the complete code in smartclientSDK/examples/databinding/SalesForce.

For DataSources that contact non-WSDL-described XML or JSON services, OperationBindings can be used to separately configure the URL, HTTP method, input and output processing for each operationType. This makes it possible to fetch JSON data from one URL for the "fetch" operationType and save to a web service for the "update" operationType, while appearing as a single integrated DataSource to a \[interface:DataBoundComponent\](#interface-databoundcomponent) such as an \[editable ListGrid\](#attr-listgridcanedit).

If no operationBinding is defined for a given DataSource operation, all of the properties which are valid on the operationBinding are checked for on the DataSource itself.

This also means that for a read-only DataSource, that is, a DataSource only capable of fetch operations, operationBindings need not be specified, and instead all operationBinding properties can be set on the DataSource itself. In the ${isc.DocUtils.linkForExampleId('rssFeed', 'RSS Feed')} sample, you can see an example of using OperationBinding properties directly on the DataSource in order to read an RSS feed.

### See Also

- [OperationBinding](#class-operationbinding)

**Flags**: IR

---
## Attr: SectionItem.canCollapse

### Description
Whether this section header can be collapsed. If set false, suppresses open/close state icon

**Flags**: IR

---
## Attr: ListGrid.firstCellStyle

### Description
The style to apply to the first cell in each row, when \[attr:ListGrid.styledRowEnds\](#attr-listgridstyledrowends) is true. Note that this style is additional to the regular cell styling and should not introduce settings that change the layout or size of the cell, such as padding or font-size. The styling will work with any design, and is also applied correctly with or without frozen fields.

If all you want to do is provide rounded-corners for records in this grid, it may be simpler to set \[attr:ListGrid.recordRadius\](#attr-listgridrecordradius) to a CSS _border-radius_ string that achieves the rounding you want.

**Flags**: IRW

---
## Attr: UserSummary.text

### Description
Summary to be evaluated.

There are two contexts where a `UserSummary` is used: \[attr:ListGridField.userSummary\](#attr-listgridfieldusersummary) / \[attr:DetailViewerField.userSummary\](#attr-detailviewerfieldusersummary) and \[attr:FormItem.textFormula\](#attr-formitemtextformula) or \[attr:ListGridField.editorTextFormula\](#attr-listgridfieldeditortextformula). For the grid/detail viewer field summary, all variables used by the summary must be single capital letters surrounded by braces and escaped with a # sign (e.g. #{A}). These are derived from field values for the record in question - see \[attr:UserSummary.summaryVars\](#attr-usersummarysummaryvars).

In the context of forms and editing, variables are dot-separated (.) names representing the nested hierarchy path to the desired value within the \[rule context\](#attr-canvasrulescope). No mapping with \[attr:UserSummary.summaryVars\](#attr-usersummarysummaryvars) is needed.

This attribute is writable only in \[class:ListGrid\](#class-listgrid)s. Applications must call either \[method:ListGrid.setUserSummary\](#method-listgridsetusersummary) or \[method:ListGrid.setUserSummaryText\](#method-listgridsetusersummarytext) to re-evaluate the summary.

**Flags**: IRW

---
## Method: DateRangeItem.canEditCriterion

### Description
Returns true if the specified criterion contains:

*   A single "lessOrEqual" or "greaterOrEqual" criterion on this field
*   An "and" type criterion containing a "lessOrEqual" and a "greaterOrEqual" criterion on this field
*   A single "equals" criterion. Internally, this will be converted into a range by constructing an "and" type criterion containing both a "lessOrEqual" and a "greaterOrEqual" criterion on this field. Note that subsequent calls to \[getCriterion()\](#method-daterangeitemgetcriterion) will return this more complex criterion.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| criterion | [Criterion](#type-criterion) | false | — | criterion to test |

### Returns

`[boolean](#type-boolean)` — returns true if this criterion can be edited by this item

### Groups

- criteriaEditing

---
## Attr: MenuButton.menuButtonImage

### Description
Image for menu button indicating that the button expands a menu. This image is shown for menus expanding down from the button. Menu direction is controlled by \[attr:MenuButton.showMenuBelow\](#attr-menubuttonshowmenubelow).

### Groups

- menu

### See Also

- [MenuButton.menuButtonImageUp](#attr-menubuttonmenubuttonimageup)

**Flags**: IRA

---
## Attr: Button.showRollOver

### Description
Should we visibly change state when the mouse goes over this object?

### Groups

- state

**Flags**: IRW

---
## Attr: ImgButton.labelHPad

### Description
Horizontal padding to be applied to this widget's label. If this value is null, the label will be given a horizontal padding of zero.

The specified amount of padding is applied to the left and right edges of the button, so the total amount of padding is 2x the specified value.

**Flags**: IRW

---
## Attr: Window.headerIcon

### Description
Header icon shown at left end of header by default.

**Flags**: R

---
## Method: Canvas.setShowPointer

### Description
Set the showPointer property.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| show | [boolean](#type-boolean) | false | — | — |

---
## Attr: StretchImg.gripImgSuffix

### Description
Suffix used the 'grip' image if \[attr:StretchImg.showGrip\](#attr-stretchimgshowgrip) is true.

### Groups

- grip

**Flags**: IRA

---
## Attr: DataSource.logSlowRemove

### Description
Allows you to specify \["remove" operation\](#type-dsoperationtype) SQL query execution time threshold in milliseconds, which if exceeded query is identified as "slow" and may be logged under specific logging category.

See \[attr:DataSource.logSlowSQL\](#attr-datasourcelogslowsql) for more details.

**Flags**: IR

---
## Class: GridRemoveSelectedDataTask

### Description
Remove data that is selected in a grid.

### See Also

- [ListGrid.removeSelectedData](#method-listgridremoveselecteddata)

---
## Attr: GridEditProxy.canResizeFields

### Description
Indicates whether fields in this listGrid can be resized by dragging header fields. Overrides \[attr:ListGrid.canResizeFields\](#attr-listgridcanresizefields) when in edit mode.

**Flags**: IR

---
## Attr: DetailViewer.showEmptyField

### Description
Whether to show the field when the value is null

### Groups

- appearance

**Flags**: IRWA

---
## Attr: FacetChart.legendRectHeight

### Description
If drawing a border around the legend, the height of the drawn Rectangle.

### Groups

- legend

**Flags**: IR

---
## Attr: DataSource.fileTypeField

### Description
The native field name used by this DataSource on the server to represent the `fileType` for \[FileSource Operations\](#group-filesource).

If the fileTypeField is not configured, then a field named "fileType" will be used, if it exists. Otherwise, the DataSource will not track fileTypes -- this may be acceptable if, for instance, you use a separate DataSource for each fileType.

The fileType is specified according to the extension that would have been used in the filesystem -- for instance, the fileType for employees.ds.xml would be "ds".

### Groups

- fileSource

**Flags**: IR

---
## Type: int

### Description
A whole number, for example, 5. Decimal numbers, for example 5.5, are not allowed. May not be null.

---
## Method: ResultSet.allMatchingRowsCached

### Description
Do we have a complete client-side cache of records for the current filter criteria?

Returns `false` if this is a paged data set, and the entire set of records that match the current criteria has not been retrieved from the server. In other words, a return value of `false` means that this `ResultSet` has a partial cache.

### Returns

`[boolean](#type-boolean)` — whether all matching rows are cached

**Flags**: A

---
## Attr: TableView.canSaveSearches

### Description
Option to save searches is disabled for TableView

**Flags**: IRA

---
## Method: FormItem.setValue

### Description
Set the value of the form item to the value passed in

NOTE: for valueMap'd items, newValue should be data value not displayed value

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| newValue | [Any](#type-any) | false | — | value to set the element to |

---
## Method: ProcessElement.updateLastElementInValueProperty

### Description
Updates a \[type:TaskInputExpression\](#type-taskinputexpression) property value containing $last references. Any implicit reference to the last task is updated to reference a last task of a specified `taskType`.

For example, a value of "$last.sequenceNo" would be replaced with "$last\[fetch\].sequenceNo" if the taskType is "fetch". Existing "$last\[...\]" references are left as-is.

This method is a helper to implement task-specific \[method:ProcessElement.updateLastElementBindingReferences\](#method-processelementupdatelastelementbindingreferences).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| propertyName | [String](#type-string) | false | — | the property name to be updated in this task |
| taskType | [String](#type-string) | false | — | the taskType to be used in new reference |

### Returns

`[Boolean](#type-boolean)` — true if any references were update; false otherwise

---
## Attr: ListGrid.exportFieldWidths

### Description
When exporting data to Excel/OpenOffice format using \[method:ListGrid.exportData\](#method-listgridexportdata) or \[method:ListGrid.exportClientData\](#method-listgridexportclientdata), whether widths of fields should be replicated in the resulting spreadsheet.

Because Excel's unit of measurement for field widths is based on the default system font, there is no exact way to translate field widths in pixels to Excel column widths. The \[attr:ListGrid.exportWidthScale\](#attr-listgridexportwidthscale) property can be set to adjust scaling; it's default value errs on the side of making Excel's columns slightly wider than the ListGrid field's actual width to avoid clipping.

Note that you can switch off width export for individual fields with the \[attr:ListGridField.exportFieldWidth\](#attr-listgridfieldexportfieldwidth) flag.

### See Also

- [ListGrid.exportHiddenFieldWidth](#attr-listgridexporthiddenfieldwidth)

**Flags**: IRW

---
## ClassAttr: DrawLabel.LEFT

### Description
A declared value of the enum type \[LabelAlignment\](#type-labelalignment).

**Flags**: R

---
## Class: VoiceAssist

### Description
The VoiceAssist class provides voice-interaction features by leveraging the browser’s speech recognition capabilities, typically through the SpeechRecognition or webkitSpeechRecognition interfaces. At the time of writing, full support is available in Chromium-based browsers like Chrome and Edge (on desktop). Safari provides partial support through the webkitSpeechRecognition API. Firefox does not support speech recognition due to privacy and security concerns, and some Chromium-based browsers like Brave also omit support due to their exclusion of Google’s proprietary services.

To enable VoiceAssist, call \[classMethod:VoiceAssist.enable\](#classmethod-voiceassistenable), optionally passing the \[keyName\](#attr-voiceassistvoicekey) you want to use for activation and recording - the default is `Control`. Once initialized, VoiceAssist can be activated or deactivated with three quick taps of the \[attr:VoiceAssist.voiceKey\](#attr-voiceassistvoicekey).

When recognition is active, a user may double-tap the `voiceKey` to begin dictating a value for a focused input control. Text appears in the input control as the user speaks and the transcription is completed by a subsequent double-tap of the `voiceKey`, or by remaining silent for a number of seconds.

In addition to value-dictation, a user may dictate a command to be issued to the focused component, which may deal with the text itself or forward to an AI for action. If the focused component doesn't \[support voice-commands\](#method-canvassupportsvoicecommands) but one of its parents does, that parent will be the focus of your dictated command. To begin dictating a command, press and hold the `voiceKey` - while the key remains pressed, the \[classMethod:VoiceAssist.recordingProgress\](#classmethod-voiceassistrecordingprogress) method is fired with interim text-results as the user speaks.

If the user speaks one of the \[attr:VoiceAssist.cancelPhrases\](#attr-voiceassistcancelphrases), the interim text is discarded and recording is canceled.

When the user releases the speech-key, recording is stopped and the final text of the recording is passed to the \[target component\](#method-canvasdovoicecommand) for action.

---
## Attr: ListGrid.headerMenuButtonIconWidth

### Description
If \[attr:ListGrid.showHeaderMenuButton\](#attr-listgridshowheadermenubutton) is true, this property governs the width of the icon shown on the auto-generated `headerMenuButton`

### Groups

- headerMenuButton

**Flags**: IRA

---
## ClassAttr: DrawLabel.defaultSansSerifFont

### Description
This setting exists due to platform limitations in some versions of Internet Explorer where the browser does not recognize the five generic font families (`cursive`, `fantasy`, `monospace`, `sans-serif`, and `serif`) and instead uses a non-configurable, default font. This setting specifies a specific font to replace the `sans-serif` keyword should a DrawLabel list it in its \[font family\](#attr-drawlabelfontfamily).

**Flags**: IRW

---
## Method: AdaptiveMenuItem.checkIf

### Description
Contains the condition that will check or uncheck the current menuItem. The handler must be specified as a function or string of script. Return false to uncheck the menuItem or true to check it

If you don't need to set this state dynamically, use \[attr:MenuItem.checked\](#attr-menuitemchecked) instead.

May be defined as a \[stringMethod\](#group-stringmethods).

Note that the `menu` parameter may be null if this `AdaptiveMenuItem` is not currently showing in a \[class:Menu\](#class-menu).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| target | [Canvas](#type-canvas) | false | — | \[target\](#attr-menutarget) attribute for the top level menu. |
| menu | [Menu](#type-menu) | false | — | The \[class:Menu\](#class-menu) instance of which this \[object:MenuItem\](#object-menuitem) is a member, or null if this item is not currently displayed in a Menu |
| item | [AdaptiveMenuItem](#type-adaptivemenuitem) | false | — | contains the reference to the current item |

### Returns

`[boolean](#type-boolean)` — Return true to show a checkmark by this menu item

### Groups

- dynamicMenuItem

---
## Attr: CubeGrid.rowFacets

### Description
The list of \[ids\](#attr-facetid) for facets that will appear to the left of the body.

### Groups

- facetLayout

### See Also

- [CubeGrid.rowHeaderGridMode](#attr-cubegridrowheadergridmode)

**Flags**: IR

---
## Method: GridRenderer.getCellValue

### Description
Return the HTML to display in this cell. Implementing this is required to get a non-empty grid.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| record | [ListGridRecord](#type-listgridrecord) | false | — | cell record as returned by getCellRecord |
| rowNum | [number](#type-number) | false | — | row number for the cell |
| colNum | [number](#type-number) | false | — | column number of the cell |

### Returns

`[String](#type-string)` — HTML to display in this cell

---
## Method: DataSource.getCacheData

### Description
Returns the complete set of data cached by this dataSource. Note that this may have been supplied via \[attr:DataSource.cacheData\](#attr-datasourcecachedata), or may have been fetched from the server for dataSources with \[attr:DataSource.cacheAllData\](#attr-datasourcecachealldata) set to true.

### Returns

`[Array of Record](#type-array-of-record)` — entire cached set of data

---
## Method: Canvas.clickMaskUp

### Description
Determines whether a clickmask is showing

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| ID | [String](#type-string) | true | — | optional ID of specific clickMask to check. If not passed, checks for the click mask associated with this widget only. |

### Returns

`[Boolean](#type-boolean)` — whether or not a clickmask is showing

### Groups

- clickMask

### See Also

- [Canvas.showClickMask](#method-canvasshowclickmask)

---
## Attr: ListGridField.optionOperationId

### Description
If this field has an optionDataSource specified and \[autoFetchDisplayMap\](#attr-listgridfieldautofetchdisplaymap) is set, this attribute provides a way to customize the \[attr:DSRequest.operationId\](#attr-dsrequestoperationid) passed to `dataSource.fetchData()` when retrieving the display map from the option dataSource.

### Groups

- display_values

**Flags**: IR

---
## Attr: NotifySettings.slideSpeed

### Description
Animation speed for \[type:NotifyTransition\](#type-notifytransition): "slide", in pixels/second.

**Flags**: IR

---
## Attr: StretchImgButton.align

### Description
Horizontal alignment of this component's title.

### Groups

- appearance

**Flags**: IRW

---
## Attr: HibernateBrowser.cancelButton

### Description
Instance of Button used to cancel this dialog.

**Flags**: IR

---
## Attr: TileLayout.tilesPerLine

### Description
Number of tiles to show in each line. Auto-derived from \[attr:TileLayout.tileSize\](#attr-tilelayouttilesize) for some layout modes. See \[type:TileLayoutPolicy\](#type-tilelayoutpolicy). This can also affect \[attr:TileLayout.tileWidth\](#attr-tilelayouttilewidth) or \[attr:TileLayout.tileHeight\](#attr-tilelayouttileheight). See those properties for details.

### Groups

- layoutPolicy

**Flags**: IRW

---
## Attr: FacetChart.logScale

### Description
Whether to use logarithmic scaling for values.

Logarithmic scale charts show an equivalent percentage increase as equivalent distance on the chart. That is, 10 and 100 are the same distance apart as 100 and 1000 (each being a 10 times or 1000% increase).

**Flags**: IR

---
## Attr: GridRenderer.alternateColumnFrequency

### Description
The number of consecutive columns to draw in the same style before alternating, when \[alternateColumnStyles\](#attr-gridrendereralternatecolumnstyles) is true.

### Groups

- cellStyling

**Flags**: IRW

---
## Attr: TourStep.title

### Description
Title for the Window.

### Groups

- appearance
- i18nMessages

**Flags**: IR

---
## Attr: ListGrid.baseStyle

### Description
\[base cell style\](#attr-gridrendererbasestyle) for this listGrid. If this property is unset, base style may be derived from \[attr:ListGrid.normalBaseStyle\](#attr-listgridnormalbasestyle) or \[attr:ListGrid.tallBaseStyle\](#attr-listgridtallbasestyle) as described in \[method:ListGrid.getBaseStyle\](#method-listgridgetbasestyle).

See \[group:cellStyleSuffixes\](#group-cellstylesuffixes) for details on how stateful suffixes are combined with the base style to generate stateful cell styles.

### Groups

- appearance

**Flags**: IR

---
## Type: PointShape

### Description
Supported data point shapes for \[attr:FacetChart.pointShapes\](#attr-facetchartpointshapes) are:

### Values

| Value | Description |
|-------|-------------|
| Oval | — |
| Square | — |
| Diamond | — |
| Triangle | — |

---
## Attr: DrawPolygon.lineCap

### Description
Style of drawing the corners of the polygon.

### Groups

- line

**Flags**: IRW

---
## Attr: ProcessElement.passThruOutput

### Description
Does this processElement pass through output from the last executed task (i.e. transient state)?

See \[taskInputExpressions\](#type-taskinputexpression) for details on the transient state outputs.

Note that this property does not affect the task at all but is an indicator to the user and to the workflow editor of the behavior of the task as coded (See \[method:Process.passThruTaskOutput\](#method-processpassthrutaskoutput)).

**Flags**: IR

---
## Attr: FormItem.defaultOperator

### Description
The default search-operator for this item when it or its form allow \[filter-expressions\](#attr-formitemallowexpressions).

### Groups

- advancedFilter

**Flags**: IR

---
## Attr: OperationBinding.mail

### Description
Definition of an email message that will be sent as an after-effect of selecting or updating data.

Note that if a fixed number of different messages need to be sent, multiple `<mail>` tags may be specified. For example, one mail could be sent to an admin address, and a different message to every member of a user group.

### Groups

- mail

**Flags**: IR

---
## Attr: DynamicForm.showTitlesWithErrorMessages

### Description
Indicates whether on validation failure, the error message displayed to the user should be pre-pended with the title for the item.

### Groups

- validation

**Flags**: IRW

---
## Attr: MultiPickerItem.shuttleHeight

### Description
Height for the \[attr:MultiPickerItem.pickerLayout\](#attr-multipickeritempickerlayout) when \[type:SelectionStyle\](#type-selectionstyle) is `"shuttle"`.

**Flags**: IRW

---
## Method: ListGrid.getFieldState

### Description
Returns a snapshot of the current presentation of this listGrid's fields as a \[type:ListGridFieldState\](#type-listgridfieldstate) object.

This object can later be passed to \[method:ListGrid.setFieldState\](#method-listgridsetfieldstate) to reset this grid's fields to the current state.

Note that the information stored includes the current width and visibility of each of this grid's fields, as well as any \[formula\](#attr-listgridcanaddformulafields) or \[summary fields\](#attr-listgridcanaddsummaryfields) added by the user.

The optional `sparse` parameter governs whether the returned field state should omit state information for hidden fields. If this parameter is not passed explicitly, field state will be sparse if \[attr:DataBoundComponent.sparseFieldState\](#attr-databoundcomponentsparsefieldstate) is true.  
When applying sparse field state to a component via \[method:ListGrid.setFieldState\](#method-listgridsetfieldstate), any explicitly defined fields on the component that were not captured in the stored state object will be hidden.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| sparse | [Boolean](#type-boolean) | true | — | If true, field state will be ommitted for hidden fields. |

### Returns

`[ListGridFieldState](#type-listgridfieldstate)` — current state of this grid's fields.

### Groups

- viewState

### See Also

- [ListGrid.setFieldState](#method-listgridsetfieldstate)

---
## Group: focus

### Description
Focus is the ability to become the target of keyboard input events.

A widget normally receives focus by being clicked on or tabbed to.

---
## Attr: Img.usePNGFix

### Description
If false, never apply the png fix needed in Internet Explorer to make png transparency work correctly.

**Flags**: IR

---
## Attr: ColorItem.pickerIconWidth

### Description
If \[showPickerIcon\](#attr-coloritemshowpickericon) is true for this item, this property governs the size of the picker icon. If unset, the picker icon will be sized as a square to fit in the available height for the icon.

Note that if spriting is being used, and the image to be displayed is specified using css properties such as `background-image`, `background-size`, changing this value may result in an unexpected appearance as the image will not scale.  
Scaleable spriting can be achieved using the \[type:SCSpriteConfig\](#type-scspriteconfig) format. See the section on spriting in the \[skinning overview\](#group-skinning) for further information.

### Groups

- pickerIcon

**Flags**: IRW

---
## Method: TileGrid.deselectRange

### Description
Deselect a contiguous range of records by index.

This is a synonym for `selectRange(startRow, endRow, false);`

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| startRow | [int](#type-int) | false | — | start of selection range |
| endRow | [int](#type-int) | false | — | end of selection range (non-inclusive) |

### Groups

- selection

### See Also

- [Selection](#class-selection)

---
## Method: EditContext.getPaletteNodesFromXML

### Description
Obtain \[PaletteNodes\](#object-palettenode) from an XML representation, but do not add them to the EditContext.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| xmlString | [String](#type-string) | false | — | XML string |
| callback | [PaletteNodeCallback](#type-palettenodecallback) | false | — | Callback used to return the PaletteNodes |

### See Also

- [Callbacks.PaletteNodeCallback](#method-callbackspalettenodecallback)
- [EditContext.serializeAllEditNodes](#method-editcontextserializealleditnodes)
- [EditContext.serializeEditNodes](#method-editcontextserializeeditnodes)

---
## Attr: FacetChart.legendAlign

### Description
Horizontal alignment of the chart's \[legend widget\](#attr-facetchartshowlegend).

### Groups

- legend

**Flags**: IRW

---
## Attr: GridEditProxy.saveGroupBy

### Description
Should changes to grid grouping (including both grouping and ungrouping the grid) be persisted?

Only valid with \[type:SelectedAppearance\](#type-selectedappearance) settings that allow direct interactivity (such as "outlineEdges").

**Flags**: IR

---
## Attr: MultiComboBoxItem.valueMap

### Description
The `valueMap` of the combo box.

### See Also

- [FormItem.valueMap](#attr-formitemvaluemap)

**Flags**: IRW

---
## Attr: TextSettings.fieldList

### Description
For export, a set of fields to export. Default is to export all DataSource fields.

Fields may be specified that are not in the DataSource but for which data values are present in the provided Records. In this case the field is assumed to be of type "text".

For import, names of DataSource fields to use to parse values, in order.

If `fieldList` is unset, DataSource fields are used, in order.

If more values exist in a given Record than the listed fields or than all DataSource fields, remaining values are ignored.

**Flags**: IR

---
## Attr: BrowserWindowSettings.alwaysOnTop

### Description
Persistent setting to position the window at the top of the window stack.

**Flags**: IR

---
## Attr: DrawDiamond.titleRotationMode

### Description
The mode in which the \[titleLabel\](#attr-drawitemtitlelabel) (if shown) is rotated with this draw item.

### See Also

- [DrawItem.title](#attr-drawitemtitle)

**Flags**: IRA

---
## Group: concurrentEdits

### Description
How do SmartClient DataSources handle multiple users making changes to the same record?

Consider a scenario where two users - _userA_ and _userB_ - are logged into the same application and viewing the same set of records in a SmartClient application:

*   _userA_ makes a change to a record and \[saves the edit\](#method-dynamicformsavedata)
*   _userB_ then makes another change to the same record and saves their edit

By default SmartClient dataSources have simple "most recent edit wins" behavior, so the changes made by userB will be preserved in the dataSource permanent storage - though if \[attr:DataSource.sparseUpdates\](#attr-datasourcesparseupdates) is false, any changes made by _userA_ to fields that were not explicitly edited by _userB_ will also be preserved.

In this case when _userA_ performs their first edit (before _userB_ has attempted a save), _userB_ will not see _userA_'s changes unless they explicitly re-fetch the data. Similarly, _userA_ will not see _userB_'s subsequent edit without a re-fetch.

In many applications this behavior is acceptable but there may be cases where users will need to see other users' updates as they occur, and simple "last edit wins" is not sufficient. There are 2 things you can do to make this more sophisticated:

#### Broadcasting changes:
  
The \[method:DataSource.updateCaches\](#method-datasourceupdatecaches) method is a way to notify a DataSource that a change has occurred. It will update its client-side caches to reflect the change and databound components showing the record will be refreshed as appropriate.

Developers using the SmartClient server and \[group:messaging\](#group-messaging) may use this feature to propogate changes from the server to the client.

See this [blog post](https://isomorphic.atlassian.net/wiki/spaces/Main/pages/525130/How+to+propagate+data+source+changes+to+all+clients+by+using+the+Real-Time+Messaging+Module) for details on this approach.  
_Note: The sample project in this post is a SmartGWT project rather than SmartClient project. This means the client-side code to handle the server response is written in Java rather than JavaScript - but the methodology directly translates to SmartClient JavaScript and should be easy to understand._

#### Detecting concurrent edits:
  
Note that even if an application is using Realtime Messaging or some similar approach to notify users of external edits as soon as they occur, it is still possible to get concurrent edit attempts on the same record.

In our original scenario - if _userB_ hit their save button after _userA_ but before the server had processed _userA_'s request, _userB_'s edit would essentially be based on "stale" values.

One way to detect this is to have custom server logic compare \[attr:DSRequest.oldValues\](#attr-dsrequestoldvalues) with the current values for the edited record and disallow the edit when this occurs.

See this [blog post](https://isomorphic.atlassian.net/wiki/spaces/Main/pages/525045/Detecting+concurrent+edits+with+long+transactions) for details on using oldValues to detect concurrent edits.  
_Once again, this post uses a SmartGWT Java project to demonstrate the approach._

---
## Attr: Calendar.lanes

### Description
An array of \[object:Lane\](#object-lane) definitions that represent the rows of the \[attr:Calendar.timelineView\](#attr-calendartimelineview), or the columns of the \[attr:Calendar.dayView\](#attr-calendardayview) if \[showDayLanes\](#attr-calendarshowdaylanes) is true.

**Flags**: IRW

---
## ClassAttr: Browser.isDesktop

### Description
Is the application running in a desktop browser? This is true if \[classAttr:Browser.isTablet\](#classattr-browseristablet) and \[classAttr:Browser.isHandset\](#classattr-browserishandset) are both `false`.

**Flags**: RW

---
## Attr: MultiGroupPanel.levelUpButtonTitle

### Description
The hover-prompt for the Level Up button.

### Groups

- i18nMessages

**Flags**: IR

---
## Attr: TreeGrid.manyItemsImage

### Description
The filename of the icon displayed use as the default drag tracker when for multiple files and/or folders are being dragged.

### Groups

- dragdrop

**Flags**: IRW

---
## ClassMethod: DateUtil.setShortDatetimeDisplayFormat

### Description
Set the default short format for datetime values. After calling this method, subsequent calls to \[method:Date.toShortDateTime\](#method-datetoshortdatetime) will return a string formatted according to this format specification. Note that this will be the standard datetime format used by SmartClient components.

The `format` parameter may be a \[type:FormatString\](#type-formatstring), a \[type:DateDisplayFormat\](#type-datedisplayformat) string, or a function. If passed a function, this function will be executed in the scope of the Date and should return the formatted string.  

Initial default format is `"toUSShortDatetime"`. See [http://en.wikipedia.org/wiki/Date\_format\_by\_country](http://en.wikipedia.org/wiki/Date_format_by_country) for a useful overview of standard date formats per country.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| format | [FormatString](#type-formatstring)|[DateDisplayFormat](#type-datedisplayformat)|[Function](#type-function) | false | — | new formatter |

### Groups

- dateFormatting

---
## Attr: DatabaseBrowser.serverType

### Description
The type of database server this DatabaseBrowser should connect to. Valid values are "sql" (SmartClient's own built-in support for SQL databases) or "hibernate"

**Flags**: IR

---
## Type: XMLDocument

### Description
XMLDocument is the "parsed" or object form of XML, which allows XML to be navigated as a tree of nodes with attributes, namespaces and other metadata, as opposed to being manipulated as just a String.

XMLDocument is a native object supplied directly by the browser. The SmartClient-supported interfaces for this object are methods that take an XMLDocument as an argument (such as \[classMethod:XMLTools.selectNodes\](#classmethod-xmltoolsselectnodes)). If you want to retrieve XML data and display it in a SmartClient component, read about \[XML Data Binding\](#group-clientdataintegration). To extract data as JavaScript Objects from XML, see \[classMethod:XMLTools.toJS\](#classmethod-xmltoolstojs). Direct manipulation of XMLDocument is subject to cross-browser inconsistencies, bugs, memory leaks and performance issues.

---
## Attr: FacetChart.dataLineType

### Description
How to draw lines between adjacent data points in Line and Scatter charts. See \[type:DataLineType\](#type-datalinetype).

Does not apply to boundary lines for shapes in Area or Radar plots.

**Flags**: IRW

---
## Attr: Canvas.childrenResizeSnapAlign

### Description
Flag to disable snapping to alignment when children of this Canvas are resized

### Groups

- snapGridDragging

**Flags**: IRW

---
## Method: ListGrid.getColumnPageLeft

### Description
Return the left coordinate for a given column number as a GLOBAL coordinate

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| colNum | [Integer](#type-integer) | false | — | number of the column |

### Returns

`[Integer](#type-integer)` — page left offset of the passed colNum, or null if undrawn or no such column

### Groups

- sizing
- positioning

**Flags**: A

---
## Method: Button.isSelected

### Description
Find out if this object is selected

### Returns

`[Boolean](#type-boolean)` — —

### Groups

- state

---
## Attr: DataBoundComponent.canEditHilites

### Description
Adds an item to the header context menu allowing users to launch a dialog to define grid hilites using the \[class:HiliteEditor\](#class-hiliteeditor).

User-added hilites can be persisted via \[method:DataBoundComponent.getHiliteState\](#method-databoundcomponentgethilitestate) and \[method:DataBoundComponent.setHiliteState\](#method-databoundcomponentsethilitestate).

To avoid undefined behavior, this property must be set to `false` if the same record objects, or the same \[class:ResultSet\](#class-resultset) instances, are shared among multiple \[interface:DataBoundComponent\](#interface-databoundcomponent)s.

### Groups

- hiliting

**Flags**: IRW

---
## Attr: RichTextCanvas.useDesignMode

### Description
Should this editor use a separate IFRAME with special cross-browser support for editing HTML content? In SmartClient versions 13.0 and later, this feature is switched off on account of better modern browser support for contentEditable containers.

**Flags**: IRA

---
## Class: Project

### Description
Represents a \[group:reify\](#group-reify) project loaded from the server via \[classMethod:RPCManager.loadProject\](#classmethod-rpcmanagerloadproject). A project contains cached screens and \[DataSources\](#class-datasource) that can be used to create actual screens by calling \[method:Project.createScreen\](#method-projectcreatescreen) or \[method:Project.createStartScreen\](#method-projectcreatestartscreen).

### See Also

- [Reify.loadProject](#method-reifyloadproject)

---
## Attr: DrawItem.showHover

### Description
If \[canHover\](#attr-drawitemcanhover) is true, should we show the global hover canvas by default when the user hovers over this DrawItem?

### Groups

- hovers

### See Also

- [DrawItem.getHoverHTML](#method-drawitemgethoverhtml)

**Flags**: IRW

---
## Group: treeIcons

### Description
—

---
## Attr: SavedSearchEditor.overwriteSharedSearchConfirmationMessage

### Description
Confirmation message to show when a user attempts to save a view with a searchName, componentID, and (if present) screenID / projectID which collides with another existing shared saved view.

This is the message that will be shown in a confirmation dialog if, for example, a user attempts to save a new view with the same name as an existing shared saved view for the same grid.

### Groups

- i18nMessages

**Flags**: IRW

---
## Attr: DataSource.useFlatFields

### Description
Like \[attr:DataBoundComponent.useFlatFields\](#attr-databoundcomponentuseflatfields), but applies to all DataBound components that bind to this DataSource.

### Groups

- fields

**Flags**: IR

---
## Attr: DynamicForm.showDetailFields

### Description
For databound forms, whether to show fields 