<#import "datasource-utils.ftl" as utils />
<#import "parameters.ftl" as parameters />
<#--
paths:
-->
<#--
  /Customer:
-->
<#macro fetch fetchOperation>
    post:
      operationId: "${fetchOperation.uid}"
      summary: |
      <#if fetchOperation.operationId??>
        ${ds.id}.${fetchOperation.operationId}
      <#else>
        Fetch ${ds.title ! ds.id}
      </#if>
      description: |
      <#if fetchOperation.description??>
        <#list fetchOperation.description as line>
        ${line?trim}
        </#list>
      <#else>
<#--        <@descriptions fetchOperation>        -->
      </#if>
      tags:
        - ${ds.id}
      parameters:
        <#--defined inline, so that we can switch between default=xml & default=json as appropriate for rest vs post-->
        <@parameters.dataFormat defaultValue=app.defaultDataFormat!"xml" />
        - $ref: "#/components/parameters/sortBy"
        - $ref: "#/components/parameters/startRow"
        - $ref: "#/components/parameters/endRow"
        - $ref: "#/components/parameters/textMatchStyle"
      <#list fetchOperation.parameters as field>
        - name: ${field.name}
          <@utils.describe indentation=10 field=field operation=fetchOperation />
          in: query
          schema:
            <@utils.fielddef indentation=12 field=field />
      </#list>
      requestBody:
        content:
          application/json:
            schema:
              oneOf:
                - $ref: '#/components/schemas/${ds.id}'
              <#if fetchOperation.hasCustomCriteria>
                - $ref: '#/components/schemas/${fetchOperation.operationId}Criteria'
                - $ref: '#/components/schemas/${fetchOperation.operationId}AdvancedCriteria'
              <#else>
                - $ref: '#/components/schemas/Criteria'
                - $ref: '#/components/schemas/AdvancedCriteria'
              </#if>
          application/xml:
            schema:
              oneOf:
                - $ref: '#/components/schemas/${ds.id}'
              <#if fetchOperation.hasCustomCriteria>
                - $ref: '#/components/schemas/${fetchOperation.operationId}Criteria'
                - $ref: '#/components/schemas/${fetchOperation.operationId}AdvancedCriteria'
              <#else>
                - $ref: '#/components/schemas/Criteria'
                - $ref: '#/components/schemas/AdvancedCriteria'
              </#if>
      responses:
        200:
          <@response fetchOperation />
        204:
          $ref: "#/components/responses/204"
        default:
          $ref: "#/components/responses/default"
</#macro>

<#macro add addOperation>
    post:
      operationId: "${addOperation.uid}"
      summary: |
      <#if addOperation.operationId??>
        ${ds.id}.${addOperation.operationId}
      <#else>
        Add ${ds.title}
      </#if>
      description: |
      <#if addOperation.description??>
        <#list addOperation.description as line>
        ${line?trim}
        </#list>
      </#if>
      tags:
        - ${ds.id}
      parameters:
        <@parameters.dataFormat defaultValue=app.defaultDataFormat!"xml" />
      <#list addOperation.parameters as field>
      <#if field.format?? && field.format == 'sequence'>
        <#continue />
      </#if>
        - name: ${field.name}
          <@utils.describe indentation=10 field=field operation=addOperation />
          in: query
          schema:
            <@utils.fielddef indentation=12 field=field />
      </#list>
      requestBody:
        <@utils.requestbodydef addOperation />
      responses:
        201:
          <@response addOperation />
        204:
          $ref: "#/components/responses/204"
        default:
          $ref: "#/components/responses/default"
</#macro>

<#macro update updateOperation>
    post:
      operationId: "${updateOperation.uid}"
      summary: |
      <#if updateOperation.operationId??>
        ${ds.id}.${updateOperation.operationId}
      <#else>
        Update ${ds.title}
      </#if>
      description: |
      <#if updateOperation.description??>
        <#list updateOperation.description as line>
        ${line?trim}
        </#list>
      <#else>
        Updates the given '${ds.id}' record, with request body values overriding / augmenting their corresponding query
        parameter values (where applicable).  Typical usage provides the value in either one place or the other, however.
      </#if>
      tags:
        - ${ds.id}
      parameters:
        <@parameters.dataFormat defaultValue=app.defaultDataFormat!"xml" />
      <#list updateOperation.parameters as field>
        - name: ${field.name}
          <@utils.describe indentation=10 field=field operation=updateOperation />
          in: query
          schema:
            <@utils.fielddef indentation=12 field=field />
      </#list>
      requestBody:
        <@utils.requestbodydef updateOperation />
      responses:
        200:
          <@response updateOperation />
        204:
          $ref: "#/components/responses/204"
        default:
          $ref: "#/components/responses/default"
</#macro>

<#macro remove removeOperation>
    post:
      operationId: "${removeOperation.uid}"
      summary: |
      <#if removeOperation.operationId??>
        ${ds.id}.${removeOperation.operationId}
      <#else>
        Remove ${ds.title}
      </#if>
      description: |
      <#if removeOperation.description??>
        <#list removeOperation.description as line>
        ${line?trim}
        </#list>
      <#else>
        Removes the given '${ds.id}' record, with request body values overriding / augmenting their corresponding query
        parameter values (where applicable).  Typical usage provides the value in either one place or the other, however.
      </#if>
      tags:
        - ${ds.id}
      parameters:
        <@parameters.dataFormat defaultValue=app.defaultDataFormat!"xml" />
      <#list removeOperation.parameters as field>
        - name: ${field.name}
          <@utils.describe indentation=10 field=field operation=removeOperation />
          in: query
          schema:
            <@utils.fielddef indentation=12 field=field />
      </#list>
      requestBody:
        <@utils.requestbodydef removeOperation />
      responses:
        200:
          <@response removeOperation />
        404:
          $ref: "#/components/responses/404"
        default:
          $ref: "#/components/responses/default"
</#macro>

<#macro batch operations>
    post:
      operationId: "${ds.id}_batchTransactions"
      summary: |
        Submit batch of ${ds.title} operations
      description: |
      tags:
        - ${ds.id}
      parameters:
        <@parameters.dataFormat defaultValue=app.defaultDataFormat!"xml" />
        - $ref: "#/components/parameters/sortBy"
        - $ref: "#/components/parameters/startRow"
        - $ref: "#/components/parameters/endRow"
        - $ref: "#/components/parameters/textMatchStyle"
      requestBody:
        content:
          application/json:
            schema:
              <@txrequest operations />
          application/xml:
            schema:
              <@txrequest operations />
      responses:
        200:
          <@txresponse operations />
        204:
          $ref: "#/components/responses/204"
        default:
          $ref: "#/components/responses/default"
</#macro>

<#macro response operation>
          description: |
            Expected Response.

        <#if app.wrapJSONResponses>
            Note that JSON responses are wrapped with a prefix/suffix pair as noted in the x-jsonWrapper element and illustrated in the example below.
            ```
              ${ds.jsonPrefix!app.jsonPrefix}
              {
                "response": {
                  "status": 0,
                  "queueStatus": 0,
                  "startRow": 0,
                  "endRow": 0,
                  "totalRows": 0,
                  "data": []
                }
              }
              ${ds.jsonSuffix!app.jsonSuffix}
            ```
          x-jsonWrapper:
            prefix: ${ds.jsonPrefix!app.jsonPrefix}
            suffix: ${ds.jsonSuffix!app.jsonSuffix}
        </#if>
          content:
            application/json:
              schema:
              <#if !operation.hasCustomOutput>
                $ref: '#/components/schemas/ResponseBodyModel'
              <#else>
                $ref: '#/components/schemas/${operation.uid}ResponseBodyModel'
              </#if>

</#macro>

<#macro txrequest operations>
              type: object
              properties:
                transaction:
                  type: object
                  properties:
                    operations:
                      type: array
                      items:
                        type: object
                        xml:
                          name: request
                        properties:
                          operationType:
                            type: string
                            description: |
                              Type of operation being performed: 'fetch', 'add', 'remove', 'update' or 'custom'.
                            enum: [fetch, add, update, remove, custom]
                        <#if ds.namedOperations?hasContent>
                          operationId:
                            type: string
                            description: |
                              Optional operationId if the given DataSource supports two or more variants of one of the basic DataSource operations, for instance, a "fetch" that uses full text search and a "fetch" that accepts per-field search criteria.
                            enum:
                          <#list ds.namedOperations as named>
                              - ${named.operationId}
                          </#list>
                        </#if>

                          startRow:
                            type: integer
                            description: |
                              Starting row of requested results, used only with fetch operations. If unset, 0 is assumed.  Note that startRow and endRow are zero-based, inclusive at the beginning and exclusive at the end (like substring), so startRow=0&endRow=1 is a request for the first record.
                          endRow:
                            type: integer
                            description: |
                              End row of requested results, used only with fetch operations. Note that startRow and endRow are zero-based, inclusive at the beginning and exclusive at the end (like substring), so startRow=0&endRow=1 is a request for the first record.
                          data:
                            oneOf:
                              - $ref: '#/components/schemas/${ds.id}'
                              - $ref: '#/components/schemas/Criteria'
                              - $ref: '#/components/schemas/AdvancedCriteria'
                            <#list operations as op>
                            <#if op.operationId?? && op.hasCustomCriteria>
                              - $ref: '#/components/schemas/${op.operationId}Criteria'
                              - $ref: '#/components/schemas/${op.operationId}AdvancedCriteria'
                            </#if>
                            </#list>
</#macro>

<#macro txresponse operations>
          description: |
            Expected Response.

        <#if app.wrapJSONResponses>
            Note that JSON responses are wrapped with a prefix/suffix pair as noted in the x-jsonWrapper element and illustrated in the example below.
            ```
              ${ds.jsonPrefix!app.jsonPrefix}
              {
                "response": {
                  "status": 0,
                  "queueStatus": 0,
                  "startRow": 0,
                  "endRow": 0,
                  "totalRows": 0,
                  "data": []
                }
              }
              ${ds.jsonSuffix!app.jsonSuffix}
            ```
          x-jsonWrapper:
            prefix: ${ds.jsonPrefix!app.jsonPrefix}
            suffix: ${ds.jsonSuffix!app.jsonSuffix}
        </#if>
          content:
            application/json:
              schema:
                title: Batch DSResponse
                type: array
                items:
                  anyOf:
                    - $ref: '#/components/schemas/ResponseBodyModel'
                  <#list operations as op>
                  <#if op.hasCustomOutput>
                    - $ref: '#/components/schemas/${op.uid}ResponseBodyModel'
                  </#if>
                  </#list>

</#macro>