/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.io.IOException;
import java.net.URL;
import java.util.jar.Attributes;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.util.FileObjectUtils;

class Resource {
    private final FileObject root;
    private final FileObject resource;
    private final FileObject packageFolder;
    private final String packageName;

    public Resource(String name, FileObject root, FileObject resource) throws FileSystemException {
        this.root = root;
        this.resource = resource;
        this.packageFolder = resource.getParent();
        int pos = name.lastIndexOf(47);
        this.packageName = pos == -1 ? null : name.substring(0, pos).replace('/', '.');
    }

    public URL getURL() throws FileSystemException {
        return this.resource.getURL();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getPackageAttribute(Attributes.Name attrName) throws FileSystemException {
        return (String)this.packageFolder.getContent().getAttribute(attrName.toString());
    }

    public FileObject getPackageFolder() {
        return this.packageFolder;
    }

    public FileObject getFileObject() {
        return this.resource;
    }

    public URL getCodeSourceURL() throws FileSystemException {
        return this.root.getURL();
    }

    public byte[] getBytes() throws IOException {
        return FileObjectUtils.getContentAsByteArray(this.resource);
    }
}

