/* Auto-Generated React */
import React from 'react';
import 'smartclient-lgpl/release';
import 'smartclient-lgpl/skins/Tahoe';

import { SC, AIDataQuestionItem, ButtonItem, Criterion, DynamicForm, IButton, SelectItem, VLayout } from 'smartclient-lgpl/react';

// a "render target" can be defined to allow JSX to be loaded dynamically into an existing application.  This Showcase sets a
// render target of "showcaseSample" so each JSX file can be loaded and later removed when the user is done with the sample.
let target = SC.getRenderTarget() || "showcaseSample";

let onGroupChanged = function (form, groupItem, group) {
    var sampleQuestionItem = form.getField('sampleQuestion'), questionItem = form.getField('question');
    sampleQuestionItem.clearValue();
    questionItem.clearValue();
    var customData = customDataByGroup[group];
    if (customData) {
        sampleQuestionItem.setValueMap(customData.sampleQuestions);
        questionItem.dataQuestionSettings = customData.dataQuestionSettings;
    }
};
let onCustomQuestionButtonClick = function (form, item) {
    isc.askForValue('Enter your custom question:', function (val) {
        if (val == null || String(val).trim() === '') {
            return;
        }
        form.setValue('question', val);
    });
};
let onSampleQuestionChanged = function (form, sampleQuestionItem, sampleQuestion) {
    form.clearErrors(true);
    form.setValue('question', sampleQuestion);
};
let onAskQuestionClick = function () {
    if (form.validate()) {
        var questionItem = form.getField('question');
        questionItem.setValue(questionItem.getValue());
    }
};

var defaultGroup = 'Sales Management';
var customDataByGroup = {
    'Classic Models Inc. Order Management': {
        dataQuestionSettings: {
            referenceTime: isc.DateUtil.createLogicalDate(2022, 6 - 1, 15),
            dataSourceNames: [
                'CM_ProductLine',
                'CM_Product',
                'CM_Office',
                'CM_Employee',
                'CM_Customer',
                'CM_Order',
                'CM_OrderDetail',
                'CM_Payment'
            ],
            applicationPurpose: 'Manage orders for Classic Models Inc. - a world-wide seller of ' + 'Classic Car, Vintage Car, Motorcycle, Truck and Bus, Plane, Ship, and Train models.'
        },
        sampleQuestions: [
            'What will happen if demand spikes in the US?',
            'Are some reps overselling or mis-selling, leading to higher disputes and cancellations?',
            'Are we at risk of not meeting order demand if we halve our stockholding?',
            'I would like an analysis of Disputed orders. Which customers have disputed orders, and how many? Which salespeople are involved?'
        ]
    },
    'Issue Tracking': {
        dataQuestionSettings: {
            referenceTime: isc.DateUtil.createLogicalDate(2023, 5 - 1, 15),
            dataSourceNames: [
                'iss_Department',
                'iss_IssueHistory',
                'iss_IssueMaster',
                'iss_IssueStatus',
                'iss_IssueType',
                'iss_Priority',
                'iss_Users',
                'iss_UserType'
            ]
        },
        sampleQuestions: [
            'Are we improving over time in terms of issue resolution?',
            'Are we prioritizing the right issues?'
        ]
    },
    'Accounts Management': {
        dataQuestionSettings: {
            referenceTime: isc.DateUtil.createLogicalDate(2022, 5 - 1, 15),
            dataSourceNames: [
                'acc_Customer',
                'acc_Employee',
                'acc_Invoice',
                'acc_invoiceLine',
                'acc_Office',
                'acc_Order',
                'acc_OrderLine',
                'acc_Payment',
                'acc_Product',
                'acc_ProductLine'
            ]
        },
        sampleQuestions: [
            'What is causing invoice payment delays, and how can we prevent them?',
            'How well are our payment terms being enforced and followed?'
        ]
    },
    'Sales Management': {
        dataQuestionSettings: {
            referenceTime: isc.DateUtil.createLogicalDate(2025, 3 - 1, 8),
            dataSourceNames: [
                'answerEngineDemo_Salespeople',
                'answerEngineDemo_Orders'
            ],
            applicationPurpose: 'Manage individual salesperson performance for California customers. ' + 'The users of this application are sales managers and executives who are interested ' + 'in seeing charts of total sales across all salespeople, identifying salespeople ' + 'whose performance is improving or worsening, seeing charts of individual salesperson ' + 'totals to compare and contrast with the performance of other salespeople, and a ' + 'grid of orders to further analyze why a salesperson\'s performance is improving or ' + 'worsening.'
        },
        sampleQuestions: [
            'What\'s causing the recent sales drop?',
            'Compare March 2025 sales to the previous month',
            'What was Henry\'s best month?'
        ]
    }
};

// SC.render() calls ReactDOM.render() in React pre-18, and
// ReactDOM.createRoot().render() in React 18+, to avoid deprecation warnings.
SC.render(
    <VLayout membersMargin="10" width="100%">
        <members>
            <DynamicForm ID="form" numCols="4" colWidths="100,300,150,*" cellPadding="5" width="100%" minWidth="850" maxWidth="1060">
                <items>
                    <SelectItem valueMap={isc.getKeys(customDataByGroup)} name="group" title="Data Sets" defaultValue={defaultGroup} wrapTitle="false" width="100%" endRow="true" required="true" changed={onGroupChanged}/>
                    <ButtonItem name="customQuestionButton" title="Custom Question" click={onCustomQuestionButtonClick}/>
                    <AIDataQuestionItem name="question" dataQuestionSettings={customDataByGroup[defaultGroup].dataQuestionSettings}>
                        <answerEngineOperationProperties>
                        	<autoShowResult>true</autoShowResult>
                        	<maxRecordsPerQuery>50</maxRecordsPerQuery>
                        </answerEngineOperationProperties>
                    </AIDataQuestionItem>
                    <SelectItem valueMap={customDataByGroup[defaultGroup].sampleQuestions} name="sampleQuestion" title="Sample Questions" width="100%" changed={onSampleQuestionChanged}>
                        <requiredWhen operator="or">
                            <criteria>
                                <Criterion fieldName="question" operator="isBlank"/>
                                <Criterion fieldName="question" operator="regexp" value="^\w+$"/>
                            </criteria>
                        </requiredWhen>
                    </SelectItem>
                </items>
            </DynamicForm>
            <IButton title="Ask Question" width="200" click={onAskQuestionClick}/>
        </members>
    </VLayout>,
    document.getElementById(target)
);
