/* Auto-Generated React */
import React from 'react';
import 'smartclient-lgpl/release';
import 'smartclient-lgpl/skins/Tahoe';

import { SC, DynamicForm, HLayout, IButton, ListGrid, SelectItem, StaticTextItem, VLayout } from 'smartclient-lgpl/react';

// a "render target" can be defined to allow JSX to be loaded dynamically into an existing application.  This Showcase sets a
// render target of "showcaseSample" so each JSX file can be loaded and later removed when the user is done with the sample.
let target = SC.getRenderTarget() || "showcaseSample";

let onGroupChanged = function (form, groupItem, group) {
    var samplePromptItem = form.getField('samplePrompt'), promptItem = form.getField('selectedPrompt');
    samplePromptItem.clearValue();
    promptItem.clearValue();
    buttonAI.setPrompt('');
    var customData = customDataByGroup[group];
    if (customData) {
        samplePromptItem.setValueMap(customData.samplePrompts);
        listGrid.setDataSource(group);
        listGrid.fetchData();
    }
};
let onSamplePromptChanged = function (form, item, value) {
    var promptItem = form.getField('selectedPrompt');
    promptItem.setValue(value);
    buttonAI.setPrompt(value);
};
let onButtonAIClick = function () {
    if (form.validate()) {
        var prompt = form.getField('selectedPrompt').getValue();
        listGrid.configureViaAI(prompt);
    }
};
let onCustomPromptClick = function () {
    listGrid.showAIConfigureWindow();
};

var defaultGroup = 'AE_Order', dsArray = {
        AE_Order: 'Orders',
        AE_IssueMaster: 'Issues',
        worldDS: 'Countries'
    };
var customDataByGroup = {
    'AE_Order': {
        samplePrompts: [
            'Show orders over $30k in the last nine months, starting with the largest order.',
            'Group my orders by Customer alphabetically and show the latest orders first.  Hilite order-totals less than 50k in red. Ignore any orders that are currently in Process.'
        ]
    },
    'AE_IssueMaster': {
        samplePrompts: [
            'Show issues with a medium to urgent priority, that took more than 4 days to close.',
            'Group the issues by assignee, showing the oldest open issues first. Ignore closed issues.'
        ]
    },
    'worldDS': { samplePrompts: ['Group by continent, sort by population, hilite GDP less than 20000 in red and GDP more than 100,000 in green, hide the area field, and show only countries that contain a c.'] }
};

// SC.render() calls ReactDOM.render() in React pre-18, and
// ReactDOM.createRoot().render() in React 18+, to avoid deprecation warnings.
SC.render(
    <VLayout membersMargin="10" width="100%">
        <members>
            <DynamicForm ID="form" cellPadding="5" width="100%" minWidth="850" maxWidth="1060">
                <items>
                    <SelectItem valueMap={dsArray} name="group" title="Data Sets" defaultValue={defaultGroup} wrapTitle="false" width="300" endRow="true" required="true" changed={onGroupChanged}/>
                    <SelectItem valueMap={customDataByGroup[defaultGroup].samplePrompts} name="samplePrompt" title="Sample Prompts" wrapTitle="false" width="300" required="true" changed={onSamplePromptChanged}/>
                    <StaticTextItem editorType="StaticText" name="selectedPrompt" title="Prompt" width="500"/>
                </items>
            </DynamicForm>
            <HLayout membersMargin="10" width="100%">
                <members>
                    <IButton title="Apply Prompt" ID="buttonAI" width="200" click={onButtonAIClick}/>
                    <IButton title="Custom Prompt" click={onCustomPromptClick}/>
                </members>
            </HLayout>
            <ListGrid ID="listGrid" dataSource={defaultGroup} autoFetchData="true" width="100%" height="500" canConfigureViaAI="true" showAllColumns="true" sortByGroupFirst="true" autoFitDateFields="title"/>
        </members>
    </VLayout>,
    document.getElementById(target)
);
