import React from 'react';
import { ILogicalComponent } from './core/ILogicalComponent';
import { AsComponentXML } from './core/ReactComponent';


declare interface CoTTransitionProps {

/**
 * See {@link isc.CoTTransition.label CoTTransition.label}.
 */
label?: string;

/**
 * See {@link isc.CoTTransition.visibleWhen CoTTransition.visibleWhen}.
 */
visibleWhen?: string | AdvancedCriteria;

/**
 * See {@link isc.CoTTransition.to CoTTransition.to}.
 */
to?: string;


children?: React.ReactElement<JSX.IntrinsicElements> |
           React.ReactElement<JSX.IntrinsicElements>[];

}


/**
 * CoTTransition wraps the SmartClient object
 * {@link isc.CoTTransition CoTTransition} for React, allowing you to import
 * CoTTransition for use in React JS and JSX.
 * @class
 */
declare class CoTTransition extends ILogicalComponent {
    props: AsComponentXML<CoTTransitionProps>;
}
