import React from 'react';
import { DataSource, DataSourceProps } from './DataSource';
import { AsComponentXML } from './core/ReactComponent';


declare interface ComponentSchemaProps extends DataSourceProps {

/**
 * See {@link isc.ComponentSchema.fields ComponentSchema.fields}.
 */
fields?: ComponentSchemaField[];


children?: React.ReactElement<JSX.IntrinsicElements> |
           React.ReactElement<JSX.IntrinsicElements>[];

}


/**
 * ComponentSchema wraps the SmartClient widget class
 * {@link isc.ComponentSchema ComponentSchema} for React, allowing you to import
 * ComponentSchema for use in React JS and JSX.
 * @class
 * @extends DataSource
 */
declare class ComponentSchema extends DataSource {
    props: AsComponentXML<ComponentSchemaProps>;
}
