/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.velocity;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.AdvancedCriteriaHandler;
import com.isomorphic.velocity.DataSourcesHandler;
import com.isomorphic.velocity.HttpAttributeHandler;
import com.isomorphic.velocity.HttpParameterHandler;
import com.isomorphic.velocity.ISCReferenceInsertionEventHandler;
import com.isomorphic.velocity.ResponseDataHandler;
import com.isomorphic.velocity.ResponsesHandler;
import com.isomorphic.velocity.ServletRequestAttributeMapFacade;
import com.isomorphic.velocity.SessionAttributeMapFacade;
import jakarta.servlet.http.HttpServletRequest;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class Velocity
extends Base {
    private static Logger log = new Logger(Velocity.class.getName());
    private static VelocityEngine vEngine;
    private static Boolean haveVelocityTools;
    private static Object toolManager;
    static final Object VELOCITY_TOOLS_LOCK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized VelocityEngine getEngine() throws Exception {
        if (vEngine != null) {
            return vEngine;
        }
        Properties velocityEngineDefaults = new Properties();
        velocityEngineDefaults.put("resource.loader.file.path", "");
        velocityEngineDefaults.put("runtime.log.name", "org.apache.Velocity");
        Properties velocityEngineProperties = new Properties();
        ISCFile velocityConfigFile = ISCFile.newInstance(DataTools.resourceFromClassLoader("velocity.properties"));
        if (velocityConfigFile.exists()) {
            log.info("Applying Velocity Engine configuration from: " + velocityConfigFile.getCanonicalPath());
            velocityEngineProperties.load(velocityConfigFile.getInputStream());
        }
        Enumeration<?> e = velocityEngineDefaults.propertyNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (velocityEngineProperties.containsKey(s)) continue;
            velocityEngineProperties.put(s, velocityEngineDefaults.get(s));
        }
        log.debug("Velocity config: " + DataTools.prettyPrint(velocityEngineProperties));
        Thread current = Thread.currentThread();
        ClassLoader oldLoader = current.getContextClassLoader();
        boolean loadSafely = Config.getGlobal().getBoolean((Object)"velocity.loadEngineSafely", false);
        try {
            if (loadSafely) {
                current.setContextClassLoader(Velocity.class.getClassLoader());
            }
            vEngine = new VelocityEngine();
            vEngine.init(velocityEngineProperties);
        }
        finally {
            if (loadSafely) {
                current.setContextClassLoader(oldLoader);
            }
        }
        return vEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context getContext(Map props) {
        Context toolContext = null;
        Object object = VELOCITY_TOOLS_LOCK;
        synchronized (object) {
            if (config.getBoolean((Object)"velocity.tools.enabled", true) && haveVelocityTools == null) {
                try {
                    toolManager = Reflection.instantiateClass("org.apache.velocity.tools.ToolManager");
                    Reflection.invokeMethod(toolManager, "setVelocityEngine", Velocity.getEngine());
                    URL url = DataTools.resourceFromClassLoader("tools.xml");
                    String configPath = url != null ? url.getPath() : "/org/apache/velocity/tools/generic/tools.xml";
                    Reflection.invokeMethod(toolManager, "configure", configPath);
                    haveVelocityTools = Boolean.TRUE;
                    log.info("Velocity Tools available, support enabled.");
                }
                catch (Exception e) {
                    haveVelocityTools = Boolean.FALSE;
                    log.info("Velocity Tools not available - using standard Velocity Contexts.");
                }
            }
            if (haveVelocityTools.booleanValue()) {
                try {
                    toolContext = (Context)Reflection.invokeMethod(toolManager, "createContext");
                }
                catch (Exception e) {
                    log.error((Object)"Unable to initialize Velocity ToolManager - using standard Velocity Context instead", e);
                }
            }
        }
        if (props != null) {
            Velocity.addRawValuesToContextMap(props, false);
        }
        VelocityContext vContext = props == null ? new VelocityContext(toolContext) : new VelocityContext(props, toolContext);
        return vContext;
    }

    public static void addRawValuesToContextMap(Map ctxMap, boolean forceRefresh) {
        if (ctxMap.containsKey("rawValue") && !forceRefresh) {
            return;
        }
        HashMap rawValue = new HashMap();
        Iterator i = ctxMap.keySet().iterator();
        while (i.hasNext()) {
            String key = i.next().toString();
            rawValue.put(key, ctxMap.get(key));
        }
        ctxMap.put("rawValue", rawValue);
    }

    public static Object evaluateTemplateFile(String fileName, Map parameters) throws Exception {
        ISCFile file = ISCFile.newInstance(DataTools.makePathAbsolute(fileName));
        return Velocity.evaluate(file.getAsString(), parameters);
    }

    public static String evaluateTemplateFileAsString(String fileName, Map parameters) throws Exception {
        String result = Velocity.evaluateAsString(fileName, parameters);
        if (result == null) {
            return null;
        }
        Object obj = Velocity.evaluateTemplateFile(result, parameters);
        return obj == null ? null : obj.toString();
    }

    public static String evaluateAsString(String template, Map parameters) throws Exception {
        Object obj = Velocity.evaluate(template, parameters);
        return obj == null ? null : obj.toString();
    }

    public static Object evaluate(String template, Map parameters) throws Exception {
        return Velocity.evaluate(template, parameters, "notProvided", null, false, false);
    }

    public static String evaluateAsString(String template, Map parameters, String operationName, DataSource ds, boolean quoteValues) throws Exception {
        return Velocity.evaluateAsString(template, parameters, operationName, ds, quoteValues, false);
    }

    public static String evaluateAsString(String template, Map parameters, String operationName, DataSource ds, boolean quoteValues, boolean failureMeansNull) throws Exception {
        String obj = Velocity.evaluateAsString(template, parameters, operationName, ds, quoteValues, failureMeansNull, null);
        return obj == null ? null : obj.toString();
    }

    public static String evaluateAsString(String template, Map parameters, String operationName, DataSource ds, boolean quoteValues, boolean failureMeansNull, Set<String> additionalEscapingExclusions) throws Exception {
        Object obj = Velocity.evaluate(template, parameters, operationName, ds, quoteValues, failureMeansNull, additionalEscapingExclusions, false);
        return obj == null ? null : obj.toString();
    }

    public static Object evaluate(String template, Map parameters, String operationName, DataSource ds, boolean quoteValues) throws Exception {
        return Velocity.evaluate(template, parameters, operationName, ds, quoteValues, false, null, false);
    }

    public static Object evaluate(String template, Map parameters, String operationName, DataSource ds, boolean quoteValues, boolean failureMeansNull) throws Exception {
        return Velocity.evaluate(template, parameters, operationName, ds, quoteValues, failureMeansNull, null, false);
    }

    public static Object evaluate(String template, Map parameters, String operationName, DataSource ds, boolean quoteValues, boolean failureMeansNull, boolean escapeStringValues) throws Exception {
        return Velocity.evaluate(template, parameters, operationName, ds, quoteValues, failureMeansNull, null, escapeStringValues);
    }

    public static Object evaluate(String template, Map parameters, String operationName, DataSource ds, boolean quoteValues, boolean failureMeansNull, Set<String> additionalEscapingExclusions, boolean escapeStringValues) throws Exception {
        if (template == null) {
            throw new NullPointerException("The template String provided for Velocity evaluation is null. Operation name is '" + operationName + "'");
        }
        StringWriter out = new StringWriter();
        Context context = Velocity.getContext(parameters);
        ISCReferenceInsertionEventHandler handler = new ISCReferenceInsertionEventHandler(context, ds, quoteValues, escapeStringValues, additionalEscapingExclusions);
        if (!Velocity.getEngine().evaluate(context, (Writer)out, operationName, template)) {
            return null;
        }
        if (handler.foundObject != null && handler.foundObject.toString().equals(out.toString())) {
            return handler.foundObject;
        }
        if (failureMeansNull && handler.nullReferences && template.equals(out.toString())) {
            return null;
        }
        return out.toString();
    }

    public static Boolean evaluateBooleanExpression(String template, Map parameters) throws Exception {
        return Velocity.evaluateBooleanExpression(template, parameters, "notProvided", null);
    }

    public static Boolean evaluateBooleanExpression(String template, Map parameters, String operationName, DataSource ds) throws Exception {
        Object obj2 = null;
        Object obj = Velocity.evaluate(template, parameters, operationName, ds, true, false, null, false);
        if (!(obj != null && (obj instanceof Boolean || obj.toString().trim().toLowerCase().equals("true") || obj.toString().trim().toLowerCase().equals("false") || obj.toString().trim().toLowerCase().equals("'true'") || obj.toString().trim().toLowerCase().equals("'false'")))) {
            String postEval = obj.toString();
            if (template.indexOf("'true'") == -1) {
                postEval = postEval.replaceAll("'true'", "true");
            }
            if (template.indexOf("'false'") == -1) {
                postEval = postEval.replaceAll("'false'", "false");
            }
            String wrappedTemplate = "#if(" + postEval + ") true #else false #end";
            try {
                obj = Velocity.evaluate(wrappedTemplate, parameters, operationName, ds, true, false);
            }
            catch (Exception e) {
                log.warn(e);
            }
        }
        if (obj != null) {
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            if (obj.toString().trim().toLowerCase().equals("true")) {
                return Boolean.TRUE;
            }
            if (obj.toString().trim().toLowerCase().equals("'true'")) {
                return Boolean.TRUE;
            }
            if (obj.toString().trim().toLowerCase().equals("false")) {
                return Boolean.FALSE;
            }
            if (obj.toString().trim().toLowerCase().equals("'false'")) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static String evaluateWithSnippets(String template, Map parameters, String operationName, DSRequest req, boolean quoteValues, boolean failureMeansNull) throws Exception {
        boolean searchForVelocityVariables = config.getBoolean((Object)"velocity.searchForVariables.enabled", true);
        if (searchForVelocityVariables && !template.contains("$")) {
            return template;
        }
        Set<String> snippets = req.getSnippetNames();
        for (String snippetName : snippets) {
            String snippetTemplate = "";
            if (parameters.get(snippetName) instanceof String) {
                snippetTemplate = (String)parameters.get(snippetName);
            } else {
                snippetTemplate = parameters.get(snippetName).toString();
                log.warn("A non-string was provided as a snippet: " + snippetTemplate);
            }
            String result = Velocity.evaluateAsString(snippetTemplate, parameters, "evaluate snippet " + snippetName, req.getDataSource(), quoteValues, failureMeansNull);
            parameters.put(snippetName, result);
        }
        return Velocity.evaluateAsString(template, parameters, operationName, req.getDataSource(), quoteValues, failureMeansNull, snippets);
    }

    public static Map<Object, Object> getStandardContextMap(DSRequest dsReq) {
        return Velocity.getStandardContextMap(dsReq, null);
    }

    public static Map<Object, Object> getStandardContextMap(DSRequest dsReq, int valueSetIndex) {
        return Velocity.getStandardContextMap(dsReq, null, valueSetIndex);
    }

    public static Map<Object, Object> getStandardContextMap(DSRequest dsReq, String fieldName) {
        return Velocity.getStandardContextMap(dsReq, fieldName, 0);
    }

    public static Map<Object, Object> getStandardContextMap(DSRequest dsReq, String fieldName, int valueSetIndex) {
        Map values;
        Map criteria;
        HashMap<Object, Object> context = new HashMap<Object, Object>();
        context.put("config", (Object)config);
        context.put("dataSources", new DataSourcesHandler(dsReq));
        context.put("util", new DataTools());
        context.put("log", new Logger("velocityTemplate"));
        if (dsReq == null) {
            DSRequest dummyReq = new DSRequest();
            context.put("currentDate", dummyReq.getCurrentDate());
            context.put("transactionDate", dummyReq.getCurrentDate());
            context.put("currentDateUTC", dummyReq.getCurrentDateUTC());
            context.put("transactionDateUTC", dummyReq.getCurrentDateUTC());
            context.put("currentDateTime", dummyReq.getCurrentDateTime());
            context.put("transactionDateTime", dummyReq.getCurrentDateTime());
            context.put("currentDateTimeUTC", dummyReq.getCurrentDateTimeUTC());
            context.put("transactionDateTimeUTC", dummyReq.getCurrentDateTimeUTC());
            return context;
        }
        if (dsReq.getDsTransaction() != null) {
            context.putAll(dsReq.getDsTransaction().getTemplateContext());
            context.put("responseData", new ResponseDataHandler(dsReq.getDsTransaction()));
            context.put("responses", new ResponsesHandler(dsReq.getDsTransaction()));
            if (context.get("currentDate") == null) {
                context.put("currentDate", dsReq.getCurrentDate());
            }
            if (context.get("currentDateUTC") == null) {
                context.put("currentDateUTC", dsReq.getCurrentDateUTC());
            }
            if (context.get("transactionDate") == null) {
                context.put("transactionDate", dsReq.getCurrentDate());
            }
            if (context.get("transactionDateUTC") == null) {
                context.put("transactionDateUTC", dsReq.getCurrentDateUTC());
            }
            if (context.get("currentDateTime") == null) {
                context.put("currentDateTime", dsReq.getCurrentDateTime());
            }
            if (context.get("currentDateTimeUTC") == null) {
                context.put("currentDateTimeUTC", dsReq.getCurrentDateTimeUTC());
            }
            if (context.get("transactionDateTime") == null) {
                context.put("transactionDateTime", dsReq.getCurrentDateTime());
            }
            if (context.get("transactionDateTimeUTC") == null) {
                context.put("transactionDateTimeUTC", dsReq.getCurrentDateTimeUTC());
            }
        } else {
            context.put("currentDate", dsReq.getCurrentDate());
            context.put("transactionDate", dsReq.getCurrentDate());
            context.put("currentDateUTC", dsReq.getCurrentDateUTC());
            context.put("transactionDateUTC", dsReq.getCurrentDateUTC());
            context.put("currentDateTime", dsReq.getCurrentDateTime());
            context.put("transactionDateTime", dsReq.getCurrentDateTime());
            context.put("currentDateTimeUTC", dsReq.getCurrentDateTimeUTC());
            context.put("transactionDateTimeUTC", dsReq.getCurrentDateTimeUTC());
        }
        context.put("timeZone", dsReq.hasParameter("timeZone") ? dsReq.getParameter("timeZone") : "UTC");
        context.put("timeZoneOffset", dsReq.hasParameter("timeZoneOffset") ? dsReq.getParameter("timeZoneOffset") : Integer.valueOf(0));
        if (valueSetIndex <= 0) {
            criteria = dsReq.getCriteria(false) != null ? new HashMap(dsReq.getCriteria(false)) : new HashMap();
            values = dsReq.getValueSets().size() > 1 ? (Map)dsReq.getValueSets().get(0) : dsReq.getValues();
            if (values == null) {
                values = new HashMap();
            }
            values = new HashMap(values);
        } else {
            Object crit = dsReq.getRawCriteria();
            if (crit instanceof List && ((List)crit).size() > valueSetIndex) {
                criteria = (Map)((List)crit).get(valueSetIndex);
            } else {
                log.warn("Velocity.getStandardContextMap() called with a valueSetIndex of " + valueSetIndex + " but the dsRequest criteria " + (String)(crit instanceof List ? "only has " + ((List)crit).size() + " entries" : "is not an instance of List") + ". Setting empty criteria");
                criteria = new HashMap();
            }
            List valueSets = dsReq.getValueSets();
            if (valueSets.size() > valueSetIndex) {
                values = (Map)valueSets.get(valueSetIndex);
            } else {
                log.warn("Velocity.getStandardContextMap() called with a valueSetIndex of " + valueSetIndex + " but the dsRequest only has " + valueSets.size() + " entries.  Setting empty values");
                values = new HashMap();
            }
        }
        context.put("criteria", criteria);
        context.put("values", values);
        context.put("dsRequest", dsReq);
        context.put("primaryDSRequest", dsReq.getPrimaryDSRequest());
        context.put("advancedCriteria", new AdvancedCriteriaHandler(dsReq));
        context.putAll(Velocity.getServletContextMap(dsReq.context));
        context.put("userId", dsReq.getUserId());
        Velocity.setMasterIdHandler(context, dsReq, fieldName);
        if (dsReq.getTemplateContext() != null) {
            for (Object subCriteria : dsReq.getTemplateContext().keySet()) {
                String key = (String)subCriteria;
                if (context.get(key) != null) {
                    log.warning("DSRequest-specified template context variable: " + key + " collides with derived key of the same name - using the DSRequest-specified value.");
                }
                context.put(key, dsReq.getTemplateContext().get(key));
            }
        }
        return context;
    }

    public static void setMasterIdHandler(Map context, DSRequest dsReq, String fieldName) {
        if (fieldName == null) {
            return;
        }
        try {
            context.put("masterId", dsReq.getMasterId(fieldName, false));
        }
        catch (Exception e) {
            log.warn("Error trying to obtain masterId for DataSource " + dsReq.getDataSourceName() + ", field " + fieldName);
        }
    }

    public static Map getServletContextMap(RPCManager rpc) {
        if (rpc == null) {
            return new HashMap();
        }
        return Velocity.getServletContextMap(rpc.getContext());
    }

    public static Map getServletContextMap(RequestContext reqContext) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        ServletRequestAttributeMapFacade escRequest = null;
        SessionAttributeMapFacade escSession = null;
        if (reqContext != null) {
            escRequest = new ServletRequestAttributeMapFacade((HttpServletRequest)reqContext.request);
            if (reqContext.request != null) {
                escSession = new SessionAttributeMapFacade(reqContext.request.getSession(false));
            }
        }
        context.put("httpParameters", new HttpParameterHandler((HttpServletRequest)escRequest));
        context.put("requestAttributes", new HttpAttributeHandler((HttpServletRequest)escRequest));
        context.put("sessionAttributes", new HttpAttributeHandler(escSession));
        if (escRequest != null) {
            context.put("servletRequest", escRequest);
        }
        if (escSession != null) {
            context.put("session", escSession);
        }
        return context;
    }

    public static Map getServletContextMap(HttpServletRequest req) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        ServletRequestAttributeMapFacade escRequest = null;
        SessionAttributeMapFacade escSession = null;
        escRequest = new ServletRequestAttributeMapFacade(req);
        if (req != null) {
            escSession = new SessionAttributeMapFacade(req.getSession(false));
        }
        context.put("httpParameters", new HttpParameterHandler((HttpServletRequest)escRequest));
        context.put("requestAttributes", new HttpAttributeHandler((HttpServletRequest)escRequest));
        context.put("sessionAttributes", new HttpAttributeHandler(escSession));
        if (escRequest != null) {
            context.put("servletRequest", escRequest);
        }
        if (escSession != null) {
            context.put("session", escSession);
        }
        return context;
    }

    static {
        haveVelocityTools = null;
        toolManager = null;
        VELOCITY_TOOLS_LOCK = new Object();
    }
}

