/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.scripting;

import com.isomorphic.log.Logger;
import com.isomorphic.scripting.PolyglotScriptEngine;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class JSEngineManager {
    private static final Logger log = new Logger(JSEngineManager.class.getName());
    private static final AtomicBoolean detectionLogged = new AtomicBoolean(false);
    private static volatile EngineInfo cachedEngineInfo = null;
    private static final Object initLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EngineInfo detectEngines(ClassLoader classLoader) {
        if (cachedEngineInfo != null) {
            return cachedEngineInfo;
        }
        Object object = initLock;
        synchronized (object) {
            EngineInfo result;
            if (cachedEngineInfo != null) {
                return cachedEngineInfo;
            }
            boolean shouldLog = detectionLogged.compareAndSet(false, true);
            cachedEngineInfo = result = JSEngineManager.doDetection(classLoader, shouldLog);
            return result;
        }
    }

    private static EngineInfo doDetection(ClassLoader classLoader, boolean shouldLog) {
        String implementingClass;
        String selectedMode;
        String selectedVersion;
        String selectedName;
        boolean nashornAvailable;
        boolean v8Available;
        boolean nashornCompatAvailable;
        boolean jsr223Available;
        boolean polyglotAvailable;
        block46: {
            block45: {
                block44: {
                    block43: {
                        if (shouldLog) {
                            log.info("=== JavaScript Engine Detection ===");
                        }
                        polyglotAvailable = false;
                        jsr223Available = false;
                        nashornCompatAvailable = false;
                        v8Available = false;
                        nashornAvailable = false;
                        selectedName = null;
                        selectedVersion = null;
                        selectedMode = null;
                        implementingClass = null;
                        if (shouldLog) {
                            log.info("Checking for GraalJS Polyglot API...");
                        }
                        try {
                            Class<?> contextClass = Class.forName("org.graalvm.polyglot.Context", true, classLoader);
                            polyglotAvailable = true;
                            String graalVersion = JSEngineManager.getGraalVersion(classLoader);
                            if (shouldLog) {
                                log.info("  \u2713 GraalJS Polyglot API available" + (String)(graalVersion != null ? " (version " + graalVersion + ")" : ""));
                            }
                            try {
                                Method newBuilderMethod = contextClass.getMethod("newBuilder", String[].class);
                                Object builder = newBuilderMethod.invoke(null, new Object[]{new String[]{"js"}});
                                Class<?> builderClass = Class.forName("org.graalvm.polyglot.Context$Builder", true, classLoader);
                                Method allowAllAccessMethod = builderClass.getMethod("allowAllAccess", Boolean.TYPE);
                                builder = allowAllAccessMethod.invoke(builder, true);
                                Method buildMethod = builderClass.getMethod("build", new Class[0]);
                                Object context = buildMethod.invoke(builder, new Object[0]);
                                Method closeMethod = contextClass.getMethod("close", new Class[0]);
                                closeMethod.invoke(context, new Object[0]);
                                selectedName = "GraalJS";
                                selectedVersion = graalVersion != null ? graalVersion : "unknown";
                                selectedMode = "polyglot";
                                implementingClass = "com.isomorphic.scripting.PolyglotScriptEngine";
                                if (shouldLog) {
                                    log.info("  \u2713 GraalJS Polyglot Context creation successful");
                                }
                            }
                            catch (Exception e) {
                                if (shouldLog) {
                                    log.info("  \u2717 GraalJS Polyglot Context creation failed: " + e.getMessage());
                                }
                            }
                        }
                        catch (ClassNotFoundException e) {
                            if (!shouldLog) break block43;
                            log.info("  \u2717 GraalJS Polyglot API not found (org.graalvm.polyglot.Context not in classpath)");
                        }
                    }
                    if (shouldLog) {
                        log.info("Checking for GraalJS via JSR-223...");
                    }
                    try {
                        Class<?> graalFactoryClass = Class.forName("com.oracle.truffle.js.scriptengine.GraalJSEngineFactory", true, classLoader);
                        jsr223Available = true;
                        if (shouldLog) {
                            log.info("  \u2713 GraalJS JSR-223 ScriptEngineFactory available");
                        }
                        if (selectedName != null) break block44;
                        try {
                            Object factory = graalFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            ScriptEngine engine = (ScriptEngine)graalFactoryClass.getMethod("getScriptEngine", new Class[0]).invoke(factory, new Object[0]);
                            if (engine != null) {
                                selectedName = engine.getFactory().getEngineName();
                                selectedVersion = engine.getFactory().getEngineVersion();
                                selectedMode = "jsr223";
                                implementingClass = engine.getClass().getName();
                                if (shouldLog) {
                                    log.info("  \u2713 GraalJS JSR-223 engine created successfully");
                                }
                            }
                        }
                        catch (Exception e) {
                            if (shouldLog) {
                                log.info("  \u2717 GraalJS JSR-223 engine creation failed: " + e.getMessage());
                            }
                        }
                    }
                    catch (ClassNotFoundException e) {
                        if (!shouldLog) break block44;
                        log.info("  \u2717 GraalJS JSR-223 not found (GraalJSEngineFactory not in classpath)");
                    }
                }
                if (polyglotAvailable || jsr223Available) {
                    nashornCompatAvailable = true;
                    if (shouldLog) {
                        log.info("  \u2713 GraalJS Nashorn compatibility mode available (via shims)");
                    }
                }
                if (shouldLog) {
                    log.info("Checking for V8 via J2V8...");
                }
                try {
                    Class<?> v8Class = Class.forName("com.eclipsesource.v8.V8", true, classLoader);
                    v8Available = true;
                    if (shouldLog) {
                        log.info("  \u2713 J2V8 (V8 JavaScript engine) available");
                    }
                    if (selectedName != null) break block45;
                    try {
                        Object v8 = v8Class.getMethod("createV8Runtime", new Class[0]).invoke(null, new Object[0]);
                        if (v8 != null) {
                            selectedName = "V8";
                            selectedVersion = JSEngineManager.getV8Version(v8Class, v8);
                            selectedMode = "v8";
                            implementingClass = v8Class.getName();
                            v8Class.getMethod("release", new Class[0]).invoke(v8, new Object[0]);
                            if (shouldLog) {
                                log.info("  \u2713 V8 runtime created successfully (version " + selectedVersion + ")");
                            }
                        }
                    }
                    catch (Exception e) {
                        if (shouldLog) {
                            log.info("  \u2717 V8 runtime creation failed (native libraries may be missing): " + e.getMessage());
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    if (!shouldLog) break block45;
                    log.info("  \u2717 J2V8 not found (com.eclipsesource.v8.V8 not in classpath)");
                }
            }
            if (shouldLog) {
                log.info("Checking for Nashorn...");
            }
            try {
                ScriptEngineManager manager = new ScriptEngineManager(classLoader);
                ScriptEngine nashornEngine = manager.getEngineByName("nashorn");
                if (nashornEngine != null) {
                    nashornAvailable = true;
                    String engineName = nashornEngine.getFactory().getEngineName();
                    String engineVersion = nashornEngine.getFactory().getEngineVersion();
                    if (shouldLog) {
                        log.info("  \u2713 Nashorn available: " + engineName + " " + engineVersion);
                    }
                    if (selectedName == null) {
                        selectedName = engineName;
                        selectedVersion = engineVersion;
                        selectedMode = "nashorn";
                        implementingClass = nashornEngine.getClass().getName();
                    }
                } else {
                    String factoryName;
                    nashornEngine = manager.getEngineByName("javascript");
                    if (nashornEngine != null && (factoryName = nashornEngine.getFactory().getEngineName()) != null && factoryName.toLowerCase().contains("nashorn")) {
                        nashornAvailable = true;
                        if (shouldLog) {
                            log.info("  \u2713 Nashorn available via 'javascript' name: " + factoryName);
                        }
                        if (selectedName == null) {
                            selectedName = factoryName;
                            selectedVersion = nashornEngine.getFactory().getEngineVersion();
                            selectedMode = "nashorn";
                            implementingClass = nashornEngine.getClass().getName();
                        }
                    }
                }
                if (!nashornAvailable && shouldLog) {
                    log.info("  \u2717 Nashorn not available (removed in Java 15+, add nashorn-core.jar for standalone Nashorn)");
                }
            }
            catch (Exception e) {
                if (!shouldLog) break block46;
                log.info("  \u2717 Error checking for Nashorn: " + e.getMessage());
            }
        }
        if (shouldLog) {
            log.info("=== JavaScript Engine Selection ===");
            if (selectedName != null) {
                log.info("Selected engine: " + selectedName + " " + selectedVersion);
                log.info("Mode: " + selectedMode);
                log.info("Implementing class: " + implementingClass);
            } else {
                log.warn("No JavaScript engine available!");
                log.warn("Please add one of the following to your classpath:");
                log.warn("  - GraalJS JARs (recommended): js-*.jar, truffle-api-*.jar, polyglot-*.jar");
                log.warn("  - J2V8 JARs: j2v8_*.jar with platform-specific native libraries");
                log.warn("  - Nashorn JAR (Java 15+): nashorn-core-*.jar, asm-*.jar");
            }
            log.info("===================================");
        }
        return new EngineInfo(selectedName != null ? selectedName : "None", selectedVersion != null ? selectedVersion : "N/A", selectedMode != null ? selectedMode : "none", polyglotAvailable, jsr223Available, nashornCompatAvailable, v8Available, nashornAvailable, implementingClass != null ? implementingClass : "N/A");
    }

    private static String getGraalVersion(ClassLoader classLoader) {
        try {
            Class<?> versionClass = Class.forName("org.graalvm.home.Version", true, classLoader);
            Method getCurrent = versionClass.getMethod("getCurrent", new Class[0]);
            Object version = getCurrent.invoke(null, new Object[0]);
            return version != null ? version.toString() : null;
        }
        catch (Exception e) {
            try {
                Package pkg = Package.getPackage("org.graalvm.polyglot");
                if (pkg != null && pkg.getImplementationVersion() != null) {
                    return pkg.getImplementationVersion();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    private static String getV8Version(Class<?> v8Class, Object v8) {
        try {
            Method getVersion = v8Class.getMethod("getV8Version", new Class[0]);
            Object version = getVersion.invoke(v8, new Object[0]);
            return version != null ? version.toString() : "unknown";
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    public static ScriptEngine createEngine(ClassLoader classLoader) {
        PolyglotScriptEngine engine;
        EngineInfo info = JSEngineManager.detectEngines(classLoader);
        if (info.polyglotAvailable && (engine = PolyglotScriptEngine.create(classLoader)) != null) {
            return engine;
        }
        try {
            ScriptEngineManager manager = new ScriptEngineManager(classLoader);
            ScriptEngine engine2 = manager.getEngineByName("graal.js");
            if (engine2 != null) {
                return engine2;
            }
            engine2 = manager.getEngineByName("nashorn");
            if (engine2 != null) {
                return engine2;
            }
            engine2 = manager.getEngineByName("javascript");
            if (engine2 != null) {
                return engine2;
            }
        }
        catch (Exception e) {
            log.warn("Error creating JavaScript engine: " + e.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetDetection() {
        Object object = initLock;
        synchronized (object) {
            cachedEngineInfo = null;
            detectionLogged.set(false);
        }
    }

    public static EngineInfo getCachedInfo() {
        return cachedEngineInfo;
    }

    public static class EngineInfo {
        public final String name;
        public final String version;
        public final String mode;
        public final boolean polyglotAvailable;
        public final boolean jsr223Available;
        public final boolean nashornCompatAvailable;
        public final boolean v8Available;
        public final boolean nashornAvailable;
        public final String implementingClass;

        public EngineInfo(String name, String version, String mode, boolean polyglotAvailable, boolean jsr223Available, boolean nashornCompatAvailable, boolean v8Available, boolean nashornAvailable, String implementingClass) {
            this.name = name;
            this.version = version;
            this.mode = mode;
            this.polyglotAvailable = polyglotAvailable;
            this.jsr223Available = jsr223Available;
            this.nashornCompatAvailable = nashornCompatAvailable;
            this.v8Available = v8Available;
            this.nashornAvailable = nashornAvailable;
            this.implementingClass = implementingClass;
        }

        public String toString() {
            return this.name + " " + this.version + " (" + this.mode + ")";
        }
    }
}

