/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.auth;

import com.isomorphic.auth.BearerTokenAuthenticator;
import com.isomorphic.base.Service;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.criteria.criterion.SimpleCriterion;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class BearerTokenReaper
extends Service {
    public String authenticator;
    public String tokenDataSource;
    public String tokenExpiresField;
    public int allowableDriftSeconds;

    @Override
    public void completeInit() throws Exception {
        if (this.authenticator != null) {
            BearerTokenAuthenticator bta = (BearerTokenAuthenticator)config.getClassInstance("authenticator." + this.authenticator);
            this.tokenDataSource = bta.tokenDataSource;
            this.tokenExpiresField = bta.tokenExpiresField;
            this.allowableDriftSeconds = bta.allowableDriftSeconds;
        }
    }

    @Override
    public String getLogContext() {
        if (this.authenticator != null) {
            return "authenticator: " + this.authenticator;
        }
        return "datasource: " + this.tokenDataSource;
    }

    @Override
    public Object execute() throws Exception {
        DateTime nowMinusAllowableDrift = new DateTime(DateTimeZone.UTC).minusSeconds(this.allowableDriftSeconds);
        int expiresSeconds = Math.round(nowMinusAllowableDrift.getMillis() / 1000L);
        AdvancedCriteria criteria = new AdvancedCriteria(DefaultOperators.And, new SimpleCriterion(this.tokenExpiresField, "lessThan", (Object)expiresSeconds));
        DSResponse dsResponse = new DSRequest(this.tokenDataSource, "remove").setCriteria(criteria).execute();
        this.log.debug("Reaped " + dsResponse.getRowCount() + " expired tokens (older than: " + nowMinusAllowableDrift.toString() + ")");
        return null;
    }
}

