# Java Module Dependencies

[← Back to API Index](../reference.md)

---

## KB Topic: Java Module Dependencies

### Description
Note that if you are using GWT, GWT itself also has an Apache 2.0 license, however tools and test environments that you may use during development have different license (such as Eclipse - Eclipse Public License). Also, specific GWT widgets, not required by Smart GWT, have licenses different from core GWT (such as JFreeChart's LGPL license). See [Google's summary of terms](http://code.google.com/webtoolkit/terms.html) for details.

If you are using [server scripting](serverScript.md#kb-topic-server-scripting) with the Javascript language, dependencies are JVM-specific. Java versions earlier than 6 do not include JSR223 support at all, so server scripting is not an option with those JVMs. Versions of the Oracle and OpenJDK JVMs from 6 to 14 inclusive include a JS engine by default - Rhino in Java 6 and 7, and Nashorn from 8 to 14 - so Javascript server scripting works out of the box with no dependencies with those versions. Oracle and OpenJDK JVMs from version 15 onwards do not include JS support automatically. However, we ship the standalone OpenJDK implementation of Nashorn with SmartClient, so Javascript scripting still works out of the box as long as you leave that dependency in place. You can also leave that dependency in place with JDK versions from 8 to 14 - the OpenJDK implementation will mask the built-in Oracle implementation, but you should not notice any difference. See the Server Scripting documentation for more details of your options with this.

[Maven](mavenSupport.md#kb-topic-maven-support) users should generally refer to the POMs bundled with the SDK, and installed for them by the official [Isomorphic plugin for Maven](http://github.smartclient.com/isc-maven-plugin/). For others, the following is a short description of the functionality contained in each SmartClient server JAR, and a link to the documentation listing its dependencies. Please refer to that documentation for more detail on the dependency graph, including version numbers, transitive dependencies, and licensing.

.jmd-module { width: 140px; text-align: right; vertical-align: top; padding-right: 10px; } .jmd-optional { text-decoration: underline; margin-top: 10px; margin-bottom: 8px; }

| isomorphic_core_rpc | This is the core SmartClient module. It provides the RPC, DMI, and DataSource support. Please note that both commons-collections-3.x and commons-collections4-4.x are required and safe to include side by side in the CLASSPATH (different third party libs rely on one or the other). The same is true of commons-lang and commons-lang3.Optional Dependenciesfreemarker - if you're using the built-in support for REST via the [RESTHandler servlet](servletDetails.md#kb-topic-the-core-and-optional-smartclient-servlets) servletisomorphic_js_parser - if you're using the built-in support for REST via the [RESTHandler servlet](servletDetails.md#kb-topic-the-core-and-optional-smartclient-servlets) servlet with JSON payloadsxercesImpl - if you're using JDK < 1.5javax.mail - if you plan to use the Mail messaging featurejavax.persistence - if you plan to use the metadata-from-annotations feature. Note that if you are using JPA, or a recent version of Hibernate, then you are probably already using this library.poi and commons-math - if you plan to export datasets in Microsoft Excel 97 (xls) or 2007 (xlsx) formats.poi-ooxml, poi-ooxml-schemas, and commons-compress - also needed if you plan to export data in Excel 2007 (xlsx) formatisomorphic_contentexport - if you plan to export to PDF formatisomorphic_jpa - if you plan to use BatchDS Generator (even if you are not using JPA, although the generated DataSources will not require JPA at runtime if you are not using JPA).log4j - if you plan to use log4j logging (used by default)slf4j-log4j12 - if you plan to use slf4j with log4j (for example), or any other slf4j bridge library depending on which logging framework will be used. See [serverLogging](serverLogging.md#kb-topic-server-logging) for information on server-side logging and how to configure it.groovy - if you plan to use Groovy with the [serverScript](serverScript.md#kb-topic-server-scripting) feature. Note, we also recommend that you use Groovy as the evaluation engine if you intend to use Java as an inline scripting language. See the "Server Scripting" documentation.commons-digester3 and commons-beanutils - if you plan to use Velocity Tools.nashorn-core and asm-util - if you are using server scripting with the Javascript language, and you want out of the box support with JDK versions from 15 onwards, as described in the paragraph aboveparquet-hadoop-bundle - columnar reader/writer and schema APIs for Parquet files; enables reading row groups, pages and converting values to Java types as used by the fetcher.hadoop-common - Hadoop core utilities and filesystem/config plumbing that Parquet’s Hadoop layer links against, even when reading over HTTP instead of HDFS.hadoop-mapreduce-client-core - MapReduce abstractions (InputSplit, job/config classes) that Parquet’s Hadoop integration references for compatibility; no MR jobs are run here, but the APIs must be present on the classpath.hadoop-shaded-protobuf_3_7 - shaded Protobuf runtime required by Hadoop internals used transitively by the Parquet Hadoop layer; avoids clashing with other protobuf versions.hadoop-shaded-guava - shaded Guava utilities used by Hadoop/Parquet (collections, I/O helpers, preconditions) without exposing Guava to the app’s dependency graph.snappy-java - native/portable Snappy codec to decompress Parquet column chunks that are Snappy-encoded; needed for fast reads of compressed datasets.woodstox-core - high-performance StAX XML parser used by Hadoop for reading XML configs and other streaming XML tasks required by transitive code paths.stax2-api - StAX2 extension API implemented by Woodstox; required at runtime whenever Woodstox is on the classpath to satisfy XML stream parser interfaces. |
|---|---|
| isomorphic_contentexport | Provides support for PDF Export.Optional Dependenciesbatik-anim, batik-awt-util, batik-bridge, batik-css, batik-dom, batik-ext, batik-gvt, batik-parser, batik-script, batik-svg-dom, batik-util, batik-xml -These are all required to use [RPCManager.exportImage](../classes/RPCManager.md#classmethod-rpcmanagerexportimage), or when using [RPCManager.exportContent](../classes/RPCManager.md#classmethod-rpcmanagerexportcontent) to export a DrawPane or FacetChart only in IE8 or earlier, or if a DrawPane has a DrawImage which loads a cross-domain image.NOTE: Between iText 2.0.x and iText 2.1.x there is a binary (but not source) incompatibility that causes a server-side NoSuchMethodError when exporting, e.g., charts in Internet Explorer. This is a known issue with the Flying Saucer product that is fixed by using core-renderer-R8-isomorphic.jar and iText-2.1.7.jar in the lib-iTextAlternate/ directory instead of core-renderer.jar and iText-2.0.8.jar in the lib/ directory. To use iText 2.1.7 with the Server Framework, exclude lib/core-renderer.jar and lib/iText-2.0.x.jar from the application's classpath and instead add lib-iTextAlternate/core-renderer-R8-isomorphic.jar and lib-iTextAlternate/iText-2.1.7.jar. |
| isomorphic_tools | Contains back-end logic for the "Admin Console" tool visible in the Developer Console, and also standalone from the SDK home page. Also contains the various data importers and exporters, and the server-side components of the BatchUploader. |
| isomorphic_cdi | Support for [DMI](dmiOverview.md#kb-topic-direct-method-invocation) dispatches to Spring beans (via [ServerObject.lookupStyle](../classes/ServerObject.md#attr-serverobjectlookupstyle) : "cdi"). |
| isomorphic_spring | Support for [DMI](dmiOverview.md#kb-topic-direct-method-invocation) dispatches to Spring beans (via [ServerObject.lookupStyle](../classes/ServerObject.md#attr-serverobjectlookupstyle) : "spring"). |
| isomorphic_spring_hibernate3 | Support for Spring + Hibernate 3, see the Compatibility section of [springIntegration](springIntegration.md#kb-topic-integration-with-spring) for more details. |
| isomorphic_realtime_messaging | Server support required for the SmartClient Realtime Messaging Module. Install this if you're using this 'push' technology. For more information, see [Messaging](messaging.md#kb-topic-real-time-messaging). |
| isomorphic_hibernate | Contains support for Hibernate DataSources as described here: [hibernateIntegration](hibernateIntegration.md#kb-topic-integration-with-hibernate). |
| isomorphic_jpa | Contains support for JPA DataSources as described [here](jpaIntegration.md#kb-topic-integration-with-jpa) |
| isomorphic_sql | The SmartClient SQLDataSource. |
| isomorphic_autotest | Support for [automated testing and Continuous Integration](automatedTesting.md#kb-topic-automated-testing)Optional Dependenciesjna - if testing with IE on Windows environmentsservlet-api - needed only if you intend to run TestRunner from a standalone process (ie, from a normal Java program, not a webapp).However, it should not be deployed to a servlet container such as Tomcat or Jetty. The best case is that the file will be unused and a source of confusion for anybody looking at the webapp's library usage; the worst case is that it will conflict with the container's own implementation of the Servlet API. |
| isomorphic_js_parser | A parser capable of reading a JSON byte stream and creating an in-memory Java object structure to match. Used by any mechanism that relies on JSON-style configuration. Examples include FileAssembly definitions in JSON format, any use of the rulesFile with a URIRegexFilter (Java Servlet) or subclass. |
| isomorphic_compression | This is a part of the Network Performance Module. The isomorphic_compression module is required for dynamic and static compression of various assets delivered to the browser. For more information, see: [compression](compression.md#kb-topic-compression). |
| isomorphic_assembly | This is part of the Network Performance Module. The isomorphic_assembly module is required for file assembly and stripping. For more information, see: [fileAssembly](fileAssembly.md#kb-topic-file-assembly). |
| isomorphic_scheduler | Server-side libraries providing [DataSource adapters](quartzAdapters.md#kb-topic-quartz-datasources) for the Quartz API. |
| isomorphic_m2pluginextras | A small collection of tools / utilities for use by Maven builds, Ant Scripts, and command line invocation. |
| isomorphic_spring_hibernate4 | Support for Spring + Hibernate 4, see the Compatibility section of [springIntegration](springIntegration.md#kb-topic-integration-with-spring) for more details. |

---
