# Experimental Features

[← Back to API Index](../reference.md)

---

## KB Topic: Experimental Features

### Description
SmartClient includes certain features which are marked as "Experimental" because, while they have been added to the core framework in a way that may be usable for many customers, there is not a clear enough need for the features for Isomorphic to commit to long-term, cross-browser support (as with all other features).

Experimental features are subject to the following limitations:

*   Experimental features are not covered by normal Support.  
    If an experimental feature isn't working as expected we'd like to know, but unlike core framework features, our support contracts do not guarantee that every question will be answered, every issue investigated, patches created for high priority bugs, phone support or remote assistance for production issues, etc.
*   Functionality may not be feature-complete. In some cases certain common use cases may not be addressed.
*   Experimental features are "use at your own risk". They could stop working entirely, for example if they involve 3rd-party functionality that fails to maintain backwards compatibility, or involve browser-specific capabilities that have not been standardized.
*   Experimental features are valid candidates for [Feature Sponsorship](https://www.smartclient.com/services/index.jsp).  
    You can pay Feature Sponsorship rates to enhance any experimental feature further.

### Related

- [EventStream.getAsSeleneseHTML](../classes/EventStream.md#method-eventstreamgetasselenesehtml)
- [EventStream.getAsSeleneseCommands](../classes/EventStream.md#method-eventstreamgetasselenesecommands)
- [SeleneseRecorder](../classes/SeleneseRecorder.md#class-seleneserecorder)
- [EventStream](../classes/EventStream.md#class-eventstream)
- [SeleniumCommand](../reference.md#object-seleniumcommand)
- [SeleneseSettings](../reference_2.md#object-selenesesettings)
- [EventStreamData](../reference.md#object-eventstreamdata)
- [EventStreamEvent](../reference.md#object-eventstreamevent)
- [MultiWindow](../classes/MultiWindow.md#class-multiwindow)
- [RemoteWindow](../classes/RemoteWindow.md#class-remotewindow)
- [OpenFin](../reference.md#class-openfin)
- [OpenFinWindow](../reference.md#class-openfinwindow)

---
