# SectionStack Documentation

[← Back to API Index](../reference.md)

---

## Class: SectionStack

*Inherits from:* [VLayout](../reference.md#class-vlayout)

### Description
A container that manages a list of sections of widgets, each with a header. Sometimes called an "Accordion".

SectionStack can be configured so that only one section is visible at a time (similar to MS Outlook's left-hand Nav), or to allow multiple sections to be visible and share the available space. For further details, see [SectionStack.visibilityMode](#attr-sectionstackvisibilitymode).

To ensure all sections are accessible, you may need to set [overflow](#attr-sectionstackoverflow) to enable scrolling.

---
## Attr: SectionStack.canTabToHeaders

### Description
If true, the headers for the sections (if shown) will be included in the page's tab order for accessibility. May be overridden at the Section level via [SectionStackSection.canTabToHeader](SectionStackSection.md#attr-sectionstacksectioncantabtoheader)

If unset, section headers will be focusable if [isc.setScreenReaderMode](isc.md#staticmethod-iscsetscreenreadermode) has been called. See [accessibility](../kb_topics/accessibility.md#kb-topic-accessibility--section-508-compliance).

**Flags**: IRA

---
## Attr: SectionStack.canCollapseAll

### Description
In [visibilityMode](#attr-sectionstackvisibilitymode) "mutex", whether to allow the last remaining expanded section to be collapsed. If false, collapsing the last open section will open the next one (wrapping around at the end).

**Flags**: IRW

---
## Attr: SectionStack.closeSectionIconSize

### Description
Pixel width/height for the [SectionStack.closeSectionIcon](#attr-sectionstackclosesectionicon).

**Flags**: IR

---
## Attr: SectionStack.canResizeSections

### Description
Whether sections can be drag resized by the user dragging the section header.

Note that, with `canResizeSections:true`, not all sections can be resized: sections that contain only [autofitting](Button.md#attr-buttonautofit) components or that are marked with [section.resizeable:false](SectionStackSection.md#attr-sectionstacksectionresizeable) will not be resizeable.

**Flags**: IRA

---
## Attr: SectionStack.sections

### Description
List of sections of components managed by this SectionStack.

### See Also

- [SectionStack.getSectionNames](#method-sectionstackgetsectionnames)

**Flags**: IR

---
## Attr: SectionStack.showExpandControls

### Description
Whether to show the Expand/Collapse controls in the headers of sections. If false, hides the expand/collapse controls and, instead, treats a click anywhere on the header as if it were a click on the expand control.

**Flags**: IRW

---
## Attr: SectionStack.itemEndIndent

### Description
Size, in pixels, of indentation of all member items relative to the end of the alignment axis. For instance, for left-aligned members, itemStartIndent specifies indentation for every item from the right side of the section stack.

### Groups

- layoutMember

**Flags**: IRW

---
## Attr: SectionStack.visibilityMode

### Description
Whether multiple sections can be expanded.

### See Also

- [SectionStack.canCollapseAll](#attr-sectionstackcancollapseall)

**Flags**: IRW

---
## Attr: SectionStack.locateSectionsBy

### Description
When [AutoTest.getElement](AutoTest.md#classmethod-autotestgetelement) is used to parse locator strings generated by [AutoTest.getLocator](AutoTest.md#classmethod-autotestgetlocator), how should sections within this stack be identified? By default if a section has a specified [Section.name](SectionStackSection.md#attr-sectionstacksectionname) this will always be used. For sections with no name, the following options are available:

*   `"title"` use the title as an identifier
*   `"index"` use the index of the section in the sections array as an identifier

If unset, and the section has no specified name, default behavior is to identify by title (if available), otherwise by index.

### Groups

- autoTest

**Flags**: IRWA

---
## Attr: SectionStack.itemStartIndent

### Description
Size, in pixels, of indentation of all member items relative to the start of the alignment axis. For instance, for left-aligned members, itemStartIndent specifies indentation for every item from the left side of the section stack. Overrides [SectionStack.itemIndent](#attr-sectionstackitemindent).

### Groups

- layoutMember

**Flags**: IRW

---
## Attr: SectionStack.canDropComponents

### Description
SectionStacks provide the same default implementation of drag and drop interactions as [Layouts](Layout.md#attr-layoutcandropcomponents), except that members are added as items into the section over which they're dropped.

If you want to completely suppress the builtin drag and drop logic, but still receive drag and drop events for your own custom implementation, set [Canvas.canAcceptDrop](Canvas.md#attr-canvascanacceptdrop) to `true` and `canDropComponents` to `false` on your SectionStack.

### Groups

- dragdrop

**Flags**: IRA

---
## Attr: SectionStack.closeSectionIcon

### Description
Default icon src for the [close button](#attr-sectionstackclosesectionbutton) for [canClose:true](SectionStackSection.md#attr-sectionstacksectioncanclose) sections.

May be overridden by [SectionStackSection.closeIcon](SectionStackSection.md#attr-sectionstacksectioncloseicon).

**Flags**: IR

---
## Attr: SectionStack.animateSections

### Description
If true, sections are animated during expand/collapse and addition/removal of SectionItems is likewise animated.

### Groups

- animation

**Flags**: IRW

---
## Attr: SectionStack.sectionHeaderClass

### Description
Widget to use for section headers.

Must be a subclass of either [ImgSectionHeader](ImgSectionHeader.md#class-imgsectionheader) or [SectionHeader](SectionHeader.md#class-sectionheader). The default class used depends on the skin; [SectionHeader](SectionHeader.md#class-sectionheader) is the simpler and lighter-weight class and uses CSS styling rather than image-based styling, and is recommended for most use cases.

Very advanced developers can use the following information to create custom header classes.

The SectionStack will instantiate this class, giving the following properties on init:

*   `layout`: the SectionStack
*   `expanded`: true or false
*   `hidden`: true or false
*   `title`: section title

Whenever the section is hidden or shown, sectionHeader.setExpanded(true|false) will be called if implemented.

If you override event handlers on your custom SectionHeader or radically change it's structure such that the default event handling no longer works, you can call [SectionStack.sectionHeaderClick](#method-sectionstacksectionheaderclick) to replicate the built-in expand/collapse handling for clicking a section header.

**Flags**: IRA

---
## Attr: SectionStack.scrollSectionIntoView

### Description
If an expanded or shown section expands past the current viewport and this property is true, then the viewport will auto-scroll to fit as much of the section content into the viewport without scrolling the top of the section out of the viewport.

**Flags**: IR

---
## Attr: SectionStack.styleName

### Description
Default CSS style for the SectionStack as a whole.

**Flags**: IR

---
## Attr: SectionStack.useGlobalSectionIDs

### Description
Should any specified [SectionStackSection.ID](SectionStackSection.md#attr-sectionstacksectionid) be applied to the generated SectionHeader widget for the section as a widget ID? If set to false, SectionStackSection.ID will behave as a synonym for SectionStackSection.name.

**Flags**: IR

---
## Attr: SectionStack.locateSectionsType

### Description
[LocatorTypeStrategy](../reference.md#type-locatortypestrategy) to use when finding Sections within this section Stack.

### Groups

- autoTest

**Flags**: IRWA

---
## Attr: SectionStack.closeSectionButton

### Description
Automatically generated close icon button to show for [canClose:true](SectionStackSection.md#attr-sectionstacksectioncanclose) sections.  
This component will be automatically added to the [controls](SectionStackSection.md#attr-sectionstacksectioncontrols) for [canClose:true](SectionStackSection.md#attr-sectionstacksectioncanclose) sections.

Icon source is derived from [SectionStack.closeSectionIcon](#attr-sectionstackclosesectionicon) or [SectionStackSection.closeIcon](SectionStackSection.md#attr-sectionstacksectioncloseicon) and related properties.

**Flags**: R

---
## Attr: SectionStack.closeSectionButtonDefaults

### Description
Default properties for the [SectionStack.closeSectionButton](#attr-sectionstackclosesectionbutton).

The default configuration includes a click handler to invoke [SectionStack.closeSection](#method-sectionstackclosesection)

**Flags**: IR

---
## Attr: SectionStack.editProxyConstructor

### Description
Default class used to construct the [EditProxy](EditProxy.md#class-editproxy) for this component when the component is [first placed into edit mode](Canvas.md#method-canvasseteditmode).

**Flags**: IR

---
## Attr: SectionStack.canCloseSections

### Description
Should sections be closeable if [SectionStackSection.canClose](SectionStackSection.md#attr-sectionstacksectioncanclose) is not explicitly specified?

Closeable sections show a [close icon button](#attr-sectionstackclosesectionbutton) which will invoke [SectionStack.closeSection](#method-sectionstackclosesection) when clicked.

**Flags**: IR

---
## Attr: SectionStack.closeSectionButtonConstructor

### Description
Constructor class for [SectionStack.closeSectionButton](#attr-sectionstackclosesectionbutton) autochildren.

**Flags**: IR

---
## Attr: SectionStack.canReorderSections

### Description
Whether sections can be drag reordered by the user dragging the section header.

Note that, with `canReorderSections:true`, sections with [section.canReorder:false](SectionStackSection.md#attr-sectionstacksectioncanreorder) will not be able to be drag-reordered (though their index may still be changed by dropping other sections above or below them in the section stack).

**Flags**: IRA

---
## Attr: SectionStack.overflow

### Description
Normal [Overflow](../reference.md#type-overflow) settings can be used on layouts, for example, an overflow:auto Layout will scroll if sections are resized to exceed the specified size, whereas an overflow:visible Layout will grow to accommodate the resized sections.

**Flags**: IRW

---
## Attr: SectionStack.itemIndent

### Description
Size, in pixels, of indentation of all member items. Items will be offset and reduced in width by this amount. Overridden by [SectionStack.itemStartIndent](#attr-sectionstackitemstartindent) or [SectionStack.itemEndIndent](#attr-sectionstackitemendindent). Setting itemIndent is equivalent to setting itemStartIndent to the same amount and itemEndIndent to 0.

### Groups

- layoutMember

**Flags**: IRW

---
## Attr: SectionStack.headerHeight

### Description
Height of headers for sections.

**Flags**: IR

---
## Method: SectionStack.getSectionNumber

### Description
Returns the position of the specified section in the SectionStack. The numbering is zero-based.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| sectionName | [String](#type-string) | false | — | name of a section for which you want to obtain the position. |

### Returns

`[number](#type-number)` — Position of the section in the SectionStack or -1 if the specified section is not a member of this SectionStack.

---
## Method: SectionStack.addItem

### Description
Add a canvas as an item to a section.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| section | [String](#type-string)|[Number](#type-number) | false | — | ID or index of the section to add item to |
| item | [Canvas](#type-canvas) | false | — | Item to insert into the section |
| index | [Number](#type-number) | false | — | Index into section to insert item |

---
## Method: SectionStack.setItems

### Description
Sets a new list of canvii as items into the specified section by removing the existing items, then adding the new ones. Initial items for a section should be specified using the property [SectionStackSection.items](SectionStackSection.md#attr-sectionstacksectionitems).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| section | [String](#type-string)|[Number](#type-number) | false | — | ID or index of the section to set items on |
| items | [Array of Canvas](#type-array-of-canvas) | false | — | new items to add |

---
## Method: SectionStack.setSectionProperties

### Description
Set arbitrary properties for a particular section in this SectionStack. Properties will be applied to the sectionHeader for the section.

Note that where APIs exist to explicitly manipulate section properties these should be used in preference to this method. For example, to add or remove items in a section use [SectionStack.addItem](#method-sectionstackadditem) or [SectionStack.removeItem](#method-sectionstackremoveitem). To change the title of a section, use [SectionStack.setSectionTitle](#method-sectionstacksetsectiontitle).

Also note that to modify properties of items within a section, call the appropriate setter methods directly on the item you want to modify.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| section | [String](#type-string)|[int](../reference.md#type-int) | false | — | ID or index of the section to modify |
| properties | [SectionStackSection Properties](#type-sectionstacksection-properties) | false | — | properties to apply to the section. |

---
## Method: SectionStack.sectionIsVisible

### Description
Returns true if the specified section is visible, false if it is not. A section is visible if it shows a header and the header is visible or if it has items and the first item is visible.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| section | [int](../reference.md#type-int)|[String](#type-string) | false | — | Section for which you want to obtain visibility information. For this parameter, you can pass the position of the section in the SectionStack, or the name of the section. |

### Returns

`[boolean](../reference.md#type-boolean)` — true if the section is visible, false if it is not.

---
## Method: SectionStack.setAnimateSections

### Description
setter for [SectionStack.animateSections](#attr-sectionstackanimatesections)

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| shouldAnimate | [boolean](../reference.md#type-boolean) | false | — | Should expand/collapse of section be animated? |

---
## Method: SectionStack.setSectionTitle

### Description
Changes the title of a SectionHeader.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| section | [String](#type-string)|[Number](#type-number) | false | — | ID or index of the section whose title you want to change |
| newTitle | [String](#type-string) | false | — | new title for the SectionHeader |

---
## Method: SectionStack.expandSection

### Description
Expands a section or sections. This action shows all the items assigned to the section. If the section is currently hidden, it is shown first and then expanded. Calling this method is equivalent to the user clicking on the SectionHeader of a collapsed section. This method is called when the user clicks on SectionHeaders to expand / collapse sections and so may be overridden to act as a notification method for the user expanding or collapsing sections.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| sections | [int](../reference.md#type-int)|[String](#type-string)|[Array of int](#type-array-of-int)|[Array of String](#type-array-of-string) | false | — | Section(s) to expand. For this parameter, you can pass the position of the section in the SectionStack, the name of the section, or a List of section names/positions. |
| callback | [ExpandSectionCallback](#type-expandsectioncallback) | true | — | callback to fire when the section has been expanded. |

### See Also

- [SectionStack.showSection](#method-sectionstackshowsection)
- [SectionStack.scrollSectionIntoView](#attr-sectionstackscrollsectionintoview)

---
## Method: SectionStack.getSectionNames

### Description
Returns a list of all [section names](SectionStackSection.md#attr-sectionstacksectionname) in the order in which they appear in the SectionStack.

### Returns

`[List](#type-list)` — list of all section names in the order in which they appear in the SectionStack.

---
## Method: SectionStack.reorderSection

### Description
Reorder the sections by shifting the specified section to a new position

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| section | [Integer](../reference_2.md#type-integer)|[String](#type-string) | false | — | Section to move. You can pass the position of the section in the SectionStack or the name of the section. |
| position | [number](#type-number) | false | — | new position index for the section. |

**Deprecated**

---
## Method: SectionStack.sectionIsExpanded

### Description
Returns true if the specified section is expanded, false if it is collapsed.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| section | [int](../reference.md#type-int)|[String](#type-string) | false | — | Section for which you want to obtain information. For this parameter, you can pass the position of the section in the SectionStack, or the name of the section. |

### Returns

`[boolean](../reference.md#type-boolean)` — true if the section is expanded, false if it is not.

---
## Method: SectionStack.showSection

### Description
Shows a section or sections. This includes the section header and its items. If the section is collapsed, only the header is shown. If the section is expanded, the section header and all items are shown.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| sections | [int](../reference.md#type-int)|[String](#type-string)|[Array of int](#type-array-of-int)|[Array of String](#type-array-of-string) | false | — | Section(s) to show. For this parameter, you can pass the position of the section in the SectionStack, the name of the section, or a List of section names / positions. |
| callback | [ShowSectionCallback](#type-showsectioncallback) | true | — | callback to fire when the sections have been shown. |

### See Also

- [SectionStack.expandSection](#method-sectionstackexpandsection)
- [SectionStack.scrollSectionIntoView](#attr-sectionstackscrollsectionintoview)

---
## Method: SectionStack.revealChild

### Description
Reveals the child Canvas passed in by expanding the section containing that child if it is currently collapsed. If no section in this sectionStack contains the passed-in Canvas, this method has no effect

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| child | [GlobalId](../reference.md#type-globalid)|[Canvas](#type-canvas) | false | — | the child Canvas to reveal, or its global ID |

---
## Method: SectionStack.sectionForItem

### Description
Search for a section that contains passed item.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| item | [Canvas](#type-canvas) | false | — | item to show |

### Returns

`[SectionStackSection](#type-sectionstacksection)` — section that contains passed item.

### See Also

- [SectionStack.expandSection](#method-sectionstackexpandsection)

---
## Method: SectionStack.moveSection

### Description
Moves the specified section(s) to a new position in the SectionStack order. If you pass in multiple sections, then each section will be moved to `newPosition` in the order specified by the `sections` argument.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| sections | [int](../reference.md#type-int)|[String](#type-string)|[Array of int](#type-array-of-int)|[Array of String](#type-array-of-string) | false | — | Section(s) to move. For this parameter, you can pass the position of the section in the SectionStack, the name of the section, or a List of section names/positions. |
| position | [int](../reference.md#type-int) | false | — | new position index for the section(s). |

---
## Method: SectionStack.collapseSection

### Description
Collapse a section or sections. This action hides all the items assigned to the section. Calling this method is equivalent to the user clicking on the SectionHeader of an expanded section. This method is called when the user clicks on SectionHeaders to expand / collapse sections and so may be overridden to act as a notification method for the user expanding or collapsing sections.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| sections | [int](../reference.md#type-int)|[String](#type-string)|[Array of int](#type-array-of-int)|[Array of String](#type-array-of-string) | false | — | Section(s) to collapse. For this parameter, you can pass the position of the section in the SectionStack, the name of the section, or a List of section positions / names |
| callback | [CollapseSectionCallback](#type-collapsesectioncallback) | true | — | callback to fire when the section has been collapsed |

### See Also

- [SectionStack.hideSection](#method-sectionstackhidesection)

---
## Method: SectionStack.getExpandedSections

### Description
Returns the list of currently expanded sections. The list items are section IDs.

### Returns

`[List](#type-list)` — list of currently expanded sections

---
## Method: SectionStack.closeSection

### Description
Close a section. This method is invoked from [close button click](#attr-sectionstackclosesectionbutton) and will [remove](#method-sectionstackremovesection) the section by default.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| section | [SectionStackSection](#type-sectionstacksection) | false | — | section to close |

---
## Method: SectionStack.removeItem

### Description
Remove an item from a section.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| section | [String](#type-string)|[Number](#type-number) | false | — | ID or index of the section to remove item from |
| item | [Canvas](#type-canvas) | false | — | Item to remove |

---
## Method: SectionStack.sectionHeaderClick

### Description
Method intended to be called by the sectionHeader when it is clicked on.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| sectionHeader | [Canvas](#type-canvas) | false | — | the sectionHeader clicked on |

**Flags**: A

---
## Method: SectionStack.addSection

### Description
Add a section to the SectionStack.

You may want to apply [overflow](Canvas.md#attr-canvasoverflow): "auto" to your stack if users can add an unlimited/ number of sections, so that they're all accessible.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| sections | [SectionStackSection Properties](#type-sectionstacksection-properties)|[List of SectionStackSection Properties](#type-list-of-sectionstacksection-properties) | false | — | Initialization block for the section or a list of initialization blocks to add. |
| position | [number](#type-number) | true | — | index for the new section(s) (if not specified, the section will be added at the end of the SectionStack). |

---
## Method: SectionStack.setVisibilityMode

### Description
Setter for [SectionStack.visibilityMode](#attr-sectionstackvisibilitymode).

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| newVisibilityMode | [VisibilityMode](../reference.md#type-visibilitymode) | false | — | new `visibilityMode` setting. If this is "mutex" then all but the first expanded section is collapsed. |

---
## Method: SectionStack.getVisibleSections

### Description
Returns the list of currently visible sections. The list items are section names.

### Returns

`[List](#type-list)` — list of visible sections

---
## Method: SectionStack.getSectionHeader

### Description
Return the SectionHeader for a section.

This will be an instance of the [SectionStack.sectionHeaderClass](#attr-sectionstacksectionheaderclass). Since different SectionStacks may use different header classes, be careful about what APIs you rely on for the section header unless you have explicitly set the `sectionHeaderClass`. In particular, use APIs such as [SectionStack.setSectionTitle](#method-sectionstacksetsectiontitle) to manipulate headers indirectly wherever possible, as high performance SectionStacks designed for very large numbers of sections may cache and re-use headers or use other strategies that would make it invalid to store a pointer to a section header, assume the header is a layout member, etc.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| section | [String](#type-string)|[Number](#type-number) | false | — | ID or index of the section for which you want the header |

### Returns

`[SectionHeader](#type-sectionheader)` — the section header indicated

---
## Method: SectionStack.getSections

### Description
Returns a list of all [section names](SectionStackSection.md#attr-sectionstacksectionname) in the order in which they appear in the SectionStack.

### Returns

`[List](#type-list)` — list of all section names in the order in which they appear in the SectionStack.

**Deprecated**

---
## Method: SectionStack.removeSection

### Description
Remove a section or set of sections from the SectionStack. The removed sections' header and controls (if any) are automatically destroyed. A section's [items](SectionStackSection.md#attr-sectionstacksectionitems) will also be destroyed if [destroyOnRemove](SectionStackSection.md#attr-sectionstacksectiondestroyonremove) is set on the section.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| sections | [int](../reference.md#type-int)|[String](#type-string)|[Array of int](#type-array-of-int)|[Array of String](#type-array-of-string) | false | — | Section(s) to remove. For this parameter, you can pass the position of the section in the SectionStack, the `name` of the section, or a List of section `name`s or indices. |

---
## Method: SectionStack.hideSection

### Description
Hides a section or sections. This includes the section header and its items. The space vacated by this action is reassigned to the nearest visible section item above this section. If there are no visible section items above this section, the space is reassigned to the nearest visible section item below this section.

### Parameters

| Name | Type | Optional | Default | Description |
|------|------|----------|---------|-------------|
| sections | [int](../reference.md#type-int)|[String](#type-string)|[Array of int](#type-array-of-int)|[Array of String](#type-array-of-string) | false | — | Section(s) to hide. For this parameter, you can pass the position of the section in the SectionStack, the name of the section, or a List of section names / positions. |
| callback | [HideSectionCallback](#type-hidesectioncallback) | true | — | to fire when the section has been hidden |

### See Also

- [SectionStack.collapseSection](#method-sectionstackcollapsesection)

---
