# MinimalScrollbar Documentation

[← Back to API Index](../reference.md)

---

## Class: MinimalScrollbar

*Inherits from:* [Canvas](Canvas.md#class-canvas)

### Description
MinimalScrollbar is an alternative scrollbar interface to the standard [Scrollbar](Scrollbar.md#class-scrollbar). It has a number of differences:

*   MinimalScrollbar has no end buttons - it consists of just a thumb floating over a track
*   The appearance is achieved entirely via CSS - see [MinimalScrollbar.trackBaseStyle](#attr-minimalscrollbartrackbasestyle) and [MinimalScrollbar.thumbBaseStyle](#attr-minimalscrollbarthumbbasestyle)
*   By default MinimalScrollbars automatically become visible when the user is actually scrolling a target, and hide themselves when the interaction is complete. See [MinimalScrollbar.autoShow](#attr-minimalscrollbarautoshow).  
    In effect this means that as a user drag-scrolls a component, the scrollbars will show up as a temporary indicator of the current drag position.  
    **Note: we recommend always [enabling floating scrollbars](Canvas.md#attr-canvasfloatingscrollbars) in conjunction with `autoShow:true`**
*   MinimalScrollbars have an [interactive](#attr-minimalscrollbarinteractive) mode in which they appear more substantial. By default this mode is turned on as [the user rolls over the visible scrollbar](#attr-minimalscrollbarsetinteractiveonmouseover)
*   The [MinimalScrollbar.contrastSuffix](#attr-minimalscrollbarcontrastsuffix) feature allows minimalScrollbars to show an appropriate appearance to contrast against either light or dark colored backgrounds.  
    By default canvases handle switching to the appropriate contrast setting based on the components rendered background-color.

To enable MinimalScrollbars we recommend the following component-level settings:

*   [scrollbarConstructor:"MinimalScrollbar"](Canvas.md#attr-canvasscrollbarconstructor)
*   [showCustomScrollbars:true](Canvas.md#attr-canvasshowcustomscrollbars)
*   [nativeAutoHideScrollbars:false](Canvas.md#attr-canvasnativeautohidescrollbars)
*   [floatingScrollbars:true](Canvas.md#attr-canvasfloatingscrollbars)

---
## Attr: MinimalScrollbar.setInteractiveOnMouseOver

### Description
Always set to [MinimalScrollbar.interactive](#attr-minimalscrollbarinteractive) mode on roll over.

**Flags**: IRW

---
## Attr: MinimalScrollbar.autoHideDelay

### Description
If [MinimalScrollbar.autoShow](#attr-minimalscrollbarautoshow) is true, the scrollbar will auto hide after the user has stopped interacting with it for this many milliseconds.

**Flags**: IRW

---
## Attr: MinimalScrollbar.interactive

### Description
Is this scrollbar currently in "interactive" mode? If true, the scrollbar will be shown with a more prominent appearance, making it clear the user can interact with it by clicking the track or dragging the thumb.

If [MinimalScrollbar.setInteractiveOnMouseOver](#attr-minimalscrollbarsetinteractiveonmouseover) is true, this property will automatically be updated on mouseOver.

**Flags**: IRW

---
## Attr: MinimalScrollbar.autoShow

### Description
Should this scrollbar automatically show itself when the scroll position / size changes and hide itself after a [delay](#attr-minimalscrollbarautohidedelay) when left untouched?

**Flags**: IRW

---
## Attr: MinimalScrollbar.thumbBaseStyle

### Description
Base style to apply to the minimal scrollbar thumb.  
The actual [styleName](Canvas.md#attr-canvasstylename) applied to the thumb will be generated by applying the specified [MinimalScrollbar.contrastSuffix](#attr-minimalscrollbarcontrastsuffix) and, if [MinimalScrollbar.interactive](#attr-minimalscrollbarinteractive) is true the additional sufix `"Interactive"`

For example, a minimalScrollbar with thumbBaseStyle set to "minimalScrollThumb", and [MinimalScrollbar.contrastSuffix](#attr-minimalscrollbarcontrastsuffix) set to "Light" would pick up the cssStyle `"minimalScrollThumbLight"` by default, or `"minimalScrollThumbLightInteractive"` when [MinimalScrollbar.interactive](#attr-minimalscrollbarinteractive) was set to true

**Flags**: IR

---
## Attr: MinimalScrollbar.thumbInset

### Description
Inset of the thumb relative to the track. An inset of N pixels means the thumb is 2N pixels smaller in breadth than the track.

### Groups

- thumb

**Flags**: IRA

---
## Attr: MinimalScrollbar.endSpace

### Description
The number of pixels of dead space at each end of the scroll-track, beyond which the thumb cannot be dragged. When a [Canvas](Canvas.md#class-canvas) is showing both scrollbars, _endSpace_ is applied on top of the square area where the two scrollbars meet, so the two don't overlap.

**Flags**: IRW

---
## Attr: MinimalScrollbar.scrollbarSize

### Description
Default thickness for this scrollbar.

If the scrollbar is in [interactive mode](#attr-minimalscrollbarinteractive), breadth will be set to [MinimalScrollbar.interactiveScrollbarSize](#attr-minimalscrollbarinteractivescrollbarsize) instead.

**Flags**: IR

---
## Attr: MinimalScrollbar.trackBaseStyle

### Description
Base style to apply to the minimal scrollbar track.  
The actual [styleName](Canvas.md#attr-canvasstylename) applied to the track will be generated by applying the specified [MinimalScrollbar.contrastSuffix](#attr-minimalscrollbarcontrastsuffix) and, if [MinimalScrollbar.interactive](#attr-minimalscrollbarinteractive) is true the additional sufix `"Interactive"`

For example, a minimalScrollbar with trackBaseStyle set to "minimalScrollTrack", and [MinimalScrollbar.contrastSuffix](#attr-minimalscrollbarcontrastsuffix) set to "Light" would pick up the cssStyle `"minimalScrollTrackLight"` by default, or `"minimalScrollTrackLightInteractive"` when [MinimalScrollbar.interactive](#attr-minimalscrollbarinteractive) was set to true

**Flags**: IR

---
## Attr: MinimalScrollbar.interactiveScrollbarSize

### Description
Thickness for this scrollbar in [interactive mode](#attr-minimalscrollbarinteractive).

**Flags**: IR

---
## Attr: MinimalScrollbar.thumbMinSize

### Description
The minimum pixel size of the draggable thumb regardless of how large the scrolling region becomes.

### Groups

- thumb

**Flags**: IRA

---
## Attr: MinimalScrollbar.contrastSuffix

### Description
Suffix to apply to the [MinimalScrollbar.thumbBaseStyle](#attr-minimalscrollbarthumbbasestyle) and [MinimalScrollbar.trackBaseStyle](#attr-minimalscrollbartrackbasestyle) to show scrollbars with an appropriate contrast against a light or dark background

**Flags**: IRW

---
## Method: MinimalScrollbar.setInteractive

### Description
Set [interactive mode](#attr-minimalscrollbarinteractive) at runtime. For [MinimalScrollbar.setInteractiveOnMouseOver](#attr-minimalscrollbarsetinteractiveonmouseover) scrollbars this method is invoked automatically at the appropriate times

---
