/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.datasource.SummaryFunctionType;
import com.isomorphic.datasource.TextMatchStyle;
import com.isomorphic.datasource.UnionDataSource;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.MysqlDriver;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLExpression;
import com.isomorphic.sql.SQLExpressions;
import com.isomorphic.sql.SQLUtils;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.Velocity;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SQLWhereClause
extends Base {
    private static final String DEFAULT_POSITIVE_RETURN_CLAUSE = "('1'='1')";
    private static final String DEFAULT_NEGATIVE_RETURN_CLAUSE = "'0'='1'";
    private static Logger log = new Logger(SQLWhereClause.class.getName());
    boolean doFilter = false;
    String filterStyle = null;
    boolean exactCase = false;
    Object whereStructure = null;
    List dataSources = null;
    boolean keepUndeclaredFields = false;
    private List customCriteriaFields = null;
    private List excludeCriteriaFields = null;
    private boolean isAdvanced = false;
    private boolean strictSQLFiltering = false;
    private DSRequest dsRequest;
    private boolean dropOrKeepFields = false;
    private List fieldNamesToDropOrKeep;
    private boolean postAggregation = false;
    private Boolean useHavingClause = null;
    private boolean processingSimpleCriteriaList = false;
    private static List unionModeExceptions = new ArrayList<String>(){
        {
            this.add(DefaultOperators.IsNull.getID());
            this.add(DefaultOperators.LessOrEqual.getID());
            this.add(DefaultOperators.LessThan.getID());
        }
    };
    private Map operatorToSql = new HashMap(){
        {
            this.put("equalsField", "=");
            this.put("notEqualField", "<>");
            this.put("greaterThanField", ">");
            this.put("greaterOrEqualField", ">=");
            this.put("lessThanField", "<");
            this.put("lessOrEqualField", "<=");
        }
    };

    public SQLWhereClause(DSRequest dsRequest, List dataSources, boolean filter) throws Exception {
        this(dsRequest, dataSources, filter, null, false, null, false);
        SQLExpressions.init(dsRequest, dataSources);
    }

    public SQLWhereClause(DSRequest dsRequest, List dataSources, boolean filter, String filterStyle, Object criteria) throws Exception {
        this(dsRequest, dataSources, filter, filterStyle, true, null, true, criteria);
    }

    public SQLWhereClause(DSRequest dsRequest, List dataSources, boolean filter, String filterStyle, boolean drop, List fieldNames, boolean postAggregation) throws Exception {
        this(dsRequest, dataSources, filter, filterStyle, drop, fieldNames, postAggregation, dsRequest.getRawCriteria());
    }

    public SQLWhereClause(DSRequest dsRequest, List dataSources, boolean filter, String filterStyle, boolean drop, List fieldNames, boolean postAggregation, Object criteria) throws Exception {
        this(criteria, dataSources, filter, filterStyle);
        this.dropOrKeepFields = drop;
        this.fieldNamesToDropOrKeep = fieldNames;
        this.postAggregation = postAggregation;
        this.dsRequest = dsRequest;
        DataTypeMap operationBinding = ((DataSource)dataSources.get(0)).getOperationBinding(dsRequest);
        if (operationBinding != null) {
            this.useHavingClause = DataTools.getBooleanObject((Map)operationBinding, (Object)"useHavingClause", null);
        }
        this.exactCase = TextMatchStyle.EXACT_CASE == TextMatchStyle.findValueOf((String)dsRequest.getTextMatchStyle());
    }

    public SQLWhereClause(Object whereStructure, List dataSources) throws Exception {
        this.dataSources = dataSources;
        this.whereStructure = whereStructure;
        if ("".equals(this.whereStructure)) {
            this.whereStructure = null;
        }
        DataSource ds = null;
        if (dataSources != null && dataSources.size() > 0) {
            ds = (DataSource)dataSources.get(0);
        }
        if (whereStructure == null) {
            return;
        }
        if (whereStructure instanceof String) {
            if (((String)whereStructure).length() != 0) {
                whereStructure = DEFAULT_POSITIVE_RETURN_CLAUSE;
            }
        } else if (whereStructure instanceof Map) {
            if (ds != null && ds.isAdvancedCriteria((Map)whereStructure)) {
                this.isAdvanced = true;
                Object strictMode = null;
                strictMode = ((Map)whereStructure).get("strictSQLFiltering");
                if (strictMode == null) {
                    strictMode = ds.getConfig().get((Object)"strictSQLFiltering");
                }
                if (strictMode != null && (strictMode instanceof Boolean && strictMode.equals(Boolean.TRUE) || strictMode instanceof String && strictMode.equals("true"))) {
                    this.strictSQLFiltering = true;
                }
                if (AdvancedCriteria.hasRelativeDates((Object)this.whereStructure)) {
                    AdvancedCriteria ac = AdvancedCriteria.fromCollections((Object)this.whereStructure);
                    ac.convertRelativeDates();
                    this.whereStructure = ac.getCriteriaAsMap();
                }
            }
        } else if (whereStructure instanceof List) {
            List clauses = (List)whereStructure;
            if (clauses.isEmpty()) {
                this.whereStructure = null;
                return;
            }
            if (clauses.size() == 1 && ((Map)clauses.get(0)).size() == 0) {
                this.whereStructure = null;
            }
        } else {
            throw new Exception("Data type: '" + whereStructure.getClass().getName() + "' is not supported");
        }
    }

    public SQLWhereClause(Object whereStructure, List dataSources, boolean filter, String filterStyle) throws Exception {
        this(whereStructure, dataSources);
        this.doFilter = filter;
        this.filterStyle = filterStyle;
    }

    public SQLWhereClause(Object whereStructure, SQLDataSource ds) throws Exception {
        this(whereStructure, DataTools.makeList((Object)((Object)ds)));
    }

    public SQLWhereClause(Object whereStructure, SQLDataSource ds, boolean filter, String filterStyle) throws Exception {
        this(whereStructure, ds);
        this.doFilter = filter;
        this.filterStyle = filterStyle;
    }

    public List getCustomCriteriaFields() {
        return this.customCriteriaFields;
    }

    public void setCustomCriteriaFields(List fields) {
        this.customCriteriaFields = fields;
    }

    public List getExcludeCriteriaFields() {
        return this.excludeCriteriaFields;
    }

    public void setExcludeCriteriaFields(List fields) {
        this.excludeCriteriaFields = fields;
    }

    public Map getDataHash() {
        if (this.whereStructure instanceof Map) {
            return (Map)this.whereStructure;
        }
        if (this.whereStructure instanceof List) {
            List whereList = (List)this.whereStructure;
            return (Map)whereList.get(whereList.size() - 1);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.whereStructure == null;
    }

    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        return 1;
    }

    public String toString(SQLDriver driver) throws Exception {
        if (this.isEmpty()) {
            log.debug((Object)"no data; returning empty string");
            return DEFAULT_POSITIVE_RETURN_CLAUSE;
        }
        return this.getOutput(this.filterCriteria(this.whereStructure), driver);
    }

    public String getSQLString() throws Exception {
        String whereClause = this.toString(((SQLDataSource)((Object)this.dataSources.get(0))).getDriver());
        if (whereClause == null) {
            whereClause = Boolean.TRUE.equals(this.dsRequest.getParameter((Object)"requiresLimitingCriteria")) ? DEFAULT_NEGATIVE_RETURN_CLAUSE : DEFAULT_POSITIVE_RETURN_CLAUSE;
        }
        return whereClause;
    }

    private String getOutput(Object condition, SQLDriver driver) throws Exception {
        if (condition == null) {
            return DEFAULT_POSITIVE_RETURN_CLAUSE;
        }
        if (this.dsRequest != null && this.dsRequest.getEndRow() == -1L && this.dsRequest.hasNonSqlCriteria() && !this.dsRequest.criteriaIsDivisible()) {
            log.warn((Object)"The presence of both SQL and non-SQL fields in the criteria requires that filtering logic be divided between SQL query and Java code. However, the criteria is indivisible so we cannot do this. Skipping SQL filtering and doing all filtering in Java code - this may drastically affect performance");
            return DEFAULT_POSITIVE_RETURN_CLAUSE;
        }
        if (condition instanceof String) {
            return "(" + String.valueOf(condition) + ")";
        }
        if (this.useHavingClause == null) {
            this.useHavingClause = driver.useHavingClause();
        }
        if (!this.isAdvanced) {
            if (condition instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)condition;
                Object value = entry.getValue();
                if (value instanceof List) {
                    boolean caseSensitive;
                    DataSource ds = this.dsRequest.getDataSource();
                    DSField field = ds.getField((String)entry.getKey());
                    boolean shouldUseIn = true;
                    if (field != null) {
                        boolean bl = shouldUseIn = !this.doFilter || this.shouldIgnoreTextMatchStyle(field, true);
                        if (shouldUseIn) {
                            String baseType = ds.getSimpleBaseType(field.getType());
                            shouldUseIn = "text".equals(baseType) || "integer".equals(baseType) || "float".equals(baseType);
                        }
                    }
                    Boolean useOr = null;
                    if (this.dsRequest != null && this.dsRequest.getDataSource() != null) {
                        useOr = this.dsRequest.getDataSource().getConfig().getBoolean((Object)"simplifyCriteriaListsToOrClause");
                    }
                    if (useOr == null) {
                        useOr = Config.getGlobal().getBoolean((Object)"sql.simplifyCriteriaListsToOrClause", false);
                    }
                    if (!(caseSensitive = this.exactCase)) {
                        caseSensitive = this.shouldIgnoreTextMatchStyle(field) && DataTools.asBoolean((Object)ds.getConfig().get((Object)"ignoreTextMatchStyleCaseSensitive"), (boolean)false) || this.alwaysIgnoreTextMatchStyleCaseSensitive(field);
                    }
                    boolean nullInList = ((List)value).contains(null);
                    boolean usingParamQuery = this.dsRequest.usePreparedStatements();
                    if (!shouldUseIn || useOr.booleanValue() || caseSensitive || nullInList || usingParamQuery) {
                        List values = (List)value;
                        ArrayList<DataTypeMap> equivalentExpression = new ArrayList<DataTypeMap>();
                        for (Object object : values) {
                            equivalentExpression.add(DataTools.buildMap((Object[])new Object[]{entry.getKey(), object}));
                        }
                        this.processingSimpleCriteriaList = true;
                        String rtn = this.buildCompoundExpression(equivalentExpression.iterator(), "OR", driver);
                        this.processingSimpleCriteriaList = false;
                        return rtn;
                    }
                    return this.buildExpression(entry.getKey().toString(), value, driver);
                }
                return this.buildExpression(entry.getKey().toString(), value, driver);
            }
            if (condition instanceof Map) {
                return this.buildCompoundExpression(((Map)condition).entrySet().iterator(), "AND", driver);
            }
            if (condition instanceof List) {
                return this.buildCompoundExpression(((List)condition).iterator(), "OR", driver);
            }
        } else {
            if (!(condition instanceof Map)) {
                throw new Exception("AdvancedCriteria was not an instance of Map");
            }
            Map conditionAsMap = (Map)condition;
            String operator = String.valueOf(conditionAsMap.get("operator"));
            String fieldName = String.valueOf(conditionAsMap.get("fieldName"));
            Object criteriaObject = conditionAsMap.get("criteria");
            if (DataTools.getBoolean((Map)conditionAsMap, (Object)"__never_matches", (boolean)false)) {
                log.warn((Object)"Creating literal false expression for illegal criterion.");
                return DEFAULT_NEGATIVE_RETURN_CLAUSE;
            }
            if (operator == null) {
                return DEFAULT_POSITIVE_RETURN_CLAUSE;
            }
            if (fieldName == null) {
                if (criteriaObject == null) {
                    return DEFAULT_POSITIVE_RETURN_CLAUSE;
                }
                if (criteriaObject instanceof Map && ((Map)criteriaObject).isEmpty()) {
                    return DEFAULT_POSITIVE_RETURN_CLAUSE;
                }
                if (criteriaObject instanceof List && ((List)criteriaObject).isEmpty()) {
                    return DEFAULT_POSITIVE_RETURN_CLAUSE;
                }
            }
            if ("and".equals(operator) || "or".equals(operator) || "not".equals(operator)) {
                if (!(criteriaObject instanceof List)) {
                    log.warn((Object)"Subcriteria of AdvancedCriteria not an instance of List - using empty ArrayList");
                    criteriaObject = new ArrayList();
                }
                List criteria = (List)criteriaObject;
                return this.buildCompoundExpression(criteria.iterator(), operator, driver);
            }
            Object value = conditionAsMap.get("value");
            if (fieldName == null) {
                throw new Exception("AdvancedCriteria contains a clause with fieldName: 'null', operator: '" + operator + ", value '" + String.valueOf(value) + "'.  Aborting.");
            }
            Object start = conditionAsMap.get("start");
            Object end = conditionAsMap.get("end");
            return this.buildAdvancedExpression(fieldName, operator, value, start, end, driver);
        }
        throw new Exception("Data type: '" + condition.getClass().getName() + "' is not supported");
    }

    private Object filterCriteria(Object raw) {
        if (this.fieldNamesToDropOrKeep == null || this.fieldNamesToDropOrKeep.isEmpty()) {
            if (this.dropOrKeepFields) {
                return raw;
            }
            return this.isAdvanced ? new HashMap() : null;
        }
        if (raw instanceof Map) {
            Map<String, String> newMap = new HashMap();
            if (this.isAdvanced) {
                newMap = this._filterCriteria((Map)raw);
                if (newMap != null && "AdvancedCriteria".equals(((Map)raw).get("_constructor"))) {
                    newMap.put("_constructor", "AdvancedCriteria");
                }
                return newMap;
            }
            for (String fieldName : ((Map)raw).keySet()) {
                if (this.fieldNamesToDropOrKeep.contains(fieldName) == this.dropOrKeepFields) continue;
                newMap.put(fieldName, (String)((Map)raw).get(fieldName));
            }
            return newMap;
        }
        if (raw instanceof List) {
            ArrayList<Object> newCriteria = new ArrayList<Object>();
            Iterator i = ((List)raw).iterator();
            while (i.hasNext()) {
                newCriteria.add(this.filterCriteria(i.next()));
            }
            return newCriteria;
        }
        return raw;
    }

    private Map _filterCriteria(Map criteria) {
        if (criteria == null) {
            return null;
        }
        if (criteria.containsKey("criteria")) {
            HashMap newMap = new HashMap(criteria);
            ArrayList newCrit = new ArrayList();
            for (Object c : (List)criteria.get("criteria")) {
                if ((c = this._filterCriteria((Map)c)) == null) continue;
                newCrit.add(c);
            }
            newMap.put("criteria", newCrit);
            return newMap;
        }
        if (criteria.containsKey("fieldName")) {
            String fieldName = (String)criteria.get("fieldName");
            return this.fieldNamesToDropOrKeep.contains(fieldName) != this.dropOrKeepFields ? criteria : null;
        }
        return null;
    }

    private String buildCompoundExpression(Iterator conditions, String operator, SQLDriver driver) throws Exception {
        if (!conditions.hasNext()) {
            log.info((Object)"empty condition");
            boolean rlc = Boolean.TRUE.equals(this.dsRequest.getParameter((Object)"requiresLimitingCriteria"));
            return rlc ? DEFAULT_NEGATIVE_RETURN_CLAUSE : DEFAULT_POSITIVE_RETURN_CLAUSE;
        }
        StringBuilder clause = new StringBuilder();
        while (conditions.hasNext()) {
            String subclause = this.getOutput(conditions.next(), driver);
            if (subclause == null) continue;
            if (clause.length() != 0) {
                if (!operator.equals("not")) {
                    clause.append(" " + operator.toUpperCase() + " ");
                } else {
                    clause.append(" OR ");
                }
            }
            clause.append(subclause);
        }
        if (clause.length() == 0) {
            return null;
        }
        if (operator.equals("not")) {
            return "NOT(" + clause.toString() + ")";
        }
        return "(" + clause.toString() + ")";
    }

    private String prepareSQLParam(DataSource ds, SQLDriver driver, DSField field, Object value) {
        if (value instanceof SQLExpression) {
            return ((SQLExpression)((Object)value)).getExpr();
        }
        return this.prepareSQLParam(ds, driver, field, value, value != null ? value.toString() : null);
    }

    private String prepareSQLParam(DataSource ds, SQLDriver driver, DSField field, Object value, String stringValue) {
        if (this.dsRequest != null && driver != null) {
            return driver.prepareSQLParam(this.dsRequest, ds, field, value, stringValue);
        }
        return stringValue;
    }

    public static SQLUtils.Either<SQLUtils.FieldInfo, String> getFieldInfo(List customCriteriaFields, List excludeCriteriaFields, boolean keepUndeclaredFields, List dataSources, DSRequest dsRequest, String fieldName, SQLDriver driver) throws Exception {
        String[] dynamic;
        boolean skipCustomSQLCheck = false;
        if (customCriteriaFields != null) {
            Iterator i = customCriteriaFields.iterator();
            while (i.hasNext()) {
                if (!i.next().equals(fieldName)) continue;
                skipCustomSQLCheck = true;
                break;
            }
        }
        BasicDataSource ds = null;
        DSField field = null;
        for (int i = 0; i < dataSources.size(); ++i) {
            ds = (BasicDataSource)dataSources.get(i);
            field = ds.getField(fieldName);
            if (field == null) continue;
            if (skipCustomSQLCheck || !field.getBoolean("customSQL") && !Boolean.FALSE.equals(field.get((Object)"canFilter"))) break;
            return new SQLUtils.Either.Right(null);
        }
        if (!skipCustomSQLCheck && excludeCriteriaFields != null) {
            Iterator i = excludeCriteriaFields.iterator();
            while (i.hasNext()) {
                if (!i.next().equals(fieldName)) continue;
                return new SQLUtils.Either.Right(null);
            }
        }
        String expressionId = fieldName;
        boolean unionMode = Boolean.TRUE.equals(dsRequest.getAttribute("unionMode"));
        if (unionMode) {
            UnionDataSource unionDS = (UnionDataSource)dsRequest.getAttribute("unionDataSource");
            DSField unionField = unionDS.getRenamedField((DataSource)ds, field);
            if (unionField != null) {
                expressionId = unionField.getName();
            } else if (field == null) {
                return new SQLUtils.Either.Right<SQLUtils.FieldInfo, String>(DEFAULT_NEGATIVE_RETURN_CLAUSE);
            }
        }
        if ((dynamic = expressionId.split("\\!")).length == 2) {
            expressionId = dynamic[0];
        }
        SQLExpression expression = SQLExpressions.getExpression(dsRequest, expressionId, !keepUndeclaredFields);
        String columnOrExpression = null;
        if (expression == null) {
            if (keepUndeclaredFields) {
                columnOrExpression = fieldName;
            }
            field = SQLWhereClause.getField(dataSources, fieldName);
        } else {
            columnOrExpression = expression.getExpr();
            field = expression.getField();
        }
        if (field != null && field.isInapplicable()) {
            return new SQLUtils.Either.Right(null);
        }
        if (columnOrExpression == null) {
            return new SQLUtils.Either.Right<SQLUtils.FieldInfo, String>(DEFAULT_POSITIVE_RETURN_CLAUSE);
        }
        String columnType = ds.getSimpleBaseType(SQLWhereClause.getFieldType(dataSources, fieldName));
        if (columnType == null) {
            log.warn((Object)("Unable to find simple basetype for field " + fieldName + " (declared type is " + SQLWhereClause.getFieldType(dataSources, fieldName) + ")"));
            columnType = "text";
        }
        IncludeFromDefinition incFrom = null;
        if (dsRequest != null && expression != null) {
            incFrom = expression.getIncludeFrom();
        }
        if (field == null && incFrom == null) {
            String returnValue = null;
            if (Boolean.TRUE.equals(dsRequest.getAttribute("unionMode"))) {
                returnValue = DEFAULT_NEGATIVE_RETURN_CLAUSE;
            }
            return new SQLUtils.Either.Right<SQLUtils.FieldInfo, String>(returnValue);
        }
        if (field != null && !driver.fieldIsSearchable(field)) {
            return new SQLUtils.Either.Right(null);
        }
        String functionName = null;
        Map summaryFunctionMap = dsRequest.getSummaryFunctions();
        if (summaryFunctionMap != null && summaryFunctionMap.containsKey(fieldName)) {
            functionName = ((SummaryFunctionType)summaryFunctionMap.get(fieldName)).getFunctionName();
        }
        return new SQLUtils.Either.Left<SQLUtils.FieldInfo, String>(new SQLUtils.FieldInfo(ds, field, columnType, columnOrExpression, functionName, expression));
    }

    private String buildExpression(String fieldName, Object value, SQLDriver driver) throws Exception {
        String prepared;
        SQLUtils.Either<SQLUtils.FieldInfo, String> either = SQLWhereClause.getFieldInfo(this.customCriteriaFields, this.excludeCriteriaFields, this.keepUndeclaredFields, this.dataSources, this.dsRequest, fieldName, driver);
        if (SQLUtils.Either.isRight(either)) {
            return SQLUtils.Either.fromRight(either, null);
        }
        SQLUtils.FieldInfo info = SQLUtils.Either.fromLeft(either, null);
        BasicDataSource ds = info.ds;
        DSField field = info.field;
        String columnName = info.columnName;
        String columnType = info.columnType;
        Object columnOrExpression = info.columnOrExpression;
        String functionName = info.functionName;
        SQLExpression expression = info.expression;
        if (this.postAggregation) {
            if (!Boolean.TRUE.equals(this.useHavingClause) || driver.referAggregatedFieldByAlias()) {
                columnOrExpression = fieldName;
            } else if (functionName != null && !"".equals(functionName.trim())) {
                columnOrExpression = functionName + "(" + (String)columnOrExpression + ")";
            }
        }
        if (field.get((Object)"customCriteriaExpression") != null) {
            String op = "equals";
            if (ds.simpleTypeInheritsFrom(columnType, "text") && this.doFilter) {
                op = TextMatchStyle.STARTS_WITH.toString().equals(this.filterStyle) ? "iStartsWith" : "iContains";
            }
            return this.getCustomCriteriaExpression(field, value, op);
        }
        if (value == null) {
            return (String)columnOrExpression + " IS NULL";
        }
        boolean processingList = value instanceof List;
        DataSource sqlDS = (DataSource)this.dataSources.get(0);
        if (ds.simpleTypeInheritsFrom(columnType, "text")) {
            if (!this.doFilter || this.shouldIgnoreTextMatchStyle(field, processingList)) {
                boolean likeIsCaseSensitive;
                Object rval = null;
                if (processingList) {
                    List valueList = (List)value;
                    if (valueList.size() <= 0) {
                        return DEFAULT_POSITIVE_RETURN_CLAUSE;
                    }
                    for (Object valueListEntry : valueList) {
                        rval = rval == null ? "(" : (String)rval + ",";
                        if (this.dsRequest.usePreparedStatements()) {
                            rval = (String)rval + valueListEntry.toString();
                            continue;
                        }
                        if (sqlDS instanceof SQLDataSource) {
                            rval = (String)rval + driver.sqlInTransform(valueListEntry, field, (SQLDataSource)sqlDS, false);
                            continue;
                        }
                        rval = (String)rval + driver.sqlInTransform(valueListEntry, field, null, false);
                    }
                    rval = (String)rval + ")";
                } else {
                    rval = this.dsRequest.usePreparedStatements() ? value.toString() : (sqlDS instanceof SQLDataSource ? driver.sqlInTransform(value, field, (SQLDataSource)sqlDS, false) : driver.sqlInTransform(value, field, null, false));
                }
                Object sql = "";
                String operator = processingList ? " IN " : "=";
                boolean caseSensitive = this.exactCase;
                if (!caseSensitive) {
                    boolean bl = caseSensitive = this.shouldIgnoreTextMatchStyle(field) && DataTools.asBoolean((Object)sqlDS.getConfig().get((Object)"ignoreTextMatchStyleCaseSensitive"), (boolean)false) || this.alwaysIgnoreTextMatchStyleCaseSensitive(field);
                }
                boolean bl = field != null && field.containsKey((Object)"sqlForceInsensitive") ? field.getBoolean("sqlForceInsensitive") : (likeIsCaseSensitive = field != null && field.containsKey((Object)"sqlLikeIsCaseSensitive") ? field.getBoolean("sqlLikeIsCaseSensitive") : driver.likeIsCaseSensitive());
                if (!caseSensitive) {
                    if (likeIsCaseSensitive && driver.caseInsensitiveStrategyForRelativeComparisons() == 2) {
                        sql = "UPPER(";
                        rval = ((String)rval).toUpperCase();
                    } else if (likeIsCaseSensitive && driver.caseInsensitiveStrategyForRelativeComparisons() == 1) {
                        sql = "LOWER(";
                        rval = ((String)rval).toLowerCase();
                    }
                } else {
                    operator = driver.caseSensitiveEqualsPredicate();
                    columnOrExpression = driver.caseSensitiveFieldPrefix() + (String)columnOrExpression + driver.caseSensitiveFieldSuffix();
                }
                if (!this.dsRequest.usePreparedStatements()) {
                    rval = driver.getLiteralPrefix(field, ds) + (String)rval;
                }
                sql = (String)sql + (String)columnOrExpression;
                if (!caseSensitive) {
                    if (likeIsCaseSensitive && driver.caseInsensitiveStrategyForRelativeComparisons() != 0) {
                        sql = (String)sql + ")";
                    }
                } else if (driver instanceof MysqlDriver && driver.optimizeCaseSensitiveCriteria()) {
                    String prepared2 = this.prepareSQLParam((DataSource)ds, driver, field, rval);
                    return "(" + (String)sql + " = " + prepared2 + " AND " + (String)sql + operator + prepared2 + ")";
                }
                return (String)sql + operator + this.prepareSQLParam((DataSource)ds, driver, field, rval);
            }
            return this.substringFilter((String)columnOrExpression, value, driver, (SQLDataSource)ds, field);
        }
        if (ds.simpleTypeInheritsFrom(columnType, "integer") || ds.simpleTypeInheritsFrom(columnType, "float")) {
            if (!this.doFilter || this.shouldIgnoreTextMatchStyle(field, processingList) || value instanceof Number && !config.getBoolean((Object)"sql.substring.numeric.criteria", false)) {
                Object rval = null;
                String operator = "=";
                if (processingList) {
                    operator = " IN ";
                    List valueList = (List)value;
                    if (valueList.size() <= 0) {
                        return DEFAULT_POSITIVE_RETURN_CLAUSE;
                    }
                    for (Object valueListEntry : valueList) {
                        rval = rval == null ? "(" : (String)rval + ",";
                        if (valueListEntry instanceof String) {
                            try {
                                valueListEntry = ds.simpleTypeInheritsFrom(columnType, "float") ? new BigDecimal((String)valueListEntry).toString() : new BigInteger((String)valueListEntry).toString();
                            }
                            catch (Exception e) {
                                log.warn((Object)("Got non-numeric value '" + String.valueOf(valueListEntry) + "' for numeric column '" + columnName + "' while processing a list-valued criterion. creating literal false expression: " + String.valueOf(e)));
                                return DEFAULT_NEGATIVE_RETURN_CLAUSE;
                            }
                        }
                        rval = (String)rval + String.valueOf(valueListEntry);
                    }
                    rval = rval + ")";
                    return (String)columnOrExpression + operator + this.prepareSQLParam((DataSource)ds, driver, field, rval, (String)rval);
                }
                if (value instanceof String) {
                    try {
                        rval = ds.simpleTypeInheritsFrom(columnType, "float") ? new BigDecimal((String)value).toString() : new BigInteger((String)value).toString();
                    }
                    catch (Exception e) {
                        log.warn((Object)("Got non-numeric value '" + String.valueOf(value) + "' for numeric column '" + columnName + "', creating literal false expression: " + String.valueOf(e)));
                        return DEFAULT_NEGATIVE_RETURN_CLAUSE;
                    }
                    return (String)columnOrExpression + operator + this.prepareSQLParam((DataSource)ds, driver, field, rval, (String)rval);
                }
            } else if (value instanceof String || "substring".equals(this.dsRequest.getTextMatchStyle())) {
                if (!(value instanceof String)) {
                    value = value.toString();
                }
                return this.substringFilter((String)columnOrExpression, value, driver, true, (SQLDataSource)ds, field);
            }
        }
        if (!(!ds.simpleTypeInheritsFrom(columnType, "date") && !ds.simpleTypeInheritsFrom(columnType, "time") && !ds.simpleTypeInheritsFrom(columnType, "datetime") || value instanceof Date || value instanceof GregorianCalendar || value != null && value.getClass().getName().startsWith("org.joda") || !config.getBoolean((Object)"sql.temporal.fields.require.date.criteria", true))) {
            return DEFAULT_NEGATIVE_RETURN_CLAUSE;
        }
        try {
            if (value != null && value.getClass().getName().startsWith("org.joda.")) {
                value = DataTools.convertType(Date.class, (Object)value);
            }
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to convert Joda date/time value", (Throwable)ex);
        }
        if (sqlDS instanceof SQLDataSource) {
            prepared = this.prepareSQLParam((DataSource)ds, driver, field, value, driver.sqlInTransform(value, field, (SQLDataSource)sqlDS));
            if (prepared != null && expression != null && expression.isSqlCasted()) {
                prepared = driver.sqlCast(prepared, expression.getField());
            }
            return (String)columnOrExpression + "=" + prepared;
        }
        prepared = this.prepareSQLParam((DataSource)ds, driver, field, value, driver.sqlInTransform(value, field, null));
        if (prepared != null && expression != null && expression.isSqlCasted()) {
            prepared = driver.sqlCast(prepared, expression.getField());
        }
        return (String)columnOrExpression + "=" + prepared;
    }

    private String getCustomCriteriaExpression(DSField field, Object value, String operator) throws Exception {
        Map context = Velocity.getStandardContextMap((DSRequest)this.dsRequest);
        context.put("criteriaValue", value);
        context.put("criteriaOperator", operator);
        String expr = (String)field.get((Object)"customCriteriaExpression");
        return Velocity.evaluateWithSnippets((String)expr, (Map)context, (String)"customCriteriaExpression", (DSRequest)this.dsRequest, (boolean)field.getBoolean("autoQuoteCustomExpressions", true), (boolean)false);
    }

    private String substringFilter(String lval, Object rval, SQLDriver driver, SQLDataSource ds, DSField field) {
        return this.substringFilter(lval, rval, driver, false, ds, field);
    }

    private String substringFilter(String lvalue, Object rvalue, SQLDriver driver, boolean isNumber, SQLDataSource ds, DSField field) {
        boolean likeIsCaseSensitive;
        boolean bl = field != null && field.containsKey((Object)"sqlForceInsensitive") ? field.getBoolean("sqlForceInsensitive") : (likeIsCaseSensitive = field != null && field.containsKey((Object)"sqlLikeIsCaseSensitive") ? field.getBoolean("sqlLikeIsCaseSensitive") : driver.likeIsCaseSensitive());
        if (likeIsCaseSensitive) {
            Object sql = driver.caseInsensitiveStrategy() == 2 ? "UPPER(" : "LOWER(";
            sql = driver.castNumbersBeforeLikeCompare() && isNumber ? (String)sql + "CAST(" + lvalue + " AS varchar(50))" : (String)sql + lvalue;
            String compare = rvalue.toString();
            compare = driver.caseInsensitiveStrategy() == 2 ? compare.toUpperCase() : compare.toLowerCase();
            return (String)sql + ") " + driver.caseInsensitiveLikePredicate() + " " + driver.sqlFilterTransform(compare, field, ds, this.filterStyle) + driver.escapeClause(compare) + " AND " + lvalue + " IS NOT NULL";
        }
        Object sql = driver.castNumbersBeforeLikeCompare() && isNumber ? "CAST(" + lvalue + " AS varchar(50))" : lvalue;
        String escapedValue = driver.escapeValueForFilter(rvalue.toString(), this.filterStyle, !this.dsRequest.usePreparedStatements());
        return (String)sql + " " + driver.caseInsensitiveLikePredicate() + " " + this.prepareSQLParam((DataSource)ds, driver, field, escapedValue) + " AND " + lvalue + " IS NOT NULL";
    }

    private DSField getField(String fieldName) {
        return SQLWhereClause.getField(this.dataSources, fieldName);
    }

    private static DSField getField(List dataSources, String fieldName) {
        if (dataSources != null) {
            for (SQLDataSource ds : dataSources) {
                DSField field = ds.getField(fieldName);
                if (field == null) continue;
                return field;
            }
        }
        return null;
    }

    private String getFieldType(String fieldName) {
        return SQLWhereClause.getFieldType(this.dataSources, fieldName);
    }

    private static String getFieldType(List dataSources, String fieldName) {
        DSField field = SQLWhereClause.getField(dataSources, fieldName);
        return field == null ? "text" : field.getType();
    }

    private String buildAdvancedExpression(String fieldName, String operator, Object value, Object start, Object end, SQLDriver driver) throws Exception {
        String columnType;
        DSField otherField;
        boolean fieldOperator;
        SQLExpression expression;
        DSField unionField;
        UnionDataSource unionDS;
        boolean skipCustomSQLCheck = false;
        boolean unionMode = Boolean.TRUE.equals(this.dsRequest.getAttribute("unionMode"));
        BasicDataSource ds = (BasicDataSource)this.dsRequest.getDataSource();
        DSField field = ds.getField(fieldName);
        String expressionId = fieldName;
        if (unionMode && (unionDS = (UnionDataSource)this.dsRequest.getAttribute("unionDataSource")) != null && (unionField = unionDS.getRenamedField((DataSource)ds, field)) != null) {
            expressionId = unionField.getName();
        }
        if ((expression = SQLExpressions.getExpression(this.dsRequest, expressionId, true)) == null || expression.getExpr() == null) {
            String returnValue = DEFAULT_POSITIVE_RETURN_CLAUSE;
            if (unionMode && !unionModeExceptions.contains(operator)) {
                returnValue = DEFAULT_NEGATIVE_RETURN_CLAUSE;
            }
            return returnValue;
        }
        if (expression.isExcludedFromWhereClause()) {
            return null;
        }
        if (this.customCriteriaFields != null && !expression.isQueryField()) {
            Iterator i = this.customCriteriaFields.iterator();
            while (i.hasNext()) {
                if (!i.next().equals(fieldName)) continue;
                skipCustomSQLCheck = true;
                break;
            }
        }
        if (expression.isQueryField()) {
            ds = expression.getDs();
        } else {
            for (int i = 0; i < this.dataSources.size(); ++i) {
                ds = (BasicDataSource)this.dataSources.get(i);
                field = ds.getField(fieldName);
                if (field == null) continue;
                if (skipCustomSQLCheck || !field.getBoolean("customSQL") && !Boolean.FALSE.equals(field.get((Object)"canFilter"))) break;
                return null;
            }
        }
        BasicDataSource otherDS = ds;
        if (!expression.isQueryField() && !skipCustomSQLCheck && this.excludeCriteriaFields != null) {
            Iterator i = this.excludeCriteriaFields.iterator();
            while (i.hasNext()) {
                if (!i.next().equals(fieldName)) continue;
                return null;
            }
        }
        String otherFieldName = (fieldOperator = AdvancedCriteria.isFieldComparisonOperator((String)operator).booleanValue()) ? (String)value : null;
        field = expression.getField();
        DSField dSField = otherField = fieldOperator ? this.getField(otherFieldName) : null;
        if (otherField != null && otherField.isInapplicable()) {
            return null;
        }
        SQLExpression otherExpression = null;
        if (fieldOperator && otherField != null && driver.fieldIsSearchable(otherField)) {
            otherExpression = SQLExpressions.getExpression(this.dsRequest, otherFieldName, true);
        }
        if (expression.isQueryField()) {
            columnType = ds.getSimpleBaseType(expression.getOutputType());
        } else {
            columnType = ds.getSimpleBaseType(this.getFieldType(fieldName));
            if (columnType == null) {
                log.warn((Object)("Unable to find simple basetype for field " + fieldName + " (declared type is " + this.getFieldType(fieldName) + ")"));
                columnType = "text";
            }
        }
        if (!"notNull".equals(operator) && !"isNull".equals(operator) && (field != null && !driver.fieldIsSearchable(field) || fieldOperator && otherField != null && !driver.fieldIsSearchable(otherField))) {
            return DEFAULT_POSITIVE_RETURN_CLAUSE;
        }
        Object columnOrExpression = null;
        if (this.postAggregation && (!Boolean.TRUE.equals(this.useHavingClause) || driver.referAggregatedFieldByAlias())) {
            columnOrExpression = fieldName;
        } else if (!expression.isIncludeFrom()) {
            if (field != null && field.get((Object)"customCriteriaExpression") != null) {
                return this.getCustomCriteriaExpression(field, value, operator);
            }
            columnOrExpression = expression.getExpr();
        } else {
            columnOrExpression = expression.getExpr();
            field = expression.getField();
            ds = expression.getDs();
        }
        String functionName = null;
        Map summaryFunctionMap = null;
        if (this.postAggregation && Boolean.TRUE.equals(this.useHavingClause) && !driver.referAggregatedFieldByAlias()) {
            summaryFunctionMap = this.dsRequest.getSummaryFunctions();
            if (summaryFunctionMap != null && summaryFunctionMap.containsKey(fieldName)) {
                functionName = ((SummaryFunctionType)summaryFunctionMap.get(fieldName)).getFunctionName();
            }
            if (functionName != null && !"".equals(functionName.trim())) {
                columnOrExpression = functionName + "(" + (String)columnOrExpression + ")";
            }
        }
        IncludeFromDefinition otherIncFrom = null;
        String otherColumnOrExpression = null;
        if (otherExpression != null) {
            otherField = otherExpression.getField();
            otherDS = otherExpression.getDs();
            otherIncFrom = otherExpression.getIncludeFrom();
            otherColumnOrExpression = otherExpression.getExpr();
        }
        if (summaryFunctionMap != null && summaryFunctionMap.containsKey(otherFieldName)) {
            functionName = ((SummaryFunctionType)summaryFunctionMap.get(otherFieldName)).getFunctionName();
        }
        try {
            if (value != null && value.getClass().getName().startsWith("org.joda.")) {
                value = DataTools.convertType(Date.class, (Object)value);
            }
            if (start != null && start.getClass().getName().startsWith("org.joda.")) {
                start = DataTools.convertType(Date.class, (Object)start);
            }
            if (end != null && end.getClass().getName().startsWith("org.joda.")) {
                end = DataTools.convertType(Date.class, (Object)end);
            }
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to convert Joda date/time value", (Throwable)ex);
        }
        if (value instanceof String && this.dsRequest.isQueryField((String)value)) {
            value = SQLExpressions.getExpression(this.dsRequest, (String)value, false);
        }
        if ((DataSource.simpleTypeInheritsFromBuiltInType((String)columnType, (String)"date") || DataSource.simpleTypeInheritsFromBuiltInType((String)columnType, (String)"time") || DataSource.simpleTypeInheritsFromBuiltInType((String)columnType, (String)"datetime")) && (operator.equals("iEquals") || operator.equals("iNotEqual"))) {
            String _operator = operator.equals("iEquals") ? "equals" : "notEqual";
            return this.valueComparison((String)columnOrExpression, columnType, expression, _operator, value, start, end, driver, fieldName);
        }
        if (operator.equals("contains") || operator.equals("iContains") || operator.equals("startsWith") || operator.equals("iStartsWith") || operator.equals("endsWith") || operator.equals("iEndsWith") || operator.equals("iEquals") || operator.equals("matchesPattern") || operator.equals("iMatchesPattern") || operator.equals("containsPattern") || operator.equals("iContainsPattern") || operator.equals("startsWithPattern") || operator.equals("iStartsWithPattern") || operator.equals("endsWithPattern") || operator.equals("iEndsWithPattern")) {
            return this.stringComparison((String)columnOrExpression, columnType, expression, operator, value, false, driver, field, ds);
        }
        if (operator.equals("notContains") || operator.equals("iNotContains") || operator.equals("notStartsWith") || operator.equals("iNotStartsWith") || operator.equals("notEndsWith") || operator.equals("iNotEndsWith") || operator.equals("iNotEqual")) {
            return this.stringComparison((String)columnOrExpression, columnType, expression, operator, value, true, driver, field, ds);
        }
        if (operator.equals("equals") || operator.equals("notEqual") || operator.equals("greaterThan") || operator.equals("greaterOrEqual") || operator.equals("lessThan") || operator.equals("lessOrEqual") || operator.equals("between") || operator.equals("betweenInclusive") || operator.equals("iBetween") || operator.equals("iBetweenInclusive")) {
            if ((operator.equals("equals") || operator.equals("notEqual")) && value != null && (value instanceof List || value.getClass().isArray())) {
                return this.setComparison((String)columnOrExpression, columnType, expression, operator, value, operator.equals("notEqual"), driver, fieldName);
            }
            return this.valueComparison((String)columnOrExpression, columnType, expression, operator, value, start, end, driver, fieldName);
        }
        if (operator.equals("isBlank") || operator.equals("notBlank")) {
            if (columnType.equals("number") || columnType.equals("integer") || columnType.equals("float") || columnType.equals("date") || columnType.equals("time") || columnType.equals("datetime") || columnType.equals("boolean") || columnType.equals("sequence") || columnType.equals("binary") || columnType.equals("imageFile")) {
                return this.nullComparison((String)columnOrExpression, operator.equals("isBlank") ? "isNull" : "notNull", driver);
            }
            return this.blankComparison((String)columnOrExpression, operator, driver);
        }
        if (operator.equals("isNull") || operator.equals("notNull")) {
            return this.nullComparison((String)columnOrExpression, operator, driver);
        }
        if (operator.equals("inSet") || operator.equals("notInSet")) {
            return this.setComparison((String)columnOrExpression, columnType, expression, operator, value, operator.equals("notInSet"), driver, fieldName);
        }
        if (operator.equals("exists") || operator.equals("notExists")) {
            return this.exists(operator, expression);
        }
        if (operator.equals("equalsField") || operator.equals("notEqualField") || operator.equals("greaterThanField") || operator.equals("greaterOrEqualField") || operator.equals("lessThanField") || operator.equals("lessOrEqualField")) {
            String otherColumnType = "";
            if (otherFieldName != null) {
                otherColumnType = this.getFieldType(otherFieldName);
            }
            if (ds instanceof SQLDataSource) {
                return this.fieldComparison((String)columnOrExpression, columnType, expression, operator, otherFieldName, otherColumnOrExpression, otherColumnType, operator.equals("notEqualField"), driver, (SQLDataSource)ds, expression.getIncludeFrom(), (SQLDataSource)otherDS, otherIncFrom, functionName);
            }
            return null;
        }
        if (operator.equals("containsField") || operator.equals("iContainsField") || operator.equals("startsWithField") || operator.equals("iStartsWithField") || operator.equals("endsWithField") || operator.equals("iEndsWithField") || operator.equals("iEqualsField")) {
            String otherColumnType = "";
            if (otherFieldName != null) {
                otherColumnType = this.getFieldType(otherFieldName);
            }
            if (ds instanceof SQLDataSource) {
                return this.fieldStringComparison((String)columnOrExpression, columnType, expression, operator, otherFieldName, otherColumnOrExpression, false, otherColumnType, driver, (SQLDataSource)ds, (SQLDataSource)otherDS, otherIncFrom, functionName);
            }
            return null;
        }
        if (operator.equals("notContainsField") || operator.equals("iNotContainsField") || operator.equals("notStartsWithField") || operator.equals("iNotStartsWithField") || operator.equals("notEndsWithField") || operator.equals("iNotEndsWithField") || operator.equals("iNotEqualField")) {
            String otherColumnType = "";
            if (otherFieldName != null) {
                otherColumnType = this.getFieldType(otherFieldName);
            }
            if (ds instanceof SQLDataSource) {
                return this.fieldStringComparison((String)columnOrExpression, columnType, expression, operator, otherFieldName, otherColumnOrExpression, true, otherColumnType, driver, (SQLDataSource)ds, (SQLDataSource)otherDS, otherIncFrom, functionName);
            }
            return null;
        }
        if (operator.equals("regexp") || operator.equals("iregexp")) {
            if (driver.supportsRegexp()) {
                if (value == null) {
                    log.warn((Object)"ignoring null value for 'regexp' and 'iregexp'");
                    return DEFAULT_POSITIVE_RETURN_CLAUSE;
                }
                if (!(value instanceof String)) {
                    log.warn((Object)("ignoring non-string (" + value.getClass().getName() + ") value for 'regexp' and 'iregexp'"));
                    return DEFAULT_POSITIVE_RETURN_CLAUSE;
                }
                return driver.getExpressionForRegexp((String)columnOrExpression, operator, (String)value);
            }
            log.warn((Object)("'regexp' and 'iregexp' are not supported by " + driver.getDatabaseProductString()));
            return DEFAULT_POSITIVE_RETURN_CLAUSE;
        }
        log.warn((Object)("Found unknown operator " + operator));
        return DEFAULT_POSITIVE_RETURN_CLAUSE;
    }

    private String stringComparison(String fieldName, String columnType, SQLExpression expression, String operator, Object objVal, boolean negate, SQLDriver driver, DSField field, BasicDataSource ds) throws Exception {
        boolean usingLike;
        if (fieldName == null) {
            if (Boolean.TRUE.equals(this.dsRequest.getAttribute("unionMode"))) {
                return DEFAULT_NEGATIVE_RETURN_CLAUSE;
            }
            log.error((Object)"Found a null fieldName");
            return DEFAULT_POSITIVE_RETURN_CLAUSE;
        }
        if (driver.castNumbersBeforeLikeCompare() && (ds.simpleTypeInheritsFrom(columnType, "integer") || ds.simpleTypeInheritsFrom(columnType, "float"))) {
            fieldName = "CAST(" + (String)fieldName + " AS varchar(50))";
        }
        if (!(!ds.simpleTypeInheritsFrom(columnType, "integer") && !ds.simpleTypeInheritsFrom(columnType, "float") || objVal == null || field != null && field.isMultiple() && objVal instanceof String)) {
            try {
                objVal = objVal instanceof Date ? Long.valueOf(((Date)objVal).getTime()).toString() : (ds.simpleTypeInheritsFrom(columnType, "float") ? new BigDecimal(objVal.toString()).toString() : new BigInteger(objVal.toString()).toString());
            }
            catch (Exception e) {
                log.warn((Object)("Got non-numeric value '" + String.valueOf(objVal) + "' for numeric column '" + (String)fieldName + "', creating literal false expression: " + String.valueOf(e)));
                if (negate) {
                    return DEFAULT_POSITIVE_RETURN_CLAUSE;
                }
                return DEFAULT_NEGATIVE_RETURN_CLAUSE;
            }
        }
        if (!(ds.simpleTypeInheritsFrom(columnType, "text") || ds.simpleTypeInheritsFrom(columnType, "integer") || ds.simpleTypeInheritsFrom(columnType, "float") || "enum".equalsIgnoreCase(field.getType()))) {
            if (ds.simpleTypeInheritsFrom(columnType, "date") || ds.simpleTypeInheritsFrom(columnType, "datetime")) {
                log.warn((Object)("Attempt to compare a Date as String, testing value " + String.valueOf(objVal) + " with operator " + operator + ". This is an invalid comparison, so we are returning " + (negate ? "TRUE" : "FALSE.")));
            }
            if (ds.simpleTypeInheritsFrom(columnType, "boolean")) {
                log.warn((Object)("Attempt to compare a Boolean as String, testing value " + String.valueOf(objVal) + " with operator " + operator + ". This is an invalid comparison, so we are returning " + (negate ? "TRUE" : "FALSE.")));
            }
            if (negate) {
                return DEFAULT_POSITIVE_RETURN_CLAUSE;
            }
            return DEFAULT_NEGATIVE_RETURN_CLAUSE;
        }
        String operatorText = "iNotEqual".equals(operator) || "iEquals".equals(operator) ? driver.caseInsensitiveEqualsPredicate() : (operator.startsWith("i") ? driver.caseInsensitiveLikePredicate() : driver.caseSensitiveLikePredicate());
        boolean bl = usingLike = driver.caseInsensitiveLikePredicate().trim().equals(operatorText.trim()) || driver.caseSensitiveLikePredicate().equals(operatorText);
        boolean likeIsCaseSensitive = field != null && field.containsKey((Object)"sqlForceInsensitive") ? field.getBoolean("sqlForceInsensitive") : (field != null && field.containsKey((Object)"sqlLikeIsCaseSensitive") ? field.getBoolean("sqlLikeIsCaseSensitive") : driver.likeIsCaseSensitive());
        StringBuilder sql = new StringBuilder("(");
        int conversionStrategy = likeIsCaseSensitive ? (usingLike ? driver.caseInsensitiveStrategy() : driver.caseInsensitiveStrategyForRelativeComparisons()) : 0;
        if (conversionStrategy != 0) {
            if (operator.startsWith("i")) {
                sql.append(driver.caseInsensitiveStrategy() == 2 ? "UPPER(" : "LOWER(");
                sql.append((String)fieldName).append(")");
                if (usingLike) {
                    sql.append(" ");
                }
                sql.append(operatorText);
                if (usingLike) {
                    sql.append(" ");
                }
            } else {
                sql.append((String)fieldName);
                if (usingLike) {
                    sql.append(" ");
                }
                sql.append(operatorText);
                if (usingLike) {
                    sql.append(" ");
                }
            }
        } else if (operator.startsWith("i")) {
            sql.append((String)fieldName);
            if (usingLike) {
                sql.append(" ");
            }
            sql.append(operatorText);
            if (usingLike) {
                sql.append(" ");
            }
        } else if (usingLike) {
            sql.append(driver.caseSensitiveFieldPrefix()).append((String)fieldName).append(driver.caseSensitiveFieldSuffix()).append(" ").append(driver.caseSensitiveLikePredicate()).append(" ");
        } else {
            sql.append(driver.caseSensitiveFieldPrefix()).append((String)fieldName).append(driver.caseSensitiveFieldSuffix()).append(driver.caseSensitiveEqualsPredicate());
            if (driver instanceof MysqlDriver) {
                usingLike = true;
            }
        }
        if (objVal == null) {
            objVal = "";
        }
        String value = objVal.toString();
        value = driver.escapeValueUnquoted(value, usingLike);
        if (operator.startsWith("i") && conversionStrategy != 0) {
            sql.append(driver.caseInsensitiveStrategy() == 2 ? "UPPER(" : "LOWER(");
        }
        if (field != null) {
            sql.append(driver.getLiteralPrefix(field, ds));
        }
        if (operator.contains("atchesPattern") || operator.contains("ontainsPattern") || operator.contains("artsWithPattern") || operator.contains("ndsWithPattern")) {
            List multiCharacterWildcard = ds.getPatternMultiWildcards();
            List singleCharacterWildcard = ds.getPatternSingleWildcards();
            boolean foundSqlEscapeCharacter = false;
            Object newValue = "";
            for (int i = 0; i < value.length(); ++i) {
                String character = String.valueOf(value.charAt(i));
                if ("\\".equals(character)) {
                    foundSqlEscapeCharacter = true;
                    continue;
                }
                newValue = multiCharacterWildcard.contains(character) ? (String)newValue + "%" : (singleCharacterWildcard.contains(character) ? (String)newValue + "_" : (foundSqlEscapeCharacter ? (String)newValue + "\\" + character : (String)newValue + character));
                foundSqlEscapeCharacter = false;
            }
            value = newValue;
        }
        if (operator.startsWith("i")) {
            value = value.toLowerCase();
        }
        sql.append(driver.sqlStringComparisonRValue((String)fieldName, value, operator, this.dsRequest));
        if (operator.startsWith("i") && conversionStrategy != 0) {
            sql.append(")");
        }
        if (usingLike) {
            sql.append(driver.escapeClause(value));
        }
        if (!this.strictSQLFiltering) {
            sql.append(" AND ").append((String)fieldName).append(" IS NOT NULL");
        }
        sql.append(")");
        if (negate) {
            sql.insert(0, "NOT");
        }
        return sql.toString();
    }

    private String valueComparison(String fieldName, String columnType, SQLExpression expression, String operator, Object value, Object start, Object end, SQLDriver driver, String realFieldName) throws Exception {
        String fieldType;
        boolean valueQueryMode;
        if (fieldName == null) {
            if (Boolean.TRUE.equals(this.dsRequest.getAttribute("unionMode"))) {
                return DEFAULT_NEGATIVE_RETURN_CLAUSE;
            }
            log.error((Object)"Found a null fieldName");
            return DEFAULT_POSITIVE_RETURN_CLAUSE;
        }
        DSField field = null;
        SQLDataSource firstDS = (SQLDataSource)((Object)this.dataSources.get(0));
        if (expression != null) {
            field = expression.getField();
        } else if (firstDS != null) {
            field = firstDS.getField(realFieldName);
        }
        SQLExpression valueExpr = null;
        if (value instanceof SQLExpression) {
            valueExpr = (SQLExpression)((Object)value);
        }
        boolean bl = valueQueryMode = valueExpr != null;
        if (("text".equals(columnType) || "string".equals(columnType)) && (valueQueryMode && (DataSource.simpleTypeInheritsFromBuiltInType((String)valueExpr.getOutputType(), (String)"date") || DataSource.simpleTypeInheritsFromBuiltInType((String)valueExpr.getOutputType(), (String)"time") || DataSource.simpleTypeInheritsFromBuiltInType((String)valueExpr.getOutputType(), (String)"datetime")) || value instanceof Date || value instanceof GregorianCalendar || value != null && value.getClass().getName().startsWith("org.joda") || start instanceof Date || start instanceof GregorianCalendar || start != null && start.getClass().getName().startsWith("org.joda") || end instanceof Date || end instanceof GregorianCalendar || end != null && end.getClass().getName().startsWith("org.joda"))) {
            if (operator.equals("notEqual")) {
                return DEFAULT_POSITIVE_RETURN_CLAUSE;
            }
            return "('0'='1')";
        }
        String string = fieldType = field == null ? columnType : field.getType();
        if (!valueQueryMode) {
            value = this.castValue(fieldName, value, columnType, fieldType, firstDS);
            start = this.castValue(fieldName, start, columnType, fieldType, firstDS);
            end = this.castValue(fieldName, end, columnType, fieldType, firstDS);
        }
        if (!valueQueryMode && ("integer".equals(columnType) && value != null && !(value instanceof Number) || "float".equals(columnType) && value != null && !(value instanceof Number) || "date".equals(columnType) && value != null && !(value instanceof Date) && !(value instanceof GregorianCalendar) && (value == null || !value.getClass().getName().startsWith("org.joda")) || "integer".equals(columnType) && start != null && !(start instanceof Number) || "float".equals(columnType) && start != null && !(start instanceof Number) || "date".equals(columnType) && start != null && !(start instanceof Date) && !(start instanceof GregorianCalendar) && (start == null || !start.getClass().getName().startsWith("org.joda")) || "integer".equals(columnType) && end != null && !(end instanceof Number) || "float".equals(columnType) && end != null && !(end instanceof Number) || "date".equals(columnType) && end != null && !(end instanceof Date) && !(end instanceof GregorianCalendar) && (end == null || !end.getClass().getName().startsWith("org.joda")))) {
            if (operator.equals("notEqual")) {
                if (this.strictSQLFiltering) {
                    return "(" + fieldName + " = " + fieldName + ")";
                }
                return DEFAULT_POSITIVE_RETURN_CLAUSE;
            }
            if (operator.equals("lessThan") || operator.equals("lessOrEqual")) {
                if (this.strictSQLFiltering) {
                    return "(" + fieldName + " <> " + fieldName + " AND " + fieldName + " IS NULL)";
                }
                return "(" + fieldName + " IS NULL)";
            }
            if (this.strictSQLFiltering) {
                return "(" + fieldName + " <> " + fieldName + " AND " + fieldName + " IS NULL)";
            }
            return DEFAULT_NEGATIVE_RETURN_CLAUSE;
        }
        boolean usingLike = operator.equals("equals") && ("text".equals(columnType) || "any".equals(columnType) && "enum".equals(fieldType)) && driver.caseSensitiveEqualsPredicate().toUpperCase().contains("LIKE") || operator.equals("notEqual") && ("text".equals(columnType) || "any".equals(columnType) && "enum".equals(fieldType)) && driver.caseSensitiveNotEqualPredicate().toUpperCase().contains("LIKE");
        Object unescapedValue = null;
        if (!valueQueryMode && value != null) {
            if (usingLike) {
                unescapedValue = value;
                value = this.dsRequest.usePreparedStatements() ? driver.escapeValueUnquoted(value, true) : "'" + driver.escapeValueUnquoted(value, true) + "'";
            } else if (!this.dsRequest.usePreparedStatements()) {
                value = driver.sqlInTransform(value, field, expression.getOutputType(), firstDS, true, false);
            }
        }
        if (!valueQueryMode && start != null && !this.dsRequest.usePreparedStatements()) {
            start = driver.sqlInTransform(start, field, expression.getOutputType(), firstDS, true, false);
        }
        if (!valueQueryMode && end != null && !this.dsRequest.usePreparedStatements()) {
            end = driver.sqlInTransform(end, field, expression.getOutputType(), firstDS, true, false);
        }
        if (operator.equals("equals")) {
            String sqlOp;
            String string2 = sqlOp = usingLike ? driver.caseSensitiveEqualsPredicate() : " = ";
            if (!valueQueryMode && usingLike && driver instanceof MysqlDriver && driver.optimizeCaseSensitiveCriteria()) {
                Object valueForEquals;
                Object object = valueForEquals = this.dsRequest.usePreparedStatements() ? driver.escapeValueUnquoted(unescapedValue, false) : "'" + driver.escapeValueUnquoted(unescapedValue, false) + "'";
                if (this.strictSQLFiltering) {
                    if (value != null) {
                        return "(" + fieldName + " = " + this.prepareSQLParam((DataSource)firstDS, driver, field, valueForEquals) + " AND " + fieldName + sqlOp + this.prepareSQLParam((DataSource)firstDS, driver, field, value) + ")";
                    }
                    return "(" + fieldName + sqlOp + this.prepareSQLParam((DataSource)firstDS, driver, field, value) + ")";
                }
                if (value != null) {
                    return "(" + fieldName + " = " + this.prepareSQLParam((DataSource)firstDS, driver, field, valueForEquals) + " AND " + fieldName + sqlOp + this.prepareSQLParam((DataSource)firstDS, driver, field, value) + " AND " + fieldName + " IS NOT NULL)";
                }
                return "(" + fieldName + " IS NULL)";
            }
            if (this.strictSQLFiltering) {
                return "(" + fieldName + sqlOp + this.prepareSQLParam((DataSource)firstDS, driver, field, value) + ")";
            }
            if (value != null) {
                return "(" + fieldName + sqlOp + this.prepareSQLParam((DataSource)firstDS, driver, field, value) + " AND " + fieldName + " IS NOT NULL)";
            }
            return "(" + fieldName + " IS NULL)";
        }
        if (operator.equals("notEqual")) {
            String sqlOp;
            String string3 = sqlOp = usingLike ? driver.caseSensitiveNotEqualPredicate() : " <> ";
            if (this.strictSQLFiltering) {
                return "(" + fieldName + sqlOp + this.prepareSQLParam((DataSource)firstDS, driver, field, value) + ")";
            }
            if (value != null) {
                return "(" + fieldName + sqlOp + this.prepareSQLParam((DataSource)firstDS, driver, field, value) + " OR " + fieldName + " IS NULL)";
            }
            return "(" + fieldName + " IS NOT NULL)";
        }
        if (operator.equals("greaterThan")) {
            if (this.strictSQLFiltering) {
                return "(" + fieldName + " > " + this.prepareSQLParam((DataSource)firstDS, driver, field, value) + ")";
            }
            if (value != null) {
                return "(" + fieldName + " > " + this.prepareSQLParam((DataSource)firstDS, driver, field, value) + " AND " + fieldName + " IS NOT NULL)";
            }
            return DEFAULT_POSITIVE_RETURN_CLAUSE;
        }
        if (operator.equals("greaterOrEqual")) {
            if (this.strictSQLFiltering) {
                return "(" + fieldName + " >= " + this.prepareSQLParam((DataSource)firstDS, driver, field, value) + ")";
            }
            if (value != null) {
                return "(" + fieldName + " >= " + this.prepareSQLParam((DataSource)firstDS, driver, field, value) + " AND " + fieldName + " IS NOT NULL)";
            }
            return DEFAULT_POSITIVE_RETURN_CLAUSE;
        }
        if (operator.equals("lessThan")) {
            if (this.strictSQLFiltering) {
                return "(" + fieldName + " < " + this.prepareSQLParam((DataSource)firstDS, driver, field, value) + ")";
            }
            if (value != null) {
                return "(" + fieldName + " < " + this.prepareSQLParam((DataSource)firstDS, driver, field, value) + " OR " + fieldName + " IS NULL)";
            }
            return DEFAULT_POSITIVE_RETURN_CLAUSE;
        }
        if (operator.equals("lessOrEqual")) {
            if (this.strictSQLFiltering) {
                return "(" + fieldName + " <= " + this.prepareSQLParam((DataSource)firstDS, driver, field, value) + ")";
            }
            if (value != null) {
                return "(" + fieldName + " <= " + this.prepareSQLParam((DataSource)firstDS, driver, field, value) + " OR " + fieldName + " IS NULL)";
            }
            return DEFAULT_POSITIVE_RETURN_CLAUSE;
        }
        if (operator.equals("between") || operator.equals("iBetween")) {
            String lEnd;
            boolean ignoreCase = operator.equals("iBetween") && "text".equals(columnType);
            String prefix = "";
            if (ignoreCase) {
                if (driver.caseInsensitiveStrategyForRelativeComparisons() == 1) {
                    prefix = "LOWER(";
                } else if (driver.caseInsensitiveStrategyForRelativeComparisons() == 2) {
                    prefix = "UPPER(";
                }
            }
            String suffix = ignoreCase && driver.caseInsensitiveStrategyForRelativeComparisons() != 0 ? ")" : "";
            String lFieldName = prefix + fieldName + suffix;
            String lStart = start == null ? "null" : prefix + this.prepareSQLParam((DataSource)firstDS, driver, field, start) + suffix;
            String string4 = lEnd = end == null ? "null" : prefix + this.prepareSQLParam((DataSource)firstDS, driver, field, end) + suffix;
            if (this.strictSQLFiltering) {
                return "(" + lFieldName + " > " + lStart + " AND " + lFieldName + " < " + lEnd + ")";
            }
            if (start == null && end != null) {
                return "(" + lFieldName + " < " + lEnd + " OR " + fieldName + " IS NULL)";
            }
            if (start != null && end == null) {
                return "(" + lFieldName + " > " + lStart + ")";
            }
            if (start != null && end != null) {
                return "(" + lFieldName + " > " + lStart + " AND " + lFieldName + " < " + lEnd + " AND " + fieldName + " IS NOT NULL)";
            }
            return DEFAULT_POSITIVE_RETURN_CLAUSE;
        }
        if (operator.equals("betweenInclusive") || operator.equals("iBetweenInclusive")) {
            String lEnd;
            boolean ignoreCase = operator.equals("iBetweenInclusive") && "text".equals(columnType);
            String prefix = "";
            if (ignoreCase) {
                if (driver.caseInsensitiveStrategyForRelativeComparisons() == 1) {
                    prefix = "LOWER(";
                } else if (driver.caseInsensitiveStrategyForRelativeComparisons() == 2) {
                    prefix = "UPPER(";
                }
            }
            String suffix = ignoreCase && driver.caseInsensitiveStrategyForRelativeComparisons() != 0 ? ")" : "";
            String lFieldName = prefix + fieldName + suffix;
            String lStart = start == null ? "null" : prefix + this.prepareSQLParam((DataSource)firstDS, driver, field, start) + suffix;
            String string5 = lEnd = end == null ? "null" : prefix + this.prepareSQLParam((DataSource)firstDS, driver, field, end) + suffix;
            if (this.strictSQLFiltering) {
                return "(" + lFieldName + " >= " + lStart + " AND " + lFieldName + " <= " + lEnd + ")";
            }
            if (start == null && end != null) {
                return "(" + lFieldName + " <= " + lEnd + " OR " + fieldName + " IS NULL)";
            }
            if (start != null && end == null) {
                return "(" + lFieldName + " >= " + lStart + ")";
            }
            if (start != null && end != null) {
                return "(" + lFieldName + " >= " + lStart + " AND " + lFieldName + " <= " + lEnd + " AND " + fieldName + " IS NOT NULL)";
            }
            return DEFAULT_POSITIVE_RETURN_CLAUSE;
        }
        return DEFAULT_POSITIVE_RETURN_CLAUSE;
    }

    private String blankComparison(String fieldName, String operator, SQLDriver driver) {
        if (fieldName == null) {
            log.error((Object)"Found a null fieldName");
            return DEFAULT_POSITIVE_RETURN_CLAUSE;
        }
        return driver.blankComparison(fieldName, operator);
    }

    private String nullComparison(String fieldName, String operator, SQLDriver driver) {
        if (fieldName == null) {
            log.error((Object)"Found a null fieldName");
            return DEFAULT_POSITIVE_RETURN_CLAUSE;
        }
        if (operator.equals("isNull")) {
            return "(" + fieldName + " IS NULL)";
        }
        return "(" + fieldName + " IS NOT NULL)";
    }

    private String setComparison(String fieldName, String columnType, SQLExpression expression, String operator, Object value, boolean negate, SQLDriver driver, String realFieldName) throws Exception {
        if (fieldName == null) {
            log.error((Object)"Found a null fieldName");
            return DEFAULT_POSITIVE_RETURN_CLAUSE;
        }
        DSField field = null;
        SQLDataSource firstDS = (SQLDataSource)((Object)this.dataSources.get(0));
        if (firstDS != null) {
            field = firstDS.getField(realFieldName);
        }
        if (value instanceof SQLExpression) {
            SQLExpression valueExpr = (SQLExpression)((Object)value);
            StringBuffer sql = new StringBuffer();
            sql.append("(" + fieldName + " IN (");
            sql.append(valueExpr.getExpr() + "))");
            if (negate) {
                sql.insert(0, "NOT");
            }
            return sql.toString();
        }
        if (value == null) {
            value = new ArrayList();
        }
        if (!(value instanceof Collection)) {
            ArrayList val = value;
            value = new ArrayList();
            ((List)value).add(val);
        } else {
            value = new ArrayList(value);
        }
        int size = ((List)value).size();
        for (int i = 0; i < size; ++i) {
            Object work = ((List)value).get(i);
            work = this.castValue(fieldName, work, columnType, field == null ? null : field.getType(), firstDS);
            if ("integer".equals(columnType) && work != null && !(work instanceof Number) || "float".equals(columnType) && work != null && !(work instanceof Number) || "date".equals(columnType) && work != null && !(work instanceof Date) && !(work instanceof GregorianCalendar) && (work == null || !work.getClass().getName().startsWith("org.joda"))) {
                ((List)value).remove(i);
                --size;
                --i;
                continue;
            }
            if (this.dsRequest != null && this.dsRequest.usePreparedStatements()) continue;
            if (work != null) {
                work = driver.sqlInTransform(work, field, firstDS);
            }
            ((List)value).set(i, work);
        }
        boolean nullInSet = false;
        if (((List)value).contains(null)) {
            nullInSet = true;
            while (((List)value).contains(null)) {
                ((List)value).remove(null);
            }
        }
        StringBuffer sql = new StringBuffer();
        if (((List)value).isEmpty()) {
            if (nullInSet) {
                sql.append("(" + fieldName + " IS NULL)");
            } else {
                sql.append("('0'='1')");
            }
        } else {
            sql.append("((" + fieldName + " IN (");
            int setSize = driver.getMaximumSetSize();
            if (setSize == 0) {
                setSize = ((List)value).size();
            }
            int j = 0;
            for (int i = 0; i < ((List)value).size(); ++i) {
                if (j >= setSize) {
                    sql.append(") OR " + fieldName + " IN (");
                    j = 0;
                }
                if (i > 0 && j > 0) {
                    sql.append(", ");
                }
                sql.append(this.prepareSQLParam((DataSource)firstDS, driver, field, ((List)value).get(i)));
                ++j;
            }
            if (nullInSet) {
                sql.append(")) OR " + fieldName + " IS NULL)");
            } else {
                sql.append(")) AND " + fieldName + " IS NOT NULL)");
            }
        }
        if (negate) {
            sql.insert(0, "NOT");
        }
        return sql.toString();
    }

    private String exists(String operator, SQLExpression expression) {
        if (expression != null && expression.getExpr() != null) {
            return ("exists".equals(operator) ? " EXISTS " : " NOT EXISTS ") + expression.getExpr();
        }
        boolean negate = "notExists".equals(operator);
        log.error((Object)("Missing expression for the fieldQuery with '" + operator + "' operator."));
        if (negate) {
            return DEFAULT_POSITIVE_RETURN_CLAUSE;
        }
        return DEFAULT_NEGATIVE_RETURN_CLAUSE;
    }

    private String fieldComparison(String fieldName, String columnType, SQLExpression expression, String operator, String otherFieldName, String columnOrExpression, String otherColumnType, boolean negate, SQLDriver driver, SQLDataSource ds, IncludeFromDefinition incFrom, SQLDataSource otherDS, IncludeFromDefinition otherIncFrom, String functionName) throws Exception {
        if (fieldName == null) {
            log.error((Object)"Found a null fieldName");
            if (negate) {
                return DEFAULT_NEGATIVE_RETURN_CLAUSE;
            }
            return DEFAULT_POSITIVE_RETURN_CLAUSE;
        }
        if (otherFieldName == null) {
            log.error((Object)"Found a null 'other' fieldName in a field comparison");
            if (negate) {
                return DEFAULT_NEGATIVE_RETURN_CLAUSE;
            }
            return DEFAULT_POSITIVE_RETURN_CLAUSE;
        }
        if (columnOrExpression == null) {
            DSField field = otherDS.getField(otherFieldName);
            if (incFrom == null && field != null && field.get((Object)"customCriteriaExpression") != null) {
                log.warn((Object)("Field " + otherFieldName + " appeared on the right-hand side of a '" + operator + "' clause.  This is not supported - fields with customCriteriaExpression may not appear in ordinary field comparison criteria"));
                return null;
            }
        }
        if (!driver.supportsFieldComparison(columnType, otherColumnType)) {
            log.warn((Object)("Found unsupported type mismatch between fields " + fieldName + " (" + columnType + ") and " + (String)columnOrExpression + " (" + otherColumnType + "). Case-sensitive field operators do not support this."));
            if (negate) {
                return DEFAULT_POSITIVE_RETURN_CLAUSE;
            }
            return "('0'='1')";
        }
        if (this.postAggregation) {
            columnOrExpression = functionName != null ? functionName + "(" + (String)columnOrExpression + ")" : otherFieldName;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("(");
        if (operator.equals("equalsField")) {
            sql.append("(" + fieldName + " IS NULL AND " + (String)columnOrExpression + " IS NULL)");
        } else if (operator.equals("notEqualField")) {
            sql.append("((" + fieldName + " IS NULL AND " + (String)columnOrExpression + " IS NOT NULL) OR ");
            sql.append("(" + fieldName + " IS NOT NULL AND " + (String)columnOrExpression + " IS NULL))");
        } else if (operator.equals("lessThanField")) {
            sql.append("(" + fieldName + " IS NULL AND " + (String)columnOrExpression + " IS NOT NULL)");
        } else if (operator.equals("lessOrEqualField")) {
            sql.append("(" + fieldName + " IS NULL)");
        } else if (operator.equals("greaterThanField")) {
            sql.append("(" + fieldName + " IS NOT NULL AND " + (String)columnOrExpression + " IS NULL)");
        } else {
            sql.append("(" + (String)columnOrExpression + " IS NULL)");
        }
        Object _fieldName = fieldName;
        Object _columnOrExpression = columnOrExpression;
        if (driver.caseInsensitiveStrategyForRelativeComparisons() == 0 || driver.caseSensitiveStrategyForRelativeComparisons() != 0) {
            _fieldName = driver.caseSensitiveFieldPrefixForRelativeComparisons() + fieldName + driver.caseSensitiveFieldSuffixForRelativeComparisons();
            _columnOrExpression = driver.caseSensitiveFieldPrefixForRelativeComparisons() + (String)columnOrExpression + driver.caseSensitiveFieldSuffixForRelativeComparisons();
        }
        sql.append(" OR (" + (String)_fieldName + " " + String.valueOf(this.operatorToSql.get(operator)) + " ");
        sql.append((String)_columnOrExpression + " AND ");
        sql.append(fieldName + " IS NOT NULL AND " + (String)columnOrExpression + " IS NOT NULL)");
        sql.append(")");
        return sql.toString();
    }

    private String fieldStringComparison(String fieldName, String columnType, SQLExpression expression, String operator, String otherFieldName, String columnOrExpression, boolean negate, String otherColumnType, SQLDriver driver, SQLDataSource ds, SQLDataSource otherDS, IncludeFromDefinition otherIncFrom, String functionName) throws Exception {
        boolean likeIsCaseSensitive;
        DSField field;
        if (fieldName == null) {
            log.error((Object)"Found a null fieldName");
            return DEFAULT_POSITIVE_RETURN_CLAUSE;
        }
        if (!this.postAggregation || functionName != null) {
            DSField field2 = otherDS.getField((String)otherFieldName);
            if (field2.get((Object)"customCriteriaExpression") != null) {
                log.warn((Object)("Field " + (String)otherFieldName + " appeared on the right-hand side of a '" + operator + "' clause.  This is not supported - fields with customCriteriaExpression may not appear in ordinary field comparison criteria"));
                return null;
            }
            otherFieldName = columnOrExpression;
        }
        if (this.postAggregation && functionName != null) {
            otherFieldName = functionName + "(" + (String)otherFieldName + ")";
        }
        if (driver.castNumbersBeforeLikeCompare()) {
            if (ds.simpleTypeInheritsFrom(columnType, "integer") || ds.simpleTypeInheritsFrom(columnType, "float")) {
                fieldName = "CAST(" + (String)fieldName + " AS varchar(50))";
            }
            if (ds.simpleTypeInheritsFrom(otherColumnType, "integer") || ds.simpleTypeInheritsFrom(otherColumnType, "float")) {
                otherFieldName = "CAST(" + (String)otherFieldName + " AS varchar(50))";
            }
        }
        if (!(ds.simpleTypeInheritsFrom(columnType, "text") || ds.simpleTypeInheritsFrom(columnType, "integer") || ds.simpleTypeInheritsFrom(columnType, "float") || "enum".equalsIgnoreCase(this.getFieldType((String)fieldName)))) {
            log.warn((Object)("Found field " + (String)fieldName + " of type " + columnType + " in a case-insensitive field operator " + operator + ". This is not supported."));
            if (negate) {
                return DEFAULT_POSITIVE_RETURN_CLAUSE;
            }
            return DEFAULT_NEGATIVE_RETURN_CLAUSE;
        }
        if (!(ds.simpleTypeInheritsFrom(otherColumnType, "text") || ds.simpleTypeInheritsFrom(otherColumnType, "integer") || ds.simpleTypeInheritsFrom(otherColumnType, "float") || "enum".equalsIgnoreCase(this.getFieldType((String)otherFieldName)))) {
            log.warn((Object)("Found field " + (String)otherFieldName + " of type " + otherColumnType + " in a case-insensitive field operator " + operator + ". This is not supported."));
            if (negate) {
                return DEFAULT_POSITIVE_RETURN_CLAUSE;
            }
            return DEFAULT_NEGATIVE_RETURN_CLAUSE;
        }
        StringBuffer sql = new StringBuffer("(");
        if (!this.strictSQLFiltering) {
            sql.append((String)otherFieldName + " IS NULL");
            if (operator.toLowerCase().contains("Equal".toLowerCase())) {
                sql.insert(0, "(");
                sql.append(" AND " + (String)fieldName + " IS NULL)");
            }
            sql.append(" OR (");
        }
        boolean bl = (field = ds.getField((String)fieldName)) != null && field.containsKey((Object)"sqlForceInsensitive") ? field.getBoolean("sqlForceInsensitive") : (likeIsCaseSensitive = field != null && field.containsKey((Object)"sqlLikeIsCaseSensitive") ? field.getBoolean("sqlLikeIsCaseSensitive") : driver.likeIsCaseSensitive());
        if (likeIsCaseSensitive && driver.caseInsensitiveStrategy() != 0) {
            if (operator.startsWith("i")) {
                sql.append(driver.caseInsensitiveStrategy() == 2 ? "UPPER(" : "LOWER(");
                sql.append((String)fieldName + ") " + driver.caseInsensitiveLikePredicate() + " ");
            } else {
                sql.append((String)fieldName + " " + driver.caseSensitiveLikePredicate() + " ");
            }
        } else if (operator.startsWith("i")) {
            if (operator.toLowerCase().indexOf("equal") != -1) {
                sql.append((String)fieldName + driver.caseInsensitiveEqualsPredicate());
            } else {
                sql.append((String)fieldName + " " + driver.caseInsensitiveLikePredicate() + " ");
            }
        } else {
            String wrappedFieldName = driver.caseSensitiveFieldPrefix() + (String)fieldName + driver.caseSensitiveFieldSuffix();
            if (operator.toLowerCase().indexOf("equal") != -1) {
                sql.append(wrappedFieldName + driver.caseSensitiveEqualsPredicate());
            } else {
                sql.append(wrappedFieldName + " " + driver.caseSensitiveLikePredicate() + " ");
            }
        }
        if (operator.startsWith("i") && likeIsCaseSensitive && driver.caseInsensitiveStrategy() != 0) {
            sql.append(driver.caseInsensitiveStrategy() == 2 ? "UPPER(" : "LOWER(");
        }
        if (operator.indexOf("ndsWith") != -1) {
            sql.append(driver.sqlConcat(new String[]{"'%'", otherFieldName}));
        } else if (operator.indexOf("tains") != -1) {
            sql.append(driver.sqlConcat(new String[]{"'%'", otherFieldName, "'%'"}));
        } else if (operator.indexOf("rtsWith") != -1) {
            sql.append(driver.sqlConcat(new String[]{otherFieldName, "'%'"}));
        } else {
            sql.append((String)otherFieldName);
        }
        if (operator.startsWith("i") && likeIsCaseSensitive && driver.caseInsensitiveStrategy() != 0) {
            sql.append(")");
        }
        sql.append(driver.escapeClause(null));
        if (!this.strictSQLFiltering) {
            sql.append(" AND " + (String)fieldName + " IS NOT NULL AND " + (String)otherFieldName + " IS NOT NULL)");
        }
        sql.append(")");
        if (negate) {
            sql.insert(0, "NOT");
        }
        return sql.toString();
    }

    private Object castValue(String fieldName, Object value, String columnType, String fieldType, BasicDataSource ds) {
        if (value instanceof String) {
            String text = (String)value;
            try {
                if (this.inheritsFromType(fieldType, "datetime", ds)) {
                    value = JSTranslater.parseDate((String)(text.indexOf(84) >= 0 ? "yyyy-MM-dd'T'HH:mm:ss" : "yyyy-MM-dd kk:mm:ss"), (String)text);
                } else if (this.inheritsFromType(fieldType, "date", ds)) {
                    value = JSTranslater.parseDate((String)"yyyy-MM-dd", (String)text);
                } else if (this.inheritsFromType(fieldType, "time", ds)) {
                    value = JSTranslater.parseDate((String)"HH:mm:ss", (String)text);
                }
            }
            catch (ParseException e) {
                try {
                    if (this.inheritsFromType(fieldType, "datetime", ds)) {
                        value = JSTranslater.parseDate((String)(text.indexOf(84) >= 0 ? "yyyy-MM-dd'T'HH:mm:ss.SSS" : "yyyy-MM-dd kk:mm:ss.SSS"), (String)text);
                    } else if (this.inheritsFromType(fieldType, "time", ds)) {
                        value = JSTranslater.parseDate((String)"HH:mm:ss.SSS", (String)text);
                    }
                }
                catch (ParseException e2) {
                    log.warn((Object)("String '" + text + "' was passed as filter criteria for a " + fieldType + " field, but it could not be parsed."));
                }
            }
        }
        if (value instanceof String) {
            try {
                Number temp;
                if (this.inheritsFromType(columnType, "integer", ds)) {
                    temp = Long.valueOf((String)value);
                    value = temp;
                }
                if (this.inheritsFromType(columnType, "float", ds)) {
                    temp = Double.valueOf((String)value);
                    value = temp;
                }
            }
            catch (Exception e) {
                log.warn((Object)("String '" + String.valueOf(value) + "' was passed as filter criteria for a numeric field. We could not parse it."));
            }
        }
        if (value != null && !(value instanceof String) && (this.inheritsFromType(columnType, "text", ds) || this.inheritsFromType(columnType, "string", ds))) {
            value = value.toString();
        }
        return value;
    }

    private boolean inheritsFromType(String typeId, String parentTypeId, BasicDataSource ds) {
        if (ds != null) {
            try {
                return ds.simpleTypeInheritsFrom(typeId, parentTypeId);
            }
            catch (Exception ex) {
                log.warn((Throwable)ex);
            }
        }
        return parentTypeId != null && parentTypeId.equalsIgnoreCase(typeId);
    }

    protected static boolean isDefaultPositiveClause(Object whereClause) {
        return DEFAULT_POSITIVE_RETURN_CLAUSE.equals(whereClause);
    }

    protected boolean shouldIgnoreTextMatchStyle(DSField field) {
        return this.shouldIgnoreTextMatchStyle(field, false);
    }

    protected boolean shouldIgnoreTextMatchStyle(DSField field, boolean useForceExact) {
        if (field == null) {
            return false;
        }
        if (this.alwaysIgnoreTextMatchStyleCaseSensitive(field)) {
            return true;
        }
        if (Boolean.TRUE.equals(field.shouldIgnoreTextMatchStyle())) {
            return true;
        }
        if (this.processingSimpleCriteriaList || useForceExact) {
            try {
                DSRequest unionReq;
                Boolean shouldForceExact = this.dsRequest.shouldApplyArrayCriteriaForceExact();
                if (shouldForceExact != null) {
                    return shouldForceExact;
                }
                if (Boolean.TRUE.equals(this.dsRequest.getAttribute("unionMode")) && (unionReq = this.dsRequest.getParentRequestForSQLParams()) != null && (shouldForceExact = unionReq.shouldApplyArrayCriteriaForceExact()) != null) {
                    return shouldForceExact;
                }
                return config.getBoolean((Object)"arrayCriteriaForceExact", true);
            }
            catch (Exception e) {
                log.warn((Object)"Caught exception atempting to retrieve 'arrayCriteriaForceExact' - returning false", (Throwable)e);
            }
        }
        return false;
    }

    protected boolean alwaysIgnoreTextMatchStyleCaseSensitive(DSField field) {
        String restrictedField = (String)this.dsRequest.getAttribute("restrictedOwnerIdField");
        return field != null && field.getName() != null && field.getName().equals(restrictedField);
    }
}

