/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.BatchRunDao;
import com.isomorphic.autotest.TestRunner;
import com.isomorphic.autotest.TestRunnerLauncher;
import com.isomorphic.base.ISCInit;
import com.isomorphic.devenv.DevUtil;
import com.isomorphic.log.Logger;
import java.util.Date;
import org.apache.commons.cli.Options;

public class TriggerOverlayBuilds {
    private static Logger log = new Logger(TriggerOverlayBuilds.class.getName());

    public static void main(String[] args) throws Exception {
        ISCInit.go((String)TriggerOverlayBuilds.class.getName());
        Options options = new Options();
        TestRunnerLauncher.addOptions(options);
        TestRunnerLauncher config = new TestRunnerLauncher();
        TestRunner.setConfiguration(config);
        log.info((Object)"Checking overlay branches to see if a commit should be triggered.");
        DevUtil.branchesAscending().forEach(branch -> {
            if (!DevUtil.isOverlayBranch(branch)) {
                return;
            }
            String baseBranch = DevUtil.getOverlayBaseBranch(branch);
            try {
                Date target = BatchRunDao.getLastBatchFromPreviousDay(baseBranch);
                if (target == null) {
                    log.info((Object)("Nothing to do for " + branch + " since there were no commits to " + baseBranch + " in the last day"));
                    return;
                }
                log.info((Object)("Commit " + String.valueOf(target) + " was last commit yesterday for " + baseBranch));
            }
            catch (Exception e) {
                log.error((Object)("Couldn't check base branch " + baseBranch + " for commits"), (Throwable)e);
                return;
            }
            try {
                Runtime.getRuntime().exec("triggerBuild " + branch).waitFor();
                log.info((Object)("Success: Triggered a build for overlay branch " + branch));
            }
            catch (Exception e) {
                log.error((Object)("Failed to trigger a build for overlay branch " + branch), (Throwable)e);
            }
        });
    }
}

